(ns com.yetanalytics.gen-openapi.generate
  (:require [spec-tools.json-schema :as json-schema]
            [com.yetanalytics.gen-openapi.generate.schema :as schema]
            [clojure.spec.alpha :as sp]))

(defn json-content [schema]
  {:content {"application/json" {:schema schema}}})

(defn response
  ([desc] {:description desc})
  ([desc schema]
   (-> schema
       schema/dsl
       json-content
       (assoc :description desc))))

(defn rref [kw-or-str]
  {"$ref" (str "#/components/responses/" (name kw-or-str))})

(defn request [schema]
  (-> schema
      schema/dsl
      json-content))


;expand-response is a fn that takes an item and returns a vector of form [http-code resp]
(defn expand-responses [route annotation expand-response]
                                        ;takes a route, annotation, and fn and returns an expanded annotation
  (update annotation :responses
          (fn [resps]
            (cond
              (map? resps)
              resps
              (vector? resps)
              (apply hash-map
                     (mapcat expand-response resps))))))

;;;;;;;;;;json-schema shorthand
;current
; only used for params
; thus a vec, takes pairs
; :t#, :a#, :r#, :?# for "of type," "array of ref", "ref," and "optional"
; required is default
;let's imagine this instead:
;[schema] is array of schema
; :r#key is reference to key;
; (r :key) is reference to key
;
;what you had for params was pretty good, 




; /\ this is a good way to describe a schema, though it needs :allOf, :anyOf, :oneOf, :not
;https://json-schema.org/understanding-json-schema/reference/combining
; also needs to handle arbitary properties  for schema literals
; like
;  {"type" "number", "minimum":0}


;also, *schema* shorthand is different from *parameter* shorthand, which is different from *response* shorthand

; :as sch


                                        ;infer
                                        ;[item] array of <item>
                                        ;[name type]
                                        ;


