(ns com.yetanalytics.gen-openapi.core
  (:require [cheshire.core :as json]
            [com.yetanalytics.gen-openapi.generate :as g]
            [com.yetanalytics.gen-openapi.generate.schema :as gs]
            [com.yetanalytics.gen-openapi.splice :as splice]
            [clojure.spec.alpha :as sp]
            [spec-tools.json-schema :as json-schema]
            [xapi-schema.spec.resources :as r]
            [clj-yaml.core :as yaml]))

(def to-json json/generate-string)
(def to-yaml yaml/generate-string)

(defn make-oa-map [generals route-vecs]
  (->> route-vecs
       splice/process-routes
       (assoc generals :paths)))

(defn annotate [route data]
  (let [[route data] (if (vector? route)
                       [route data]
                       [data route])
        [path method] route]
    (splice/annotate-unchanged route {path {method data}})))

(def o gs/o)
(def a gs/a)
(def dsl gs/dsl)
(def request g/request)
(def response g/response)
