/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IHashEq;
import clojure.lang.Murmur3;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigInt
extends Number
implements IHashEq {
    public final long lpart;
    public final BigInteger bipart;
    public static final BigInt ZERO = new BigInt(0L, null);
    public static final BigInt ONE = new BigInt(1L, null);

    public int hashCode() {
        if (this.bipart == null) {
            return (int)(this.lpart ^ this.lpart >>> 32);
        }
        return this.bipart.hashCode();
    }

    @Override
    public int hasheq() {
        if (this.bipart == null) {
            return Murmur3.hashLong(this.lpart);
        }
        return this.bipart.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BigInt) {
            BigInt o = (BigInt)obj;
            if (this.bipart == null) {
                return o.bipart == null && this.lpart == o.lpart;
            }
            return o.bipart != null && this.bipart.equals(o.bipart);
        }
        return false;
    }

    private BigInt(long lpart, BigInteger bipart) {
        this.lpart = lpart;
        this.bipart = bipart;
    }

    public static BigInt fromBigInteger(BigInteger val) {
        if (val.bitLength() < 64) {
            return new BigInt(val.longValue(), null);
        }
        return new BigInt(0L, val);
    }

    public static BigInt fromLong(long val) {
        return new BigInt(val, null);
    }

    public BigInteger toBigInteger() {
        if (this.bipart == null) {
            return BigInteger.valueOf(this.lpart);
        }
        return this.bipart;
    }

    public BigDecimal toBigDecimal() {
        if (this.bipart == null) {
            return BigDecimal.valueOf(this.lpart);
        }
        return new BigDecimal(this.bipart);
    }

    @Override
    public int intValue() {
        if (this.bipart == null) {
            return (int)this.lpart;
        }
        return this.bipart.intValue();
    }

    @Override
    public long longValue() {
        if (this.bipart == null) {
            return this.lpart;
        }
        return this.bipart.longValue();
    }

    @Override
    public float floatValue() {
        if (this.bipart == null) {
            return this.lpart;
        }
        return this.bipart.floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.bipart == null) {
            return this.lpart;
        }
        return this.bipart.doubleValue();
    }

    @Override
    public byte byteValue() {
        if (this.bipart == null) {
            return (byte)this.lpart;
        }
        return this.bipart.byteValue();
    }

    @Override
    public short shortValue() {
        if (this.bipart == null) {
            return (short)this.lpart;
        }
        return this.bipart.shortValue();
    }

    public static BigInt valueOf(long val) {
        return new BigInt(val, null);
    }

    public String toString() {
        if (this.bipart == null) {
            return String.valueOf(this.lpart);
        }
        return this.bipart.toString();
    }

    public int bitLength() {
        return this.toBigInteger().bitLength();
    }

    public BigInt add(BigInt y) {
        long ret;
        if (this.bipart == null && y.bipart == null && (((ret = this.lpart + y.lpart) ^ this.lpart) >= 0L || (ret ^ y.lpart) >= 0L)) {
            return BigInt.valueOf(ret);
        }
        return BigInt.fromBigInteger(this.toBigInteger().add(y.toBigInteger()));
    }

    public BigInt multiply(BigInt y) {
        if (this.bipart == null && y.bipart == null) {
            long ret = this.lpart * y.lpart;
            if (y.lpart == 0L || ret / y.lpart == this.lpart && this.lpart != Long.MIN_VALUE) {
                return BigInt.valueOf(ret);
            }
        }
        return BigInt.fromBigInteger(this.toBigInteger().multiply(y.toBigInteger()));
    }

    public BigInt quotient(BigInt y) {
        if (this.bipart == null && y.bipart == null) {
            return BigInt.valueOf(this.lpart / y.lpart);
        }
        return BigInt.fromBigInteger(this.toBigInteger().divide(y.toBigInteger()));
    }

    public BigInt remainder(BigInt y) {
        if (this.bipart == null && y.bipart == null) {
            return BigInt.valueOf(this.lpart % y.lpart);
        }
        return BigInt.fromBigInteger(this.toBigInteger().remainder(y.toBigInteger()));
    }

    public boolean lt(BigInt y) {
        if (this.bipart == null && y.bipart == null) {
            return this.lpart < y.lpart;
        }
        return this.toBigInteger().compareTo(y.toBigInteger()) < 0;
    }
}

