;;;; DO NOT MODIFY ;;;;
;;; WARNING ;;;

;; This class was auto-generated by expose-api, do not manually edit
;; or your edits might get overwritten when it gets re-generated.
;; Instead modify the expose-api generation.
;; Refer to https://github.com/xadecimal/expose-api

;;; WARNING ;;;
;;;; DO NOT MODIFY ;;;

(ns com.xadecimal.async-style
  "Definitions:
    async: asynchronously running on the async-pool, await and others will park, use it for polling and small compute tasks
    blocking: asynchronously running on the blocking-pool, use it for running blocking operations and blocking io
    compute: asynchronously running on the compute-pool, use it for running heavy computation, don't block it
    settle(d): when a channel is delivered a value and closed, or in the case of a promise-chan, it means the promise-chan was fulfilled and will forever return the same value every time it is taken for and additional puts are ignored.
    fulfill(ed): when a channel is delivered a value, but not necessarily closed
    join(ed): when a channel returns a channel, joining is the process of further taking from the returned channel until a value is returned, thus unrolling a channel of channel of channel of ...
    async-pool: the core.async go block executor, it is fixed size, defaulting to 8 threads, don't soft or hard block it
    blocking-pool: the core.async thread block executor, it is caching, unbounded and not pre-allocated, use it for blocking operations and blocking io
    compute-pool: the clojure.core Agent pooledExecutor, it is fixed size bounded to cpu cores + 2 and pre-allocated, use it for heavy computation, don't block it"
  (:refer-clojure :exclude [await time])
  (:require [com.xadecimal.async-style.impl :as impl]))

(defn error?
  "Returns true if v is considered an error as per async-style's error
   representations, false otherwise. Valid error representations in async-style
   for now are:
     * instances of Throwable"
  {:inline (fn ([v] ` (com.xadecimal.async-style.impl/error? ~v)))}
  ([v] (com.xadecimal.async-style.impl/error? v)))

(defn ok?
  "Returns true if v is not considered an error as per async-style's error
   representations, false otherwise. Valid error representations in async-style
   for now are:
     * instances of Throwable"
  {:inline (fn ([v] ` (com.xadecimal.async-style.impl/ok? ~v)))}
  ([v] (com.xadecimal.async-style.impl/ok? v)))

(defn cancelled?
  "Returns true if execution context was cancelled and thus should be
   interrupted/short-circuited, false otherwise.

   Users are expected, when inside an execution block like async, blocking or
   compute, to check using (cancelled? or check-cancelled!) as often as they can
   in case someone tried to cancel their execution, in which case they should
   interrupt/short-circuit the work as soon as they can."
  {:inline (fn ([] ` (com.xadecimal.async-style.impl/cancelled?)))}
  ([] (com.xadecimal.async-style.impl/cancelled?)))

(defn check-cancelled!
  "Throws if execution context was cancelled and thus should be
   interrupted/short-circuited, returns nil.

   Users are expected, when inside an execution block like async, blocking or
   compute, to check using (cancelled? or check-cancelled!) as often as they can
   in case someone tried to cancel their execution, in which case they should
   interrupt/short-circuit the work as soon as they can."
  {:inline (fn ([] ` (com.xadecimal.async-style.impl/check-cancelled!)))}
  ([] (com.xadecimal.async-style.impl/check-cancelled!)))

(defn cancel!
  "When called on chan, tries to tell processes currently executing over the
   chan that they should interrupt and short-circuit (aka cancel) their execution
   as soon as they can, as it is no longer needed.

   The way cancellation is conveyed is by settling the return channel of async,
   blocking and compute blocks to a CancellationException, unless passed a v
   explicitly, in which case it will settle it with v.

   That means by default a block that has its execution cancelled will return a
   CancellationException and thus awaiters and other takers of its result will
   see the exception and can handle it accordingly. If instead you want to cancel
   the block so it returns a value, pass in a v and the awaiters and takers will
   receive that value instead. You can't set nil as the cancelled value,
   attempting to do so will throw an IllegalArgumentException.

   It is up to processes inside async, blocking and compute blocks to properly
   check for cancellation on a channel."
  {:inline (fn
             ([chan] ` (com.xadecimal.async-style.impl/cancel! ~chan))
             ([chan v] ` (com.xadecimal.async-style.impl/cancel! ~chan ~v)))}
  ([chan] (com.xadecimal.async-style.impl/cancel! chan))
  ([chan v] (com.xadecimal.async-style.impl/cancel! chan v)))

(defmacro await*
  "Parking takes from chan-or-value so that any exception is returned, and with
   taken result fully joined."
  {}
  ([chan-or-value] ` (com.xadecimal.async-style.impl/await* ~chan-or-value)))

(defn wait*
  "Blocking takes from chan-or-value so that any exception is returned, and with
   taken result fully joined."
  {:inline (fn
             ([chan-or-value]
              `
              (com.xadecimal.async-style.impl/wait* ~chan-or-value)))}
  ([chan-or-value] (com.xadecimal.async-style.impl/wait* chan-or-value)))

(defmacro async
  "Asynchronously execute body on the async-pool with support for cancellation,
   implicit-try, and returning a promise-chan settled with the result or any
   exception thrown.

   body will run on the async-pool, so if you plan on doing something blocking
   or compute heavy, use blocking or compute instead."
  {}
  ([& body] ` (com.xadecimal.async-style.impl/async ~@body)))

(defmacro blocking
  "Asynchronously execute body on the blocking-pool with support for
   cancellation, implicit-try, and returning a promise-chan settled with the
   result or any exception thrown.

   body will run on the blocking-pool, so use this when you will be blocking or
   doing blocking io only."
  {}
  ([& body] ` (com.xadecimal.async-style.impl/blocking ~@body)))

(defmacro compute
  "Asynchronously execute body on the compute-pool with support for
   cancellation, implicit-try, and returning a promise-chan settled with the
   result or any exception thrown.

   body will run on the compute-pool, so use this when you will be doing heavy
   computation, and don't block, if you're going to block use blocking
   instead. If you're doing a very small computation, like polling another chan,
   use async instead."
  {}
  ([& body] ` (com.xadecimal.async-style.impl/compute ~@body)))

(defmacro await
  "Parking takes from chan-or-value so that any exception taken is re-thrown,
   and with taken result fully joined.

   Supports implicit-try to handle thrown exceptions such as:

   (async
     (await (async (/ 1 0))
            (catch ArithmeticException e
              (println e))
            (catch Exception e
              (println \"Other unexpected excpetion\"))
            (finally (println \"done\"))))"
  {}
  ([chan-or-value & body]
   `
   (com.xadecimal.async-style.impl/await ~chan-or-value ~@body)))

(defmacro wait
  "Blocking takes from chan-or-value so that any exception taken is re-thrown,
   and with taken result fully joined.

   Supports implicit-try to handle thrown exceptions such as:

   (wait (async (/ 1 0))
         (catch ArithmeticException e
           (println e))
         (catch Exception e
           (println \"Other unexpected excpetion\"))
         (finally (println \"done\")))"
  {}
  ([chan-or-value & body]
   `
   (com.xadecimal.async-style.impl/wait ~chan-or-value ~@body)))

(defn catch
  "Parking takes fully joined value from chan. If value is an error of
   pred-or-type, will call error-handler with it.

   Returns a promise-chan settled with the value or the return of the
   error-handler.

   error-handler will run on the async-pool, so if you plan on doing something
   blocking or compute heavy, remember to wrap it in a blocking or compute
   respectively."
  {:inline (fn
             ([chan error-handler]
              `
              (com.xadecimal.async-style.impl/catch ~chan ~error-handler))
             ([chan pred-or-type error-handler]
              `
              (com.xadecimal.async-style.impl/catch ~chan ~pred-or-type
                ~error-handler)))}
  ([chan error-handler]
   (com.xadecimal.async-style.impl/catch chan error-handler))
  ([chan pred-or-type error-handler]
   (com.xadecimal.async-style.impl/catch chan pred-or-type error-handler)))

(defn finally
  "Parking takes fully joined value from chan, and calls f with it no matter if
   the value is ok? or error?.

   Returns a promise-chan settled with the taken value, and not the return of f,
   which means f is implied to be doing side-effect(s).

   f will run on the async-pool, so if you plan on doing something blocking or
   compute heavy, remember to wrap it in a blocking or compute respectively."
  {:inline (fn ([chan f] ` (com.xadecimal.async-style.impl/finally ~chan ~f)))}
  ([chan f] (com.xadecimal.async-style.impl/finally chan f)))

(defn then
  "Asynchronously executes f with the result of chan once available, unless chan
   results in an error, in which case f is not executed.

   Returns a promise-chan settled with the result of f or the error.

   f will run on the async-pool, so if you plan on doing something blocking or
   compute heavy, remember to wrap it in a blocking or compute respectively."
  {:inline (fn ([chan f] ` (com.xadecimal.async-style.impl/then ~chan ~f)))}
  ([chan f] (com.xadecimal.async-style.impl/then chan f)))

(defn chain
  "Chains multiple then together starting with chan like:
     (-> chan (then f1) (then f2) (then fs) ...)

   fs will all run on the async-pool, so if you plan on doing something blocking
   or compute heavy, remember to wrap it in a blocking or compute respectively."
  {:inline (fn
             ([chan & fs] ` (com.xadecimal.async-style.impl/chain ~chan ~@fs)))}
  ([chan & fs]
   (clojure.core/apply com.xadecimal.async-style.impl/chain chan fs)))

(defn handle
  "Asynchronously executes f with the result of chan once available (f result),
   unlike then, handle will always execute f, when chan's result is an error f is
   called with the error (f error).

   Returns a promise-chan settled with the result of f.

   Alternatively, one can pass an ok-handler and an error-handler and the
   respective one will be called based on if chan's result is ok (ok-handler
   result) or an error (error-handler error).

   f, ok-handler and error-handler will all run on the async-pool, so if you
   plan on doing something blocking or compute heavy, remember to wrap it in a
   blocking or compute respectively."
  {:inline (fn
             ([chan f] ` (com.xadecimal.async-style.impl/handle ~chan ~f))
             ([chan ok-handler error-handler]
              `
              (com.xadecimal.async-style.impl/handle ~chan
                                                     ~ok-handler
                                                     ~error-handler)))}
  ([chan f] (com.xadecimal.async-style.impl/handle chan f))
  ([chan ok-handler error-handler]
   (com.xadecimal.async-style.impl/handle chan ok-handler error-handler)))

(defn sleep
  "Asynchronously sleep ms time, returns a promise-chan which settles after ms
   time."
  {:inline (fn ([ms] ` (com.xadecimal.async-style.impl/sleep ~ms)))}
  ([ms] (com.xadecimal.async-style.impl/sleep ms)))

(defn defer
  "Waits ms time and then asynchronously executes value-or-fn, returning a
   promsie-chan settled with the result.

   value-or-fn will run on the async-pool, so if you plan on doing something
   blocking or compute heavy, remember to wrap it in a blocking or compute
   respectively."
  {:inline (fn
             ([ms value-or-fn]
              `
              (com.xadecimal.async-style.impl/defer ~ms ~value-or-fn)))}
  ([ms value-or-fn] (com.xadecimal.async-style.impl/defer ms value-or-fn)))

(defn timeout
  "If chan fulfills before ms time has passed, return a promise-chan settled
   with the result, else returns a promise-chan settled with a TimeoutException
   or the result of timed-out-value-or-fn.

   In the case of a timeout, chan will be cancelled.

   timed-out-value-or-fn will run on the async-pool, so if you plan on doing
   something blocking or compute heavy, remember to wrap it in a blocking or
   compute respectively."
  {:inline (fn
             ([chan ms] ` (com.xadecimal.async-style.impl/timeout ~chan ~ms))
             ([chan ms timed-out-value-or-fn]
              `
              (com.xadecimal.async-style.impl/timeout ~chan
                                                      ~ms
                                                      ~timed-out-value-or-fn)))}
  ([chan ms] (com.xadecimal.async-style.impl/timeout chan ms))
  ([chan ms timed-out-value-or-fn]
   (com.xadecimal.async-style.impl/timeout chan ms timed-out-value-or-fn)))

(defn race
  "Returns a promise-chan that settles as soon as one of the chan in chans
   fulfill, with the value taken (and joined) from that chan.

   Unlike any, this will also return the first error? to be returned by one of
   the chans. So if the first chan to fulfill does so with an error?, race will
   return a promise-chan settled with that error.

   Once a chan fulfills, race cancels all the others."
  {:inline (fn ([chans] ` (com.xadecimal.async-style.impl/race ~chans)))}
  ([chans] (com.xadecimal.async-style.impl/race chans)))

(defn any
  "Returns a promise-chan that settles as soon as one of the chan in chans
   fulfills in ok?, with the value taken (and joined) from that chan.

   Unlike race, this will ignore chans that fulfilled with an error?. So if the
   first chan to fulfill does so with an error?, any will keep waiting for
   another chan to eventually fulfill in ok?.

   If all chans fulfill in error?, returns an error containing the list of all
   the errors.

   Once a chan fulfills with an ok?, any cancels all the others."
  {:inline (fn ([chans] ` (com.xadecimal.async-style.impl/any ~chans)))}
  ([chans] (com.xadecimal.async-style.impl/any chans)))

(defn all-settled
  "Takes a seqable of chans as an input, and returns a promise-chan that settles
   after all of the given chans have fulfilled in ok? or error?, with a vector of
   the taken ok? results and error? results of the input chans.

   It is typically used when you have multiple asynchronous tasks that are not
   dependent on one another to complete successfully, or you'd always like to
   know the result of each chan even when one errors.

   In comparison, the promise-chan returned by all may be more appropriate if
   the tasks are dependent on each other / if you'd like to immediately stop upon
   any of them returning an error?."
  {:inline (fn ([chans] ` (com.xadecimal.async-style.impl/all-settled ~chans)))}
  ([chans] (com.xadecimal.async-style.impl/all-settled chans)))

(defn all
  "Takes a seqable of chans as an input, and returns a promise-chan that settles
   after all of the given chans have fulfilled in ok?, with a vector of the taken
   ok? results of the input chans. This returned promise-chan will settle when
   all of the input's chans have fulfilled, or if the input seqable contains no
   chans (only values or empty). It settles in error? immediately upon any of the
   input chans returning an error? or non-chans throwing an error?, and will
   contain the error? of the first taken chan to return one."
  {:inline (fn ([chans] ` (com.xadecimal.async-style.impl/all ~chans)))}
  ([chans] (com.xadecimal.async-style.impl/all chans)))

(defmacro ado
  "Asynchronous do. Execute expressions one after the other, awaiting the result
   of each one before moving on to the next. Results are lost to the void, same
   as clojure.core/do, so side effects are expected. Returns a promise-chan which
   settles with the result of the last expression when the entire do! is done."
  {}
  ([& exprs] ` (com.xadecimal.async-style.impl/ado ~@exprs)))

(defmacro alet
  "Asynchronous let. Binds result of async expressions to local binding, executing
   bindings in order one after the other."
  {}
  ([bindings & exprs]
   `
   (com.xadecimal.async-style.impl/alet ~bindings ~@exprs)))

(defmacro clet
  "Concurrent let. Executes all bound expressions in an async block so that
   the bindings run concurrently. If a later binding or the body depends on an
   earlier binding, that reference is automatically replaced with an await.
   In a blocking/compute context, await is transformed to wait for proper
   blocking behavior.

   Notes:
     * Bindings are evaluated in the async-pool; therefore, they should not
       perform blocking I/O or heavy compute directly. If you need to do blocking
       operations or heavy compute, wrap the binding in a blocking or compute call.
     * This macro only supports simple symbol bindings; destructuring (vector or
       map destructuring) is not supported.
     * It will transform symbols even inside quoted forms, so literal code in quotes
       may be rewritten unexpectedly.
     * Inner local bindings (e.g. via a nested let) that shadow an outer binding are
       not handled separately; the macro will attempt to rewrite every occurrence,
       which may lead to incorrect replacements.
     * Anonymous functions that use parameter names identical to outer bindings
       will also be rewritten, which can cause unintended behavior if they are meant
       to shadow those bindings."
  {}
  ([bindings & body] ` (com.xadecimal.async-style.impl/clet ~bindings ~@body)))

(defmacro time
  "Evaluates expr and prints the time it took. Returns the value of expr. If
   expr evaluates to a channel, it waits for channel to fulfill before printing
   the time it took."
  {}
  ([expr] ` (com.xadecimal.async-style.impl/time ~expr))
  ([expr print-fn] ` (com.xadecimal.async-style.impl/time ~expr ~print-fn)))

;;;; DO NOT MODIFY ;;;;
;;; WARNING ;;;

;; This class was auto-generated by expose-api, do not manually edit
;; or your edits might get overwritten when it gets re-generated.
;; Instead modify the expose-api generation.
;; Refer to https://github.com/xadecimal/expose-api

;;; WARNING ;;;
;;;; DO NOT MODIFY ;;;
