goog.provide('com.wsscode.pathom.test');
goog.require('cljs.core');
goog.require('com.wsscode.pathom.core');
goog.require('com.wsscode.pathom.misc');
goog.require('com.wsscode.async.async_cljs');
goog.require('edn_query_language.core');
goog.require('clojure.string');
goog.require('com.fulcrologic.guardrails.core');
goog.require('cljs.spec.alpha');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.int_QMARK_);
/**
 * Check if the mod of the hash of x is zero. This is useful to call against some random value.
 *   It will have a chance of 1/n to be true.
 */
com.wsscode.pathom.test.hash_mod_QMARK_ = (function com$wsscode$pathom$test$hash_mod_QMARK_(x,n){
return (cljs.core.mod.call(null,cljs.core.hash.call(null,x),n) === (0));
});
/**
 * Generate a random value for a key, uses hash-mod to pick what type of value will be returned.
 */
com.wsscode.pathom.test.key_ex_value = (function com$wsscode$pathom$test$key_ex_value(key,p__82109){
var map__82111 = p__82109;
var map__82111__$1 = (((((!((map__82111 == null))))?(((((map__82111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82111.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82111):map__82111);
var env = map__82111__$1;
var throw_errors_QMARK_ = cljs.core.get.call(null,map__82111__$1,new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797));
var include_nils_QMARK_ = cljs.core.get.call(null,map__82111__$1,new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358),true);
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(11))){
return false;
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = include_nils_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(9));
} else {
return and__4120__auto__;
}
})())){
return null;
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(8))){
return true;
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(7))){
return com.wsscode.pathom.core.cached_STAR_.call(null,env,key,((function (map__82111,map__82111__$1,env,throw_errors_QMARK_,include_nils_QMARK_){
return (function (){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(key);
});})(map__82111,map__82111__$1,env,throw_errors_QMARK_,include_nils_QMARK_))
);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = throw_errors_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(5));
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Demo error",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"x","x",2099068185),key], null));
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,key,(3))){
return cljs.core.hash.call(null,key);
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(key);

}
}
}
}
}
}
});
/**
 * Picks a union path based on the hash-mod of key.
 */
com.wsscode.pathom.test.union_test_path = (function com$wsscode$pathom$test$union_test_path(env){
var temp__5718__auto__ = cljs.core.seq.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ast","ast",-860334068).cljs$core$IFn$_invoke$arity$1(env)))));
if(temp__5718__auto__){
var entries = temp__5718__auto__;
return new cljs.core.Keyword(null,"union-key","union-key",1529707234).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,entries,cljs.core.mod.call(null,cljs.core.hash.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ast","ast",-860334068).cljs$core$IFn$_invoke$arity$1(env))),cljs.core.count.call(null,entries))));
} else {
return null;
}
});
/**
 * Reader suited for random testing.
 */
com.wsscode.pathom.test.reader = (function com$wsscode$pathom$test$reader(p__82127){
var map__82128 = p__82127;
var map__82128__$1 = (((((!((map__82128 == null))))?(((((map__82128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82128.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82128):map__82128);
var env = map__82128__$1;
var ast = cljs.core.get.call(null,map__82128__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var query = cljs.core.get.call(null,map__82128__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var depth_limit = cljs.core.get.call(null,map__82128__$1,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(5));
if(cljs.core.truth_(query)){
if((depth_limit > (0))){
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),(5))){
return com.wsscode.pathom.core.join_seq.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(depth_limit - (3))),cljs.core.vec.call(null,cljs.core.repeat.call(null,cljs.core.mod.call(null,cljs.core.hash.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast)),(4)),cljs.core.PersistentArrayMap.EMPTY)));
} else {
return com.wsscode.pathom.core.join.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(depth_limit - (1))));
}
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),(5))){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return com.wsscode.pathom.test.key_ex_value.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),env);
}
});
/**
 * Like reader, but have a chance to return channels.
 */
com.wsscode.pathom.test.async_reader = (function com$wsscode$pathom$test$async_reader(p__82138){
var map__82139 = p__82138;
var map__82139__$1 = (((((!((map__82139 == null))))?(((((map__82139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82139):map__82139);
var env = map__82139__$1;
var ast = cljs.core.get.call(null,map__82139__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var query = cljs.core.get.call(null,map__82139__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var depth_limit = cljs.core.get.call(null,map__82139__$1,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(5));
if(cljs.core.truth_(query)){
if((depth_limit > (0))){
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),(5))){
return com.wsscode.pathom.core.join_seq.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(depth_limit - (3))),cljs.core.vec.call(null,cljs.core.repeat.call(null,cljs.core.mod.call(null,cljs.core.hash.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast)),(4)),cljs.core.PersistentArrayMap.EMPTY)));
} else {
return com.wsscode.pathom.core.join.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("com.wsscode.pathom.test","depth-limit","com.wsscode.pathom.test/depth-limit",827113181),(depth_limit - (1))));
}
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),(5))){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
if(com.wsscode.pathom.test.hash_mod_QMARK_.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),(2))){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit){
return (function (state_82157){
var state_val_82158 = (state_82157[(1)]);
if((state_val_82158 === (1))){
var state_82157__$1 = state_82157;
var statearr_82162_82243 = state_82157__$1;
(statearr_82162_82243[(2)] = null);

(statearr_82162_82243[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82158 === (2))){
var inst_82155 = (state_82157[(2)]);
var state_82157__$1 = state_82157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82157__$1,inst_82155);
} else {
if((state_val_82158 === (3))){
var inst_82147 = (state_82157[(2)]);
var state_82157__$1 = state_82157;
var statearr_82167_82244 = state_82157__$1;
(statearr_82167_82244[(2)] = inst_82147);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_82157__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82158 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_82157,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_82152 = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast);
var inst_82153 = com.wsscode.pathom.test.key_ex_value.call(null,inst_82152,env);
var state_82157__$1 = state_82157;
var statearr_82168_82245 = state_82157__$1;
(statearr_82168_82245[(2)] = inst_82153);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_82157__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});})(c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit))
;
return ((function (switch__53637__auto__,c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit){
return (function() {
var com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__ = null;
var com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____0 = (function (){
var statearr_82172 = [null,null,null,null,null,null,null];
(statearr_82172[(0)] = com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__);

(statearr_82172[(1)] = (1));

return statearr_82172;
});
var com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____1 = (function (state_82157){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_82157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e82177){if((e82177 instanceof Object)){
var ex__53641__auto__ = e82177;
var statearr_82179_82246 = state_82157;
(statearr_82179_82246[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_82157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e82177;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82247 = state_82157;
state_82157 = G__82247;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__ = function(state_82157){
switch(arguments.length){
case 0:
return com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____0.call(this);
case 1:
return com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____1.call(this,state_82157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____0;
com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto____1;
return com$wsscode$pathom$test$async_reader_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit))
})();
var state__54030__auto__ = (function (){var statearr_82185 = f__54029__auto__();
(statearr_82185[(6)] = c__54028__auto__);

return statearr_82185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,map__82139,map__82139__$1,env,ast,query,depth_limit))
);

return c__54028__auto__;
} else {
return com.wsscode.pathom.test.key_ex_value.call(null,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast),env);
}
}
});
/**
 * Mutation function suited for random testing.
 */
com.wsscode.pathom.test.mutate_fn = (function com$wsscode$pathom$test$mutate_fn(p__82187,k,_){
var map__82188 = p__82187;
var map__82188__$1 = (((((!((map__82188 == null))))?(((((map__82188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__82188.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__82188):map__82188);
var throw_errors_QMARK_ = cljs.core.get.call(null,map__82188__$1,new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__82188,map__82188__$1,throw_errors_QMARK_){
return (function (){
if(cljs.core.truth_((function (){var and__4120__auto__ = throw_errors_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return com.wsscode.pathom.test.hash_mod_QMARK_.call(null,k,(5));
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Demo error",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"x","x",2099068185),k], null));
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(k);
}
});})(map__82188,map__82188__$1,throw_errors_QMARK_))
], null);
});
/**
 * This reader looks for ident queries starting with :repeat., and repeat for the ident value amount of times.
 */
com.wsscode.pathom.test.repeat_reader = (function com$wsscode$pathom$test$repeat_reader(env){
var temp__5718__auto__ = com.wsscode.pathom.core.ident_key.call(null,env);
if(cljs.core.truth_(temp__5718__auto__)){
var key = temp__5718__auto__;
if(cljs.core.truth_((function (){var G__82197 = key;
var G__82197__$1 = (((G__82197 == null))?null:cljs.core.name.call(null,G__82197));
if((G__82197__$1 == null)){
return null;
} else {
return clojure.string.starts_with_QMARK_.call(null,G__82197__$1,"repeat.");
}
})())){
return com.wsscode.pathom.core.join_seq.call(null,env,cljs.core.map.call(null,cljs.core.constantly.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.range.call(null,com.wsscode.pathom.core.ident_value.call(null,env))));
} else {
return new cljs.core.Keyword("com.wsscode.pathom.core","continue","com.wsscode.pathom.core/continue",591698194);
}
} else {
return new cljs.core.Keyword("com.wsscode.pathom.core","continue","com.wsscode.pathom.core/continue",591698194);
}
});
if(com.wsscode.pathom.misc.INCLUDE_SPECS){
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom.test","hash-mod?","com.wsscode.pathom.test/hash-mod?",1840893997,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"n","n",562130025),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","nat-int?","cljs.core/nat-int?",-164364171,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"n","n",562130025),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"n","n",562130025)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.any_QMARK_,cljs.core.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"n","n",562130025),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","nat-int?","cljs.core/nat-int?",-164364171,null),cljs.core.nat_int_QMARK_,null,null),new cljs.core.Symbol("cljs.core","nat-int?","cljs.core/nat-int?",-164364171,null),null,null,null));

cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom.test","key-ex-value","com.wsscode.pathom.test/key-ex-value",-397098031,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword("edn-query-language.core","join-key","edn-query-language.core/join-key",-2056428321),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null)))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword("edn-query-language.core","join-key","edn-query-language.core/join-key",-2056428321),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"env","env",-1815813235)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("edn-query-language.core","join-key","edn-query-language.core/join-key",-2056428321),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__82215){
return cljs.core.map_QMARK_.call(null,G__82215);
})], null),(function (G__82215){
return cljs.core.map_QMARK_.call(null,G__82215);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("edn-query-language.core","join-key","edn-query-language.core/join-key",-2056428321),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword("edn-query-language.core","join-key","edn-query-language.core/join-key",-2056428321),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom.test","throw-errors?","com.wsscode.pathom.test/throw-errors?",-1606486797),new cljs.core.Keyword("com.wsscode.pathom.test","include-nils?","com.wsscode.pathom.test/include-nils?",390587358)], null))),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));
} else {
}

//# sourceMappingURL=com.wsscode.pathom.test.js.map
