goog.provide('fulcro.incubator.spec_helpers');
goog.require('cljs.core');
goog.require('cljs.env');
goog.require('cljs.test');
goog.require('cljs.spec.test.alpha');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('cljs.pprint');
goog.require('cljs.spec.alpha');
goog.require('cljs.spec.gen.alpha');
goog.require('cljs.core.specs.alpha');
fulcro.incubator.spec_helpers._STAR_unsafe_bound_ops_STAR_ = cljs.core.PersistentHashSet.EMPTY;
fulcro.incubator.spec_helpers.cljs_env_QMARK_ = (function fulcro$incubator$spec_helpers$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});
fulcro.incubator.spec_helpers.clj__GT_cljs = (function fulcro$incubator$spec_helpers$clj__GT_cljs(var_args){
var G__68235 = arguments.length;
switch (G__68235) {
case 1:
return fulcro.incubator.spec_helpers.clj__GT_cljs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.spec_helpers.clj__GT_cljs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.spec_helpers.clj__GT_cljs.cljs$core$IFn$_invoke$arity$1 = (function (form){
return fulcro.incubator.spec_helpers.clj__GT_cljs.call(null,form,true);
});

fulcro.incubator.spec_helpers.clj__GT_cljs.cljs$core$IFn$_invoke$arity$2 = (function (form,strip_core_ns){
var ns_replacements = (function (){var G__68245 = new cljs.core.PersistentArrayMap(null, 6, ["clojure.core","cljs.core","clojure.test","cljs.test","clojure.spec.alpha","cljs.spec.alpha","clojure.spec.test.alpha","cljs.spec.test.alpha","orchestra.spec.test","orchestra-cljs.spec.test","clojure.spec.gen.alpha","cljs.spec.gen.alpha"], null);
if(cljs.core.truth_(strip_core_ns)){
return cljs.core.merge.call(null,G__68245,new cljs.core.PersistentArrayMap(null, 2, ["clojure.core",null,"cljs.core",null], null));
} else {
return G__68245;
}
})();
var replace_namespace = ((function (ns_replacements){
return (function (p1__68225_SHARP_){
if((!(cljs.core.qualified_symbol_QMARK_.call(null,p1__68225_SHARP_)))){
return p1__68225_SHARP_;
} else {
var nspace = cljs.core.namespace.call(null,p1__68225_SHARP_);
if(cljs.core.contains_QMARK_.call(null,ns_replacements,nspace)){
return cljs.core.symbol.call(null,cljs.core.get.call(null,ns_replacements,nspace),cljs.core.name.call(null,p1__68225_SHARP_));
} else {
return p1__68225_SHARP_;
}
}
});})(ns_replacements))
;
return clojure.walk.postwalk.call(null,replace_namespace,form);
});

fulcro.incubator.spec_helpers.clj__GT_cljs.cljs$lang$maxFixedArity = 2;

/**
 * Returns a tuple with the number of regular and non-variadic arguments.
 */
fulcro.incubator.spec_helpers.count_args = (function fulcro$incubator$spec_helpers$count_args(conformed_args){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.count.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(conformed_args)),(cljs.core.truth_(new cljs.core.Keyword(null,"varargs","varargs",1030150858).cljs$core$IFn$_invoke$arity$1(conformed_args))?(1):(0))], null);
});
fulcro.incubator.spec_helpers._EQ__GT_ = new cljs.core.Keyword(null,"ret","ret",-468222814);
fulcro.incubator.spec_helpers._BAR_ = new cljs.core.Keyword(null,"st","st",1455255828);
fulcro.incubator.spec_helpers._LT__ = new cljs.core.Keyword(null,"gen","gen",142575302);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","trace","fulcro.incubator.spec-helpers/trace",160522118),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [(0),"null",(1),"null",(4),"null",true,"null",(3),"null",(2),"null",(5),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [(0),null,(1),null,(4),null,true,null,(3),null,(2),null,(5),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","trace-color","fulcro.incubator.spec-helpers/trace-color",542212530),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"literal","literal",1664775605),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68253#","p1__68253#",-2080136967,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","re-matches","cljs.core/re-matches",2013608485,null),/#[a-fA-F0-9]+/,new cljs.core.Symbol(null,"p1__68253#","p1__68253#",-2080136967,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)),(7)),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)),(4)))))),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"literal","literal",1664775605)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68253#","p1__68253#",-2080136967,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","re-matches","cljs.core/re-matches",2013608485,null),/#[a-fA-F0-9]+/,new cljs.core.Symbol(null,"p1__68253#","p1__68253#",-2080136967,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)),(7)),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__68254#","p1__68254#",-208696809,null)),(4)))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","re-matches","cljs.core/re-matches",2013608485,null),/#[a-fA-F0-9]+/,new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),(7)),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),(4))))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.string_QMARK_,(function (p1__68253_SHARP_){
return cljs.core.re_matches.call(null,/#[a-fA-F0-9]+/,p1__68253_SHARP_);
}),(function (p1__68254_SHARP_){
return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,p1__68254_SHARP_),(7))) || (cljs.core._EQ_.call(null,cljs.core.count.call(null,p1__68254_SHARP_),(4))));
})], null),null)], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","check","fulcro.incubator.spec-helpers/check",-2093128279),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","check-coverage","fulcro.incubator.spec-helpers/check-coverage",684590947),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","ignore-fx","fulcro.incubator.spec-helpers/ignore-fx",-214141368),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","num-tests","fulcro.incubator.spec-helpers/num-tests",1066139285),new cljs.core.Symbol("cljs.core","nat-int?","cljs.core/nat-int?",-164364171,null),cljs.core.nat_int_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","num-tests-ext","fulcro.incubator.spec-helpers/num-tests-ext",1107586771),new cljs.core.Symbol("cljs.core","nat-int?","cljs.core/nat-int?",-164364171,null),cljs.core.nat_int_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","extensive-tests","fulcro.incubator.spec-helpers/extensive-tests",-1653945389),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","instrument","fulcro.incubator.spec-helpers/instrument",-2074640487),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","outstrument","fulcro.incubator.spec-helpers/outstrument",1860244099),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","extrument","fulcro.incubator.spec-helpers/extrument",122509503),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","qualified-symbol?","cljs.core/qualified-symbol?",1570873476,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.nilable_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","qualified-symbol?","cljs.core/qualified-symbol?",1570873476,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"qualified-symbol?","qualified-symbol?",98763807,null),cljs.core.qualified_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68341){
return cljs.core.vector_QMARK_.call(null,G__68341);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","qualified-symbol?","cljs.core/qualified-symbol?",1570873476,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68342#","p1__68342#",-1385503908,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","not=","cljs.core/not=",1017572457,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),new cljs.core.Symbol(null,"p1__68342#","p1__68342#",-1385503908,null)))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","not=","cljs.core/not=",1017572457,null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.simple_symbol_QMARK_,(function (p1__68342_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"&","&",-2144855648,null),p1__68342_SHARP_);
})], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","seq-binding-form","fulcro.incubator.spec-helpers/seq-binding-form",-1922681363),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"elems","elems",-547490822),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),new cljs.core.Keyword(null,"rest","rest",-1241696419),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))),new cljs.core.Keyword(null,"as","as",1148689641),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),"null"], null), null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"elems","elems",-547490822),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),new cljs.core.Keyword(null,"rest","rest",-1241696419),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))),new cljs.core.Keyword(null,"as","as",1148689641),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),"null"], null), null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"elems","elems",-547490822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword(null,"as","as",1148689641)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.Keyword(null,"form","form",-1624062471)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"sym","sym",-1444860305)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),"null"], null), null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),"null"], null), null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","keys","fulcro.incubator.spec-helpers/keys",156234381),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","ident?","cljs.core/ident?",1567441535,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"ident?","ident?",-2061359468,null),cljs.core.ident_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68397){
return cljs.core.vector_QMARK_.call(null,G__68397);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","ident?","cljs.core/ident?",1567441535,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","syms","fulcro.incubator.spec-helpers/syms",1744237881),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"symbol?","symbol?",1820680511,null),cljs.core.symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68403){
return cljs.core.vector_QMARK_.call(null,G__68403);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","strs","fulcro.incubator.spec-helpers/strs",934554858),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"simple-symbol?","simple-symbol?",1408454822,null),cljs.core.simple_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68410){
return cljs.core.vector_QMARK_.call(null,G__68410);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","or","fulcro.incubator.spec-helpers/or",1202213702),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"simple-symbol?","simple-symbol?",1408454822,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.simple_symbol_QMARK_,cljs.core.any_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68412){
return cljs.core.map_QMARK_.call(null,G__68412);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","as","fulcro.incubator.spec-helpers/as",455378566),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-special-binding","fulcro.incubator.spec-helpers/map-special-binding",-1666739663),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","as","fulcro.incubator.spec-helpers/as",455378566),new cljs.core.Keyword("fulcro.incubator.spec-helpers","or","fulcro.incubator.spec-helpers/or",1202213702),new cljs.core.Keyword("fulcro.incubator.spec-helpers","keys","fulcro.incubator.spec-helpers/keys",156234381),new cljs.core.Keyword("fulcro.incubator.spec-helpers","syms","fulcro.incubator.spec-helpers/syms",1744237881),new cljs.core.Keyword("fulcro.incubator.spec-helpers","strs","fulcro.incubator.spec-helpers/strs",934554858)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","as","fulcro.incubator.spec-helpers/as",455378566),new cljs.core.Keyword("fulcro.incubator.spec-helpers","or","fulcro.incubator.spec-helpers/or",1202213702),new cljs.core.Keyword("fulcro.incubator.spec-helpers","keys","fulcro.incubator.spec-helpers/keys",156234381),new cljs.core.Keyword("fulcro.incubator.spec-helpers","syms","fulcro.incubator.spec-helpers/syms",1744237881),new cljs.core.Keyword("fulcro.incubator.spec-helpers","strs","fulcro.incubator.spec-helpers/strs",934554858)], null),null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__68426){
return cljs.core.map_QMARK_.call(null,G__68426);
})], null),(function (G__68426){
return cljs.core.map_QMARK_.call(null,G__68426);
}),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword(null,"syms","syms",-1575891762),new cljs.core.Keyword(null,"strs","strs",1175537277)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","as","fulcro.incubator.spec-helpers/as",455378566),new cljs.core.Keyword("fulcro.incubator.spec-helpers","or","fulcro.incubator.spec-helpers/or",1202213702),new cljs.core.Keyword("fulcro.incubator.spec-helpers","keys","fulcro.incubator.spec-helpers/keys",156234381),new cljs.core.Keyword("fulcro.incubator.spec-helpers","syms","fulcro.incubator.spec-helpers/syms",1744237881),new cljs.core.Keyword("fulcro.incubator.spec-helpers","strs","fulcro.incubator.spec-helpers/strs",934554858)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),null])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),cljs.core.any_QMARK_], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68437#","p1__68437#",-140253708,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__68437#","p1__68437#",-140253708,null),new cljs.core.Symbol("cljs.core","name","cljs.core/name",-260873443,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["syms","null","keys","null"], null), null)))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68437#","p1__68437#",-140253708,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__68437#","p1__68437#",-140253708,null),new cljs.core.Symbol("cljs.core","name","cljs.core/name",-260873443,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["syms","null","keys","null"], null), null)))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Symbol("cljs.core","name","cljs.core/name",-260873443,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["syms","null","keys","null"], null), null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.qualified_keyword_QMARK_,(function (p1__68437_SHARP_){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["syms",null,"keys",null], null), null).call(null,cljs.core.name.call(null,p1__68437_SHARP_));
})], null),null),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"simple-symbol?","simple-symbol?",1408454822,null),cljs.core.simple_symbol_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68449){
return cljs.core.vector_QMARK_.call(null,G__68449);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null)], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-bindings","fulcro.incubator.spec-helpers/map-bindings",-1470207297),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"mb","mb",1534459853),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),new cljs.core.Keyword(null,"nsk","nsk",-939952068),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),new cljs.core.Keyword(null,"msb","msb",-1623778966),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),"null",new cljs.core.Keyword(null,"or","or",235744169),"null",new cljs.core.Keyword(null,"syms","syms",-1575891762),"null",new cljs.core.Keyword(null,"keys","keys",1068423698),"null",new cljs.core.Keyword(null,"strs","strs",1175537277),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("s","or","s/or",1876282981,null),new cljs.core.Keyword(null,"mb","mb",1534459853),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),new cljs.core.Keyword(null,"nsk","nsk",-939952068),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),new cljs.core.Keyword(null,"msb","msb",-1623778966),cljs.core.list(new cljs.core.Symbol("s","tuple","s/tuple",1167863840,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),"null",new cljs.core.Keyword(null,"or","or",235744169),"null",new cljs.core.Keyword(null,"syms","syms",-1575891762),"null",new cljs.core.Keyword(null,"keys","keys",1068423698),"null",new cljs.core.Keyword(null,"strs","strs",1175537277),"null"], null), null),new cljs.core.Symbol(null,"any?","any?",-318999933,null))),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mb","mb",1534459853),new cljs.core.Keyword(null,"nsk","nsk",-939952068),new cljs.core.Keyword(null,"msb","msb",-1623778966)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),"null",new cljs.core.Keyword(null,"or","or",235744169),"null",new cljs.core.Keyword(null,"syms","syms",-1575891762),"null",new cljs.core.Keyword(null,"keys","keys",1068423698),"null",new cljs.core.Keyword(null,"strs","strs",1175537277),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),"null",new cljs.core.Keyword(null,"or","or",235744169),"null",new cljs.core.Keyword(null,"syms","syms",-1575891762),"null",new cljs.core.Keyword(null,"keys","keys",1068423698),"null",new cljs.core.Keyword(null,"strs","strs",1175537277),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"or","or",235744169),null,new cljs.core.Keyword(null,"syms","syms",-1575891762),null,new cljs.core.Keyword(null,"keys","keys",1068423698),null,new cljs.core.Keyword(null,"strs","strs",1175537277),null], null), null),cljs.core.any_QMARK_], null))], null),null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68457){
return cljs.core.coll_QMARK_.call(null,G__68457);
}),new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","every","cljs.spec.alpha/every",123912744,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"mb","mb",1534459853),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding","fulcro.incubator.spec-helpers/map-binding",2146979436),new cljs.core.Keyword(null,"nsk","nsk",-939952068),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ns-keys","fulcro.incubator.spec-helpers/ns-keys",1339197145),new cljs.core.Keyword(null,"msb","msb",-1623778966),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"as","as",1148689641),"null",new cljs.core.Keyword(null,"or","or",235744169),"null",new cljs.core.Keyword(null,"syms","syms",-1575891762),"null",new cljs.core.Keyword(null,"keys","keys",1068423698),"null",new cljs.core.Keyword(null,"strs","strs",1175537277),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY)], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding-form","fulcro.incubator.spec-helpers/map-binding-form",-1054265108),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","merge","cljs.spec.alpha/merge",1420080689,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-bindings","fulcro.incubator.spec-helpers/map-bindings",-1470207297),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-special-binding","fulcro.incubator.spec-helpers/map-special-binding",-1666739663)),cljs.spec.alpha.merge_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-bindings","fulcro.incubator.spec-helpers/map-bindings",-1470207297),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-special-binding","fulcro.incubator.spec-helpers/map-special-binding",-1666739663)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-bindings","fulcro.incubator.spec-helpers/map-bindings",-1470207297),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-special-binding","fulcro.incubator.spec-helpers/map-special-binding",-1666739663)], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword("fulcro.incubator.spec-helpers","seq-binding-form","fulcro.incubator.spec-helpers/seq-binding-form",-1922681363),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding-form","fulcro.incubator.spec-helpers/map-binding-form",-1054265108)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"map","map",1371690461)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552),new cljs.core.Keyword("fulcro.incubator.spec-helpers","seq-binding-form","fulcro.incubator.spec-helpers/seq-binding-form",-1922681363),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding-form","fulcro.incubator.spec-helpers/map-binding-form",-1054265108)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552),new cljs.core.Keyword("fulcro.incubator.spec-helpers","seq-binding-form","fulcro.incubator.spec-helpers/seq-binding-form",-1922681363),new cljs.core.Keyword("fulcro.incubator.spec-helpers","map-binding-form","fulcro.incubator.spec-helpers/map-binding-form",-1054265108)], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),new cljs.core.Keyword(null,"varargs","varargs",1030150858),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),new cljs.core.Keyword(null,"varargs","varargs",1030150858),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"varargs","varargs",1030150858)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.Keyword(null,"form","form",-1624062471)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"amp","amp",271690571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"&","&",-2144855648,null)),"null"], null), null),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638)))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-arg-list","fulcro.incubator.spec-helpers/pred-arg-list",-352494720),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sym","sym",-1444860305)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)], null),null))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword("fulcro.incubator.spec-helpers","local-name","fulcro.incubator.spec-helpers/local-name",-1240226552)))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-fn","fulcro.incubator.spec-helpers/anon-fn",-315007685),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475)))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475)))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"bs","bs",1748393559)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,new cljs.core.Symbol(null,"fn","fn",465265323,null),null], null), null),cljs.spec.alpha.maybe_impl.call(null,cljs.core.simple_symbol_QMARK_,new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),null,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475)))], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn","fn",465265323,null)),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","anon-args+body","fulcro.incubator.spec-helpers/anon-args+body",-1920898475))))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-arg-list","fulcro.incubator.spec-helpers/pred-arg-list",-352494720),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-arg-list","fulcro.incubator.spec-helpers/pred-arg-list",-352494720),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,new cljs.core.Symbol(null,"fn","fn",465265323,null),null], null), null),cljs.spec.alpha.maybe_impl.call(null,cljs.core.simple_symbol_QMARK_,new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-arg-list","fulcro.incubator.spec-helpers/pred-arg-list",-352494720),cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn","fn",465265323,null)),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-arg-list","fulcro.incubator.spec-helpers/pred-arg-list",-352494720),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),new cljs.core.Keyword(null,"pred-sym","pred-sym",1132481576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol("cljs.core","complement","cljs.core/complement",-498493640,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","|","fulcro.incubator.spec-helpers/|",1898581508,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","=>","fulcro.incubator.spec-helpers/=>",69768940,null)),"null"], null), null)),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68562#","p1__68562#",1814173086,null)], null),cljs.core.list(new cljs.core.Symbol("clojure.string","ends-with?","clojure.string/ends-with?",-745964149,null),cljs.core.list(new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),new cljs.core.Symbol(null,"p1__68562#","p1__68562#",1814173086,null)),"?"))),new cljs.core.Keyword(null,"gspec","gspec",1282160262),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nilable-gspec","nilable-gspec",-925413839),new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable-gspec","fulcro.incubator.spec-helpers/nilable-gspec",1856652734),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)),new cljs.core.Keyword(null,"spec-key","spec-key",-1928172992),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),new cljs.core.Keyword(null,"list","list",765357683),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"pred-sym","pred-sym",1132481576),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword(null,"spec-key","spec-key",-1928172992),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"list","list",765357683)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol("cljs.core","complement","cljs.core/complement",-498493640,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","|","fulcro.incubator.spec-helpers/|",1898581508,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","=>","fulcro.incubator.spec-helpers/=>",69768940,null)),"null"], null), null)),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68562#","p1__68562#",1814173086,null)], null),cljs.core.list(new cljs.core.Symbol("clojure.string","ends-with?","clojure.string/ends-with?",-745964149,null),cljs.core.list(new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),new cljs.core.Symbol(null,"p1__68562#","p1__68562#",1814173086,null)),"?"))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nilable-gspec","nilable-gspec",-925413839),new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable-gspec","fulcro.incubator.spec-helpers/nilable-gspec",1856652734),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.set_QMARK_,cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol("cljs.core","complement","cljs.core/complement",-498493640,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","|","fulcro.incubator.spec-helpers/|",1898581508,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","=>","fulcro.incubator.spec-helpers/=>",69768940,null)),"null"], null), null)),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("clojure.string","ends-with?","clojure.string/ends-with?",-745964149,null),cljs.core.list(new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),"?"))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol_QMARK_,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"=>","=>",-813269641,null),null,new cljs.core.Symbol(null,"|","|",1288119951,null),null], null), null)),(function (p1__68562_SHARP_){
return clojure.string.ends_with_QMARK_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__68562_SHARP_),"?");
})], null),null),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nilable-gspec","nilable-gspec",-925413839),new cljs.core.Keyword(null,"gspec","gspec",1282160262)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable-gspec","fulcro.incubator.spec-helpers/nilable-gspec",1856652734),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable-gspec","fulcro.incubator.spec-helpers/nilable-gspec",1856652734),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)], null),null),cljs.core.qualified_keyword_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),cljs.core.seq_QMARK_], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"|","|",1288119951,null)),"null",new cljs.core.Keyword(null,"st","st",1455255828),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"|","|",1288119951,null),null,new cljs.core.Keyword(null,"st","st",1455255828),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","ret-op","fulcro.incubator.spec-helpers/ret-op",1198598987),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"=>","=>",-813269641,null)),"null",new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"=>","=>",-813269641,null),null,new cljs.core.Keyword(null,"ret","ret",-468222814),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gen","gen",142575302),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"<-","<-",-1894022771,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gen","gen",142575302),null,new cljs.core.Symbol(null,"<-","<-",-1894022771,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))))),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ret-op","fulcro.incubator.spec-helpers/ret-op",1198598987),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),new cljs.core.Keyword(null,"fn-such-that","fn-such-that",1755729726),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))),new cljs.core.Keyword(null,"gen","gen",142575302),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null))))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))))),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ret-op","fulcro.incubator.spec-helpers/ret-op",1198598987),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),new cljs.core.Keyword(null,"fn-such-that","fn-such-that",1755729726),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))),new cljs.core.Keyword(null,"gen","gen",142575302),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null))))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn-such-that","fn-such-that",1755729726),new cljs.core.Keyword(null,"gen","gen",142575302)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"preds","preds",-1489609750)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))))], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))))),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ret-op","fulcro.incubator.spec-helpers/ret-op",1198598987),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"preds","preds",-1489609750)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738))], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),cljs.spec.alpha.maybe_impl.call(null,cljs.core.some_fn.call(null,cljs.core.seq_QMARK_,cljs.core.symbol_QMARK_),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null)))], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null)))))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)),new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))))),new cljs.core.Keyword("fulcro.incubator.spec-helpers","ret-op","fulcro.incubator.spec-helpers/ret-op",1198598987),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","such-that-op","fulcro.incubator.spec-helpers/such-that-op",2085526135),new cljs.core.Keyword(null,"preds","preds",-1489609750),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","pred-fn","fulcro.incubator.spec-helpers/pred-fn",2006782738)))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gen-op","fulcro.incubator.spec-helpers/gen-op",430195607),new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.core","some-fn","cljs.core/some-fn",-905373668,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null)))))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable-gspec","fulcro.incubator.spec-helpers/nilable-gspec",1856652734),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"maybe","maybe",-314397560),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","?","fulcro.incubator.spec-helpers/?",112177539,null)),"null"], null), null),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"maybe","maybe",-314397560),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","?","fulcro.incubator.spec-helpers/?",112177539,null)),"null"], null), null),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"maybe","maybe",-314397560),new cljs.core.Keyword(null,"gspec","gspec",1282160262)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("s","nilable","s/nilable",-812128520,null),null,new cljs.core.Symbol(null,"?","?",-62633706,null),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("s","nilable","s/nilable",-812128520,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"?","?",-62633706,null)),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pre","pre",2118456869),"null",new cljs.core.Keyword(null,"post","post",269697687),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pre","pre",2118456869),"null",new cljs.core.Keyword(null,"post","post",269697687),"null"], null), null),cljs.core.list(new cljs.core.Symbol("s","coll-of","s/coll-of",-1705285349,null),new cljs.core.Symbol(null,"seq?","seq?",-1951934719,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol(null,"vector?","vector?",-61367869,null),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pre","pre",2118456869),"null",new cljs.core.Keyword(null,"post","post",269697687),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pre","pre",2118456869),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"seq?","seq?",-1951934719,null),cljs.core.seq_QMARK_,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68668){
var and__4120__auto__ = cljs.core.vector_QMARK_.call(null,G__68668);
if(and__4120__auto__){
var or__4131__auto__ = cljs.core.empty_QMARK_.call(null,G__68668);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,G__68668);
}
} else {
return and__4120__auto__;
}
}),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true,new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.vector_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true,new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null))], null),null)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__68665){
return cljs.core.map_QMARK_.call(null,G__68665);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pre","pre",2118456869),"null",new cljs.core.Keyword(null,"post","post",269697687),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),true))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)),cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","&","cljs.spec.alpha/&",1635809823,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"gspec","gspec",1282160262),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.Symbol(null,"arg-specs-match-param-count?","arg-specs-match-param-count?",-1821902262,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null)], null)], null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","if-not","cljs.core/if-not",-1997686824,null),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null),true,cljs.core.list(new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->>","cljs.core/->>",-1207871206,null),new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","count-args","fulcro.incubator.spec-helpers/count-args",163555411,null),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null))),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),cljs.core.list(new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null),(0))))))),cljs.spec.alpha.amp_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"gspec","gspec",1282160262),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353),null),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)),cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"gspec","gspec",1282160262),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"prepost+body","prepost+body",1703890068),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"prepost","prepost",1251610712),new cljs.core.Keyword("fulcro.incubator.spec-helpers","prepost","fulcro.incubator.spec-helpers/prepost",884963033),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function fulcro$incubator$spec_helpers$arg_specs_match_param_count_QMARK_(p__68769){
var map__68770 = p__68769;
var map__68770__$1 = (((((!((map__68770 == null))))?(((((map__68770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68770):map__68770);
var args = cljs.core.get.call(null,map__68770__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var gspec = cljs.core.get.call(null,map__68770__$1,new cljs.core.Keyword(null,"gspec","gspec",1282160262));
if(cljs.core.not(gspec)){
return true;
} else {
var argcount = cljs.core.apply.call(null,cljs.core._PLUS_,fulcro.incubator.spec_helpers.count_args.call(null,args));
var spec_args = new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(gspec);
if(cljs.core.truth_(spec_args)){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(spec_args)),argcount);
} else {
return cljs.core._EQ_.call(null,argcount,(0));
}
}
})], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.Symbol(null,"arg-specs-match-param-count?","arg-specs-match-param-count?",-1821902262,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null)], null)], null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","if-not","cljs.core/if-not",-1997686824,null),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null),true,cljs.core.list(new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->>","cljs.core/->>",-1207871206,null),new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","count-args","fulcro.incubator.spec-helpers/count-args",163555411,null),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null))),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),cljs.core.list(new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol(null,"gspec","gspec",-1372275507,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"spec-args","spec-args",-1253869619,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),new cljs.core.Symbol(null,"argcount","argcount",-1682303943,null),(0))))))], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"args-op","args-op",-2015536609),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),"null"], null), null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180))),new cljs.core.Keyword(null,"fun","fun",-1265158045),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fn-op","fn-op",695589016),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),"null"], null), null),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"args-op","args-op",-2015536609),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),"null"], null), null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180))),new cljs.core.Keyword(null,"fun","fun",-1265158045),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fn-op","fn-op",695589016),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),"null"], null), null),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"args-op","args-op",-2015536609),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fun","fun",-1265158045)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null),null,new cljs.core.Symbol("clojure.spec.alpha","fdef","clojure.spec.alpha/fdef",1635692618,null),null], null), null),cljs.core.symbol_QMARK_,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),null], null), null),cljs.core.seq_QMARK_,cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.Keyword(null,"ret","ret",-468222814)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180))),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fn-op","fn-op",695589016),new cljs.core.Keyword(null,"pred","pred",1927423397)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),null], null), null),cljs.core.seq_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),"null"], null), null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fn-op","fn-op",695589016),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),"null"], null), null),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("clojure.spec.alpha","fdef","clojure.spec.alpha/fdef",1635692618,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),"null"], null), null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"ret-op","ret-op",26616262),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ret","ret",-468222814),"null"], null), null),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fn-op","fn-op",695589016),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),"null"], null), null),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","defn","fulcro.incubator.spec-helpers/defn",-602944332),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","defn-","cljs.core/defn-",1764521227,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"docstring","docstring",879233117),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624))),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","defn","cljs.core/defn",-1606493717,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","defn-","cljs.core/defn-",1764521227,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"docstring","docstring",879233117),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624))),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"docstring","docstring",879233117),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"bs","bs",1748393559)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"defn","defn",-126010802,null),null,new cljs.core.Symbol(null,"defn-","defn-",1097765044,null),null], null), null),cljs.core.simple_symbol_QMARK_,cljs.spec.alpha.maybe_impl.call(null,cljs.core.string_QMARK_,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),cljs.spec.alpha.maybe_impl.call(null,cljs.core.map_QMARK_,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bodies","bodies",-1295887172),new cljs.core.Keyword(null,"attr","attr",-604132353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),null,null)),cljs.spec.alpha.maybe_impl.call(null,cljs.core.map_QMARK_,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624))),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)))], null))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"defn","defn",-126010802,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"defn-","defn-",1097765044,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"bodies","bodies",-1295887172),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+body","fulcro.incubator.spec-helpers/args+body",-1401442624))),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.test","deftest","cljs.test/deftest",-271367143,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.test","deftest","cljs.test/deftest",-271367143,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.test","deftest","cljs.test/deftest",-271367143,null),null,new cljs.core.Symbol("clojure.test","deftest","clojure.test/deftest",-437170741,null),null], null), null),cljs.core.symbol_QMARK_,cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.test","deftest","cljs.test/deftest",-271367143,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("clojure.test","deftest","clojure.test/deftest",-437170741,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"do","do",46310725),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"do","do",1686842252,null)),"null"], null), null),new cljs.core.Keyword(null,"defn","defn",-1766542329),new cljs.core.Keyword("fulcro.incubator.spec-helpers","defn","fulcro.incubator.spec-helpers/defn",-602944332),new cljs.core.Keyword(null,"fdef","fdef",-1180812168),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933)),new cljs.core.Keyword(null,"deftest","deftest",-702282712),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653)))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"do","do",46310725),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"do","do",1686842252,null)),"null"], null), null),new cljs.core.Keyword(null,"defn","defn",-1766542329),new cljs.core.Keyword("fulcro.incubator.spec-helpers","defn","fulcro.incubator.spec-helpers/defn",-602944332),new cljs.core.Keyword(null,"fdef","fdef",-1180812168),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933)),new cljs.core.Keyword(null,"deftest","deftest",-702282712),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"do","do",46310725),new cljs.core.Keyword(null,"defn","defn",-1766542329),new cljs.core.Keyword(null,"fdef","fdef",-1180812168),new cljs.core.Keyword(null,"deftest","deftest",-702282712)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"do","do",1686842252,null),null], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","defn","fulcro.incubator.spec-helpers/defn",-602944332),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),null),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653),new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653),null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"do","do",1686842252,null)),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","defn","fulcro.incubator.spec-helpers/defn",-602944332),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","deftest","fulcro.incubator.spec-helpers/deftest",-1414980653))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*as->","*as->",1583021072,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*some->>","*some->>",-54074160,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*cond->","*cond->",2142572517,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"->>","->>",-1874332161,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*cond->>","*cond->>",-377155425,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"cond->>","cond->>",348844960,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"some->>","some->>",-1499987794,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"some->","some->",-1011172200,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*->>","*->>",309247818,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*->","*->",1332248959,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"cond->","cond->",561741875,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"->","->",-2139605430,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"as->","as->",1430690540,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"*some->","*some->",-418200066,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Symbol(null,"*as->","*as->",1583021072,null),null,new cljs.core.Symbol(null,"*some->>","*some->>",-54074160,null),null,new cljs.core.Symbol(null,"*cond->","*cond->",2142572517,null),null,new cljs.core.Symbol(null,"->>","->>",-1874332161,null),null,new cljs.core.Symbol(null,"*cond->>","*cond->>",-377155425,null),null,new cljs.core.Symbol(null,"cond->>","cond->>",348844960,null),null,new cljs.core.Symbol(null,"some->>","some->>",-1499987794,null),null,new cljs.core.Symbol(null,"some->","some->",-1011172200,null),null,new cljs.core.Symbol(null,"*->>","*->>",309247818,null),null,new cljs.core.Symbol(null,"*->","*->",1332248959,null),null,new cljs.core.Symbol(null,"cond->","cond->",561741875,null),null,new cljs.core.Symbol(null,"->","->",-2139605430,null),null,new cljs.core.Symbol(null,"as->","as->",1430690540,null),null,new cljs.core.Symbol(null,"*some->","*some->",-418200066,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"doseq","doseq",221164135,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"for","for",316745208,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"let","let",358118826,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"binding","binding",-2114503176,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"doseq","doseq",221164135,null),null,new cljs.core.Symbol(null,"for","for",316745208,null),null,new cljs.core.Symbol(null,"let","let",358118826,null),null,new cljs.core.Symbol(null,"binding","binding",-2114503176,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fnil","fnil",-187395162,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"partial","partial",1881673272,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fnil","fnil",-187395162,null),null,new cljs.core.Symbol(null,"partial","partial",1881673272,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"complement","complement",-913606051,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"memoize","memoize",2019341169,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"complement","complement",-913606051,null),null,new cljs.core.Symbol(null,"memoize","memoize",2019341169,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"comp","comp",-1462482139,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"some-fn","some-fn",-490044165,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"juxt","juxt",671085604,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"every-pred","every-pred",-1346958247,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"some-fn","some-fn",-490044165,null),null,new cljs.core.Symbol(null,"juxt","juxt",671085604,null),null,new cljs.core.Symbol(null,"every-pred","every-pred",-1346958247,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fmap","fmap",55293788,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"apply","apply",-1334050276,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"map","map",-1282745308,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"reduce","reduce",1358839360,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"map-indexed","map-indexed",-1391025435,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"fmap","fmap",55293788,null),null,new cljs.core.Symbol(null,"apply","apply",-1334050276,null),null,new cljs.core.Symbol(null,"map","map",-1282745308,null),null,new cljs.core.Symbol(null,"reduce","reduce",1358839360,null),null,new cljs.core.Symbol(null,"map-indexed","map-indexed",-1391025435,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"reduce-kv","reduce-kv",1856296400,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"sort-by","sort-by",1317932224,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"drop-while","drop-while",719206685,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"take-while","take-while",2007268328,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"sort","sort",-1700969851,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"keep","keep",-492807003,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"group-by","group-by",1261391725,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"keep-indexed","keep-indexed",-2020916352,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"mapv","mapv",-241595241,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"iterate","iterate",694501410,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"mapcat","mapcat",-601348859,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"filterv","filterv",1977739179,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"reductions","reductions",549963952,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"sorted-map-by","sorted-map-by",218894812,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"filter","filter",691993593,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"merge-with","merge-with",1025434534,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"remove","remove",1509103113,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Symbol(null,"reduce-kv","reduce-kv",1856296400,null),null,new cljs.core.Symbol(null,"sort-by","sort-by",1317932224,null),null,new cljs.core.Symbol(null,"drop-while","drop-while",719206685,null),null,new cljs.core.Symbol(null,"take-while","take-while",2007268328,null),null,new cljs.core.Symbol(null,"sort","sort",-1700969851,null),null,new cljs.core.Symbol(null,"keep","keep",-492807003,null),null,new cljs.core.Symbol(null,"group-by","group-by",1261391725,null),null,new cljs.core.Symbol(null,"keep-indexed","keep-indexed",-2020916352,null),null,new cljs.core.Symbol(null,"mapv","mapv",-241595241,null),null,new cljs.core.Symbol(null,"iterate","iterate",694501410,null),null,new cljs.core.Symbol(null,"mapcat","mapcat",-601348859,null),null,new cljs.core.Symbol(null,"filterv","filterv",1977739179,null),null,new cljs.core.Symbol(null,"reductions","reductions",549963952,null),null,new cljs.core.Symbol(null,"sorted-map-by","sorted-map-by",218894812,null),null,new cljs.core.Symbol(null,"filter","filter",691993593,null),null,new cljs.core.Symbol(null,"merge-with","merge-with",1025434534,null),null,new cljs.core.Symbol(null,"remove","remove",1509103113,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"do","do",1686842252,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"doseq","doseq",221164135,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"dotimes","dotimes",-818708397,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"do","do",1686842252,null),null,new cljs.core.Symbol(null,"doseq","doseq",221164135,null),null,new cljs.core.Symbol(null,"dotimes","dotimes",-818708397,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-call","fulcro.incubator.spec-helpers/unsafe-clj-call",-175367509),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"dispatch","dispatch",-1335098760,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"js-delete","js-delete",170306730,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"aset","aset",900773178,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"dorun","dorun",560426022,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"repeatedly","repeatedly",1199964457,null)),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"dispatch","dispatch",-1335098760,null),null,new cljs.core.Symbol(null,"js-delete","js-delete",170306730,null),null,new cljs.core.Symbol(null,"aset","aset",900773178,null),null,new cljs.core.Symbol(null,"dorun","dorun",560426022,null),null,new cljs.core.Symbol(null,"repeatedly","repeatedly",1199964457,null),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"single-fn","single-fn",-1461539472),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"composition","composition",1834198617),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301)),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"multi-fn","multi-fn",-1122370209),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"composition","composition",1834198617),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855)),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"single-fn","single-fn",-1461539472),new cljs.core.Keyword(null,"multi-fn","multi-fn",-1122370209)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"composition","composition",1834198617),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"safe","safe",-125058214)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301)], null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"composition","composition",1834198617),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"safe","safe",-125058214)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855)], null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"composition","composition",1834198617),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","single-function-composition","fulcro.incubator.spec-helpers/single-function-composition",-1070122549),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-single-function-composition","fulcro.incubator.spec-helpers/safe-single-function-composition",1144153301)),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"composition","composition",1834198617),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","multi-function-composition","fulcro.incubator.spec-helpers/multi-function-composition",-1038712744),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-multi-function-composition","fulcro.incubator.spec-helpers/safe-multi-function-composition",938555855)),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))], null)));
var bang_suffix_QMARK__70203 = (function (p1__68902_SHARP_){
return clojure.string.ends_with_QMARK_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__68902_SHARP_),"!");
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","bang-suffix","fulcro.incubator.spec-helpers/bang-suffix",-1772829126),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),cljs.core.every_pred.call(null,cljs.core.symbol_QMARK_,bang_suffix_QMARK__70203));

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"bang-suffix","bang-suffix",-706224947),new cljs.core.Keyword("fulcro.incubator.spec-helpers","bang-suffix","fulcro.incubator.spec-helpers/bang-suffix",-1772829126),new cljs.core.Keyword(null,"unsafe-anon-fn","unsafe-anon-fn",-13864978),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"unsafe-body","unsafe-body",8389259),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)),new cljs.core.Keyword(null,"unsafe-name","unsafe-name",1150744053),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))),new cljs.core.Keyword(null,"unsafe-clj-call","unsafe-clj-call",-1408826574),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-call","fulcro.incubator.spec-helpers/unsafe-clj-call",-175367509),new cljs.core.Keyword(null,"unsafe-clj-comp","unsafe-clj-comp",-176805153),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)),new cljs.core.Keyword(null,"unsafe-bound-call","unsafe-bound-call",572215860),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__68903#","p1__68903#",1990813292,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","*unsafe-bound-ops*","fulcro.incubator.spec-helpers/*unsafe-bound-ops*",2144395137,null),new cljs.core.Symbol(null,"p1__68903#","p1__68903#",1990813292,null))),new cljs.core.Keyword(null,"multi-form-op","multi-form-op",1344024909),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-let","cljs.core/when-let",-2049838349,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-some","cljs.core/when-some",1033431610,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-first","cljs.core/when-first",-667185267,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-not","cljs.core/when-not",-556141047,null)),"null"], null), null),new cljs.core.Keyword(null,"pred-or-bindings","pred-or-bindings",-1496416130),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"fx","fx",-1237829572),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bang-suffix","bang-suffix",-706224947),new cljs.core.Keyword(null,"unsafe-anon-fn","unsafe-anon-fn",-13864978),new cljs.core.Keyword(null,"unsafe-clj-call","unsafe-clj-call",-1408826574),new cljs.core.Keyword(null,"unsafe-clj-comp","unsafe-clj-comp",-176805153),new cljs.core.Keyword(null,"unsafe-bound-call","unsafe-bound-call",572215860),new cljs.core.Keyword(null,"multi-form-op","multi-form-op",1344024909)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","bang-suffix","fulcro.incubator.spec-helpers/bang-suffix",-1772829126),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"unsafe-body","unsafe-body",8389259),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)),new cljs.core.Keyword(null,"unsafe-name","unsafe-name",1150744053),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"unsafe-body","unsafe-body",8389259),new cljs.core.Keyword(null,"unsafe-name","unsafe-name",1150744053)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,new cljs.core.Symbol(null,"fn","fn",465265323,null),null], null), null),cljs.spec.alpha.maybe_impl.call(null,cljs.core.simple_symbol_QMARK_,new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn","fn",465265323,null)),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)], null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,new cljs.core.Symbol(null,"fn","fn",465265323,null),null], null), null),cljs.core.every_pred.call(null,cljs.core.simple_symbol_QMARK_,bang_suffix_QMARK__70203),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn","fn",465265323,null)),"null"], null), null),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null))], null),null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-call","fulcro.incubator.spec-helpers/unsafe-clj-call",-175367509),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262),null,null),((function (bang_suffix_QMARK__70203){
return (function (p1__68903_SHARP_){
return cljs.core.contains_QMARK_.call(null,fulcro.incubator.spec_helpers._STAR_unsafe_bound_ops_STAR_,p1__68903_SHARP_);
});})(bang_suffix_QMARK__70203))
,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"pred-or-bindings","pred-or-bindings",-1496416130),new cljs.core.Keyword(null,"fx","fx",-1237829572),new cljs.core.Keyword(null,"return","return",-1891502105)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Symbol(null,"when-first","when-first",821699168,null),null,new cljs.core.Symbol(null,"when-not","when-not",-1223136340,null),null,new cljs.core.Symbol(null,"when","when",1064114221,null),null,new cljs.core.Symbol(null,"when-some","when-some",1700415903,null),null,new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),null,new cljs.core.Symbol(null,"let","let",358118826,null),null,new cljs.core.Symbol(null,"binding","binding",-2114503176,null),null], null), null),cljs.core.any_QMARK_,cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_),cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"when-first","when-first",821699168,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"when-not","when-not",-1223136340,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"when","when",1064114221,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"when-some","when-some",1700415903,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"let","let",358118826,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"binding","binding",-2114503176,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","bang-suffix","fulcro.incubator.spec-helpers/bang-suffix",-1772829126),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"unsafe-body","unsafe-body",8389259),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005)),new cljs.core.Keyword(null,"unsafe-name","unsafe-name",1150744053),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"fn*","fn*",-752876845,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),"null"], null), null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.core","every-pred","cljs.core/every-pred",1081452798,null),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Symbol(null,"bang-suffix?","bang-suffix?",-1283080164,null)),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers","arg-list","fulcro.incubator.spec-helpers/arg-list",-865301278),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)))),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-call","fulcro.incubator.spec-helpers/unsafe-clj-call",-175367509),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol("fulcro.incubator.spec-helpers","*unsafe-bound-ops*","fulcro.incubator.spec-helpers/*unsafe-bound-ops*",2144395137,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-let","cljs.core/when-let",-2049838349,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-some","cljs.core/when-some",1033431610,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-first","cljs.core/when-first",-667185267,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","when-not","cljs.core/when-not",-556141047,null)),"null"], null), null),new cljs.core.Keyword(null,"pred-or-bindings","pred-or-bindings",-1496416130),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"fx","fx",-1237829572),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","valid?","cljs.spec.alpha/valid?",-142132235,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),cljs.core.list(new cljs.core.Symbol("cljs.core","list","cljs.core/list",-1331406371,null),new cljs.core.Symbol(null,"%","%",-950237169,null))))),(function (p1__69024_SHARP_){
return (!(cljs.spec.alpha.valid_QMARK_.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),(new cljs.core.List(null,p1__69024_SHARP_,null,(1),null)))));
}));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"skipped-ops","skipped-ops",169829810),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822))),cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"skipped-ops","skipped-ops",169829810),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"skipped-ops","skipped-ops",169829810),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822)], null))));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"skipped-bindings","skipped-bindings",1607538132),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851))),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"skipped-bindings","skipped-bindings",1607538132),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851))),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"skipped-bindings","skipped-bindings",1607538132),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851))),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"skipped-bindings","skipped-bindings",1607538132),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.rep_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"value","value",305978217)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851)], null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"value","value",305978217)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822))], null)))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-form","fulcro.incubator.spec-helpers/unsafe-form",908078005),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"unsafe-block","unsafe-block",76367673),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"unsafe-clj-block","unsafe-clj-block",-935817213),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))),new cljs.core.Keyword(null,"unsafe-call","unsafe-call",-1482953262),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"direct","direct",-1775717856),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"application","application",551185447),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"threading","threading",1396900726),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"threading-macro-op","threading-macro-op",1907853940),new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.Keyword(null,"threaded-form","threaded-form",-358975981),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"update","update",1045576396),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update","cljs.core/update",-908565906,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update-in","cljs.core/update-in",-2120854498,null)),"null"], null), null),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)))),new cljs.core.Keyword(null,"unsafe-composition","unsafe-composition",1351794059),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding-op","binding-op",716913917),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))),new cljs.core.Keyword(null,"unsafe-argument","unsafe-argument",1281466596),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)))),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"unsafe-block","unsafe-block",76367673),new cljs.core.Keyword(null,"unsafe-call","unsafe-call",-1482953262),new cljs.core.Keyword(null,"unsafe-composition","unsafe-composition",1351794059),new cljs.core.Keyword(null,"unsafe-binding","unsafe-binding",-196739510),new cljs.core.Keyword(null,"unsafe-argument","unsafe-argument",1281466596)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"unsafe-clj-block","unsafe-clj-block",-935817213),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"direct","direct",-1775717856),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"application","application",551185447),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"threading","threading",1396900726),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"threading-macro-op","threading-macro-op",1907853940),new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.Keyword(null,"threaded-form","threaded-form",-358975981),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"update","update",1045576396),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update","cljs.core/update",-908565906,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update-in","cljs.core/update-in",-2120854498,null)),"null"], null), null),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding-op","binding-op",716913917),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)))], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"unsafe-clj-block","unsafe-clj-block",-935817213),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"unsafe-clj-block","unsafe-clj-block",-935817213),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-block","fulcro.incubator.spec-helpers/unsafe-clj-block",-1294178122),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null))], null),null),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"direct","direct",-1775717856),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"application","application",551185447),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"threading","threading",1396900726),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"threading-macro-op","threading-macro-op",1907853940),new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.Keyword(null,"threaded-form","threaded-form",-358975981),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),new cljs.core.Keyword(null,"update","update",1045576396),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update","cljs.core/update",-908565906,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update-in","cljs.core/update-in",-2120854498,null)),"null"], null), null),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"direct","direct",-1775717856),new cljs.core.Keyword(null,"threading","threading",1396900726),new cljs.core.Keyword(null,"update","update",1045576396)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"application","application",551185447),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword(null,"safe","safe",-125058214)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"threading-macro-op","threading-macro-op",1907853940),new cljs.core.Keyword(null,"threaded-form","threaded-form",-358975981),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),cljs.core.any_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"update-in","update-in",-1445516941,null),null,new cljs.core.Symbol(null,"update","update",-1608859373,null),null], null), null),cljs.core.any_QMARK_,cljs.core.any_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"update-in","update-in",-1445516941,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"update","update",-1608859373,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"application","application",551185447),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"generic","generic",-1245036524),new cljs.core.Keyword("fulcro.incubator.spec-helpers","function-application","fulcro.incubator.spec-helpers/function-application",-1337527632),new cljs.core.Keyword(null,"safe","safe",-125058214),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-function-application","fulcro.incubator.spec-helpers/safe-function-application",-461861551))),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"threading-macro-op","threading-macro-op",1907853940),new cljs.core.Keyword("fulcro.incubator.spec-helpers","threading-macro-op","fulcro.incubator.spec-helpers/threading-macro-op",877814271),new cljs.core.Keyword(null,"threaded-form","threaded-form",-358975981),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update","cljs.core/update",-908565906,null)),"null",cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("cljs.core","update-in","cljs.core/update-in",-2120854498,null)),"null"], null), null),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"unsafe-op","unsafe-op",1938139865),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-op","fulcro.incubator.spec-helpers/unsafe-op",1029214822),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))], null))], null),null),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","unsafe-clj-comp","fulcro.incubator.spec-helpers/unsafe-clj-comp",-1160591262)], null),null),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"binding-op","binding-op",716913917),new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"binding-op","binding-op",716913917),new cljs.core.Keyword(null,"bindings","bindings",1271397192),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-op","fulcro.incubator.spec-helpers/binding-op",1764124036),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-bindings","fulcro.incubator.spec-helpers/some-unsafe-bindings",-596491003),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null))], null),null),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword(null,"rest","rest",-1241696419),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"some-unsafe-ops","some-unsafe-ops",628056639),new cljs.core.Keyword(null,"rest","rest",-1241696419)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","safe-op","fulcro.incubator.spec-helpers/safe-op",126075851),new cljs.core.Keyword("fulcro.incubator.spec-helpers","some-unsafe-ops","fulcro.incubator.spec-helpers/some-unsafe-ops",1624533686),new cljs.core.Keyword("fulcro.incubator.spec-helpers","rest","fulcro.incubator.spec-helpers/rest",-404746550)], null))], null),null)], null),null));
/**
 * Half-arsed workaround for spec bugs CLJ-2003 and CLJ-2021.
 */
fulcro.incubator.spec_helpers.unscrew_vec_unform = (function fulcro$incubator$spec_helpers$unscrew_vec_unform(unformed_arg){
if((!(cljs.core.sequential_QMARK_.call(null,unformed_arg)))){
return unformed_arg;
} else {
var malformed_seq_destructuring_QMARK_ = cljs.core.every_pred.call(null,cljs.core.seq_QMARK_,cljs.core.comp.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null,new cljs.core.Keyword(null,"as","as",1148689641),null], null), null),cljs.core.first));
var vec__69138 = cljs.core.split_with.call(null,cljs.core.complement.call(null,malformed_seq_destructuring_QMARK_),unformed_arg);
var unformed = cljs.core.nth.call(null,vec__69138,(0),null);
var malformed = cljs.core.nth.call(null,vec__69138,(1),null);
return cljs.core.vec.call(null,cljs.core.concat.call(null,unformed,cljs.core.apply.call(null,cljs.core.concat,malformed)));
}
});
fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_ = (function fulcro$incubator$spec_helpers$gspec__GT_fspec_STAR_(conformed_arg_list,conformed_gspec,anon_fspec_QMARK_,multi_arity_args_QMARK_,nilable_QMARK_){
var map__69165 = conformed_gspec;
var map__69165__$1 = (((((!((map__69165 == null))))?(((((map__69165.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69165.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69165):map__69165);
var argspec_def = cljs.core.get.call(null,map__69165__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var retspec = cljs.core.get.call(null,map__69165__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var fn_such_that = cljs.core.get.call(null,map__69165__$1,new cljs.core.Keyword(null,"fn-such-that","fn-such-that",1755729726));
var map__69166 = cljs.core.get.call(null,map__69165__$1,new cljs.core.Keyword(null,"gen","gen",142575302));
var map__69166__$1 = (((((!((map__69166 == null))))?(((((map__69166.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69166.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69166):map__69166);
var gen = map__69166__$1;
var gen_fn = cljs.core.get.call(null,map__69166__$1,new cljs.core.Keyword(null,"gen-fn","gen-fn",1212304428));
if(cljs.core.truth_((function (){var and__4120__auto__ = anon_fspec_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = argspec_def;
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = cljs.core.not(gen);
if(and__4120__auto____$2){
return cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"any?","any?",-318999933,null),null], null), null),cljs.core.vals.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(argspec_def)));
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
if(cljs.core.truth_(nilable_QMARK_)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null),null,(1),null)))));
} else {
return new cljs.core.Symbol("cljs.core","ifn?","cljs.core/ifn?",1573873861,null);
}
} else {
var extract_spec = ((function (map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function fulcro$incubator$spec_helpers$gspec__GT_fspec_STAR__$_extract_spec(p__69182){
var vec__69185 = p__69182;
var spec_type = cljs.core.nth.call(null,vec__69185,(0),null);
var spec = cljs.core.nth.call(null,vec__69185,(1),null);
if(cljs.core._EQ_.call(null,spec_type,new cljs.core.Keyword(null,"gspec","gspec",1282160262))){
if(cljs.core._EQ_.call(null,cljs.core.key.call(null,spec),new cljs.core.Keyword(null,"nilable-gspec","nilable-gspec",-925413839))){
return fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_.call(null,null,new cljs.core.Keyword(null,"gspec","gspec",1282160262).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)),true,false,true);
} else {
return fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_.call(null,null,cljs.core.val.call(null,spec),true,false,false);
}
} else {
return spec;
}
});})(map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
;
var named_conformed_args = (cljs.core.truth_(argspec_def)?(function (){var all_args = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.concat.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(conformed_arg_list),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"varargs","varargs",1030150858).cljs$core$IFn$_invoke$arity$1(conformed_arg_list))], null)));
var gen_arg_name = ((function (all_args,extract_spec,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function (index){
return ["arg",cljs.core.str.cljs$core$IFn$_invoke$arity$1((index + (1)))].join('');
});})(all_args,extract_spec,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
;
var gen_name = ((function (all_args,gen_arg_name,extract_spec,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function (index,p__69197){
var vec__69201 = p__69197;
var arg_type = cljs.core.nth.call(null,vec__69201,(0),null);
var arg = cljs.core.nth.call(null,vec__69201,(1),null);
var full_arg = vec__69201;
var arg_name = ((cljs.core.not(arg_type))?gen_arg_name(index):(function (){var G__69206 = arg_type;
var G__69206__$1 = (((G__69206 instanceof cljs.core.Keyword))?G__69206.fqn:null);
switch (G__69206__$1) {
case "sym":
return arg;

break;
case "seq":
var or__4131__auto__ = new cljs.core.Keyword(null,"sym","sym",-1444860305).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return gen_arg_name(index);
}

break;
case "map":
var or__4131__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return gen_arg_name(index);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69206__$1)].join('')));

}
})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,arg_name),full_arg], null);
});})(all_args,gen_arg_name,extract_spec,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
;
return cljs.core.map_indexed.call(null,gen_name,(function (){var or__4131__auto__ = cljs.core.seq.call(null,all_args);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.repeat.call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(argspec_def)),null);
}
})());
})():null);
var arg_binding_map = ((cljs.core.not(conformed_arg_list))?cljs.core.PersistentArrayMap.EMPTY:((cljs.core.every_QMARK_.call(null,((function (extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function (p1__69146_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.key.call(null,cljs.core.second.call(null,p1__69146_SHARP_)),new cljs.core.Keyword(null,"sym","sym",-1444860305));
});})(extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
,named_conformed_args))?cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"keys","keys",1068423698),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.map.call(null,((function (extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function (p1__69148_SHARP_){
return cljs.core.symbol.call(null,cljs.core.name.call(null,cljs.core.first.call(null,p1__69148_SHARP_)));
});})(extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
,named_conformed_args)),null,(1),null)))))):cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function (p__69226){
var vec__69227 = p__69226;
var arg_key = cljs.core.nth.call(null,vec__69227,(0),null);
var conformed_arg = cljs.core.nth.call(null,vec__69227,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.spec_helpers.unscrew_vec_unform.call(null,cljs.spec.alpha.unform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),conformed_arg)),arg_key], null);
});})(extract_spec,named_conformed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
,named_conformed_args))));
var process_arg_pred = ((function (extract_spec,named_conformed_args,arg_binding_map,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function fulcro$incubator$spec_helpers$gspec__GT_fspec_STAR__$_process_arg_pred(p__69232){
var map__69237 = p__69232;
var map__69237__$1 = (((((!((map__69237 == null))))?(((((map__69237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69237):map__69237);
var name = cljs.core.get.call(null,map__69237__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var args = cljs.core.get.call(null,map__69237__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var body = cljs.core.get.call(null,map__69237__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = (function (){var temp__5718__auto__ = (function (){var G__69245 = args;
var G__69245__$1 = (((G__69245 == null))?null:new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(G__69245));
var G__69245__$2 = (((G__69245__$1 == null))?null:cljs.core.first.call(null,G__69245__$1));
if((G__69245__$2 == null)){
return null;
} else {
return cljs.core.second.call(null,G__69245__$2);
}
})();
if(cljs.core.truth_(temp__5718__auto__)){
var anon_arg = temp__5718__auto__;
return cljs.core.assoc.call(null,arg_binding_map,new cljs.core.Keyword(null,"as","as",1148689641),anon_arg);
} else {
return arg_binding_map;
}
})();
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,bindings,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,body,null,(1),null))))));
});})(extract_spec,named_conformed_args,arg_binding_map,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
;
var processed_args = ((cljs.core.not(argspec_def))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),null,(1),null))))):(function (){var wrapped_params = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),cljs.core.interleave.call(null,cljs.core.map.call(null,cljs.core.first,named_conformed_args),cljs.core.map.call(null,extract_spec,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(argspec_def))));
var temp__5718__auto__ = new cljs.core.Keyword(null,"args-such-that","args-such-that",1913142965).cljs$core$IFn$_invoke$arity$1(argspec_def);
if(cljs.core.truth_(temp__5718__auto__)){
var args_such_that = temp__5718__auto__;
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),wrapped_params,cljs.core.map.call(null,process_arg_pred,new cljs.core.Keyword(null,"preds","preds",-1489609750).cljs$core$IFn$_invoke$arity$1(args_such_that)));
} else {
return wrapped_params;
}
})());
var process_ret_pred = ((function (extract_spec,named_conformed_args,arg_binding_map,process_arg_pred,processed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn){
return (function fulcro$incubator$spec_helpers$gspec__GT_fspec_STAR__$_process_ret_pred(p__69264){
var map__69267 = p__69264;
var map__69267__$1 = (((((!((map__69267 == null))))?(((((map__69267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69267):map__69267);
var name = cljs.core.get.call(null,map__69267__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var args = cljs.core.get.call(null,map__69267__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var body = cljs.core.get.call(null,map__69267__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var anon_arg = (function (){var G__69270 = args;
var G__69270__$1 = (((G__69270 == null))?null:new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(G__69270));
var G__69270__$2 = (((G__69270__$1 == null))?null:cljs.core.first.call(null,G__69270__$1));
if((G__69270__$2 == null)){
return null;
} else {
return cljs.core.second.call(null,G__69270__$2);
}
})();
var ret_sym = cljs.core.gensym.call(null,"ret__");
var bindings = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([(cljs.core.truth_(multi_arity_args_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),arg_binding_map], null):arg_binding_map),new cljs.core.Keyword(null,"args","args",1315556576),ret_sym,new cljs.core.Keyword(null,"ret","ret",-468222814)])], null);
var processed_body = (cljs.core.truth_(anon_arg)?clojure.walk.postwalk_replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([anon_arg,ret_sym]),body):body);
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)),(new cljs.core.List(null,bindings,null,(1),null)),(new cljs.core.List(null,processed_body,null,(1),null))))));
});})(extract_spec,named_conformed_args,arg_binding_map,process_arg_pred,processed_args,map__69165,map__69165__$1,argspec_def,retspec,fn_such_that,map__69166,map__69166__$1,gen,gen_fn))
;
var fn_spec = (cljs.core.truth_(fn_such_that)?(function (){var processed_ret_preds = cljs.core.map.call(null,process_ret_pred,new cljs.core.Keyword(null,"preds","preds",-1489609750).cljs$core$IFn$_invoke$arity$1(fn_such_that));
if(cljs.core.next.call(null,processed_ret_preds)){
return cljs.core.cons.call(null,new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),processed_ret_preds);
} else {
return cljs.core.first.call(null,processed_ret_preds);
}
})():null);
var final_fspec = cljs.core.concat.call(null,(cljs.core.truth_(anon_fspec_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),processed_args], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ret","ret",-468222814),extract_spec(retspec)], null),(cljs.core.truth_(fn_spec)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fn","fn",-1175266204),fn_spec], null):null),(cljs.core.truth_(gen_fn)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen","gen",142575302),gen_fn], null):null));
if(cljs.core.truth_(nilable_QMARK_)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),null,(1),null)),(new cljs.core.List(null,final_fspec,null,(1),null)))));
} else {
return final_fspec;
}
}
});
var get_fspecs_70493 = (function (fn_body){
var vec__69306 = fulcro.incubator.spec_helpers.count_args.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(fn_body));
var param_count = cljs.core.nth.call(null,vec__69306,(0),null);
var variadic = cljs.core.nth.call(null,vec__69306,(1),null);
var gspec = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"gspec","gspec",1282160262).cljs$core$IFn$_invoke$arity$1(fn_body);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.spec.alpha.conform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","gspec","fulcro.incubator.spec-helpers/gspec",-272036353),cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.repeat.call(null,param_count,new cljs.core.Symbol(null,"any?","any?",-318999933,null)),(((variadic > (0)))?cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,(1),null))))),null,(1),null)))))):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"=>","=>",-813269641,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null)], null))));
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,["arity-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((variadic > (0)))?"n":param_count))].join('')),fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(fn_body),gspec,false,true,false)], null);
});
var get_spec_part_70494 = ((function (get_fspecs_70493){
return (function (part,spec){
return cljs.core.second.call(null,cljs.core.drop_while.call(null,cljs.core.complement.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([part])),spec));
});})(get_fspecs_70493))
;
fulcro.incubator.spec_helpers.generate_fspec_body = ((function (get_fspecs_70493,get_spec_part_70494){
return (function fulcro$incubator$spec_helpers$generate_fspec_body(fn_bodies){
var G__69323 = cljs.core.key.call(null,fn_bodies);
var G__69323__$1 = (((G__69323 instanceof cljs.core.Keyword))?G__69323.fqn:null);
switch (G__69323__$1) {
case "arity-1":
var temp__5720__auto__ = new cljs.core.Keyword(null,"gspec","gspec",1282160262).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,fn_bodies));
if(cljs.core.truth_(temp__5720__auto__)){
var gspec = temp__5720__auto__;
return fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,fn_bodies)),gspec,false,false,false);
} else {
return null;
}

break;
case "arity-n":
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.Keyword(null,"gspec","gspec",1282160262),cljs.core.val.call(null,fn_bodies)))){
var fspecs = cljs.core.map.call(null,get_fspecs_70493,cljs.core.val.call(null,fn_bodies));
var arg_specs = cljs.core.mapcat.call(null,((function (fspecs,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494){
return (function (p__69334){
var vec__69335 = p__69334;
var arity = cljs.core.nth.call(null,vec__69335,(0),null);
var spec = cljs.core.nth.call(null,vec__69335,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arity,(function (){var or__4131__auto__ = get_spec_part_70494(new cljs.core.Keyword(null,"args","args",1315556576),spec);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Symbol("cljs.core","empty?","cljs.core/empty?",1866613644,null);
}
})()], null);
});})(fspecs,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494))
,fspecs);
var fn_param = cljs.core.gensym.call(null,"p1__");
var multi_ret_specs = ((cljs.core.not_EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.distinct.call(null,cljs.core.map.call(null,((function (fspecs,arg_specs,fn_param,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494){
return (function (p1__69293_SHARP_){
return get_spec_part_70494(new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.second.call(null,p1__69293_SHARP_));
});})(fspecs,arg_specs,fn_param,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494))
,fspecs)))))?cljs.core.mapcat.call(null,((function (fspecs,arg_specs,fn_param,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494){
return (function (p__69348){
var vec__69349 = p__69348;
var arity = cljs.core.nth.call(null,vec__69349,(0),null);
var spec = cljs.core.nth.call(null,vec__69349,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arity,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","valid?","cljs.spec.alpha/valid?",-142132235,null),null,(1),null)),(new cljs.core.List(null,get_spec_part_70494(new cljs.core.Keyword(null,"ret","ret",-468222814),spec),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"ret","ret",-468222814),null,(1),null)),(new cljs.core.List(null,fn_param,null,(1),null))))),null,(1),null)))))], null);
});})(fspecs,arg_specs,fn_param,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494))
,fspecs):null);
var get_fn_clause = cljs.core.partial.call(null,get_spec_part_70494,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var fn_specs = (cljs.core.truth_(cljs.core.some.call(null,get_fn_clause,cljs.core.map.call(null,cljs.core.second,fspecs)))?cljs.core.mapcat.call(null,((function (fspecs,arg_specs,fn_param,multi_ret_specs,get_fn_clause,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494){
return (function (p__69358){
var vec__69364 = p__69358;
var arity = cljs.core.nth.call(null,vec__69364,(0),null);
var spec = cljs.core.nth.call(null,vec__69364,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arity,(function (){var temp__5718__auto__ = get_fn_clause(spec);
if(cljs.core.truth_(temp__5718__auto__)){
var fn_spec = temp__5718__auto__;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","valid?","cljs.spec.alpha/valid?",-142132235,null),null,(1),null)),(new cljs.core.List(null,fn_spec,null,(1),null)),(new cljs.core.List(null,fn_param,null,(1),null)))));
} else {
return true;
}
})()], null);
});})(fspecs,arg_specs,fn_param,multi_ret_specs,get_fn_clause,G__69323,G__69323__$1,get_fspecs_70493,get_spec_part_70494))
,fspecs):null);
var multi_ret_clause = (cljs.core.truth_(multi_ret_specs)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"valid-multi-arity-ret?","valid-multi-arity-ret?",-2088255426,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,fn_param,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),null,(1),null)),(new cljs.core.List(null,fn_param,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"args","args",1315556576),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","key","cljs.core/key",799303703,null),null,(1),null))))),null,(1),null)),multi_ret_specs))),null,(1),null))))):null);
var multi_fn_clause = (cljs.core.truth_(fn_specs)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"valid-multi-arity-fn?","valid-multi-arity-fn?",995683820,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,fn_param,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","case","cljs.core/case",-1674122212,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),null,(1),null)),(new cljs.core.List(null,fn_param,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"args","args",1315556576),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","key","cljs.core/key",799303703,null),null,(1),null))))),null,(1),null)),fn_specs))),null,(1),null))))):null);
return cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),null,(1),null)),arg_specs)))], null),(cljs.core.truth_(multi_ret_clause)?null:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ret","ret",-468222814),get_spec_part_70494(new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.second.call(null,cljs.core.first.call(null,fspecs)))], null)),(cljs.core.truth_((function (){var or__4131__auto__ = multi_ret_clause;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return multi_fn_clause;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fn","fn",-1175266204),(cljs.core.truth_(multi_fn_clause)?(cljs.core.truth_(multi_ret_clause)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),null,(1),null)),(new cljs.core.List(null,multi_ret_clause,null,(1),null)),(new cljs.core.List(null,multi_fn_clause,null,(1),null))))):multi_fn_clause):multi_ret_clause)], null):null));
} else {
return null;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69323__$1)].join('')));

}
});})(get_fspecs_70493,get_spec_part_70494))
;
fulcro.incubator.spec_helpers.spec_op__GT_type = (function (){var map_prot = "cljs.core.IMap";
var coll_prot = "cljs.core.ICollection";
var seqable_prot = "(cljs.core.ISeqable|string)";
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"int-in","int-in",664882605,null),new cljs.core.Symbol(null,"merge","merge",-163787882,null),new cljs.core.Symbol(null,"int?","int?",1799729645,null),new cljs.core.Symbol(null,"every","every",-419764351,null),new cljs.core.Symbol(null,"float?","float?",673884616,null),new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"vector?","vector?",-61367869,null),new cljs.core.Symbol(null,"associative?","associative?",-141666771,null),new cljs.core.Symbol(null,"tuple","tuple",1167864243,null),new cljs.core.Symbol(null,"neg-int?","neg-int?",-1610409390,null),new cljs.core.Symbol(null,"map-of","map-of",-1464753414,null),new cljs.core.Symbol(null,"coll-of","coll-of",-1705285400,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"double-in","double-in",-303226659,null),new cljs.core.Symbol(null,"integer?","integer?",1303791671,null),new cljs.core.Symbol(null,"atom?","atom?",-1007535292,null),new cljs.core.Symbol(null,"string?","string?",-1129175764,null),new cljs.core.Symbol(null,"seq?","seq?",-1951934719,null),new cljs.core.Symbol(null,"nat-int?","nat-int?",-1879663400,null),new cljs.core.Symbol(null,"set?","set?",1636014792,null),new cljs.core.Symbol(null,"boolean?","boolean?",1790940868,null),new cljs.core.Symbol(null,"fn?","fn?",1820990818,null),new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"double?","double?",-2146564276,null),new cljs.core.Symbol(null,"seqable?","seqable?",72462495,null),new cljs.core.Symbol(null,"pos-int?","pos-int?",-1205815015,null)],[map_prot,"number",map_prot,"number",coll_prot,"number","cljs.core.IFn",map_prot,"cljs.core.IVector","cljs.core.IAssociative","cljs.core.IVector","number",map_prot,coll_prot,"cljs.core.Keyword","number","number","cljs.core.IAtom","string","cljs.core.ISeq","number","cljs.core.ISet","boolean","Function","number","number",seqable_prot,"number"]);
})();
fulcro.incubator.spec_helpers.get_type = (function fulcro$incubator$spec_helpers$get_type(recursive_call,conformed_spec_elem){
var vec__69399 = conformed_spec_elem;
var spec_type = cljs.core.nth.call(null,vec__69399,(0),null);
var spec_def = cljs.core.nth.call(null,vec__69399,(1),null);
var spec_op = (function (){var G__69403 = spec_type;
var G__69403__$1 = (((G__69403 instanceof cljs.core.Keyword))?G__69403.fqn:null);
switch (G__69403__$1) {
case "list":
var op = cljs.core.symbol.call(null,cljs.core.name.call(null,cljs.core.first.call(null,spec_def)));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"nilable","nilable",-812128667,null),null,new cljs.core.Symbol(null,"?","?",-62633706,null),null], null), null).call(null,op))){
return cljs.core.concat.call(null,fulcro.incubator.spec_helpers.get_type.call(null,true,cljs.spec.alpha.conform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),cljs.core.second.call(null,spec_def))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable","fulcro.incubator.spec-helpers/nilable",-1505470071)], null));
} else {
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"+","+",-740910886,null),null,new cljs.core.Symbol(null,"*","*",345799209,null),null], null), null).call(null,op))){
return cljs.core.concat.call(null,fulcro.incubator.spec_helpers.get_type.call(null,true,cljs.spec.alpha.conform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","spec-elem","fulcro.incubator.spec-helpers/spec-elem",1498141180),cljs.core.second.call(null,spec_def))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","variadic","fulcro.incubator.spec-helpers/variadic",1914095254)], null));
} else {
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"and","and",668631710,null),null], null), null).call(null,op))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,spec_def)], null);
} else {
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"every","every",-419764351,null),null,new cljs.core.Symbol(null,"coll-of","coll-of",-1705285400,null),null], null), null).call(null,op))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var or__4131__auto__ = cljs.core.second.call(null,cljs.core.drop_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"kind","kind",-717265803),null], null), null)),spec_def));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return op;
}
})()], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [op], null);

}
}
}
}

break;
case "gspec":
var gspec_def = cljs.core.val.call(null,spec_def);
if(cljs.core._EQ_.call(null,cljs.core.key.call(null,spec_def),new cljs.core.Keyword(null,"nilable-gspec","nilable-gspec",-925413839))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.spec_helpers.get_gspec_type.call(null,new cljs.core.Keyword(null,"gspec","gspec",1282160262).cljs$core$IFn$_invoke$arity$1(gspec_def)),new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable","fulcro.incubator.spec-helpers/nilable",-1505470071)], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.spec_helpers.get_gspec_type.call(null,gspec_def)], null);
}

break;
case "pred-sym":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_def], null);

break;
default:
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null);

}
})();
if(cljs.core.truth_(recursive_call)){
return spec_op;
} else {
var temp__5718__auto__ = fulcro.incubator.spec_helpers.spec_op__GT_type.call(null,cljs.core.first.call(null,spec_op));
if(cljs.core.truth_(temp__5718__auto__)){
var js_type = temp__5718__auto__;
var modifiers = cljs.core.set.call(null,cljs.core.rest.call(null,spec_op));
var t = js_type;
var t__$1 = [(cljs.core.truth_(new cljs.core.Keyword("fulcro.incubator.spec-helpers","nilable","fulcro.incubator.spec-helpers/nilable",-1505470071).cljs$core$IFn$_invoke$arity$1(modifiers))?"?":"!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(t)].join('');
return [(cljs.core.truth_(new cljs.core.Keyword("fulcro.incubator.spec-helpers","variadic","fulcro.incubator.spec-helpers/variadic",1914095254).cljs$core$IFn$_invoke$arity$1(modifiers))?"...":null),t__$1].join('');
} else {
return "*";
}
}
});
fulcro.incubator.spec_helpers.get_gspec_type = (function fulcro$incubator$spec_helpers$get_gspec_type(conformed_gspec){
var argspec_def = new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(conformed_gspec);
var args_jstype = ((cljs.core.not(argspec_def))?"":clojure.string.join.call(null,", ",cljs.core.map.call(null,cljs.core.partial.call(null,fulcro.incubator.spec_helpers.get_type,false),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(conformed_gspec)))));
var ret_jstype = fulcro.incubator.spec_helpers.get_type.call(null,false,new cljs.core.Keyword(null,"ret","ret",-468222814).cljs$core$IFn$_invoke$arity$1(conformed_gspec));
return ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_jstype),"): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_jstype)].join('');
});
fulcro.incubator.spec_helpers.generate_type_annotations = (function fulcro$incubator$spec_helpers$generate_type_annotations(conformed_bs){
var G__69450 = cljs.core.key.call(null,conformed_bs);
var G__69450__$1 = (((G__69450 instanceof cljs.core.Keyword))?G__69450.fqn:null);
switch (G__69450__$1) {
case "arity-1":
var temp__5720__auto__ = new cljs.core.Keyword(null,"gspec","gspec",1282160262).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,conformed_bs));
if(cljs.core.truth_(temp__5720__auto__)){
var gspec = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@type {",fulcro.incubator.spec_helpers.get_gspec_type.call(null,gspec),"}"].join('')], null)], null);
} else {
return null;
}

break;
case "arity-n":
return null;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69450__$1)].join('')));

}
});
fulcro.incubator.spec_helpers.generate_fdef = (function fulcro$incubator$spec_helpers$generate_fdef(forms){
var map__69457 = cljs.spec.alpha.conform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),forms);
var map__69457__$1 = (((((!((map__69457 == null))))?(((((map__69457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69457):map__69457);
var name = cljs.core.get.call(null,map__69457__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var bs = cljs.core.get.call(null,map__69457__$1,new cljs.core.Keyword(null,"bs","bs",1748393559));
var G__69462 = cljs.core.key.call(null,name);
var G__69462__$1 = (((G__69462 instanceof cljs.core.Keyword))?G__69462.fqn:null);
switch (G__69462__$1) {
case "sym":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.val.call(null,name),null,(1),null)),fulcro.incubator.spec_helpers.generate_fspec_body.call(null,bs))));

break;
case "key":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","def","cljs.spec.alpha/def",1122970404,null),null,(1),null)),(new cljs.core.List(null,cljs.core.val.call(null,name),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),null,(1),null)),fulcro.incubator.spec_helpers.generate_fspec_body.call(null,bs)))),null,(1),null)))));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69462__$1)].join('')));

}
});
var process_defn_body_70659 = (function (cfg,fspec,args_PLUS_gspec_PLUS_body){
var map__69472 = cfg;
var map__69472__$1 = (((((!((map__69472 == null))))?(((((map__69472.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69472.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69472):map__69472);
var env = cljs.core.get.call(null,map__69472__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var fn_name = cljs.core.get.call(null,map__69472__$1,new cljs.core.Keyword(null,"fn-name","fn-name",-766594004));
var map__69473 = args_PLUS_gspec_PLUS_body;
var map__69473__$1 = (((((!((map__69473 == null))))?(((((map__69473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69473):map__69473);
var args = cljs.core.get.call(null,map__69473__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var body = cljs.core.get.call(null,map__69473__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var vec__69474 = (function (){var G__69483 = cljs.core.key.call(null,body);
var G__69483__$1 = (((G__69483 instanceof cljs.core.Keyword))?G__69483.fqn:null);
switch (G__69483__$1) {
case "prepost+body":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prepost","prepost",1251610712).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,body)),new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,body))], null);

break;
case "body":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.val.call(null,body)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69483__$1)].join('')));

}
})();
var prepost = cljs.core.nth.call(null,vec__69474,(0),null);
var orig_body_forms = cljs.core.nth.call(null,vec__69474,(1),null);
var process_arg = ((function (map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms){
return (function (p__69484){
var vec__69485 = p__69484;
var arg_type = cljs.core.nth.call(null,vec__69485,(0),null);
var arg = cljs.core.nth.call(null,vec__69485,(1),null);
var arg__$1 = arg;
var G__69490 = arg_type;
var G__69490__$1 = (((G__69490 instanceof cljs.core.Keyword))?G__69490.fqn:null);
switch (G__69490__$1) {
case "sym":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arg_type,arg__$1], null);

break;
case "seq":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arg_type,cljs.core.update.call(null,arg__$1,new cljs.core.Keyword(null,"as","as",1148689641),((function (G__69490,G__69490__$1,arg__$1,vec__69485,arg_type,arg,map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms){
return (function (p1__69464_SHARP_){
var or__4131__auto__ = p1__69464_SHARP_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"sym","sym",-1444860305),cljs.core.gensym.call(null,"arg_")], null);
}
});})(G__69490,G__69490__$1,arg__$1,vec__69485,arg_type,arg,map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms))
)], null);

break;
case "map":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [arg_type,cljs.core.update.call(null,arg__$1,new cljs.core.Keyword(null,"as","as",1148689641),((function (G__69490,G__69490__$1,arg__$1,vec__69485,arg_type,arg,map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms){
return (function (p1__69465_SHARP_){
var or__4131__auto__ = p1__69465_SHARP_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.gensym.call(null,"arg_");
}
});})(G__69490,G__69490__$1,arg__$1,vec__69485,arg_type,arg,map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms))
)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69490__$1)].join('')));

}
});})(map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms))
;
var extract_arg = ((function (map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms,process_arg){
return (function (p__69529){
var vec__69532 = p__69529;
var arg_type = cljs.core.nth.call(null,vec__69532,(0),null);
var arg = cljs.core.nth.call(null,vec__69532,(1),null);
var G__69535 = arg_type;
var G__69535__$1 = (((G__69535 instanceof cljs.core.Keyword))?G__69535.fqn:null);
switch (G__69535__$1) {
case "sym":
return arg;

break;
case "seq":
return cljs.core.get_in.call(null,arg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"sym","sym",-1444860305)], null));

break;
case "map":
return new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg);

break;
default:
return null;

}
});})(map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms,process_arg))
;
var unform_arg = ((function (map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms,process_arg,extract_arg){
return (function (p1__69466_SHARP_){
return fulcro.incubator.spec_helpers.unscrew_vec_unform.call(null,cljs.spec.alpha.unform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","binding-form","fulcro.incubator.spec-helpers/binding-form",322923638),p1__69466_SHARP_));
});})(map__69472,map__69472__$1,env,fn_name,map__69473,map__69473__$1,args,body,vec__69474,prepost,orig_body_forms,process_arg,extract_arg))
;
var reg_args = cljs.core.map.call(null,process_arg,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(args));
var var_arg = (function (){var G__69537 = args;
var G__69537__$1 = (((G__69537 == null))?null:new cljs.core.Keyword(null,"varargs","varargs",1030150858).cljs$core$IFn$_invoke$arity$1(G__69537));
var G__69537__$2 = (((G__69537__$1 == null))?null:new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(G__69537__$1));
if((G__69537__$2 == null)){
return null;
} else {
return process_arg(G__69537__$2);
}
})();
var arg_list = cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,unform_arg,reg_args),(cljs.core.truth_(var_arg)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),unform_arg(var_arg)], null):null)));
var body_forms = (cljs.core.truth_((function (){var and__4120__auto__ = fspec;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_.call(null,cljs.core.nil_QMARK_,orig_body_forms);
} else {
return and__4120__auto__;
}
})())?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),null,(1),null)),(new cljs.core.List(null,fspec,null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.gen.alpha","generate","cljs.spec.gen.alpha/generate",-1135206536,null),null,(1),null))))),null,(1),null)),cljs.core.map.call(null,extract_arg,reg_args),(new cljs.core.List(null,extract_arg(var_arg),null,(1),null)))))], null):orig_body_forms);
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,arg_list,null,(1),null)),(new cljs.core.List(null,prepost,null,(1),null)),body_forms))));
});
fulcro.incubator.spec_helpers.generate_defn = ((function (process_defn_body_70659){
return (function fulcro$incubator$spec_helpers$generate_defn(forms,private$,env){
var conformed_gdefn = cljs.spec.alpha.conform.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),forms);
var fn_deftype = (cljs.core.truth_(private$)?new cljs.core.Symbol(null,"defn-","defn-",1097765044,null):new cljs.core.Symbol(null,"defn","defn",-126010802,null));
var fn_bodies = new cljs.core.Keyword(null,"bs","bs",1748393559).cljs$core$IFn$_invoke$arity$1(conformed_gdefn);
var arity = cljs.core.key.call(null,fn_bodies);
var fn_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(conformed_gdefn);
var docstring = new cljs.core.Keyword(null,"docstring","docstring",879233117).cljs$core$IFn$_invoke$arity$1(conformed_gdefn);
var meta_map = cljs.core.merge.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(conformed_gdefn),fulcro.incubator.spec_helpers.generate_type_annotations.call(null,fn_bodies));
var fdef_body = fulcro.incubator.spec_helpers.generate_fspec_body.call(null,fn_bodies);
var fdef = (cljs.core.truth_(fdef_body)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","fdef","cljs.spec.alpha/fdef",-1174458600,null),null,(1),null)),(new cljs.core.List(null,fn_name,null,(1),null)),fdef_body))):null);
var individual_arity_fspecs = cljs.core.map.call(null,((function (conformed_gdefn,fn_deftype,fn_bodies,arity,fn_name,docstring,meta_map,fdef_body,fdef,process_defn_body_70659){
return (function (p__69585){
var map__69586 = p__69585;
var map__69586__$1 = (((((!((map__69586 == null))))?(((((map__69586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69586.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69586):map__69586);
var args = cljs.core.get.call(null,map__69586__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var gspec = cljs.core.get.call(null,map__69586__$1,new cljs.core.Keyword(null,"gspec","gspec",1282160262));
if(cljs.core.truth_(gspec)){
return fulcro.incubator.spec_helpers.gspec__GT_fspec_STAR_.call(null,args,gspec,true,false,false);
} else {
return null;
}
});})(conformed_gdefn,fn_deftype,fn_bodies,arity,fn_name,docstring,meta_map,fdef_body,fdef,process_defn_body_70659))
,cljs.core.val.call(null,fn_bodies));
var process_fn_bodies = ((function (conformed_gdefn,fn_deftype,fn_bodies,arity,fn_name,docstring,meta_map,fdef_body,fdef,individual_arity_fspecs,process_defn_body_70659){
return (function (){
var process_cfg = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"env","env",-1815813235),env,new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),fn_name], null);
var G__69591 = arity;
var G__69591__$1 = (((G__69591 instanceof cljs.core.Keyword))?G__69591.fqn:null);
switch (G__69591__$1) {
case "arity-1":
return process_defn_body_70659(process_cfg,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),null,(1),null)),fdef_body))),cljs.core.val.call(null,fn_bodies));

break;
case "arity-n":
return cljs.core.map.call(null,cljs.core.partial.call(null,process_defn_body_70659,process_cfg),individual_arity_fspecs,cljs.core.val.call(null,fn_bodies));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__69591__$1)].join('')));

}
});})(conformed_gdefn,fn_deftype,fn_bodies,arity,fn_name,docstring,meta_map,fdef_body,fdef,individual_arity_fspecs,process_defn_body_70659))
;
var main_defn = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,fn_deftype,null,(1),null)),(new cljs.core.List(null,fn_name,null,(1),null)),(new cljs.core.List(null,docstring,null,(1),null)),(new cljs.core.List(null,meta_map,null,(1),null)),process_fn_bodies()))));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),(new cljs.core.List(null,fdef,null,(1),null)),(new cljs.core.List(null,main_defn,null,(1),null)))));
});})(process_defn_body_70659))
;
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"docstring","docstring",879233117),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),new cljs.core.Keyword(null,"docstring","docstring",879233117),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"docstring","docstring",879233117),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"bs","bs",1748393559)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.simple_symbol_QMARK_,cljs.spec.alpha.maybe_impl.call(null,cljs.core.string_QMARK_,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),cljs.spec.alpha.maybe_impl.call(null,cljs.core.map_QMARK_,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)], null),null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))], null))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","simple-symbol?","cljs.core/simple-symbol?",-1951205629,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951))))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.incubator.spec-helpers",">defn","fulcro.incubator.spec-helpers/>defn",-1480815091,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.incubator.spec-helpers",">defn-","fulcro.incubator.spec-helpers/>defn-",-1788180577,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">defn-args","fulcro.incubator.spec-helpers/>defn-args",265801911),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","desugared->defn","fulcro.incubator.spec-helpers/desugared->defn",-746086844),null,null,null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))))),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null)),new cljs.core.Keyword(null,"bs","bs",1748393559),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"bs","bs",1748393559)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword(null,"key","key",-1516042587)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol_QMARK_,cljs.core.qualified_keyword_QMARK_], null),null),cljs.spec.alpha.alt_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),cljs.spec.alpha.rep_PLUS_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)),cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.seq_QMARK_,new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)], null),null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951)))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Symbol("cljs.core","qualified-keyword?","cljs.core/qualified-keyword?",-308091478,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","alt","cljs.spec.alpha/alt",-2130750332,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951),new cljs.core.Keyword(null,"arity-n","arity-n",-1049811975),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","args+gspec+body","fulcro.incubator.spec-helpers/args+gspec+body",-1009394951))))], null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro.incubator.spec-helpers",">fdef","fulcro.incubator.spec-helpers/>fdef",453744805,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers",">fdef-args","fulcro.incubator.spec-helpers/>fdef-args",-320136807),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),null,null),new cljs.core.Keyword("fulcro.incubator.spec-helpers","fdef","fulcro.incubator.spec-helpers/fdef",1966173933),null,null,null));

//# sourceMappingURL=fulcro.incubator.spec_helpers.js.map
