goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__50698){
var map__50700 = p__50698;
var map__50700__$1 = (((((!((map__50700 == null))))?(((((map__50700.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50700.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50700):map__50700);
var m = map__50700__$1;
var n = cljs.core.get.call(null,map__50700__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__50700__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__50714_51051 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__50715_51052 = null;
var count__50716_51053 = (0);
var i__50717_51054 = (0);
while(true){
if((i__50717_51054 < count__50716_51053)){
var f_51055 = cljs.core._nth(chunk__50715_51052,i__50717_51054);
cljs.core.println.call(null,"  ",f_51055);


var G__51057 = seq__50714_51051;
var G__51058 = chunk__50715_51052;
var G__51059 = count__50716_51053;
var G__51060 = (i__50717_51054 + (1));
seq__50714_51051 = G__51057;
chunk__50715_51052 = G__51058;
count__50716_51053 = G__51059;
i__50717_51054 = G__51060;
continue;
} else {
var temp__5720__auto___51061 = cljs.core.seq.call(null,seq__50714_51051);
if(temp__5720__auto___51061){
var seq__50714_51062__$1 = temp__5720__auto___51061;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50714_51062__$1)){
var c__4550__auto___51063 = cljs.core.chunk_first.call(null,seq__50714_51062__$1);
var G__51064 = cljs.core.chunk_rest.call(null,seq__50714_51062__$1);
var G__51065 = c__4550__auto___51063;
var G__51066 = cljs.core.count.call(null,c__4550__auto___51063);
var G__51067 = (0);
seq__50714_51051 = G__51064;
chunk__50715_51052 = G__51065;
count__50716_51053 = G__51066;
i__50717_51054 = G__51067;
continue;
} else {
var f_51068 = cljs.core.first.call(null,seq__50714_51062__$1);
cljs.core.println.call(null,"  ",f_51068);


var G__51070 = cljs.core.next.call(null,seq__50714_51062__$1);
var G__51071 = null;
var G__51072 = (0);
var G__51073 = (0);
seq__50714_51051 = G__51070;
chunk__50715_51052 = G__51071;
count__50716_51053 = G__51072;
i__50717_51054 = G__51073;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_51075 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_51075);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_51075)))?cljs.core.second.call(null,arglists_51075):arglists_51075));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__50739_51078 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__50740_51079 = null;
var count__50741_51080 = (0);
var i__50742_51081 = (0);
while(true){
if((i__50742_51081 < count__50741_51080)){
var vec__50764_51082 = cljs.core._nth(chunk__50740_51079,i__50742_51081);
var name_51083 = cljs.core.nth.call(null,vec__50764_51082,(0),null);
var map__50767_51084 = cljs.core.nth.call(null,vec__50764_51082,(1),null);
var map__50767_51085__$1 = (((((!((map__50767_51084 == null))))?(((((map__50767_51084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50767_51084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50767_51084):map__50767_51084);
var doc_51086 = cljs.core.get.call(null,map__50767_51085__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_51087 = cljs.core.get.call(null,map__50767_51085__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_51083);

cljs.core.println.call(null," ",arglists_51087);

if(cljs.core.truth_(doc_51086)){
cljs.core.println.call(null," ",doc_51086);
} else {
}


var G__51091 = seq__50739_51078;
var G__51092 = chunk__50740_51079;
var G__51093 = count__50741_51080;
var G__51094 = (i__50742_51081 + (1));
seq__50739_51078 = G__51091;
chunk__50740_51079 = G__51092;
count__50741_51080 = G__51093;
i__50742_51081 = G__51094;
continue;
} else {
var temp__5720__auto___51096 = cljs.core.seq.call(null,seq__50739_51078);
if(temp__5720__auto___51096){
var seq__50739_51098__$1 = temp__5720__auto___51096;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50739_51098__$1)){
var c__4550__auto___51099 = cljs.core.chunk_first.call(null,seq__50739_51098__$1);
var G__51100 = cljs.core.chunk_rest.call(null,seq__50739_51098__$1);
var G__51101 = c__4550__auto___51099;
var G__51102 = cljs.core.count.call(null,c__4550__auto___51099);
var G__51103 = (0);
seq__50739_51078 = G__51100;
chunk__50740_51079 = G__51101;
count__50741_51080 = G__51102;
i__50742_51081 = G__51103;
continue;
} else {
var vec__50773_51105 = cljs.core.first.call(null,seq__50739_51098__$1);
var name_51106 = cljs.core.nth.call(null,vec__50773_51105,(0),null);
var map__50776_51107 = cljs.core.nth.call(null,vec__50773_51105,(1),null);
var map__50776_51108__$1 = (((((!((map__50776_51107 == null))))?(((((map__50776_51107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50776_51107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50776_51107):map__50776_51107);
var doc_51109 = cljs.core.get.call(null,map__50776_51108__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_51110 = cljs.core.get.call(null,map__50776_51108__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_51106);

cljs.core.println.call(null," ",arglists_51110);

if(cljs.core.truth_(doc_51109)){
cljs.core.println.call(null," ",doc_51109);
} else {
}


var G__51111 = cljs.core.next.call(null,seq__50739_51098__$1);
var G__51112 = null;
var G__51113 = (0);
var G__51114 = (0);
seq__50739_51078 = G__51111;
chunk__50740_51079 = G__51112;
count__50741_51080 = G__51113;
i__50742_51081 = G__51114;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__50794 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__50799 = null;
var count__50800 = (0);
var i__50801 = (0);
while(true){
if((i__50801 < count__50800)){
var role = cljs.core._nth(chunk__50799,i__50801);
var temp__5720__auto___51122__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___51122__$1)){
var spec_51123 = temp__5720__auto___51122__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_51123));
} else {
}


var G__51125 = seq__50794;
var G__51126 = chunk__50799;
var G__51127 = count__50800;
var G__51128 = (i__50801 + (1));
seq__50794 = G__51125;
chunk__50799 = G__51126;
count__50800 = G__51127;
i__50801 = G__51128;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__50794);
if(temp__5720__auto____$1){
var seq__50794__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50794__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__50794__$1);
var G__51135 = cljs.core.chunk_rest.call(null,seq__50794__$1);
var G__51136 = c__4550__auto__;
var G__51137 = cljs.core.count.call(null,c__4550__auto__);
var G__51138 = (0);
seq__50794 = G__51135;
chunk__50799 = G__51136;
count__50800 = G__51137;
i__50801 = G__51138;
continue;
} else {
var role = cljs.core.first.call(null,seq__50794__$1);
var temp__5720__auto___51139__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___51139__$2)){
var spec_51140 = temp__5720__auto___51139__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_51140));
} else {
}


var G__51141 = cljs.core.next.call(null,seq__50794__$1);
var G__51142 = null;
var G__51143 = (0);
var G__51144 = (0);
seq__50794 = G__51141;
chunk__50799 = G__51142;
count__50800 = G__51143;
i__50801 = G__51144;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__51169 = cljs.core.conj.call(null,via,t);
var G__51170 = cljs.core.ex_cause.call(null,t);
via = G__51169;
t = G__51170;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__50884 = datafied_throwable;
var map__50884__$1 = (((((!((map__50884 == null))))?(((((map__50884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50884.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50884):map__50884);
var via = cljs.core.get.call(null,map__50884__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__50884__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__50884__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__50885 = cljs.core.last.call(null,via);
var map__50885__$1 = (((((!((map__50885 == null))))?(((((map__50885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50885.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50885):map__50885);
var type = cljs.core.get.call(null,map__50885__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__50885__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__50885__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__50886 = data;
var map__50886__$1 = (((((!((map__50886 == null))))?(((((map__50886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50886):map__50886);
var problems = cljs.core.get.call(null,map__50886__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__50886__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__50886__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__50887 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__50887__$1 = (((((!((map__50887 == null))))?(((((map__50887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50887):map__50887);
var top_data = map__50887__$1;
var source = cljs.core.get.call(null,map__50887__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__50924 = phase;
var G__50924__$1 = (((G__50924 instanceof cljs.core.Keyword))?G__50924.fqn:null);
switch (G__50924__$1) {
case "read-source":
var map__50932 = data;
var map__50932__$1 = (((((!((map__50932 == null))))?(((((map__50932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50932.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50932):map__50932);
var line = cljs.core.get.call(null,map__50932__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__50932__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__50935 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__50935__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__50935,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__50935);
var G__50935__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__50935__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__50935__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__50935__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__50935__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__50948 = top_data;
var G__50948__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__50948,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__50948);
var G__50948__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__50948__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__50948__$1);
var G__50948__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__50948__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__50948__$2);
var G__50948__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__50948__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__50948__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__50948__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__50948__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__50954 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__50954,(0),null);
var method = cljs.core.nth.call(null,vec__50954,(1),null);
var file = cljs.core.nth.call(null,vec__50954,(2),null);
var line = cljs.core.nth.call(null,vec__50954,(3),null);
var G__50968 = top_data;
var G__50968__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__50968,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__50968);
var G__50968__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__50968__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__50968__$1);
var G__50968__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__50968__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__50968__$2);
var G__50968__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__50968__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__50968__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__50968__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__50968__$4;
}

break;
case "execution":
var vec__50980 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__50980,(0),null);
var method = cljs.core.nth.call(null,vec__50980,(1),null);
var file = cljs.core.nth.call(null,vec__50980,(2),null);
var line = cljs.core.nth.call(null,vec__50980,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__50980,source__$1,method,file,line,G__50924,G__50924__$1,map__50884,map__50884__$1,via,trace,phase,map__50885,map__50885__$1,type,message,data,map__50886,map__50886__$1,problems,fn,caller,map__50887,map__50887__$1,top_data,source){
return (function (p1__50869_SHARP_){
var or__4131__auto__ = (p1__50869_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__50869_SHARP_);
}
});})(vec__50980,source__$1,method,file,line,G__50924,G__50924__$1,map__50884,map__50884__$1,via,trace,phase,map__50885,map__50885__$1,type,message,data,map__50886,map__50886__$1,problems,fn,caller,map__50887,map__50887__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__50988 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__50988__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__50988,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__50988);
var G__50988__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__50988__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__50988__$1);
var G__50988__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__50988__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__50988__$2);
var G__50988__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__50988__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__50988__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__50988__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__50988__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__50924__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__51002){
var map__51005 = p__51002;
var map__51005__$1 = (((((!((map__51005 == null))))?(((((map__51005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51005):map__51005);
var triage_data = map__51005__$1;
var phase = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__51005__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__51017 = phase;
var G__51017__$1 = (((G__51017 instanceof cljs.core.Keyword))?G__51017.fqn:null);
switch (G__51017__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__51020_51227 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__51022_51228 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__51023_51229 = true;
var _STAR_print_fn_STAR__temp_val__51024_51230 = ((function (_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__51023_51229;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__51024_51230;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,_STAR_print_fn_STAR__temp_val__51024_51230,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,_STAR_print_fn_STAR__temp_val__51024_51230,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__50999_SHARP_){
return cljs.core.dissoc.call(null,p1__50999_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,_STAR_print_fn_STAR__temp_val__51024_51230,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__51020_51227,_STAR_print_fn_STAR__orig_val__51022_51228,_STAR_print_newline_STAR__temp_val__51023_51229,_STAR_print_fn_STAR__temp_val__51024_51230,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__51022_51228;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__51020_51227;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__51029_51240 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__51030_51241 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__51031_51242 = true;
var _STAR_print_fn_STAR__temp_val__51032_51243 = ((function (_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__51031_51242;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__51032_51243;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,_STAR_print_fn_STAR__temp_val__51032_51243,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,_STAR_print_fn_STAR__temp_val__51032_51243,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__51000_SHARP_){
return cljs.core.dissoc.call(null,p1__51000_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,_STAR_print_fn_STAR__temp_val__51032_51243,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__51029_51240,_STAR_print_fn_STAR__orig_val__51030_51241,_STAR_print_newline_STAR__temp_val__51031_51242,_STAR_print_fn_STAR__temp_val__51032_51243,sb__4661__auto__,G__51017,G__51017__$1,loc,class_name,simple_class,cause_type,format,map__51005,map__51005__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__51030_51241;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__51029_51240;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__51017__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=cljs.repl.js.map
