(ns roam.parser.playground
  (:require [com.wsscode.pathom.core :as p]
            [com.wsscode.pathom.connect :as pc]))

(pc/defresolver pi [env _]
  {::pc/output [:math/pi]}
  {:math/pi Math/PI})

(pc/defresolver tau [env {:math/keys [pi]}]
  {::pc/input  #{:math/pi}
   ::pc/output [:math/tau]}
  {:math/tau (/ pi 2)})

(def users
  {1 {:user/name  "Conor" :user/age 31 :user/likes {:user/id 3}
      :user/owner 1}
   2 {:user/name  "Josh" :user/age 22 :user/likes {:user/id 1} :user/_likes [{:user/id 1}]
      :user/owner 2}
   3 {:user/name   "Wilker"
      :user/age    32
      :user/owner  1
      :user/likes  {:user/id 2}
      :user/_likes [{:user/id 1}]}})

(pc/defresolver user-by-id [{::keys [current-user]} {:user/keys [id]}]
  {::pc/input  #{:user/id}
   ::pc/output [:user/name :user/age
                {:user/likes [:user/id]}]}
  (let [user (get users id)]
    (if (= current-user (:user/owner user))
      user)))

(pc/defresolver roam-devs [env {:keys []}]
  {::pc/output [{:user/roam-devs [:user/id]}]}
  {:user/roam-devs [{:user/id 1}
                    {:user/id 2}]})

(pc/defresolver roam-devs-age [{:keys  [parser]
                                ::keys [current-user]
                                :as    env} {:keys []}]
  {::pc/input  #{:user/roam-devs}
   ::pc/output [:roam-devs/added-age]}
  (clojure.pprint/pprint ["USER" current-user])
  (let [ages (->> (parser env [{:user/roam-devs [:user/age]}])
                  :user/roam-devs
                  (map :user/age))]
    {:roam-devs/added-age (reduce + 0 ages)}))

(def registry
  [pi
   tau
   user-by-id
   roam-devs
   roam-devs-age
   (pc/constantly-resolver :a 1)
   (pc/single-attr-resolver :a :b inc)
   (pc/single-attr-resolver :b :c #(* 2 %))
   (pc/single-attr-resolver :c :d #(vector %))])

(def parser
  (p/parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/reader3
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}
                  ::authenticated?         false}
     ::p/mutate  pc/mutate
     ::p/plugins [(pc/connect-plugin {::pc/register registry})
                  p/error-handler-plugin
                  p/trace-plugin]}))

(comment
  (let [env (atom {})]
    (sci/eval-string "(defn ^:cool-fn foo [] :foo) (meta #'foo)" {:env env})
    (-> @env :namespaces (get 'user)))
  (select-keys {:a 1 :b 2 :c 3} [:a :b])

  (-> (parser {::current-user 321} [::pc/indexes])
      ::pc/indexes
      ::pc/index-oir)

  (parser {::current-user 321} [:roam-devs/added-age])
  (parser {} [{[:a 88] [:d]}])
  (parser {} [{[:user/id 1] [{:other-person 5} :user/name]}])
  (parser {::current-user 2} [{[:user/id 3] [:user/age]}]))
