goog.provide('com.wsscode.pathom.misc');
goog.require('cljs.core');
/**
 * @define {boolean}
 */
com.wsscode.pathom.misc.INCLUDE_SPECS = goog.define("com.wsscode.pathom.misc.INCLUDE_SPECS",true);
com.wsscode.pathom.misc.pathom_random_uuid = (function com$wsscode$pathom$misc$pathom_random_uuid(){
return cljs.core.random_uuid.call(null);
});
/**
 * Returns a lazy sequence of the elements of coll, removing any elements that
 *   return duplicate values when passed to a function f.
 */
com.wsscode.pathom.misc.distinct_by = (function com$wsscode$pathom$misc$distinct_by(var_args){
var G__73613 = arguments.length;
switch (G__73613) {
case 1:
return com.wsscode.pathom.misc.distinct_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.misc.distinct_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.misc.distinct_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__73720 = null;
var G__73720__0 = (function (){
return rf.call(null);
});
var G__73720__1 = (function (result){
return rf.call(null,result);
});
var G__73720__2 = (function (result,x){
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,seen),fx)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.call(null,cljs.core._deref(seen),fx));

return rf.call(null,result,x);
}
});
G__73720 = function(result,x){
switch(arguments.length){
case 0:
return G__73720__0.call(this);
case 1:
return G__73720__1.call(this,result);
case 2:
return G__73720__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__73720.cljs$core$IFn$_invoke$arity$0 = G__73720__0;
G__73720.cljs$core$IFn$_invoke$arity$1 = G__73720__1;
G__73720.cljs$core$IFn$_invoke$arity$2 = G__73720__2;
return G__73720;
})()
;})(seen))
});
});

com.wsscode.pathom.misc.distinct_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var step = (function com$wsscode$pathom$misc$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__73625,seen__$1){
while(true){
var vec__73628 = p__73625;
var x = cljs.core.nth.call(null,vec__73628,(0),null);
var xs__$1 = vec__73628;
var temp__5720__auto__ = cljs.core.seq.call(null,xs__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,seen__$1,fx)){
var G__73728 = cljs.core.rest.call(null,s);
var G__73729 = seen__$1;
p__73625 = G__73728;
seen__$1 = G__73729;
continue;
} else {
return cljs.core.cons.call(null,x,com$wsscode$pathom$misc$step.call(null,cljs.core.rest.call(null,s),cljs.core.conj.call(null,seen__$1,fx)));
}
} else {
return null;
}
break;
}
})(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

com.wsscode.pathom.misc.distinct_by.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence removing consecutive duplicates in coll when passed to a function f.
 *   Returns a transducer when no collection is provided.
 */
com.wsscode.pathom.misc.dedupe_by = (function com$wsscode$pathom$misc$dedupe_by(var_args){
var G__73641 = arguments.length;
switch (G__73641) {
case 1:
return com.wsscode.pathom.misc.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.misc.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.misc.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var pv = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword("com.wsscode.pathom.misc","none","com.wsscode.pathom.misc/none",534209886));
return ((function (pv){
return (function() {
var G__73740 = null;
var G__73740__0 = (function (){
return rf.call(null);
});
var G__73740__1 = (function (result){
return rf.call(null,result);
});
var G__73740__2 = (function (result,x){
var prior = cljs.core.deref.call(null,pv);
var fx = f.call(null,x);
cljs.core.vreset_BANG_.call(null,pv,fx);

if(cljs.core._EQ_.call(null,prior,fx)){
return result;
} else {
return rf.call(null,result,x);
}
});
G__73740 = function(result,x){
switch(arguments.length){
case 0:
return G__73740__0.call(this);
case 1:
return G__73740__1.call(this,result);
case 2:
return G__73740__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__73740.cljs$core$IFn$_invoke$arity$0 = G__73740__0;
G__73740.cljs$core$IFn$_invoke$arity$1 = G__73740__1;
G__73740.cljs$core$IFn$_invoke$arity$2 = G__73740__2;
return G__73740;
})()
;})(pv))
});
});

com.wsscode.pathom.misc.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.sequence.call(null,com.wsscode.pathom.misc.dedupe_by.call(null,f),coll);
});

com.wsscode.pathom.misc.dedupe_by.cljs$lang$maxFixedArity = 2;

/**
 * Like group by, but will keep only the last result.
 */
com.wsscode.pathom.misc.index_by = (function com$wsscode$pathom$misc$index_by(f,coll){
return cljs.core.reduce.call(null,(function (m,x){
return cljs.core.assoc.call(null,m,f.call(null,x),x);
}),cljs.core.PersistentArrayMap.EMPTY,coll);
});
com.wsscode.pathom.misc.sconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY);
com.wsscode.pathom.misc.vconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY);
com.wsscode.pathom.misc.spec_doc = (function com$wsscode$pathom$misc$spec_doc(spec,doc){
return spec;
});
/**
 * Create a queue.
 */
com.wsscode.pathom.misc.queue = (function com$wsscode$pathom$misc$queue(var_args){
var G__73664 = arguments.length;
switch (G__73664) {
case 0:
return com.wsscode.pathom.misc.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.pathom.misc.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.misc.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

com.wsscode.pathom.misc.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.reduce.call(null,cljs.core.conj,com.wsscode.pathom.misc.queue.call(null),coll);
});

com.wsscode.pathom.misc.queue.cljs$lang$maxFixedArity = 1;

/**
 * Map over the given hash-map keys.
 * 
 *   Example:
 *  (map-keys #(str/replace (name %) "_" "-") {"foo_bar" 1}) => {"foo-bar" 1}
 *   
 */
com.wsscode.pathom.misc.map_keys = (function com$wsscode$pathom$misc$map_keys(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4523__auto__ = (function com$wsscode$pathom$misc$map_keys_$_iter__73667(s__73668){
return (new cljs.core.LazySeq(null,(function (){
var s__73668__$1 = s__73668;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__73668__$1);
if(temp__5720__auto__){
var s__73668__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__73668__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__73668__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__73670 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__73669 = (0);
while(true){
if((i__73669 < size__4522__auto__)){
var vec__73674 = cljs.core._nth(c__4521__auto__,i__73669);
var k = cljs.core.nth.call(null,vec__73674,(0),null);
var v = cljs.core.nth.call(null,vec__73674,(1),null);
cljs.core.chunk_append.call(null,b__73670,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.call(null,k),v], null));

var G__73755 = (i__73669 + (1));
i__73669 = G__73755;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__73670),com$wsscode$pathom$misc$map_keys_$_iter__73667.call(null,cljs.core.chunk_rest.call(null,s__73668__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__73670),null);
}
} else {
var vec__73677 = cljs.core.first.call(null,s__73668__$2);
var k = cljs.core.nth.call(null,vec__73677,(0),null);
var v = cljs.core.nth.call(null,vec__73677,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.call(null,k),v], null),com$wsscode$pathom$misc$map_keys_$_iter__73667.call(null,cljs.core.rest.call(null,s__73668__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(m);
})());
});
/**
 * Map over the given hash-map vals.
 * 
 *   Example:
 *  (map-vals inc {:a 1 :b 2})
 *   
 */
com.wsscode.pathom.misc.map_vals = (function com$wsscode$pathom$misc$map_vals(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4523__auto__ = (function com$wsscode$pathom$misc$map_vals_$_iter__73694(s__73695){
return (new cljs.core.LazySeq(null,(function (){
var s__73695__$1 = s__73695;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__73695__$1);
if(temp__5720__auto__){
var s__73695__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__73695__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__73695__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__73697 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__73696 = (0);
while(true){
if((i__73696 < size__4522__auto__)){
var vec__73704 = cljs.core._nth(c__4521__auto__,i__73696);
var k = cljs.core.nth.call(null,vec__73704,(0),null);
var v = cljs.core.nth.call(null,vec__73704,(1),null);
cljs.core.chunk_append.call(null,b__73697,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,f.call(null,v)], null));

var G__73761 = (i__73696 + (1));
i__73696 = G__73761;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__73697),com$wsscode$pathom$misc$map_vals_$_iter__73694.call(null,cljs.core.chunk_rest.call(null,s__73695__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__73697),null);
}
} else {
var vec__73710 = cljs.core.first.call(null,s__73695__$2);
var k = cljs.core.nth.call(null,vec__73710,(0),null);
var v = cljs.core.nth.call(null,vec__73710,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,f.call(null,v)], null),com$wsscode$pathom$misc$map_vals_$_iter__73694.call(null,cljs.core.rest.call(null,s__73695__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(m);
})());
});

//# sourceMappingURL=com.wsscode.pathom.misc.js.map
