goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
goog.require('clojure.set');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.call(null,null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_.call(null,null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65447 = arguments.length;
var i__4731__auto___65448 = (0);
while(true){
if((i__4731__auto___65448 < len__4730__auto___65447)){
args__4736__auto__.push((arguments[i__4731__auto___65448]));

var G__65450 = (i__4731__auto___65448 + (1));
i__4731__auto___65448 = G__65450;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq65025){
var G__65026 = cljs.core.first.call(null,seq65025);
var seq65025__$1 = cljs.core.next.call(null,seq65025);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65026,seq65025__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5718__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s.send(cljs.core.pr_str.call(null,msg));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.call(null,msg));
}
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__65056 = cljs.core.seq.call(null,sources);
var chunk__65058 = null;
var count__65059 = (0);
var i__65060 = (0);
while(true){
if((i__65060 < count__65059)){
var map__65084 = cljs.core._nth(chunk__65058,i__65060);
var map__65084__$1 = (((((!((map__65084 == null))))?(((((map__65084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65084):map__65084);
var src = map__65084__$1;
var resource_id = cljs.core.get.call(null,map__65084__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__65084__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__65084__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__65084__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e65090){var e_65455 = e65090;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_65455);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_65455.message)].join('')));
}

var G__65457 = seq__65056;
var G__65458 = chunk__65058;
var G__65459 = count__65059;
var G__65460 = (i__65060 + (1));
seq__65056 = G__65457;
chunk__65058 = G__65458;
count__65059 = G__65459;
i__65060 = G__65460;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__65056);
if(temp__5720__auto__){
var seq__65056__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65056__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__65056__$1);
var G__65463 = cljs.core.chunk_rest.call(null,seq__65056__$1);
var G__65464 = c__4550__auto__;
var G__65465 = cljs.core.count.call(null,c__4550__auto__);
var G__65466 = (0);
seq__65056 = G__65463;
chunk__65058 = G__65464;
count__65059 = G__65465;
i__65060 = G__65466;
continue;
} else {
var map__65097 = cljs.core.first.call(null,seq__65056__$1);
var map__65097__$1 = (((((!((map__65097 == null))))?(((((map__65097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65097):map__65097);
var src = map__65097__$1;
var resource_id = cljs.core.get.call(null,map__65097__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__65097__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__65097__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__65097__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e65106){var e_65467 = e65106;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_65467);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_65467.message)].join('')));
}

var G__65468 = cljs.core.next.call(null,seq__65056__$1);
var G__65469 = null;
var G__65470 = (0);
var G__65471 = (0);
seq__65056 = G__65468;
chunk__65058 = G__65469;
count__65059 = G__65470;
i__65060 = G__65471;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,cljs.core.assoc.call(null,msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})),(function (){
return shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__65116 = cljs.core.seq.call(null,js_requires);
var chunk__65117 = null;
var count__65118 = (0);
var i__65119 = (0);
while(true){
if((i__65119 < count__65118)){
var js_ns = cljs.core._nth(chunk__65117,i__65119);
var require_str_65475 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_65475);


var G__65478 = seq__65116;
var G__65479 = chunk__65117;
var G__65480 = count__65118;
var G__65481 = (i__65119 + (1));
seq__65116 = G__65478;
chunk__65117 = G__65479;
count__65118 = G__65480;
i__65119 = G__65481;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__65116);
if(temp__5720__auto__){
var seq__65116__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65116__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__65116__$1);
var G__65482 = cljs.core.chunk_rest.call(null,seq__65116__$1);
var G__65483 = c__4550__auto__;
var G__65484 = cljs.core.count.call(null,c__4550__auto__);
var G__65485 = (0);
seq__65116 = G__65482;
chunk__65117 = G__65483;
count__65118 = G__65484;
i__65119 = G__65485;
continue;
} else {
var js_ns = cljs.core.first.call(null,seq__65116__$1);
var require_str_65486 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_65486);


var G__65487 = cljs.core.next.call(null,seq__65116__$1);
var G__65488 = null;
var G__65489 = (0);
var G__65490 = (0);
seq__65116 = G__65487;
chunk__65117 = G__65488;
count__65118 = G__65489;
i__65119 = G__65490;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_.call(null,sources)){
return callback.call(null,cljs.core.PersistentVector.EMPTY);
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url.call(null),(function (res){
var req = this;
var content = cljs.reader.read_string.call(null,req.getResponseText());
return callback.call(null,content);
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__65138){
var map__65139 = p__65138;
var map__65139__$1 = (((((!((map__65139 == null))))?(((((map__65139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65139):map__65139);
var msg = map__65139__$1;
var info = cljs.core.get.call(null,map__65139__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.call(null,map__65139__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__4523__auto__ = ((function (map__65139,map__65139__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__65145(s__65146){
return (new cljs.core.LazySeq(null,((function (map__65139,map__65139__$1,msg,info,reload_info){
return (function (){
var s__65146__$1 = s__65146;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__65146__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var map__65153 = cljs.core.first.call(null,xs__6277__auto__);
var map__65153__$1 = (((((!((map__65153 == null))))?(((((map__65153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65153.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65153):map__65153);
var src = map__65153__$1;
var resource_name = cljs.core.get.call(null,map__65153__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__65153__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4519__auto__ = ((function (s__65146__$1,map__65153,map__65153__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__65139,map__65139__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__65145_$_iter__65147(s__65148){
return (new cljs.core.LazySeq(null,((function (s__65146__$1,map__65153,map__65153__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__65139,map__65139__$1,msg,info,reload_info){
return (function (){
var s__65148__$1 = s__65148;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__65148__$1);
if(temp__5720__auto____$1){
var s__65148__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65148__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__65148__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__65150 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__65149 = (0);
while(true){
if((i__65149 < size__4522__auto__)){
var warning = cljs.core._nth(c__4521__auto__,i__65149);
cljs.core.chunk_append.call(null,b__65150,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__65494 = (i__65149 + (1));
i__65149 = G__65494;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65150),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__65145_$_iter__65147.call(null,cljs.core.chunk_rest.call(null,s__65148__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65150),null);
}
} else {
var warning = cljs.core.first.call(null,s__65148__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__65145_$_iter__65147.call(null,cljs.core.rest.call(null,s__65148__$2)));
}
} else {
return null;
}
break;
}
});})(s__65146__$1,map__65153,map__65153__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__65139,map__65139__$1,msg,info,reload_info))
,null,null));
});})(s__65146__$1,map__65153,map__65153__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__65139,map__65139__$1,msg,info,reload_info))
;
var fs__4520__auto__ = cljs.core.seq.call(null,iterys__4519__auto__(warnings));
if(fs__4520__auto__){
return cljs.core.concat.call(null,fs__4520__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__65145.call(null,cljs.core.rest.call(null,s__65146__$1)));
} else {
var G__65497 = cljs.core.rest.call(null,s__65146__$1);
s__65146__$1 = G__65497;
continue;
}
} else {
var G__65498 = cljs.core.rest.call(null,s__65146__$1);
s__65146__$1 = G__65498;
continue;
}
} else {
return null;
}
break;
}
});})(map__65139,map__65139__$1,msg,info,reload_info))
,null,null));
});})(map__65139,map__65139__$1,msg,info,reload_info))
;
return iter__4523__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
var seq__65158_65499 = cljs.core.seq.call(null,warnings);
var chunk__65159_65500 = null;
var count__65160_65501 = (0);
var i__65161_65502 = (0);
while(true){
if((i__65161_65502 < count__65160_65501)){
var map__65173_65503 = cljs.core._nth(chunk__65159_65500,i__65161_65502);
var map__65173_65504__$1 = (((((!((map__65173_65503 == null))))?(((((map__65173_65503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65173_65503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65173_65503):map__65173_65503);
var w_65505 = map__65173_65504__$1;
var msg_65506__$1 = cljs.core.get.call(null,map__65173_65504__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_65507 = cljs.core.get.call(null,map__65173_65504__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_65508 = cljs.core.get.call(null,map__65173_65504__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_65509 = cljs.core.get.call(null,map__65173_65504__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_65509)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_65507),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_65508),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_65506__$1)].join(''));


var G__65512 = seq__65158_65499;
var G__65513 = chunk__65159_65500;
var G__65514 = count__65160_65501;
var G__65515 = (i__65161_65502 + (1));
seq__65158_65499 = G__65512;
chunk__65159_65500 = G__65513;
count__65160_65501 = G__65514;
i__65161_65502 = G__65515;
continue;
} else {
var temp__5720__auto___65516 = cljs.core.seq.call(null,seq__65158_65499);
if(temp__5720__auto___65516){
var seq__65158_65517__$1 = temp__5720__auto___65516;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65158_65517__$1)){
var c__4550__auto___65518 = cljs.core.chunk_first.call(null,seq__65158_65517__$1);
var G__65519 = cljs.core.chunk_rest.call(null,seq__65158_65517__$1);
var G__65520 = c__4550__auto___65518;
var G__65521 = cljs.core.count.call(null,c__4550__auto___65518);
var G__65522 = (0);
seq__65158_65499 = G__65519;
chunk__65159_65500 = G__65520;
count__65160_65501 = G__65521;
i__65161_65502 = G__65522;
continue;
} else {
var map__65178_65523 = cljs.core.first.call(null,seq__65158_65517__$1);
var map__65178_65524__$1 = (((((!((map__65178_65523 == null))))?(((((map__65178_65523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65178_65523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65178_65523):map__65178_65523);
var w_65525 = map__65178_65524__$1;
var msg_65526__$1 = cljs.core.get.call(null,map__65178_65524__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_65527 = cljs.core.get.call(null,map__65178_65524__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_65528 = cljs.core.get.call(null,map__65178_65524__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_65529 = cljs.core.get.call(null,map__65178_65524__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_65529)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_65527),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_65528),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_65526__$1)].join(''));


var G__65531 = cljs.core.next.call(null,seq__65158_65517__$1);
var G__65532 = null;
var G__65533 = (0);
var G__65534 = (0);
seq__65158_65499 = G__65531;
chunk__65159_65500 = G__65532;
count__65160_65501 = G__65533;
i__65161_65502 = G__65534;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(((cljs.core.empty_QMARK_.call(null,warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = shadow.cljs.devtools.client.env.filter_reload_sources.call(null,info,reload_info);
if(cljs.core.not(cljs.core.seq.call(null,sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.seq.call(null,cljs.core.get_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"reloading code but no :after-load hooks are configured!","https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks");
}

return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_get,((function (sources_to_get,warnings,map__65139,map__65139__$1,msg,info,reload_info){
return (function (p1__65137_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload.call(null,msg,p1__65137_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,warnings,map__65139,map__65139__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.call(null,"file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.call(null,new$,(1));
if(((cljs.core._EQ_.call(null,old,rel_new)) || (clojure.string.starts_with_QMARK_.call(null,old,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(rel_new),"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
var and__4120__auto__ = ((cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())));
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core._EQ_.call(null,node_abs,new$);
if(and__4120__auto____$1){
return new$;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__65204){
var map__65205 = p__65204;
var map__65205__$1 = (((((!((map__65205 == null))))?(((((map__65205.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65205.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65205):map__65205);
var msg = map__65205__$1;
var updates = cljs.core.get.call(null,map__65205__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__65207 = cljs.core.seq.call(null,updates);
var chunk__65209 = null;
var count__65210 = (0);
var i__65211 = (0);
while(true){
if((i__65211 < count__65210)){
var path = cljs.core._nth(chunk__65209,i__65211);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__65264_65539 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__65267_65540 = null;
var count__65268_65541 = (0);
var i__65269_65542 = (0);
while(true){
if((i__65269_65542 < count__65268_65541)){
var node_65545 = cljs.core._nth(chunk__65267_65540,i__65269_65542);
var path_match_65547 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_65545.getAttribute("href"),path);
if(cljs.core.truth_(path_match_65547)){
var new_link_65548 = (function (){var G__65287 = node_65545.cloneNode(true);
G__65287.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_65547),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__65287;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_65547);

goog.dom.insertSiblingAfter(new_link_65548,node_65545);

goog.dom.removeNode(node_65545);


var G__65549 = seq__65264_65539;
var G__65550 = chunk__65267_65540;
var G__65551 = count__65268_65541;
var G__65552 = (i__65269_65542 + (1));
seq__65264_65539 = G__65549;
chunk__65267_65540 = G__65550;
count__65268_65541 = G__65551;
i__65269_65542 = G__65552;
continue;
} else {
var G__65553 = seq__65264_65539;
var G__65554 = chunk__65267_65540;
var G__65555 = count__65268_65541;
var G__65556 = (i__65269_65542 + (1));
seq__65264_65539 = G__65553;
chunk__65267_65540 = G__65554;
count__65268_65541 = G__65555;
i__65269_65542 = G__65556;
continue;
}
} else {
var temp__5720__auto___65557 = cljs.core.seq.call(null,seq__65264_65539);
if(temp__5720__auto___65557){
var seq__65264_65558__$1 = temp__5720__auto___65557;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65264_65558__$1)){
var c__4550__auto___65559 = cljs.core.chunk_first.call(null,seq__65264_65558__$1);
var G__65560 = cljs.core.chunk_rest.call(null,seq__65264_65558__$1);
var G__65561 = c__4550__auto___65559;
var G__65562 = cljs.core.count.call(null,c__4550__auto___65559);
var G__65563 = (0);
seq__65264_65539 = G__65560;
chunk__65267_65540 = G__65561;
count__65268_65541 = G__65562;
i__65269_65542 = G__65563;
continue;
} else {
var node_65564 = cljs.core.first.call(null,seq__65264_65558__$1);
var path_match_65565 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_65564.getAttribute("href"),path);
if(cljs.core.truth_(path_match_65565)){
var new_link_65567 = (function (){var G__65292 = node_65564.cloneNode(true);
G__65292.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_65565),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__65292;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_65565);

goog.dom.insertSiblingAfter(new_link_65567,node_65564);

goog.dom.removeNode(node_65564);


var G__65568 = cljs.core.next.call(null,seq__65264_65558__$1);
var G__65569 = null;
var G__65570 = (0);
var G__65571 = (0);
seq__65264_65539 = G__65568;
chunk__65267_65540 = G__65569;
count__65268_65541 = G__65570;
i__65269_65542 = G__65571;
continue;
} else {
var G__65572 = cljs.core.next.call(null,seq__65264_65558__$1);
var G__65573 = null;
var G__65574 = (0);
var G__65575 = (0);
seq__65264_65539 = G__65572;
chunk__65267_65540 = G__65573;
count__65268_65541 = G__65574;
i__65269_65542 = G__65575;
continue;
}
}
} else {
}
}
break;
}


var G__65576 = seq__65207;
var G__65577 = chunk__65209;
var G__65578 = count__65210;
var G__65579 = (i__65211 + (1));
seq__65207 = G__65576;
chunk__65209 = G__65577;
count__65210 = G__65578;
i__65211 = G__65579;
continue;
} else {
var G__65580 = seq__65207;
var G__65581 = chunk__65209;
var G__65582 = count__65210;
var G__65583 = (i__65211 + (1));
seq__65207 = G__65580;
chunk__65209 = G__65581;
count__65210 = G__65582;
i__65211 = G__65583;
continue;
}
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__65207);
if(temp__5720__auto__){
var seq__65207__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65207__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__65207__$1);
var G__65585 = cljs.core.chunk_rest.call(null,seq__65207__$1);
var G__65586 = c__4550__auto__;
var G__65587 = cljs.core.count.call(null,c__4550__auto__);
var G__65588 = (0);
seq__65207 = G__65585;
chunk__65209 = G__65586;
count__65210 = G__65587;
i__65211 = G__65588;
continue;
} else {
var path = cljs.core.first.call(null,seq__65207__$1);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__65302_65590 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__65305_65591 = null;
var count__65306_65592 = (0);
var i__65307_65593 = (0);
while(true){
if((i__65307_65593 < count__65306_65592)){
var node_65594 = cljs.core._nth(chunk__65305_65591,i__65307_65593);
var path_match_65595 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_65594.getAttribute("href"),path);
if(cljs.core.truth_(path_match_65595)){
var new_link_65596 = (function (){var G__65320 = node_65594.cloneNode(true);
G__65320.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_65595),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__65320;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_65595);

goog.dom.insertSiblingAfter(new_link_65596,node_65594);

goog.dom.removeNode(node_65594);


var G__65597 = seq__65302_65590;
var G__65598 = chunk__65305_65591;
var G__65599 = count__65306_65592;
var G__65600 = (i__65307_65593 + (1));
seq__65302_65590 = G__65597;
chunk__65305_65591 = G__65598;
count__65306_65592 = G__65599;
i__65307_65593 = G__65600;
continue;
} else {
var G__65601 = seq__65302_65590;
var G__65602 = chunk__65305_65591;
var G__65603 = count__65306_65592;
var G__65604 = (i__65307_65593 + (1));
seq__65302_65590 = G__65601;
chunk__65305_65591 = G__65602;
count__65306_65592 = G__65603;
i__65307_65593 = G__65604;
continue;
}
} else {
var temp__5720__auto___65605__$1 = cljs.core.seq.call(null,seq__65302_65590);
if(temp__5720__auto___65605__$1){
var seq__65302_65606__$1 = temp__5720__auto___65605__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65302_65606__$1)){
var c__4550__auto___65607 = cljs.core.chunk_first.call(null,seq__65302_65606__$1);
var G__65608 = cljs.core.chunk_rest.call(null,seq__65302_65606__$1);
var G__65609 = c__4550__auto___65607;
var G__65610 = cljs.core.count.call(null,c__4550__auto___65607);
var G__65611 = (0);
seq__65302_65590 = G__65608;
chunk__65305_65591 = G__65609;
count__65306_65592 = G__65610;
i__65307_65593 = G__65611;
continue;
} else {
var node_65613 = cljs.core.first.call(null,seq__65302_65606__$1);
var path_match_65614 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_65613.getAttribute("href"),path);
if(cljs.core.truth_(path_match_65614)){
var new_link_65615 = (function (){var G__65326 = node_65613.cloneNode(true);
G__65326.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_65614),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__65326;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_65614);

goog.dom.insertSiblingAfter(new_link_65615,node_65613);

goog.dom.removeNode(node_65613);


var G__65616 = cljs.core.next.call(null,seq__65302_65606__$1);
var G__65617 = null;
var G__65618 = (0);
var G__65619 = (0);
seq__65302_65590 = G__65616;
chunk__65305_65591 = G__65617;
count__65306_65592 = G__65618;
i__65307_65593 = G__65619;
continue;
} else {
var G__65620 = cljs.core.next.call(null,seq__65302_65606__$1);
var G__65621 = null;
var G__65622 = (0);
var G__65623 = (0);
seq__65302_65590 = G__65620;
chunk__65305_65591 = G__65621;
count__65306_65592 = G__65622;
i__65307_65593 = G__65623;
continue;
}
}
} else {
}
}
break;
}


var G__65624 = cljs.core.next.call(null,seq__65207__$1);
var G__65625 = null;
var G__65626 = (0);
var G__65627 = (0);
seq__65207 = G__65624;
chunk__65209 = G__65625;
count__65210 = G__65626;
i__65211 = G__65627;
continue;
} else {
var G__65628 = cljs.core.next.call(null,seq__65207__$1);
var G__65629 = null;
var G__65630 = (0);
var G__65631 = (0);
seq__65207 = G__65628;
chunk__65209 = G__65629;
count__65210 = G__65630;
i__65211 = G__65631;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace.call(null,s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.call(null,shadow.cljs.devtools.client.env.repl_error.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product.call(null),new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root.call(null));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.call(null,"undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__65352){
var map__65353 = p__65352;
var map__65353__$1 = (((((!((map__65353 == null))))?(((((map__65353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65353.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65353):map__65353);
var id = cljs.core.get.call(null,map__65353__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.call(null,map__65353__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call.call(null,((function (map__65353,map__65353__$1,id,js){
return (function (){
return shadow.cljs.devtools.client.browser.global_eval.call(null,js);
});})(map__65353,map__65353__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg.call(null,cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__65360,done){
var map__65361 = p__65360;
var map__65361__$1 = (((((!((map__65361 == null))))?(((((map__65361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65361):map__65361);
var msg = map__65361__$1;
var id = cljs.core.get.call(null,map__65361__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.call(null,map__65361__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.call(null,map__65361__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.call(null,map__65361__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,((function (map__65361,map__65361__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__65366){
var map__65367 = p__65366;
var map__65367__$1 = (((((!((map__65367 == null))))?(((((map__65367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65367.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65367):map__65367);
var src = map__65367__$1;
var provides = cljs.core.get.call(null,map__65367__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4120__auto__ = shadow.cljs.devtools.client.env.src_is_loaded_QMARK_.call(null,src);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(cljs.core.some.call(null,reload_namespaces,provides));
} else {
return and__4120__auto__;
}
});})(map__65361,map__65361__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_load,((function (sources_to_load,map__65361,map__65361__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load.call(null,sources__$1);

if(cljs.core.seq.call(null,js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires.call(null,js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e65372){var e = e65372;
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {done.call(null);
}});})(sources_to_load,map__65361,map__65361__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__65379,done){
var map__65380 = p__65379;
var map__65380__$1 = (((((!((map__65380 == null))))?(((((map__65380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65380):map__65380);
var repl_state = cljs.core.get.call(null,map__65380__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.call(null,map__65380__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__65380,map__65380__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);

shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"REPL session start successful");

return done.call(null);
});})(map__65380,map__65380__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__65384){
var map__65386 = p__65384;
var map__65386__$1 = (((((!((map__65386 == null))))?(((((map__65386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65386):map__65386);
var id = cljs.core.get.call(null,map__65386__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.call(null,map__65386__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_.call(null,null);
shadow.cljs.devtools.client.browser.stale_client_detected = cljs.core.volatile_BANG_.call(null,false);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__65396,done){
var map__65397 = p__65396;
var map__65397__$1 = (((((!((map__65397 == null))))?(((((map__65397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65397.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65397):map__65397);
var msg = map__65397__$1;
var type = cljs.core.get.call(null,map__65397__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

var G__65405_65647 = type;
var G__65405_65648__$1 = (((G__65405_65647 instanceof cljs.core.Keyword))?G__65405_65647.fqn:null);
switch (G__65405_65648__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch.call(null,msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke.call(null,msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require.call(null,msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns.call(null,msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

shadow.cljs.devtools.client.browser.handle_build_complete.call(null,msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end.call(null);

shadow.cljs.devtools.client.hud.hud_error.call(null,msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide.call(null);

shadow.cljs.devtools.client.hud.load_start.call(null);

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_.call(null,new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_.call(null,shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return done.call(null);
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.call(null,req.getResponseText());
if(cljs.core.truth_(callback)){
return callback.call(null,actions);
} else {
return null;
}
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)),({"content-type": "application/edn; charset=utf-8"}));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_status !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_status = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword(null,"init","init",-1875481434));
}
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status).call(null,new cljs.core.Keyword(null,"init","init",-1875481434)))){
return shadow.cljs.devtools.client.browser.ws_connect_impl.call(null);
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.maybe_reconnect = (function shadow$cljs$devtools$client$browser$maybe_reconnect(){
if(((cljs.core.not(cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.stale_client_detected))) && (cljs.core.not_EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status),new cljs.core.Keyword(null,"init","init",-1875481434))))){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"init","init",-1875481434));

return setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(3000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect_impl = (function shadow$cljs$devtools$client$browser$ws_connect_impl(){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connecting","connecting",-1347943866));

try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url.call(null,new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg.call(null,e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connected","connected",-169833045));

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error.call(null,(function (){var or__4131__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);

shadow.cljs.devtools.client.env.reset_print_fns_BANG_.call(null);

return shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);
});})(print_fn,ws_url,socket))
;

return socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error.call(null,"Connection failed!");

shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"websocket error",e);
});})(print_fn,ws_url,socket))
;
}catch (e65424){var e = e65424;
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket setup failed",e);
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5720__auto___65684 = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto___65684)){
var s_65685 = temp__5720__auto___65684;
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"connection reset!");

s_65685.onclose = ((function (s_65685,temp__5720__auto___65684){
return (function (e){
return null;
});})(s_65685,temp__5720__auto___65684))
;

s_65685.close();

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var s = temp__5720__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4120__auto__ = document;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.call(null,"loading",document.readyState);
} else {
return and__4120__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
