goog.provide('fulcro.util');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.walk');
goog.require('fulcro.logging');
fulcro.util.force_children = (function fulcro$util$force_children(x){
var G__54696 = x;
if(cljs.core.seq_QMARK_.call(null,x)){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,fulcro.util.force_children),G__54696);
} else {
return G__54696;
}
});
fulcro.util.union_QMARK_ = (function fulcro$util$union_QMARK_(expr){
var expr__$1 = (function (){var G__54699 = expr;
if(cljs.core.seq_QMARK_.call(null,expr)){
return cljs.core.first.call(null,G__54699);
} else {
return G__54699;
}
})();
return ((cljs.core.map_QMARK_.call(null,expr__$1)) && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,cljs.core.first.call(null,expr__$1)))));
});
fulcro.util.join_QMARK_ = (function fulcro$util$join_QMARK_(x){
var x__$1 = ((cljs.core.seq_QMARK_.call(null,x))?cljs.core.first.call(null,x):x);
return cljs.core.map_QMARK_.call(null,x__$1);
});
/**
 * Returns true if x is an ident.
 */
fulcro.util.ident_QMARK_ = (function fulcro$util$ident_QMARK_(x){
return ((cljs.core.vector_QMARK_.call(null,x)) && (((2) === cljs.core.count.call(null,x))) && ((cljs.core.nth.call(null,x,(0)) instanceof cljs.core.Keyword)));
});
fulcro.util.join_entry = (function fulcro$util$join_entry(expr){
var vec__54723 = ((cljs.core.seq_QMARK_.call(null,expr))?cljs.core.ffirst.call(null,expr):cljs.core.first.call(null,expr));
var k = cljs.core.nth.call(null,vec__54723,(0),null);
var v = cljs.core.nth.call(null,vec__54723,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core.list_QMARK_.call(null,k))?cljs.core.first.call(null,k):k),v], null);
});
fulcro.util.join_key = (function fulcro$util$join_key(expr){
if(cljs.core.map_QMARK_.call(null,expr)){
var k = cljs.core.ffirst.call(null,expr);
if(cljs.core.list_QMARK_.call(null,k)){
return cljs.core.first.call(null,k);
} else {
return cljs.core.ffirst.call(null,expr);
}
} else {
if(cljs.core.seq_QMARK_.call(null,expr)){
return fulcro.util.join_key.call(null,cljs.core.first.call(null,expr));
} else {
return expr;

}
}
});
fulcro.util.join_value = (function fulcro$util$join_value(join){
return cljs.core.second.call(null,fulcro.util.join_entry.call(null,join));
});
fulcro.util.mutation_join_QMARK_ = (function fulcro$util$mutation_join_QMARK_(expr){
return ((fulcro.util.join_QMARK_.call(null,expr)) && ((fulcro.util.join_key.call(null,expr) instanceof cljs.core.Symbol)));
});
fulcro.util.unique_ident_QMARK_ = (function fulcro$util$unique_ident_QMARK_(x){
return ((fulcro.util.ident_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"_","_",-1201019570,null),cljs.core.second.call(null,x))));
});
fulcro.util.recursion_QMARK_ = (function fulcro$util$recursion_QMARK_(x){
return ((cljs.core.symbol_identical_QMARK_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),x)) || (typeof x === 'number'));
});
fulcro.util.mutation_QMARK_ = (function fulcro$util$mutation_QMARK_(expr){
return ((fulcro.util.mutation_join_QMARK_.call(null,expr)) || (((function (){var G__54762 = expr;
if(cljs.core.seq_QMARK_.call(null,expr)){
return cljs.core.first.call(null,G__54762);
} else {
return G__54762;
}
})() instanceof cljs.core.Symbol)));
});
fulcro.util.mutation_key = (function fulcro$util$mutation_key(expr){
if((cljs.core.first.call(null,expr) instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? (first expr))"));
}

return cljs.core.first.call(null,expr);
});
/**
 * Get a unique string-based key. Never returns the same value.
 */
fulcro.util.unique_key = (function fulcro$util$unique_key(){
var s = cljs.core.random_uuid.call(null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(s);
});
fulcro.util.atom_QMARK_ = (function fulcro$util$atom_QMARK_(a){
return (a instanceof cljs.core.Atom);
});
fulcro.util.deep_merge = (function fulcro$util$deep_merge(var_args){
var args__4736__auto__ = [];
var len__4730__auto___54883 = arguments.length;
var i__4731__auto___54884 = (0);
while(true){
if((i__4731__auto___54884 < len__4730__auto___54883)){
args__4736__auto__.push((arguments[i__4731__auto___54884]));

var G__54885 = (i__4731__auto___54884 + (1));
i__4731__auto___54884 = G__54885;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (xs){

if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,xs)){
return cljs.core.apply.call(null,cljs.core.merge_with,fulcro.util.deep_merge,xs);
} else {
return cljs.core.last.call(null,xs);
}
});

fulcro.util.deep_merge.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.util.deep_merge.cljs$lang$applyTo = (function (seq54771){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54771));
});

fulcro.util.conform_BANG_ = (function fulcro$util$conform_BANG_(spec,x){
var rt = cljs.spec.alpha.conform.call(null,spec,x);
if(cljs.spec.alpha.invalid_QMARK_.call(null,rt)){
throw cljs.core.ex_info.call(null,cljs.spec.alpha.explain_str.call(null,spec,x),cljs.spec.alpha.explain_data.call(null,spec,x));
} else {
}

return rt;
});
/**
 * Logs the given message if v is false.
 */
fulcro.util.soft_invariant = (function fulcro$util$soft_invariant(v,msg){
if(cljs.core.truth_(v)){
return null;
} else {
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.util",new cljs.core.Keyword(null,"line","line",212345235),104], null),new cljs.core.Keyword(null,"error","error",-978969032),"Invariant failed");
}catch (e54783){if((e54783 instanceof Error)){
var e__54502__auto__ = e54783;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.util",new cljs.core.Keyword(null,"line","line",212345235),104], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e54783;

}
}}
});
/**
 * DO NOT USE!
 * 
 *   This logic is held here because it was originally in
 *   fulcro.client.primitives, but we wanted to deprecate that, move it into
 *   fulcro.client.mutations, and reference the mutations implementation from
 *   primitives. However the mutations namespace already depends on the primitives
 *   namespace. So we put the logic here and reference it from both places.
 */
fulcro.util.__integrate_ident_impl__ = (function fulcro$util$__integrate_ident_impl__(var_args){
var args__4736__auto__ = [];
var len__4730__auto___54897 = arguments.length;
var i__4731__auto___54902 = (0);
while(true){
if((i__4731__auto___54902 < len__4730__auto___54897)){
args__4736__auto__.push((arguments[i__4731__auto___54902]));

var G__54904 = (i__4731__auto___54902 + (1));
i__4731__auto___54902 = G__54904;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.util.__integrate_ident_impl__.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.util.__integrate_ident_impl__.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__54811){
var vec__54812 = p__54811;
var command = cljs.core.nth.call(null,vec__54812,(0),null);
var data_path = cljs.core.nth.call(null,vec__54812,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__54812,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__54812,command,data_path,actions){
return (function (p1__54794_SHARP_){
return cljs.core._EQ_.call(null,p1__54794_SHARP_,ident);
});})(vec__54812,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__54812,command,data_path,actions))
;
var G__54816 = command;
var G__54816__$1 = (((G__54816 instanceof cljs.core.Keyword))?G__54816.fqn:null);
switch (G__54816__$1) {
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
return cljs.core.update_in.call(null,state__$1,data_path,((function (G__54816,G__54816__$1,already_has_ident_at_path_QMARK_,vec__54812,command,data_path,actions){
return (function (p1__54795_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__54795_SHARP_);
});})(G__54816,G__54816__$1,already_has_ident_at_path_QMARK_,vec__54812,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = ((cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector))));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join(''),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join(''),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.util.__integrate_ident_impl__.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.util.__integrate_ident_impl__.cljs$lang$applyTo = (function (seq54796){
var G__54797 = cljs.core.first.call(null,seq54796);
var seq54796__$1 = cljs.core.next.call(null,seq54796);
var G__54798 = cljs.core.first.call(null,seq54796__$1);
var seq54796__$2 = cljs.core.next.call(null,seq54796__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54797,G__54798,seq54796__$2);
});


//# sourceMappingURL=fulcro.util.js.map
