goog.provide('com.wsscode.fuzzy');
goog.require('cljs.core');
goog.require('com.wsscode.fuzzyjs');
goog.require('cljs.spec.alpha');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.fuzzy","sort?","com.wsscode.fuzzy/sort?",1163052809),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.fuzzy","search-input","com.wsscode.fuzzy/search-input",897823168),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),cljs.core.string_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.fuzzy","options","com.wsscode.fuzzy/options",773495630),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null))),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("s","keys","s/keys",-1586011188,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__66035){
return cljs.core.map_QMARK_.call(null,G__66035);
}),(function (G__66035){
return cljs.core.contains_QMARK_.call(null,G__66035,new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815));
})], null),(function (G__66035){
return ((cljs.core.map_QMARK_.call(null,G__66035)) && (cljs.core.contains_QMARK_.call(null,G__66035,new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815))));
}),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)))], null),null])),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__66034){
return cljs.core.coll_QMARK_.call(null,G__66034);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815)], null)))], null),null));
/**
 * Matches ::search-input with ::string from map. When match is valid the map is
 *   augmented with the keys ::match? ::match-score and ::match-hl.
 * 
 *   ```clojure
 *   (fuzzy/match-one {::fuzzy/search-input "a"} {::fuzzy/string "abc"})
 *   ; => {::fuzzy/string      "abc"
 *   ;     ::fuzzy/match?      true
 *   ;     ::fuzzy/match-score 8
 *   ;     ::fuzzy/match-hl    "<b>a</b>bc"}
 *   ```
 */
com.wsscode.fuzzy.match_one = (function com$wsscode$fuzzy$match_one(p__66054,p__66055){
var map__66056 = p__66054;
var map__66056__$1 = (((((!((map__66056 == null))))?(((((map__66056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66056.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66056):map__66056);
var search_input = cljs.core.get.call(null,map__66056__$1,new cljs.core.Keyword("com.wsscode.fuzzy","search-input","com.wsscode.fuzzy/search-input",897823168));
var map__66057 = p__66055;
var map__66057__$1 = (((((!((map__66057 == null))))?(((((map__66057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66057):map__66057);
var opt = map__66057__$1;
var string = cljs.core.get.call(null,map__66057__$1,new cljs.core.Keyword("com.wsscode.fuzzy","string","com.wsscode.fuzzy/string",320074815));
var vec__66066 = com.wsscode.fuzzyjs.fuzzy_match(search_input,string);
var match_QMARK_ = cljs.core.nth.call(null,vec__66066,(0),null);
var score = cljs.core.nth.call(null,vec__66066,(1),null);
var hl = cljs.core.nth.call(null,vec__66066,(2),null);
if(cljs.core.truth_(match_QMARK_)){
return cljs.core.assoc.call(null,opt,new cljs.core.Keyword("com.wsscode.fuzzy","match?","com.wsscode.fuzzy/match?",1344922817),match_QMARK_,new cljs.core.Keyword("com.wsscode.fuzzy","match-score","com.wsscode.fuzzy/match-score",-1700262252),score,new cljs.core.Keyword("com.wsscode.fuzzy","match-hl","com.wsscode.fuzzy/match-hl",-611317739),hl);
} else {
return null;
}
});
/**
 * Search for all matches of ::search-input in ::options. Options must be a collection
 *   of maps, the map key ::string will be used to make the lookup. By default the
 *   results will be sorted by score, use ::sort? false to keep original order.
 */
com.wsscode.fuzzy.fuzzy_match = (function com$wsscode$fuzzy$fuzzy_match(p__66075){
var map__66077 = p__66075;
var map__66077__$1 = (((((!((map__66077 == null))))?(((((map__66077.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66077.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66077):map__66077);
var input = map__66077__$1;
var options = cljs.core.get.call(null,map__66077__$1,new cljs.core.Keyword("com.wsscode.fuzzy","options","com.wsscode.fuzzy/options",773495630));
var search_input = cljs.core.get.call(null,map__66077__$1,new cljs.core.Keyword("com.wsscode.fuzzy","search-input","com.wsscode.fuzzy/search-input",897823168));
var sort_QMARK_ = cljs.core.get.call(null,map__66077__$1,new cljs.core.Keyword("com.wsscode.fuzzy","sort?","com.wsscode.fuzzy/sort?",1163052809),true);
if(cljs.core.seq.call(null,search_input)){
var fuzzy = cljs.core.partial.call(null,com.wsscode.fuzzy.match_one,input);
var compare = ((function (fuzzy,map__66077,map__66077__$1,input,options,search_input,sort_QMARK_){
return (function (p1__66073_SHARP_,p2__66072_SHARP_){
return cljs.core.compare.call(null,p2__66072_SHARP_,p1__66073_SHARP_);
});})(fuzzy,map__66077,map__66077__$1,input,options,search_input,sort_QMARK_))
;
var _LT__GT_ = options;
var _LT__GT___$1 = cljs.core.keep.call(null,fuzzy,_LT__GT_);
var G__66080 = _LT__GT___$1;
if(cljs.core.truth_(sort_QMARK_)){
return cljs.core.sort_by.call(null,new cljs.core.Keyword("com.wsscode.fuzzy","match-score","com.wsscode.fuzzy/match-score",-1700262252),compare,G__66080);
} else {
return G__66080;
}
} else {
return options;
}
});

//# sourceMappingURL=com.wsscode.fuzzy.js.map
