goog.provide('fulcro.client.data_fetch');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.client.impl.data_targeting');
goog.require('fulcro.client.mutations');
goog.require('fulcro.logging');
goog.require('fulcro.client');
goog.require('fulcro.util');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.spec.alpha');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.data-fetch","target","fulcro.client.data-fetch/target",-970395030),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_);



fulcro.client.data_fetch.bool_QMARK_ = (function fulcro$client$data_fetch$bool_QMARK_(v){
return cljs.core.boolean_QMARK_.call(null,v);
});
/**
 * The name of the table in which fulcro load markers are stored
 */
fulcro.client.data_fetch.marker_table = fulcro.client.impl.data_fetch.marker_table;
fulcro.client.data_fetch.multiple_targets = (function fulcro$client$data_fetch$multiple_targets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___67812 = arguments.length;
var i__4731__auto___67814 = (0);
while(true){
if((i__4731__auto___67814 < len__4730__auto___67812)){
args__4736__auto__.push((arguments[i__4731__auto___67814]));

var G__67816 = (i__4731__auto___67814 + (1));
i__4731__auto___67814 = G__67816;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.data_fetch.multiple_targets.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.data_fetch.multiple_targets.cljs$core$IFn$_invoke$arity$variadic = (function (targets){
return cljs.core.apply.call(null,fulcro.client.impl.data_targeting.multiple_targets,targets);
});

fulcro.client.data_fetch.multiple_targets.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.data_fetch.multiple_targets.cljs$lang$applyTo = (function (seq67450){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67450));
});

fulcro.client.data_fetch.prepend_to = (function fulcro$client$data_fetch$prepend_to(target){
return fulcro.client.impl.data_targeting.prepend_to.call(null,target);
});
fulcro.client.data_fetch.append_to = (function fulcro$client$data_fetch$append_to(target){
return fulcro.client.impl.data_targeting.append_to.call(null,target);
});
fulcro.client.data_fetch.replace_at = (function fulcro$client$data_fetch$replace_at(target){
return fulcro.client.impl.data_targeting.replace_at.call(null,target);
});
/**
 * Remove items from a query when the query element where the (node-predicate key) returns true. Commonly used with
 * a set as a predicate to elide specific well-known UI-only paths.
 */
fulcro.client.data_fetch.elide_query_nodes = (function fulcro$client$data_fetch$elide_query_nodes(query,node_predicate){
return fulcro.client.primitives.ast__GT_query.call(null,fulcro.client.impl.data_fetch.elide_ast_nodes.call(null,fulcro.client.primitives.query__GT_ast.call(null,query),node_predicate));
});
/**
 * Computes the refresh for the load by ensuring the loaded data is on the
 *   list of things to re-render.
 */
fulcro.client.data_fetch.computed_refresh = (function fulcro$client$data_fetch$computed_refresh(explicit_refresh,load_key,target){
return cljs.core.vec.call(null,(function (){var result = cljs.core.conj.call(null,cljs.core.set.call(null,explicit_refresh));
var result__$1 = (((((target == null)) || (fulcro.util.ident_QMARK_.call(null,load_key))))?cljs.core.conj.call(null,result,load_key):result);
var add_target = ((function (result,result__$1){
return (function (r,t){
if(((cljs.core.vector_QMARK_.call(null,t)) && ((cljs.core.count.call(null,t) >= (2))))){
return cljs.core.conj.call(null,r,cljs.core.vec.call(null,cljs.core.take.call(null,(2),t)));
} else {
if(cljs.core.vector_QMARK_.call(null,t)){
return cljs.core.conj.call(null,r,cljs.core.first.call(null,t));
} else {
return cljs.core.conj.call(null,r,t);

}
}
});})(result,result__$1))
;
if(fulcro.client.impl.data_fetch.multiple_targets_QMARK_.call(null,target)){
return cljs.core.reduce.call(null,((function (result,result__$1,add_target){
return (function (refresh,t){
return add_target(refresh,t);
});})(result,result__$1,add_target))
,result__$1,target);
} else {
if(cljs.core.truth_(target)){
return add_target(result__$1,target);
} else {
return result__$1;

}
}
})());
});
/**
 * Internal function to validate and process the parameters of `load` and `load-action`.
 */
fulcro.client.data_fetch.load_params_STAR_ = (function fulcro$client$data_fetch$load_params_STAR_(state_map,server_property_or_ident,class_or_factory,p__67458){
var map__67460 = p__67458;
var map__67460__$1 = (((((!((map__67460 == null))))?(((((map__67460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67460):map__67460);
var target = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"target","target",253001721));
var abort_id = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819));
var remote = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"remote","remote",-1593576576));
var update_query = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"update-query","update-query",-1566885791));
var refresh = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128),false);
var fallback = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"marker","marker",865118313),true);
var params = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"params","params",710516235));
var post_mutation = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY);
var initialize = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"initialize","initialize",609952913),false);
var post_mutation_params = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
var focus = cljs.core.get.call(null,map__67460__$1,new cljs.core.Keyword(null,"focus","focus",234677911));
if((((target == null)) || (cljs.core.vector_QMARK_.call(null,target)))){
} else {
throw (new Error("Assert failed: (or (nil? target) (vector? target))"));
}

if((((post_mutation == null)) || ((post_mutation instanceof cljs.core.Symbol)))){
} else {
throw (new Error("Assert failed: (or (nil? post-mutation) (symbol? post-mutation))"));
}

if((((fallback == null)) || ((fallback instanceof cljs.core.Symbol)))){
} else {
throw (new Error("Assert failed: (or (nil? fallback) (symbol? fallback))"));
}

if((((post_mutation_params == null)) || (cljs.core.map_QMARK_.call(null,post_mutation_params)))){
} else {
throw (new Error("Assert failed: (or (nil? post-mutation-params) (map? post-mutation-params))"));
}

if(cljs.core.vector_QMARK_.call(null,refresh)){
} else {
throw (new Error("Assert failed: (vector? refresh)"));
}

if((((params == null)) || (cljs.core.map_QMARK_.call(null,params)))){
} else {
throw (new Error("Assert failed: (or (nil? params) (map? params))"));
}

if(cljs.core.set_QMARK_.call(null,without)){
} else {
throw (new Error("Assert failed: (set? without)"));
}

if((((focus == null)) || (cljs.core.vector_QMARK_.call(null,focus)))){
} else {
throw (new Error("Assert failed: (or (nil? focus) (vector? focus))"));
}

if(((fulcro.util.ident_QMARK_.call(null,server_property_or_ident)) || ((server_property_or_ident instanceof cljs.core.Keyword)))){
} else {
throw (new Error("Assert failed: (or (util/ident? server-property-or-ident) (keyword? server-property-or-ident))"));
}

var query_SINGLEQUOTE_ = (cljs.core.truth_(class_or_factory)?(function (){var G__67465 = fulcro.client.primitives.get_query.call(null,class_or_factory,state_map);
var G__67465__$1 = (cljs.core.truth_(focus)?fulcro.client.primitives.focus_subquery.call(null,G__67465,focus):G__67465);
if(cljs.core.truth_(update_query)){
return update_query.call(null,G__67465__$1);
} else {
return G__67465__$1;
}
})():null);
var query = (cljs.core.truth_((function (){var and__4120__auto__ = class_or_factory;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.map_QMARK_.call(null,params);
} else {
return and__4120__auto__;
}
})())?cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,server_property_or_ident,null,(1),null)),(new cljs.core.List(null,query_SINGLEQUOTE_,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,params,null,(1),null))))),null,(1),null)))))):(cljs.core.truth_(class_or_factory)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([server_property_or_ident,query_SINGLEQUOTE_])], null):((cljs.core.map_QMARK_.call(null,params))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.List(null,server_property_or_ident,(new cljs.core.List(null,params,null,(1),null)),(2),null))], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [server_property_or_ident], null)
)));
var marker__$1 = ((((marker === true) && (fulcro.client.impl.data_fetch.special_target_QMARK_.call(null,target))))?(function (){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),90], null),new cljs.core.Keyword(null,"warn","warn",-436710552),["Load of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_property_or_ident),": Boolean load marker not allowed. Turned off so load target will not overwrite a to-many relation. To fix this warning, set :marker to false or a marker ID."].join(''));
}catch (e67468){if((e67468 instanceof Error)){
var e__54502__auto___67826 = e67468;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),90], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___67826);
} else {
throw e67468;

}
}
return false;
})()
:marker);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.Keyword(null,"parallel","parallel",-1863607128),new cljs.core.Keyword(null,"fallback","fallback",761637929),new cljs.core.Keyword(null,"marker","marker",865118313),new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Keyword(null,"without","without",1107036688),new cljs.core.Keyword(null,"initialize","initialize",609952913),new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),new cljs.core.Keyword(null,"focus","focus",234677911),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"abort-id","abort-id",1559937819)],[remote,fulcro.client.data_fetch.computed_refresh.call(null,refresh,server_property_or_ident,target),parallel,fallback,marker__$1,post_mutation,without,(cljs.core.truth_((function (){var and__4120__auto__ = initialize;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = class_or_factory;
if(cljs.core.truth_(and__4120__auto____$1)){
return server_property_or_ident;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())?(function (){var class$ = (function (){var temp__5718__auto__ = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,class_or_factory));
if(cljs.core.truth_(temp__5718__auto__)){
var c = temp__5718__auto__;
return c;
} else {
return class_or_factory;
}
})();
return cljs.core.PersistentArrayMap.createAsIfByAssoc([server_property_or_ident,((cljs.core.map_QMARK_.call(null,initialize))?initialize:(cljs.core.truth_((function (){var and__4120__auto__ = initialize;
if(cljs.core.truth_(and__4120__auto__)){
return fulcro.client.primitives.has_initial_app_state_QMARK_.call(null,class$);
} else {
return and__4120__auto__;
}
})())?fulcro.client.primitives.get_initial_state.call(null,class$,cljs.core.PersistentArrayMap.EMPTY):cljs.core.PersistentArrayMap.EMPTY
))]);
})():null),post_mutation_params,focus,target,query,abort_id]);
});
/**
 * Generates a transaction expression for a load mutation. It includes a follow-on read for :ui/loading-data. The args
 *   must be a map of the parameters usable from `load`. Returns a complete tx (as a vector), not just the mutation
 *   since follow-on reads are part of the mutation. You may use `concat` to join this with additional expressions.
 */
fulcro.client.data_fetch.load_mutation = (function fulcro$client$data_fetch$load_mutation(load_args){
if((((new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(load_args) == null)) || (cljs.core.vector_QMARK_.call(null,new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(load_args))))){
} else {
throw (new Error("Assert failed: (or (nil? (:refresh load-args)) (vector? (:refresh load-args)))"));
}

var refresh = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(load_args);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.List(null,new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null),(new cljs.core.List(null,load_args,null,(1),null)),(2),null)),new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143)], null),refresh);
});
/**
 * Load data from the server.
 * 
 *   This function triggers a server interaction and normalizes the server response into your app state database. During
 *   operation it also adds (by default) fetch markers into the app state so you can show busy indicators on the UI
 *   components that are waiting for data. The `:target` parameter can be used to place the data somewhere besides app
 *   state root (which is the default).
 * 
 *   The server will receive a query of the form: [({server-property (prim/get-query class-or-factory)} params)], which
 *   a Fulcro parser will correctly parse as a join on server-property with the given subquery and params. See the AST and
 *   instructions on parsing queries in the developer's guide.
 * 
 *   Parameters:
 *   - `app-or-comp-or-reconciler` : A component instance, Fulcro application, or reconciler
 *   - `server-property-or-ident` : A keyword or ident that represents the root of the query to send to the server. If this is an ident
 *   you are loading a specific entity from the database into a local app db table. A custom target will be ignored.
 *   - `class-or-factory` : A component that implements IQuery, or a factory for it (if using dynamic queries). This will be combined with `server-property` into a join for the server query. Needed to normalize results.
 *  class-or-factory can be nil, in which case the resulting server query will not be a join.
 *   - `config` : A map of load configuration parameters.
 * 
 *   Config (all optional):
 *   - `target` - An assoc-in path at which to put the result of the Subquery (as an edge (normalized) or value (not normalized)).
 *  Can also be special targets (multiple-targets, append-to,
 *  prepend-to, or replace-at). If you are loading by keyword (into root), then this relocates the result (ident or value) after load.
 *  When loading an entity (by ident), then this option will place additional idents at the target path(s) that point to that entity.
 *   - `initialize` - Optional. If `true`, uses `get-initial-state` on class-or-factory to  get a basis for merge of the result. This allows you
 *  to use initial state to pre-populate loads with things like UI concerns. If `:initialize` is passed a map, then it uses that as
 *  the base target merge value for class-or-factory instead.
 *   - `remote` - Optional. Keyword name of the remote that this load should come from.
 *   - `params` - Optional parameters to add to the generated query
 *   - `marker` - ID of marker. Normalizes a load marker into app state so you can see progress.
 *   - `refresh` - A vector of keywords that will cause component re-renders after the final load/mutations. Same as follow-on
 *   reads in normal `transact!`
 *   - `parallel` - If true, indicates that this load does not have to go through the sequential network queue. Defaults to false.
 *   - `post-mutation` - A mutation (symbol) to run after the data is merged. Note, if target is supplied be sure your post mutation
 *   should expect the data at the targeted location. The `env` of that mutation will be the env of the load (if available), but will also include `:load-request`.
 *   - `post-mutation-params` - An optional map  that will be passed to the post-mutation when it is called. May only contain raw data, not code!
 *   - `fallback` - A mutation (symbol) to run if there is a server/network error. The `env` of the fallback will be the env of the load (if available), but will also include `:load-request`.
 *   - `update-query` - A optional function that can transform the component query before sending to remote.
 *    For example, to focus a subquery using update-query:
 *        {:update-query #(prim/focus-subquery % [:my {:sub [:query]}])}
 * 
 *    Removing properties (like previous :without option):
 *        {:update-query #(df/elide-query-nodes % #{:my :elisions})}
 *   - `focus` - An optional subquery to focus on some parts of the original query.
 *   - `without` - An optional set of keywords that should (recursively) be removed from the query.
 *   - `abort-id` - An ID (typically a keyword) that you can use to cancel the load via `fulcro.client/abort`.
 * 
 *   Notes on UI Refresh:
 *   The refresh list will automatically include what you load (as a non-duplicate):
 *   - When target is set and has 2+ elements: refresh will include an ident of the first two elements
 *   - e.g. `:target [:a 1 :thing]` -> `:refresh [[:a 1]]`
 *   - When target has a single element, refresh will include that element as a keyword
 *   - e.g. `:target [:thing]` -> `:refresh [:thing]`
 *   - When there is no target:
 *   - If prop-or-ident is a kw -> `:refresh [kw]`
 *   - If prop-or-ident is an ident -> `:refresh [ident]`
 *   In all cases, any explicit refresh things you include will not be dropped. The computed refresh list
 *   is essentially a `(-> original-refresh-list set add-computed-bits vec)`.
 *   
 */
fulcro.client.data_fetch.load = (function fulcro$client$data_fetch$load(var_args){
var G__67476 = arguments.length;
switch (G__67476) {
case 3:
return fulcro.client.data_fetch.load.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.client.data_fetch.load.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.data_fetch.load.cljs$core$IFn$_invoke$arity$3 = (function (app_or_comp_or_reconciler,server_property_or_ident,class_or_factory){
return fulcro.client.data_fetch.load.call(null,app_or_comp_or_reconciler,server_property_or_ident,class_or_factory,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.client.data_fetch.load.cljs$core$IFn$_invoke$arity$4 = (function (app_or_comp_or_reconciler,server_property_or_ident,class_or_factory,config){
if((function (){var or__4131__auto__ = fulcro.client.primitives.component_QMARK_.call(null,app_or_comp_or_reconciler);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = fulcro.client.primitives.reconciler_QMARK_.call(null,app_or_comp_or_reconciler);
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
if((!((app_or_comp_or_reconciler == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === app_or_comp_or_reconciler.fulcro$client$FulcroApplication$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
}
})()){
} else {
throw (new Error("Assert failed: (or (prim/component? app-or-comp-or-reconciler) (prim/reconciler? app-or-comp-or-reconciler) (implements? fc/FulcroApplication app-or-comp-or-reconciler))"));
}

var component_or_reconciler = (((((!((app_or_comp_or_reconciler == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === app_or_comp_or_reconciler.fulcro$client$FulcroApplication$))))?true:false):false))?cljs.core.get.call(null,app_or_comp_or_reconciler,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966)):app_or_comp_or_reconciler);
var reconciler = fulcro.client.primitives.any__GT_reconciler.call(null,component_or_reconciler);
var map__67485 = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(reconciler);
var map__67485__$1 = (((((!((map__67485 == null))))?(((((map__67485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67485.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67485):map__67485);
var load_marker_default = cljs.core.get.call(null,map__67485__$1,new cljs.core.Keyword(null,"load-marker-default","load-marker-default",335781105));
var query_transform_default = cljs.core.get.call(null,map__67485__$1,new cljs.core.Keyword(null,"query-transform-default","query-transform-default",-1684574273));
var config__$1 = cljs.core.merge.call(null,(function (){var G__67489 = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"marker","marker",865118313),load_marker_default,new cljs.core.Keyword(null,"parallel","parallel",-1863607128),false,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY], null);
if(cljs.core.truth_(query_transform_default)){
return cljs.core.assoc.call(null,G__67489,new cljs.core.Keyword(null,"update-query","update-query",-1566885791),query_transform_default);
} else {
return G__67489;
}
})(),config);
var state = fulcro.client.primitives.app_state.call(null,reconciler);
var mutation_args = fulcro.client.data_fetch.load_params_STAR_.call(null,cljs.core.deref.call(null,state),server_property_or_ident,class_or_factory,config__$1);
return fulcro.client.primitives.transact_BANG_.call(null,component_or_reconciler,fulcro.client.data_fetch.load_mutation.call(null,mutation_args));
});

fulcro.client.data_fetch.load.cljs$lang$maxFixedArity = 4;

/**
 * 
 *   See `load` for descriptions of parameters and config.
 * 
 *   Queue up a remote load from within an already-running mutation. Similar to `load`, but usable from
 *   within a mutation. IMPORTANT: Make sure you specify the `:remote` parameter to this function, as
 *   well as including a `remote-load` for that remote.
 * 
 *   Note the `:refresh` parameter is supported, and defaults to empty. If you want anything to refresh other than
 *   the targeted component you will want to include the :refresh parameter.
 * 
 *   To use this function make sure your mutation specifies a return value with a remote. The remote
 *   should use the helper function `remote-load` as it's value:
 * 
 *   { :remote (df/remote-load env)
 *     ; NOTE: :remote must be the keyword name of a legal remote in your system; however,
 *     ; You must still name the remote in the `load-action` if it is something other than default.
 *     :action (fn []
 *        (load-action env ...)
 *        ; other optimistic updates/state changes)}
 * 
 *   `env` is the mutation's environment parameter.
 */
fulcro.client.data_fetch.load_action = (function fulcro$client$data_fetch$load_action(var_args){
var G__67493 = arguments.length;
switch (G__67493) {
case 3:
return fulcro.client.data_fetch.load_action.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.client.data_fetch.load_action.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.data_fetch.load_action.cljs$core$IFn$_invoke$arity$3 = (function (env,server_property_or_ident,SubqueryClass){
return fulcro.client.data_fetch.load_action.call(null,env,server_property_or_ident,SubqueryClass,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.client.data_fetch.load_action.cljs$core$IFn$_invoke$arity$4 = (function (env,server_property_or_ident,SubqueryClass,config){
if(((cljs.core.map_QMARK_.call(null,env)) && (cljs.core.contains_QMARK_.call(null,env,new cljs.core.Keyword(null,"state","state",-1988618099))))){
} else {
throw (new Error("Assert failed: (and (map? env) (contains? env :state))"));
}

var reconciler = new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(env);
var map__67495 = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(reconciler);
var map__67495__$1 = (((((!((map__67495 == null))))?(((((map__67495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67495.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67495):map__67495);
var load_marker_default = cljs.core.get.call(null,map__67495__$1,new cljs.core.Keyword(null,"load-marker-default","load-marker-default",335781105));
var query_transform_default = cljs.core.get.call(null,map__67495__$1,new cljs.core.Keyword(null,"query-transform-default","query-transform-default",-1684574273));
var config__$1 = cljs.core.merge.call(null,(function (){var G__67499 = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"marker","marker",865118313),load_marker_default,new cljs.core.Keyword(null,"parallel","parallel",-1863607128),false,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY], null);
if(cljs.core.truth_(query_transform_default)){
return cljs.core.assoc.call(null,G__67499,new cljs.core.Keyword(null,"update-query","update-query",-1566885791),query_transform_default);
} else {
return G__67499;
}
})(),config);
var state_map = cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(env));
return fulcro.client.impl.data_fetch.mark_ready.call(null,cljs.core.assoc.call(null,fulcro.client.data_fetch.load_params_STAR_.call(null,state_map,server_property_or_ident,SubqueryClass,config__$1),new cljs.core.Keyword(null,"env","env",-1815813235),env));
});

fulcro.client.data_fetch.load_action.cljs$lang$maxFixedArity = 4;

/**
 * Load a field of the current component. Runs `prim/transact!`.
 * 
 *   Parameters
 *   - `component`: The component (**instance**, not class). This component MUST have an Ident.
 *   - `field`: A field on the component's query that you wish to load.
 *   - `parameters` : A map of: (will also accept as named parameters)
 * 
 *  - `without`: See `load`
 *  - `params`: See `load`
 *  - `post-mutation`: See `load`
 *  - `post-mutation-params`: See `load`
 *  - `parallel`: See `load`
 *  - `fallback`: See `load`
 *  - `marker`: See `load`
 *  - `update-query`: See `load`
 *  - `remote`: See `load`
 *  - `refresh`: See `load`
 *  - `abort-id`: See `load`
 * 
 *   NOTE: The :ui/loading-data attribute is always included in refresh. This means you probably don't want to
 *   query for that attribute near the root of your UI. Instead, create some leaf component with an ident that queries for :ui/loading-data
 *   using a link  query (e.g. `[:ui/loading-data '_]`). The presence of the ident on components will enable query optimization, which can
 *   improve your frame rate because we will not have to run a full root query.
 * 
 *   WARNING: If you're using dynamic queries, you won't really know what factory your parent is using,
 *   nor can you pass it as a parameter to this function. Therefore, it is not recommended to use load-field from within
 *   a component that has a dynamic query unless you can base it on the original static query (which
 *   is what this function will use).
 *   
 */
fulcro.client.data_fetch.load_field = (function fulcro$client$data_fetch$load_field(var_args){
var args__4736__auto__ = [];
var len__4730__auto___67838 = arguments.length;
var i__4731__auto___67840 = (0);
while(true){
if((i__4731__auto___67840 < len__4730__auto___67838)){
args__4736__auto__.push((arguments[i__4731__auto___67840]));

var G__67841 = (i__4731__auto___67840 + (1));
i__4731__auto___67840 = G__67841;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.client.data_fetch.load_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.client.data_fetch.load_field.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,params){
var params__$1 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,params)))?cljs.core.first.call(null,params):params);
var reconciler = fulcro.client.primitives.any__GT_reconciler.call(null,component);
var map__67505 = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(reconciler);
var map__67505__$1 = (((((!((map__67505 == null))))?(((((map__67505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67505):map__67505);
var load_marker_default = cljs.core.get.call(null,map__67505__$1,new cljs.core.Keyword(null,"load-marker-default","load-marker-default",335781105));
var query_transform_default = cljs.core.get.call(null,map__67505__$1,new cljs.core.Keyword(null,"query-transform-default","query-transform-default",-1684574273));
var map__67506 = params__$1;
var map__67506__$1 = (((((!((map__67506 == null))))?(((((map__67506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67506):map__67506);
var abort_id = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819));
var remote = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"remote","remote",-1593576576));
var update_query = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"update-query","update-query",-1566885791),query_transform_default);
var refresh = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128));
var fallback = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"marker","marker",865118313),load_marker_default);
var params__$2 = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"params","params",710516235));
var post_mutation = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"without","without",1107036688));
var post_mutation_params = cljs.core.get.call(null,map__67506__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
var state_map = (function (){var G__67511 = reconciler;
var G__67511__$1 = (((G__67511 == null))?null:fulcro.client.primitives.app_state.call(null,G__67511));
if((G__67511__$1 == null)){
return null;
} else {
return cljs.core.deref.call(null,G__67511__$1);
}
})();
var query = (function (){var G__67512 = fulcro.client.primitives.focus_query.call(null,fulcro.client.primitives.get_query.call(null,component,state_map),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [field], null));
if(cljs.core.truth_(update_query)){
return update_query.call(null,G__67512);
} else {
return G__67512;
}
})();
if(cljs.core.truth_(fallback)){
if((fallback instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ","Fallback must be a mutation symbol.","\n","(symbol? fallback)"].join('')));
}
} else {
}

return fulcro.client.primitives.transact_BANG_.call(null,component,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.List(null,new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null),(new cljs.core.List(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.Keyword(null,"parallel","parallel",-1863607128),new cljs.core.Keyword(null,"fallback","fallback",761637929),new cljs.core.Keyword(null,"marker","marker",865118313),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Keyword(null,"without","without",1107036688),new cljs.core.Keyword(null,"ident","ident",-742346),new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"abort-id","abort-id",1559937819)],[remote,refresh,parallel,fallback,marker,params__$2,field,post_mutation,without,fulcro.client.primitives.get_ident.call(null,component),post_mutation_params,query,abort_id]),null,(1),null)),(2),null)),new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),new cljs.core.Keyword("ui.fulcro.client.data-fetch.load-markers","by-id","ui.fulcro.client.data-fetch.load-markers/by-id",763321486),fulcro.client.primitives.get_ident.call(null,component)], null),refresh));
});

fulcro.client.data_fetch.load_field.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.client.data_fetch.load_field.cljs$lang$applyTo = (function (seq67500){
var G__67501 = cljs.core.first.call(null,seq67500);
var seq67500__$1 = cljs.core.next.call(null,seq67500);
var G__67502 = cljs.core.first.call(null,seq67500__$1);
var seq67500__$2 = cljs.core.next.call(null,seq67500__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67501,G__67502,seq67500__$2);
});

/**
 * Queue up a remote load of a component's field from within an already-running mutation. Similar to `load-field`
 *   but usable from within a mutation. Note the `:refresh` parameter is supported, and defaults to nothing, even for
 *   fields, in actions. If you want anything to refresh other than the targeted component you will want to use the
 *   :refresh parameter.
 * 
 *   `params` can be a map or named parameters, just like in `load-field`.
 * 
 *   To use this function make sure your mutation specifies a return value with a remote. The remote
 *   should use the helper function `remote-load` as it's value:
 * 
 *   { :remote (df/remote-load env)
 *  ; NOTE: :remote must be the keyword name of a legal remote in your system; however,
 *  ; You must still name the remote in the `load-action` if it is something other than default.
 *  :action (fn []
 *     (load-field-action ...)
 *     ; other optimistic updates/state changes)}
 * 
 *   It is preferable that you use `env` instead of `app-state` for the first argument, as this allows more details to
 *   be available for post mutations and fallbacks.
 *   
 */
fulcro.client.data_fetch.load_field_action = (function fulcro$client$data_fetch$load_field_action(var_args){
var args__4736__auto__ = [];
var len__4730__auto___67858 = arguments.length;
var i__4731__auto___67859 = (0);
while(true){
if((i__4731__auto___67859 < len__4730__auto___67858)){
args__4736__auto__.push((arguments[i__4731__auto___67859]));

var G__67861 = (i__4731__auto___67859 + (1));
i__4731__auto___67859 = G__67861;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return fulcro.client.data_fetch.load_field_action.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

fulcro.client.data_fetch.load_field_action.cljs$core$IFn$_invoke$arity$variadic = (function (env_or_app_state,component_class,ident,field,params){
var params__$1 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,params)))?cljs.core.first.call(null,params):params);
var env_QMARK_ = ((cljs.core.map_QMARK_.call(null,env_or_app_state)) && (cljs.core.contains_QMARK_.call(null,env_or_app_state,new cljs.core.Keyword(null,"state","state",-1988618099))));
var env = ((env_QMARK_)?env_or_app_state:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),env_or_app_state], null));
var map__67522 = ((env_QMARK_)?new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(env)):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"load-marker-default","load-marker-default",335781105),true], null));
var map__67522__$1 = (((((!((map__67522 == null))))?(((((map__67522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67522):map__67522);
var load_marker_default = cljs.core.get.call(null,map__67522__$1,new cljs.core.Keyword(null,"load-marker-default","load-marker-default",335781105));
var query_transform_default = cljs.core.get.call(null,map__67522__$1,new cljs.core.Keyword(null,"query-transform-default","query-transform-default",-1684574273));
var map__67523 = params__$1;
var map__67523__$1 = (((((!((map__67523 == null))))?(((((map__67523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67523):map__67523);
var abort_id = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819));
var remote = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"remote","remote",-1593576576));
var update_query = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"update-query","update-query",-1566885791),query_transform_default);
var refresh = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128));
var fallback = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"marker","marker",865118313),load_marker_default);
var params__$2 = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"params","params",710516235));
var post_mutation = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"without","without",1107036688));
var post_mutation_params = cljs.core.get.call(null,map__67523__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
var state_map = (function (){var G__67537 = env;
var G__67537__$1 = (((G__67537 == null))?null:new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__67537));
if((G__67537__$1 == null)){
return null;
} else {
return cljs.core.deref.call(null,G__67537__$1);
}
})();
var query = (function (){var G__67543 = fulcro.client.primitives.focus_query.call(null,fulcro.client.primitives.get_query.call(null,component_class,state_map),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [field], null));
if(cljs.core.truth_(update_query)){
return update_query.call(null,G__67543);
} else {
return G__67543;
}
})();
if(env_QMARK_){
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),335], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"load-field-action for field ",field," was called with app state instead of env. This is a deprecated usage and some features may not work when using it.");
}catch (e67548){if((e67548 instanceof Error)){
var e__54502__auto___67886 = e67548;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),335], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___67886);
} else {
throw e67548;

}
}}

return fulcro.client.impl.data_fetch.mark_ready.call(null,(function (){var G__67550 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"refresh","refresh",1947415525),new cljs.core.Keyword(null,"parallel","parallel",-1863607128),new cljs.core.Keyword(null,"fallback","fallback",761637929),new cljs.core.Keyword(null,"marker","marker",865118313),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Keyword(null,"without","without",1107036688),new cljs.core.Keyword(null,"ident","ident",-742346),new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"abort-id","abort-id",1559937819)],[remote,refresh,parallel,fallback,marker,params__$2,field,env,post_mutation,without,ident,post_mutation_params,query,abort_id]);
return G__67550;
})());
});

fulcro.client.data_fetch.load_field_action.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
fulcro.client.data_fetch.load_field_action.cljs$lang$applyTo = (function (seq67516){
var G__67517 = cljs.core.first.call(null,seq67516);
var seq67516__$1 = cljs.core.next.call(null,seq67516);
var G__67518 = cljs.core.first.call(null,seq67516__$1);
var seq67516__$2 = cljs.core.next.call(null,seq67516__$1);
var G__67519 = cljs.core.first.call(null,seq67516__$2);
var seq67516__$3 = cljs.core.next.call(null,seq67516__$2);
var G__67520 = cljs.core.first.call(null,seq67516__$3);
var seq67516__$4 = cljs.core.next.call(null,seq67516__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67517,G__67518,G__67519,G__67520,seq67516__$4);
});

/**
 * Returns the correct value for the `:remote` side of a mutation that should act as a
 *   trigger for remote loads. Must be used in conjunction with running `load-action` or
 *   `load-field-action` in the `:action` side of the mutation (which queues the exact things to
 *   load).
 */
fulcro.client.data_fetch.remote_load = (function fulcro$client$data_fetch$remote_load(parsing_env){
var ast = new cljs.core.Keyword(null,"ast","ast",-860334068).cljs$core$IFn$_invoke$arity$1(parsing_env);
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null),new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null));
});
fulcro.client.data_fetch.data_state_QMARK_ = (function fulcro$client$data_fetch$data_state_QMARK_(state){
return fulcro.client.impl.data_fetch.data_state_QMARK_.call(null,state);
});
fulcro.client.data_fetch.ready_QMARK_ = (function fulcro$client$data_fetch$ready_QMARK_(state){
return fulcro.client.impl.data_fetch.ready_QMARK_.call(null,state);
});
fulcro.client.data_fetch.loading_QMARK_ = (function fulcro$client$data_fetch$loading_QMARK_(state){
return fulcro.client.impl.data_fetch.loading_QMARK_.call(null,state);
});
fulcro.client.data_fetch.failed_QMARK_ = (function fulcro$client$data_fetch$failed_QMARK_(state){
return fulcro.client.impl.data_fetch.failed_QMARK_.call(null,state);
});
/**
 * Custom rendering for use while data is being lazily loaded using the data fetch methods
 *   load-collection and load-field.
 * 
 *   `data-render` : the render method to call once the data has been successfully loaded from
 *   the server. Can be a factory method or a React rendering function.
 * 
 *   `props` : the React properties for the element to be loaded.
 * 
 *   Optional:
 * 
 *   `ready-render` : the render method to call when the desired data has been marked as ready
 *   to load, but the server request has not yet been sent.
 * 
 *   `loading-render` : render method once the server request has been sent, and UI is waiting
 *   on the response
 * 
 *   `failed-render` : render method when the server returns a failure state for the requested data
 * 
 *   `not-present-render` : called when props is nil (helpful for differentiating between a nil and
 *   empty response from the server).
 * 
 *   Example Usage:
 * 
 *   ```
 *   (defui Thing
 *  static prim/IQuery
 *  (query [this] [{:thing2 (prim/get-query Thing2)}])
 *  Object
 *  (componentDidMount [this]
 *     (load-field this :thing2))
 * 
 *  (render [this]
 *    (let [thing2 (:thing2 (prim/props this))]
 *      (lazily-loaded ui-thing2 thing2))))
 * 
 *   (defui Thing2
 *  static prim/IQuery
 *  (query [this] [:ui/fetch-state])
 *  Object
 *  (render [this]
 *    (display-thing-2))
 * 
 *   (def ui-thing2 (prim/factory Thing2))
 *   ```
 */
fulcro.client.data_fetch.lazily_loaded = (function fulcro$client$data_fetch$lazily_loaded(var_args){
var args__4736__auto__ = [];
var len__4730__auto___67909 = arguments.length;
var i__4731__auto___67910 = (0);
while(true){
if((i__4731__auto___67910 < len__4730__auto___67909)){
args__4736__auto__.push((arguments[i__4731__auto___67910]));

var G__67911 = (i__4731__auto___67910 + (1));
i__4731__auto___67910 = G__67911;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.client.data_fetch.lazily_loaded.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.client.data_fetch.lazily_loaded.cljs$core$IFn$_invoke$arity$variadic = (function (data_render,props,p__67580){
var map__67582 = p__67580;
var map__67582__$1 = (((((!((map__67582 == null))))?(((((map__67582.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67582.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67582):map__67582);
var ready_render = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"ready-render","ready-render",-1421004936),((function (map__67582,map__67582__$1){
return (function (_){
return "Queued";
});})(map__67582,map__67582__$1))
);
var loading_render = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"loading-render","loading-render",-1821208169),((function (map__67582,map__67582__$1,ready_render){
return (function (_){
return "Loading...";
});})(map__67582,map__67582__$1,ready_render))
);
var failed_render = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"failed-render","failed-render",-433071277),((function (map__67582,map__67582__$1,ready_render,loading_render){
return (function (_){
return "Loading error!";
});})(map__67582,map__67582__$1,ready_render,loading_render))
);
var not_present_render = cljs.core.get.call(null,map__67582__$1,new cljs.core.Keyword(null,"not-present-render","not-present-render",-946766938));
var state = new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(fulcro.client.data_fetch.ready_QMARK_.call(null,state))){
return ready_render.call(null,props);
} else {
if(cljs.core.truth_(fulcro.client.data_fetch.loading_QMARK_.call(null,state))){
return loading_render.call(null,props);
} else {
if(cljs.core.truth_(fulcro.client.data_fetch.failed_QMARK_.call(null,state))){
return failed_render.call(null,props);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = not_present_render;
if(cljs.core.truth_(and__4120__auto__)){
return (props == null);
} else {
return and__4120__auto__;
}
})())){
return not_present_render.call(null,props);
} else {
return data_render.call(null,props);

}
}
}
}
});

fulcro.client.data_fetch.lazily_loaded.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.client.data_fetch.lazily_loaded.cljs$lang$applyTo = (function (seq67571){
var G__67572 = cljs.core.first.call(null,seq67571);
var seq67571__$1 = cljs.core.next.call(null,seq67571);
var G__67573 = cljs.core.first.call(null,seq67571__$1);
var seq67571__$2 = cljs.core.next.call(null,seq67571__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67572,G__67573,seq67571__$2);
});

fulcro.client.data_fetch.refresh_BANG_ = (function fulcro$client$data_fetch$refresh_BANG_(var_args){
var G__67611 = arguments.length;
switch (G__67611) {
case 2:
return fulcro.client.data_fetch.refresh_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return fulcro.client.data_fetch.refresh_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.data_fetch.refresh_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (component,load_options){
return fulcro.client.data_fetch.load.call(null,component,fulcro.client.primitives.get_ident.call(null,component),fulcro.client.primitives.react_type.call(null,component),load_options);
});

fulcro.client.data_fetch.refresh_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (component){
return fulcro.client.data_fetch.load.call(null,component,fulcro.client.primitives.get_ident.call(null,component),fulcro.client.primitives.react_type.call(null,component));
});

fulcro.client.data_fetch.refresh_BANG_.cljs$lang$maxFixedArity = 2;

fulcro.client.data_fetch.load_STAR_ = (function fulcro$client$data_fetch$load_STAR_(env,p__67619){
var map__67646 = p__67619;
var map__67646__$1 = (((((!((map__67646 == null))))?(((((map__67646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67646):map__67646);
var config = map__67646__$1;
var post_mutation = cljs.core.get.call(null,map__67646__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var remote = cljs.core.get.call(null,map__67646__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576));
if(cljs.core.truth_((function (){var and__4120__auto__ = post_mutation;
if(cljs.core.truth_(and__4120__auto__)){
return (!((post_mutation instanceof cljs.core.Symbol)));
} else {
return and__4120__auto__;
}
})())){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),434], null),new cljs.core.Keyword(null,"error","error",-978969032),"post-mutation must be a symbol or nil");
}catch (e67655){if((e67655 instanceof Error)){
var e__54502__auto___67930 = e67655;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),434], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___67930);
} else {
throw e67655;

}
}} else {
}

return cljs.core.PersistentArrayMap.createAsIfByAssoc([(cljs.core.truth_(remote)?remote:new cljs.core.Keyword(null,"remote","remote",-1593576576)),true,new cljs.core.Keyword(null,"action","action",-811238024),((function (map__67646,map__67646__$1,config,post_mutation,remote){
return (function (){
return fulcro.client.impl.data_fetch.mark_ready.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"env","env",-1815813235),env));
});})(map__67646,map__67646__$1,config,post_mutation,remote))
]);
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null),(function (env,_,params){
return fulcro.client.data_fetch.load_STAR_.call(null,env,params);
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.data-fetch","load","fulcro.client.data-fetch/load",-1506599212,null),(function (env,_,params){
return fulcro.client.data_fetch.load_STAR_.call(null,env,params);
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.data-fetch","run-deferred-transaction","fulcro.client.data-fetch/run-deferred-transaction",934105139,null),(function (fulcro_incoming_env,_,p__67687){
var map__67688 = p__67687;
var map__67688__$1 = (((((!((map__67688 == null))))?(((((map__67688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67688.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67688):map__67688);
var tx = cljs.core.get.call(null,map__67688__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var ref = cljs.core.get.call(null,map__67688__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var reconciler = cljs.core.get.call(null,map__67688__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__67688,map__67688__$1,tx,ref,reconciler){
return (function (){
var reconciler__$1 = new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,reconciler));
return setTimeout(((function (reconciler__$1,env,map__67688,map__67688__$1,tx,ref,reconciler){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler__$1,ref,tx);
});})(reconciler__$1,env,map__67688,map__67688__$1,tx,ref,reconciler))
,(1));
});})(env,map__67688,map__67688__$1,tx,ref,reconciler))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.data-fetch","deferred-transaction","fulcro.client.data-fetch/deferred-transaction",574929731,null),(function (fulcro_incoming_env,_,p__67712){
var map__67713 = p__67712;
var map__67713__$1 = (((((!((map__67713 == null))))?(((((map__67713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67713):map__67713);
var tx = cljs.core.get.call(null,map__67713__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var remote = cljs.core.get.call(null,map__67713__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576));
var ref = cljs.core.get.call(null,map__67713__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__67713,map__67713__$1,tx,remote,ref){
return (function (){
var map__67717 = env;
var map__67717__$1 = (((((!((map__67717 == null))))?(((((map__67717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67717):map__67717);
var env__$1 = map__67717__$1;
var reconciler = cljs.core.get.call(null,map__67717__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var component = cljs.core.get.call(null,map__67717__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var reconciler__$1 = (cljs.core.truth_(reconciler)?reconciler:(cljs.core.truth_(component)?fulcro.client.primitives.get_reconciler.call(null,component):null
));
if(cljs.core.truth_(reconciler__$1)){
return fulcro.client.data_fetch.load_action.call(null,env__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","deferred-transaction","fulcro.client.impl.data-fetch/deferred-transaction",1662063962),null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Symbol("fulcro.client.data-fetch","run-deferred-transaction","fulcro.client.data-fetch/run-deferred-transaction",934105139,null),new cljs.core.Keyword(null,"remote","remote",-1593576576),remote,new cljs.core.Keyword(null,"marker","marker",865118313),false,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),reconciler__$1], null))], null)], null));
} else {
try{return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),461], null),new cljs.core.Keyword(null,"error","error",-978969032),"Cannot defer transaction. Reconciler was not available. Tx = ",tx);
}catch (e67730){if((e67730 instanceof Error)){
var e__54502__auto__ = e67730;
return fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),461], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto__);
} else {
throw e67730;

}
}}
});})(env,map__67713,map__67713__$1,tx,remote,ref))
], null);
})(),(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),fulcro.client.data_fetch.remote_load.call(null,env)], null);
})());
}));
fulcro.client.data_fetch.fallback_action_STAR_ = (function fulcro$client$data_fetch$fallback_action_STAR_(env,p__67738){
var map__67739 = p__67738;
var map__67739__$1 = (((((!((map__67739 == null))))?(((((map__67739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67739):map__67739);
var params = map__67739__$1;
var action = cljs.core.get.call(null,map__67739__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var G__67743 = fulcro.client.mutations.mutate.call(null,env,action,cljs.core.dissoc.call(null,params,new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"execute","execute",-129499188)));
var G__67743__$1 = (((G__67743 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__67743));
if((G__67743__$1 == null)){
return null;
} else {
return cljs.core.apply.call(null,G__67743__$1,cljs.core.PersistentVector.EMPTY);
}
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("tx","fallback","tx/fallback",-1892802308,null),(function (p__67755,_,p__67756){
var map__67758 = p__67755;
var map__67758__$1 = (((((!((map__67758 == null))))?(((((map__67758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67758):map__67758);
var env = map__67758__$1;
var target = cljs.core.get.call(null,map__67758__$1,new cljs.core.Keyword(null,"target","target",253001721));
var ast = cljs.core.get.call(null,map__67758__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var ref = cljs.core.get.call(null,map__67758__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var map__67759 = p__67756;
var map__67759__$1 = (((((!((map__67759 == null))))?(((((map__67759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67759):map__67759);
var params = map__67759__$1;
var execute = cljs.core.get.call(null,map__67759__$1,new cljs.core.Keyword(null,"execute","execute",-129499188));
var action = cljs.core.get.call(null,map__67759__$1,new cljs.core.Keyword(null,"action","action",-811238024));
if(cljs.core.truth_(execute)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__67758,map__67758__$1,env,target,ast,ref,map__67759,map__67759__$1,params,execute,action){
return (function (){
return fulcro.client.data_fetch.fallback_action_STAR_.call(null,env,params);
});})(map__67758,map__67758__$1,env,target,ast,ref,map__67759,map__67759__$1,params,execute,action))
], null);
} else {
if(cljs.core.truth_(target)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([target,(cljs.core.truth_(ref)?cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.assoc,new cljs.core.Keyword("fulcro.client.primitives","ref","fulcro.client.primitives/ref",-1451073405),ref):true)]);
} else {
return null;

}
}
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.data-fetch","fallback","fulcro.client.data-fetch/fallback",1556791555,null),(function (env,_,params){
return fulcro.client.mutations.mutate.call(null,env,new cljs.core.Symbol("tx","fallback","tx/fallback",-1892802308,null),params);
}));
/**
 * Returns the remote against which the given mutation will try to execute. Returns nil if it is not a remote mutation.
 *   `legal-remotes` is a set of legal remote names. Defaults to `#{:remote}`.
 * 
 *   Returns a set of the remotes that will be triggered for this mutation, which may be empty.
 *   
 */
fulcro.client.data_fetch.mutation_remotes = (function fulcro$client$data_fetch$mutation_remotes(state_map,p__67770,legal_remotes){
var map__67771 = p__67770;
var map__67771__$1 = (((((!((map__67771 == null))))?(((((map__67771.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67771.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67771):map__67771);
var dispatch_ast = map__67771__$1;
var dispatch_key = cljs.core.get.call(null,map__67771__$1,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510));
var params = cljs.core.get.call(null,map__67771__$1,new cljs.core.Keyword(null,"params","params",710516235));
var run_mutation = ((function (map__67771,map__67771__$1,dispatch_ast,dispatch_key,params){
return (function fulcro$client$data_fetch$mutation_remotes_$_run_mutation(remote){
return fulcro.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"ast","ast",-860334068),dispatch_ast,new cljs.core.Keyword(null,"parser","parser",-1543495310),cljs.core.constantly.call(null,null),new cljs.core.Keyword(null,"target","target",253001721),remote,new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.atom.call(null,state_map)], null),dispatch_key,params);
});})(map__67771,map__67771__$1,dispatch_ast,dispatch_key,params))
;
return cljs.core.reduce.call(null,((function (map__67771,map__67771__$1,dispatch_ast,dispatch_key,params){
return (function (remotes,r){
try{var mutation_map = run_mutation(r);
var ks = cljs.core.set.call(null,cljs.core.keep.call(null,((function (mutation_map,map__67771,map__67771__$1,dispatch_ast,dispatch_key,params){
return (function (p1__67767_SHARP_){
if(clojure.string.ends_with_QMARK_.call(null,cljs.core.name.call(null,p1__67767_SHARP_),"action")){
return null;
} else {
return p1__67767_SHARP_;
}
});})(mutation_map,map__67771,map__67771__$1,dispatch_ast,dispatch_key,params))
,cljs.core.keys.call(null,mutation_map)));
var possible_remotes = clojure.set.difference.call(null,ks,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"keys","keys",1068423698),null], null), null));
var active_now_QMARK_ = ((function (mutation_map,ks,possible_remotes,map__67771,map__67771__$1,dispatch_ast,dispatch_key,params){
return (function (p1__67768_SHARP_){
return cljs.core.get.call(null,mutation_map,p1__67768_SHARP_,false);
});})(mutation_map,ks,possible_remotes,map__67771,map__67771__$1,dispatch_ast,dispatch_key,params))
;
return cljs.core.into.call(null,remotes,cljs.core.filter.call(null,active_now_QMARK_,possible_remotes));
}catch (e67775){var e = e67775;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),502], null),new cljs.core.Keyword(null,"error","error",-978969032),"Attempting to get the remotes for mutation ",dispatch_ast," threw an exception. Make sure that mutation is side-effect free!",e);
}catch (e67776){if((e67776 instanceof Error)){
var e__54502__auto___67991 = e67776;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),502], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___67991);
} else {
throw e67776;

}
}
return cljs.core.reduced.call(null,((cljs.core.seq.call(null,remotes))?remotes:new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),null], null), null)));
}});})(map__67771,map__67771__$1,dispatch_ast,dispatch_key,params))
,cljs.core.PersistentHashSet.EMPTY,legal_remotes);
});
/**
 * Mutation: Add a fallback to the current tx. `action` is the symbol of the mutation to run if this tx fails due to
 *   network or server errors (bad status codes).
 */
fulcro.client.data_fetch.fallback = (function fulcro$client$data_fetch$fallback(p__67781){
var map__67783 = p__67781;
var map__67783__$1 = (((((!((map__67783 == null))))?(((((map__67783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67783.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67783):map__67783);
var action = cljs.core.get.call(null,map__67783__$1,new cljs.core.Keyword(null,"action","action",-811238024));
return null;
});
/**
 * Returns the remote against which the given mutation will try to execute. Returns nil if it is not a remote mutation.
 *   `legal-remotes` is a set of legal remote names. Defaults to `#{:remote}`.
 * 
 *   Returns a set of the remotes that will be triggered for this mutation, which may be empty.
 * 
 *   DEPRECATED. Do not use.  Use `mutation-remotes` instead.
 *   
 */
fulcro.client.data_fetch.get_remotes = (function fulcro$client$data_fetch$get_remotes(var_args){
var G__67793 = arguments.length;
switch (G__67793) {
case 2:
return fulcro.client.data_fetch.get_remotes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.client.data_fetch.get_remotes.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.data_fetch.get_remotes.cljs$core$IFn$_invoke$arity$2 = (function (state_map,dispatch_symbol){
return fulcro.client.data_fetch.get_remotes.call(null,state_map,dispatch_symbol,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),null], null), null));
});

fulcro.client.data_fetch.get_remotes.cljs$core$IFn$_invoke$arity$3 = (function (state_map,dispatch_symbol,legal_remotes){
var run_mutation = (function fulcro$client$data_fetch$run_mutation(remote){
return fulcro.client.mutations.mutate.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"ast","ast",-860334068),fulcro.client.primitives.query__GT_ast1.call(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,dispatch_symbol,null,(1),null))))),null,(1),null))))))),new cljs.core.Keyword(null,"parser","parser",-1543495310),cljs.core.constantly.call(null,null),new cljs.core.Keyword(null,"target","target",253001721),remote,new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.atom.call(null,state_map)], null),dispatch_symbol,cljs.core.PersistentArrayMap.EMPTY);
});
return cljs.core.reduce.call(null,(function (remotes,r){
try{var mutation_map = run_mutation(r);
var ks = cljs.core.set.call(null,cljs.core.keep.call(null,((function (mutation_map){
return (function (p1__67789_SHARP_){
if(clojure.string.ends_with_QMARK_.call(null,cljs.core.name.call(null,p1__67789_SHARP_),"action")){
return null;
} else {
return p1__67789_SHARP_;
}
});})(mutation_map))
,cljs.core.keys.call(null,mutation_map)));
var possible_remotes = clojure.set.difference.call(null,ks,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"refresh","refresh",1947415525),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"keys","keys",1068423698),null], null), null));
var active_now_QMARK_ = ((function (mutation_map,ks,possible_remotes){
return (function (p1__67790_SHARP_){
return cljs.core.get.call(null,mutation_map,p1__67790_SHARP_,false);
});})(mutation_map,ks,possible_remotes))
;
return cljs.core.into.call(null,remotes,cljs.core.filter.call(null,active_now_QMARK_,possible_remotes));
}catch (e67798){var e = e67798;
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),537], null),new cljs.core.Keyword(null,"error","error",-978969032),"Attempting to get the remotes for mutation ",dispatch_symbol," threw an exception. Make sure that mutation is side-effect free!",e);
}catch (e67800){if((e67800 instanceof Error)){
var e__54502__auto___68012 = e67800;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.client.data-fetch",new cljs.core.Keyword(null,"line","line",212345235),537], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___68012);
} else {
throw e67800;

}
}
return cljs.core.reduced.call(null,((cljs.core.seq.call(null,remotes))?remotes:new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),null], null), null)));
}}),cljs.core.PersistentHashSet.EMPTY,legal_remotes);
});

fulcro.client.data_fetch.get_remotes.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=fulcro.client.data_fetch.js.map
