goog.provide('com.wsscode.pathom.fulcro.network');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('com.wsscode.async.async_cljs');
goog.require('com.wsscode.pathom.core');
goog.require('com.wsscode.pathom.graphql');
goog.require('com.wsscode.pathom.diplomat.http');
goog.require('com.wsscode.pathom.diplomat.http.fetch');
goog.require('fulcro.client.network');
goog.require('fulcro.client.primitives');
goog.require('goog.net.XhrIo');
goog.require('goog.net.EventType');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fulcro.client.network.FulcroRemoteI}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.wsscode.pathom.fulcro.network.PathomRemote = (function (parser,__meta,__extmap,__hash){
this.parser = parser;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k87650,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__87662 = k87650;
var G__87662__$1 = (((G__87662 instanceof cljs.core.Keyword))?G__87662.fqn:null);
switch (G__87662__$1) {
case "parser":
return self__.parser;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k87650,else__4388__auto__);

}
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__87664){
var vec__87665 = p__87664;
var k__4408__auto__ = cljs.core.nth.call(null,vec__87665,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__87665,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#com.wsscode.pathom.fulcro.network.PathomRemote{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parser","parser",-1543495310),self__.parser],null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__87649){
var self__ = this;
var G__87649__$1 = this;
return (new cljs.core.RecordIter((0),G__87649__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parser","parser",-1543495310)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.PathomRemote(self__.parser,self__.__meta,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-654270555 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this87651,other87652){
var self__ = this;
var this87651__$1 = this;
return (((!((other87652 == null)))) && ((this87651__$1.constructor === other87652.constructor)) && (cljs.core._EQ_.call(null,this87651__$1.parser,other87652.parser)) && (cljs.core._EQ_.call(null,this87651__$1.__extmap,other87652.__extmap)));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"parser","parser",-1543495310),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new com.wsscode.pathom.fulcro.network.PathomRemote(self__.parser,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__87649){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__87696 = cljs.core.keyword_identical_QMARK_;
var expr__87697 = k__4393__auto__;
if(cljs.core.truth_(pred__87696.call(null,new cljs.core.Keyword(null,"parser","parser",-1543495310),expr__87697))){
return (new com.wsscode.pathom.fulcro.network.PathomRemote(G__87649,self__.__meta,self__.__extmap,null));
} else {
return (new com.wsscode.pathom.fulcro.network.PathomRemote(self__.parser,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__87649),null));
}
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parser","parser",-1543495310),self__.parser,null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__87649){
var self__ = this;
var this__4384__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.PathomRemote(self__.parser,G__87649,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.fulcro$client$network$FulcroRemoteI$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.PathomRemote.prototype.fulcro$client$network$FulcroRemoteI$transmit$arity$2 = (function (this$,p__87706){
var self__ = this;
var map__87708 = p__87706;
var map__87708__$1 = (((((!((map__87708 == null))))?(((((map__87708.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87708.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87708):map__87708);
var edn = cljs.core.get.call(null,map__87708__$1,new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957));
var ok_handler = cljs.core.get.call(null,map__87708__$1,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727));
var error_handler = cljs.core.get.call(null,map__87708__$1,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226));
var progress_handler = cljs.core.get.call(null,map__87708__$1,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355));
var this$__$1 = this;
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler){
return (function (state_87755){
var state_val_87756 = (state_87755[(1)]);
if((state_val_87756 === (7))){
var inst_87723 = (state_87755[(7)]);
var inst_87748 = (state_87755[(2)]);
var inst_87749 = [edn,inst_87748];
var inst_87750 = cljs.core.PersistentHashMap.fromArrays(inst_87723,inst_87749);
var inst_87751 = ok_handler.call(null,inst_87750);
var state_87755__$1 = state_87755;
var statearr_87761_88994 = state_87755__$1;
(statearr_87761_88994[(2)] = inst_87751);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_87755__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (1))){
var state_87755__$1 = state_87755;
var statearr_87763_88995 = state_87755__$1;
(statearr_87763_88995[(2)] = null);

(statearr_87763_88995[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (4))){
var inst_87726 = (state_87755[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_87755,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_87723 = [new cljs.core.Keyword(null,"transaction","transaction",1777321997),new cljs.core.Keyword(null,"body","body",-2049205669)];
var inst_87725 = cljs.core.PersistentHashMap.EMPTY;
var inst_87726__$1 = self__.parser.call(null,inst_87725,edn);
var inst_87727 = com.wsscode.async.async_cljs.chan_QMARK_.call(null,inst_87726__$1);
var state_87755__$1 = (function (){var statearr_87765 = state_87755;
(statearr_87765[(8)] = inst_87726__$1);

(statearr_87765[(7)] = inst_87723);

return statearr_87765;
})();
if(inst_87727){
var statearr_87767_89005 = state_87755__$1;
(statearr_87767_89005[(1)] = (5));

} else {
var statearr_87769_89006 = state_87755__$1;
(statearr_87769_89006[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (15))){
var inst_87744 = (state_87755[(2)]);
var state_87755__$1 = state_87755;
var statearr_87770_89011 = state_87755__$1;
(statearr_87770_89011[(2)] = inst_87744);

(statearr_87770_89011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (13))){
var inst_87726 = (state_87755[(8)]);
var state_87755__$1 = state_87755;
var statearr_87772_89014 = state_87755__$1;
(statearr_87772_89014[(2)] = inst_87726);

(statearr_87772_89014[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (6))){
var inst_87726 = (state_87755[(8)]);
var inst_87733 = com.wsscode.async.async_cljs.promise_QMARK_.call(null,inst_87726);
var state_87755__$1 = state_87755;
if(cljs.core.truth_(inst_87733)){
var statearr_87776_89021 = state_87755__$1;
(statearr_87776_89021[(1)] = (9));

} else {
var statearr_87777_89022 = state_87755__$1;
(statearr_87777_89022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (3))){
var inst_87713 = (state_87755[(2)]);
var inst_87714 = console.error("PathomRemote error:",inst_87713);
var inst_87715 = [new cljs.core.Keyword(null,"body","body",-2049205669)];
var inst_87717 = [inst_87713];
var inst_87718 = cljs.core.PersistentHashMap.fromArrays(inst_87715,inst_87717);
var inst_87719 = error_handler.call(null,inst_87718);
var state_87755__$1 = (function (){var statearr_87778 = state_87755;
(statearr_87778[(9)] = inst_87714);

return statearr_87778;
})();
var statearr_87779_89033 = state_87755__$1;
(statearr_87779_89033[(2)] = inst_87719);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_87755__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (12))){
var inst_87737 = (state_87755[(2)]);
var inst_87738 = com.wsscode.async.async_cljs.consumer_pair.call(null,inst_87737);
var state_87755__$1 = state_87755;
var statearr_87780_89036 = state_87755__$1;
(statearr_87780_89036[(2)] = inst_87738);

(statearr_87780_89036[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (2))){
var inst_87753 = (state_87755[(2)]);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_87755__$1,inst_87753);
} else {
if((state_val_87756 === (11))){
var inst_87746 = (state_87755[(2)]);
var state_87755__$1 = state_87755;
var statearr_87781_89041 = state_87755__$1;
(statearr_87781_89041[(2)] = inst_87746);

(statearr_87781_89041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (9))){
var inst_87726 = (state_87755[(8)]);
var inst_87735 = com.wsscode.async.async_cljs.promise__GT_chan.call(null,inst_87726);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_87755__$1,(12),inst_87735);
} else {
if((state_val_87756 === (5))){
var inst_87726 = (state_87755[(8)]);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_87755__$1,(8),inst_87726);
} else {
if((state_val_87756 === (14))){
var state_87755__$1 = state_87755;
var statearr_87785_89057 = state_87755__$1;
(statearr_87785_89057[(2)] = null);

(statearr_87785_89057[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (10))){
var state_87755__$1 = state_87755;
var statearr_87787_89061 = state_87755__$1;
(statearr_87787_89061[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (8))){
var inst_87730 = (state_87755[(2)]);
var inst_87731 = com.wsscode.async.async_cljs.throw_err.call(null,inst_87730);
var state_87755__$1 = state_87755;
var statearr_87790_89066 = state_87755__$1;
(statearr_87790_89066[(2)] = inst_87731);

(statearr_87790_89066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler))
;
return ((function (switch__53637__auto__,c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler){
return (function() {
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = null;
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0 = (function (){
var statearr_87793 = [null,null,null,null,null,null,null,null,null,null];
(statearr_87793[(0)] = com$wsscode$pathom$fulcro$network$state_machine__53638__auto__);

(statearr_87793[(1)] = (1));

return statearr_87793;
});
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1 = (function (state_87755){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_87755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e87795){if((e87795 instanceof Object)){
var ex__53641__auto__ = e87795;
var statearr_87797_89076 = state_87755;
(statearr_87797_89076[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_87755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e87795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89084 = state_87755;
state_87755 = G__89084;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = function(state_87755){
switch(arguments.length){
case 0:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0.call(this);
case 1:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1.call(this,state_87755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0;
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1;
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler))
})();
var state__54030__auto__ = (function (){var statearr_87798 = f__54029__auto__();
(statearr_87798[(6)] = c__54028__auto__);

return statearr_87798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,this$__$1,map__87708,map__87708__$1,edn,ok_handler,error_handler,progress_handler))
);

return c__54028__auto__;
});

com.wsscode.pathom.fulcro.network.PathomRemote.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parser","parser",97036217,null)], null);
});

com.wsscode.pathom.fulcro.network.PathomRemote.cljs$lang$type = true;

com.wsscode.pathom.fulcro.network.PathomRemote.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"com.wsscode.pathom.fulcro.network/PathomRemote",null,(1),null));
});

com.wsscode.pathom.fulcro.network.PathomRemote.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"com.wsscode.pathom.fulcro.network/PathomRemote");
});

/**
 * Positional factory function for com.wsscode.pathom.fulcro.network/PathomRemote.
 */
com.wsscode.pathom.fulcro.network.__GT_PathomRemote = (function com$wsscode$pathom$fulcro$network$__GT_PathomRemote(parser){
return (new com.wsscode.pathom.fulcro.network.PathomRemote(parser,null,null,null));
});

/**
 * Factory function for com.wsscode.pathom.fulcro.network/PathomRemote, taking a map of keywords to field values.
 */
com.wsscode.pathom.fulcro.network.map__GT_PathomRemote = (function com$wsscode$pathom$fulcro$network$map__GT_PathomRemote(G__87656){
var extmap__4424__auto__ = (function (){var G__87802 = cljs.core.dissoc.call(null,G__87656,new cljs.core.Keyword(null,"parser","parser",-1543495310));
if(cljs.core.record_QMARK_.call(null,G__87656)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__87802);
} else {
return G__87802;
}
})();
return (new com.wsscode.pathom.fulcro.network.PathomRemote(new cljs.core.Keyword(null,"parser","parser",-1543495310).cljs$core$IFn$_invoke$arity$1(G__87656),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

/**
 * Create a Fulcro remote that will use a Pathom async parser to process the query.
 */
com.wsscode.pathom.fulcro.network.pathom_remote = (function com$wsscode$pathom$fulcro$network$pathom_remote(parser){
return com.wsscode.pathom.fulcro.network.map__GT_PathomRemote.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.wsscode.pathom.fulcro.network.FnNetwork = (function (f,serialize_QMARK_,__meta,__extmap,__hash){
this.f = f;
this.serialize_QMARK_ = serialize_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k87806,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__87815 = k87806;
var G__87815__$1 = (((G__87815 instanceof cljs.core.Keyword))?G__87815.fqn:null);
switch (G__87815__$1) {
case "f":
return self__.f;

break;
case "serialize?":
return self__.serialize_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k87806,else__4388__auto__);

}
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__87819){
var vec__87820 = p__87819;
var k__4408__auto__ = cljs.core.nth.call(null,vec__87820,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__87820,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#com.wsscode.pathom.fulcro.network.FnNetwork{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"f","f",-1597136552),self__.f],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serialize?","serialize?",1512776885),self__.serialize_QMARK_],null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__87805){
var self__ = this;
var G__87805__$1 = this;
return (new cljs.core.RecordIter((0),G__87805__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"serialize?","serialize?",1512776885)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.FnNetwork(self__.f,self__.serialize_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1603683175 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this87808,other87809){
var self__ = this;
var this87808__$1 = this;
return (((!((other87809 == null)))) && ((this87808__$1.constructor === other87809.constructor)) && (cljs.core._EQ_.call(null,this87808__$1.f,other87809.f)) && (cljs.core._EQ_.call(null,this87808__$1.serialize_QMARK_,other87809.serialize_QMARK_)) && (cljs.core._EQ_.call(null,this87808__$1.__extmap,other87809.__extmap)));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (this$,edn,ok,error){
var self__ = this;
var this$__$1 = this;
return self__.f.call(null,this$__$1,edn,ok,error);
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.serialize_QMARK_;
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"serialize?","serialize?",1512776885),null,new cljs.core.Keyword(null,"f","f",-1597136552),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new com.wsscode.pathom.fulcro.network.FnNetwork(self__.f,self__.serialize_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__87805){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__87829 = cljs.core.keyword_identical_QMARK_;
var expr__87830 = k__4393__auto__;
if(cljs.core.truth_(pred__87829.call(null,new cljs.core.Keyword(null,"f","f",-1597136552),expr__87830))){
return (new com.wsscode.pathom.fulcro.network.FnNetwork(G__87805,self__.serialize_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__87829.call(null,new cljs.core.Keyword(null,"serialize?","serialize?",1512776885),expr__87830))){
return (new com.wsscode.pathom.fulcro.network.FnNetwork(self__.f,G__87805,self__.__meta,self__.__extmap,null));
} else {
return (new com.wsscode.pathom.fulcro.network.FnNetwork(self__.f,self__.serialize_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__87805),null));
}
}
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"f","f",-1597136552),self__.f,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serialize?","serialize?",1512776885),self__.serialize_QMARK_,null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__87805){
var self__ = this;
var this__4384__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.FnNetwork(self__.f,self__.serialize_QMARK_,G__87805,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.FnNetwork.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

com.wsscode.pathom.fulcro.network.FnNetwork.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"serialize?","serialize?",-1141658884,null)], null);
});

com.wsscode.pathom.fulcro.network.FnNetwork.cljs$lang$type = true;

com.wsscode.pathom.fulcro.network.FnNetwork.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"com.wsscode.pathom.fulcro.network/FnNetwork",null,(1),null));
});

com.wsscode.pathom.fulcro.network.FnNetwork.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"com.wsscode.pathom.fulcro.network/FnNetwork");
});

/**
 * Positional factory function for com.wsscode.pathom.fulcro.network/FnNetwork.
 */
com.wsscode.pathom.fulcro.network.__GT_FnNetwork = (function com$wsscode$pathom$fulcro$network$__GT_FnNetwork(f,serialize_QMARK_){
return (new com.wsscode.pathom.fulcro.network.FnNetwork(f,serialize_QMARK_,null,null,null));
});

/**
 * Factory function for com.wsscode.pathom.fulcro.network/FnNetwork, taking a map of keywords to field values.
 */
com.wsscode.pathom.fulcro.network.map__GT_FnNetwork = (function com$wsscode$pathom$fulcro$network$map__GT_FnNetwork(G__87811){
var extmap__4424__auto__ = (function (){var G__87832 = cljs.core.dissoc.call(null,G__87811,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"serialize?","serialize?",1512776885));
if(cljs.core.record_QMARK_.call(null,G__87811)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__87832);
} else {
return G__87832;
}
})();
return (new com.wsscode.pathom.fulcro.network.FnNetwork(new cljs.core.Keyword(null,"f","f",-1597136552).cljs$core$IFn$_invoke$arity$1(G__87811),new cljs.core.Keyword(null,"serialize?","serialize?",1512776885).cljs$core$IFn$_invoke$arity$1(G__87811),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

/**
 * Creates a simple Fulcro network out a function, the function will reeive the params:
 *   [network edn ok-callback error-callback]
 */
com.wsscode.pathom.fulcro.network.fn_network = (function com$wsscode$pathom$fulcro$network$fn_network(var_args){
var G__87838 = arguments.length;
switch (G__87838) {
case 1:
return com.wsscode.pathom.fulcro.network.fn_network.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.fulcro.network.fn_network.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.fulcro.network.fn_network.cljs$core$IFn$_invoke$arity$1 = (function (f){
return com.wsscode.pathom.fulcro.network.fn_network.call(null,f,true);
});

com.wsscode.pathom.fulcro.network.fn_network.cljs$core$IFn$_invoke$arity$2 = (function (f,serialize_QMARK_){
return com.wsscode.pathom.fulcro.network.map__GT_FnNetwork.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"f","f",-1597136552),f,new cljs.core.Keyword(null,"serialize?","serialize?",1512776885),serialize_QMARK_], null));
});

com.wsscode.pathom.fulcro.network.fn_network.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.wsscode.pathom.fulcro.network.TransformNetwork = (function (network,options,__meta,__extmap,__hash){
this.network = network;
this.options = options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k87844,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__87850 = k87844;
var G__87850__$1 = (((G__87850 instanceof cljs.core.Keyword))?G__87850.fqn:null);
switch (G__87850__$1) {
case "network":
return self__.network;

break;
case "options":
return self__.options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k87844,else__4388__auto__);

}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__87855){
var vec__87863 = p__87855;
var k__4408__auto__ = cljs.core.nth.call(null,vec__87863,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__87863,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#com.wsscode.pathom.fulcro.network.TransformNetwork{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__87843){
var self__ = this;
var G__87843__$1 = this;
return (new cljs.core.RecordIter((0),G__87843__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(self__.network,self__.options,self__.__meta,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-928703448 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this87845,other87846){
var self__ = this;
var this87845__$1 = this;
return (((!((other87846 == null)))) && ((this87845__$1.constructor === other87846.constructor)) && (cljs.core._EQ_.call(null,this87845__$1.network,other87846.network)) && (cljs.core._EQ_.call(null,this87845__$1.options,other87846.options)) && (cljs.core._EQ_.call(null,this87845__$1.__extmap,other87846.__extmap)));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (_,edn,ok,error){
var self__ = this;
var ___$1 = this;
var map__87875 = self__.options;
var map__87875__$1 = (((((!((map__87875 == null))))?(((((map__87875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87875):map__87875);
var transform_query = cljs.core.get.call(null,map__87875__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-query","com.wsscode.pathom.fulcro.network/transform-query",-858543588),((function (map__87875,map__87875__$1,___$1){
return (function (___$2,x){
return x;
});})(map__87875,map__87875__$1,___$1))
);
var transform_response = cljs.core.get.call(null,map__87875__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-response","com.wsscode.pathom.fulcro.network/transform-response",612468140),((function (map__87875,map__87875__$1,transform_query,___$1){
return (function (___$2,x){
return x;
});})(map__87875,map__87875__$1,transform_query,___$1))
);
var transform_error = cljs.core.get.call(null,map__87875__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-error","com.wsscode.pathom.fulcro.network/transform-error",-1129352368),((function (map__87875,map__87875__$1,transform_query,transform_response,___$1){
return (function (___$2,x){
return x;
});})(map__87875,map__87875__$1,transform_query,transform_response,___$1))
);
var transform_transmission = cljs.core.get.call(null,map__87875__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-transmission","com.wsscode.pathom.fulcro.network/transform-transmission",1217468815));
var app_STAR_ = cljs.core.get.call(null,map__87875__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app*","com.wsscode.pathom.fulcro.network/app*",212485267));
var req_id = cljs.core.random_uuid.call(null);
var env = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","request-id","com.wsscode.pathom.fulcro.network/request-id",-2145646802),req_id,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app","com.wsscode.pathom.fulcro.network/app",-1540176162),cljs.core.deref.call(null,app_STAR_)], null);
var temp__5718__auto__ = transform_query.call(null,env,edn);
if(cljs.core.truth_(temp__5718__auto__)){
var edn_SINGLEQUOTE_ = temp__5718__auto__;
if(cljs.core.truth_(transform_transmission)){
return transform_transmission.call(null,edn_SINGLEQUOTE_,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1){
return (function (edn_SINGLEQUOTE___$1){
return fulcro.client.network.send(self__.network,edn_SINGLEQUOTE___$1,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1){
return (function (p1__87839_SHARP_){
return ok.call(null,transform_response.call(null,env,p1__87839_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1))
,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1){
return (function (p1__87840_SHARP_){
return error.call(null,transform_error.call(null,env,p1__87840_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1))
);
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1))
);
} else {
return fulcro.client.network.send(self__.network,edn_SINGLEQUOTE_,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1){
return (function (p1__87841_SHARP_){
return ok.call(null,transform_response.call(null,env,p1__87841_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1))
,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1){
return (function (p1__87842_SHARP_){
return error.call(null,transform_error.call(null,env,p1__87842_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87875,map__87875__$1,transform_query,transform_response,transform_error,transform_transmission,app_STAR_,req_id,env,___$1))
);
}
} else {
return ok.call(null,null);
}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
fulcro.client.network.start(self__.network);

return this$__$1;
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
try{return fulcro.client.network.serialize_requests_QMARK_(self__.network);
}catch (e87894){var ___$2 = e87894;
return true;
}});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"network","network",2050004697),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(self__.network,self__.options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__87843){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__87896 = cljs.core.keyword_identical_QMARK_;
var expr__87897 = k__4393__auto__;
if(cljs.core.truth_(pred__87896.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__87897))){
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(G__87843,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__87896.call(null,new cljs.core.Keyword(null,"options","options",99638489),expr__87897))){
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(self__.network,G__87843,self__.__meta,self__.__extmap,null));
} else {
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(self__.network,self__.options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__87843),null));
}
}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"options","options",99638489),self__.options,null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__87843){
var self__ = this;
var this__4384__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(self__.network,self__.options,G__87843,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

com.wsscode.pathom.fulcro.network.TransformNetwork.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null);
});

com.wsscode.pathom.fulcro.network.TransformNetwork.cljs$lang$type = true;

com.wsscode.pathom.fulcro.network.TransformNetwork.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"com.wsscode.pathom.fulcro.network/TransformNetwork",null,(1),null));
});

com.wsscode.pathom.fulcro.network.TransformNetwork.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"com.wsscode.pathom.fulcro.network/TransformNetwork");
});

/**
 * Positional factory function for com.wsscode.pathom.fulcro.network/TransformNetwork.
 */
com.wsscode.pathom.fulcro.network.__GT_TransformNetwork = (function com$wsscode$pathom$fulcro$network$__GT_TransformNetwork(network,options){
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(network,options,null,null,null));
});

/**
 * Factory function for com.wsscode.pathom.fulcro.network/TransformNetwork, taking a map of keywords to field values.
 */
com.wsscode.pathom.fulcro.network.map__GT_TransformNetwork = (function com$wsscode$pathom$fulcro$network$map__GT_TransformNetwork(G__87847){
var extmap__4424__auto__ = (function (){var G__87919 = cljs.core.dissoc.call(null,G__87847,new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489));
if(cljs.core.record_QMARK_.call(null,G__87847)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__87919);
} else {
return G__87919;
}
})();
return (new com.wsscode.pathom.fulcro.network.TransformNetwork(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__87847),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__87847),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fulcro.client.network.FulcroRemoteI}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.wsscode.pathom.fulcro.network.TransformRemoteI = (function (network,options,__meta,__extmap,__hash){
this.network = network;
this.options = options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k87929,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__87939 = k87929;
var G__87939__$1 = (((G__87939 instanceof cljs.core.Keyword))?G__87939.fqn:null);
switch (G__87939__$1) {
case "network":
return self__.network;

break;
case "options":
return self__.options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k87929,else__4388__auto__);

}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__87941){
var vec__87942 = p__87941;
var k__4408__auto__ = cljs.core.nth.call(null,vec__87942,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__87942,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#com.wsscode.pathom.fulcro.network.TransformRemoteI{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__87928){
var self__ = this;
var G__87928__$1 = this;
return (new cljs.core.RecordIter((0),G__87928__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(self__.network,self__.options,self__.__meta,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1483300891 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this87930,other87931){
var self__ = this;
var this87930__$1 = this;
return (((!((other87931 == null)))) && ((this87930__$1.constructor === other87931.constructor)) && (cljs.core._EQ_.call(null,this87930__$1.network,other87931.network)) && (cljs.core._EQ_.call(null,this87930__$1.options,other87931.options)) && (cljs.core._EQ_.call(null,this87930__$1.__extmap,other87931.__extmap)));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
try{return fulcro.client.network.serialize_requests_QMARK_(self__.network);
}catch (e87957){var ___$2 = e87957;
return true;
}});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"network","network",2050004697),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(self__.network,self__.options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__87928){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__87963 = cljs.core.keyword_identical_QMARK_;
var expr__87964 = k__4393__auto__;
if(cljs.core.truth_(pred__87963.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__87964))){
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(G__87928,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__87963.call(null,new cljs.core.Keyword(null,"options","options",99638489),expr__87964))){
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(self__.network,G__87928,self__.__meta,self__.__extmap,null));
} else {
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(self__.network,self__.options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__87928),null));
}
}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"options","options",99638489),self__.options,null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__87928){
var self__ = this;
var this__4384__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(self__.network,self__.options,G__87928,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.fulcro$client$network$FulcroRemoteI$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.fulcro$client$network$FulcroRemoteI$transmit$arity$2 = (function (this$,p__87971){
var self__ = this;
var map__87972 = p__87971;
var map__87972__$1 = (((((!((map__87972 == null))))?(((((map__87972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87972):map__87972);
var edn = cljs.core.get.call(null,map__87972__$1,new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957));
var ok_handler = cljs.core.get.call(null,map__87972__$1,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727));
var error_handler = cljs.core.get.call(null,map__87972__$1,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226));
var progress_handler = cljs.core.get.call(null,map__87972__$1,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355));
var this$__$1 = this;
var map__87975 = self__.options;
var map__87975__$1 = (((((!((map__87975 == null))))?(((((map__87975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87975):map__87975);
var transform_query = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-query","com.wsscode.pathom.fulcro.network/transform-query",-858543588),((function (map__87975,map__87975__$1,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (_,x){
return x;
});})(map__87975,map__87975__$1,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_response = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-response","com.wsscode.pathom.fulcro.network/transform-response",612468140),((function (map__87975,map__87975__$1,transform_query,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (_,x){
return x;
});})(map__87975,map__87975__$1,transform_query,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_error = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-error","com.wsscode.pathom.fulcro.network/transform-error",-1129352368),((function (map__87975,map__87975__$1,transform_query,transform_response,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (_,x){
return x;
});})(map__87975,map__87975__$1,transform_query,transform_response,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_progress = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-progress","com.wsscode.pathom.fulcro.network/transform-progress",-587053240),((function (map__87975,map__87975__$1,transform_query,transform_response,transform_error,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (_,x){
return x;
});})(map__87975,map__87975__$1,transform_query,transform_response,transform_error,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_transmission = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-transmission","com.wsscode.pathom.fulcro.network/transform-transmission",1217468815));
var app_STAR_ = cljs.core.get.call(null,map__87975__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app*","com.wsscode.pathom.fulcro.network/app*",212485267));
var req_id = cljs.core.random_uuid.call(null);
var env = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","request-id","com.wsscode.pathom.fulcro.network/request-id",-2145646802),req_id,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app","com.wsscode.pathom.fulcro.network/app",-1540176162),cljs.core.deref.call(null,app_STAR_)], null);
var temp__5718__auto__ = transform_query.call(null,env,edn);
if(cljs.core.truth_(temp__5718__auto__)){
var edn_SINGLEQUOTE_ = temp__5718__auto__;
if(cljs.core.truth_(transform_transmission)){
return transform_transmission.call(null,env,edn_SINGLEQUOTE_,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (edn_SINGLEQUOTE___$1){
return fulcro.client.network.transmit(self__.network,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957),edn_SINGLEQUOTE___$1,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (response){
return ok_handler.call(null,cljs.core.update.call(null,response,new cljs.core.Keyword(null,"body","body",-2049205669),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__87923_SHARP_){
return transform_response.call(null,env,p1__87923_SHARP_);
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (error){
return error_handler.call(null,cljs.core.update.call(null,error,new cljs.core.Keyword(null,"body","body",-2049205669),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__87924_SHARP_){
return transform_error.call(null,env,p1__87924_SHARP_);
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (progress){
return progress_handler.call(null,transform_progress.call(null,env,progress));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
], null));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
);
} else {
return fulcro.client.network.transmit(self__.network,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957),edn_SINGLEQUOTE_,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (response){
return ok_handler.call(null,cljs.core.update.call(null,response,new cljs.core.Keyword(null,"body","body",-2049205669),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__87925_SHARP_){
return transform_response.call(null,env,p1__87925_SHARP_);
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (error){
return error_handler.call(null,cljs.core.update.call(null,error,new cljs.core.Keyword(null,"body","body",-2049205669),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__87926_SHARP_){
return transform_error.call(null,env,p1__87926_SHARP_);
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler){
return (function (progress){
return progress_handler.call(null,transform_progress.call(null,env,progress));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__87975,map__87975__$1,transform_query,transform_response,transform_error,transform_progress,transform_transmission,app_STAR_,req_id,env,this$__$1,map__87972,map__87972__$1,edn,ok_handler,error_handler,progress_handler))
], null));
}
} else {
return ok_handler.call(null,null);
}
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.prototype.fulcro$client$network$FulcroRemoteI$abort$arity$2 = (function (this$,abort_id){
var self__ = this;
var this$__$1 = this;
return fulcro.client.network.abort(self__.network,abort_id);
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null);
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.cljs$lang$type = true;

com.wsscode.pathom.fulcro.network.TransformRemoteI.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"com.wsscode.pathom.fulcro.network/TransformRemoteI",null,(1),null));
});

com.wsscode.pathom.fulcro.network.TransformRemoteI.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"com.wsscode.pathom.fulcro.network/TransformRemoteI");
});

/**
 * Positional factory function for com.wsscode.pathom.fulcro.network/TransformRemoteI.
 */
com.wsscode.pathom.fulcro.network.__GT_TransformRemoteI = (function com$wsscode$pathom$fulcro$network$__GT_TransformRemoteI(network,options){
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(network,options,null,null,null));
});

/**
 * Factory function for com.wsscode.pathom.fulcro.network/TransformRemoteI, taking a map of keywords to field values.
 */
com.wsscode.pathom.fulcro.network.map__GT_TransformRemoteI = (function com$wsscode$pathom$fulcro$network$map__GT_TransformRemoteI(G__87933){
var extmap__4424__auto__ = (function (){var G__88053 = cljs.core.dissoc.call(null,G__87933,new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489));
if(cljs.core.record_QMARK_.call(null,G__87933)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__88053);
} else {
return G__88053;
}
})();
return (new com.wsscode.pathom.fulcro.network.TransformRemoteI(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__87933),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__87933),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

/**
 * Given a network, provides some hooks to modify the network behavior.
 * 
 *   ::transform-query [env edn] -> edn
 *   Receives the EDN query so you can modify before it's transmited. If you return nil the send will be cancelled, and the
 *   network ok handler will be triggered with nil.
 * 
 *   ::transform-response [env response] -> response
 *   ::transform-error [env error] -> error
 *   ::transform-progress [env progress] -> progress (for FulcroRemoteI only)
 * 
 *   ::transform-transmission [env transmit]
 *   Transmit is a function with zero arguments, this can be used to wrap some operation around the data
 *   transmission entirely, but you can't affect the parameters from here.
 * 
 *   env is a map with the keys `::request-id` and `::app`
 * 
 *   `::request-id` is a uuid generated on the request, it will
 *   be the same during all transform hooks, you can use this to correlate the hook steps.
 * 
 *   The `::app` is an atom with the app, to have this you must initialize it during the Fulcro :started-callback using
 *   the following code:
 * 
 *   (fn [app] (pathom.network/transform-remote-init remote app))
 * 
 *   This helper is compatible with both fulcro network work interfaces FulcroNetwork and FulcroRemoteI.
 */
com.wsscode.pathom.fulcro.network.transform_remote = (function com$wsscode$pathom$fulcro$network$transform_remote(remote,options){
var options__$1 = cljs.core.assoc.call(null,options,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app*","com.wsscode.pathom.fulcro.network/app*",212485267),cljs.core.atom.call(null,null));
if((((!((remote == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === remote.fulcro$client$network$FulcroRemoteI$))))?true:false):false)){
return com.wsscode.pathom.fulcro.network.__GT_TransformRemoteI.call(null,remote,options__$1);
} else {
if((((!((remote == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === remote.fulcro$client$network$FulcroNetwork$))))?true:false):false)){
return com.wsscode.pathom.fulcro.network.__GT_TransformNetwork.call(null,remote,options__$1);
} else {
return null;
}
}
});
/**
 * Set the transform remote app reference, this is needed if your remote needs access to the app.
 */
com.wsscode.pathom.fulcro.network.transform_remote_init = (function com$wsscode$pathom$fulcro$network$transform_remote_init(network,app){
var G__88065 = network;
var G__88065__$1 = (((G__88065 == null))?null:new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__88065));
var G__88065__$2 = (((G__88065__$1 == null))?null:new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","app*","com.wsscode.pathom.fulcro.network/app*",212485267).cljs$core$IFn$_invoke$arity$1(G__88065__$1));
if((G__88065__$2 == null)){
return null;
} else {
return cljs.core.reset_BANG_.call(null,G__88065__$2,app);
}
});
/**
 * Wrap a Remote so it always ask for the pathom profile.
 */
com.wsscode.pathom.fulcro.network.trace_remote = (function com$wsscode$pathom$fulcro$network$trace_remote(network){
return com.wsscode.pathom.fulcro.network.transform_remote.call(null,network,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-query","com.wsscode.pathom.fulcro.network/transform-query",-858543588),(function (_,query){
return cljs.core.conj.call(null,query,new cljs.core.Keyword("com.wsscode.pathom","trace","com.wsscode.pathom/trace",1253203063));
})], null));
});
/**
 * Wrap a Remote so it always ask for the pathom profile.
 */
com.wsscode.pathom.fulcro.network.profile_remote = (function com$wsscode$pathom$fulcro$network$profile_remote(network){
return com.wsscode.pathom.fulcro.network.transform_remote.call(null,network,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","transform-query","com.wsscode.pathom.fulcro.network/transform-query",-858543588),(function (_,query){
return cljs.core.conj.call(null,query,new cljs.core.Keyword("com.wsscode.pathom.profile","profile","com.wsscode.pathom.profile/profile",-1055198583));
})], null));
});
com.wsscode.pathom.fulcro.network.graphql_response_key = cljs.core.comp.call(null,cljs.core.keyword,com.wsscode.pathom.graphql.camel_case,cljs.core.name);
com.wsscode.pathom.fulcro.network.graphql_response_parser = com.wsscode.pathom.core.parser.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.core","env","com.wsscode.pathom.core/env",602275378),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.core","reader","com.wsscode.pathom.core/reader",1510046410),com.wsscode.pathom.core.map_reader_STAR_.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.core","map-key-transform","com.wsscode.pathom.core/map-key-transform",-238565800),com.wsscode.pathom.fulcro.network.graphql_response_key], null))], null),new cljs.core.Keyword("com.wsscode.pathom.core","mutate","com.wsscode.pathom.core/mutate",-2086097173),(function (env,k,_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),(function (){
var response = cljs.core.get.call(null,com.wsscode.pathom.core.entity.call(null,env),com.wsscode.pathom.fulcro.network.graphql_response_key(k));
var id_param = com.wsscode.pathom.graphql.find_id.call(null,cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ast","ast",-860334068),new cljs.core.Keyword(null,"params","params",710516235)], null)),fulcro.client.primitives.tempid_QMARK_);
var G__88076 = response;
if(cljs.core.truth_(id_param)){
return cljs.core.assoc.call(null,G__88076,new cljs.core.Keyword("fulcro.client.primitives","tempids","fulcro.client.primitives/tempids",1304031205),cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.val.call(null,id_param),cljs.core.get.call(null,response,com.wsscode.pathom.fulcro.network.graphql_response_key(cljs.core.key.call(null,id_param)))]));
} else {
return G__88076;
}
})], null);
})], null));
com.wsscode.pathom.fulcro.network.graphql_network = (function com$wsscode$pathom$fulcro$network$graphql_network(var_args){
var G__88081 = arguments.length;
switch (G__88081) {
case 1:
return com.wsscode.pathom.fulcro.network.graphql_network.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.fulcro.network.graphql_network.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.fulcro.network.graphql_network.cljs$core$IFn$_invoke$arity$1 = (function (url){
return com.wsscode.pathom.fulcro.network.graphql_network.call(null,url,cljs.core.PersistentArrayMap.EMPTY);
});

com.wsscode.pathom.fulcro.network.graphql_network.cljs$core$IFn$_invoke$arity$2 = (function (url,p__88084){
var map__88086 = p__88084;
var map__88086__$1 = (((((!((map__88086 == null))))?(((((map__88086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88086):map__88086);
var update_http_request = cljs.core.get.call(null,map__88086__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","update-http-request","com.wsscode.pathom.fulcro.network/update-http-request",-478575150));
return com.wsscode.pathom.fulcro.network.fn_network.call(null,((function (map__88086,map__88086__$1,update_http_request){
return (function (this$,edn,ok,error){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__,map__88086,map__88086__$1,update_http_request){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__,map__88086,map__88086__$1,update_http_request){
return (function (state_88161){
var state_val_88162 = (state_88161[(1)]);
if((state_val_88162 === (7))){
var inst_88117 = (state_88161[(7)]);
var state_88161__$1 = state_88161;
var statearr_88163_89746 = state_88161__$1;
(statearr_88163_89746[(2)] = inst_88117);

(statearr_88163_89746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (1))){
var state_88161__$1 = state_88161;
var statearr_88164_89764 = state_88161__$1;
(statearr_88164_89764[(2)] = null);

(statearr_88164_89764[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (4))){
var inst_88103 = (state_88161[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_88161,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_88098 = com.wsscode.pathom.core.query__GT_ast.call(null,edn);
var inst_88099 = [new cljs.core.Keyword("com.wsscode.pathom.profile","profile","com.wsscode.pathom.profile/profile",-1055198583),null];
var inst_88100 = (new cljs.core.PersistentArrayMap(null,1,inst_88099,null));
var inst_88101 = (new cljs.core.PersistentHashSet(null,inst_88100,null));
var inst_88102 = com.wsscode.pathom.core.elide_ast_nodes.call(null,inst_88098,inst_88101);
var inst_88103__$1 = com.wsscode.pathom.core.ast__GT_query.call(null,inst_88102);
var inst_88104 = [new cljs.core.Keyword("com.wsscode.pathom.graphql","js-name","com.wsscode.pathom.graphql/js-name",1988989576)];
var inst_88105 = cljs.core.comp.call(null,com.wsscode.pathom.graphql.camel_case,cljs.core.name);
var inst_88106 = [inst_88105];
var inst_88107 = cljs.core.PersistentHashMap.fromArrays(inst_88104,inst_88106);
var inst_88108 = com.wsscode.pathom.graphql.query__GT_graphql.call(null,inst_88103__$1,inst_88107);
var inst_88111 = [new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","url","com.wsscode.pathom.diplomat.http/url",1690966630),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","method","com.wsscode.pathom.diplomat.http/method",1862305016),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","as","com.wsscode.pathom.diplomat.http/as",139380761),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","form-params","com.wsscode.pathom.diplomat.http/form-params",1015103523)];
var inst_88112 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_88114 = [inst_88108];
var inst_88115 = cljs.core.PersistentHashMap.fromArrays(inst_88112,inst_88114);
var inst_88116 = [url,new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","post","com.wsscode.pathom.diplomat.http/post",-1010788441),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","json","com.wsscode.pathom.diplomat.http/json",2025134090),inst_88115];
var inst_88117 = cljs.core.PersistentHashMap.fromArrays(inst_88111,inst_88116);
var state_88161__$1 = (function (){var statearr_88165 = state_88161;
(statearr_88165[(8)] = inst_88103__$1);

(statearr_88165[(7)] = inst_88117);

return statearr_88165;
})();
if(cljs.core.truth_(update_http_request)){
var statearr_88166_89798 = state_88161__$1;
(statearr_88166_89798[(1)] = (6));

} else {
var statearr_88167_89799 = state_88161__$1;
(statearr_88167_89799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (15))){
var inst_88128 = (state_88161[(9)]);
var inst_88146 = cljs.core.apply.call(null,cljs.core.hash_map,inst_88128);
var state_88161__$1 = state_88161;
var statearr_88168_89802 = state_88161__$1;
(statearr_88168_89802[(2)] = inst_88146);

(statearr_88168_89802[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (13))){
var state_88161__$1 = state_88161;
var statearr_88169_89805 = state_88161__$1;
(statearr_88169_89805[(2)] = false);

(statearr_88169_89805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (6))){
var inst_88117 = (state_88161[(7)]);
var inst_88119 = update_http_request.call(null,inst_88117);
var state_88161__$1 = state_88161;
var statearr_88170_89809 = state_88161__$1;
(statearr_88170_89809[(2)] = inst_88119);

(statearr_88170_89809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (17))){
var inst_88103 = (state_88161[(8)]);
var inst_88149 = (state_88161[(2)]);
var inst_88150 = cljs.core.get.call(null,inst_88149,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_88151 = cljs.core.get.call(null,inst_88149,new cljs.core.Keyword(null,"errors","errors",-908790718));
var inst_88153 = [new cljs.core.Keyword("com.wsscode.pathom.core","entity","com.wsscode.pathom.core/entity",884706031)];
var inst_88154 = [inst_88150];
var inst_88155 = cljs.core.PersistentHashMap.fromArrays(inst_88153,inst_88154);
var inst_88156 = com.wsscode.pathom.fulcro.network.graphql_response_parser(inst_88155,inst_88103);
var inst_88157 = ok.call(null,inst_88156);
var state_88161__$1 = (function (){var statearr_88175 = state_88161;
(statearr_88175[(10)] = inst_88151);

return statearr_88175;
})();
var statearr_88176_89816 = state_88161__$1;
(statearr_88176_89816[(2)] = inst_88157);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88161__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (3))){
var inst_88092 = (state_88161[(2)]);
var inst_88093 = error.call(null,inst_88092);
var state_88161__$1 = state_88161;
var statearr_88180_89821 = state_88161__$1;
(statearr_88180_89821[(2)] = inst_88093);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88161__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (12))){
var state_88161__$1 = state_88161;
var statearr_88181_89822 = state_88161__$1;
(statearr_88181_89822[(2)] = true);

(statearr_88181_89822[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (2))){
var inst_88159 = (state_88161[(2)]);
var state_88161__$1 = state_88161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_88161__$1,inst_88159);
} else {
if((state_val_88162 === (11))){
var inst_88144 = (state_88161[(2)]);
var state_88161__$1 = state_88161;
if(cljs.core.truth_(inst_88144)){
var statearr_88182_89829 = state_88161__$1;
(statearr_88182_89829[(1)] = (15));

} else {
var statearr_88183_89830 = state_88161__$1;
(statearr_88183_89830[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (9))){
var inst_88128 = (state_88161[(9)]);
var inst_88133 = inst_88128.cljs$lang$protocol_mask$partition0$;
var inst_88134 = (inst_88133 & (64));
var inst_88135 = inst_88128.cljs$core$ISeq$;
var inst_88136 = (cljs.core.PROTOCOL_SENTINEL === inst_88135);
var inst_88137 = ((inst_88134) || (inst_88136));
var state_88161__$1 = state_88161;
if(cljs.core.truth_(inst_88137)){
var statearr_88184_89839 = state_88161__$1;
(statearr_88184_89839[(1)] = (12));

} else {
var statearr_88185_89841 = state_88161__$1;
(statearr_88185_89841[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (5))){
var inst_88128 = (state_88161[(9)]);
var inst_88125 = (state_88161[(2)]);
var inst_88126 = com.wsscode.async.async_cljs.throw_err.call(null,inst_88125);
var inst_88128__$1 = new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","body","com.wsscode.pathom.diplomat.http/body",839730955).cljs$core$IFn$_invoke$arity$1(inst_88126);
var inst_88130 = (inst_88128__$1 == null);
var inst_88131 = cljs.core.not(inst_88130);
var state_88161__$1 = (function (){var statearr_88186 = state_88161;
(statearr_88186[(9)] = inst_88128__$1);

return statearr_88186;
})();
if(inst_88131){
var statearr_88188_89847 = state_88161__$1;
(statearr_88188_89847[(1)] = (9));

} else {
var statearr_88192_89849 = state_88161__$1;
(statearr_88192_89849[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (14))){
var inst_88141 = (state_88161[(2)]);
var state_88161__$1 = state_88161;
var statearr_88193_89853 = state_88161__$1;
(statearr_88193_89853[(2)] = inst_88141);

(statearr_88193_89853[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (16))){
var inst_88128 = (state_88161[(9)]);
var state_88161__$1 = state_88161;
var statearr_88194_89855 = state_88161__$1;
(statearr_88194_89855[(2)] = inst_88128);

(statearr_88194_89855[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (10))){
var state_88161__$1 = state_88161;
var statearr_88195_89859 = state_88161__$1;
(statearr_88195_89859[(2)] = false);

(statearr_88195_89859[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88162 === (8))){
var inst_88122 = (state_88161[(2)]);
var inst_88123 = com.wsscode.pathom.diplomat.http.fetch.request_async.call(null,inst_88122);
var state_88161__$1 = state_88161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88161__$1,(5),inst_88123);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__,map__88086,map__88086__$1,update_http_request))
;
return ((function (switch__53637__auto__,c__54028__auto__,map__88086,map__88086__$1,update_http_request){
return (function() {
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = null;
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0 = (function (){
var statearr_88204 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_88204[(0)] = com$wsscode$pathom$fulcro$network$state_machine__53638__auto__);

(statearr_88204[(1)] = (1));

return statearr_88204;
});
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1 = (function (state_88161){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_88161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e88205){if((e88205 instanceof Object)){
var ex__53641__auto__ = e88205;
var statearr_88207_89871 = state_88161;
(statearr_88207_89871[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89874 = state_88161;
state_88161 = G__89874;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = function(state_88161){
switch(arguments.length){
case 0:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0.call(this);
case 1:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1.call(this,state_88161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0;
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1;
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__,map__88086,map__88086__$1,update_http_request))
})();
var state__54030__auto__ = (function (){var statearr_88210 = f__54029__auto__();
(statearr_88210[(6)] = c__54028__auto__);

return statearr_88210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__,map__88086,map__88086__$1,update_http_request))
);

return c__54028__auto__;
});})(map__88086,map__88086__$1,update_http_request))
);
});

com.wsscode.pathom.fulcro.network.graphql_network.cljs$lang$maxFixedArity = 2;

com.wsscode.pathom.fulcro.network.graphql_response_parser2 = (function (){var simple_keyword = cljs.core.comp.call(null,cljs.core.keyword,cljs.core.name);
return com.wsscode.pathom.core.parser.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom.core","env","com.wsscode.pathom.core/env",602275378),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.core","reader","com.wsscode.pathom.core/reader",1510046410),com.wsscode.pathom.core.map_reader_STAR_.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("com.wsscode.pathom.core","map-key-transform","com.wsscode.pathom.core/map-key-transform",-238565800),simple_keyword], null))], null),new cljs.core.Keyword("com.wsscode.pathom.core","mutate","com.wsscode.pathom.core/mutate",-2086097173),((function (simple_keyword){
return (function (env,k,_){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (simple_keyword){
return (function (){
var response = cljs.core.get.call(null,com.wsscode.pathom.core.entity.call(null,env),simple_keyword(k));
var id_param = com.wsscode.pathom.graphql.find_id.call(null,cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ast","ast",-860334068),new cljs.core.Keyword(null,"params","params",710516235)], null)),fulcro.client.primitives.tempid_QMARK_);
console.log("VOLTA",id_param,com.wsscode.pathom.core.entity.call(null,env),response);

var G__88214 = response;
if(cljs.core.truth_(id_param)){
return cljs.core.assoc.call(null,G__88214,new cljs.core.Keyword("fulcro.client.primitives","tempids","fulcro.client.primitives/tempids",1304031205),cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.val.call(null,id_param),cljs.core.get.call(null,response,simple_keyword(cljs.core.key.call(null,id_param)))]));
} else {
return G__88214;
}
});})(simple_keyword))
], null);
});})(simple_keyword))
], null));
})();
com.wsscode.pathom.fulcro.network.graphql_network2 = (function com$wsscode$pathom$fulcro$network$graphql_network2(var_args){
var G__88218 = arguments.length;
switch (G__88218) {
case 1:
return com.wsscode.pathom.fulcro.network.graphql_network2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.fulcro.network.graphql_network2.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.fulcro.network.graphql_network2.cljs$core$IFn$_invoke$arity$1 = (function (url){
return com.wsscode.pathom.fulcro.network.graphql_network2.call(null,url,cljs.core.PersistentArrayMap.EMPTY);
});

com.wsscode.pathom.fulcro.network.graphql_network2.cljs$core$IFn$_invoke$arity$2 = (function (url,config){
return com.wsscode.pathom.fulcro.network.fn_network.call(null,(function (this$,edn,ok,error){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_88287){
var state_val_88288 = (state_88287[(1)]);
if((state_val_88288 === (7))){
var state_88287__$1 = state_88287;
var statearr_88289_89906 = state_88287__$1;
(statearr_88289_89906[(2)] = false);

(statearr_88289_89906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (1))){
var state_88287__$1 = state_88287;
var statearr_88290_89915 = state_88287__$1;
(statearr_88290_89915[(2)] = null);

(statearr_88290_89915[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (4))){
var inst_88233 = (state_88287[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_88287,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_88228 = com.wsscode.pathom.core.query__GT_ast.call(null,edn);
var inst_88229 = [new cljs.core.Keyword("com.wsscode.pathom.profile","profile","com.wsscode.pathom.profile/profile",-1055198583),null];
var inst_88230 = (new cljs.core.PersistentArrayMap(null,1,inst_88229,null));
var inst_88231 = (new cljs.core.PersistentHashSet(null,inst_88230,null));
var inst_88232 = com.wsscode.pathom.core.elide_ast_nodes.call(null,inst_88228,inst_88231);
var inst_88233__$1 = com.wsscode.pathom.core.ast__GT_query.call(null,inst_88232);
var inst_88235 = [new cljs.core.Keyword("com.wsscode.pathom.graphql","tempid?","com.wsscode.pathom.graphql/tempid?",1423381701)];
var inst_88237 = [fulcro.client.primitives.tempid_QMARK_];
var inst_88238 = cljs.core.PersistentHashMap.fromArrays(inst_88235,inst_88237);
var inst_88239 = cljs.core.merge.call(null,inst_88238,config);
var inst_88240 = com.wsscode.pathom.graphql.query__GT_graphql.call(null,inst_88233__$1,inst_88239);
var inst_88242 = [new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","url","com.wsscode.pathom.diplomat.http/url",1690966630),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","method","com.wsscode.pathom.diplomat.http/method",1862305016),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","as","com.wsscode.pathom.diplomat.http/as",139380761),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","form-params","com.wsscode.pathom.diplomat.http/form-params",1015103523)];
var inst_88243 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_88244 = [inst_88240];
var inst_88245 = cljs.core.PersistentHashMap.fromArrays(inst_88243,inst_88244);
var inst_88246 = [url,new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","post","com.wsscode.pathom.diplomat.http/post",-1010788441),new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","json","com.wsscode.pathom.diplomat.http/json",2025134090),inst_88245];
var inst_88247 = cljs.core.PersistentHashMap.fromArrays(inst_88242,inst_88246);
var inst_88248 = com.wsscode.pathom.diplomat.http.fetch.request_async.call(null,inst_88247);
var state_88287__$1 = (function (){var statearr_88296 = state_88287;
(statearr_88296[(7)] = inst_88233__$1);

return statearr_88296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88287__$1,(5),inst_88248);
} else {
if((state_val_88288 === (13))){
var inst_88252 = (state_88287[(8)]);
var state_88287__$1 = state_88287;
var statearr_88300_89979 = state_88287__$1;
(statearr_88300_89979[(2)] = inst_88252);

(statearr_88300_89979[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (6))){
var inst_88252 = (state_88287[(8)]);
var inst_88258 = inst_88252.cljs$lang$protocol_mask$partition0$;
var inst_88259 = (inst_88258 & (64));
var inst_88260 = inst_88252.cljs$core$ISeq$;
var inst_88261 = (cljs.core.PROTOCOL_SENTINEL === inst_88260);
var inst_88262 = ((inst_88259) || (inst_88261));
var state_88287__$1 = state_88287;
if(cljs.core.truth_(inst_88262)){
var statearr_88303_89984 = state_88287__$1;
(statearr_88303_89984[(1)] = (9));

} else {
var statearr_88305_89985 = state_88287__$1;
(statearr_88305_89985[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (3))){
var inst_88221 = (state_88287[(2)]);
var inst_88223 = error.call(null,inst_88221);
var state_88287__$1 = state_88287;
var statearr_88306_89991 = state_88287__$1;
(statearr_88306_89991[(2)] = inst_88223);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88287__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (12))){
var inst_88252 = (state_88287[(8)]);
var inst_88271 = cljs.core.apply.call(null,cljs.core.hash_map,inst_88252);
var state_88287__$1 = state_88287;
var statearr_88308_89996 = state_88287__$1;
(statearr_88308_89996[(2)] = inst_88271);

(statearr_88308_89996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (2))){
var inst_88285 = (state_88287[(2)]);
var state_88287__$1 = state_88287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_88287__$1,inst_88285);
} else {
if((state_val_88288 === (11))){
var inst_88266 = (state_88287[(2)]);
var state_88287__$1 = state_88287;
var statearr_88310_89999 = state_88287__$1;
(statearr_88310_89999[(2)] = inst_88266);

(statearr_88310_89999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (9))){
var state_88287__$1 = state_88287;
var statearr_88313_90002 = state_88287__$1;
(statearr_88313_90002[(2)] = true);

(statearr_88313_90002[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (5))){
var inst_88252 = (state_88287[(8)]);
var inst_88250 = (state_88287[(2)]);
var inst_88251 = com.wsscode.async.async_cljs.throw_err.call(null,inst_88250);
var inst_88252__$1 = new cljs.core.Keyword("com.wsscode.pathom.diplomat.http","body","com.wsscode.pathom.diplomat.http/body",839730955).cljs$core$IFn$_invoke$arity$1(inst_88251);
var inst_88255 = (inst_88252__$1 == null);
var inst_88256 = cljs.core.not(inst_88255);
var state_88287__$1 = (function (){var statearr_88315 = state_88287;
(statearr_88315[(8)] = inst_88252__$1);

return statearr_88315;
})();
if(inst_88256){
var statearr_88316_90008 = state_88287__$1;
(statearr_88316_90008[(1)] = (6));

} else {
var statearr_88317_90009 = state_88287__$1;
(statearr_88317_90009[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (14))){
var inst_88233 = (state_88287[(7)]);
var inst_88274 = (state_88287[(2)]);
var inst_88275 = cljs.core.get.call(null,inst_88274,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_88276 = cljs.core.get.call(null,inst_88274,new cljs.core.Keyword(null,"errors","errors",-908790718));
var inst_88279 = [new cljs.core.Keyword("com.wsscode.pathom.core","entity","com.wsscode.pathom.core/entity",884706031)];
var inst_88280 = [inst_88275];
var inst_88281 = cljs.core.PersistentHashMap.fromArrays(inst_88279,inst_88280);
var inst_88282 = com.wsscode.pathom.fulcro.network.graphql_response_parser2(inst_88281,inst_88233);
var inst_88283 = ok.call(null,inst_88282);
var state_88287__$1 = (function (){var statearr_88321 = state_88287;
(statearr_88321[(9)] = inst_88276);

return statearr_88321;
})();
var statearr_88322_90015 = state_88287__$1;
(statearr_88322_90015[(2)] = inst_88283);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88287__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (10))){
var state_88287__$1 = state_88287;
var statearr_88323_90018 = state_88287__$1;
(statearr_88323_90018[(2)] = false);

(statearr_88323_90018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88288 === (8))){
var inst_88269 = (state_88287[(2)]);
var state_88287__$1 = state_88287;
if(cljs.core.truth_(inst_88269)){
var statearr_88326_90020 = state_88287__$1;
(statearr_88326_90020[(1)] = (12));

} else {
var statearr_88328_90021 = state_88287__$1;
(statearr_88328_90021[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = null;
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0 = (function (){
var statearr_88331 = [null,null,null,null,null,null,null,null,null,null];
(statearr_88331[(0)] = com$wsscode$pathom$fulcro$network$state_machine__53638__auto__);

(statearr_88331[(1)] = (1));

return statearr_88331;
});
var com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1 = (function (state_88287){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_88287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e88332){if((e88332 instanceof Object)){
var ex__53641__auto__ = e88332;
var statearr_88333_90030 = state_88287;
(statearr_88333_90030[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88287);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88332;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__90031 = state_88287;
state_88287 = G__90031;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__ = function(state_88287){
switch(arguments.length){
case 0:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0.call(this);
case 1:
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1.call(this,state_88287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____0;
com$wsscode$pathom$fulcro$network$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$pathom$fulcro$network$state_machine__53638__auto____1;
return com$wsscode$pathom$fulcro$network$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_88336 = f__54029__auto__();
(statearr_88336[(6)] = c__54028__auto__);

return statearr_88336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
}));
});

com.wsscode.pathom.fulcro.network.graphql_network2.cljs$lang$maxFixedArity = 2;

/**
 * Debounce calls, all the call inputs will be stored and the final call will receive a vector with every
 *   collected input during the debounce.
 */
com.wsscode.pathom.fulcro.network.debounce = (function com$wsscode$pathom$fulcro$network$debounce(f,interval){
var timer = cljs.core.atom.call(null,(0));
var calls = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
return ((function (timer,calls){
return (function() { 
var G__90038__delegate = function (args){
clearTimeout(cljs.core.deref.call(null,timer));

cljs.core.swap_BANG_.call(null,calls,cljs.core.conj,args);

return cljs.core.reset_BANG_.call(null,timer,setTimeout(((function (timer,calls){
return (function (){
f.call(null,cljs.core.deref.call(null,calls));

return cljs.core.reset_BANG_.call(null,calls,cljs.core.PersistentVector.EMPTY);
});})(timer,calls))
,interval));
};
var G__90038 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__90042__i = 0, G__90042__a = new Array(arguments.length -  0);
while (G__90042__i < G__90042__a.length) {G__90042__a[G__90042__i] = arguments[G__90042__i + 0]; ++G__90042__i;}
  args = new cljs.core.IndexedSeq(G__90042__a,0,null);
} 
return G__90038__delegate.call(this,args);};
G__90038.cljs$lang$maxFixedArity = 0;
G__90038.cljs$lang$applyTo = (function (arglist__90043){
var args = cljs.core.seq(arglist__90043);
return G__90038__delegate(args);
});
G__90038.cljs$core$IFn$_invoke$arity$variadic = G__90038__delegate;
return G__90038;
})()
;
;})(timer,calls))
});
/**
 * Given a list of requests [query ok-callback error-callback], reduces the number of requests to the minimum by merging
 *   the requests. Not all requests are mergeable, so this still might output multiple requests.
 */
com.wsscode.pathom.fulcro.network.group_mergeable_requests = (function com$wsscode$pathom$fulcro$network$group_mergeable_requests(requests){
if(cljs.core.seq.call(null,requests)){
var vec__88342 = requests;
var seq__88343 = cljs.core.seq.call(null,vec__88342);
var first__88344 = cljs.core.first.call(null,seq__88343);
var seq__88343__$1 = cljs.core.next.call(null,seq__88343);
var vec__88345 = first__88344;
var q = cljs.core.nth.call(null,vec__88345,(0),null);
var ok = cljs.core.nth.call(null,vec__88345,(1),null);
var err = cljs.core.nth.call(null,vec__88345,(2),null);
var tail = seq__88343__$1;
var groups = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305),q,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","ok","com.wsscode.pathom.fulcro.network/ok",-297624695),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ok], null),new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","err","com.wsscode.pathom.fulcro.network/err",-930100396),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [err], null)], null)], null);
var left = tail;
var groups__$1 = groups;
var current = (0);
var next_cycle = cljs.core.PersistentVector.EMPTY;
while(true){
var temp__5718__auto__ = cljs.core.first.call(null,left);
if(cljs.core.truth_(temp__5718__auto__)){
var vec__88401 = temp__5718__auto__;
var query = cljs.core.nth.call(null,vec__88401,(0),null);
var ok__$1 = cljs.core.nth.call(null,vec__88401,(1),null);
var err__$1 = cljs.core.nth.call(null,vec__88401,(2),null);
var req = vec__88401;
var cur_group = cljs.core.get.call(null,groups__$1,current);
var merged = com.wsscode.pathom.core.merge_queries.call(null,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305).cljs$core$IFn$_invoke$arity$1(cur_group),query);
if(cljs.core.truth_(merged)){
var G__90068 = cljs.core.next.call(null,left);
var G__90069 = cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,groups__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [current,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305)], null),merged),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [current,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","ok","com.wsscode.pathom.fulcro.network/ok",-297624695)], null),cljs.core.conj,ok__$1),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [current,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","err","com.wsscode.pathom.fulcro.network/err",-930100396)], null),cljs.core.conj,err__$1);
var G__90070 = current;
var G__90071 = next_cycle;
left = G__90068;
groups__$1 = G__90069;
current = G__90070;
next_cycle = G__90071;
continue;
} else {
var G__90078 = cljs.core.next.call(null,left);
var G__90079 = groups__$1;
var G__90080 = current;
var G__90081 = cljs.core.conj.call(null,next_cycle,req);
left = G__90078;
groups__$1 = G__90079;
current = G__90080;
next_cycle = G__90081;
continue;
}
} else {
if(cljs.core.seq.call(null,next_cycle)){
var vec__88407 = next_cycle;
var seq__88408 = cljs.core.seq.call(null,vec__88407);
var first__88409 = cljs.core.first.call(null,seq__88408);
var seq__88408__$1 = cljs.core.next.call(null,seq__88408);
var vec__88410 = first__88409;
var q__$1 = cljs.core.nth.call(null,vec__88410,(0),null);
var ok__$1 = cljs.core.nth.call(null,vec__88410,(1),null);
var err__$1 = cljs.core.nth.call(null,vec__88410,(2),null);
var tail__$1 = seq__88408__$1;
var G__90089 = tail__$1;
var G__90090 = cljs.core.conj.call(null,groups__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305),q__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","ok","com.wsscode.pathom.fulcro.network/ok",-297624695),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ok__$1], null),new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","err","com.wsscode.pathom.fulcro.network/err",-930100396),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [err__$1], null)], null));
var G__90091 = (current + (1));
var G__90092 = cljs.core.PersistentVector.EMPTY;
left = G__90089;
groups__$1 = G__90090;
current = G__90091;
next_cycle = G__90092;
continue;
} else {
return groups__$1;
}
}
break;
}
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Setup a debounce to batch network requests. The callback function f will be called with a list of requests to be made
 *   after merging as max as possible.
 */
com.wsscode.pathom.fulcro.network.batch_send = (function com$wsscode$pathom$fulcro$network$batch_send(f,delay){
return com.wsscode.pathom.fulcro.network.debounce.call(null,(function (p1__88426_SHARP_){
return f.call(null,com.wsscode.pathom.fulcro.network.group_mergeable_requests.call(null,p1__88426_SHARP_));
}),delay);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.wsscode.pathom.fulcro.network.BatchNetwork = (function (send_fn,__meta,__extmap,__hash){
this.send_fn = send_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k88430,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__88442 = k88430;
var G__88442__$1 = (((G__88442 instanceof cljs.core.Keyword))?G__88442.fqn:null);
switch (G__88442__$1) {
case "send-fn":
return self__.send_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k88430,else__4388__auto__);

}
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__88450){
var vec__88451 = p__88450;
var k__4408__auto__ = cljs.core.nth.call(null,vec__88451,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__88451,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#com.wsscode.pathom.fulcro.network.BatchNetwork{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__88429){
var self__ = this;
var G__88429__$1 = this;
return (new cljs.core.RecordIter((0),G__88429__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"send-fn","send-fn",351002041)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(self__.send_fn,self__.__meta,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (176772946 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this88431,other88432){
var self__ = this;
var this88431__$1 = this;
return (((!((other88432 == null)))) && ((this88431__$1.constructor === other88432.constructor)) && (cljs.core._EQ_.call(null,this88431__$1.send_fn,other88432.send_fn)) && (cljs.core._EQ_.call(null,this88431__$1.__extmap,other88432.__extmap)));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (_,edn,ok,error){
var self__ = this;
var ___$1 = this;
return self__.send_fn.call(null,edn,ok,error);
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(self__.send_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__88429){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__88494 = cljs.core.keyword_identical_QMARK_;
var expr__88495 = k__4393__auto__;
if(cljs.core.truth_(pred__88494.call(null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),expr__88495))){
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(G__88429,self__.__meta,self__.__extmap,null));
} else {
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(self__.send_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__88429),null));
}
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn,null))], null),self__.__extmap));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__88429){
var self__ = this;
var this__4384__auto____$1 = this;
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(self__.send_fn,G__88429,self__.__extmap,self__.__hash));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

com.wsscode.pathom.fulcro.network.BatchNetwork.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"send-fn","send-fn",1991533568,null)], null);
});

com.wsscode.pathom.fulcro.network.BatchNetwork.cljs$lang$type = true;

com.wsscode.pathom.fulcro.network.BatchNetwork.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"com.wsscode.pathom.fulcro.network/BatchNetwork",null,(1),null));
});

com.wsscode.pathom.fulcro.network.BatchNetwork.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"com.wsscode.pathom.fulcro.network/BatchNetwork");
});

/**
 * Positional factory function for com.wsscode.pathom.fulcro.network/BatchNetwork.
 */
com.wsscode.pathom.fulcro.network.__GT_BatchNetwork = (function com$wsscode$pathom$fulcro$network$__GT_BatchNetwork(send_fn){
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(send_fn,null,null,null));
});

/**
 * Factory function for com.wsscode.pathom.fulcro.network/BatchNetwork, taking a map of keywords to field values.
 */
com.wsscode.pathom.fulcro.network.map__GT_BatchNetwork = (function com$wsscode$pathom$fulcro$network$map__GT_BatchNetwork(G__88435){
var extmap__4424__auto__ = (function (){var G__88532 = cljs.core.dissoc.call(null,G__88435,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
if(cljs.core.record_QMARK_.call(null,G__88435)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__88532);
} else {
return G__88532;
}
})();
return (new com.wsscode.pathom.fulcro.network.BatchNetwork(new cljs.core.Keyword(null,"send-fn","send-fn",351002041).cljs$core$IFn$_invoke$arity$1(G__88435),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

/**
 * Wraps a network send calls with a debounce that will accumulate, merge and batch send requests in a time frame
 *   interval.
 */
com.wsscode.pathom.fulcro.network.batch_network = (function com$wsscode$pathom$fulcro$network$batch_network(var_args){
var G__88571 = arguments.length;
switch (G__88571) {
case 1:
return com.wsscode.pathom.fulcro.network.batch_network.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom.fulcro.network.batch_network.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

com.wsscode.pathom.fulcro.network.batch_network.cljs$core$IFn$_invoke$arity$1 = (function (network){
return com.wsscode.pathom.fulcro.network.batch_network.call(null,network,(10));
});

com.wsscode.pathom.fulcro.network.batch_network.cljs$core$IFn$_invoke$arity$2 = (function (network,delay){
var send_fn = com.wsscode.pathom.fulcro.network.batch_send.call(null,(function (reqs){
var seq__88583 = cljs.core.seq.call(null,reqs);
var chunk__88584 = null;
var count__88585 = (0);
var i__88586 = (0);
while(true){
if((i__88586 < count__88585)){
var map__88728 = cljs.core._nth(chunk__88584,i__88586);
var map__88728__$1 = (((((!((map__88728 == null))))?(((((map__88728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88728.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88728):map__88728);
var query = cljs.core.get.call(null,map__88728__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305));
var ok = cljs.core.get.call(null,map__88728__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","ok","com.wsscode.pathom.fulcro.network/ok",-297624695));
var err = cljs.core.get.call(null,map__88728__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","err","com.wsscode.pathom.fulcro.network/err",-930100396));
fulcro.client.network.send(network,query,((function (seq__88583,chunk__88584,count__88585,i__88586,map__88728,map__88728__$1,query,ok,err){
return (function (p1__88562_SHARP_){
var seq__88737 = cljs.core.seq.call(null,ok);
var chunk__88738 = null;
var count__88739 = (0);
var i__88740 = (0);
while(true){
if((i__88740 < count__88739)){
var f = cljs.core._nth(chunk__88738,i__88740);
f.call(null,p1__88562_SHARP_);


var G__90144 = seq__88737;
var G__90145 = chunk__88738;
var G__90146 = count__88739;
var G__90147 = (i__88740 + (1));
seq__88737 = G__90144;
chunk__88738 = G__90145;
count__88739 = G__90146;
i__88740 = G__90147;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__88737);
if(temp__5720__auto__){
var seq__88737__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88737__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__88737__$1);
var G__90150 = cljs.core.chunk_rest.call(null,seq__88737__$1);
var G__90151 = c__4550__auto__;
var G__90152 = cljs.core.count.call(null,c__4550__auto__);
var G__90153 = (0);
seq__88737 = G__90150;
chunk__88738 = G__90151;
count__88739 = G__90152;
i__88740 = G__90153;
continue;
} else {
var f = cljs.core.first.call(null,seq__88737__$1);
f.call(null,p1__88562_SHARP_);


var G__90155 = cljs.core.next.call(null,seq__88737__$1);
var G__90156 = null;
var G__90157 = (0);
var G__90158 = (0);
seq__88737 = G__90155;
chunk__88738 = G__90156;
count__88739 = G__90157;
i__88740 = G__90158;
continue;
}
} else {
return null;
}
}
break;
}
});})(seq__88583,chunk__88584,count__88585,i__88586,map__88728,map__88728__$1,query,ok,err))
,((function (seq__88583,chunk__88584,count__88585,i__88586,map__88728,map__88728__$1,query,ok,err){
return (function (p1__88565_SHARP_){
var seq__88761 = cljs.core.seq.call(null,err);
var chunk__88762 = null;
var count__88763 = (0);
var i__88764 = (0);
while(true){
if((i__88764 < count__88763)){
var f = cljs.core._nth(chunk__88762,i__88764);
f.call(null,p1__88565_SHARP_);


var G__90163 = seq__88761;
var G__90164 = chunk__88762;
var G__90165 = count__88763;
var G__90166 = (i__88764 + (1));
seq__88761 = G__90163;
chunk__88762 = G__90164;
count__88763 = G__90165;
i__88764 = G__90166;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__88761);
if(temp__5720__auto__){
var seq__88761__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88761__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__88761__$1);
var G__90168 = cljs.core.chunk_rest.call(null,seq__88761__$1);
var G__90169 = c__4550__auto__;
var G__90170 = cljs.core.count.call(null,c__4550__auto__);
var G__90171 = (0);
seq__88761 = G__90168;
chunk__88762 = G__90169;
count__88763 = G__90170;
i__88764 = G__90171;
continue;
} else {
var f = cljs.core.first.call(null,seq__88761__$1);
f.call(null,p1__88565_SHARP_);


var G__90177 = cljs.core.next.call(null,seq__88761__$1);
var G__90178 = null;
var G__90179 = (0);
var G__90180 = (0);
seq__88761 = G__90177;
chunk__88762 = G__90178;
count__88763 = G__90179;
i__88764 = G__90180;
continue;
}
} else {
return null;
}
}
break;
}
});})(seq__88583,chunk__88584,count__88585,i__88586,map__88728,map__88728__$1,query,ok,err))
);


var G__90182 = seq__88583;
var G__90183 = chunk__88584;
var G__90184 = count__88585;
var G__90185 = (i__88586 + (1));
seq__88583 = G__90182;
chunk__88584 = G__90183;
count__88585 = G__90184;
i__88586 = G__90185;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__88583);
if(temp__5720__auto__){
var seq__88583__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88583__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__88583__$1);
var G__90186 = cljs.core.chunk_rest.call(null,seq__88583__$1);
var G__90187 = c__4550__auto__;
var G__90188 = cljs.core.count.call(null,c__4550__auto__);
var G__90189 = (0);
seq__88583 = G__90186;
chunk__88584 = G__90187;
count__88585 = G__90188;
i__88586 = G__90189;
continue;
} else {
var map__88787 = cljs.core.first.call(null,seq__88583__$1);
var map__88787__$1 = (((((!((map__88787 == null))))?(((((map__88787.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88787.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88787):map__88787);
var query = cljs.core.get.call(null,map__88787__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","query","com.wsscode.pathom.fulcro.network/query",-259045305));
var ok = cljs.core.get.call(null,map__88787__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","ok","com.wsscode.pathom.fulcro.network/ok",-297624695));
var err = cljs.core.get.call(null,map__88787__$1,new cljs.core.Keyword("com.wsscode.pathom.fulcro.network","err","com.wsscode.pathom.fulcro.network/err",-930100396));
fulcro.client.network.send(network,query,((function (seq__88583,chunk__88584,count__88585,i__88586,map__88787,map__88787__$1,query,ok,err,seq__88583__$1,temp__5720__auto__){
return (function (p1__88562_SHARP_){
var seq__88791 = cljs.core.seq.call(null,ok);
var chunk__88792 = null;
var count__88793 = (0);
var i__88794 = (0);
while(true){
if((i__88794 < count__88793)){
var f = cljs.core._nth(chunk__88792,i__88794);
f.call(null,p1__88562_SHARP_);


var G__90194 = seq__88791;
var G__90195 = chunk__88792;
var G__90196 = count__88793;
var G__90197 = (i__88794 + (1));
seq__88791 = G__90194;
chunk__88792 = G__90195;
count__88793 = G__90196;
i__88794 = G__90197;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__88791);
if(temp__5720__auto____$1){
var seq__88791__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88791__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__88791__$1);
var G__90200 = cljs.core.chunk_rest.call(null,seq__88791__$1);
var G__90201 = c__4550__auto__;
var G__90202 = cljs.core.count.call(null,c__4550__auto__);
var G__90203 = (0);
seq__88791 = G__90200;
chunk__88792 = G__90201;
count__88793 = G__90202;
i__88794 = G__90203;
continue;
} else {
var f = cljs.core.first.call(null,seq__88791__$1);
f.call(null,p1__88562_SHARP_);


var G__90205 = cljs.core.next.call(null,seq__88791__$1);
var G__90206 = null;
var G__90207 = (0);
var G__90208 = (0);
seq__88791 = G__90205;
chunk__88792 = G__90206;
count__88793 = G__90207;
i__88794 = G__90208;
continue;
}
} else {
return null;
}
}
break;
}
});})(seq__88583,chunk__88584,count__88585,i__88586,map__88787,map__88787__$1,query,ok,err,seq__88583__$1,temp__5720__auto__))
,((function (seq__88583,chunk__88584,count__88585,i__88586,map__88787,map__88787__$1,query,ok,err,seq__88583__$1,temp__5720__auto__){
return (function (p1__88565_SHARP_){
var seq__88816 = cljs.core.seq.call(null,err);
var chunk__88817 = null;
var count__88818 = (0);
var i__88819 = (0);
while(true){
if((i__88819 < count__88818)){
var f = cljs.core._nth(chunk__88817,i__88819);
f.call(null,p1__88565_SHARP_);


var G__90212 = seq__88816;
var G__90213 = chunk__88817;
var G__90214 = count__88818;
var G__90215 = (i__88819 + (1));
seq__88816 = G__90212;
chunk__88817 = G__90213;
count__88818 = G__90214;
i__88819 = G__90215;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__88816);
if(temp__5720__auto____$1){
var seq__88816__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88816__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__88816__$1);
var G__90219 = cljs.core.chunk_rest.call(null,seq__88816__$1);
var G__90220 = c__4550__auto__;
var G__90221 = cljs.core.count.call(null,c__4550__auto__);
var G__90222 = (0);
seq__88816 = G__90219;
chunk__88817 = G__90220;
count__88818 = G__90221;
i__88819 = G__90222;
continue;
} else {
var f = cljs.core.first.call(null,seq__88816__$1);
f.call(null,p1__88565_SHARP_);


var G__90227 = cljs.core.next.call(null,seq__88816__$1);
var G__90228 = null;
var G__90229 = (0);
var G__90230 = (0);
seq__88816 = G__90227;
chunk__88817 = G__90228;
count__88818 = G__90229;
i__88819 = G__90230;
continue;
}
} else {
return null;
}
}
break;
}
});})(seq__88583,chunk__88584,count__88585,i__88586,map__88787,map__88787__$1,query,ok,err,seq__88583__$1,temp__5720__auto__))
);


var G__90231 = cljs.core.next.call(null,seq__88583__$1);
var G__90232 = null;
var G__90233 = (0);
var G__90234 = (0);
seq__88583 = G__90231;
chunk__88584 = G__90232;
count__88585 = G__90233;
i__88586 = G__90234;
continue;
}
} else {
return null;
}
}
break;
}
}),delay);
return com.wsscode.pathom.fulcro.network.map__GT_BatchNetwork.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn], null));
});

com.wsscode.pathom.fulcro.network.batch_network.cljs$lang$maxFixedArity = 2;

/**
 * Decide the union branch based on the Fulcro union component ident dispatch. This is
 *   useful if you are using a parser in the Clojurescript side living in the same process
 *   as the client app, this makes the union picking automatic on those cases.
 */
com.wsscode.pathom.fulcro.network.fulcro_union_path = (function com$wsscode$pathom$fulcro$network$fulcro_union_path(p__88835){
var map__88837 = p__88835;
var map__88837__$1 = (((((!((map__88837 == null))))?(((((map__88837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88837):map__88837);
var env = map__88837__$1;
var ast = cljs.core.get.call(null,map__88837__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var component = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(ast);
var props = com.wsscode.pathom.core.entity.call(null,env);
var vec__88845 = fulcro.client.primitives.get_ident.call(null,component,props);
var type = cljs.core.nth.call(null,vec__88845,(0),null);
var _ = cljs.core.nth.call(null,vec__88845,(1),null);
return type;
});

//# sourceMappingURL=com.wsscode.pathom.fulcro.network.js.map
