goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4131__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom(el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__56464 = arguments.length;
switch (G__56464) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__56475 = arguments.length;
switch (G__56475) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__56493 = arguments.length;
switch (G__56493) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__56520 = arguments.length;
switch (G__56520) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__56550 = arguments.length;
switch (G__56550) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__56567 = arguments.length;
switch (G__56567) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e56580){if((e56580 instanceof Object)){
var e = e56580;
return console.log("didnt support attachEvent",el,e);
} else {
throw e56580;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__56586 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__56587 = null;
var count__56588 = (0);
var i__56589 = (0);
while(true){
if((i__56589 < count__56588)){
var el = cljs.core._nth(chunk__56587,i__56589);
var handler_57564__$1 = ((function (seq__56586,chunk__56587,count__56588,i__56589,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__56586,chunk__56587,count__56588,i__56589,el))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_57564__$1);


var G__57567 = seq__56586;
var G__57568 = chunk__56587;
var G__57569 = count__56588;
var G__57570 = (i__56589 + (1));
seq__56586 = G__57567;
chunk__56587 = G__57568;
count__56588 = G__57569;
i__56589 = G__57570;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56586);
if(temp__5720__auto__){
var seq__56586__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56586__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__56586__$1);
var G__57572 = cljs.core.chunk_rest.call(null,seq__56586__$1);
var G__57573 = c__4550__auto__;
var G__57574 = cljs.core.count.call(null,c__4550__auto__);
var G__57575 = (0);
seq__56586 = G__57572;
chunk__56587 = G__57573;
count__56588 = G__57574;
i__56589 = G__57575;
continue;
} else {
var el = cljs.core.first.call(null,seq__56586__$1);
var handler_57579__$1 = ((function (seq__56586,chunk__56587,count__56588,i__56589,el,seq__56586__$1,temp__5720__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__56586,chunk__56587,count__56588,i__56589,el,seq__56586__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_57579__$1);


var G__57581 = cljs.core.next.call(null,seq__56586__$1);
var G__57582 = null;
var G__57583 = (0);
var G__57584 = (0);
seq__56586 = G__57581;
chunk__56587 = G__57582;
count__56588 = G__57583;
i__56589 = G__57584;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__56616 = arguments.length;
switch (G__56616) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__56639 = cljs.core.seq.call(null,events);
var chunk__56641 = null;
var count__56642 = (0);
var i__56643 = (0);
while(true){
if((i__56643 < count__56642)){
var vec__56657 = cljs.core._nth(chunk__56641,i__56643);
var k = cljs.core.nth.call(null,vec__56657,(0),null);
var v = cljs.core.nth.call(null,vec__56657,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__57596 = seq__56639;
var G__57597 = chunk__56641;
var G__57598 = count__56642;
var G__57599 = (i__56643 + (1));
seq__56639 = G__57596;
chunk__56641 = G__57597;
count__56642 = G__57598;
i__56643 = G__57599;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56639);
if(temp__5720__auto__){
var seq__56639__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56639__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__56639__$1);
var G__57600 = cljs.core.chunk_rest.call(null,seq__56639__$1);
var G__57601 = c__4550__auto__;
var G__57602 = cljs.core.count.call(null,c__4550__auto__);
var G__57603 = (0);
seq__56639 = G__57600;
chunk__56641 = G__57601;
count__56642 = G__57602;
i__56643 = G__57603;
continue;
} else {
var vec__56666 = cljs.core.first.call(null,seq__56639__$1);
var k = cljs.core.nth.call(null,vec__56666,(0),null);
var v = cljs.core.nth.call(null,vec__56666,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__57608 = cljs.core.next.call(null,seq__56639__$1);
var G__57609 = null;
var G__57610 = (0);
var G__57611 = (0);
seq__56639 = G__57608;
chunk__56641 = G__57609;
count__56642 = G__57610;
i__56643 = G__57611;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__56673 = cljs.core.seq.call(null,styles);
var chunk__56674 = null;
var count__56675 = (0);
var i__56676 = (0);
while(true){
if((i__56676 < count__56675)){
var vec__56699 = cljs.core._nth(chunk__56674,i__56676);
var k = cljs.core.nth.call(null,vec__56699,(0),null);
var v = cljs.core.nth.call(null,vec__56699,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__57614 = seq__56673;
var G__57615 = chunk__56674;
var G__57616 = count__56675;
var G__57617 = (i__56676 + (1));
seq__56673 = G__57614;
chunk__56674 = G__57615;
count__56675 = G__57616;
i__56676 = G__57617;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56673);
if(temp__5720__auto__){
var seq__56673__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56673__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__56673__$1);
var G__57618 = cljs.core.chunk_rest.call(null,seq__56673__$1);
var G__57619 = c__4550__auto__;
var G__57620 = cljs.core.count.call(null,c__4550__auto__);
var G__57621 = (0);
seq__56673 = G__57618;
chunk__56674 = G__57619;
count__56675 = G__57620;
i__56676 = G__57621;
continue;
} else {
var vec__56704 = cljs.core.first.call(null,seq__56673__$1);
var k = cljs.core.nth.call(null,vec__56704,(0),null);
var v = cljs.core.nth.call(null,vec__56704,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__57622 = cljs.core.next.call(null,seq__56673__$1);
var G__57623 = null;
var G__57624 = (0);
var G__57625 = (0);
seq__56673 = G__57622;
chunk__56674 = G__57623;
count__56675 = G__57624;
i__56676 = G__57625;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__56713_57628 = key;
var G__56713_57629__$1 = (((G__56713_57628 instanceof cljs.core.Keyword))?G__56713_57628.fqn:null);
switch (G__56713_57629__$1) {
case "id":
el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "class":
el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_57635 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4131__auto__ = goog.string.startsWith(ks_57635,"data-");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.string.startsWith(ks_57635,"aria-");
}
})())){
el.setAttribute(ks_57635,value);
} else {
(el[ks_57635] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__56730){
var map__56731 = p__56730;
var map__56731__$1 = (((((!((map__56731 == null))))?(((((map__56731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56731.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56731):map__56731);
var props = map__56731__$1;
var class$ = cljs.core.get.call(null,map__56731__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__56734 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__56734,(0),null);
var tag_id = cljs.core.nth.call(null,vec__56734,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__56734,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__56743 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__56743,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__56743;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__56768 = arguments.length;
switch (G__56768) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__56777){
var vec__56778 = p__56777;
var seq__56779 = cljs.core.seq.call(null,vec__56778);
var first__56780 = cljs.core.first.call(null,seq__56779);
var seq__56779__$1 = cljs.core.next.call(null,seq__56779);
var nn = first__56780;
var first__56780__$1 = cljs.core.first.call(null,seq__56779__$1);
var seq__56779__$2 = cljs.core.next.call(null,seq__56779__$1);
var np = first__56780__$1;
var nc = seq__56779__$2;
var node = vec__56778;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__56787 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__56787,(0),null);
var node_children = cljs.core.nth.call(null,vec__56787,(1),null);
var seq__56792_57660 = cljs.core.seq.call(null,node_children);
var chunk__56793_57661 = null;
var count__56794_57662 = (0);
var i__56795_57663 = (0);
while(true){
if((i__56795_57663 < count__56794_57662)){
var child_struct_57665 = cljs.core._nth(chunk__56793_57661,i__56795_57663);
var children_57667 = shadow.dom.dom_node.call(null,child_struct_57665);
if(cljs.core.seq_QMARK_.call(null,children_57667)){
var seq__56845_57669 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_57667));
var chunk__56847_57670 = null;
var count__56848_57671 = (0);
var i__56849_57672 = (0);
while(true){
if((i__56849_57672 < count__56848_57671)){
var child_57675 = cljs.core._nth(chunk__56847_57670,i__56849_57672);
if(cljs.core.truth_(child_57675)){
shadow.dom.append.call(null,node,child_57675);


var G__57676 = seq__56845_57669;
var G__57677 = chunk__56847_57670;
var G__57678 = count__56848_57671;
var G__57679 = (i__56849_57672 + (1));
seq__56845_57669 = G__57676;
chunk__56847_57670 = G__57677;
count__56848_57671 = G__57678;
i__56849_57672 = G__57679;
continue;
} else {
var G__57681 = seq__56845_57669;
var G__57682 = chunk__56847_57670;
var G__57683 = count__56848_57671;
var G__57684 = (i__56849_57672 + (1));
seq__56845_57669 = G__57681;
chunk__56847_57670 = G__57682;
count__56848_57671 = G__57683;
i__56849_57672 = G__57684;
continue;
}
} else {
var temp__5720__auto___57686 = cljs.core.seq.call(null,seq__56845_57669);
if(temp__5720__auto___57686){
var seq__56845_57688__$1 = temp__5720__auto___57686;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56845_57688__$1)){
var c__4550__auto___57689 = cljs.core.chunk_first.call(null,seq__56845_57688__$1);
var G__57690 = cljs.core.chunk_rest.call(null,seq__56845_57688__$1);
var G__57691 = c__4550__auto___57689;
var G__57692 = cljs.core.count.call(null,c__4550__auto___57689);
var G__57693 = (0);
seq__56845_57669 = G__57690;
chunk__56847_57670 = G__57691;
count__56848_57671 = G__57692;
i__56849_57672 = G__57693;
continue;
} else {
var child_57696 = cljs.core.first.call(null,seq__56845_57688__$1);
if(cljs.core.truth_(child_57696)){
shadow.dom.append.call(null,node,child_57696);


var G__57697 = cljs.core.next.call(null,seq__56845_57688__$1);
var G__57698 = null;
var G__57699 = (0);
var G__57700 = (0);
seq__56845_57669 = G__57697;
chunk__56847_57670 = G__57698;
count__56848_57671 = G__57699;
i__56849_57672 = G__57700;
continue;
} else {
var G__57702 = cljs.core.next.call(null,seq__56845_57688__$1);
var G__57703 = null;
var G__57704 = (0);
var G__57705 = (0);
seq__56845_57669 = G__57702;
chunk__56847_57670 = G__57703;
count__56848_57671 = G__57704;
i__56849_57672 = G__57705;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_57667);
}


var G__57709 = seq__56792_57660;
var G__57710 = chunk__56793_57661;
var G__57711 = count__56794_57662;
var G__57712 = (i__56795_57663 + (1));
seq__56792_57660 = G__57709;
chunk__56793_57661 = G__57710;
count__56794_57662 = G__57711;
i__56795_57663 = G__57712;
continue;
} else {
var temp__5720__auto___57716 = cljs.core.seq.call(null,seq__56792_57660);
if(temp__5720__auto___57716){
var seq__56792_57717__$1 = temp__5720__auto___57716;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56792_57717__$1)){
var c__4550__auto___57719 = cljs.core.chunk_first.call(null,seq__56792_57717__$1);
var G__57720 = cljs.core.chunk_rest.call(null,seq__56792_57717__$1);
var G__57721 = c__4550__auto___57719;
var G__57722 = cljs.core.count.call(null,c__4550__auto___57719);
var G__57723 = (0);
seq__56792_57660 = G__57720;
chunk__56793_57661 = G__57721;
count__56794_57662 = G__57722;
i__56795_57663 = G__57723;
continue;
} else {
var child_struct_57724 = cljs.core.first.call(null,seq__56792_57717__$1);
var children_57725 = shadow.dom.dom_node.call(null,child_struct_57724);
if(cljs.core.seq_QMARK_.call(null,children_57725)){
var seq__56871_57727 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_57725));
var chunk__56873_57728 = null;
var count__56874_57729 = (0);
var i__56875_57730 = (0);
while(true){
if((i__56875_57730 < count__56874_57729)){
var child_57733 = cljs.core._nth(chunk__56873_57728,i__56875_57730);
if(cljs.core.truth_(child_57733)){
shadow.dom.append.call(null,node,child_57733);


var G__57735 = seq__56871_57727;
var G__57736 = chunk__56873_57728;
var G__57737 = count__56874_57729;
var G__57738 = (i__56875_57730 + (1));
seq__56871_57727 = G__57735;
chunk__56873_57728 = G__57736;
count__56874_57729 = G__57737;
i__56875_57730 = G__57738;
continue;
} else {
var G__57741 = seq__56871_57727;
var G__57742 = chunk__56873_57728;
var G__57743 = count__56874_57729;
var G__57744 = (i__56875_57730 + (1));
seq__56871_57727 = G__57741;
chunk__56873_57728 = G__57742;
count__56874_57729 = G__57743;
i__56875_57730 = G__57744;
continue;
}
} else {
var temp__5720__auto___57746__$1 = cljs.core.seq.call(null,seq__56871_57727);
if(temp__5720__auto___57746__$1){
var seq__56871_57747__$1 = temp__5720__auto___57746__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56871_57747__$1)){
var c__4550__auto___57749 = cljs.core.chunk_first.call(null,seq__56871_57747__$1);
var G__57750 = cljs.core.chunk_rest.call(null,seq__56871_57747__$1);
var G__57751 = c__4550__auto___57749;
var G__57752 = cljs.core.count.call(null,c__4550__auto___57749);
var G__57753 = (0);
seq__56871_57727 = G__57750;
chunk__56873_57728 = G__57751;
count__56874_57729 = G__57752;
i__56875_57730 = G__57753;
continue;
} else {
var child_57754 = cljs.core.first.call(null,seq__56871_57747__$1);
if(cljs.core.truth_(child_57754)){
shadow.dom.append.call(null,node,child_57754);


var G__57755 = cljs.core.next.call(null,seq__56871_57747__$1);
var G__57756 = null;
var G__57757 = (0);
var G__57758 = (0);
seq__56871_57727 = G__57755;
chunk__56873_57728 = G__57756;
count__56874_57729 = G__57757;
i__56875_57730 = G__57758;
continue;
} else {
var G__57759 = cljs.core.next.call(null,seq__56871_57747__$1);
var G__57761 = null;
var G__57762 = (0);
var G__57763 = (0);
seq__56871_57727 = G__57759;
chunk__56873_57728 = G__57761;
count__56874_57729 = G__57762;
i__56875_57730 = G__57763;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_57725);
}


var G__57764 = cljs.core.next.call(null,seq__56792_57717__$1);
var G__57765 = null;
var G__57766 = (0);
var G__57767 = (0);
seq__56792_57660 = G__57764;
chunk__56793_57661 = G__57765;
count__56794_57662 = G__57766;
i__56795_57663 = G__57767;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__56902 = cljs.core.seq.call(null,node);
var chunk__56903 = null;
var count__56904 = (0);
var i__56905 = (0);
while(true){
if((i__56905 < count__56904)){
var n = cljs.core._nth(chunk__56903,i__56905);
shadow.dom.remove.call(null,n);


var G__57779 = seq__56902;
var G__57780 = chunk__56903;
var G__57781 = count__56904;
var G__57782 = (i__56905 + (1));
seq__56902 = G__57779;
chunk__56903 = G__57780;
count__56904 = G__57781;
i__56905 = G__57782;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56902);
if(temp__5720__auto__){
var seq__56902__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56902__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__56902__$1);
var G__57783 = cljs.core.chunk_rest.call(null,seq__56902__$1);
var G__57784 = c__4550__auto__;
var G__57785 = cljs.core.count.call(null,c__4550__auto__);
var G__57786 = (0);
seq__56902 = G__57783;
chunk__56903 = G__57784;
count__56904 = G__57785;
i__56905 = G__57786;
continue;
} else {
var n = cljs.core.first.call(null,seq__56902__$1);
shadow.dom.remove.call(null,n);


var G__57787 = cljs.core.next.call(null,seq__56902__$1);
var G__57788 = null;
var G__57789 = (0);
var G__57790 = (0);
seq__56902 = G__57787;
chunk__56903 = G__57788;
count__56904 = G__57789;
i__56905 = G__57790;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__56915 = arguments.length;
switch (G__56915) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node.call(null,el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__56927 = arguments.length;
switch (G__56927) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node.call(null,el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__56952 = arguments.length;
switch (G__56952) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4131__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node.call(null,node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___57806 = arguments.length;
var i__4731__auto___57807 = (0);
while(true){
if((i__4731__auto___57807 < len__4730__auto___57806)){
args__4736__auto__.push((arguments[i__4731__auto___57807]));

var G__57808 = (i__4731__auto___57807 + (1));
i__4731__auto___57807 = G__57808;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__56977_57811 = cljs.core.seq.call(null,nodes);
var chunk__56978_57812 = null;
var count__56979_57813 = (0);
var i__56980_57814 = (0);
while(true){
if((i__56980_57814 < count__56979_57813)){
var node_57816 = cljs.core._nth(chunk__56978_57812,i__56980_57814);
fragment.appendChild(shadow.dom._to_dom(node_57816));


var G__57817 = seq__56977_57811;
var G__57818 = chunk__56978_57812;
var G__57819 = count__56979_57813;
var G__57820 = (i__56980_57814 + (1));
seq__56977_57811 = G__57817;
chunk__56978_57812 = G__57818;
count__56979_57813 = G__57819;
i__56980_57814 = G__57820;
continue;
} else {
var temp__5720__auto___57821 = cljs.core.seq.call(null,seq__56977_57811);
if(temp__5720__auto___57821){
var seq__56977_57822__$1 = temp__5720__auto___57821;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56977_57822__$1)){
var c__4550__auto___57823 = cljs.core.chunk_first.call(null,seq__56977_57822__$1);
var G__57824 = cljs.core.chunk_rest.call(null,seq__56977_57822__$1);
var G__57825 = c__4550__auto___57823;
var G__57826 = cljs.core.count.call(null,c__4550__auto___57823);
var G__57827 = (0);
seq__56977_57811 = G__57824;
chunk__56978_57812 = G__57825;
count__56979_57813 = G__57826;
i__56980_57814 = G__57827;
continue;
} else {
var node_57828 = cljs.core.first.call(null,seq__56977_57822__$1);
fragment.appendChild(shadow.dom._to_dom(node_57828));


var G__57830 = cljs.core.next.call(null,seq__56977_57822__$1);
var G__57831 = null;
var G__57832 = (0);
var G__57833 = (0);
seq__56977_57811 = G__57830;
chunk__56978_57812 = G__57831;
count__56979_57813 = G__57832;
i__56980_57814 = G__57833;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq56972){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq56972));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__56992_57835 = cljs.core.seq.call(null,scripts);
var chunk__56993_57836 = null;
var count__56994_57837 = (0);
var i__56995_57838 = (0);
while(true){
if((i__56995_57838 < count__56994_57837)){
var vec__57010_57839 = cljs.core._nth(chunk__56993_57836,i__56995_57838);
var script_tag_57840 = cljs.core.nth.call(null,vec__57010_57839,(0),null);
var script_body_57841 = cljs.core.nth.call(null,vec__57010_57839,(1),null);
eval(script_body_57841);


var G__57843 = seq__56992_57835;
var G__57844 = chunk__56993_57836;
var G__57845 = count__56994_57837;
var G__57846 = (i__56995_57838 + (1));
seq__56992_57835 = G__57843;
chunk__56993_57836 = G__57844;
count__56994_57837 = G__57845;
i__56995_57838 = G__57846;
continue;
} else {
var temp__5720__auto___57848 = cljs.core.seq.call(null,seq__56992_57835);
if(temp__5720__auto___57848){
var seq__56992_57849__$1 = temp__5720__auto___57848;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56992_57849__$1)){
var c__4550__auto___57850 = cljs.core.chunk_first.call(null,seq__56992_57849__$1);
var G__57851 = cljs.core.chunk_rest.call(null,seq__56992_57849__$1);
var G__57852 = c__4550__auto___57850;
var G__57853 = cljs.core.count.call(null,c__4550__auto___57850);
var G__57854 = (0);
seq__56992_57835 = G__57851;
chunk__56993_57836 = G__57852;
count__56994_57837 = G__57853;
i__56995_57838 = G__57854;
continue;
} else {
var vec__57015_57855 = cljs.core.first.call(null,seq__56992_57849__$1);
var script_tag_57856 = cljs.core.nth.call(null,vec__57015_57855,(0),null);
var script_body_57857 = cljs.core.nth.call(null,vec__57015_57855,(1),null);
eval(script_body_57857);


var G__57861 = cljs.core.next.call(null,seq__56992_57849__$1);
var G__57862 = null;
var G__57863 = (0);
var G__57864 = (0);
seq__56992_57835 = G__57861;
chunk__56993_57836 = G__57862;
count__56994_57837 = G__57863;
i__56995_57838 = G__57864;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,((function (scripts){
return (function (s__$1,p__57019){
var vec__57022 = p__57019;
var script_tag = cljs.core.nth.call(null,vec__57022,(0),null);
var script_body = cljs.core.nth.call(null,vec__57022,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__57048 = arguments.length;
switch (G__57048) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__57070 = cljs.core.seq.call(null,style_keys);
var chunk__57071 = null;
var count__57072 = (0);
var i__57073 = (0);
while(true){
if((i__57073 < count__57072)){
var it = cljs.core._nth(chunk__57071,i__57073);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__57882 = seq__57070;
var G__57883 = chunk__57071;
var G__57884 = count__57072;
var G__57885 = (i__57073 + (1));
seq__57070 = G__57882;
chunk__57071 = G__57883;
count__57072 = G__57884;
i__57073 = G__57885;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__57070);
if(temp__5720__auto__){
var seq__57070__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57070__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__57070__$1);
var G__57889 = cljs.core.chunk_rest.call(null,seq__57070__$1);
var G__57890 = c__4550__auto__;
var G__57891 = cljs.core.count.call(null,c__4550__auto__);
var G__57892 = (0);
seq__57070 = G__57889;
chunk__57071 = G__57890;
count__57072 = G__57891;
i__57073 = G__57892;
continue;
} else {
var it = cljs.core.first.call(null,seq__57070__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__57893 = cljs.core.next.call(null,seq__57070__$1);
var G__57894 = null;
var G__57895 = (0);
var G__57896 = (0);
seq__57070 = G__57893;
chunk__57071 = G__57894;
count__57072 = G__57895;
i__57073 = G__57896;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k57081,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__57089 = k57081;
var G__57089__$1 = (((G__57089 instanceof cljs.core.Keyword))?G__57089.fqn:null);
switch (G__57089__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k57081,else__4388__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__57091){
var vec__57092 = p__57091;
var k__4408__auto__ = cljs.core.nth.call(null,vec__57092,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__57092,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__57080){
var self__ = this;
var G__57080__$1 = this;
return (new cljs.core.RecordIter((0),G__57080__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this57082,other57083){
var self__ = this;
var this57082__$1 = this;
return (((!((other57083 == null)))) && ((this57082__$1.constructor === other57083.constructor)) && (cljs.core._EQ_.call(null,this57082__$1.x,other57083.x)) && (cljs.core._EQ_.call(null,this57082__$1.y,other57083.y)) && (cljs.core._EQ_.call(null,this57082__$1.__extmap,other57083.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__57080){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__57117 = cljs.core.keyword_identical_QMARK_;
var expr__57118 = k__4393__auto__;
if(cljs.core.truth_(pred__57117.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__57118))){
return (new shadow.dom.Coordinate(G__57080,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57117.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__57118))){
return (new shadow.dom.Coordinate(self__.x,G__57080,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__57080),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__57080){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__57080,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__57085){
var extmap__4424__auto__ = (function (){var G__57123 = cljs.core.dissoc.call(null,G__57085,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__57085)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__57123);
} else {
return G__57123;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__57085),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__57085),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k57127,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__57135 = k57127;
var G__57135__$1 = (((G__57135 instanceof cljs.core.Keyword))?G__57135.fqn:null);
switch (G__57135__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k57127,else__4388__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__57139){
var vec__57140 = p__57139;
var k__4408__auto__ = cljs.core.nth.call(null,vec__57140,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__57140,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Size{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__57126){
var self__ = this;
var G__57126__$1 = this;
return (new cljs.core.RecordIter((0),G__57126__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this57128,other57129){
var self__ = this;
var this57128__$1 = this;
return (((!((other57129 == null)))) && ((this57128__$1.constructor === other57129.constructor)) && (cljs.core._EQ_.call(null,this57128__$1.w,other57129.w)) && (cljs.core._EQ_.call(null,this57128__$1.h,other57129.h)) && (cljs.core._EQ_.call(null,this57128__$1.__extmap,other57129.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__57126){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__57162 = cljs.core.keyword_identical_QMARK_;
var expr__57163 = k__4393__auto__;
if(cljs.core.truth_(pred__57162.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__57163))){
return (new shadow.dom.Size(G__57126,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57162.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__57163))){
return (new shadow.dom.Size(self__.w,G__57126,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__57126),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__57126){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__57126,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__57133){
var extmap__4424__auto__ = (function (){var G__57180 = cljs.core.dissoc.call(null,G__57133,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__57133)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__57180);
} else {
return G__57180;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__57133),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__57133),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4604__auto__ = opts;
var l__4605__auto__ = a__4604__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4605__auto__)){
var G__58015 = (i + (1));
var G__58016 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__58015;
ret = G__58016;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__57212){
var vec__57213 = p__57212;
var k = cljs.core.nth.call(null,vec__57213,(0),null);
var v = cljs.core.nth.call(null,vec__57213,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__57217 = arguments.length;
switch (G__57217) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__58061 = ps;
var G__58062 = (i + (1));
el__$1 = G__58061;
i = G__58062;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return shadow.dom.parents.call(null,parent);
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__57248 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__57248,(0),null);
var tag_id = cljs.core.nth.call(null,vec__57248,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__57248,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__57252_58091 = cljs.core.seq.call(null,props);
var chunk__57253_58092 = null;
var count__57254_58093 = (0);
var i__57255_58094 = (0);
while(true){
if((i__57255_58094 < count__57254_58093)){
var vec__57266_58095 = cljs.core._nth(chunk__57253_58092,i__57255_58094);
var k_58096 = cljs.core.nth.call(null,vec__57266_58095,(0),null);
var v_58097 = cljs.core.nth.call(null,vec__57266_58095,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace.call(null,k_58096);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_58096),v_58097);


var G__58098 = seq__57252_58091;
var G__58099 = chunk__57253_58092;
var G__58100 = count__57254_58093;
var G__58101 = (i__57255_58094 + (1));
seq__57252_58091 = G__58098;
chunk__57253_58092 = G__58099;
count__57254_58093 = G__58100;
i__57255_58094 = G__58101;
continue;
} else {
var temp__5720__auto___58102 = cljs.core.seq.call(null,seq__57252_58091);
if(temp__5720__auto___58102){
var seq__57252_58103__$1 = temp__5720__auto___58102;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57252_58103__$1)){
var c__4550__auto___58106 = cljs.core.chunk_first.call(null,seq__57252_58103__$1);
var G__58107 = cljs.core.chunk_rest.call(null,seq__57252_58103__$1);
var G__58108 = c__4550__auto___58106;
var G__58109 = cljs.core.count.call(null,c__4550__auto___58106);
var G__58110 = (0);
seq__57252_58091 = G__58107;
chunk__57253_58092 = G__58108;
count__57254_58093 = G__58109;
i__57255_58094 = G__58110;
continue;
} else {
var vec__57270_58111 = cljs.core.first.call(null,seq__57252_58103__$1);
var k_58112 = cljs.core.nth.call(null,vec__57270_58111,(0),null);
var v_58113 = cljs.core.nth.call(null,vec__57270_58111,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace.call(null,k_58112);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_58112),v_58113);


var G__58116 = cljs.core.next.call(null,seq__57252_58103__$1);
var G__58117 = null;
var G__58118 = (0);
var G__58119 = (0);
seq__57252_58091 = G__58116;
chunk__57253_58092 = G__58117;
count__57254_58093 = G__58118;
i__57255_58094 = G__58119;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg(el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__57284 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__57284,(0),null);
var node_children = cljs.core.nth.call(null,vec__57284,(1),null);
var seq__57287_58149 = cljs.core.seq.call(null,node_children);
var chunk__57289_58150 = null;
var count__57290_58151 = (0);
var i__57291_58152 = (0);
while(true){
if((i__57291_58152 < count__57290_58151)){
var child_struct_58155 = cljs.core._nth(chunk__57289_58150,i__57291_58152);
if((!((child_struct_58155 == null)))){
if(typeof child_struct_58155 === 'string'){
var text_58156 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_58156),child_struct_58155].join(''));
} else {
var children_58157 = shadow.dom.svg_node.call(null,child_struct_58155);
if(cljs.core.seq_QMARK_.call(null,children_58157)){
var seq__57343_58158 = cljs.core.seq.call(null,children_58157);
var chunk__57345_58159 = null;
var count__57346_58160 = (0);
var i__57347_58161 = (0);
while(true){
if((i__57347_58161 < count__57346_58160)){
var child_58163 = cljs.core._nth(chunk__57345_58159,i__57347_58161);
if(cljs.core.truth_(child_58163)){
node.appendChild(child_58163);


var G__58165 = seq__57343_58158;
var G__58166 = chunk__57345_58159;
var G__58167 = count__57346_58160;
var G__58168 = (i__57347_58161 + (1));
seq__57343_58158 = G__58165;
chunk__57345_58159 = G__58166;
count__57346_58160 = G__58167;
i__57347_58161 = G__58168;
continue;
} else {
var G__58169 = seq__57343_58158;
var G__58170 = chunk__57345_58159;
var G__58171 = count__57346_58160;
var G__58172 = (i__57347_58161 + (1));
seq__57343_58158 = G__58169;
chunk__57345_58159 = G__58170;
count__57346_58160 = G__58171;
i__57347_58161 = G__58172;
continue;
}
} else {
var temp__5720__auto___58175 = cljs.core.seq.call(null,seq__57343_58158);
if(temp__5720__auto___58175){
var seq__57343_58176__$1 = temp__5720__auto___58175;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57343_58176__$1)){
var c__4550__auto___58177 = cljs.core.chunk_first.call(null,seq__57343_58176__$1);
var G__58178 = cljs.core.chunk_rest.call(null,seq__57343_58176__$1);
var G__58179 = c__4550__auto___58177;
var G__58180 = cljs.core.count.call(null,c__4550__auto___58177);
var G__58181 = (0);
seq__57343_58158 = G__58178;
chunk__57345_58159 = G__58179;
count__57346_58160 = G__58180;
i__57347_58161 = G__58181;
continue;
} else {
var child_58182 = cljs.core.first.call(null,seq__57343_58176__$1);
if(cljs.core.truth_(child_58182)){
node.appendChild(child_58182);


var G__58183 = cljs.core.next.call(null,seq__57343_58176__$1);
var G__58184 = null;
var G__58185 = (0);
var G__58186 = (0);
seq__57343_58158 = G__58183;
chunk__57345_58159 = G__58184;
count__57346_58160 = G__58185;
i__57347_58161 = G__58186;
continue;
} else {
var G__58188 = cljs.core.next.call(null,seq__57343_58176__$1);
var G__58189 = null;
var G__58190 = (0);
var G__58191 = (0);
seq__57343_58158 = G__58188;
chunk__57345_58159 = G__58189;
count__57346_58160 = G__58190;
i__57347_58161 = G__58191;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_58157);
}
}


var G__58193 = seq__57287_58149;
var G__58194 = chunk__57289_58150;
var G__58195 = count__57290_58151;
var G__58196 = (i__57291_58152 + (1));
seq__57287_58149 = G__58193;
chunk__57289_58150 = G__58194;
count__57290_58151 = G__58195;
i__57291_58152 = G__58196;
continue;
} else {
var G__58202 = seq__57287_58149;
var G__58203 = chunk__57289_58150;
var G__58204 = count__57290_58151;
var G__58205 = (i__57291_58152 + (1));
seq__57287_58149 = G__58202;
chunk__57289_58150 = G__58203;
count__57290_58151 = G__58204;
i__57291_58152 = G__58205;
continue;
}
} else {
var temp__5720__auto___58208 = cljs.core.seq.call(null,seq__57287_58149);
if(temp__5720__auto___58208){
var seq__57287_58209__$1 = temp__5720__auto___58208;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57287_58209__$1)){
var c__4550__auto___58215 = cljs.core.chunk_first.call(null,seq__57287_58209__$1);
var G__58216 = cljs.core.chunk_rest.call(null,seq__57287_58209__$1);
var G__58217 = c__4550__auto___58215;
var G__58218 = cljs.core.count.call(null,c__4550__auto___58215);
var G__58219 = (0);
seq__57287_58149 = G__58216;
chunk__57289_58150 = G__58217;
count__57290_58151 = G__58218;
i__57291_58152 = G__58219;
continue;
} else {
var child_struct_58221 = cljs.core.first.call(null,seq__57287_58209__$1);
if((!((child_struct_58221 == null)))){
if(typeof child_struct_58221 === 'string'){
var text_58222 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_58222),child_struct_58221].join(''));
} else {
var children_58226 = shadow.dom.svg_node.call(null,child_struct_58221);
if(cljs.core.seq_QMARK_.call(null,children_58226)){
var seq__57367_58229 = cljs.core.seq.call(null,children_58226);
var chunk__57369_58230 = null;
var count__57370_58231 = (0);
var i__57371_58232 = (0);
while(true){
if((i__57371_58232 < count__57370_58231)){
var child_58235 = cljs.core._nth(chunk__57369_58230,i__57371_58232);
if(cljs.core.truth_(child_58235)){
node.appendChild(child_58235);


var G__58238 = seq__57367_58229;
var G__58239 = chunk__57369_58230;
var G__58240 = count__57370_58231;
var G__58241 = (i__57371_58232 + (1));
seq__57367_58229 = G__58238;
chunk__57369_58230 = G__58239;
count__57370_58231 = G__58240;
i__57371_58232 = G__58241;
continue;
} else {
var G__58244 = seq__57367_58229;
var G__58245 = chunk__57369_58230;
var G__58246 = count__57370_58231;
var G__58247 = (i__57371_58232 + (1));
seq__57367_58229 = G__58244;
chunk__57369_58230 = G__58245;
count__57370_58231 = G__58246;
i__57371_58232 = G__58247;
continue;
}
} else {
var temp__5720__auto___58250__$1 = cljs.core.seq.call(null,seq__57367_58229);
if(temp__5720__auto___58250__$1){
var seq__57367_58251__$1 = temp__5720__auto___58250__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57367_58251__$1)){
var c__4550__auto___58255 = cljs.core.chunk_first.call(null,seq__57367_58251__$1);
var G__58256 = cljs.core.chunk_rest.call(null,seq__57367_58251__$1);
var G__58257 = c__4550__auto___58255;
var G__58258 = cljs.core.count.call(null,c__4550__auto___58255);
var G__58259 = (0);
seq__57367_58229 = G__58256;
chunk__57369_58230 = G__58257;
count__57370_58231 = G__58258;
i__57371_58232 = G__58259;
continue;
} else {
var child_58262 = cljs.core.first.call(null,seq__57367_58251__$1);
if(cljs.core.truth_(child_58262)){
node.appendChild(child_58262);


var G__58264 = cljs.core.next.call(null,seq__57367_58251__$1);
var G__58265 = null;
var G__58266 = (0);
var G__58267 = (0);
seq__57367_58229 = G__58264;
chunk__57369_58230 = G__58265;
count__57370_58231 = G__58266;
i__57371_58232 = G__58267;
continue;
} else {
var G__58270 = cljs.core.next.call(null,seq__57367_58251__$1);
var G__58271 = null;
var G__58272 = (0);
var G__58273 = (0);
seq__57367_58229 = G__58270;
chunk__57369_58230 = G__58271;
count__57370_58231 = G__58272;
i__57371_58232 = G__58273;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_58226);
}
}


var G__58278 = cljs.core.next.call(null,seq__57287_58209__$1);
var G__58279 = null;
var G__58280 = (0);
var G__58281 = (0);
seq__57287_58149 = G__58278;
chunk__57289_58150 = G__58279;
count__57290_58151 = G__58280;
i__57291_58152 = G__58281;
continue;
} else {
var G__58283 = cljs.core.next.call(null,seq__57287_58209__$1);
var G__58284 = null;
var G__58285 = (0);
var G__58286 = (0);
seq__57287_58149 = G__58283;
chunk__57289_58150 = G__58284;
count__57290_58151 = G__58285;
i__57291_58152 = G__58286;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___58305 = arguments.length;
var i__4731__auto___58306 = (0);
while(true){
if((i__4731__auto___58306 < len__4730__auto___58305)){
args__4736__auto__.push((arguments[i__4731__auto___58306]));

var G__58310 = (i__4731__auto___58306 + (1));
i__4731__auto___58306 = G__58310;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq57410){
var G__57411 = cljs.core.first.call(null,seq57410);
var seq57410__$1 = cljs.core.next.call(null,seq57410);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57411,seq57410__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__57437 = arguments.length;
switch (G__57437) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});})(buf,chan))
;
shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4120__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4120__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4120__auto__;
}
})())){
var c__54028__auto___58345 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto___58345,buf,chan,event_fn){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto___58345,buf,chan,event_fn){
return (function (state_57463){
var state_val_57464 = (state_57463[(1)]);
if((state_val_57464 === (1))){
var state_57463__$1 = state_57463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57463__$1,(2),once_or_cleanup);
} else {
if((state_val_57464 === (2))){
var inst_57460 = (state_57463[(2)]);
var inst_57461 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_57463__$1 = (function (){var statearr_57470 = state_57463;
(statearr_57470[(7)] = inst_57460);

return statearr_57470;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57463__$1,inst_57461);
} else {
return null;
}
}
});})(c__54028__auto___58345,buf,chan,event_fn))
;
return ((function (switch__53637__auto__,c__54028__auto___58345,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__53638__auto__ = null;
var shadow$dom$state_machine__53638__auto____0 = (function (){
var statearr_57473 = [null,null,null,null,null,null,null,null];
(statearr_57473[(0)] = shadow$dom$state_machine__53638__auto__);

(statearr_57473[(1)] = (1));

return statearr_57473;
});
var shadow$dom$state_machine__53638__auto____1 = (function (state_57463){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_57463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e57476){if((e57476 instanceof Object)){
var ex__53641__auto__ = e57476;
var statearr_57480_58365 = state_57463;
(statearr_57480_58365[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57476;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58371 = state_57463;
state_57463 = G__58371;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
shadow$dom$state_machine__53638__auto__ = function(state_57463){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__53638__auto____0.call(this);
case 1:
return shadow$dom$state_machine__53638__auto____1.call(this,state_57463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__53638__auto____0;
shadow$dom$state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__53638__auto____1;
return shadow$dom$state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto___58345,buf,chan,event_fn))
})();
var state__54030__auto__ = (function (){var statearr_57484 = f__54029__auto__();
(statearr_57484[(6)] = c__54028__auto___58345);

return statearr_57484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto___58345,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
