goog.provide('fulcro.inspect.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('fulcro_css.css');
goog.require('fulcro.client');
goog.require('fulcro.client.localized_dom');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.network');
goog.require('fulcro.client.primitives');
goog.require('fulcro.inspect.lib.diff');
goog.require('fulcro.inspect.lib.misc');
goog.require('fulcro.inspect.lib.version');
goog.require('fulcro.inspect.remote.transit');
goog.require('fulcro.inspect.ui.dom_history_viewer');
goog.require('fulcro.inspect.ui.element_picker');
goog.require('fulcro.inspect.ui.helpers');
goog.require('goog.object');
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.client !== 'undefined') && (typeof fulcro.inspect.client.started_QMARK__STAR_ !== 'undefined')){
} else {
fulcro.inspect.client.started_QMARK__STAR_ = cljs.core.atom.call(null,false);
}
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.client !== 'undefined') && (typeof fulcro.inspect.client.tools_app_STAR_ !== 'undefined')){
} else {
fulcro.inspect.client.tools_app_STAR_ = cljs.core.atom.call(null,null);
}
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.client !== 'undefined') && (typeof fulcro.inspect.client.apps_STAR_ !== 'undefined')){
} else {
fulcro.inspect.client.apps_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.client !== 'undefined') && (typeof fulcro.inspect.client.send_ch !== 'undefined')){
} else {
fulcro.inspect.client.send_ch = cljs.core.async.chan.call(null,cljs.core.async.dropping_buffer.call(null,(1024)));
}
fulcro.inspect.client.app_uuid_key = new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491);
fulcro.inspect.client.post_message = (function fulcro$inspect$client$post_message(type,data){
return cljs.core.async.put_BANG_.call(null,fulcro.inspect.client.send_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,data], null));
});
fulcro.inspect.client.event_data = (function fulcro$inspect$client$event_data(event){
var G__71848 = event;
var G__71848__$1 = (((G__71848 == null))?null:goog.object.getValueByKeys(G__71848,"data","fulcro-inspect-devtool-message"));
if((G__71848__$1 == null)){
return null;
} else {
return fulcro.inspect.remote.transit.read.call(null,G__71848__$1);
}
});
fulcro.inspect.client.start_send_message_loop = (function fulcro$inspect$client$start_send_message_loop(){
var c__54028__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54028__auto__){
return (function (){
var f__54029__auto__ = (function (){var switch__53637__auto__ = ((function (c__54028__auto__){
return (function (state_71882){
var state_val_71883 = (state_71882[(1)]);
if((state_val_71883 === (1))){
var state_71882__$1 = state_71882;
var statearr_71885_72584 = state_71882__$1;
(statearr_71885_72584[(2)] = null);

(statearr_71885_72584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71883 === (2))){
var state_71882__$1 = state_71882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71882__$1,(4),fulcro.inspect.client.send_ch);
} else {
if((state_val_71883 === (3))){
var inst_71879 = (state_71882[(2)]);
var state_71882__$1 = state_71882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71882__$1,inst_71879);
} else {
if((state_val_71883 === (4))){
var inst_71854 = (state_71882[(7)]);
var inst_71854__$1 = (state_71882[(2)]);
var state_71882__$1 = (function (){var statearr_71889 = state_71882;
(statearr_71889[(7)] = inst_71854__$1);

return statearr_71889;
})();
if(cljs.core.truth_(inst_71854__$1)){
var statearr_71890_72592 = state_71882__$1;
(statearr_71890_72592[(1)] = (5));

} else {
var statearr_71891_72594 = state_71882__$1;
(statearr_71891_72594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71883 === (5))){
var inst_71854 = (state_71882[(7)]);
var inst_71860 = cljs.core.nth.call(null,inst_71854,(0),null);
var inst_71861 = cljs.core.nth.call(null,inst_71854,(1),null);
var inst_71864 = [new cljs.core.Keyword(null,"fulcro-inspect-remote-message","fulcro-inspect-remote-message",1518065210)];
var inst_71865 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"timestamp","timestamp",579478971)];
var inst_71866 = (new Date());
var inst_71867 = [inst_71860,inst_71861,inst_71866];
var inst_71868 = cljs.core.PersistentHashMap.fromArrays(inst_71865,inst_71867);
var inst_71869 = fulcro.inspect.remote.transit.write.call(null,inst_71868);
var inst_71870 = [inst_71869];
var inst_71871 = cljs.core.PersistentHashMap.fromArrays(inst_71864,inst_71870);
var inst_71872 = cljs.core.clj__GT_js.call(null,inst_71871);
var inst_71873 = window.postMessage(inst_71872,"*");
var state_71882__$1 = (function (){var statearr_71895 = state_71882;
(statearr_71895[(8)] = inst_71873);

return statearr_71895;
})();
var statearr_71896_72601 = state_71882__$1;
(statearr_71896_72601[(2)] = null);

(statearr_71896_72601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71883 === (6))){
var state_71882__$1 = state_71882;
var statearr_71897_72603 = state_71882__$1;
(statearr_71897_72603[(2)] = null);

(statearr_71897_72603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71883 === (7))){
var inst_71877 = (state_71882[(2)]);
var state_71882__$1 = state_71882;
var statearr_71898_72604 = state_71882__$1;
(statearr_71898_72604[(2)] = inst_71877);

(statearr_71898_72604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__54028__auto__))
;
return ((function (switch__53637__auto__,c__54028__auto__){
return (function() {
var fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__ = null;
var fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____0 = (function (){
var statearr_71901 = [null,null,null,null,null,null,null,null,null];
(statearr_71901[(0)] = fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__);

(statearr_71901[(1)] = (1));

return statearr_71901;
});
var fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____1 = (function (state_71882){
while(true){
var ret_value__53639__auto__ = (function (){try{while(true){
var result__53640__auto__ = switch__53637__auto__(state_71882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53640__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53640__auto__;
}
break;
}
}catch (e71902){if((e71902 instanceof Object)){
var ex__53641__auto__ = e71902;
var statearr_71903_72613 = state_71882;
(statearr_71903_72613[(5)] = ex__53641__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71902;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53639__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72614 = state_71882;
state_71882 = G__72614;
continue;
} else {
return ret_value__53639__auto__;
}
break;
}
});
fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__ = function(state_71882){
switch(arguments.length){
case 0:
return fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____0.call(this);
case 1:
return fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____1.call(this,state_71882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____0;
fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto____1;
return fulcro$inspect$client$start_send_message_loop_$_state_machine__53638__auto__;
})()
;})(switch__53637__auto__,c__54028__auto__))
})();
var state__54030__auto__ = (function (){var statearr_71912 = f__54029__auto__();
(statearr_71912[(6)] = c__54028__auto__);

return statearr_71912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54030__auto__);
});})(c__54028__auto__))
);

return c__54028__auto__;
});
fulcro.inspect.client.listen_local_messages = (function fulcro$inspect$client$listen_local_messages(){
return window.addEventListener("message",(function (event){
if(cljs.core.truth_((function (){var and__4120__auto__ = (event.source === window);
if(and__4120__auto__){
return goog.object.getValueByKeys(event,"data","fulcro-inspect-devtool-message");
} else {
return and__4120__auto__;
}
})())){
return fulcro.inspect.client.handle_devtool_message.call(null,fulcro.inspect.client.event_data.call(null,event));
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = (event.source === window);
if(and__4120__auto__){
return goog.object.getValueByKeys(event,"data","fulcro-inspect-start-consume");
} else {
return and__4120__auto__;
}
})())){
return fulcro.inspect.client.start_send_message_loop.call(null);
} else {
return null;
}
}
}),false);
});
fulcro.inspect.client.app_uuid = (function fulcro$inspect$client$app_uuid(reconciler){
var G__71922 = reconciler;
var G__71922__$1 = (((G__71922 == null))?null:fulcro.client.primitives.app_state.call(null,G__71922));
var G__71922__$2 = (((G__71922__$1 == null))?null:cljs.core.deref.call(null,G__71922__$1));
if((G__71922__$2 == null)){
return null;
} else {
return fulcro.inspect.client.app_uuid_key.cljs$core$IFn$_invoke$arity$1(G__71922__$2);
}
});
fulcro.inspect.client.app_id = (function fulcro$inspect$client$app_id(reconciler){
var or__4131__auto__ = (function (){var G__71932 = reconciler;
var G__71932__$1 = (((G__71932 == null))?null:fulcro.client.primitives.app_state.call(null,G__71932));
var G__71932__$2 = (((G__71932__$1 == null))?null:cljs.core.deref.call(null,G__71932__$1));
if((G__71932__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233).cljs$core$IFn$_invoke$arity$1(G__71932__$2);
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var G__71933 = reconciler;
var G__71933__$1 = (((G__71933 == null))?null:fulcro.client.primitives.app_root.call(null,G__71933));
if((G__71933__$1 == null)){
return null;
} else {
return fulcro.inspect.ui.helpers.react_display_name.call(null,G__71933__$1);
}
}
});
fulcro.inspect.client.inspect_network_init = (function fulcro$inspect$client$inspect_network_init(network,app){
return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword("fulcro.inspect.client","app*","fulcro.inspect.client/app*",389597452).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(network)),app);
});
fulcro.inspect.client.transact_inspector_BANG_ = (function fulcro$inspect$client$transact_inspector_BANG_(var_args){
var G__71941 = arguments.length;
switch (G__71941) {
case 1:
return fulcro.inspect.client.transact_inspector_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.inspect.client.transact_inspector_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.inspect.client.transact_inspector_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tx){
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","transact-inspector","fulcro.inspect.client/transact-inspector",-905938352),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.client","tx","fulcro.inspect.client/tx",-815771134),tx], null));
});

fulcro.inspect.client.transact_inspector_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ref,tx){
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","transact-inspector","fulcro.inspect.client/transact-inspector",-905938352),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.inspect.client","tx-ref","fulcro.inspect.client/tx-ref",-1370560773),ref,new cljs.core.Keyword("fulcro.inspect.client","tx","fulcro.inspect.client/tx",-815771134),tx], null));
});

fulcro.inspect.client.transact_inspector_BANG_.cljs$lang$maxFixedArity = 2;

fulcro.inspect.client.MAX_HISTORY_SIZE = (100);
fulcro.inspect.client.update_state_history = (function fulcro$inspect$client$update_state_history(app,state){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)),cljs.core.update,new cljs.core.Keyword("fulcro.inspect.client","state-history","fulcro.inspect.client/state-history",2111486187),(function (p1__71947_SHARP_){
return fulcro.inspect.lib.misc.fixed_size_assoc.call(null,fulcro.inspect.client.MAX_HISTORY_SIZE,p1__71947_SHARP_,cljs.core.hash.call(null,state),state);
}));
});
fulcro.inspect.client.db_update = (function fulcro$inspect$client$db_update(app,app_uuid,old_state,new_state){
fulcro.inspect.client.update_state_history.call(null,app,new_state);

var diff = fulcro.inspect.lib.diff.diff.call(null,old_state,new_state);
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","db-update","fulcro.inspect.client/db-update",587693556),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,app_uuid,new cljs.core.Keyword("fulcro.inspect.client","prev-state-hash","fulcro.inspect.client/prev-state-hash",413242088),cljs.core.hash.call(null,old_state),new cljs.core.Keyword("fulcro.inspect.client","state-hash","fulcro.inspect.client/state-hash",-1488761756),cljs.core.hash.call(null,new_state),new cljs.core.Keyword("fulcro.inspect.client","state-delta","fulcro.inspect.client/state-delta",1518835964),diff]));
});
fulcro.inspect.client.db_from_history = (function fulcro$inspect$client$db_from_history(app,state_hash){
var G__71954 = app;
var G__71954__$1 = (((G__71954 == null))?null:new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(G__71954));
var G__71954__$2 = (((G__71954__$1 == null))?null:new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71954__$1));
var G__71954__$3 = (((G__71954__$2 == null))?null:cljs.core.deref.call(null,G__71954__$2));
var G__71954__$4 = (((G__71954__$3 == null))?null:new cljs.core.Keyword("fulcro.inspect.client","state-history","fulcro.inspect.client/state-history",2111486187).cljs$core$IFn$_invoke$arity$1(G__71954__$3));
if((G__71954__$4 == null)){
return null;
} else {
return cljs.core.get.call(null,G__71954__$4,state_hash);
}
});
fulcro.inspect.client.dispose_app = (function fulcro$inspect$client$dispose_app(app_uuid){
cljs.core.swap_BANG_.call(null,fulcro.inspect.client.apps_STAR_,cljs.core.dissoc,app_uuid);

return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","dispose-app","fulcro.inspect.client/dispose-app",-574872452),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,app_uuid]));
});
fulcro.inspect.client.set_active_app = (function fulcro$inspect$client$set_active_app(app_uuid){
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","set-active-app","fulcro.inspect.client/set-active-app",-2049837528),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,app_uuid]));
});
fulcro.inspect.client.inspect_app = (function fulcro$inspect$client$inspect_app(p__71967){
var map__71968 = p__71967;
var map__71968__$1 = (((((!((map__71968 == null))))?(((((map__71968.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71968.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71968):map__71968);
var app = map__71968__$1;
var reconciler = cljs.core.get.call(null,map__71968__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__71968__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var state_STAR_ = (function (){var G__71970 = app;
var G__71970__$1 = (((G__71970 == null))?null:new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(G__71970));
var G__71970__$2 = (((G__71970__$1 == null))?null:new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__71970__$1));
if((G__71970__$2 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71970__$2);
}
})();
var app_uuid = cljs.core.random_uuid.call(null);
var seq__71971_72641 = cljs.core.seq.call(null,networking);
var chunk__71972_72643 = null;
var count__71973_72644 = (0);
var i__71974_72645 = (0);
while(true){
if((i__71974_72645 < count__71973_72644)){
var vec__71994_72648 = cljs.core._nth(chunk__71972_72643,i__71974_72645);
var __72649 = cljs.core.nth.call(null,vec__71994_72648,(0),null);
var n_72650 = cljs.core.nth.call(null,vec__71994_72648,(1),null);
fulcro.inspect.client.inspect_network_init.call(null,n_72650,app);


var G__72651 = seq__71971_72641;
var G__72652 = chunk__71972_72643;
var G__72653 = count__71973_72644;
var G__72654 = (i__71974_72645 + (1));
seq__71971_72641 = G__72651;
chunk__71972_72643 = G__72652;
count__71973_72644 = G__72653;
i__71974_72645 = G__72654;
continue;
} else {
var temp__5720__auto___72655 = cljs.core.seq.call(null,seq__71971_72641);
if(temp__5720__auto___72655){
var seq__71971_72656__$1 = temp__5720__auto___72655;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71971_72656__$1)){
var c__4550__auto___72658 = cljs.core.chunk_first.call(null,seq__71971_72656__$1);
var G__72660 = cljs.core.chunk_rest.call(null,seq__71971_72656__$1);
var G__72661 = c__4550__auto___72658;
var G__72662 = cljs.core.count.call(null,c__4550__auto___72658);
var G__72663 = (0);
seq__71971_72641 = G__72660;
chunk__71972_72643 = G__72661;
count__71973_72644 = G__72662;
i__71974_72645 = G__72663;
continue;
} else {
var vec__72000_72664 = cljs.core.first.call(null,seq__71971_72656__$1);
var __72665 = cljs.core.nth.call(null,vec__72000_72664,(0),null);
var n_72666 = cljs.core.nth.call(null,vec__72000_72664,(1),null);
fulcro.inspect.client.inspect_network_init.call(null,n_72666,app);


var G__72667 = cljs.core.next.call(null,seq__71971_72656__$1);
var G__72668 = null;
var G__72669 = (0);
var G__72670 = (0);
seq__71971_72641 = G__72667;
chunk__71972_72643 = G__72668;
count__71973_72644 = G__72669;
i__71974_72645 = G__72670;
continue;
}
} else {
}
}
break;
}

cljs.core.swap_BANG_.call(null,fulcro.inspect.client.apps_STAR_,cljs.core.assoc,app_uuid,app);

fulcro.inspect.client.update_state_history.call(null,app,cljs.core.deref.call(null,state_STAR_));

fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","init-app","fulcro.inspect.client/init-app",-1984595648),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,app_uuid,new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233),fulcro.inspect.client.app_id.call(null,reconciler),new cljs.core.Keyword("fulcro.inspect.client","remotes","fulcro.inspect.client/remotes",-2062632712),cljs.core.sort_by.call(null,cljs.core.juxt.call(null,((function (state_STAR_,app_uuid,map__71968,map__71968__$1,app,reconciler,networking){
return (function (p1__71959_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"remote","remote",-1593576576),p1__71959_SHARP_);
});})(state_STAR_,app_uuid,map__71968,map__71968__$1,app,reconciler,networking))
,cljs.core.str),cljs.core.keys.call(null,networking)),new cljs.core.Keyword("fulcro.inspect.client","initial-state","fulcro.inspect.client/initial-state",1225829482),cljs.core.deref.call(null,state_STAR_),new cljs.core.Keyword("fulcro.inspect.client","state-hash","fulcro.inspect.client/state-hash",-1488761756),cljs.core.hash.call(null,cljs.core.deref.call(null,state_STAR_))]));

cljs.core.add_watch.call(null,state_STAR_,app_uuid,((function (state_STAR_,app_uuid,map__71968,map__71968__$1,app,reconciler,networking){
return (function (p1__71962_SHARP_,p2__71963_SHARP_,p3__71960_SHARP_,p4__71961_SHARP_){
return fulcro.inspect.client.db_update.call(null,app,app_uuid,p3__71960_SHARP_,p4__71961_SHARP_);
});})(state_STAR_,app_uuid,map__71968,map__71968__$1,app,reconciler,networking))
);

cljs.core.swap_BANG_.call(null,state_STAR_,cljs.core.assoc,fulcro.inspect.client.app_uuid_key,app_uuid);

return app;
});
fulcro.inspect.client.inspect_tx = (function fulcro$inspect$client$inspect_tx(p__72012,p__72013){
var map__72015 = p__72012;
var map__72015__$1 = (((((!((map__72015 == null))))?(((((map__72015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72015.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72015):map__72015);
var env = map__72015__$1;
var reconciler = cljs.core.get.call(null,map__72015__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__72016 = p__72013;
var map__72016__$1 = (((((!((map__72016 == null))))?(((((map__72016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72016):map__72016);
var info = map__72016__$1;
var db_before = cljs.core.get.call(null,map__72016__$1,new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365));
var db_after = cljs.core.get.call(null,map__72016__$1,new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361));
if(cljs.core.truth_(fulcro.client.primitives.app_root.call(null,reconciler))){
var tx = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,clojure.set.rename_keys.call(null,cljs.core.update.call(null,cljs.core.merge.call(null,info,cljs.core.select_keys.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"component","component",1555936782)], null))),new cljs.core.Keyword(null,"component","component",1555936782),((function (map__72015,map__72015__$1,env,reconciler,map__72016,map__72016__$1,info,db_before,db_after){
return (function (p1__72008_SHARP_){
return goog.object.get(fulcro.client.primitives.react_type.call(null,p1__72008_SHARP_),"displayName");
});})(map__72015,map__72015__$1,env,reconciler,map__72016,map__72016__$1,info,db_before,db_after))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"ident-ref","ident-ref",663643478)], null)),new cljs.core.Keyword(null,"old-state","old-state",1039580704),new cljs.core.Keyword(null,"new-state","new-state",-490349212),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("fulcro.history","db-before","fulcro.history/db-before",650457365),new cljs.core.Keyword("fulcro.history","db-after","fulcro.history/db-after",-1774997361)),new cljs.core.Keyword("fulcro.history","db-before-hash","fulcro.history/db-before-hash",-1020674495),cljs.core.hash.call(null,db_before),new cljs.core.Keyword("fulcro.history","db-after-hash","fulcro.history/db-after-hash",-1603617752),cljs.core.hash.call(null,db_after));
var app_uuid = fulcro.inspect.client.app_uuid.call(null,reconciler);
if(cljs.core.truth_(new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler))))){
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","new-client-transaction","fulcro.inspect.client/new-client-transaction",-1086637148),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,app_uuid,new cljs.core.Keyword("fulcro.inspect.client","tx","fulcro.inspect.client/tx",-815771134),tx]));
} else {
return null;
}
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro.inspect.client.TransformNetwork = (function (network,options,__meta,__extmap,__hash){
this.network = network;
this.options = options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k72030,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__72039 = k72030;
var G__72039__$1 = (((G__72039 instanceof cljs.core.Keyword))?G__72039.fqn:null);
switch (G__72039__$1) {
case "network":
return self__.network;

break;
case "options":
return self__.options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k72030,else__4388__auto__);

}
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__72045){
var vec__72046 = p__72045;
var k__4408__auto__ = cljs.core.nth.call(null,vec__72046,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__72046,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#fulcro.inspect.client.TransformNetwork{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__72029){
var self__ = this;
var G__72029__$1 = this;
return (new cljs.core.RecordIter((0),G__72029__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fulcro.inspect.client.TransformNetwork(self__.network,self__.options,self__.__meta,self__.__extmap,self__.__hash));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1657413298 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this72031,other72032){
var self__ = this;
var this72031__$1 = this;
return (((!((other72032 == null)))) && ((this72031__$1.constructor === other72032.constructor)) && (cljs.core._EQ_.call(null,this72031__$1.network,other72032.network)) && (cljs.core._EQ_.call(null,this72031__$1.options,other72032.options)) && (cljs.core._EQ_.call(null,this72031__$1.__extmap,other72032.__extmap)));
});

fulcro.inspect.client.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;

fulcro.inspect.client.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (_,edn,ok,error){
var self__ = this;
var ___$1 = this;
var map__72079 = self__.options;
var map__72079__$1 = (((((!((map__72079 == null))))?(((((map__72079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72079):map__72079);
var transform_query = cljs.core.get.call(null,map__72079__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-query","fulcro.inspect.client/transform-query",-974573391),((function (map__72079,map__72079__$1,___$1){
return (function (___$2,x){
return x;
});})(map__72079,map__72079__$1,___$1))
);
var transform_response = cljs.core.get.call(null,map__72079__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-response","fulcro.inspect.client/transform-response",664733229),((function (map__72079,map__72079__$1,transform_query,___$1){
return (function (___$2,x){
return x;
});})(map__72079,map__72079__$1,transform_query,___$1))
);
var transform_error = cljs.core.get.call(null,map__72079__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-error","fulcro.inspect.client/transform-error",-1523058473),((function (map__72079,map__72079__$1,transform_query,transform_response,___$1){
return (function (___$2,x){
return x;
});})(map__72079,map__72079__$1,transform_query,transform_response,___$1))
);
var app_STAR_ = cljs.core.get.call(null,map__72079__$1,new cljs.core.Keyword("fulcro.inspect.client","app*","fulcro.inspect.client/app*",389597452));
var req_id = cljs.core.random_uuid.call(null);
var env = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.inspect.client","request-id","fulcro.inspect.client/request-id",-2031123789),req_id,new cljs.core.Keyword("fulcro.inspect.client","app","fulcro.inspect.client/app",-614448539),cljs.core.deref.call(null,app_STAR_)], null);
var temp__5718__auto__ = transform_query.call(null,env,edn);
if(cljs.core.truth_(temp__5718__auto__)){
var edn_SINGLEQUOTE_ = temp__5718__auto__;
return fulcro.client.network.send(self__.network,edn_SINGLEQUOTE_,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__72079,map__72079__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1){
return (function (p1__72027_SHARP_){
return ok.call(null,transform_response.call(null,env,p1__72027_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__72079,map__72079__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1))
,((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__72079,map__72079__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1){
return (function (p1__72028_SHARP_){
return error.call(null,transform_error.call(null,env,p1__72028_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__72079,map__72079__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1))
);
} else {
return ok.call(null,null);
}
});

fulcro.inspect.client.TransformNetwork.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{fulcro.client.network.start(self__.network);
}catch (e72092){if(cljs.core.truth_((function (){var c__4167__auto__ = new cljs.core.Keyword("fulcro.inspect.client","default","fulcro.inspect.client/default",1295274520);
var x__4168__auto__ = e72092;
return (x__4168__auto__ instanceof c__4167__auto__);
})())){
var e_72733 = e72092;
console.log("Error starting sub network",e_72733);
} else {
throw e72092;

}
}
return this$__$1;
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"network","network",2050004697),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fulcro.inspect.client.TransformNetwork(self__.network,self__.options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

fulcro.inspect.client.TransformNetwork.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

fulcro.inspect.client.TransformNetwork.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{return fulcro.client.network.serialize_requests_QMARK_(self__.network);
}catch (e72096){var _ = e72096;
return true;
}});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__72029){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__72101 = cljs.core.keyword_identical_QMARK_;
var expr__72102 = k__4393__auto__;
if(cljs.core.truth_(pred__72101.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__72102))){
return (new fulcro.inspect.client.TransformNetwork(G__72029,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72101.call(null,new cljs.core.Keyword(null,"options","options",99638489),expr__72102))){
return (new fulcro.inspect.client.TransformNetwork(self__.network,G__72029,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro.inspect.client.TransformNetwork(self__.network,self__.options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__72029),null));
}
}
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"options","options",99638489),self__.options,null))], null),self__.__extmap));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__72029){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fulcro.inspect.client.TransformNetwork(self__.network,self__.options,G__72029,self__.__extmap,self__.__hash));
});

fulcro.inspect.client.TransformNetwork.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fulcro.inspect.client.TransformNetwork.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null);
});

fulcro.inspect.client.TransformNetwork.cljs$lang$type = true;

fulcro.inspect.client.TransformNetwork.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fulcro.inspect.client/TransformNetwork",null,(1),null));
});

fulcro.inspect.client.TransformNetwork.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fulcro.inspect.client/TransformNetwork");
});

/**
 * Positional factory function for fulcro.inspect.client/TransformNetwork.
 */
fulcro.inspect.client.__GT_TransformNetwork = (function fulcro$inspect$client$__GT_TransformNetwork(network,options){
return (new fulcro.inspect.client.TransformNetwork(network,options,null,null,null));
});

/**
 * Factory function for fulcro.inspect.client/TransformNetwork, taking a map of keywords to field values.
 */
fulcro.inspect.client.map__GT_TransformNetwork = (function fulcro$inspect$client$map__GT_TransformNetwork(G__72033){
var extmap__4424__auto__ = (function (){var G__72124 = cljs.core.dissoc.call(null,G__72033,new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489));
if(cljs.core.record_QMARK_.call(null,G__72033)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__72124);
} else {
return G__72124;
}
})();
return (new fulcro.inspect.client.TransformNetwork(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__72033),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__72033),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

fulcro.inspect.client.transform_network = (function fulcro$inspect$client$transform_network(network,options){
return fulcro.inspect.client.__GT_TransformNetwork.call(null,network,cljs.core.assoc.call(null,options,new cljs.core.Keyword("fulcro.inspect.client","app*","fulcro.inspect.client/app*",389597452),cljs.core.atom.call(null,null)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {fulcro.client.network.NetworkBehavior}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fulcro.client.network.FulcroRemoteI}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro.inspect.client.TransformNetworkI = (function (network,options,__meta,__extmap,__hash){
this.network = network;
this.options = options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k72136,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__72151 = k72136;
var G__72151__$1 = (((G__72151 instanceof cljs.core.Keyword))?G__72151.fqn:null);
switch (G__72151__$1) {
case "network":
return self__.network;

break;
case "options":
return self__.options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k72136,else__4388__auto__);

}
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__72156){
var vec__72157 = p__72156;
var k__4408__auto__ = cljs.core.nth.call(null,vec__72157,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__72157,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#fulcro.inspect.client.TransformNetworkI{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null))], null),self__.__extmap));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__72135){
var self__ = this;
var G__72135__$1 = this;
return (new cljs.core.RecordIter((0),G__72135__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fulcro.inspect.client.TransformNetworkI(self__.network,self__.options,self__.__meta,self__.__extmap,self__.__hash));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1349897959 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this72137,other72138){
var self__ = this;
var this72137__$1 = this;
return (((!((other72138 == null)))) && ((this72137__$1.constructor === other72138.constructor)) && (cljs.core._EQ_.call(null,this72137__$1.network,other72138.network)) && (cljs.core._EQ_.call(null,this72137__$1.options,other72138.options)) && (cljs.core._EQ_.call(null,this72137__$1.__extmap,other72138.__extmap)));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"network","network",2050004697),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fulcro.inspect.client.TransformNetworkI(self__.network,self__.options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

fulcro.inspect.client.TransformNetworkI.prototype.fulcro$client$network$NetworkBehavior$ = cljs.core.PROTOCOL_SENTINEL;

fulcro.inspect.client.TransformNetworkI.prototype.fulcro$client$network$NetworkBehavior$serialize_requests_QMARK_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((((!((self__.network == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.network.fulcro$client$network$NetworkBehavior$))))?true:(((!self__.network.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,fulcro.client.network.NetworkBehavior,self__.network):false)):cljs.core.native_satisfies_QMARK_.call(null,fulcro.client.network.NetworkBehavior,self__.network))){
return fulcro.client.network.serialize_requests_QMARK_(self__.network);
} else {
return true;
}
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__72135){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__72221 = cljs.core.keyword_identical_QMARK_;
var expr__72222 = k__4393__auto__;
if(cljs.core.truth_(pred__72221.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__72222))){
return (new fulcro.inspect.client.TransformNetworkI(G__72135,self__.options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__72221.call(null,new cljs.core.Keyword(null,"options","options",99638489),expr__72222))){
return (new fulcro.inspect.client.TransformNetworkI(self__.network,G__72135,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro.inspect.client.TransformNetworkI(self__.network,self__.options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__72135),null));
}
}
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"options","options",99638489),self__.options,null))], null),self__.__extmap));
});

fulcro.inspect.client.TransformNetworkI.prototype.fulcro$client$network$FulcroRemoteI$ = cljs.core.PROTOCOL_SENTINEL;

fulcro.inspect.client.TransformNetworkI.prototype.fulcro$client$network$FulcroRemoteI$transmit$arity$2 = (function (_,p__72237){
var self__ = this;
var map__72238 = p__72237;
var map__72238__$1 = (((((!((map__72238 == null))))?(((((map__72238.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72238.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72238):map__72238);
var edn = cljs.core.get.call(null,map__72238__$1,new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957));
var ok_handler = cljs.core.get.call(null,map__72238__$1,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727));
var error_handler = cljs.core.get.call(null,map__72238__$1,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226));
var progress_handler = cljs.core.get.call(null,map__72238__$1,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355));
var ___$1 = this;
var map__72246 = self__.options;
var map__72246__$1 = (((((!((map__72246 == null))))?(((((map__72246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72246.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72246):map__72246);
var transform_query = cljs.core.get.call(null,map__72246__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-query","fulcro.inspect.client/transform-query",-974573391),((function (map__72246,map__72246__$1,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler){
return (function (___$2,x){
return x;
});})(map__72246,map__72246__$1,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_response = cljs.core.get.call(null,map__72246__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-response","fulcro.inspect.client/transform-response",664733229),((function (map__72246,map__72246__$1,transform_query,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler){
return (function (___$2,x){
return x;
});})(map__72246,map__72246__$1,transform_query,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler))
);
var transform_error = cljs.core.get.call(null,map__72246__$1,new cljs.core.Keyword("fulcro.inspect.client","transform-error","fulcro.inspect.client/transform-error",-1523058473),((function (map__72246,map__72246__$1,transform_query,transform_response,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler){
return (function (___$2,x){
return x;
});})(map__72246,map__72246__$1,transform_query,transform_response,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler))
);
var app_STAR_ = cljs.core.get.call(null,map__72246__$1,new cljs.core.Keyword("fulcro.inspect.client","app*","fulcro.inspect.client/app*",389597452));
var req_id = cljs.core.random_uuid.call(null);
var env = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.inspect.client","request-id","fulcro.inspect.client/request-id",-2031123789),req_id,new cljs.core.Keyword("fulcro.inspect.client","app","fulcro.inspect.client/app",-614448539),cljs.core.deref.call(null,app_STAR_)], null);
var temp__5718__auto__ = transform_query.call(null,env,edn);
if(cljs.core.truth_(temp__5718__auto__)){
var edn_SINGLEQUOTE_ = temp__5718__auto__;
return fulcro.client.network.transmit(self__.network,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957),edn_SINGLEQUOTE_,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__72246,map__72246__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__72133_SHARP_){
return ok_handler.call(null,transform_response.call(null,env,p1__72133_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__72246,map__72246__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226),((function (edn_SINGLEQUOTE_,temp__5718__auto__,map__72246,map__72246__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler){
return (function (p1__72134_SHARP_){
return error_handler.call(null,transform_error.call(null,env,p1__72134_SHARP_));
});})(edn_SINGLEQUOTE_,temp__5718__auto__,map__72246,map__72246__$1,transform_query,transform_response,transform_error,app_STAR_,req_id,env,___$1,map__72238,map__72238__$1,edn,ok_handler,error_handler,progress_handler))
,new cljs.core.Keyword("fulcro.client.network","progress-handler","fulcro.client.network/progress-handler",1886593355),progress_handler], null));
} else {
return ok_handler.call(null,null);
}
});

fulcro.inspect.client.TransformNetworkI.prototype.fulcro$client$network$FulcroRemoteI$abort$arity$2 = (function (_,abort_id){
var self__ = this;
var ___$1 = this;
return fulcro.client.network.abort(self__.network,abort_id);
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__72135){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fulcro.inspect.client.TransformNetworkI(self__.network,self__.options,G__72135,self__.__extmap,self__.__hash));
});

fulcro.inspect.client.TransformNetworkI.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fulcro.inspect.client.TransformNetworkI.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"options","options",1740170016,null)], null);
});

fulcro.inspect.client.TransformNetworkI.cljs$lang$type = true;

fulcro.inspect.client.TransformNetworkI.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fulcro.inspect.client/TransformNetworkI",null,(1),null));
});

fulcro.inspect.client.TransformNetworkI.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fulcro.inspect.client/TransformNetworkI");
});

/**
 * Positional factory function for fulcro.inspect.client/TransformNetworkI.
 */
fulcro.inspect.client.__GT_TransformNetworkI = (function fulcro$inspect$client$__GT_TransformNetworkI(network,options){
return (new fulcro.inspect.client.TransformNetworkI(network,options,null,null,null));
});

/**
 * Factory function for fulcro.inspect.client/TransformNetworkI, taking a map of keywords to field values.
 */
fulcro.inspect.client.map__GT_TransformNetworkI = (function fulcro$inspect$client$map__GT_TransformNetworkI(G__72142){
var extmap__4424__auto__ = (function (){var G__72289 = cljs.core.dissoc.call(null,G__72142,new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"options","options",99638489));
if(cljs.core.record_QMARK_.call(null,G__72142)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__72289);
} else {
return G__72289;
}
})();
return (new fulcro.inspect.client.TransformNetworkI(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__72142),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__72142),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

fulcro.inspect.client.transform_network_i = (function fulcro$inspect$client$transform_network_i(network,options){
return fulcro.inspect.client.__GT_TransformNetworkI.call(null,network,cljs.core.assoc.call(null,options,new cljs.core.Keyword("fulcro.inspect.client","app*","fulcro.inspect.client/app*",389597452),cljs.core.atom.call(null,null)));
});
fulcro.inspect.client.inspect_network = (function fulcro$inspect$client$inspect_network(remote,network){
var ts = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.inspect.client","transform-query","fulcro.inspect.client/transform-query",-974573391),(function (p__72313,edn){
var map__72314 = p__72313;
var map__72314__$1 = (((((!((map__72314 == null))))?(((((map__72314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72314.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72314):map__72314);
var request_id = cljs.core.get.call(null,map__72314__$1,new cljs.core.Keyword("fulcro.inspect.client","request-id","fulcro.inspect.client/request-id",-2031123789));
var app = cljs.core.get.call(null,map__72314__$1,new cljs.core.Keyword("fulcro.inspect.client","app","fulcro.inspect.client/app",-614448539));
var start_72820 = (new Date());
var app_uuid_72821 = fulcro.inspect.client.app_uuid.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app));
fulcro.inspect.client.transact_inspector_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.network","history-id","fulcro.inspect.ui.network/history-id",702365090),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.inspect.client.app_uuid_key,app_uuid_72821], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.network","request-start","fulcro.inspect.ui.network/request-start",-1415257884,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.inspect.ui.network","remote","fulcro.inspect.ui.network/remote",-307593223),remote,new cljs.core.Keyword("fulcro.inspect.ui.network","request-id","fulcro.inspect.ui.network/request-id",-2031413204),request_id,new cljs.core.Keyword("fulcro.inspect.ui.network","request-started-at","fulcro.inspect.ui.network/request-started-at",1582455117),start_72820,new cljs.core.Keyword("fulcro.inspect.ui.network","request-edn","fulcro.inspect.ui.network/request-edn",-1638784885),edn], null),null,(1),null)))))], null));

return edn;
}),new cljs.core.Keyword("fulcro.inspect.client","transform-response","fulcro.inspect.client/transform-response",664733229),(function (p__72322,response){
var map__72323 = p__72322;
var map__72323__$1 = (((((!((map__72323 == null))))?(((((map__72323.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72323.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72323):map__72323);
var request_id = cljs.core.get.call(null,map__72323__$1,new cljs.core.Keyword("fulcro.inspect.client","request-id","fulcro.inspect.client/request-id",-2031123789));
var app = cljs.core.get.call(null,map__72323__$1,new cljs.core.Keyword("fulcro.inspect.client","app","fulcro.inspect.client/app",-614448539));
var finished_72831 = (new Date());
var app_uuid_72832 = fulcro.inspect.client.app_uuid.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app));
fulcro.inspect.client.transact_inspector_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.network","history-id","fulcro.inspect.ui.network/history-id",702365090),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.inspect.client.app_uuid_key,app_uuid_72832], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.network","request-finish","fulcro.inspect.ui.network/request-finish",817834789,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.inspect.ui.network","request-id","fulcro.inspect.ui.network/request-id",-2031413204),request_id,new cljs.core.Keyword("fulcro.inspect.ui.network","request-finished-at","fulcro.inspect.ui.network/request-finished-at",-1848991883),finished_72831,new cljs.core.Keyword("fulcro.inspect.ui.network","response-edn","fulcro.inspect.ui.network/response-edn",221134354),response], null),null,(1),null)))))], null));

return response;
}),new cljs.core.Keyword("fulcro.inspect.client","transform-error","fulcro.inspect.client/transform-error",-1523058473),(function (p__72328,error){
var map__72332 = p__72328;
var map__72332__$1 = (((((!((map__72332 == null))))?(((((map__72332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72332):map__72332);
var request_id = cljs.core.get.call(null,map__72332__$1,new cljs.core.Keyword("fulcro.inspect.client","request-id","fulcro.inspect.client/request-id",-2031123789));
var app = cljs.core.get.call(null,map__72332__$1,new cljs.core.Keyword("fulcro.inspect.client","app","fulcro.inspect.client/app",-614448539));
var finished_72841 = (new Date());
var app_uuid_72842 = fulcro.inspect.client.app_uuid.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app));
fulcro.inspect.client.transact_inspector_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.network","history-id","fulcro.inspect.ui.network/history-id",702365090),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.inspect.client.app_uuid_key,app_uuid_72842], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.network","request-finish","fulcro.inspect.ui.network/request-finish",817834789,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.inspect.ui.network","request-id","fulcro.inspect.ui.network/request-id",-2031413204),request_id,new cljs.core.Keyword("fulcro.inspect.ui.network","request-finished-at","fulcro.inspect.ui.network/request-finished-at",-1848991883),finished_72841,new cljs.core.Keyword("fulcro.inspect.ui.network","error","fulcro.inspect.ui.network/error",36212909),error], null),null,(1),null)))))], null));

return error;
})], null);
if((((!((network == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$FulcroNetwork$))))?true:false):false)){
return fulcro.inspect.client.transform_network.call(null,network,ts);
} else {
if((((!((network == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$FulcroRemoteI$))))?true:false):false)){
return fulcro.inspect.client.transform_network_i.call(null,network,cljs.core.update.call(null,ts,new cljs.core.Keyword("fulcro.inspect.client","transform-response","fulcro.inspect.client/transform-response",664733229),((function (ts){
return (function (tr){
return ((function (ts){
return (function (env,p__72352){
var map__72357 = p__72352;
var map__72357__$1 = (((((!((map__72357 == null))))?(((((map__72357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72357):map__72357);
var response = map__72357__$1;
var body = cljs.core.get.call(null,map__72357__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
tr.call(null,env,body);

return response;
});
;})(ts))
});})(ts))
));
} else {
return console.warn("Invalid network",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"network","network",2050004697),network], null));

}
}
});
fulcro.inspect.client.handle_devtool_message = (function fulcro$inspect$client$handle_devtool_message(p__72368){
var map__72369 = p__72368;
var map__72369__$1 = (((((!((map__72369 == null))))?(((((map__72369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72369):map__72369);
var type = cljs.core.get.call(null,map__72369__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var data = cljs.core.get.call(null,map__72369__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var G__72372 = type;
var G__72372__$1 = (((G__72372 instanceof cljs.core.Keyword))?G__72372.fqn:null);
switch (G__72372__$1) {
case "fulcro.inspect.client/request-page-apps":
var seq__72373 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_)));
var chunk__72374 = null;
var count__72375 = (0);
var i__72376 = (0);
while(true){
if((i__72376 < count__72375)){
var map__72394 = cljs.core._nth(chunk__72374,i__72376);
var map__72394__$1 = (((((!((map__72394 == null))))?(((((map__72394.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72394.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72394):map__72394);
var reconciler = cljs.core.get.call(null,map__72394__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__72394__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","init-app","fulcro.inspect.client/init-app",-1984595648),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,fulcro.inspect.client.app_uuid.call(null,reconciler),new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233),fulcro.inspect.client.app_id.call(null,reconciler),new cljs.core.Keyword("fulcro.inspect.client","remotes","fulcro.inspect.client/remotes",-2062632712),cljs.core.sort_by.call(null,cljs.core.juxt.call(null,((function (seq__72373,chunk__72374,count__72375,i__72376,map__72394,map__72394__$1,reconciler,networking,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data){
return (function (p1__72360_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"remote","remote",-1593576576),p1__72360_SHARP_);
});})(seq__72373,chunk__72374,count__72375,i__72376,map__72394,map__72394__$1,reconciler,networking,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data))
,cljs.core.str),cljs.core.keys.call(null,networking)),new cljs.core.Keyword("fulcro.inspect.client","initial-state","fulcro.inspect.client/initial-state",1225829482),cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler)),new cljs.core.Keyword("fulcro.inspect.client","state-hash","fulcro.inspect.client/state-hash",-1488761756),cljs.core.hash.call(null,cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler)))]));


var G__72876 = seq__72373;
var G__72877 = chunk__72374;
var G__72878 = count__72375;
var G__72879 = (i__72376 + (1));
seq__72373 = G__72876;
chunk__72374 = G__72877;
count__72375 = G__72878;
i__72376 = G__72879;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__72373);
if(temp__5720__auto__){
var seq__72373__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72373__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__72373__$1);
var G__72880 = cljs.core.chunk_rest.call(null,seq__72373__$1);
var G__72881 = c__4550__auto__;
var G__72882 = cljs.core.count.call(null,c__4550__auto__);
var G__72883 = (0);
seq__72373 = G__72880;
chunk__72374 = G__72881;
count__72375 = G__72882;
i__72376 = G__72883;
continue;
} else {
var map__72400 = cljs.core.first.call(null,seq__72373__$1);
var map__72400__$1 = (((((!((map__72400 == null))))?(((((map__72400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72400):map__72400);
var reconciler = cljs.core.get.call(null,map__72400__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__72400__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","init-app","fulcro.inspect.client/init-app",-1984595648),cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.inspect.client.app_uuid_key,fulcro.inspect.client.app_uuid.call(null,reconciler),new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233),fulcro.inspect.client.app_id.call(null,reconciler),new cljs.core.Keyword("fulcro.inspect.client","remotes","fulcro.inspect.client/remotes",-2062632712),cljs.core.sort_by.call(null,cljs.core.juxt.call(null,((function (seq__72373,chunk__72374,count__72375,i__72376,map__72400,map__72400__$1,reconciler,networking,seq__72373__$1,temp__5720__auto__,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data){
return (function (p1__72360_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"remote","remote",-1593576576),p1__72360_SHARP_);
});})(seq__72373,chunk__72374,count__72375,i__72376,map__72400,map__72400__$1,reconciler,networking,seq__72373__$1,temp__5720__auto__,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data))
,cljs.core.str),cljs.core.keys.call(null,networking)),new cljs.core.Keyword("fulcro.inspect.client","initial-state","fulcro.inspect.client/initial-state",1225829482),cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler)),new cljs.core.Keyword("fulcro.inspect.client","state-hash","fulcro.inspect.client/state-hash",-1488761756),cljs.core.hash.call(null,cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,reconciler)))]));


var G__72899 = cljs.core.next.call(null,seq__72373__$1);
var G__72900 = null;
var G__72901 = (0);
var G__72902 = (0);
seq__72373 = G__72899;
chunk__72374 = G__72900;
count__72375 = G__72901;
i__72376 = G__72902;
continue;
}
} else {
return null;
}
}
break;
}

break;
case "fulcro.inspect.client/reset-app-state":
var map__72403 = data;
var map__72403__$1 = (((((!((map__72403 == null))))?(((((map__72403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72403.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72403):map__72403);
var target_state = cljs.core.get.call(null,map__72403__$1,new cljs.core.Keyword(null,"target-state","target-state",-682429993));
var app_uuid = cljs.core.get.call(null,map__72403__$1,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491));
var temp__5718__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_),app_uuid);
if(cljs.core.truth_(temp__5718__auto__)){
var map__72410 = temp__5718__auto__;
var map__72410__$1 = (((((!((map__72410 == null))))?(((((map__72410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72410):map__72410);
var reconciler = cljs.core.get.call(null,map__72410__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
if(cljs.core.truth_(target_state)){
var target_state_72907__$1 = cljs.core.assoc.call(null,target_state,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491),app_uuid);
var G__72417_72908 = reconciler;
var G__72417_72909__$1 = (((G__72417_72908 == null))?null:fulcro.client.primitives.app_state.call(null,G__72417_72908));
if((G__72417_72909__$1 == null)){
} else {
cljs.core.reset_BANG_.call(null,G__72417_72909__$1,target_state_72907__$1);
}
} else {
}

return setTimeout(((function (map__72410,map__72410__$1,reconciler,temp__5718__auto__,map__72403,map__72403__$1,target_state,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data){
return (function (){
return fulcro.client.primitives.force_root_render_BANG_.call(null,reconciler);
});})(map__72410,map__72410__$1,reconciler,temp__5718__auto__,map__72403,map__72403__$1,target_state,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data))
,(10));
} else {
return console.log("Reset app on invalid uuid",app_uuid);
}

break;
case "fulcro.inspect.client/transact":
var map__72418 = data;
var map__72418__$1 = (((((!((map__72418 == null))))?(((((map__72418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72418):map__72418);
var tx = cljs.core.get.call(null,map__72418__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var tx_ref = cljs.core.get.call(null,map__72418__$1,new cljs.core.Keyword(null,"tx-ref","tx-ref",-216104949));
var app_uuid = cljs.core.get.call(null,map__72418__$1,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491));
var temp__5718__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_),app_uuid);
if(cljs.core.truth_(temp__5718__auto__)){
var map__72426 = temp__5718__auto__;
var map__72426__$1 = (((((!((map__72426 == null))))?(((((map__72426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72426):map__72426);
var reconciler = cljs.core.get.call(null,map__72426__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
if(cljs.core.truth_(tx_ref)){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,tx_ref,tx);
} else {
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,tx);
}
} else {
return console.log("Transact on invalid uuid",app_uuid);
}

break;
case "fulcro.inspect.client/pick-element":
var map__72428 = data;
var map__72428__$1 = (((((!((map__72428 == null))))?(((((map__72428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72428):map__72428);
var app_uuid = cljs.core.get.call(null,map__72428__$1,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491));
return fulcro.inspect.ui.element_picker.pick_element.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491),app_uuid,new cljs.core.Keyword("fulcro.inspect.ui.element-picker","on-pick","fulcro.inspect.ui.element-picker/on-pick",-1116265320),((function (map__72428,map__72428__$1,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data){
return (function (comp){
if(cljs.core.truth_(comp)){
var details = fulcro.inspect.ui.element_picker.inspect_component.call(null,comp);
return fulcro.inspect.client.transact_inspector_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.element","panel-id","fulcro.inspect.ui.element/panel-id",714724520),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491),app_uuid], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.element","set-element","fulcro.inspect.ui.element/set-element",1898236728,null),null,(1),null)),(new cljs.core.List(null,details,null,(1),null)))))], null));
} else {
return fulcro.inspect.client.transact_inspector_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.element","panel-id","fulcro.inspect.ui.element/panel-id",714724520),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491),app_uuid], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword("ui","picking?","ui/picking?",969621556),null,(1),null)),(new cljs.core.List(null,false,null,(1),null)))))),null,(1),null)))))], null));
}
});})(map__72428,map__72428__$1,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data))
], null));

break;
case "fulcro.inspect.client/show-dom-preview":
var map__72437 = data;
var map__72437__$1 = (((((!((map__72437 == null))))?(((((map__72437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72437):map__72437);
var app_uuid = cljs.core.get.call(null,map__72437__$1,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491));
var app = (function (){var G__72439 = cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_);
if((G__72439 == null)){
return null;
} else {
return cljs.core.get.call(null,G__72439,app_uuid);
}
})();
var app_state = fulcro.inspect.client.db_from_history.call(null,app,new cljs.core.Keyword("fulcro.inspect.client","state-hash","fulcro.inspect.client/state-hash",-1488761756).cljs$core$IFn$_invoke$arity$1(data));
var reconciler = (function (){var G__72446 = cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_);
var G__72446__$1 = (((G__72446 == null))?null:cljs.core.get.call(null,G__72446,app_uuid));
if((G__72446__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(G__72446__$1);
}
})();
var app_root_class = fulcro.client.primitives.react_type.call(null,fulcro.client.primitives.app_root.call(null,reconciler));
var app_root_class_factory = fulcro.client.primitives.factory.call(null,app_root_class);
var root_query = fulcro.client.primitives.get_query.call(null,app_root_class,app_state);
var view_tree = fulcro.client.primitives.db__GT_tree.call(null,root_query,app_state,app_state);
var data__$1 = cljs.core.assoc.call(null,data,new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.vary_meta.call(null,view_tree,cljs.core.assoc,new cljs.core.Keyword(null,"render-fn","render-fn",398796518),app_root_class_factory));
return fulcro.client.primitives.transact_BANG_.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,fulcro.inspect.client.tools_app_STAR_)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.dom-history-viewer","dom-viewer","fulcro.inspect.ui.dom-history-viewer/dom-viewer",212161533),new cljs.core.Keyword(null,"singleton","singleton",-1768662798)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.dom-history-viewer","show-dom-preview","fulcro.inspect.ui.dom-history-viewer/show-dom-preview",626121644,null),null,(1),null)),(new cljs.core.List(null,data__$1,null,(1),null)))))], null));

break;
case "fulcro.inspect.client/hide-dom-preview":
return fulcro.client.primitives.transact_BANG_.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,fulcro.inspect.client.tools_app_STAR_)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.dom-history-viewer","dom-viewer","fulcro.inspect.ui.dom-history-viewer/dom-viewer",212161533),new cljs.core.Keyword(null,"singleton","singleton",-1768662798)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.ui.dom-history-viewer","hide-dom-preview","fulcro.inspect.ui.dom-history-viewer/hide-dom-preview",1398943440,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)))))], null));

break;
case "fulcro.inspect.client/network-request":
var map__72450 = data;
var map__72450__$1 = (((((!((map__72450 == null))))?(((((map__72450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72450.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72450):map__72450);
var query = cljs.core.get.call(null,map__72450__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var remote = cljs.core.get.call(null,map__72450__$1,new cljs.core.Keyword("fulcro.inspect.client","remote","fulcro.inspect.client/remote",-306964848));
var msg_id = cljs.core.get.call(null,map__72450__$1,new cljs.core.Keyword("fulcro.inspect.ui-parser","msg-id","fulcro.inspect.ui-parser/msg-id",-467621998));
var app_uuid = cljs.core.get.call(null,map__72450__$1,new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491));
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.inspect.client.apps_STAR_),app_uuid);
if(cljs.core.truth_(temp__5720__auto__)){
var app = temp__5720__auto__;
var remote__$1 = remote.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app));
var response_handler = ((function (remote__$1,app,temp__5720__auto__,map__72450,map__72450__$1,query,remote,msg_id,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data){
return (function (res){
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","message-response","fulcro.inspect.client/message-response",587955053),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.inspect.ui-parser","msg-id","fulcro.inspect.ui-parser/msg-id",-467621998),msg_id,new cljs.core.Keyword("fulcro.inspect.ui-parser","msg-response","fulcro.inspect.ui-parser/msg-response",1721295840),res], null));
});})(remote__$1,app,temp__5720__auto__,map__72450,map__72450__$1,query,remote,msg_id,app_uuid,G__72372,G__72372__$1,map__72369,map__72369__$1,type,data))
;
if((((!((remote__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === remote__$1.fulcro$client$network$FulcroNetwork$))))?true:false):false)){
return fulcro.client.network.send(remote__$1,query,response_handler,response_handler);
} else {
if((((!((remote__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === remote__$1.fulcro$client$network$FulcroRemoteI$))))?true:false):false)){
return fulcro.client.network.transmit(remote__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.client.network","edn","fulcro.client.network/edn",-1239708957),query,new cljs.core.Keyword("fulcro.client.network","ok-handler","fulcro.client.network/ok-handler",-107274727),cljs.core.comp.call(null,response_handler,new cljs.core.Keyword(null,"body","body",-2049205669)),new cljs.core.Keyword("fulcro.client.network","error-handler","fulcro.client.network/error-handler",-607171226),cljs.core.comp.call(null,response_handler,new cljs.core.Keyword(null,"body","body",-2049205669))], null));
} else {
return null;
}
}
} else {
return null;
}

break;
case "fulcro.inspect.client/console-log":
var map__72470 = data;
var map__72470__$1 = (((((!((map__72470 == null))))?(((((map__72470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72470):map__72470);
var log = cljs.core.get.call(null,map__72470__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var log_js = cljs.core.get.call(null,map__72470__$1,new cljs.core.Keyword(null,"log-js","log-js",-1565471667));
var warn = cljs.core.get.call(null,map__72470__$1,new cljs.core.Keyword(null,"warn","warn",-436710552));
var error = cljs.core.get.call(null,map__72470__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(log)){
return console.log(log);
} else {
if(cljs.core.truth_(log_js)){
return console.log(cljs.core.clj__GT_js.call(null,log_js));
} else {
if(cljs.core.truth_(warn)){
return console.warn(warn);
} else {
if(cljs.core.truth_(error)){
return console.error(error);
} else {
return null;
}
}
}
}

break;
case "fulcro.inspect.client/check-client-version":
return fulcro.inspect.client.post_message.call(null,new cljs.core.Keyword("fulcro.inspect.client","client-version","fulcro.inspect.client/client-version",728119531),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"version","version",425292698),fulcro.inspect.lib.version.last_inspect_version], null));

break;
default:
return console.log("Unknown message",type);

}
});
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.client !== 'undefined') && (typeof fulcro.inspect.client.ClientRoot !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
fulcro.inspect.client.ClientRoot = (function fulcro$inspect$client$ClientRoot(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(fulcro.inspect.client.ClientRoot.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("fulcro.inspect.client","ClientRoot","fulcro.inspect.client/ClientRoot",-683834442),fulcro.inspect.client.ClientRoot);

var x72485_72955 = fulcro.inspect.client.ClientRoot.prototype;
x72485_72955.render = ((function (x72485_72955){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__72491 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__72492 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__72493 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__72494 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__72495 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__72496 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__72497 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__72498 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__72499 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__72500 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__72496;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__72497;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__72498;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__72499;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__72500;

try{var map__72502 = fulcro.client.primitives.props.call(null,this$);
var map__72502__$1 = (((((!((map__72502 == null))))?(((((map__72502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72502.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72502):map__72502);
var history = cljs.core.get.call(null,map__72502__$1,new cljs.core.Keyword(null,"history","history",-247395220));
return fulcro.client.localized_dom.div.call(null,fulcro_css.css.style_element.call(null,this$),fulcro.inspect.ui.dom_history_viewer.ui_dom_history_view.call(null,history));
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__72495;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__72494;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__72493;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__72492;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__72491;
}});})(x72485_72955))
;


fulcro.inspect.client.ClientRoot.prototype.constructor = fulcro.inspect.client.ClientRoot;

fulcro.inspect.client.ClientRoot.prototype.constructor.displayName = "fulcro.inspect.client/ClientRoot";

fulcro.inspect.client.ClientRoot.prototype.fulcro$isComponent = true;

var x72514_72961 = fulcro.inspect.client.ClientRoot;
x72514_72961.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x72514_72961.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x72514_72961){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x72514_72961))
;

x72514_72961.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x72514_72961){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.inspect.ui.element_picker.MarkerCSS,fulcro.inspect.ui.dom_history_viewer.DOMHistoryView], null);
});})(x72514_72961))
;

x72514_72961.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x72514_72961.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x72514_72961){
return (function (c,params){
var c__$1 = this;
return fulcro.client.primitives.make_state_map.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),fulcro.inspect.ui.dom_history_viewer.DOMHistoryView], null),params);
});})(x72514_72961))
;

x72514_72961.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x72514_72961.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x72514_72961){
return (function (this$,p__72519){
var map__72521 = p__72519;
var map__72521__$1 = (((((!((map__72521 == null))))?(((((map__72521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72521):map__72521);
var history = cljs.core.get.call(null,map__72521__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.client","root","fulcro.inspect.client/root",-1445929181),"main"], null);
});})(x72514_72961))
;

x72514_72961.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x72514_72961.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x72514_72961){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),fulcro.client.primitives.get_query.call(null,fulcro.inspect.ui.dom_history_viewer.DOMHistoryView)], null)], null);
});})(x72514_72961))
;


var x72526_72966 = fulcro.inspect.client.ClientRoot.prototype;
x72526_72966.fulcro_css$css_protocols$CSS$ = cljs.core.PROTOCOL_SENTINEL;

x72526_72966.fulcro_css$css_protocols$CSS$local_rules$arity$1 = ((function (x72526_72966){
return (function (_){
var ___$1 = this;
return cljs.core.PersistentVector.EMPTY;
});})(x72526_72966))
;

x72526_72966.fulcro_css$css_protocols$CSS$include_children$arity$1 = ((function (x72526_72966){
return (function (_){
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.inspect.ui.element_picker.MarkerCSS,fulcro.inspect.ui.dom_history_viewer.DOMHistoryView], null);
});})(x72526_72966))
;

x72526_72966.fulcro$client$primitives$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

x72526_72966.fulcro$client$primitives$InitialAppState$initial_state$arity$2 = ((function (x72526_72966){
return (function (c,params){
var c__$1 = this;
return fulcro.client.primitives.make_state_map.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),fulcro.inspect.ui.dom_history_viewer.DOMHistoryView], null),params);
});})(x72526_72966))
;

x72526_72966.fulcro$client$primitives$Ident$ = cljs.core.PROTOCOL_SENTINEL;

x72526_72966.fulcro$client$primitives$Ident$ident$arity$2 = ((function (x72526_72966){
return (function (this$,p__72532){
var map__72533 = p__72532;
var map__72533__$1 = (((((!((map__72533 == null))))?(((((map__72533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72533.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72533):map__72533);
var history = cljs.core.get.call(null,map__72533__$1,new cljs.core.Keyword(null,"history","history",-247395220));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.client","root","fulcro.inspect.client/root",-1445929181),"main"], null);
});})(x72526_72966))
;

x72526_72966.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

x72526_72966.fulcro$client$primitives$IQuery$query$arity$1 = ((function (x72526_72966){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history","history",-247395220),fulcro.client.primitives.get_query.call(null,fulcro.inspect.ui.dom_history_viewer.DOMHistoryView)], null)], null);
});})(x72526_72966))
;


fulcro.inspect.client.ClientRoot.cljs$lang$type = true;

fulcro.inspect.client.ClientRoot.cljs$lang$ctorStr = "fulcro.inspect.client/ClientRoot";

fulcro.inspect.client.ClientRoot.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"fulcro.inspect.client/ClientRoot");
});
fulcro.inspect.client.install = (function fulcro$inspect$client$install(_){
document.documentElement.setAttribute("__fulcro-inspect-remote-installed__",true);

if(cljs.core.truth_(cljs.core.deref.call(null,fulcro.inspect.client.started_QMARK__STAR_))){
return null;
} else {
console.log("Installing Fulcro Inspect",cljs.core.PersistentArrayMap.EMPTY);

cljs.core.reset_BANG_.call(null,fulcro.inspect.client.started_QMARK__STAR_,true);

var app_72976 = fulcro.client.new_fulcro_client.call(null);
var node_72977 = document.createElement("div");
document.body.appendChild(node_72977);

cljs.core.reset_BANG_.call(null,fulcro.inspect.client.tools_app_STAR_,fulcro.client.mount(app_72976,fulcro.inspect.client.ClientRoot,node_72977));

fulcro.client.register_tool.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.client","tool-id","fulcro.client/tool-id",92631184),new cljs.core.Keyword("fulcro.inspect.client","fulcro-inspect-remote","fulcro.inspect.client/fulcro-inspect-remote",309494381),new cljs.core.Keyword("fulcro.client","app-started","fulcro.client/app-started",1807137305),fulcro.inspect.client.inspect_app,new cljs.core.Keyword("fulcro.client","network-wrapper","fulcro.client/network-wrapper",-982819985),(function (networks){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__72554){
var vec__72555 = p__72554;
var k = cljs.core.nth.call(null,vec__72555,(0),null);
var v = cljs.core.nth.call(null,vec__72555,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fulcro.inspect.client.inspect_network.call(null,k,v)], null);
})),networks);
}),new cljs.core.Keyword("fulcro.client","tx-listen","fulcro.client/tx-listen",267162069),fulcro.inspect.client.inspect_tx], null));

return fulcro.inspect.client.listen_local_messages.call(null);
}
});

//# sourceMappingURL=fulcro.inspect.client.js.map
