goog.provide('fulcro.incubator.db_helpers');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.data_fetch');
goog.require('clojure.set');
fulcro.incubator.db_helpers.fulcro_ident_QMARK_ = (function fulcro$incubator$db_helpers$fulcro_ident_QMARK_(x){
return ((cljs.core.vector_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && ((cljs.core.first.call(null,x) instanceof cljs.core.Keyword)));
});
/**
 * Run a query against a component with ident. If you provide a path on
 *   focus-path, only that path will be queried, and the result will be pulled
 *   from the edge of the path.
 */
fulcro.incubator.db_helpers.query_component = (function fulcro$incubator$db_helpers$query_component(var_args){
var G__71248 = arguments.length;
switch (G__71248) {
case 1:
return fulcro.incubator.db_helpers.query_component.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.db_helpers.query_component.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.db_helpers.query_component.cljs$core$IFn$_invoke$arity$1 = (function (this$){
var component = fulcro.client.primitives.react_type.call(null,this$);
var ref = fulcro.client.primitives.get_ident.call(null,this$);
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)));
var query = fulcro.client.primitives.get_query.call(null,component);
return fulcro.client.primitives.db__GT_tree.call(null,query,cljs.core.get_in.call(null,state,ref),state);
});

fulcro.incubator.db_helpers.query_component.cljs$core$IFn$_invoke$arity$2 = (function (this$,focus_path){
var component = fulcro.client.primitives.react_type.call(null,this$);
var ref = fulcro.client.primitives.get_ident.call(null,this$);
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)));
var query = fulcro.client.primitives.focus_query.call(null,fulcro.client.primitives.get_query.call(null,component),focus_path);
return cljs.core.get_in.call(null,fulcro.client.primitives.db__GT_tree.call(null,query,cljs.core.get_in.call(null,state,ref),state),focus_path);
});

fulcro.incubator.db_helpers.query_component.cljs$lang$maxFixedArity = 2;

/**
 * Swap/`update-in` then entity whose ident is `ref` in the given env.
 */
fulcro.incubator.db_helpers.swap_entity_BANG_ = (function fulcro$incubator$db_helpers$swap_entity_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___71421 = arguments.length;
var i__4731__auto___71422 = (0);
while(true){
if((i__4731__auto___71422 < len__4730__auto___71421)){
args__4736__auto__.push((arguments[i__4731__auto___71422]));

var G__71424 = (i__4731__auto___71422 + (1));
i__4731__auto___71422 = G__71424;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fulcro.incubator.db_helpers.swap_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fulcro.incubator.db_helpers.swap_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__71254,args){
var map__71255 = p__71254;
var map__71255__$1 = (((((!((map__71255 == null))))?(((((map__71255.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71255.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71255):map__71255);
var env = map__71255__$1;
var state = cljs.core.get.call(null,map__71255__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71255__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,cljs.core.update_in,ref,args);
});

fulcro.incubator.db_helpers.swap_entity_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fulcro.incubator.db_helpers.swap_entity_BANG_.cljs$lang$applyTo = (function (seq71251){
var G__71252 = cljs.core.first.call(null,seq71251);
var seq71251__$1 = cljs.core.next.call(null,seq71251);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71252,seq71251__$1);
});

/**
 * Walks a db path, when find an ident it resets the path to that ident. Use to realize paths of relations.
 */
fulcro.incubator.db_helpers.resolve_path = (function fulcro$incubator$db_helpers$resolve_path(state,path){
var G__71266 = path;
var vec__71267 = G__71266;
var seq__71268 = cljs.core.seq.call(null,vec__71267);
var first__71269 = cljs.core.first.call(null,seq__71268);
var seq__71268__$1 = cljs.core.next.call(null,seq__71268);
var h = first__71269;
var t = seq__71268__$1;
var new_path = cljs.core.PersistentVector.EMPTY;
var G__71266__$1 = G__71266;
var new_path__$1 = new_path;
while(true){
var vec__71274 = G__71266__$1;
var seq__71275 = cljs.core.seq.call(null,vec__71274);
var first__71276 = cljs.core.first.call(null,seq__71275);
var seq__71275__$1 = cljs.core.next.call(null,seq__71275);
var h__$1 = first__71276;
var t__$1 = seq__71275__$1;
var new_path__$2 = new_path__$1;
if(cljs.core.truth_(h__$1)){
var np = cljs.core.conj.call(null,new_path__$2,h__$1);
var c = cljs.core.get_in.call(null,state,np);
if(fulcro.incubator.db_helpers.fulcro_ident_QMARK_.call(null,c)){
var G__71426 = t__$1;
var G__71427 = c;
G__71266__$1 = G__71426;
new_path__$1 = G__71427;
continue;
} else {
var G__71428 = t__$1;
var G__71429 = cljs.core.conj.call(null,new_path__$2,h__$1);
G__71266__$1 = G__71428;
new_path__$1 = G__71429;
continue;
}
} else {
return new_path__$2;
}
break;
}
});
/**
 * Like swap! but starts at the ref from `env`, adds in supplied `path` elements (resolving across idents if necessary).
 * Finally runs an update-in on that resultant path with the given `args`.
 * 
 * Roughly equivalent to:
 * 
 * ```
 * (swap! (:state env) update-in (resolve-path @state (into (:ref env) path)) args)
 * ```
 * 
 * with a small bit of additional sanity checking.
 * 
 */
fulcro.incubator.db_helpers.swap_in_BANG_ = (function fulcro$incubator$db_helpers$swap_in_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___71431 = arguments.length;
var i__4731__auto___71432 = (0);
while(true){
if((i__4731__auto___71432 < len__4730__auto___71431)){
args__4736__auto__.push((arguments[i__4731__auto___71432]));

var G__71434 = (i__4731__auto___71432 + (1));
i__4731__auto___71432 = G__71434;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.incubator.db_helpers.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.incubator.db_helpers.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__71286,path,args){
var map__71287 = p__71286;
var map__71287__$1 = (((((!((map__71287 == null))))?(((((map__71287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71287):map__71287);
var state = cljs.core.get.call(null,map__71287__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71287__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var path__$1 = fulcro.incubator.db_helpers.resolve_path.call(null,cljs.core.deref.call(null,state),cljs.core.into.call(null,ref,path));
if(cljs.core.truth_((function (){var and__4120__auto__ = path__$1;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,state),path__$1);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,cljs.core.update_in,path__$1,args);
} else {
return cljs.core.deref.call(null,state);
}
});

fulcro.incubator.db_helpers.swap_in_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.incubator.db_helpers.swap_in_BANG_.cljs$lang$applyTo = (function (seq71279){
var G__71280 = cljs.core.first.call(null,seq71279);
var seq71279__$1 = cljs.core.next.call(null,seq71279);
var G__71281 = cljs.core.first.call(null,seq71279__$1);
var seq71279__$2 = cljs.core.next.call(null,seq71279__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71280,G__71281,seq71279__$2);
});

/**
 * Merge the data-tree using the query from component-class, then run integrate-ident with the names parameters.
 */
fulcro.incubator.db_helpers.merge_entity_STAR_ = (function fulcro$incubator$db_helpers$merge_entity_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___71439 = arguments.length;
var i__4731__auto___71440 = (0);
while(true){
if((i__4731__auto___71440 < len__4730__auto___71439)){
args__4736__auto__.push((arguments[i__4731__auto___71440]));

var G__71442 = (i__4731__auto___71440 + (1));
i__4731__auto___71440 = G__71442;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return fulcro.incubator.db_helpers.merge_entity_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

fulcro.incubator.db_helpers.merge_entity_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (state_map,component_class,data_tree,integrate_ident_named_parameters){
var idents = cljs.core.dissoc.call(null,fulcro.client.primitives.tree__GT_db.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.db-helpers","root","fulcro.incubator.db-helpers/root",545774465),fulcro.client.primitives.get_query.call(null,component_class)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.db-helpers","root","fulcro.incubator.db-helpers/root",545774465),data_tree], null),true),new cljs.core.Keyword("fulcro.incubator.db-helpers","root","fulcro.incubator.db-helpers/root",545774465),new cljs.core.Keyword("fulcro.client.primitives","tables","fulcro.client.primitives/tables",-1418944816));
var root_ident = fulcro.client.primitives.ident(component_class,data_tree);
var state = cljs.core.merge_with.call(null,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map,idents);
if(cljs.core.seq.call(null,integrate_ident_named_parameters)){
return cljs.core.apply.call(null,fulcro.client.mutations.integrate_ident_STAR_,state,root_ident,integrate_ident_named_parameters);
} else {
return state;
}
});

fulcro.incubator.db_helpers.merge_entity_STAR_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
fulcro.incubator.db_helpers.merge_entity_STAR_.cljs$lang$applyTo = (function (seq71292){
var G__71293 = cljs.core.first.call(null,seq71292);
var seq71292__$1 = cljs.core.next.call(null,seq71292);
var G__71294 = cljs.core.first.call(null,seq71292__$1);
var seq71292__$2 = cljs.core.next.call(null,seq71292__$1);
var G__71295 = cljs.core.first.call(null,seq71292__$2);
var seq71292__$3 = cljs.core.next.call(null,seq71292__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71293,G__71294,G__71295,seq71292__$3);
});

/**
 * DEPRECATED. Use merge-entity*
 */
fulcro.incubator.db_helpers.merge_entity = fulcro.incubator.db_helpers.merge_entity_STAR_;
/**
 * Mark `data` so that the value is not augmented via get-initial-state merging when using create-entity* and create-entity!
 */
fulcro.incubator.db_helpers.initialized = (function fulcro$incubator$db_helpers$initialized(data){
return cljs.core.vary_meta.call(null,data,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","initialized","fulcro.incubator.db-helpers/initialized",183969656),true);
});
/**
 * Mutation helper.  Create a new instance of the given component class. This differs from Fulcro's standard
 *   merge-component because it combines the `data` with the component's initial state.
 * 
 *   The named-parameters are passed to Fulcro integrate-ident* to add the ident of the new entity into other parts
 *   of your app state. NOTE: The create-entity! function sets these to the invoking components ref + a field. This function
 *   does *not*.
 * 
 *   See create-entity!
 */
fulcro.incubator.db_helpers.create_entity_STAR_ = (function fulcro$incubator$db_helpers$create_entity_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___71450 = arguments.length;
var i__4731__auto___71451 = (0);
while(true){
if((i__4731__auto___71451 < len__4730__auto___71450)){
args__4736__auto__.push((arguments[i__4731__auto___71451]));

var G__71452 = (i__4731__auto___71451 + (1));
i__4731__auto___71451 = G__71452;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return fulcro.incubator.db_helpers.create_entity_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

fulcro.incubator.db_helpers.create_entity_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (state_map,component_class,data,named_parameters){
var data_SINGLEQUOTE_ = (cljs.core.truth_(new cljs.core.Keyword("fulcro.incubator.db-helpers","initialized","fulcro.incubator.db-helpers/initialized",183969656).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data)))?data:fulcro.client.primitives.get_initial_state.call(null,component_class,data));
var data_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.empty_QMARK_.call(null,data_SINGLEQUOTE_))?data:data_SINGLEQUOTE_);
return cljs.core.apply.call(null,fulcro.incubator.db_helpers.merge_entity_STAR_,state_map,component_class,data_SINGLEQUOTE__SINGLEQUOTE_,named_parameters);
});

fulcro.incubator.db_helpers.create_entity_STAR_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
fulcro.incubator.db_helpers.create_entity_STAR_.cljs$lang$applyTo = (function (seq71300){
var G__71301 = cljs.core.first.call(null,seq71300);
var seq71300__$1 = cljs.core.next.call(null,seq71300);
var G__71302 = cljs.core.first.call(null,seq71300__$1);
var seq71300__$2 = cljs.core.next.call(null,seq71300__$1);
var G__71303 = cljs.core.first.call(null,seq71300__$2);
var seq71300__$3 = cljs.core.next.call(null,seq71300__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71301,G__71302,G__71303,seq71300__$3);
});

/**
 * Create a new entity on the database for a given component. Example:
 * 
 *    (fp/defsc TodoItem
 *    [this {::keys []}]
 *    ; note the create-entity! data will be used as input for component initial state
 *    ; function to get the new entity initial state
 *    {:initial-state (fn [{::keys [title]}]
 *                      {::todo-id (random-uuid)
 *                       ::title   title})
 *     :ident         [::todo-id ::todo-id]
 *     :query         [::todo-id ::title]})
 * 
 *    (def todo-item (fp/factory TodoItem {:keyfn ::todo-id}))
 * 
 *    (fm/defmutation add-todo [todo]
 *      (action [env]
 *        ; append will integrate the new ident into the current ref (which is the todo
 *        ; list since it's the transaction reference)
 *        (db.h/create-entity! env TodoItem todo :append ::todo-items)))
 * 
 *    (fp/defsc TodoList
 *      [this {::keys [todo-items]}]
 *      {:initial-state (fn [_]
 *                        {})
 *       :ident         (fn [] [::todo-list "singleton"])
 *       :query         [{::todo-items (fp/get-query TodoItem)}]
 *       :css           []
 *       :css-include   []}
 *      (dom/div
 *        (dom/button {:onClick #(fp/transact! this [`(add-todo {::title "Description"})])})
 *        (mapv todo-item todo-items)))
 * 
 *   If you like to send the new entity data directly you can mark it as initialized:
 * 
 *    (let [todo (-> (fp/get-initial-state TodoItem todo)
 *                   (db.h/initialized))]
 *      (db.h/create-entity! env TodoItem todo :append ::todo-items))
 *   
 */
fulcro.incubator.db_helpers.create_entity_BANG_ = (function fulcro$incubator$db_helpers$create_entity_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___71460 = arguments.length;
var i__4731__auto___71461 = (0);
while(true){
if((i__4731__auto___71461 < len__4730__auto___71460)){
args__4736__auto__.push((arguments[i__4731__auto___71461]));

var G__71463 = (i__4731__auto___71461 + (1));
i__4731__auto___71461 = G__71463;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return fulcro.incubator.db_helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

fulcro.incubator.db_helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__71314,component_class,data,named_parameters){
var map__71315 = p__71314;
var map__71315__$1 = (((((!((map__71315 == null))))?(((((map__71315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71315):map__71315);
var state = cljs.core.get.call(null,map__71315__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71315__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var named_parameters__$1 = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,((function (map__71315,map__71315__$1,state,ref){
return (function (p__71317){
var vec__71318 = p__71317;
var op = cljs.core.nth.call(null,vec__71318,(0),null);
var path = cljs.core.nth.call(null,vec__71318,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [op,cljs.core.conj.call(null,ref,path)], null);
});})(map__71315,map__71315__$1,state,ref))
,cljs.core.partition.call(null,(2),named_parameters)));
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,fulcro.incubator.db_helpers.create_entity_STAR_,component_class,data,ref,named_parameters__$1);
});

fulcro.incubator.db_helpers.create_entity_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
fulcro.incubator.db_helpers.create_entity_BANG_.cljs$lang$applyTo = (function (seq71308){
var G__71309 = cljs.core.first.call(null,seq71308);
var seq71308__$1 = cljs.core.next.call(null,seq71308);
var G__71310 = cljs.core.first.call(null,seq71308__$1);
var seq71308__$2 = cljs.core.next.call(null,seq71308__$1);
var G__71311 = cljs.core.first.call(null,seq71308__$2);
var seq71308__$3 = cljs.core.next.call(null,seq71308__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71309,G__71310,G__71311,seq71308__$3);
});

/**
 * Remove the given leaf of the `path` from recursive data structure `m`
 */
fulcro.incubator.db_helpers.dissoc_in = (function fulcro$incubator$db_helpers$dissoc_in(m,path){
var G__71324 = m;
if(cljs.core.truth_(cljs.core.get_in.call(null,m,cljs.core.butlast.call(null,path)))){
return cljs.core.update_in.call(null,G__71324,cljs.core.butlast.call(null,path),cljs.core.dissoc,cljs.core.last.call(null,path));
} else {
return G__71324;
}
});
/**
 * Recursively remove a table entry (by ident) and anything it recursively points to.
 */
fulcro.incubator.db_helpers.deep_remove_entity_STAR_ = (function fulcro$incubator$db_helpers$deep_remove_entity_STAR_(state_map,ident){
var item = cljs.core.get_in.call(null,state_map,ident);
var idents = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.comp.call(null,cljs.core.keep.call(null,((function (item){
return (function (v){
if(fulcro.incubator.db_helpers.fulcro_ident_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null);
} else {
if(((cljs.core.vector_QMARK_.call(null,v)) && (cljs.core.every_QMARK_.call(null,fulcro.incubator.db_helpers.fulcro_ident_QMARK_,v)))){
return v;
} else {
return null;
}
}
});})(item))
),cljs.core.cat),cljs.core.vals.call(null,item));
return cljs.core.reduce.call(null,((function (item,idents){
return (function (s,i){
return fulcro.incubator.db_helpers.deep_remove_entity_STAR_.call(null,s,i);
});})(item,idents))
,fulcro.incubator.db_helpers.dissoc_in.call(null,state_map,ident),idents);
});
/**
 * DEPRECATED: Use deep-remote-entity*
 */
fulcro.incubator.db_helpers.deep_remove_ref = fulcro.incubator.db_helpers.deep_remove_entity_STAR_;
/**
 * Given a mutation env and a field: Remove the graph edge designated by `field`, and recursively remove the data
 * for the referenced entity/ies (to-one or to-many).
 */
fulcro.incubator.db_helpers.remove_edge_BANG_ = (function fulcro$incubator$db_helpers$remove_edge_BANG_(p__71332,field){
var map__71333 = p__71332;
var map__71333__$1 = (((((!((map__71333 == null))))?(((((map__71333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71333.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71333):map__71333);
var env = map__71333__$1;
var state = cljs.core.get.call(null,map__71333__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71333__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var children = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,ref,field));
if(fulcro.incubator.db_helpers.fulcro_ident_QMARK_.call(null,children)){
return cljs.core.swap_BANG_.call(null,state,cljs.core.comp.call(null,((function (children,map__71333,map__71333__$1,env,state,ref){
return (function (p1__71327_SHARP_){
return cljs.core.update_in.call(null,p1__71327_SHARP_,ref,cljs.core.dissoc,field);
});})(children,map__71333,map__71333__$1,env,state,ref))
,((function (children,map__71333,map__71333__$1,env,state,ref){
return (function (p1__71329_SHARP_){
return fulcro.incubator.db_helpers.deep_remove_entity_STAR_.call(null,p1__71329_SHARP_,children);
});})(children,map__71333,map__71333__$1,env,state,ref))
));
} else {
if(cljs.core.seq.call(null,children)){
return cljs.core.swap_BANG_.call(null,state,cljs.core.comp.call(null,((function (children,map__71333,map__71333__$1,env,state,ref){
return (function (p1__71330_SHARP_){
return cljs.core.assoc_in.call(null,p1__71330_SHARP_,cljs.core.conj.call(null,ref,field),cljs.core.PersistentVector.EMPTY);
});})(children,map__71333,map__71333__$1,env,state,ref))
,((function (children,map__71333,map__71333__$1,env,state,ref){
return (function (p1__71331_SHARP_){
return cljs.core.reduce.call(null,fulcro.incubator.db_helpers.deep_remove_entity_STAR_,p1__71331_SHARP_,children);
});})(children,map__71333,map__71333__$1,env,state,ref))
));
} else {
return null;
}
}
});
/**
 * Fill in any declared component initial state over a just-loaded entity.  This recursively follows the query of the
 *   component, calling `get-initial-state` at each level, and fills in any *missing* fields with the data from initial
 *   state.  This allows a newly-fetched item to have initial state for ui-only attributes.
 */
fulcro.incubator.db_helpers.init_loaded_state_STAR_ = (function fulcro$incubator$db_helpers$init_loaded_state_STAR_(state,component_class,ident){
var initial = fulcro.client.primitives.get_initial_state.call(null,component_class,null);
var children = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(fulcro.client.primitives.query__GT_ast.call(null,fulcro.client.primitives.get_query.call(null,component_class)));
var data = fulcro.client.primitives.db__GT_tree.call(null,fulcro.client.primitives.get_query.call(null,component_class),cljs.core.get_in.call(null,state,ident),state);
return cljs.core.reduce.call(null,((function (initial,children,data){
return (function (s,p__71338){
var map__71339 = p__71338;
var map__71339__$1 = (((((!((map__71339 == null))))?(((((map__71339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71339):map__71339);
var type = cljs.core.get.call(null,map__71339__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var component = cljs.core.get.call(null,map__71339__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var key = cljs.core.get.call(null,map__71339__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"join","join",-758861890),type);
if(and__4120__auto__){
return component;
} else {
return and__4120__auto__;
}
})())){
var value = cljs.core.get_in.call(null,state,cljs.core.conj.call(null,ident,key));
if(fulcro.incubator.db_helpers.fulcro_ident_QMARK_.call(null,value)){
return fulcro.incubator.db_helpers.init_loaded_state_STAR_.call(null,s,component,value);
} else {
if(cljs.core.vector_QMARK_.call(null,value)){
return cljs.core.reduce.call(null,((function (value,map__71339,map__71339__$1,type,component,key,initial,children,data){
return (function (s__$1,ident__$1){
if(fulcro.incubator.db_helpers.fulcro_ident_QMARK_.call(null,ident__$1)){
return fulcro.incubator.db_helpers.init_loaded_state_STAR_.call(null,s__$1,component,ident__$1);
} else {
return s__$1;
}
});})(value,map__71339,map__71339__$1,type,component,key,initial,children,data))
,s,value);
} else {
return s;

}
}
} else {
return s;
}
});})(initial,children,data))
,fulcro.incubator.db_helpers.merge_entity_STAR_.call(null,state,component_class,cljs.core.merge.call(null,initial,data)),children);
});
/**
 * DEPRECATED: use init-loaded-state*
 */
fulcro.incubator.db_helpers.init_state = fulcro.incubator.db_helpers.init_loaded_state_STAR_;
/**
 * Remove an item from a vector via index.
 */
fulcro.incubator.db_helpers.vec_remove_index = (function fulcro$incubator$db_helpers$vec_remove_index(i,v){
return cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.subvec.call(null,v,(0),i),cljs.core.subvec.call(null,v,(i + (1)),cljs.core.count.call(null,v))));
});
/**
 * Set given keys to empty strings on current ref of `env`.
 */
fulcro.incubator.db_helpers.clean_keys = (function fulcro$incubator$db_helpers$clean_keys(env,keys){
var empty_map = cljs.core.zipmap.call(null,keys,cljs.core.repeat.call(null,""));
return fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.merge,empty_map);
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.db-helpers","init-loaded-state","fulcro.incubator.db-helpers/init-loaded-state",-221375603,null),(function (fulcro_incoming_env,_,p__71344){
var map__71346 = p__71344;
var map__71346__$1 = (((((!((map__71346 == null))))?(((((map__71346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71346):map__71346);
var ref = cljs.core.get.call(null,map__71346__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var component = cljs.core.get.call(null,map__71346__$1,new cljs.core.Keyword(null,"component","component",1555936782));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__71346,map__71346__$1,ref,component){
return (function (){
var map__71348 = env;
var map__71348__$1 = (((((!((map__71348 == null))))?(((((map__71348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71348):map__71348);
var state = cljs.core.get.call(null,map__71348__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,fulcro.incubator.db_helpers.init_loaded_state_STAR_,component,ref);
});})(env,map__71346,map__71346__$1,ref,component))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.db-helpers","multi-mutation","fulcro.incubator.db-helpers/multi-mutation",-1830897321,null),(function (fulcro_incoming_env,_,mutations){
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env){
return (function (){
var seq__71352 = cljs.core.seq.call(null,mutations);
var chunk__71354 = null;
var count__71355 = (0);
var i__71356 = (0);
while(true){
if((i__71356 < count__71355)){
var vec__71367 = cljs.core._nth(chunk__71354,i__71356);
var sym = cljs.core.nth.call(null,vec__71367,(0),null);
var params = cljs.core.nth.call(null,vec__71367,(1),null);
if((sym instanceof cljs.core.Symbol)){
new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(fulcro.client.mutations.mutate.call(null,env,sym,params)).call(null);


var G__71497 = seq__71352;
var G__71498 = chunk__71354;
var G__71499 = count__71355;
var G__71500 = (i__71356 + (1));
seq__71352 = G__71497;
chunk__71354 = G__71498;
count__71355 = G__71499;
i__71356 = G__71500;
continue;
} else {
var G__71503 = seq__71352;
var G__71504 = chunk__71354;
var G__71505 = count__71355;
var G__71506 = (i__71356 + (1));
seq__71352 = G__71503;
chunk__71354 = G__71504;
count__71355 = G__71505;
i__71356 = G__71506;
continue;
}
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__71352);
if(temp__5720__auto__){
var seq__71352__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71352__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__71352__$1);
var G__71509 = cljs.core.chunk_rest.call(null,seq__71352__$1);
var G__71510 = c__4550__auto__;
var G__71511 = cljs.core.count.call(null,c__4550__auto__);
var G__71512 = (0);
seq__71352 = G__71509;
chunk__71354 = G__71510;
count__71355 = G__71511;
i__71356 = G__71512;
continue;
} else {
var vec__71370 = cljs.core.first.call(null,seq__71352__$1);
var sym = cljs.core.nth.call(null,vec__71370,(0),null);
var params = cljs.core.nth.call(null,vec__71370,(1),null);
if((sym instanceof cljs.core.Symbol)){
new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(fulcro.client.mutations.mutate.call(null,env,sym,params)).call(null);


var G__71515 = cljs.core.next.call(null,seq__71352__$1);
var G__71516 = null;
var G__71517 = (0);
var G__71518 = (0);
seq__71352 = G__71515;
chunk__71354 = G__71516;
count__71355 = G__71517;
i__71356 = G__71518;
continue;
} else {
var G__71520 = cljs.core.next.call(null,seq__71352__$1);
var G__71521 = null;
var G__71522 = (0);
var G__71523 = (0);
seq__71352 = G__71520;
chunk__71354 = G__71521;
count__71355 = G__71522;
i__71356 = G__71523;
continue;
}
}
} else {
return null;
}
}
break;
}
});})(env))
], null);
})());
}));
fulcro.incubator.db_helpers.response_component = (function fulcro$incubator$db_helpers$response_component(component){
return cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),component], null));
});
fulcro.incubator.db_helpers.get_response_component = (function fulcro$incubator$db_helpers$get_response_component(response){
return new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(response)));
});
/**
 * A helper function that you should not use. 
 */
fulcro.incubator.db_helpers.transform_remote = (function fulcro$incubator$db_helpers$transform_remote(env,ast){
var ast__$1 = ((ast === true)?new cljs.core.Keyword(null,"ast","ast",-860334068).cljs$core$IFn$_invoke$arity$1(env):ast);
var temp__5718__auto___71527 = (function (){var G__71376 = ast__$1;
var G__71376__$1 = (((G__71376 == null))?null:new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(G__71376));
var G__71376__$2 = (((G__71376__$1 == null))?null:cljs.core.meta.call(null,G__71376__$1));
if((G__71376__$2 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(G__71376__$2);
}
})();
if(cljs.core.truth_(temp__5718__auto___71527)){
var component_71531 = temp__5718__auto___71527;
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429),new cljs.core.Keyword(null,"component","component",1555936782)], null),fulcro.incubator.db_helpers.response_component.call(null,component_71531));
} else {
}

return fulcro.client.mutations.with_target.call(null,(function (){var G__71378 = ast__$1;
if(cljs.core.truth_(new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(ast__$1))){
return cljs.core.update.call(null,G__71378,new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.vary_meta,cljs.core.dissoc,new cljs.core.Keyword(null,"component","component",1555936782));
} else {
return G__71378;
}
})(),cljs.core.conj.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response-swap","fulcro.incubator.db-helpers/mutation-response-swap",1172246221)));
});
/**
 * Retrieves the mutation response from `this` component.  Can also be used against the state-map with an ident.
 */
fulcro.incubator.db_helpers.mutation_response = (function fulcro$incubator$db_helpers$mutation_response(var_args){
var G__71382 = arguments.length;
switch (G__71382) {
case 1:
return fulcro.incubator.db_helpers.mutation_response.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.db_helpers.mutation_response.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.db_helpers.mutation_response.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if(fulcro.client.primitives.component_QMARK_.call(null,this$)){
return fulcro.incubator.db_helpers.mutation_response.call(null,cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$))),fulcro.client.primitives.props.call(null,this$));
} else {
return new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429).cljs$core$IFn$_invoke$arity$1(this$);
}
});

fulcro.incubator.db_helpers.mutation_response.cljs$core$IFn$_invoke$arity$2 = (function (state,props){
var response = new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429).cljs$core$IFn$_invoke$arity$1(props);
if(fulcro.util.ident_QMARK_.call(null,response)){
return cljs.core.get_in.call(null,state,response);
} else {
return response;
}
});

fulcro.incubator.db_helpers.mutation_response.cljs$lang$maxFixedArity = 2;

/**
 * Checks this props of `this` component to see if a mutation is in progress.
 */
fulcro.incubator.db_helpers.mutation_loading_QMARK_ = (function fulcro$incubator$db_helpers$mutation_loading_QMARK_(this$){
var props = (function (){var G__71386 = this$;
if(fulcro.client.primitives.component_QMARK_.call(null,this$)){
return fulcro.client.primitives.props.call(null,G__71386);
} else {
return G__71386;
}
})();
return fulcro.client.data_fetch.loading_QMARK_.call(null,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429).cljs$core$IFn$_invoke$arity$1(props));
});
/**
 * Is the mutation in error. This version assumes you use :com.wsscode.pathom.core/mutation-errors as a key in your
 *   response to indicate an error.
 */
fulcro.incubator.db_helpers.mutation_error_QMARK_ = (function fulcro$incubator$db_helpers$mutation_error_QMARK_(var_args){
var G__71388 = arguments.length;
switch (G__71388) {
case 1:
return fulcro.incubator.db_helpers.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.incubator.db_helpers.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.db_helpers.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (this$){
return cljs.core.contains_QMARK_.call(null,fulcro.incubator.db_helpers.mutation_response.call(null,this$),new cljs.core.Keyword("com.wsscode.pathom.core","mutation-errors","com.wsscode.pathom.core/mutation-errors",1569788218));
});

fulcro.incubator.db_helpers.mutation_error_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (state,props){
return cljs.core.contains_QMARK_.call(null,fulcro.incubator.db_helpers.mutation_response.call(null,state,props),new cljs.core.Keyword("com.wsscode.pathom.core","mutation-errors","com.wsscode.pathom.core/mutation-errors",1569788218));
});

fulcro.incubator.db_helpers.mutation_error_QMARK_.cljs$lang$maxFixedArity = 2;

/**
 * Runs the side-effect-free multimethod for the given (client) mutation and returns a map describing the mutation:
 * 
 *   {:action (fn [env] ...)
 * :remote ...}
 */
fulcro.incubator.db_helpers.get_mutation = (function fulcro$incubator$db_helpers$get_mutation(env,k,p){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.methods$.call(null,fulcro.client.mutations.mutate),k);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return m.call(null,env,k,p);
} else {
return null;
}
});
/**
 * Call a Fulcro client mutation action (defined on the multimethod fulcro.client.mutations/mutate). This
 *   runs the `action` section of the mutation and returns its value.
 */
fulcro.incubator.db_helpers.call_mutation_action = (function fulcro$incubator$db_helpers$call_mutation_action(env,k,p){
var temp__5720__auto__ = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(fulcro.incubator.db_helpers.get_mutation.call(null,env,k,p));
if(cljs.core.truth_(temp__5720__auto__)){
var h = temp__5720__auto__;
return h.call(null);
} else {
return null;
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__71393){
return cljs.core.map_QMARK_.call(null,G__71393);
})], null),(function (G__71393){
return cljs.core.map_QMARK_.call(null,G__71393);
}),cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),null])));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.db-helpers","mutation-network-error","fulcro.incubator.db-helpers/mutation-network-error",-1922384364,null),(function (fulcro_incoming_env,_,p__71397){
var map__71398 = p__71397;
var map__71398__$1 = (((((!((map__71398 == null))))?(((((map__71398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71398):map__71398);
var p = map__71398__$1;
var ref = cljs.core.get.call(null,map__71398__$1,new cljs.core.Keyword("fulcro.incubator.db-helpers","ref","fulcro.incubator.db-helpers/ref",169567445));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__71398,map__71398__$1,p,ref){
return (function (){
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"ref","ref",1289896967),ref),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429),cljs.core.assoc.call(null,cljs.core.dissoc.call(null,p,new cljs.core.Keyword("fulcro.incubator.db-helpers","ref","fulcro.incubator.db-helpers/ref",169567445)),new cljs.core.Keyword("fulcro.client.primitives","error","fulcro.client.primitives/error",1510344092),"Network error"));

return null;
});})(env,map__71398,map__71398__$1,p,ref))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.db-helpers","start-pmutation","fulcro.incubator.db-helpers/start-pmutation",-1827491093,null),(function (fulcro_incoming_env,_,___$1){
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env){
return (function (){
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),new cljs.core.Keyword(null,"loading","loading",-737050189)], null));

return null;
});})(env))
], null);
})());
}));
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.db-helpers","finish-pmutation","fulcro.incubator.db-helpers/finish-pmutation",-1763091939,null),(function (fulcro_incoming_env,_,p__71403){
var map__71404 = p__71403;
var map__71404__$1 = (((((!((map__71404 == null))))?(((((map__71404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71404):map__71404);
var ok_mutation = cljs.core.get.call(null,map__71404__$1,new cljs.core.Keyword(null,"ok-mutation","ok-mutation",1189511936));
var error_mutation = cljs.core.get.call(null,map__71404__$1,new cljs.core.Keyword(null,"error-mutation","error-mutation",1814452520));
var input = cljs.core.get.call(null,map__71404__$1,new cljs.core.Keyword(null,"input","input",556931961));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__71404,map__71404__$1,ok_mutation,error_mutation,input){
return (function (){
var map__71408 = env;
var map__71408__$1 = (((((!((map__71408 == null))))?(((((map__71408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71408.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71408):map__71408);
var state = cljs.core.get.call(null,map__71408__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71408__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var reconciler = cljs.core.get.call(null,map__71408__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__71409 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),ref);
var map__71409__$1 = (((((!((map__71409 == null))))?(((((map__71409.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71409.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71409):map__71409);
var props = map__71409__$1;
var mutation_response = cljs.core.get.call(null,map__71409__$1,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429));
var mutation_response_swap = cljs.core.get.call(null,map__71409__$1,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response-swap","fulcro.incubator.db-helpers/mutation-response-swap",1172246221));
if(fulcro.incubator.db_helpers.mutation_error_QMARK_.call(null,cljs.core.deref.call(null,state),clojure.set.rename_keys.call(null,props,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response-swap","fulcro.incubator.db-helpers/mutation-response-swap",1172246221),new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429)], null)))){
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429),mutation_response_swap);

fulcro.incubator.db_helpers.call_mutation_action.call(null,env,error_mutation,input);
} else {
var temp__5720__auto___71573 = fulcro.incubator.db_helpers.get_response_component.call(null,mutation_response);
if(cljs.core.truth_(temp__5720__auto___71573)){
var component_71574 = temp__5720__auto___71573;
fulcro.client.primitives.merge_component_BANG_.call(null,reconciler,component_71574,mutation_response_swap);
} else {
}

if(cljs.core.truth_(fulcro.incubator.db_helpers.mutation_loading_QMARK_.call(null,props))){
fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response","fulcro.incubator.db-helpers/mutation-response",1254256429));
} else {
}

fulcro.incubator.db_helpers.call_mutation_action.call(null,env,ok_mutation,input);
}

return fulcro.incubator.db_helpers.swap_entity_BANG_.call(null,env,cljs.core.dissoc,new cljs.core.Keyword("fulcro.incubator.db-helpers","mutation-response-swap","fulcro.incubator.db-helpers/mutation-response-swap",1172246221));
});})(env,map__71404,map__71404__$1,ok_mutation,error_mutation,input))
], null);
})());
}));
/**
 * Run a pmutation defined by `defpmutation`.
 * 
 *   this - The component whose ident will be used for status reporting on the progress of the mutation.
 *   mutation - The symbol of the mutation you want to run.
 *   params - The parameter map for the mutation.
 * 
 *   The `params` map can contain the additional special keys which are used to augment the functionality:
 * 
 *   `::pm/error-marker` - An opaque value that will be placed in the mutation response if there is an error. You can
 *   use this to distinguish the error when components in the UI share idents.
 * 
 *   
 */
fulcro.incubator.db_helpers.pmutate_BANG_ = (function fulcro$incubator$db_helpers$pmutate_BANG_(this$,mutation,params){
var ok_mutation = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mutation),"-ok"].join(''));
var error_mutation = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mutation),"-error"].join(''));
return fulcro.client.primitives.ptransact_BANG_.call(null,this$,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.db-helpers","start-pmutation","fulcro.incubator.db-helpers/start-pmutation",-1827491093,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,(new cljs.core.List(null,mutation,(new cljs.core.List(null,params,null,(1),null)),(2),null)),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.client.data-fetch","fallback","fulcro.client.data-fetch/fallback",1556791555,null),null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"action","action",-811238024),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.db-helpers","mutation-network-error","fulcro.incubator.db-helpers/mutation-network-error",-1922384364,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("fulcro.incubator.db-helpers","ref","fulcro.incubator.db-helpers/ref",169567445),null,(1),null)),(new cljs.core.List(null,fulcro.client.primitives.get_ident.call(null,this$),null,(1),null)))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fulcro.incubator.db-helpers","finish-pmutation","fulcro.incubator.db-helpers/finish-pmutation",-1763091939,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ok-mutation","ok-mutation",1189511936),ok_mutation,new cljs.core.Keyword(null,"error-mutation","error-mutation",1814452520),error_mutation,new cljs.core.Keyword(null,"input","input",556931961),params], null),null,(1),null))))),null,(1),null)))))));
});

//# sourceMappingURL=fulcro.incubator.db_helpers.js.map
