goog.provide('fulcro.incubator.ui_state_machines');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('cljs.spec.alpha');
goog.require('cljs.spec.test.alpha');
goog.require('fulcro.logging');
goog.require('fulcro.client.data_fetch');
goog.require('fulcro.client.impl.data_targeting');
goog.require('fulcro.client.impl.protocols');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.primitives');
goog.require('fulcro.incubator.mutation_interface');
goog.require('fulcro.incubator.spec_helpers');
goog.require('fulcro.incubator.pessimistic_mutations');
goog.require('fulcro.util');
fulcro.incubator.ui_state_machines.mutation_delegate = fulcro.incubator.mutation_interface.__GT_Mutation.call(null,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","mutation-delegate","fulcro.incubator.ui-state-machines/mutation-delegate",-1977239495,null),cljs.core.map_QMARK_);
/**
 * No effect in CLJ. In CLJS, defer calling `f` until the current UI thread is released (setTimeout 0).
 */
fulcro.incubator.ui_state_machines.defer = (function fulcro$incubator$ui_state_machines$defer(f){
return setTimeout(f,(0));
});
fulcro.incubator.ui_state_machines.set_js_timeout_BANG_ = (function fulcro$incubator$ui_state_machines$set_js_timeout_BANG_(f,tm){
return setTimeout(f,tm);
});
fulcro.incubator.ui_state_machines.clear_js_timeout_BANG_ = (function fulcro$incubator$ui_state_machines$clear_js_timeout_BANG_(timer){
return clearTimeout(timer);
});
/**
 * Returns TRUE when x is an atom.
 */
fulcro.incubator.ui_state_machines.is_atom_QMARK_ = (function fulcro$incubator$ui_state_machines$is_atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","atom","fulcro.incubator.ui-state-machines/atom",-2144865964),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","is-atom?","fulcro.incubator.ui-state-machines/is-atom?",-672628443,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.list(new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null),null),"null",cljs.core.list(new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null),cljs.core.PersistentArrayMap.EMPTY),"null",cljs.core.list(new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null),cljs.core.PersistentHashSet.EMPTY),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,fulcro.incubator.ui_state_machines.is_atom_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.atom.call(null,null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("fulcro.util","ident?","fulcro.util/ident?",-2064561335,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),(1)], null),"null",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"other","other",995793544),new cljs.core.Keyword(null,"tab","tab",-559583621)], null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,fulcro.util.ident_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),(1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"other","other",995793544),new cljs.core.Keyword(null,"tab","tab",-559583621)], null)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("fulcro.client.primitives","reconciler?","fulcro.client.primitives/reconciler?",-1575870606,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol("fulcro.client.primitives","reconciler","fulcro.client.primitives/reconciler",1357504637,null),cljs.core.PersistentArrayMap.EMPTY),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,fulcro.client.primitives.reconciler_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([fulcro.client.primitives.reconciler.call(null,cljs.core.PersistentArrayMap.EMPTY)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73007){
return cljs.core.map_QMARK_.call(null,G__73007);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73009){
return cljs.core.map_QMARK_.call(null,G__73009);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"the-state-machine","the-state-machine",923612868,null)),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.symbol_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"the-state-machine","the-state-machine",923612868,null),null], null), null));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.any_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73027){
return cljs.core.map_QMARK_.call(null,G__73027);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),cljs.core.pos_int_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timer-1","timer-1",549442173),"null",(42),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.any_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timer-1","timer-1",549442173),null,(42),null], null), null));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-fn","fulcro.incubator.ui-state-machines/cancel-fn",646002455),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"other!","other!",696342595),"null",new cljs.core.Keyword(null,"event!","event!",-361570295),"null"], null), null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.fn_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"other!","other!",696342595),null,new cljs.core.Keyword(null,"event!","event!",-361570295),null], null), null)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__73054#","p1__73054#",-1846702204,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__73054#","p1__73054#",-1846702204,null),new cljs.core.Symbol("cljs.core","meta","cljs.core/meta",-748218346,null),new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol("cljs.core","with-meta","cljs.core/with-meta",749126446,null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"e","e",-1273166571,null)], null),true)], null)),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,(function (p1__73054_SHARP_){
return cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__73054_SHARP_)));
}),(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301),(function (e){
return true;
})], null))]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__73070#","p1__73070#",420922632,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__73070#","p1__73070#",420922632,null),new cljs.core.Symbol("cljs.core","meta","cljs.core/meta",-748218346,null),new cljs.core.Keyword(null,"timer","timer",-1266967739),new cljs.core.Symbol("cljs.core","boolean","cljs.core/boolean",-1222483266,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol("cljs.core","with-meta","cljs.core/with-meta",749126446,null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"timer","timer",-1266967739),cljs.core.PersistentArrayMap.EMPTY], null)),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,(function (p1__73070_SHARP_){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"timer","timer",-1266967739).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__73070_SHARP_)));
}),(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"timer","timer",-1266967739),cljs.core.PersistentArrayMap.EMPTY], null))]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73080){
return cljs.core.map_QMARK_.call(null,G__73080);
}),(function (G__73080){
return cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963));
}),(function (G__73080){
return cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771));
}),(function (G__73080){
return cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
}),(function (G__73080){
return cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242));
}),(function (G__73080){
return cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796));
})], null),(function (G__73080){
return ((cljs.core.map_QMARK_.call(null,G__73080)) && (cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963))) && (cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771))) && (cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503))) && (cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242))) && (cljs.core.contains_QMARK_.call(null,G__73080,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796))));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73174){
return cljs.core.coll_QMARK_.call(null,G__73174);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73175){
return cljs.core.map_QMARK_.call(null,G__73175);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout-descriptor","fulcro.incubator.ui-state-machines/timeout-descriptor",618556623))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm","fulcro.incubator.ui-state-machines/asm",2115037986),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73184){
return cljs.core.map_QMARK_.call(null,G__73184);
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640));
}),(function (G__73184){
return cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083));
})], null),(function (G__73184){
return ((cljs.core.map_QMARK_.call(null,G__73184)) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640))) && (cljs.core.contains_QMARK_.call(null,G__73184,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083))));
}),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)))], null),null])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73259){
return cljs.core.map_QMARK_.call(null,G__73259);
}),(function (G__73259){
return cljs.core.contains_QMARK_.call(null,G__73259,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111));
}),(function (G__73259){
return cljs.core.contains_QMARK_.call(null,G__73259,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
})], null),(function (G__73259){
return ((cljs.core.map_QMARK_.call(null,G__73259)) && (cljs.core.contains_QMARK_.call(null,G__73259,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111))) && (cljs.core.contains_QMARK_.call(null,G__73259,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187))));
}),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)))], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342)], null)])));
fulcro.incubator.ui_state_machines.fake_handler = (function fulcro$incubator$ui_state_machines$fake_handler(env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return env;
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73282){
return cljs.core.set_QMARK_.call(null,G__73282);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.set_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null)], null),true),"null",cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null)], null),false),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.fn_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([(function (_){
return true;
}),(function (_){
return false;
})]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("fulcro.incubator.ui-state-machines","fake-handler","fulcro.incubator.ui-state-machines/fake-handler",1984914581,null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.fn_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([fulcro.incubator.ui_state_machines.fake_handler]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73292){
return cljs.core.map_QMARK_.call(null,G__73292);
})], null),(function (G__73292){
return cljs.core.map_QMARK_.call(null,G__73292);
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73300){
return cljs.core.map_QMARK_.call(null,G__73300);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-processing","fulcro.incubator.ui-state-machines/event-processing",2076573625))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"handler","handler",-195596612),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null)),new cljs.core.Keyword(null,"events","events",1792552201),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)], null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","fake-handler","fulcro.incubator.ui-state-machines/fake-handler",1984914581,null)], null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"events","events",1792552201)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73304){
return cljs.core.map_QMARK_.call(null,G__73304);
}),(function (G__73304){
return cljs.core.contains_QMARK_.call(null,G__73304,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199));
})], null),(function (G__73304){
return ((cljs.core.map_QMARK_.call(null,G__73304)) && (cljs.core.contains_QMARK_.call(null,G__73304,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199))));
}),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)))], null),null])),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73338){
return cljs.core.map_QMARK_.call(null,G__73338);
}),(function (G__73338){
return cljs.core.contains_QMARK_.call(null,G__73338,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170));
})], null),(function (G__73338){
return ((cljs.core.map_QMARK_.call(null,G__73338)) && (cljs.core.contains_QMARK_.call(null,G__73338,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170))));
}),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170)))], null),null]))], null),null),(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),fulcro.incubator.ui_state_machines.fake_handler], null)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424)),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","fake-handler","fulcro.incubator.ui-state-machines/fake-handler",1984914581,null)], null)], null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73376){
return cljs.core.map_QMARK_.call(null,G__73376);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state","fulcro.incubator.ui-state-machines/state",-544056424))], null),null),(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),fulcro.incubator.ui_state_machines.fake_handler], null)], null)]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null))),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.list(new cljs.core.Symbol("s","tuple","s/tuple",1167863840,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null))),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.core.keyword_QMARK_], null))], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73387){
return cljs.core.map_QMARK_.call(null,G__73387);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aliases","aliases",-1307561055,null)], null),null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.any_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([(function (aliases){
return null;
})]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790)),cljs.spec.alpha.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","tuple","cljs.spec.alpha/tuple",-415901908,null),new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790)),cljs.spec.alpha.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790)], null)),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73395){
return cljs.core.map_QMARK_.call(null,G__73395);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.map_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","kfn","cljs.spec.alpha/kfn",672643897),(function (i__13227__auto__,v__13228__auto__){
return cljs.core.nth.call(null,v__13228__auto__,(0));
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","map-of","cljs.spec.alpha/map-of",153715093,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugin","fulcro.incubator.ui-state-machines/plugin",624948790))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-names","fulcro.incubator.ui-state-machines/event-names",-379800553),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),cljs.core.keyword_QMARK_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null),new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__73397){
return cljs.core.set_QMARK_.call(null,G__73397);
}),new cljs.core.Keyword(null,"kind","kind",-717265803),cljs.core.set_QMARK_,new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Symbol("cljs.core","set?","cljs.core/set?",-1176684971,null))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-names","fulcro.incubator.ui-state-machines/event-names",-379800553)], null)),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"a","a",-2123407586),"null"], null), null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"env","env",-175281708,null)], null),new cljs.core.Symbol(null,"env","env",-175281708,null))], null)], null)], null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__73408){
return cljs.core.map_QMARK_.call(null,G__73408);
}),(function (G__73408){
return cljs.core.contains_QMARK_.call(null,G__73408,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571));
}),(function (G__73408){
return cljs.core.contains_QMARK_.call(null,G__73408,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683));
})], null),(function (G__73408){
return ((cljs.core.map_QMARK_.call(null,G__73408)) && (cljs.core.contains_QMARK_.call(null,G__73408,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571))) && (cljs.core.contains_QMARK_.call(null,G__73408,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683))));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-names","fulcro.incubator.ui-state-machines/event-names",-379800553)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-names","fulcro.incubator.ui-state-machines/event-names",-379800553)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-names","fulcro.incubator.ui-state-machines/event-names",-379800553)], null)])),(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),(function (env){
return env;
})], null)], null)], null)]));
})));
fulcro.incubator.ui_state_machines.registry = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fulcro.incubator.ui_state_machines.register_state_machine_BANG_ = (function fulcro$incubator$ui_state_machines$register_state_machine_BANG_(id,definition){
return cljs.core.swap_BANG_.call(null,fulcro.incubator.ui_state_machines.registry,cljs.core.assoc,id,definition);
});
fulcro.incubator.ui_state_machines.get_state_machine = (function fulcro$incubator$ui_state_machines$get_state_machine(id){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),null)], null);

return cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.incubator.ui_state_machines.registry),id);
});
fulcro.incubator.ui_state_machines.lookup_state_machine = (function fulcro$incubator$ui_state_machines$lookup_state_machine(env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),null)], null);

var G__73425 = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002)], null));
if((G__73425 == null)){
return null;
} else {
return cljs.core.get.call(null,cljs.core.deref.call(null,fulcro.incubator.ui_state_machines.registry),G__73425);
}
});
fulcro.incubator.ui_state_machines.lookup_state_machine_field = (function fulcro$incubator$ui_state_machines$lookup_state_machine_field(env,ks){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393),new cljs.core.Keyword(null,"kpath","kpath",-89376795)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.vector_QMARK_], null),null),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

if(cljs.core.vector_QMARK_.call(null,ks)){
return cljs.core.get_in.call(null,fulcro.incubator.ui_state_machines.lookup_state_machine.call(null,env),ks);
} else {
return cljs.core.get.call(null,fulcro.incubator.ui_state_machines.lookup_state_machine.call(null,env),ks);
}
});
fulcro.incubator.ui_state_machines.trigger_state_machine_event = fulcro.incubator.mutation_interface.__GT_Mutation.call(null,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","trigger-state-machine-event","fulcro.incubator.ui-state-machines/trigger-state-machine-event",593149133,null),cljs.core.map_QMARK_);
/**
 * Trigger an event on an active state machine. Safe to use in mutation bodies.
 */
fulcro.incubator.ui_state_machines.trigger_BANG_ = (function fulcro$incubator$ui_state_machines$trigger_BANG_(var_args){
var G__73437 = arguments.length;
switch (G__73437) {
case 3:
return fulcro.incubator.ui_state_machines.trigger_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.incubator.ui_state_machines.trigger_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.trigger_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,active_state_machine_id,event_id){
return fulcro.incubator.ui_state_machines.trigger_BANG_.call(null,this$,active_state_machine_id,event_id,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.incubator.ui_state_machines.trigger_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (this$,active_state_machine_id,event_id,extra_data){
return fulcro.incubator.ui_state_machines.defer.call(null,(function (){
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.ui_state_machines.trigger_state_machine_event.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),active_state_machine_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),event_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),extra_data], null))], null));
}));
});

fulcro.incubator.ui_state_machines.trigger_BANG_.cljs$lang$maxFixedArity = 4;

/**
 * Create the runtime state for the given state machine in it's initial state.
 * 
 *   - `::state-machine-id` is the globally unique key of for a state machine definition.
 *   - `::asm-id` is a user-generated unique ID for the instance of the asm. This allows more than one
 *  instance of the same state machine definition to be active at the same time on the UI.
 *   - `::actor->ident` is a map from actor name to an ident.
 * 
 *   Returns an active state machine that can be stored in Fulcro state for a specific
 *   state machine definition.
 */
fulcro.incubator.ui_state_machines.new_asm = (function fulcro$incubator$ui_state_machines$new_asm(p__73441){
var map__73442 = p__73441;
var map__73442__$1 = (((((!((map__73442 == null))))?(((((map__73442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73442.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73442):map__73442);
var state_machine_id = cljs.core.get.call(null,map__73442__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002));
var asm_id = cljs.core.get.call(null,map__73442__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var actor__GT_ident = cljs.core.get.call(null,map__73442__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379));
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [((function (map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident){
return (function (G__73444){
return cljs.core.map_QMARK_.call(null,G__73444);
});})(map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident))
,((function (map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident){
return (function (G__73444){
return cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002));
});})(map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident))
,((function (map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident){
return (function (G__73444){
return cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
});})(map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident))
,((function (map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident){
return (function (G__73444){
return cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379));
});})(map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident))
], null),((function (map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident){
return (function (G__73444){
return ((cljs.core.map_QMARK_.call(null,G__73444)) && (cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002))) && (cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187))) && (cljs.core.contains_QMARK_.call(null,G__73444,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379))));
});})(map__73442,map__73442__$1,state_machine_id,asm_id,actor__GT_ident))
,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379)], null),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379)))], null),null])),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm","fulcro.incubator.ui-state-machines/asm",2115037986)], null);

var i__GT_a = clojure.set.map_invert.call(null,actor__GT_ident);
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),state_machine_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016),new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ident->actor","fulcro.incubator.ui-state-machines/ident->actor",-14423807),i__GT_a,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),actor__GT_ident,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083),cljs.core.PersistentArrayMap.EMPTY], null);
});
/**
 * Returns the path to an asm elements in an asm `env`.
 */
fulcro.incubator.ui_state_machines.asm_path = (function fulcro$incubator$ui_state_machines$asm_path(p__73487,ks){
var map__73489 = p__73487;
var map__73489__$1 = (((((!((map__73489 == null))))?(((((map__73489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73489.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73489):map__73489);
var env = map__73489__$1;
var state_map = cljs.core.get.call(null,map__73489__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111));
var asm_id = cljs.core.get.call(null,map__73489__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059),new cljs.core.Keyword(null,"k","k",-2146297393)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.core.keyword_QMARK_], null),null),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.vector_QMARK_], null);

var path = ((cljs.core.vector_QMARK_.call(null,ks))?cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id], null),ks):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,ks], null));
if(cljs.core.not(cljs.core.get_in.call(null,state_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id], null)))){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),169], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Attempt to get an ASM path",ks,"for a state machine that is not in Fulcro state. ASM ID: ",asm_id);
}catch (e73498){if((e73498 instanceof Error)){
var e__54502__auto___74321 = e73498;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),169], null),new cljs.core.Keyword(null,"warn","warn",-436710552),"Log statement failed (arguments did not evaluate).",e__54502__auto___74321);
} else {
throw e73498;

}
}} else {
}

return path;
});
/**
 * Get the value of an ASM based on keyword OR key-path `ks`.
 */
fulcro.incubator.ui_state_machines.asm_value = (function fulcro$incubator$ui_state_machines$asm_value(env,ks){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059),new cljs.core.Keyword(null,"k","k",-2146297393)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,cljs.core.keyword_QMARK_], null),null),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return cljs.core.get_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,ks));
});
fulcro.incubator.ui_state_machines.valid_state_QMARK_ = (function fulcro$incubator$ui_state_machines$valid_state_QMARK_(env,state_id){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.boolean_QMARK_], null);

var states = clojure.set.union.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","started","fulcro.incubator.ui-state-machines/started",-1147945147),null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","exit","fulcro.incubator.ui-state-machines/exit",992916909),null], null), null),cljs.core.set.call(null,cljs.core.keys.call(null,fulcro.incubator.ui_state_machines.lookup_state_machine_field.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683)))));
return cljs.core.contains_QMARK_.call(null,states,state_id);
});
/**
 * Move to the given state. Returns a new env.
 */
fulcro.incubator.ui_state_machines.activate = (function fulcro$incubator$ui_state_machines$activate(env,state_id){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-id","fulcro.incubator.ui-state-machines/state-id",1698927809),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

if(fulcro.incubator.ui_state_machines.valid_state_QMARK_.call(null,env,state_id)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),189], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Activating ",state_id);
}catch (e73505){if((e73505 instanceof Error)){
var e__54502__auto___74327 = e73505;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),189], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74327);
} else {
throw e73505;

}
}
return cljs.core.assoc_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016)),state_id);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),192], null),new cljs.core.Keyword(null,"error","error",-978969032),"Activate called for invalid state: ",state_id);
}catch (e73506){if((e73506 instanceof Error)){
var e__54502__auto___74333 = e73506;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),192], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74333);
} else {
throw e73506;

}
}
return env;
}
});
/**
 * Store a k/v pair with the active state machine (will only exist as long as it is active)
 */
fulcro.incubator.ui_state_machines.store = (function fulcro$incubator$ui_state_machines$store(env,k,v){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return cljs.core.update_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083)),cljs.core.assoc,k,v);
});
/**
 * Retrieve the value for a k from the active state machine. See `store`.
 */
fulcro.incubator.ui_state_machines.retrieve = (function fulcro$incubator$ui_state_machines$retrieve(var_args){
var G__73511 = arguments.length;
switch (G__73511) {
case 2:
return fulcro.incubator.ui_state_machines.retrieve.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.incubator.ui_state_machines.retrieve.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.retrieve.cljs$core$IFn$_invoke$arity$2 = (function (env,k){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return fulcro.incubator.ui_state_machines.retrieve.call(null,env,k,null);
});

fulcro.incubator.ui_state_machines.retrieve.cljs$core$IFn$_invoke$arity$3 = (function (env,k,dflt){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return cljs.core.get_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","local-storage","fulcro.incubator.ui-state-machines/local-storage",1079584083),k], null)),dflt);
});

fulcro.incubator.ui_state_machines.retrieve.cljs$lang$maxFixedArity = 3;

fulcro.incubator.ui_state_machines.actor__GT_ident = (function fulcro$incubator$ui_state_machines$actor__GT_ident(env,actor_name){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),null)], null);

var temp__5720__auto__ = cljs.core.get_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379)));
if(cljs.core.truth_(temp__5720__auto__)){
var lookup = temp__5720__auto__;
return lookup.call(null,actor_name);
} else {
return null;
}
});
/**
 * Looks up the given alias in the alias map and returns the real Fulcro state path or nil if no such path exists.
 */
fulcro.incubator.ui_state_machines.resolve_alias = (function fulcro$incubator$ui_state_machines$resolve_alias(env,alias){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var temp__5720__auto__ = fulcro.incubator.ui_state_machines.lookup_state_machine_field.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113),alias], null));
if(cljs.core.truth_(temp__5720__auto__)){
var resolution_path = temp__5720__auto__;
var vec__73529 = resolution_path;
var seq__73530 = cljs.core.seq.call(null,vec__73529);
var first__73531 = cljs.core.first.call(null,seq__73530);
var seq__73530__$1 = cljs.core.next.call(null,seq__73530);
var actor = first__73531;
var subpath = seq__73530__$1;
var base_path = fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,actor);
var real_path = cljs.core.into.call(null,base_path,subpath);
return real_path;
} else {
return null;
}
});
/**
 * Get the real Fulcro state-path for the entity of the given actor.
 */
fulcro.incubator.ui_state_machines.actor_path = (function fulcro$incubator$ui_state_machines$actor_path(var_args){
var G__73540 = arguments.length;
switch (G__73540) {
case 2:
return fulcro.incubator.ui_state_machines.actor_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.incubator.ui_state_machines.actor_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.actor_path.cljs$core$IFn$_invoke$arity$2 = (function (env,actor_name){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_,null)], null);

return fulcro.incubator.ui_state_machines.actor_path.call(null,env,actor_name,null);
});

fulcro.incubator.ui_state_machines.actor_path.cljs$core$IFn$_invoke$arity$3 = (function (env,actor_name,k){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_,null)], null);

var temp__5718__auto__ = fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,actor_name);
if(cljs.core.truth_(temp__5718__auto__)){
var ident = temp__5718__auto__;
var G__73543 = ident;
if(cljs.core.truth_(k)){
return cljs.core.conj.call(null,G__73543,k);
} else {
return G__73543;
}
} else {
return null;
}
});

fulcro.incubator.ui_state_machines.actor_path.cljs$lang$maxFixedArity = 3;

/**
 * Set a value in the actor's Fulcro entity. Only the actor is resolved. The k is not processed as an alias. 
 */
fulcro.incubator.ui_state_machines.set_actor_value = (function fulcro$incubator$ui_state_machines$set_actor_value(env,actor_name,k,v){
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.core.any_QMARK_,cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var temp__5718__auto__ = fulcro.incubator.ui_state_machines.actor_path.call(null,env,actor_name,k);
if(cljs.core.truth_(temp__5718__auto__)){
var path = temp__5718__auto__;
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),cljs.core.assoc_in,path,v);
} else {
return env;
}
});
/**
 * Get the value of a particular key in the given actor's entity. If follow-idents? is true (which is the default),
 *   then it will recursively follow idents until it finds a non-ident value.
 */
fulcro.incubator.ui_state_machines.actor_value = (function fulcro$incubator$ui_state_machines$actor_value(var_args){
var G__73550 = arguments.length;
switch (G__73550) {
case 4:
return fulcro.incubator.ui_state_machines.actor_value.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return fulcro.incubator.ui_state_machines.actor_value.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.actor_value.cljs$core$IFn$_invoke$arity$4 = (function (p__73552,actor_name,k,follow_idents_QMARK_){
var map__73553 = p__73552;
var map__73553__$1 = (((((!((map__73553 == null))))?(((((map__73553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73553):map__73553);
var env = map__73553__$1;
var state_map = cljs.core.get.call(null,map__73553__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111));
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.core.any_QMARK_,cljs.core.boolean_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var temp__5720__auto__ = fulcro.incubator.ui_state_machines.actor_path.call(null,env,actor_name,k);
if(cljs.core.truth_(temp__5720__auto__)){
var path = temp__5720__auto__;
var v = cljs.core.get_in.call(null,state_map,path);
var depth = (100);
while(true){
if(cljs.core.truth_((function (){var and__4120__auto__ = follow_idents_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return ((fulcro.util.ident_QMARK_.call(null,v)) && (cljs.core.pos_int_QMARK_.call(null,depth)));
} else {
return and__4120__auto__;
}
})())){
var G__74373 = cljs.core.get_in.call(null,state_map,v);
var G__74374 = (depth - (1));
v = G__74373;
depth = G__74374;
continue;
} else {
return v;
}
break;
}
} else {
return null;
}
});

fulcro.incubator.ui_state_machines.actor_value.cljs$core$IFn$_invoke$arity$3 = (function (env,actor_name,k){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return fulcro.incubator.ui_state_machines.actor_value.call(null,env,actor_name,k,true);
});

fulcro.incubator.ui_state_machines.actor_value.cljs$lang$maxFixedArity = 4;

/**
 * Get a Fulcro state value by state machine data alias.
 */
fulcro.incubator.ui_state_machines.alias_value = (function fulcro$incubator$ui_state_machines$alias_value(p__73561,alias){
var map__73562 = p__73561;
var map__73562__$1 = (((((!((map__73562 == null))))?(((((map__73562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73562):map__73562);
var env = map__73562__$1;
var state_map = cljs.core.get.call(null,map__73562__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111));
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var temp__5718__auto__ = fulcro.incubator.ui_state_machines.resolve_alias.call(null,env,alias);
if(cljs.core.truth_(temp__5718__auto__)){
var real_path = temp__5718__auto__;
return cljs.core.get_in.call(null,state_map,real_path);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),267], null),new cljs.core.Keyword(null,"error","error",-978969032),"Unable to find alias in state machine:",alias);
}catch (e73569){if((e73569 instanceof Error)){
var e__54502__auto___74381 = e73569;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),267], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74381);
} else {
throw e73569;

}
}
return null;
}
});
fulcro.incubator.ui_state_machines.set_aliased_value = (function fulcro$incubator$ui_state_machines$set_aliased_value(var_args){
var G__73596 = arguments.length;
switch (G__73596) {
case 3:
return fulcro.incubator.ui_state_machines.set_aliased_value.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___74387 = arguments.length;
var i__4731__auto___74388 = (0);
while(true){
if((i__4731__auto___74388 < len__4730__auto___74387)){
args_arr__4751__auto__.push((arguments[i__4731__auto___74388]));

var G__74390 = (i__4731__auto___74388 + (1));
i__4731__auto___74388 = G__74390;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return fulcro.incubator.ui_state_machines.set_aliased_value.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

fulcro.incubator.ui_state_machines.set_aliased_value.cljs$core$IFn$_invoke$arity$variadic = (function (env,alias,new_value,alias_2,value_2,kv_pairs){
new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.any_QMARK_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.any_QMARK_,cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var kvs = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,new_value], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias_2,value_2], null)], null),cljs.core.partition.call(null,(2),kv_pairs));
return cljs.core.reduce.call(null,((function (kvs){
return (function (e,p__73604){
var vec__73605 = p__73604;
var k = cljs.core.nth.call(null,vec__73605,(0),null);
var v = cljs.core.nth.call(null,vec__73605,(1),null);
return fulcro.incubator.ui_state_machines.set_aliased_value.call(null,e,k,v);
});})(kvs))
,env,kvs);
});

/** @this {Function} */
fulcro.incubator.ui_state_machines.set_aliased_value.cljs$lang$applyTo = (function (seq73590){
var G__73591 = cljs.core.first.call(null,seq73590);
var seq73590__$1 = cljs.core.next.call(null,seq73590);
var G__73592 = cljs.core.first.call(null,seq73590__$1);
var seq73590__$2 = cljs.core.next.call(null,seq73590__$1);
var G__73593 = cljs.core.first.call(null,seq73590__$2);
var seq73590__$3 = cljs.core.next.call(null,seq73590__$2);
var G__73594 = cljs.core.first.call(null,seq73590__$3);
var seq73590__$4 = cljs.core.next.call(null,seq73590__$3);
var G__73595 = cljs.core.first.call(null,seq73590__$4);
var seq73590__$5 = cljs.core.next.call(null,seq73590__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73591,G__73592,G__73593,G__73594,G__73595,seq73590__$5);
});

fulcro.incubator.ui_state_machines.set_aliased_value.cljs$core$IFn$_invoke$arity$3 = (function (env,alias,new_value){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),cljs.core.any_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var temp__5718__auto__ = fulcro.incubator.ui_state_machines.resolve_alias.call(null,env,alias);
if(cljs.core.truth_(temp__5718__auto__)){
var real_path = temp__5718__auto__;
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),cljs.core.assoc_in,real_path,new_value);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),284], null),new cljs.core.Keyword(null,"error","error",-978969032),"Attempt to set a value on an invalid alias:",alias);
}catch (e73616){if((e73616 instanceof Error)){
var e__54502__auto___74410 = e73616;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),284], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74410);
} else {
throw e73616;

}
}
return env;
}
});

fulcro.incubator.ui_state_machines.set_aliased_value.cljs$lang$maxFixedArity = (5);

/**
 * Extracts aliased data from Fulcro state to construct arguments. If explicit-args is supplied,
 * then that is merged with aliased data, passed to the named plugin.  The return of the plugin is
 * the result of this function
 */
fulcro.incubator.ui_state_machines.aliased_data = (function fulcro$incubator$ui_state_machines$aliased_data(env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.map_QMARK_], null);

var alias_keys = (function (){var G__73622 = fulcro.incubator.ui_state_machines.lookup_state_machine_field.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","aliases","fulcro.incubator.ui-state-machines/aliases",-160031113));
if((G__73622 == null)){
return null;
} else {
return cljs.core.keys.call(null,G__73622);
}
})();
return cljs.core.reduce.call(null,((function (alias_keys){
return (function (result,k){
return cljs.core.assoc.call(null,result,k,fulcro.incubator.ui_state_machines.alias_value.call(null,env,k));
});})(alias_keys))
,cljs.core.PersistentArrayMap.EMPTY,alias_keys);
});
/**
 * Run a state-machine plugin. Extracts aliased data from Fulcro state to construct arguments. If explicit-args is supplied,
 * then that is merged with aliased data, passed to the named plugin.  The return of the plugin is
 * the result of this function. Plugins cannot side-effect, and are meant for providing external computation algorithms
 * that the state machine logic might need. For example, an actor representing a form might need to provide validation
 * logic.
 * 
 * If explicit-args are passed, then they will take *precedence* over the auto-extracted aliased data that is passed to
 * the plugin.
 */
fulcro.incubator.ui_state_machines.run = (function fulcro$incubator$ui_state_machines$run(var_args){
var G__73633 = arguments.length;
switch (G__73633) {
case 2:
return fulcro.incubator.ui_state_machines.run.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.incubator.ui_state_machines.run.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.run.cljs$core$IFn$_invoke$arity$2 = (function (env,plugin_name){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return fulcro.incubator.ui_state_machines.run.call(null,env,plugin_name,null);
});

fulcro.incubator.ui_state_machines.run.cljs$core$IFn$_invoke$arity$3 = (function (env,plugin_name,explicit_args){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var temp__5720__auto__ = fulcro.incubator.ui_state_machines.lookup_state_machine_field.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","plugins","fulcro.incubator.ui-state-machines/plugins",391064574),plugin_name], null));
if(cljs.core.truth_(temp__5720__auto__)){
var plugin = temp__5720__auto__;
var params = cljs.core.merge.call(null,fulcro.incubator.ui_state_machines.aliased_data.call(null,env),explicit_args);
return plugin.call(null,params);
} else {
return null;
}
});

fulcro.incubator.ui_state_machines.run.cljs$lang$maxFixedArity = 3;

/**
 * Indicate that the state machine is done.
 */
fulcro.incubator.ui_state_machines.exit = (function fulcro$incubator$ui_state_machines$exit(env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return fulcro.incubator.ui_state_machines.activate.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","exit","fulcro.incubator.ui-state-machines/exit",992916909));
});
fulcro.incubator.ui_state_machines.apply_event_value = (function fulcro$incubator$ui_state_machines$apply_event_value(env,p__73646){
var map__73647 = p__73646;
var map__73647__$1 = (((((!((map__73647 == null))))?(((((map__73647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73647):map__73647);
var event_id = cljs.core.get.call(null,map__73647__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
var event_data = cljs.core.get.call(null,map__73647__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294));
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((function (map__73647,map__73647__$1,event_id,event_data){
return (function (G__73652){
return cljs.core.map_QMARK_.call(null,G__73652);
});})(map__73647,map__73647__$1,event_id,event_data))
], null),((function (map__73647,map__73647__$1,event_id,event_data){
return (function (G__73652){
return cljs.core.map_QMARK_.call(null,G__73652);
});})(map__73647,map__73647__$1,event_id,event_data))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294)], null)])),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var alias = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839).cljs$core$IFn$_invoke$arity$1(event_data);
var value = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(event_data);
var G__73665 = env;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","value-changed","fulcro.incubator.ui-state-machines/value-changed",-144746786),event_id);
if(and__4120__auto__){
return alias;
} else {
return and__4120__auto__;
}
})())){
return fulcro.incubator.ui_state_machines.set_aliased_value.call(null,G__73665,alias,value);
} else {
return G__73665;
}
});
fulcro.incubator.ui_state_machines.state_machine_env = (function fulcro$incubator$ui_state_machines$state_machine_env(state_map,ref,asm_id,event_id,event_data){
new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),null),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),null),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var G__73673 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),state_map,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id], null);
var G__73673__$1 = (cljs.core.truth_(event_id)?cljs.core.assoc.call(null,G__73673,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),event_id):G__73673);
var G__73673__$2 = ((cljs.core.seq.call(null,event_data))?cljs.core.assoc.call(null,G__73673__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),event_data):G__73673__$1);
if(cljs.core.truth_(ref)){
return cljs.core.assoc.call(null,G__73673__$2,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","source-actor-ident","fulcro.incubator.ui-state-machines/source-actor-ident",2010438532),ref);
} else {
return G__73673__$2;
}
});
/**
 * Associate a given component UI Fulcro class with an ident.  This is used with `begin!` in your actor map if the
 *   actor in question is going to be used with loads or mutations that return a value of that type. The actor's class
 *   can be retrieved for use in a handler using `(uism/actor-class env)`.
 * 
 *   ```
 *   (begin! ... {:person (uism/with-actor-class [:person/by-id 1] Person)})
 *   ```
 *   
 */
fulcro.incubator.ui_state_machines.with_actor_class = (function fulcro$incubator$ui_state_machines$with_actor_class(ident,class$){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-ident","fulcro.incubator.ui-state-machines/fulcro-ident",333762529)], null);

return cljs.core.vary_meta.call(null,ident,cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","class","fulcro.incubator.ui-state-machines/class",281830299),class$);
});
fulcro.incubator.ui_state_machines.actor_class = (function fulcro$incubator$ui_state_machines$actor_class(env,actor_name){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),null)], null);

var actor__GT_ident = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379));
var cls = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","class","fulcro.incubator.ui-state-machines/class",281830299).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,actor__GT_ident.call(null,actor_name)));
return cls;
});
fulcro.incubator.ui_state_machines.queue_mutations_BANG_ = (function fulcro$incubator$ui_state_machines$queue_mutations_BANG_(reconciler,env){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.nil_QMARK_], null);

var queued_mutations = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227).cljs$core$IFn$_invoke$arity$1(env);
var seq__73699_74431 = cljs.core.seq.call(null,queued_mutations);
var chunk__73700_74432 = null;
var count__73701_74433 = (0);
var i__73702_74434 = (0);
while(true){
if((i__73702_74434 < count__73701_74433)){
var map__73730_74435 = cljs.core._nth(chunk__73700_74432,i__73702_74434);
var map__73730_74436__$1 = (((((!((map__73730_74435 == null))))?(((((map__73730_74435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73730_74435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73730_74435):map__73730_74435);
var mutation_params_74437 = map__73730_74436__$1;
var mutation_context_74438 = cljs.core.get.call(null,map__73730_74436__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170));
var contextual_component_74442 = fulcro.client.primitives.ref__GT_any.call(null,reconciler,fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,mutation_context_74438));
if((contextual_component_74442 == null)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),366], null),new cljs.core.Keyword(null,"error","error",-978969032),"Cannot run mutation. No contextual component mounted for ",mutation_context_74438);
}catch (e73737){if((e73737 instanceof Error)){
var e__54502__auto___74444 = e73737;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),366], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74444);
} else {
throw e73737;

}
}} else {
fulcro.incubator.pessimistic_mutations.pmutate_BANG_.call(null,contextual_component_74442,fulcro.incubator.ui_state_machines.mutation_delegate,mutation_params_74437);
}


var G__74449 = seq__73699_74431;
var G__74450 = chunk__73700_74432;
var G__74451 = count__73701_74433;
var G__74452 = (i__73702_74434 + (1));
seq__73699_74431 = G__74449;
chunk__73700_74432 = G__74450;
count__73701_74433 = G__74451;
i__73702_74434 = G__74452;
continue;
} else {
var temp__5720__auto___74454 = cljs.core.seq.call(null,seq__73699_74431);
if(temp__5720__auto___74454){
var seq__73699_74457__$1 = temp__5720__auto___74454;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73699_74457__$1)){
var c__4550__auto___74458 = cljs.core.chunk_first.call(null,seq__73699_74457__$1);
var G__74459 = cljs.core.chunk_rest.call(null,seq__73699_74457__$1);
var G__74460 = c__4550__auto___74458;
var G__74461 = cljs.core.count.call(null,c__4550__auto___74458);
var G__74462 = (0);
seq__73699_74431 = G__74459;
chunk__73700_74432 = G__74460;
count__73701_74433 = G__74461;
i__73702_74434 = G__74462;
continue;
} else {
var map__73741_74463 = cljs.core.first.call(null,seq__73699_74457__$1);
var map__73741_74464__$1 = (((((!((map__73741_74463 == null))))?(((((map__73741_74463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73741_74463.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73741_74463):map__73741_74463);
var mutation_params_74465 = map__73741_74464__$1;
var mutation_context_74466 = cljs.core.get.call(null,map__73741_74464__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170));
var contextual_component_74467 = fulcro.client.primitives.ref__GT_any.call(null,reconciler,fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,mutation_context_74466));
if((contextual_component_74467 == null)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),366], null),new cljs.core.Keyword(null,"error","error",-978969032),"Cannot run mutation. No contextual component mounted for ",mutation_context_74466);
}catch (e73747){if((e73747 instanceof Error)){
var e__54502__auto___74468 = e73747;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),366], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74468);
} else {
throw e73747;

}
}} else {
fulcro.incubator.pessimistic_mutations.pmutate_BANG_.call(null,contextual_component_74467,fulcro.incubator.ui_state_machines.mutation_delegate,mutation_params_74465);
}


var G__74473 = cljs.core.next.call(null,seq__73699_74457__$1);
var G__74474 = null;
var G__74475 = (0);
var G__74476 = (0);
seq__73699_74431 = G__74473;
chunk__73700_74432 = G__74474;
count__73701_74433 = G__74475;
i__73702_74434 = G__74476;
continue;
}
} else {
}
}
break;
}

return null;
});
/**
 * Internal implementation. Queue a load of an actor.
 */
fulcro.incubator.ui_state_machines.queue_actor_load_BANG_ = (function fulcro$incubator$ui_state_machines$queue_actor_load_BANG_(reconciler,env,actor_name,component_class,load_options){
new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.nil_QMARK_], null);

var actor_ident = fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,actor_name);
var cls = (function (){var or__4131__auto__ = component_class;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = fulcro.incubator.ui_state_machines.actor_class.call(null,env,actor_name);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return fulcro.client.primitives.react_type.call(null,fulcro.client.primitives.ref__GT_any.call(null,reconciler,actor_ident));
}
}
})();
if((cls == null)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),377], null),new cljs.core.Keyword(null,"error","error",-978969032),"Cannot run load. Counld not derive Fulcro class (and none was configured) for ",actor_name);
}catch (e73757){if((e73757 instanceof Error)){
var e__54502__auto___74485 = e73757;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),377], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74485);
} else {
throw e73757;

}
}} else {
fulcro.incubator.ui_state_machines.defer.call(null,((function (actor_ident,cls){
return (function (){
return fulcro.client.data_fetch.load.call(null,reconciler,actor_ident,cls,load_options);
});})(actor_ident,cls))
);
}

return null;
});
/**
 * Internal implementation. Queue a load.
 */
fulcro.incubator.ui_state_machines.queue_normal_load_BANG_ = (function fulcro$incubator$ui_state_machines$queue_normal_load_BANG_(reconciler,query_key,component_class,load_options){
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_,null),cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.nil_QMARK_], null);

if((((query_key == null)) && ((component_class == null)))){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),386], null),new cljs.core.Keyword(null,"error","error",-978969032),"Cannot run load. Either query-key or component-class is required.");
}catch (e73762){if((e73762 instanceof Error)){
var e__54502__auto___74486 = e73762;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),386], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74486);
} else {
throw e73762;

}
}} else {
fulcro.incubator.ui_state_machines.defer.call(null,(function (){
return fulcro.client.data_fetch.load.call(null,reconciler,query_key,component_class,load_options);
}));
}

return null;
});
fulcro.incubator.ui_state_machines.handle_load_error_STAR_ = (function fulcro$incubator$ui_state_machines$handle_load_error_STAR_(reconciler,load_request){
var map__73768 = (function (){var G__73769 = load_request;
if((G__73769 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897).cljs$core$IFn$_invoke$arity$1(G__73769);
}
})();
var map__73768__$1 = (((((!((map__73768 == null))))?(((((map__73768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73768.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73768):map__73768);
var asm_id = cljs.core.get.call(null,map__73768__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var error_event = cljs.core.get.call(null,map__73768__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603));
var error_data = cljs.core.get.call(null,map__73768__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787));
if(cljs.core.truth_((function (){var and__4120__auto__ = asm_id;
if(cljs.core.truth_(and__4120__auto__)){
return error_event;
} else {
return and__4120__auto__;
}
})())){
return fulcro.incubator.ui_state_machines.defer.call(null,((function (map__73768,map__73768__$1,asm_id,error_event,error_data){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.ui_state_machines.trigger_state_machine_event.call(null,(function (){var G__73771 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),error_event], null);
if(cljs.core.truth_(error_data)){
return cljs.core.assoc.call(null,G__73771,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),error_data);
} else {
return G__73771;
}
})())], null));
});})(map__73768,map__73768__$1,asm_id,error_event,error_data))
);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),398], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"A fallback occurred, but no event was defined by the client. Sending generic event.");
}catch (e73775){if((e73775 instanceof Error)){
var e__54502__auto___74491 = e73775;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),398], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74491);
} else {
throw e73775;

}
}
return fulcro.incubator.ui_state_machines.defer.call(null,((function (map__73768,map__73768__$1,asm_id,error_event,error_data){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.ui_state_machines.trigger_state_machine_event.call(null,(function (){var G__73779 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-error","fulcro.incubator.ui-state-machines/load-error",1199461746)], null);
return G__73779;
})())], null));
});})(map__73768,map__73768__$1,asm_id,error_event,error_data))
);
}
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","handle-load-error","fulcro.incubator.ui-state-machines/handle-load-error",54393509,null),(function (fulcro_incoming_env,_,___$1){
return cljs.core.merge.call(null,(function (){var map__73780 = fulcro_incoming_env;
var map__73780__$1 = (((((!((map__73780 == null))))?(((((map__73780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73780.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73780):map__73780);
var reconciler = cljs.core.get.call(null,map__73780__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var load_request = cljs.core.get.call(null,map__73780__$1,new cljs.core.Keyword(null,"load-request","load-request",693664659));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__73780,map__73780__$1,reconciler,load_request){
return (function (){
return fulcro.incubator.ui_state_machines.handle_load_error_STAR_.call(null,reconciler,load_request);
});})(map__73780,map__73780__$1,reconciler,load_request))
], null);
})());
}));
fulcro.incubator.ui_state_machines.queue_loads_BANG_ = (function fulcro$incubator$ui_state_machines$queue_loads_BANG_(reconciler,env){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.nil_QMARK_], null);

var queued_loads_74506 = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060).cljs$core$IFn$_invoke$arity$1(env);
var seq__73788_74507 = cljs.core.seq.call(null,queued_loads_74506);
var chunk__73789_74508 = null;
var count__73790_74509 = (0);
var i__73791_74510 = (0);
while(true){
if((i__73791_74510 < count__73790_74509)){
var map__73806_74512 = cljs.core._nth(chunk__73789_74508,i__73791_74510);
var map__73806_74513__$1 = (((((!((map__73806_74512 == null))))?(((((map__73806_74512.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73806_74512.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73806_74512):map__73806_74512);
var load_params_74514 = map__73806_74513__$1;
var component_class_74515 = cljs.core.get.call(null,map__73806_74513__$1,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212));
var actor_name_74516 = cljs.core.get.call(null,map__73806_74513__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357));
var query_key_74517 = cljs.core.get.call(null,map__73806_74513__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946));
var load_options_74518 = cljs.core.get.call(null,map__73806_74513__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800));
if(cljs.core.truth_(actor_name_74516)){
fulcro.incubator.ui_state_machines.queue_actor_load_BANG_.call(null,reconciler,env,actor_name_74516,component_class_74515,load_options_74518);
} else {
fulcro.incubator.ui_state_machines.queue_normal_load_BANG_.call(null,reconciler,query_key_74517,component_class_74515,load_options_74518);
}


var G__74525 = seq__73788_74507;
var G__74526 = chunk__73789_74508;
var G__74527 = count__73790_74509;
var G__74528 = (i__73791_74510 + (1));
seq__73788_74507 = G__74525;
chunk__73789_74508 = G__74526;
count__73790_74509 = G__74527;
i__73791_74510 = G__74528;
continue;
} else {
var temp__5720__auto___74529 = cljs.core.seq.call(null,seq__73788_74507);
if(temp__5720__auto___74529){
var seq__73788_74530__$1 = temp__5720__auto___74529;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73788_74530__$1)){
var c__4550__auto___74531 = cljs.core.chunk_first.call(null,seq__73788_74530__$1);
var G__74532 = cljs.core.chunk_rest.call(null,seq__73788_74530__$1);
var G__74533 = c__4550__auto___74531;
var G__74534 = cljs.core.count.call(null,c__4550__auto___74531);
var G__74535 = (0);
seq__73788_74507 = G__74532;
chunk__73789_74508 = G__74533;
count__73790_74509 = G__74534;
i__73791_74510 = G__74535;
continue;
} else {
var map__73808_74538 = cljs.core.first.call(null,seq__73788_74530__$1);
var map__73808_74539__$1 = (((((!((map__73808_74538 == null))))?(((((map__73808_74538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73808_74538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73808_74538):map__73808_74538);
var load_params_74540 = map__73808_74539__$1;
var component_class_74541 = cljs.core.get.call(null,map__73808_74539__$1,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212));
var actor_name_74542 = cljs.core.get.call(null,map__73808_74539__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357));
var query_key_74543 = cljs.core.get.call(null,map__73808_74539__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946));
var load_options_74544 = cljs.core.get.call(null,map__73808_74539__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800));
if(cljs.core.truth_(actor_name_74542)){
fulcro.incubator.ui_state_machines.queue_actor_load_BANG_.call(null,reconciler,env,actor_name_74542,component_class_74541,load_options_74544);
} else {
fulcro.incubator.ui_state_machines.queue_normal_load_BANG_.call(null,reconciler,query_key_74543,component_class_74541,load_options_74544);
}


var G__74562 = cljs.core.next.call(null,seq__73788_74530__$1);
var G__74563 = null;
var G__74564 = (0);
var G__74565 = (0);
seq__73788_74507 = G__74562;
chunk__73789_74508 = G__74563;
count__73790_74509 = G__74564;
i__73791_74510 = G__74565;
continue;
}
} else {
}
}
break;
}

return null;
});
/**
 * Put the evolved state-map from an env into a (Fulcro) state-atom
 */
fulcro.incubator.ui_state_machines.update_fulcro_state_BANG_ = (function fulcro$incubator$ui_state_machines$update_fulcro_state_BANG_(p__73817,state_atom){
var map__73819 = p__73817;
var map__73819__$1 = (((((!((map__73819 == null))))?(((((map__73819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73819):map__73819);
var env = map__73819__$1;
var asm_id = cljs.core.get.call(null,map__73819__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","atom","fulcro.incubator.ui-state-machines/atom",-2144865964),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.nil_QMARK_], null);

var next_state_74574 = (cljs.core.truth_(env)?fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016)):null);
var temp__5720__auto___74575 = (function (){var G__73825 = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111).cljs$core$IFn$_invoke$arity$1(env);
if((G__73825 == null)){
return null;
} else {
var G__73826 = G__73825;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","exit","fulcro.incubator.ui-state-machines/exit",992916909),next_state_74574)){
return cljs.core.update.call(null,G__73826,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),cljs.core.dissoc,asm_id);
} else {
return G__73826;
}
}
})();
if(cljs.core.truth_(temp__5720__auto___74575)){
var new_fulcro_state_74576 = temp__5720__auto___74575;
cljs.core.reset_BANG_.call(null,state_atom,new_fulcro_state_74576);
} else {
}

return null;
});
/**
 * Add a timeout named `timer-id` to the `env` that will send `event-id` with `event-data` event
 * after `timeout` (in milliseconds) unless an event (i.e. some-event-id) occurs where a call
 * to `(cancel-on-events some-event-id)` returns true.
 * 
 * Setting a timeout on an existing timer-id will cancel the current one and start the new one.
 * 
 * `cancel-on-events` is a predicate that will be passed an event ID on events. If it returns true
 *  on an event before the timeout fires, then the timeout will be auto-cancelled. If not specified, then
 *  it defaults to `(constantly false)`.
 */
fulcro.incubator.ui_state_machines.set_timeout = (function fulcro$incubator$ui_state_machines$set_timeout(var_args){
var G__73831 = arguments.length;
switch (G__73831) {
case 5:
return fulcro.incubator.ui_state_machines.set_timeout.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fulcro.incubator.ui_state_machines.set_timeout.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.set_timeout.cljs$core$IFn$_invoke$arity$5 = (function (env,timer_id,event_id,event_data,timeout){
new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),cljs.core.pos_int_QMARK_,fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return fulcro.incubator.ui_state_machines.set_timeout.call(null,env,timer_id,event_id,event_data,timeout,cljs.core.constantly.call(null,false));
});

fulcro.incubator.ui_state_machines.set_timeout.cljs$core$IFn$_invoke$arity$6 = (function (env,timer_id,event_id,event_data,timeout,cancel_on_events){
new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),cljs.core.pos_int_QMARK_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-fn","fulcro.incubator.ui-state-machines/cancel-fn",646002455),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var descriptor = (function (){var G__73837 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771),timeout,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),timer_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"timer","timer",-1266967739),true], null)),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),event_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301),cancel_on_events], null))], null);
if(cljs.core.truth_(event_data)){
return cljs.core.assoc.call(null,G__73837,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),event_data);
} else {
return G__73837;
}
})();
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),descriptor);
});

fulcro.incubator.ui_state_machines.set_timeout.cljs$lang$maxFixedArity = 6;

/**
 * Clear a scheduled timeout (if it has yet to fire).  Harmless to call if the timeout is gone. This call takes
 *   effect immediately (in terms of making sure the timeout does not fire).
 */
fulcro.incubator.ui_state_machines.clear_timeout_BANG_ = (function fulcro$incubator$ui_state_machines$clear_timeout_BANG_(env,timer_id){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var map__73843 = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),timer_id], null));
var map__73843__$1 = (((((!((map__73843 == null))))?(((((map__73843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73843.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73843):map__73843);
var js_timer = cljs.core.get.call(null,map__73843__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963));
var real_js_timer = new cljs.core.Keyword(null,"timer","timer",-1266967739).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,js_timer));
if(cljs.core.truth_(real_js_timer)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),459], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Clearing timeout on ",timer_id);
}catch (e73848){if((e73848 instanceof Error)){
var e__54502__auto___74583 = e73848;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),459], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74583);
} else {
throw e73848;

}
}
fulcro.incubator.ui_state_machines.clear_js_timeout_BANG_.call(null,real_js_timer);
} else {
}

return cljs.core.update_in.call(null,env,fulcro.incubator.ui_state_machines.asm_path.call(null,env,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640)], null)),cljs.core.dissoc,timer_id);
});
/**
 * Returns an event handler that can process events according to a state machine
 *   ::uism/events definition of the current event/state in `env`.
 *   If a definition cannot be found then it returns nil.
 */
fulcro.incubator.ui_state_machines.generic_event_handler = (function fulcro$incubator$ui_state_machines$generic_event_handler(original_env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199),null)], null);

var smdef = fulcro.incubator.ui_state_machines.lookup_state_machine.call(null,original_env);
var current_state_id = fulcro.incubator.ui_state_machines.asm_value.call(null,original_env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016));
var current_event = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503).cljs$core$IFn$_invoke$arity$1(original_env);
var map__73853 = (function (){var G__73856 = smdef;
var G__73856__$1 = (((G__73856 == null))?null:new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683).cljs$core$IFn$_invoke$arity$1(G__73856));
var G__73856__$2 = (((G__73856__$1 == null))?null:cljs.core.get.call(null,G__73856__$1,current_state_id));
var G__73856__$3 = (((G__73856__$2 == null))?null:new cljs.core.Keyword("fulcro.incubator.ui-state-machines","events","fulcro.incubator.ui-state-machines/events",418161170).cljs$core$IFn$_invoke$arity$1(G__73856__$2));
if((G__73856__$3 == null)){
return null;
} else {
return cljs.core.get.call(null,G__73856__$3,current_event);
}
})();
var map__73853__$1 = (((((!((map__73853 == null))))?(((((map__73853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73853):map__73853);
var event_def = map__73853__$1;
var event_predicate = cljs.core.get.call(null,map__73853__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-predicate","fulcro.incubator.ui-state-machines/event-predicate",797710440));
var handler = cljs.core.get.call(null,map__73853__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199));
var target_state = cljs.core.get.call(null,map__73853__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-state","fulcro.incubator.ui-state-machines/target-state",-173645600));
if(cljs.core.truth_(event_def)){
return ((function (smdef,current_state_id,current_event,map__73853,map__73853__$1,event_def,event_predicate,handler,target_state){
return (function (env){
if(cljs.core.truth_((function (){var or__4131__auto__ = (event_predicate == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = event_predicate;
if(cljs.core.truth_(and__4120__auto__)){
return event_predicate.call(null,env);
} else {
return and__4120__auto__;
}
}
})())){
var env__$1 = (cljs.core.truth_(handler)?(function (){var or__4131__auto__ = handler.call(null,env);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return env;
}
})():env);
var post_handler_state = fulcro.incubator.ui_state_machines.asm_value.call(null,env__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016));
var state_changed_QMARK_ = cljs.core.not_EQ_.call(null,post_handler_state,current_state_id);
var G__73868 = env__$1;
if(cljs.core.truth_((function (){var and__4120__auto__ = (!(state_changed_QMARK_));
if(and__4120__auto__){
return target_state;
} else {
return and__4120__auto__;
}
})())){
return fulcro.incubator.ui_state_machines.activate.call(null,G__73868,target_state);
} else {
return G__73868;
}
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),484], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Undoing changes from value-changed");
}catch (e73869){if((e73869 instanceof Error)){
var e__54502__auto___74589 = e73869;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),484], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74589);
} else {
throw e73869;

}
}
return original_env;
}
});
;})(smdef,current_state_id,current_event,map__73853,map__73853__$1,event_def,event_predicate,handler,target_state))
} else {
return null;
}
});
/**
 * Find the handler for the active state in the current env.
 */
fulcro.incubator.ui_state_machines.active_state_handler = (function fulcro$incubator$ui_state_machines$active_state_handler(env){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null);

var smdef = fulcro.incubator.ui_state_machines.lookup_state_machine.call(null,env);
var current_state = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016));
var handler = (function (){var or__4131__auto__ = cljs.core.get_in.call(null,smdef,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","states","fulcro.incubator.ui-state-machines/states",-1590291683),current_state,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","handler","fulcro.incubator.ui-state-machines/handler",-1707547199)], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fulcro.incubator.ui_state_machines.generic_event_handler.call(null,env);
}
})();
if(cljs.core.truth_(handler)){
return handler;
} else {
var map__73873 = env;
var map__73873__$1 = (((((!((map__73873 == null))))?(((((map__73873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73873.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73873):map__73873);
var event_id = cljs.core.get.call(null,map__73873__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),500], null),new cljs.core.Keyword(null,"error","error",-978969032),"UNEXPECTED EVENT: Did not find a way to handle event",event_id,"in the current active state:",current_state);
}catch (e73877){if((e73877 instanceof Error)){
var e__54502__auto___74597 = e73877;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),500], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74597);
} else {
throw e73877;

}
}
return cljs.core.identity;
}
});
/**
 * Returns a vector of things to refresh in Fulcro based on the final state of an active SM env.
 */
fulcro.incubator.ui_state_machines.ui_refresh_list = (function fulcro$incubator$ui_state_machines$ui_refresh_list(env){
var smdef = fulcro.incubator.ui_state_machines.lookup_state_machine.call(null,env);
var actor_idents = cljs.core.mapv.call(null,((function (smdef){
return (function (p1__73884_SHARP_){
return fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,p1__73884_SHARP_);
});})(smdef))
,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-names","fulcro.incubator.ui-state-machines/actor-names",-1069751571).cljs$core$IFn$_invoke$arity$1(smdef));
return actor_idents;
});
fulcro.incubator.ui_state_machines.get_js_timer = (function fulcro$incubator$ui_state_machines$get_js_timer(env,timer_id){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var G__73889 = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),timer_id], null));
var G__73889__$1 = (((G__73889 == null))?null:new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963).cljs$core$IFn$_invoke$arity$1(G__73889));
var G__73889__$2 = (((G__73889__$1 == null))?null:cljs.core.meta.call(null,G__73889__$1));
if((G__73889__$2 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"timer","timer",-1266967739).cljs$core$IFn$_invoke$arity$1(G__73889__$2);
}
});
/**
 * INTERNAL: actually schedule the timers that were submitted during the event handler.
 */
fulcro.incubator.ui_state_machines.schedule_timeouts_BANG_ = (function fulcro$incubator$ui_state_machines$schedule_timeouts_BANG_(reconciler,env){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var map__73902 = env;
var map__73902__$1 = (((((!((map__73902 == null))))?(((((map__73902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73902.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73902):map__73902);
var queued_timeouts = cljs.core.get.call(null,map__73902__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-timeouts","fulcro.incubator.ui-state-machines/queued-timeouts",1174994342));
var asm_id = cljs.core.get.call(null,map__73902__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
return cljs.core.reduce.call(null,((function (map__73902,map__73902__$1,queued_timeouts,asm_id){
return (function (env__$1,p__73909){
var map__73910 = p__73909;
var map__73910__$1 = (((((!((map__73910 == null))))?(((((map__73910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73910):map__73910);
var descriptor = map__73910__$1;
var timeout = cljs.core.get.call(null,map__73910__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timeout","fulcro.incubator.ui-state-machines/timeout",1865196771));
var event_id = cljs.core.get.call(null,map__73910__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
var event_data = cljs.core.get.call(null,map__73910__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294));
var timer_id = cljs.core.get.call(null,map__73910__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","timer-id","fulcro.incubator.ui-state-machines/timer-id",-898024242));
var current_timer = fulcro.incubator.ui_state_machines.get_js_timer.call(null,env__$1,timer_id);
var js_timer = fulcro.incubator.ui_state_machines.set_js_timeout_BANG_.call(null,((function (current_timer,map__73910,map__73910__$1,descriptor,timeout,event_id,event_data,timer_id,map__73902,map__73902__$1,queued_timeouts,asm_id){
return (function (){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),523], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Sending ",event_id,"due to timeout of",timer_id,"after",timeout,"ms");
}catch (e73912){if((e73912 instanceof Error)){
var e__54502__auto___74620 = e73912;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),523], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74620);
} else {
throw e73912;

}
}
return fulcro.incubator.ui_state_machines.trigger_BANG_.call(null,reconciler,asm_id,event_id,(function (){var or__4131__auto__ = event_data;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());
});})(current_timer,map__73910,map__73910__$1,descriptor,timeout,event_id,event_data,timer_id,map__73902,map__73902__$1,queued_timeouts,asm_id))
,timeout);
var descriptor__$1 = cljs.core.update_in.call(null,descriptor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","js-timer","fulcro.incubator.ui-state-machines/js-timer",1400500963)], null),cljs.core.vary_meta,cljs.core.assoc,new cljs.core.Keyword(null,"timer","timer",-1266967739),js_timer);
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),526], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Scheduled timer",timer_id);
}catch (e73913){if((e73913 instanceof Error)){
var e__54502__auto___74623 = e73913;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),526], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74623);
} else {
throw e73913;

}
}
if(cljs.core.truth_(current_timer)){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),528], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Resetting active timer",timer_id);
}catch (e73916){if((e73916 instanceof Error)){
var e__54502__auto___74628 = e73916;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),528], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74628);
} else {
throw e73916;

}
}
fulcro.incubator.ui_state_machines.clear_js_timeout_BANG_.call(null,current_timer);
} else {
}

return cljs.core.assoc_in.call(null,env__$1,fulcro.incubator.ui_state_machines.asm_path.call(null,env__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640),timer_id], null)),descriptor__$1);
});})(map__73902,map__73902__$1,queued_timeouts,asm_id))
,env,queued_timeouts);
});
/**
 * Processes the auto-cancel of events. This is a normal part of the internals, but can be used in handlers
 *   to simulate a *different* event than acutally occured for the purpose of clearing sets of timers that
 *   auto-cancel on other events than what occurred.
 */
fulcro.incubator.ui_state_machines.clear_timeouts_on_event_BANG_ = (function fulcro$incubator$ui_state_machines$clear_timeouts_on_event_BANG_(env,event_id){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var active_timers = fulcro.incubator.ui_state_machines.asm_value.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-timers","fulcro.incubator.ui-state-machines/active-timers",1858099640));
return cljs.core.reduce.call(null,((function (active_timers){
return (function (env__$1,timer_id){
var cancel_predicate = (function (){var G__73919 = cljs.core.get_in.call(null,active_timers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [timer_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","cancel-on","fulcro.incubator.ui-state-machines/cancel-on",2098628796)], null));
var G__73919__$1 = (((G__73919 == null))?null:cljs.core.meta.call(null,G__73919));
if((G__73919__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"cancel-on","cancel-on",-479584301).cljs$core$IFn$_invoke$arity$1(G__73919__$1);
}
})();
if(cljs.core.truth_(cancel_predicate)){
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),545], null),new cljs.core.Keyword(null,"error","error",-978969032),"INTERNAL ERROR: Cancel predicate was nil for timer ",timer_id);
}catch (e73922){if((e73922 instanceof Error)){
var e__54502__auto___74630 = e73922;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),545], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74630);
} else {
throw e73922;

}
}}

if(cljs.core.truth_((function (){var and__4120__auto__ = cancel_predicate;
if(cljs.core.truth_(and__4120__auto__)){
return cancel_predicate.call(null,event_id);
} else {
return and__4120__auto__;
}
})())){
return fulcro.incubator.ui_state_machines.clear_timeout_BANG_.call(null,env__$1,timer_id);
} else {
return env__$1;
}
});})(active_timers))
,env,cljs.core.keys.call(null,active_timers));
});
/**
 * IMPLEMENTATION DETAIL. Low-level implementation of triggering a state machine event. Does no direct interaction with
 *   Fulcro UI refresh.  Use `trigger!` instead.
 * 
 *   - `env` - A fulcro mutation env, containing at least the state atom and optionally the ref of the
 *  component that was the source of the event.
 *   - params - The parameters for the event
 * 
 *   Returns a vector of actor idents that should be refreshed. 
 */
fulcro.incubator.ui_state_machines.trigger_state_machine_event_BANG_ = (function fulcro$incubator$ui_state_machines$trigger_state_machine_event_BANG_(p__73923,p__73924){
var map__73925 = p__73923;
var map__73925__$1 = (((((!((map__73925 == null))))?(((((map__73925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73925):map__73925);
var reconciler = cljs.core.get.call(null,map__73925__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state = cljs.core.get.call(null,map__73925__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__73925__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var map__73926 = p__73924;
var map__73926__$1 = (((((!((map__73926 == null))))?(((((map__73926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73926.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73926):map__73926);
var params = map__73926__$1;
var event_id = cljs.core.get.call(null,map__73926__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
var event_data = cljs.core.get.call(null,map__73926__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294));
var asm_id = cljs.core.get.call(null,map__73926__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var sm_env = fulcro.incubator.ui_state_machines.state_machine_env.call(null,cljs.core.deref.call(null,state),ref,asm_id,event_id,event_data);
var handler = fulcro.incubator.ui_state_machines.active_state_handler.call(null,sm_env);
var valued_env = fulcro.incubator.ui_state_machines.apply_event_value.call(null,sm_env,params);
var handled_env = handler.call(null,valued_env);
var final_env = (function (){var e = (function (){var or__4131__auto__ = handled_env;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return valued_env;
}
})();
var e__$1 = fulcro.incubator.ui_state_machines.clear_timeouts_on_event_BANG_.call(null,e,event_id);
return fulcro.incubator.ui_state_machines.schedule_timeouts_BANG_.call(null,reconciler,e__$1);
})();
fulcro.incubator.ui_state_machines.queue_mutations_BANG_.call(null,reconciler,final_env);

fulcro.incubator.ui_state_machines.queue_loads_BANG_.call(null,reconciler,final_env);

fulcro.incubator.ui_state_machines.update_fulcro_state_BANG_.call(null,final_env,state);

return fulcro.incubator.ui_state_machines.ui_refresh_list.call(null,final_env);
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","trigger-state-machine-event","fulcro.incubator.ui-state-machines/trigger-state-machine-event",593149133,null),(function (fulcro_incoming_env,_,p__73935){
var map__73936 = p__73935;
var map__73936__$1 = (((((!((map__73936 == null))))?(((((map__73936.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73936.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73936):map__73936);
var params = map__73936__$1;
var event_id = cljs.core.get.call(null,map__73936__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
var event_data = cljs.core.get.call(null,map__73936__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294));
var asm_id = cljs.core.get.call(null,map__73936__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
return cljs.core.merge.call(null,(function (){var map__73941 = fulcro_incoming_env;
var map__73941__$1 = (((((!((map__73941 == null))))?(((((map__73941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73941):map__73941);
var env = map__73941__$1;
var reconciler = cljs.core.get.call(null,map__73941__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__73941,map__73941__$1,env,reconciler,map__73936,map__73936__$1,params,event_id,event_data,asm_id){
return (function (){
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),578], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Triggering state machine event ",event_id);
}catch (e73947){if((e73947 instanceof Error)){
var e__54502__auto___74649 = e73947;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),578], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74649);
} else {
throw e73947;

}
}
var to_refresh_74650 = fulcro.incubator.ui_state_machines.trigger_state_machine_event_BANG_.call(null,env,params);
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),580], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Queuing actor refreshes",to_refresh_74650);
}catch (e73951){if((e73951 instanceof Error)){
var e__54502__auto___74651 = e73951;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),580], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74651);
} else {
throw e73951;

}
}
fulcro.incubator.ui_state_machines.defer.call(null,((function (to_refresh_74650,map__73941,map__73941__$1,env,reconciler,map__73936,map__73936__$1,params,event_id,event_data,asm_id){
return (function (){
return fulcro.client.impl.protocols.queue_BANG_(reconciler,to_refresh_74650);
});})(to_refresh_74650,map__73941,map__73941__$1,env,reconciler,map__73936,map__73936__$1,params,event_id,event_data,asm_id))
);

return true;
});})(map__73941,map__73941__$1,env,reconciler,map__73936,map__73936__$1,params,event_id,event_data,asm_id))
], null);
})());
}));
/**
 * Similar to Fulcro's set-string, but it sets the string on an active state machine's data alias.
 *   event-or-string can be a string or a React DOM onChange event.
 * 
 *   The incoming `event-data` to your handler will include `::uism/alias` and `:value` (if you care to do anything
 *   with the value change event).
 * 
 *   NOTE: Generates a ::uism/value-changed event. If you're state machine is implemented with the events
 *   structure that allows an event-predicate, then this set will be ignored if the current state's event-predicate
 *   returns false.
 */
fulcro.incubator.ui_state_machines.set_string_BANG_ = (function fulcro$incubator$ui_state_machines$set_string_BANG_(this$,active_state_machine_id,alias,event_or_string){
var value = ((typeof event_or_string === 'string')?event_or_string:(function (){var or__4131__auto__ = (function (){var G__73960 = event_or_string;
var G__73960__$1 = (((G__73960 == null))?null:G__73960.target);
if((G__73960__$1 == null)){
return null;
} else {
return G__73960__$1.value;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
return fulcro.incubator.ui_state_machines.trigger_BANG_.call(null,this$,active_state_machine_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","value-changed","fulcro.incubator.ui-state-machines/value-changed",-144746786),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),alias,new cljs.core.Keyword(null,"value","value",305978217),value], null));
});
/**
 * Similar to Fulcro's set-value, but it sets the raw value on an active state machine's data alias.
 * 
 *   The incoming `event-data` to your handler will include `::uism/alias` and `:value` (if you care to do anything
 *   with the value change event).
 * 
 *   NOTE: Generates a ::uism/value-changed event. If you're state machine is implemented with the events
 *   structure that allows an event-predicate, then this set will be ignored if the current state's event-predicate
 *   returns false.
 */
fulcro.incubator.ui_state_machines.set_value_BANG_ = (function fulcro$incubator$ui_state_machines$set_value_BANG_(this$,active_state_machine_id,alias,value){
return fulcro.incubator.ui_state_machines.trigger_BANG_.call(null,this$,active_state_machine_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","value-changed","fulcro.incubator.ui-state-machines/value-changed",-144746786),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),alias,new cljs.core.Keyword(null,"value","value",305978217),value], null));
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","begin","fulcro.incubator.ui-state-machines/begin",-659301023,null),(function (fulcro_incoming_env,_,p__73964){
var map__73965 = p__73964;
var map__73965__$1 = (((((!((map__73965 == null))))?(((((map__73965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73965):map__73965);
var params = map__73965__$1;
var asm_id = cljs.core.get.call(null,map__73965__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var event_data = cljs.core.get.call(null,map__73965__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294));
return cljs.core.merge.call(null,(function (){var map__73967 = fulcro_incoming_env;
var map__73967__$1 = (((((!((map__73967 == null))))?(((((map__73967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73967):map__73967);
var env = map__73967__$1;
var state = cljs.core.get.call(null,map__73967__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__73967,map__73967__$1,env,state,map__73965,map__73965__$1,params,asm_id,event_data){
return (function (){
cljs.core.swap_BANG_.call(null,state,((function (map__73967,map__73967__$1,env,state,map__73965,map__73965__$1,params,asm_id,event_data){
return (function (s){
return cljs.core.assoc_in.call(null,s,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id], null),fulcro.incubator.ui_state_machines.new_asm.call(null,params));
});})(map__73967,map__73967__$1,env,state,map__73965,map__73965__$1,params,asm_id,event_data))
);

return fulcro.incubator.ui_state_machines.trigger_state_machine_event_BANG_.call(null,env,(function (){var G__73974 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","started","fulcro.incubator.ui-state-machines/started",-1147945147),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),cljs.core.PersistentArrayMap.EMPTY], null);
if(cljs.core.truth_(event_data)){
return cljs.core.assoc.call(null,G__73974,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),event_data);
} else {
return G__73974;
}
})());
});})(map__73967,map__73967__$1,env,state,map__73965,map__73965__$1,params,asm_id,event_data))
], null);
})());
}));
fulcro.incubator.ui_state_machines.begin = fulcro.incubator.mutation_interface.__GT_Mutation.call(null,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","begin","fulcro.incubator.ui-state-machines/begin",-659301023,null),cljs.core.map_QMARK_);
/**
 * Generate an actor->ident map where the class of the actor is stored as metadata on each ident.
 */
fulcro.incubator.ui_state_machines.derive_actor_idents = (function fulcro$incubator$ui_state_machines$derive_actor_idents(actors){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,(function (p__73979){
var vec__73980 = p__73979;
var actor_id = cljs.core.nth.call(null,vec__73980,(0),null);
var v = cljs.core.nth.call(null,vec__73980,(1),null);
if(cljs.core.truth_((function (){var and__4120__auto__ = fulcro.client.primitives.component_QMARK_.call(null,v);
if(and__4120__auto__){
return cljs.core.second.call(null,fulcro.client.primitives.get_ident.call(null,v));
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [actor_id,fulcro.incubator.ui_state_machines.with_actor_class.call(null,fulcro.client.primitives.get_ident.call(null,v),fulcro.client.primitives.react_type.call(null,v))], null);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = fulcro.client.primitives.component_class_QMARK_.call(null,v);
if(and__4120__auto__){
return cljs.core.second.call(null,fulcro.client.primitives.get_ident.call(null,v,cljs.core.PersistentArrayMap.EMPTY));
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [actor_id,fulcro.incubator.ui_state_machines.with_actor_class.call(null,fulcro.client.primitives.get_ident.call(null,v,cljs.core.PersistentArrayMap.EMPTY),v)], null);
} else {
if(fulcro.util.ident_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [actor_id,v], null);
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),645], null),new cljs.core.Keyword(null,"error","error",-978969032),"The value given for actor",actor_id,"had (or was) an invalid ident:",v);
}catch (e73983){if((e73983 instanceof Error)){
var e__54502__auto___74673 = e73983;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),645], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___74673);
} else {
throw e73983;

}
}
return null;

}
}
}
})),actors);
});
/**
 * Install and start a state machine.
 * 
 *   this - A UI component or reconciler
 *   machine - A state machine defined with defstatemachine
 *   instance-id - An ID by which you will refer to this active instance.
 *   actors - A map of actor-names -> The ident, class, or react instance that represent them in the UI. Raw idents do not support SM loads.
 *   started-event-data - Data that will be sent with the ::uism/started event as ::uism/event-data
 */
fulcro.incubator.ui_state_machines.begin_BANG_ = (function fulcro$incubator$ui_state_machines$begin_BANG_(var_args){
var G__73993 = arguments.length;
switch (G__73993) {
case 4:
return fulcro.incubator.ui_state_machines.begin_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fulcro.incubator.ui_state_machines.begin_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.begin_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (this$,machine,instance_id,actors){
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),new cljs.core.Keyword(null,"r","r",-471384190)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.primitives","component","fulcro.client.primitives/component",2031982986),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.primitives","component","fulcro.client.primitives/component",2031982986),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603)], null),null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

return fulcro.incubator.ui_state_machines.begin_BANG_.call(null,this$,machine,instance_id,actors,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.incubator.ui_state_machines.begin_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (this$,machine,instance_id,actors,started_event_data){
new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),new cljs.core.Keyword(null,"r","r",-471384190)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.primitives","component","fulcro.client.primitives/component",2031982986),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.client.primitives","component","fulcro.client.primitives/component",2031982986),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fulcro-reconciler","fulcro.incubator.ui-state-machines/fulcro-reconciler",-973332603)], null),null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-definition","fulcro.incubator.ui-state-machines/state-machine-definition",-1781489091),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.any_QMARK_], null);

var actors__GT_idents = fulcro.incubator.ui_state_machines.derive_actor_idents.call(null,actors);
return fulcro.client.primitives.transact_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.ui_state_machines.begin.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),instance_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-machine-id","fulcro.incubator.ui-state-machines/state-machine-id",-998144002).cljs$core$IFn$_invoke$arity$1(machine),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),started_event_data,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor->ident","fulcro.incubator.ui-state-machines/actor->ident",-1642317379),actors__GT_idents], null))], null));
});

fulcro.incubator.ui_state_machines.begin_BANG_.cljs$lang$maxFixedArity = 5;

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","alias","fulcro.incubator.ui-state-machines/alias",-1538820839));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","do-something","fulcro.incubator.ui-state-machines/do-something",1432261601,null)),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,cljs.core.symbol_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("fulcro.incubator.ui-state-machines","do-something","fulcro.incubator.ui-state-machines/do-something",1432261601,null),null], null), null));
})));
fulcro.incubator.ui_state_machines.spec_mutation = fulcro.incubator.mutation_interface.__GT_Mutation.call(null,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","spec-mutation","fulcro.incubator.ui-state-machines/spec-mutation",-1139975060,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-decl","fulcro.incubator.ui-state-machines/mutation-decl",-863155623),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),new cljs.core.Symbol("fulcro.incubator.mutation-interface","mutation-declaration?","fulcro.incubator.mutation-interface/mutation-declaration?",487845417,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("fulcro.incubator.ui-state-machines","spec-mutation","fulcro.incubator.ui-state-machines/spec-mutation",-1139975060,null),"null"], null), null)))),cljs.spec.alpha.with_gen.call(null,fulcro.incubator.mutation_interface.mutation_declaration_QMARK_,(function (){
return cljs.spec.alpha.gen.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([fulcro.incubator.ui_state_machines.spec_mutation]));
})));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-descriptor","fulcro.incubator.ui-state-machines/mutation-descriptor",1360386363),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163)], null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__74002){
return cljs.core.map_QMARK_.call(null,G__74002);
}),(function (G__74002){
return cljs.core.contains_QMARK_.call(null,G__74002,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170));
}),(function (G__74002){
return cljs.core.contains_QMARK_.call(null,G__74002,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163));
})], null),(function (G__74002){
return ((cljs.core.map_QMARK_.call(null,G__74002)) && (cljs.core.contains_QMARK_.call(null,G__74002,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170))) && (cljs.core.contains_QMARK_.call(null,G__74002,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163))));
}),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163)))], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.keyword_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-descriptor","fulcro.incubator.ui-state-machines/mutation-descriptor",1360386363)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-descriptor","fulcro.incubator.ui-state-machines/mutation-descriptor",1360386363),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-descriptor","fulcro.incubator.ui-state-machines/mutation-descriptor",1360386363),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__74016){
return cljs.core.coll_QMARK_.call(null,G__74016);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-descriptor","fulcro.incubator.ui-state-machines/mutation-descriptor",1360386363))], null),null));
/**
 * Compute a raw Fulcro target based on the possible options.
 * 
 *   `env` - The SM env
 * 
 *   targeting options:
 * 
 *   `::pm/target explicit-target` - A raw Fulcro data fetch target.
 *   `::uism/target-actor actor-alias` - Helper that can translate an actor alias to a target
 *   `::uism/target-alias field-alias` - Helper that can translate a data alias to a target (ident + field)
 * 
 *   If more than one option is used, then `df/mutliple-targets` will be used to encode them all.
 *   
 */
fulcro.incubator.ui_state_machines.compute_target = (function fulcro$incubator$ui_state_machines$compute_target(env,p__74017){
var map__74018 = p__74017;
var map__74018__$1 = (((((!((map__74018 == null))))?(((((map__74018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74018.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74018):map__74018);
var target = cljs.core.get.call(null,map__74018__$1,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751));
var target_actor = cljs.core.get.call(null,map__74018__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189));
var target_alias = cljs.core.get.call(null,map__74018__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795));
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((function (map__74018,map__74018__$1,target,target_actor,target_alias){
return (function (G__74021){
return cljs.core.map_QMARK_.call(null,G__74021);
});})(map__74018,map__74018__$1,target,target_actor,target_alias))
], null),((function (map__74018,map__74018__$1,target,target_actor,target_alias){
return (function (G__74021){
return cljs.core.map_QMARK_.call(null,G__74021);
});})(map__74018,map__74018__$1,target,target_actor,target_alias))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795)], null)])),fulcro.incubator.spec_helpers._EQ__GT_,cljs.spec.alpha.nilable_impl.call(null,new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.vector_QMARK_,null)], null);

var noptions = cljs.core.count.call(null,cljs.core.keep.call(null,cljs.core.identity,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [target,target_actor,target_alias], null)));
var actor = (cljs.core.truth_(target_actor)?fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,env,target_actor):null);
var field = (cljs.core.truth_(target_alias)?fulcro.incubator.ui_state_machines.resolve_alias.call(null,env,target_alias):null);
if((noptions > (1))){
if(cljs.core.truth_((function (){var and__4120__auto__ = target;
if(cljs.core.truth_(and__4120__auto__)){
return fulcro.client.impl.data_targeting.multiple_targets_QMARK_.call(null,target);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.into.call(null,target,cljs.core.keep.call(null,cljs.core.identity,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [actor,field], null)));
} else {
return cljs.core.apply.call(null,fulcro.client.data_fetch.multiple_targets,cljs.core.keep.call(null,cljs.core.identity,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [target,actor,field], null)));
}
} else {
var or__4131__auto__ = target;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = actor;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return field;
}
}
}
});
var mtrigger_BANG__74713 = (function fulcro$incubator$ui_state_machines$mutation_trigger_STAR_(p__74029,actor_ident,asm_id,event,data){
var map__74030 = p__74029;
var map__74030__$1 = (((((!((map__74030 == null))))?(((((map__74030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74030.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74030):map__74030);
var reconciler = cljs.core.get.call(null,map__74030__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state = cljs.core.get.call(null,map__74030__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var response = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,actor_ident,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","mutation-response","fulcro.incubator.pessimistic-mutations/mutation-response",1444887855)));
var event_data = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,data,response);
return fulcro.incubator.ui_state_machines.defer.call(null,((function (response,event_data,map__74030,map__74030__$1,reconciler,state){
return (function (){
return fulcro.client.primitives.transact_BANG_.call(null,reconciler,actor_ident,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.incubator.ui_state_machines.trigger_state_machine_event.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),event,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),event_data], null))], null));
});})(response,event_data,map__74030,map__74030__$1,reconciler,state))
);
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.incubator.ui-state-machines","mutation-delegate","fulcro.incubator.ui-state-machines/mutation-delegate",-1977239495,null),((function (mtrigger_BANG__74713){
return (function (p__74036,_,p__74037){
var map__74038 = p__74036;
var map__74038__$1 = (((((!((map__74038 == null))))?(((((map__74038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74038):map__74038);
var env = map__74038__$1;
var reconciler = cljs.core.get.call(null,map__74038__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var state = cljs.core.get.call(null,map__74038__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var map__74039 = p__74037;
var map__74039__$1 = (((((!((map__74039 == null))))?(((((map__74039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74039):map__74039);
var mp = map__74039__$1;
var asm_id = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var ok_event = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881));
var error_event = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603));
var mutation = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163));
var mutation_context = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170));
var ok_data = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656));
var error_data = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787));
var mutation_remote = cljs.core.get.call(null,map__74039__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161));
if(((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,state))) || (cljs.core.empty_QMARK_.call(null,mp)))){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([(function (){var or__4131__auto__ = mutation_remote;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"remote","remote",-1593576576);
}
})(),fulcro.incubator.pessimistic_mutations.pessimistic_mutation.call(null,env)]);
} else {
var sm_env = fulcro.incubator.ui_state_machines.state_machine_env.call(null,cljs.core.deref.call(null,state),null,asm_id,ok_event,ok_data);
var actor_ident = fulcro.incubator.ui_state_machines.actor__GT_ident.call(null,sm_env,mutation_context);
var abort_id = new cljs.core.Keyword(null,"abort-id","abort-id",1559937819).cljs$core$IFn$_invoke$arity$1(mp);
var fixed_env = cljs.core.update.call(null,(function (){var G__74045 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"ref","ref",1289896967),actor_ident);
if(cljs.core.truth_(abort_id)){
return cljs.core.update.call(null,G__74045,new cljs.core.Keyword(null,"ast","ast",-860334068),fulcro.client.mutations.with_abort_id,abort_id);
} else {
return G__74045;
}
})(),new cljs.core.Keyword(null,"ast","ast",-860334068),cljs.core.assoc,new cljs.core.Keyword(null,"key","key",-1516042587),mutation,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),mutation,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.dissoc.call(null,mp,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187)));
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),746], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"explcit remote is ",mutation_remote);
}catch (e74046){if((e74046 instanceof Error)){
var e__54502__auto___74730 = e74046;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro.incubator.ui-state-machines",new cljs.core.Keyword(null,"line","line",212345235),746], null),new cljs.core.Keyword(null,"debug","debug",-1608172596),"Log statement failed (arguments did not evaluate).",e__54502__auto___74730);
} else {
throw e74046;

}
}
var G__74047 = cljs.core.PersistentArrayMap.createAsIfByAssoc([(function (){var or__4131__auto__ = mutation_remote;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"remote","remote",-1593576576);
}
})(),fulcro.incubator.pessimistic_mutations.pessimistic_mutation.call(null,fixed_env)]);
var G__74047__$1 = (cljs.core.truth_(ok_event)?cljs.core.assoc.call(null,G__74047,new cljs.core.Keyword(null,"ok-action","ok-action",1253795573),((function (G__74047,sm_env,actor_ident,abort_id,fixed_env,map__74038,map__74038__$1,env,reconciler,state,map__74039,map__74039__$1,mp,asm_id,ok_event,error_event,mutation,mutation_context,ok_data,error_data,mutation_remote,mtrigger_BANG__74713){
return (function (){
return mtrigger_BANG__74713(fixed_env,actor_ident,asm_id,ok_event,ok_data);
});})(G__74047,sm_env,actor_ident,abort_id,fixed_env,map__74038,map__74038__$1,env,reconciler,state,map__74039,map__74039__$1,mp,asm_id,ok_event,error_event,mutation,mutation_context,ok_data,error_data,mutation_remote,mtrigger_BANG__74713))
):G__74047);
if(cljs.core.truth_(error_event)){
return cljs.core.assoc.call(null,G__74047__$1,new cljs.core.Keyword(null,"error-action","error-action",-1147840498),((function (G__74047,G__74047__$1,sm_env,actor_ident,abort_id,fixed_env,map__74038,map__74038__$1,env,reconciler,state,map__74039,map__74039__$1,mp,asm_id,ok_event,error_event,mutation,mutation_context,ok_data,error_data,mutation_remote,mtrigger_BANG__74713){
return (function (){
return mtrigger_BANG__74713(fixed_env,actor_ident,asm_id,error_event,error_data);
});})(G__74047,G__74047__$1,sm_env,actor_ident,abort_id,fixed_env,map__74038,map__74038__$1,env,reconciler,state,map__74039,map__74039__$1,mp,asm_id,ok_event,error_event,mutation,mutation_context,ok_data,error_data,mutation_remote,mtrigger_BANG__74713))
);
} else {
return G__74047__$1;
}
}
});})(mtrigger_BANG__74713))
);
/**
 * Run the given REMOTE mutation (a symbol or mutation declaration) in the context of the state machine.
 * 
 *   `env` - The SM handler environment
 *   `actor` - The name (keyword) of a defined actor.  The mutation will be run in the context of this actor's state
 *          (see pm/pmutate!), which means that progress will be visible there. THERE MUST BE A MOUNTED COMPONENT
 *          with this actor's name ON the UI, or the mutation will abort.
 *   `mutation` - The symbol (or mutation declaration) of the *server* mutation to run. This function will *not* run a local
 *   version of the mutation.
 *   `options-and-params` - The parameters to pass to your mutation. This map can also include these additional
 *   state-machine options:
 * 
 *   `::pm/returning Class` - Option of pmutate to supply a component form normalizing the returned result.
 *   `::pm/target explicit-target` - Option of pmutate for targeting retuned result.
 *   `::uism/target-actor actor` - Helper that can translate an actor name to a target, if returning a result.
 *   `::uism/target-alias field-alias` - Helper that can translate a data alias to a target (ident + field).
 *   `::uism/ok-event event-id` - The SM event to trigger when the pessimistic mutation succeeds (no default).
 *   `::uism/error-event event-id` - The SM event to trigger when the pessimistic mutation fails (no default).
 *   `::uism/ok-data map-of-data` - Data to include in the event-data on an ok event
 *   `::uism/error-data map-of-data` - Data to include in the event-data on an error event
 *   `::uism/mutation-remote` - The keyword name of the Fulcro remote (defaults to :remote)
 * 
 *   NOTE: The mutation response *will be merged* into the event data that is sent to the SM handler.
 * 
 *   This function does *not* side effect.  It queues the mutation to run after the handler exits.
 */
fulcro.incubator.ui_state_machines.trigger_remote_mutation = (function fulcro$incubator$ui_state_machines$trigger_remote_mutation(env,actor,mutation,options_and_params){
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sym","sym",-1444860305),new cljs.core.Keyword(null,"decl","decl",-1498869485)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-decl","fulcro.incubator.ui-state-machines/mutation-decl",-863155623)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-decl","fulcro.incubator.ui-state-machines/mutation-decl",-863155623)], null),null),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__74056){
return cljs.core.map_QMARK_.call(null,G__74056);
})], null),(function (G__74056){
return cljs.core.map_QMARK_.call(null,G__74056);
}),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","returning","fulcro.incubator.pessimistic-mutations/returning",-1359534109),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-event","fulcro.incubator.ui-state-machines/ok-event",-2107450881),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","ok-data","fulcro.incubator.ui-state-machines/ok-data",523256656),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-remote","fulcro.incubator.ui-state-machines/mutation-remote",-990090161)], null)])),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var target = fulcro.incubator.ui_state_machines.compute_target.call(null,env,options_and_params);
var asm_id = new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187).cljs$core$IFn$_invoke$arity$1(env);
var mutation_sym = fulcro.incubator.mutation_interface.mutation_symbol.call(null,mutation,cljs.core.PersistentArrayMap.EMPTY);
var mutation_descriptor = (function (){var G__74060 = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,options_and_params,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-actor","fulcro.incubator.ui-state-machines/target-actor",198116189),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","target-alias","fulcro.incubator.ui-state-machines/target-alias",704597795),new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751)),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation","fulcro.incubator.ui-state-machines/mutation",-2004801163),mutation_sym,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","mutation-context","fulcro.incubator.ui-state-machines/mutation-context",2082590170),actor);
if(cljs.core.seq.call(null,target)){
return cljs.core.assoc.call(null,G__74060,new cljs.core.Keyword("fulcro.incubator.pessimistic-mutations","target","fulcro.incubator.pessimistic-mutations/target",-648317751),target);
} else {
return G__74060;
}
})();
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-mutations","fulcro.incubator.ui-state-machines/queued-mutations",-762845227),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),mutation_descriptor);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load","fulcro.incubator.ui-state-machines/load",54086375),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800)], null)),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__74074){
return cljs.core.map_QMARK_.call(null,G__74074);
})], null),(function (G__74074){
return cljs.core.map_QMARK_.call(null,G__74074);
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800)], null)])));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load","fulcro.incubator.ui-state-machines/load",54086375)),cljs.spec.alpha.every_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load","fulcro.incubator.ui-state-machines/load",54086375),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load","fulcro.incubator.ui-state-machines/load",54086375),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("cljs.spec.alpha","kind-form","cljs.spec.alpha/kind-form",-1047104697),null,new cljs.core.Keyword("cljs.spec.alpha","cpred","cljs.spec.alpha/cpred",-693471218),(function (G__74076){
return cljs.core.coll_QMARK_.call(null,G__74076);
}),new cljs.core.Keyword("cljs.spec.alpha","conform-all","cljs.spec.alpha/conform-all",45201917),true,new cljs.core.Keyword("cljs.spec.alpha","describe","cljs.spec.alpha/describe",1883026911),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","coll-of","cljs.spec.alpha/coll-of",1019430407,null),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load","fulcro.incubator.ui-state-machines/load",54086375))], null),null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_);
/**
 * INTERNAL: Convert SM load options into Fulcro load options.
 */
fulcro.incubator.ui_state_machines.convert_load_options = (function fulcro$incubator$ui_state_machines$convert_load_options(env,options){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__74077){
return cljs.core.map_QMARK_.call(null,G__74077);
})], null),(function (G__74077){
return cljs.core.map_QMARK_.call(null,G__74077);
}),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event","fulcro.incubator.ui-state-machines/fallback-event",-2044696247),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event","fulcro.incubator.ui-state-machines/fallback-event",-2044696247),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event","fulcro.incubator.ui-state-machines/fallback-event",-2044696247),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768)], null)])),fulcro.incubator.spec_helpers._EQ__GT_,cljs.core.map_QMARK_], null);

var map__74086 = options;
var map__74086__$1 = (((((!((map__74086 == null))))?(((((map__74086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74086):map__74086);
var post_event = cljs.core.get.call(null,map__74086__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289));
var post_event_params = cljs.core.get.call(null,map__74086__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663));
var fallback_event = cljs.core.get.call(null,map__74086__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event","fulcro.incubator.ui-state-machines/fallback-event",-2044696247));
var fallback_event_params = cljs.core.get.call(null,map__74086__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768));
var map__74087 = options;
var map__74087__$1 = (((((!((map__74087 == null))))?(((((map__74087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74087.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74087):map__74087);
var marker = cljs.core.get.call(null,map__74087__$1,new cljs.core.Keyword(null,"marker","marker",865118313));
var marker__$1 = (((marker == null))?false:marker);
var map__74088 = env;
var map__74088__$1 = (((((!((map__74088 == null))))?(((((map__74088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74088.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74088):map__74088);
var asm_id = cljs.core.get.call(null,map__74088__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187));
var options__$1 = (function (){var G__74099 = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,options,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event","fulcro.incubator.ui-state-machines/post-event",778669289),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","post-event-params","fulcro.incubator.ui-state-machines/post-event-params",-1027051663),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event","fulcro.incubator.ui-state-machines/fallback-event",-2044696247),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","fallback-event-params","fulcro.incubator.ui-state-machines/fallback-event-params",-802750768),new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212)),new cljs.core.Keyword(null,"marker","marker",865118313),marker__$1,new cljs.core.Keyword(null,"abort-id","abort-id",1559937819),asm_id,new cljs.core.Keyword(null,"fallback","fallback",761637929),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","handle-load-error","fulcro.incubator.ui-state-machines/handle-load-error",54393509,null),new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),cljs.core.merge.call(null,post_event_params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187),asm_id], null)));
var G__74099__$1 = (cljs.core.truth_(post_event)?cljs.core.update.call(null,cljs.core.assoc.call(null,G__74099,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Symbol("fulcro.incubator.ui-state-machines","trigger-state-machine-event","fulcro.incubator.ui-state-machines/trigger-state-machine-event",593149133,null)),new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-id","fulcro.incubator.ui-state-machines/event-id",-183708503),post_event):G__74099);
var G__74099__$2 = (cljs.core.truth_(post_event_params)?cljs.core.update.call(null,G__74099__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","event-data","fulcro.incubator.ui-state-machines/event-data",523467294),post_event_params):G__74099__$1);
var G__74099__$3 = (cljs.core.truth_(fallback_event)?cljs.core.update.call(null,G__74099__$2,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-event","fulcro.incubator.ui-state-machines/error-event",-1285328603),fallback_event):G__74099__$2);
if(cljs.core.truth_(fallback_event_params)){
return cljs.core.update.call(null,G__74099__$3,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),cljs.core.assoc,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","error-data","fulcro.incubator.ui-state-machines/error-data",1688432787),fallback_event_params);
} else {
return G__74099__$3;
}
})();
return options__$1;
});
/**
 * Identical API to fulcro's data fetch `load`, but using a handle `env` instead of a component/reconciler.
 * Adds the load request to then env which will be sent to Fulcro as soon as the handler finishes.
 * 
 *   The `options` are as in Fulcro's load, with the following additional keys for convenience:
 * 
 *   `::uism/post-event`:: An event to send when the load is done (instead of calling a mutation)
 *   `::uism/post-event-params`:: Extra parameters to send as event-data on the post-event.
 *   `::uism/fallback-event`:: The event to send if the load triggers a fallback.
 *   `::uism/fallback-event-params`:: Extra parameters to send as event-data on a fallback.
 * 
 * NOTE: In general a state machine should declare an actor for items in the machine and use `load-actor` instead of
 * this function so that the state definitions themselves need not be coupled (via code) to the UI.
 */
fulcro.incubator.ui_state_machines.load = (function fulcro$incubator$ui_state_machines$load(var_args){
var G__74107 = arguments.length;
switch (G__74107) {
case 3:
return fulcro.incubator.ui_state_machines.load.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.incubator.ui_state_machines.load.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.load.cljs$core$IFn$_invoke$arity$3 = (function (env,k,component_class){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return fulcro.incubator.ui_state_machines.load.call(null,env,k,component_class,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.incubator.ui_state_machines.load.cljs$core$IFn$_invoke$arity$4 = (function (env,k,component_class,options){
new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.keyword_QMARK_,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var options__$1 = fulcro.incubator.ui_state_machines.convert_load_options.call(null,env,options);
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),(function (){var G__74113 = cljs.core.PersistentArrayMap.EMPTY;
var G__74113__$1 = (cljs.core.truth_(component_class)?cljs.core.assoc.call(null,G__74113,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),component_class):G__74113);
var G__74113__$2 = (cljs.core.truth_(k)?cljs.core.assoc.call(null,G__74113__$1,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","query-key","fulcro.incubator.ui-state-machines/query-key",-1270410946),k):G__74113__$1);
if(cljs.core.truth_(options__$1)){
return cljs.core.assoc.call(null,G__74113__$2,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),options__$1);
} else {
return G__74113__$2;
}
})());
});

fulcro.incubator.ui_state_machines.load.cljs$lang$maxFixedArity = 4;

/**
 * Load (refresh) the given actor. If the actor *is not* on the UI, then you *must* specify
 * `:fulcro.client.primitives/component-class` in the `options` map.
 * 
 * options can contain the normal `df/load` parameters, and also:
 * 
 *   `::prim/component-class` - The defsc name of the component to use for normalization and query. Only needed if the
 *  actor was not declared using a Fulcro component or component class.
 *   `::uism/post-event`:: An event to send when the load is done (instead of calling a mutation)
 *   `::uism/post-event-params`:: Extra parameters to send as event-data on the post-event.
 *   `::uism/fallback-event`:: The event to send if the load triggers a fallback.
 *   `::uism/fallback-event-params`:: Extra parameters to send as event-data on a fallback.
 * 
 * Adds a load request to then env which will be sent to Fulcro as soon as the handler finishes.
 */
fulcro.incubator.ui_state_machines.load_actor = (function fulcro$incubator$ui_state_machines$load_actor(var_args){
var G__74116 = arguments.length;
switch (G__74116) {
case 2:
return fulcro.incubator.ui_state_machines.load_actor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.incubator.ui_state_machines.load_actor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.incubator.ui_state_machines.load_actor.cljs$core$IFn$_invoke$arity$2 = (function (env,actor_name){
new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return fulcro.incubator.ui_state_machines.load_actor.call(null,env,actor_name,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.incubator.ui_state_machines.load_actor.cljs$core$IFn$_invoke$arity$3 = (function (env,actor_name,p__74122){
var map__74124 = p__74122;
var map__74124__$1 = (((((!((map__74124 == null))))?(((((map__74124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74124.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74124):map__74124);
var options = map__74124__$1;
var component_class = cljs.core.get.call(null,map__74124__$1,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212));
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

var options__$1 = fulcro.incubator.ui_state_machines.convert_load_options.call(null,env,options);
return cljs.core.update.call(null,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","queued-loads","fulcro.incubator.ui-state-machines/queued-loads",824051060),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),(function (){var G__74129 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","actor-name","fulcro.incubator.ui-state-machines/actor-name",-271927357),actor_name,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","load-options","fulcro.incubator.ui-state-machines/load-options",-2024935800),options__$1], null);
if(cljs.core.truth_(component_class)){
return cljs.core.assoc.call(null,G__74129,new cljs.core.Keyword("fulcro.client.primitives","component-class","fulcro.client.primitives/component-class",282793212),component_class);
} else {
return G__74129;
}
})());
});

fulcro.incubator.ui_state_machines.load_actor.cljs$lang$maxFixedArity = 3;

/**
 * Run a mutation helper function (e.g. a fn of Fulcro state).
 */
fulcro.incubator.ui_state_machines.apply_action = (function fulcro$incubator$ui_state_machines$apply_action(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74783 = arguments.length;
var i__4731__auto___74784 = (0);
while(true){
if((i__4731__auto___74784 < len__4730__auto___74783)){
args__4736__auto__.push((arguments[i__4731__auto___74784]));

var G__74786 = (i__4731__auto___74784 + (1));
i__4731__auto___74784 = G__74786;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.incubator.ui_state_machines.apply_action.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.incubator.ui_state_machines.apply_action.cljs$core$IFn$_invoke$arity$variadic = (function (env,mutation_helper,args){
new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796),cljs.core.fn_QMARK_,cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_),fulcro.incubator.spec_helpers._EQ__GT_,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","env","fulcro.incubator.ui-state-machines/env",30108796)], null);

return cljs.core.apply.call(null,cljs.core.update,env,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","state-map","fulcro.incubator.ui-state-machines/state-map",1134981111),mutation_helper,args);
});

fulcro.incubator.ui_state_machines.apply_action.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.incubator.ui_state_machines.apply_action.cljs$lang$applyTo = (function (seq74130){
var G__74131 = cljs.core.first.call(null,seq74130);
var seq74130__$1 = cljs.core.next.call(null,seq74130);
var G__74132 = cljs.core.first.call(null,seq74130__$1);
var seq74130__$2 = cljs.core.next.call(null,seq74130__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74131,G__74132,seq74130__$2);
});

/**
 * Get the name of the active state for an active state machine using a component.
 */
fulcro.incubator.ui_state_machines.get_active_state = (function fulcro$incubator$ui_state_machines$get_active_state(this$,asm_id){
return new cljs.core.Keyword("fulcro.incubator.ui-state-machines","active-state","fulcro.incubator.ui-state-machines/active-state",261201016).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword("fulcro.incubator.ui-state-machines","asm-id","fulcro.incubator.ui-state-machines/asm-id",-280598187).cljs$core$IFn$_invoke$arity$1(fulcro.client.primitives.component__GT_state_map.call(null,this$)),asm_id));
});

//# sourceMappingURL=fulcro.incubator.ui_state_machines.js.map
