goog.provide('fulcro.incubator.mutation_interface');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('fulcro.client.primitives');
fulcro.incubator.mutation_interface._STAR_checked_mutations_STAR_ = false;

/**
* @constructor
 * @implements {cljs.core.IFn}
*/
fulcro.incubator.mutation_interface.Mutation = (function (sym,param_spec){
this.sym = sym;
this.param_spec = param_spec;
this.cljs$lang$protocol_mask$partition0$ = 1;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
fulcro.incubator.mutation_interface.Mutation.prototype.call = (function (unused__10763__auto__){
var self__ = this;
var self__ = this;
var G__67430 = (arguments.length - (1));
switch (G__67430) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
});

fulcro.incubator.mutation_interface.Mutation.prototype.apply = (function (self__,args67429){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args67429)));
});

fulcro.incubator.mutation_interface.Mutation.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var this$ = this;
return this$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.incubator.mutation_interface.Mutation.prototype.cljs$core$IFn$_invoke$arity$1 = (function (args){
var self__ = this;
var this$ = this;
if(((fulcro.incubator.mutation_interface._STAR_checked_mutations_STAR_) && ((!(cljs.spec.alpha.valid_QMARK_.call(null,self__.param_spec,args)))))){
throw cljs.core.ex_info.call(null,"Mutation failed spec",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mutation","mutation",-285823378),self__.sym,new cljs.core.Keyword(null,"reason","reason",-2070751759),cljs.spec.alpha.explain.call(null,self__.param_spec,args)], null));
} else {
}

return (new cljs.core.List(null,self__.sym,(new cljs.core.List(null,args,null,(1),null)),(2),null));
});

fulcro.incubator.mutation_interface.Mutation.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"param-spec","param-spec",1645456897,null)], null);
});

fulcro.incubator.mutation_interface.Mutation.cljs$lang$type = true;

fulcro.incubator.mutation_interface.Mutation.cljs$lang$ctorStr = "fulcro.incubator.mutation-interface/Mutation";

fulcro.incubator.mutation_interface.Mutation.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"fulcro.incubator.mutation-interface/Mutation");
});

/**
 * Positional factory function for fulcro.incubator.mutation-interface/Mutation.
 */
fulcro.incubator.mutation_interface.__GT_Mutation = (function fulcro$incubator$mutation_interface$__GT_Mutation(sym,param_spec){
return (new fulcro.incubator.mutation_interface.Mutation(sym,param_spec));
});

fulcro.incubator.mutation_interface.mutation_declaration_QMARK_ = (function fulcro$incubator$mutation_interface$mutation_declaration_QMARK_(expr){
return cljs.core._EQ_.call(null,fulcro.incubator.mutation_interface.Mutation,cljs.core.type.call(null,expr));
});
/**
 * Return the real symbol (for mutation dispatch) of `mutation`, which can be a symbol (this function is then identity)
 * or a mutation-declaration.
 */
fulcro.incubator.mutation_interface.mutation_symbol = (function fulcro$incubator$mutation_interface$mutation_symbol(mutation,params){
if(fulcro.incubator.mutation_interface.mutation_declaration_QMARK_.call(null,mutation)){
return cljs.core.first.call(null,mutation.call(null,params));
} else {
return mutation;
}
});

//# sourceMappingURL=fulcro.incubator.mutation_interface.js.map
