goog.provide('fulcro.client.impl.parser');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fulcro.logging');
goog.require('fulcro.util');
fulcro.client.impl.parser.mark_meta = (function fulcro$client$impl$parser$mark_meta(source,target){
var G__55128 = target;
if(cljs.core.truth_(cljs.core.meta.call(null,source))){
return cljs.core.assoc.call(null,G__55128,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta.call(null,source));
} else {
return G__55128;
}
});
fulcro.client.impl.parser.symbol__GT_ast = (function fulcro$client$impl$parser$symbol__GT_ast(k){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),k,new cljs.core.Keyword(null,"key","key",-1516042587),k], null);
});
fulcro.client.impl.parser.keyword__GT_ast = (function fulcro$client$impl$parser$keyword__GT_ast(k){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"prop","prop",-515168332),new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),k,new cljs.core.Keyword(null,"key","key",-1516042587),k], null);
});
fulcro.client.impl.parser.union_entry__GT_ast = (function fulcro$client$impl$parser$union_entry__GT_ast(p__55139){
var vec__55140 = p__55139;
var k = cljs.core.nth.call(null,vec__55140,(0),null);
var v = cljs.core.nth.call(null,vec__55140,(1),null);
var component = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union-entry","union-entry",223335750),new cljs.core.Keyword(null,"union-key","union-key",1529707234),k,new cljs.core.Keyword(null,"query","query",-1288509510),v,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,fulcro.client.impl.parser.expr__GT_ast),v)], null),(((component == null))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),component], null)));
});
fulcro.client.impl.parser.union__GT_ast = (function fulcro$client$impl$parser$union__GT_ast(m){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.Keyword(null,"query","query",-1288509510),m,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,fulcro.client.impl.parser.union_entry__GT_ast),m)], null);
});
fulcro.client.impl.parser.call__GT_ast = (function fulcro$client$impl$parser$call__GT_ast(p__55151){
var vec__55152 = p__55151;
var f = cljs.core.nth.call(null,vec__55152,(0),null);
var args = cljs.core.nth.call(null,vec__55152,(1),null);
var call = vec__55152;
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),f)){
return cljs.core.assoc.call(null,fulcro.client.impl.parser.expr__GT_ast.call(null,args),new cljs.core.Keyword(null,"target","target",253001721),(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,call));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"remote","remote",-1593576576);
}
})());
} else {
var ast = cljs.core.update_in.call(null,fulcro.client.impl.parser.expr__GT_ast.call(null,f),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235)], null),cljs.core.merge,(function (){var or__4131__auto__ = args;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());
var G__55164 = fulcro.client.impl.parser.mark_meta.call(null,call,ast);
if((new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(ast) instanceof cljs.core.Symbol)){
return cljs.core.assoc.call(null,G__55164,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"call","call",-519999866));
} else {
return G__55164;
}
}
});
/**
 * Convert a query to its AST representation.
 */
fulcro.client.impl.parser.query__GT_ast = (function fulcro$client$impl$parser$query__GT_ast(query){
var component = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,query));
return cljs.core.merge.call(null,fulcro.client.impl.parser.mark_meta.call(null,query,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,fulcro.client.impl.parser.expr__GT_ast),query)], null)),(((component == null))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),component], null)));
});
fulcro.client.impl.parser.join__GT_ast = (function fulcro$client$impl$parser$join__GT_ast(join){
var query_root_QMARK_ = new cljs.core.Keyword(null,"query-root","query-root",359781888).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,join));
var vec__55176 = cljs.core.first.call(null,join);
var k = cljs.core.nth.call(null,vec__55176,(0),null);
var v = cljs.core.nth.call(null,vec__55176,(1),null);
var ast = fulcro.client.impl.parser.expr__GT_ast.call(null,k);
var type = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast)))?new cljs.core.Keyword(null,"call","call",-519999866):new cljs.core.Keyword(null,"join","join",-758861890));
var component = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
return cljs.core.merge.call(null,ast,fulcro.client.impl.parser.mark_meta.call(null,join,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"query","query",-1288509510),v], null)),(((component == null))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component","component",1555936782),component], null)),(cljs.core.truth_(query_root_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-root","query-root",359781888),true], null):null),((((typeof v === 'number') || (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),v))))?null:((cljs.core.vector_QMARK_.call(null,v))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,fulcro.client.impl.parser.expr__GT_ast),v)], null):((cljs.core.map_QMARK_.call(null,v))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.client.impl.parser.union__GT_ast.call(null,v)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid join, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(join)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("error","invalid-join","error/invalid-join",1594073006)], null))})()
))));
});
fulcro.client.impl.parser.ident__GT_ast = (function fulcro$client$impl$parser$ident__GT_ast(p__55205){
var vec__55208 = p__55205;
var k = cljs.core.nth.call(null,vec__55208,(0),null);
var id = cljs.core.nth.call(null,vec__55208,(1),null);
var ref = vec__55208;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"prop","prop",-515168332),new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),k,new cljs.core.Keyword(null,"key","key",-1516042587),ref], null);
});
/**
 * Given a query expression convert it into an AST.
 */
fulcro.client.impl.parser.expr__GT_ast = (function fulcro$client$impl$parser$expr__GT_ast(x){
if((x instanceof cljs.core.Symbol)){
return fulcro.client.impl.parser.symbol__GT_ast.call(null,x);
} else {
if((x instanceof cljs.core.Keyword)){
return fulcro.client.impl.parser.keyword__GT_ast.call(null,x);
} else {
if(cljs.core.map_QMARK_.call(null,x)){
return fulcro.client.impl.parser.join__GT_ast.call(null,x);
} else {
if(cljs.core.vector_QMARK_.call(null,x)){
return fulcro.client.impl.parser.ident__GT_ast.call(null,x);
} else {
if(cljs.core.seq_QMARK_.call(null,x)){
return fulcro.client.impl.parser.call__GT_ast.call(null,x);
} else {
throw cljs.core.ex_info.call(null,["Invalid expression ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("error","invalid-expression","error/invalid-expression",-881565136)], null));

}
}
}
}
}
});
fulcro.client.impl.parser.wrap_expr = (function fulcro$client$impl$parser$wrap_expr(root_QMARK_,expr){
if(cljs.core.truth_(root_QMARK_)){
return cljs.core.with_meta.call(null,(function (){var G__55221 = expr;
if((expr instanceof cljs.core.Keyword)){
return (new cljs.core.List(null,G__55221,null,(1),null));
} else {
return G__55221;
}
})(),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-root","query-root",359781888),true], null));
} else {
return expr;
}
});
fulcro.client.impl.parser.parameterize = (function fulcro$client$impl$parser$parameterize(expr,params){
if((!(cljs.core.empty_QMARK_.call(null,params)))){
return (new cljs.core.List(null,expr,(new cljs.core.List(null,params,null,(1),null)),(2),null));
} else {
return (new cljs.core.List(null,expr,null,(1),null));
}
});
/**
 * Given a query expression AST convert it back into a query expression.
 */
fulcro.client.impl.parser.ast__GT_expr = (function fulcro$client$impl$parser$ast__GT_expr(var_args){
var G__55235 = arguments.length;
switch (G__55235) {
case 1:
return fulcro.client.impl.parser.ast__GT_expr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.parser.ast__GT_expr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.parser.ast__GT_expr.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return fulcro.client.impl.parser.ast__GT_expr.call(null,ast,false);
});

fulcro.client.impl.parser.ast__GT_expr.cljs$core$IFn$_invoke$arity$2 = (function (p__55239,unparse_QMARK_){
var map__55240 = p__55239;
var map__55240__$1 = (((((!((map__55240 == null))))?(((((map__55240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55240):map__55240);
var ast = map__55240__$1;
var ast_meta = cljs.core.get.call(null,map__55240__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var type = cljs.core.get.call(null,map__55240__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var component = cljs.core.get.call(null,map__55240__$1,new cljs.core.Keyword(null,"component","component",1555936782));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"root","root",-448657453),type)){
var G__55250 = cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,ast_meta),cljs.core.map.call(null,((function (map__55240,map__55240__$1,ast,ast_meta,type,component){
return (function (p1__55227_SHARP_){
return fulcro.client.impl.parser.ast__GT_expr.call(null,p1__55227_SHARP_,unparse_QMARK_);
});})(map__55240,map__55240__$1,ast,ast_meta,type,component))
),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast));
if((!((component == null)))){
return cljs.core.vary_meta.call(null,G__55250,cljs.core.assoc,new cljs.core.Keyword(null,"component","component",1555936782),component);
} else {
return G__55250;
}
} else {
var map__55260 = ast;
var map__55260__$1 = (((((!((map__55260 == null))))?(((((map__55260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55260):map__55260);
var key = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var query = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var query_root = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"query-root","query-root",359781888));
var params = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"params","params",710516235));
return fulcro.client.impl.parser.wrap_expr.call(null,query_root,(cljs.core.truth_((function (){var and__4120__auto__ = params;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type);
} else {
return and__4120__auto__;
}
})())?(function (){var expr = fulcro.client.impl.parser.ast__GT_expr.call(null,cljs.core.dissoc.call(null,ast,new cljs.core.Keyword(null,"params","params",710516235)),unparse_QMARK_);
return fulcro.client.impl.parser.parameterize.call(null,expr,params);
})():(function (){var key__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type))?fulcro.client.impl.parser.parameterize.call(null,key,params):key);
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"join","join",-758861890),type);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type);
if(and__4120__auto__){
return new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast);
} else {
return and__4120__auto__;
}
}
})())){
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),query)) && ((!(typeof query === 'number'))) && (((unparse_QMARK_ === true) || (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type)))))){
var map__55282 = ast;
var map__55282__$1 = (((((!((map__55282 == null))))?(((((map__55282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55282):map__55282);
var children = cljs.core.get.call(null,map__55282__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var query_meta = cljs.core.meta.call(null,query);
if(((((1) === cljs.core.count.call(null,children))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,children)))))){
return cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([key__$1,cljs.core.into.call(null,(function (){var G__55296 = cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,ast_meta);
if(cljs.core.truth_(component)){
return cljs.core.vary_meta.call(null,G__55296,cljs.core.assoc,new cljs.core.Keyword(null,"component","component",1555936782),component);
} else {
return G__55296;
}
})(),cljs.core.map.call(null,((function (map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component){
return (function (p__55306){
var map__55307 = p__55306;
var map__55307__$1 = (((((!((map__55307 == null))))?(((((map__55307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55307.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55307):map__55307);
var union_key = cljs.core.get.call(null,map__55307__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var children__$1 = cljs.core.get.call(null,map__55307__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var component__$1 = cljs.core.get.call(null,map__55307__$1,new cljs.core.Keyword(null,"component","component",1555936782));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [union_key,(function (){var G__55309 = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (map__55307,map__55307__$1,union_key,children__$1,component__$1,map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component){
return (function (p1__55230_SHARP_){
return fulcro.client.impl.parser.ast__GT_expr.call(null,p1__55230_SHARP_,unparse_QMARK_);
});})(map__55307,map__55307__$1,union_key,children__$1,component__$1,map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component))
),children__$1);
if((!((component__$1 == null)))){
return cljs.core.vary_meta.call(null,G__55309,cljs.core.assoc,new cljs.core.Keyword(null,"component","component",1555936782),component__$1);
} else {
return G__55309;
}
})()], null);
});})(map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component))
),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,children)))]),ast_meta);
} else {
return cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([key__$1,(function (){var G__55315 = cljs.core.into.call(null,cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,query_meta),cljs.core.map.call(null,((function (map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component){
return (function (p1__55231_SHARP_){
return fulcro.client.impl.parser.ast__GT_expr.call(null,p1__55231_SHARP_,unparse_QMARK_);
});})(map__55282,map__55282__$1,children,query_meta,key__$1,map__55260,map__55260__$1,key,query,query_root,params,map__55240,map__55240__$1,ast,ast_meta,type,component))
),children);
if((!((component == null)))){
return cljs.core.vary_meta.call(null,G__55315,cljs.core.assoc,new cljs.core.Keyword(null,"component","component",1555936782),component);
} else {
return G__55315;
}
})()]),ast_meta);
}
} else {
return cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([key__$1,query]),ast_meta);
}
} else {
return key__$1;
}
})()));
}
});

fulcro.client.impl.parser.ast__GT_expr.cljs$lang$maxFixedArity = 2;

/**
 * Add path metadata to a data structure. data is the data to be worked on.
 * path is the current path into the data. query is the query used to
 * walk the data. union-expr tracks the last seen union query to be used
 * when it finds a recursive union.
 */
fulcro.client.impl.parser.path_meta = (function fulcro$client$impl$parser$path_meta(var_args){
var G__55341 = arguments.length;
switch (G__55341) {
case 3:
return fulcro.client.impl.parser.path_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fulcro.client.impl.parser.path_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.parser.path_meta.cljs$core$IFn$_invoke$arity$3 = (function (data,path,query){
return fulcro.client.impl.parser.path_meta.call(null,data,path,query,null);
});

fulcro.client.impl.parser.path_meta.cljs$core$IFn$_invoke$arity$4 = (function (data,path,query,union_expr){
if((query == null)){
var G__55347 = data;
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IWithMeta$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWithMeta,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWithMeta,data))){
return cljs.core.vary_meta.call(null,G__55347,cljs.core.assoc,new cljs.core.Keyword("fulcro.client.impl.parser","data-path","fulcro.client.impl.parser/data-path",1793359026),path);
} else {
return G__55347;
}
} else {
if(cljs.core.sequential_QMARK_.call(null,data)){
return cljs.core.vary_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map_indexed.call(null,(function (idx,v){
return fulcro.client.impl.parser.path_meta.call(null,v,cljs.core.conj.call(null,path,idx),query,union_expr);
})),data),cljs.core.assoc,new cljs.core.Keyword("fulcro.client.impl.parser","data-path","fulcro.client.impl.parser/data-path",1793359026),path);
} else {
if(cljs.core.vector_QMARK_.call(null,query)){
var joins = cljs.core.seq.call(null,query);
var ret = data;
while(true){
if((!((joins == null)))){
var join = cljs.core.first.call(null,joins);
if((!(((fulcro.util.join_QMARK_.call(null,join)) || (fulcro.util.ident_QMARK_.call(null,join)) || (((cljs.core.seq_QMARK_.call(null,join)) && (fulcro.util.ident_QMARK_.call(null,cljs.core.first.call(null,join))))))))){
var G__55605 = cljs.core.next.call(null,joins);
var G__55606 = ret;
joins = G__55605;
ret = G__55606;
continue;
} else {
var join__$1 = (function (){var G__55362 = join;
if(cljs.core.seq_QMARK_.call(null,join)){
return cljs.core.first.call(null,G__55362);
} else {
return G__55362;
}
})();
var join__$2 = (function (){var G__55363 = join__$1;
if(fulcro.util.ident_QMARK_.call(null,join__$1)){
return cljs.core.PersistentHashMap.fromArrays([G__55363],[new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null)]);
} else {
return G__55363;
}
})();
var vec__55359 = fulcro.util.join_entry.call(null,join__$2);
var key = cljs.core.nth.call(null,vec__55359,(0),null);
var sel = cljs.core.nth.call(null,vec__55359,(1),null);
var union_entry = ((fulcro.util.union_QMARK_.call(null,join__$2))?sel:union_expr);
var sel__$1 = ((fulcro.util.recursion_QMARK_.call(null,sel))?(((!((union_expr == null))))?union_entry:query):sel);
var key__$1 = (function (){var G__55366 = key;
if(fulcro.util.unique_ident_QMARK_.call(null,key)){
return cljs.core.first.call(null,G__55366);
} else {
return G__55366;
}
})();
var v = cljs.core.get.call(null,ret,key__$1);
var G__55611 = cljs.core.next.call(null,joins);
var G__55612 = (function (){var G__55367 = ret;
if(((cljs.core.map_QMARK_.call(null,ret)) && (cljs.core.contains_QMARK_.call(null,ret,key__$1)))){
return cljs.core.assoc.call(null,G__55367,key__$1,fulcro.client.impl.parser.path_meta.call(null,v,cljs.core.conj.call(null,path,key__$1),sel__$1,union_entry));
} else {
return G__55367;
}
})();
joins = G__55611;
ret = G__55612;
continue;
}
} else {
var G__55369 = ret;
if((((!((ret == null))))?(((((ret.cljs$lang$protocol_mask$partition0$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === ret.cljs$core$IWithMeta$))))?true:(((!ret.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWithMeta,ret):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWithMeta,ret))){
return cljs.core.vary_meta.call(null,G__55369,cljs.core.assoc,new cljs.core.Keyword("fulcro.client.impl.parser","data-path","fulcro.client.impl.parser/data-path",1793359026),path);
} else {
return G__55369;
}
}
break;
}
} else {
if(cljs.core.map_QMARK_.call(null,data)){
var dispatch_key = cljs.core.comp.call(null,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),fulcro.client.impl.parser.expr__GT_ast);
var branches = cljs.core.vals.call(null,query);
var props = cljs.core.map.call(null,dispatch_key,cljs.core.keys.call(null,data));
var query__$1 = cljs.core.reduce.call(null,((function (dispatch_key,branches,props){
return (function (ret,q){
var query_props = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,dispatch_key),q);
var props__$1 = cljs.core.set.call(null,props);
if(cljs.core._EQ_.call(null,cljs.core.set.call(null,props__$1),cljs.core.set.call(null,query_props))){
return cljs.core.reduced.call(null,q);
} else {
if(clojure.set.subset_QMARK_.call(null,props__$1,query_props)){
return q;
} else {
return ret;

}
}
});})(dispatch_key,branches,props))
,null,branches);
return fulcro.client.impl.parser.path_meta.call(null,data,path,query__$1,union_expr);
} else {
return data;
}

}
}
}
});

fulcro.client.impl.parser.path_meta.cljs$lang$maxFixedArity = 4;

fulcro.client.impl.parser.rethrow_QMARK_ = (function fulcro$client$impl$parser$rethrow_QMARK_(x){
return (((x instanceof cljs.core.ExceptionInfo)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.primitives","abort","fulcro.client.primitives/abort",-2106449038),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,x)))));
});
/**
 * Given the result (and query) of an ident-based query like:
 * 
 *   [{[:TABLE :ID] (get-query C)}]
 * 
 *   a query response data tree:
 * 
 *   { [:TABLE :ID] { ...props for C...} }
 * 
 *   and a replacement-root-path such as [:ROOT/subcomponent :subcomponent/items 0],
 *   adds path metadata to the val (props for C) of that data tree as-if it had been
 *   queried from the UI root (replacement-root-path). E.g. the path metadata on the val (props of C) will
 *   START at replacement-root-path.
 */
fulcro.client.impl.parser.substitute_root_path_for_ident = (function fulcro$client$impl$parser$substitute_root_path_for_ident(data_tree,replacement_root_path,query){
var join_ast_node = cljs.core.first.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(fulcro.client.impl.parser.query__GT_ast.call(null,query)));
var map__55395 = join_ast_node;
var map__55395__$1 = (((((!((map__55395 == null))))?(((((map__55395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55395.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55395):map__55395);
var subquery = cljs.core.get.call(null,map__55395__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var key = cljs.core.get.call(null,map__55395__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var real_data_tree_of_interest = cljs.core.get.call(null,data_tree,key);
var result = fulcro.client.impl.parser.path_meta.call(null,real_data_tree_of_interest,replacement_root_path,subquery);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([key,result]);
});
/**
 * Given a :read and/or :mutate function return a parser. Refer to fulcro.client.primitives/parser
 * for top level documentation.
 */
fulcro.client.impl.parser.parser = (function fulcro$client$impl$parser$parser(p__55408){
var map__55411 = p__55408;
var map__55411__$1 = (((((!((map__55411 == null))))?(((((map__55411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55411):map__55411);
var config = map__55411__$1;
var read = cljs.core.get.call(null,map__55411__$1,new cljs.core.Keyword(null,"read","read",1140058661));
var mutate = cljs.core.get.call(null,map__55411__$1,new cljs.core.Keyword(null,"mutate","mutate",1422419038));
return ((function (map__55411,map__55411__$1,config,read,mutate){
return (function() {
var fulcro$client$impl$parser$parser_$_self = null;
var fulcro$client$impl$parser$parser_$_self__2 = (function (env,query){
return fulcro$client$impl$parser$parser_$_self.call(null,env,query,null);
});
var fulcro$client$impl$parser$parser_$_self__3 = (function (env,query,target){
var target__$1 = (function (){var or__4131__auto__ = target;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(env);
}
})();
var map__55417 = (function (){var G__55418 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"parser","parser",-1543495310),fulcro$client$impl$parser$parser_$_self,new cljs.core.Keyword(null,"target","target",253001721),target__$1,new cljs.core.Keyword(null,"query-root","query-root",359781888),new cljs.core.Keyword("fulcro.client.primitives","root","fulcro.client.primitives/root",-1042228161));
if((!(cljs.core.contains_QMARK_.call(null,env,new cljs.core.Keyword(null,"path","path",-188191168))))){
return cljs.core.assoc.call(null,G__55418,new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.PersistentVector.EMPTY);
} else {
return G__55418;
}
})();
var map__55417__$1 = (((((!((map__55417 == null))))?(((((map__55417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55417):map__55417);
var env__$1 = map__55417__$1;
var replacement_root_path = cljs.core.get.call(null,map__55417__$1,new cljs.core.Keyword(null,"replacement-root-path","replacement-root-path",-1563938351));
var path = cljs.core.get.call(null,map__55417__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var step = ((function (target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate){
return (function fulcro$client$impl$parser$parser_$_self_$_step(ret,expr){
var map__55445 = fulcro.client.impl.parser.expr__GT_ast.call(null,expr);
var map__55445__$1 = (((((!((map__55445 == null))))?(((((map__55445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55445.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55445):map__55445);
var ast = map__55445__$1;
var query_SINGLEQUOTE_ = cljs.core.get.call(null,map__55445__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var key = cljs.core.get.call(null,map__55445__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var dispatch_key = cljs.core.get.call(null,map__55445__$1,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510));
var params = cljs.core.get.call(null,map__55445__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env__$2 = (function (){var G__55449 = cljs.core.merge.call(null,env__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ast","ast",-860334068),ast,new cljs.core.Keyword(null,"query","query",-1288509510),query_SINGLEQUOTE_], null));
var G__55449__$1 = (((query_SINGLEQUOTE_ == null))?cljs.core.dissoc.call(null,G__55449,new cljs.core.Keyword(null,"query","query",-1288509510)):G__55449);
var G__55449__$2 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),query_SINGLEQUOTE_))?cljs.core.assoc.call(null,G__55449__$1,new cljs.core.Keyword(null,"query","query",-1288509510),query):G__55449__$1);
if(cljs.core.vector_QMARK_.call(null,key)){
return cljs.core.assoc.call(null,G__55449__$2,new cljs.core.Keyword(null,"query-root","query-root",359781888),key);
} else {
return G__55449__$2;
}
})();
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(ast);
var call_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"call","call",-519999866),type);
var res = (function (){var G__55454 = type;
var G__55454__$1 = (((G__55454 instanceof cljs.core.Keyword))?G__55454.fqn:null);
switch (G__55454__$1) {
case "call":
if(cljs.core.truth_(mutate)){
} else {
throw (new Error(["Assert failed: ","Parse mutation attempted but no :mutate function supplied","\n","mutate"].join('')));
}

return mutate.call(null,env__$2,dispatch_key,params);

break;
case "prop":
case "join":
case "union":
if(cljs.core.truth_(read)){
} else {
throw (new Error(["Assert failed: ","Parse read attempted but no :read function supplied","\n","read"].join('')));
}

return read.call(null,env__$2,dispatch_key,params);

break;
default:
return null;

}
})();
if((!((target__$1 == null)))){
var ast_SINGLEQUOTE_ = cljs.core.get.call(null,res,target__$1);
var G__55455 = ret;
var G__55455__$1 = ((ast_SINGLEQUOTE_ === true)?cljs.core.conj.call(null,G__55455,expr):G__55455);
var G__55455__$2 = ((cljs.core.map_QMARK_.call(null,ast_SINGLEQUOTE_))?cljs.core.conj.call(null,G__55455__$1,fulcro.client.impl.parser.ast__GT_expr.call(null,ast_SINGLEQUOTE_)):G__55455__$1);
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.vary_meta.call(null,G__55455__$2,cljs.core.update,new cljs.core.Keyword("fulcro.client.primitives","refresh","fulcro.client.primitives/refresh",481513561),((function (G__55455,G__55455__$1,G__55455__$2,ast_SINGLEQUOTE_,map__55445,map__55445__$1,ast,query_SINGLEQUOTE_,key,dispatch_key,params,env__$2,type,call_QMARK_,res,target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate){
return (function (p1__55401_SHARP_,p2__55402_SHARP_){
return cljs.core.into.call(null,(function (){var or__4131__auto__ = p1__55401_SHARP_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),p2__55402_SHARP_);
});})(G__55455,G__55455__$1,G__55455__$2,ast_SINGLEQUOTE_,map__55445,map__55445__$1,ast,query_SINGLEQUOTE_,key,dispatch_key,params,env__$2,type,call_QMARK_,res,target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate))
,new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(res));
} else {
return G__55455__$2;
}
} else {
if((!(((call_QMARK_) || ((new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(ast) == null)) || (cljs.core.contains_QMARK_.call(null,res,new cljs.core.Keyword(null,"value","value",305978217))))))){
return ret;
} else {
var error = cljs.core.atom.call(null,null);
var mut_ret = cljs.core.atom.call(null,null);
if(((call_QMARK_) && ((!((new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(res) == null)))))){
try{cljs.core.reset_BANG_.call(null,mut_ret,new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(res).call(null));
}catch (e55458){var e_55640 = e55458;
if(fulcro.client.impl.parser.rethrow_QMARK_.call(null,e_55640)){
throw e_55640;
} else {
cljs.core.reset_BANG_.call(null,error,e_55640);
}
}} else {
}

var value = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res);
if(call_QMARK_){
if((((value == null)) || (cljs.core.map_QMARK_.call(null,value)))){
} else {
throw (new Error(["Assert failed: ",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dispatch_key)," mutation :value must be nil or a map with structure {:refresh [...]}"].join(''),"\n","(or (nil? value) (map? value))"].join('')));
}
} else {
}

var G__55463 = ret;
var G__55463__$1 = (((!((value == null))))?cljs.core.assoc.call(null,G__55463,(function (){var G__55464 = key;
if(fulcro.util.unique_ident_QMARK_.call(null,key)){
return cljs.core.first.call(null,G__55464);
} else {
return G__55464;
}
})(),value):G__55463);
var G__55463__$2 = (cljs.core.truth_(cljs.core.deref.call(null,mut_ret))?cljs.core.assoc_in.call(null,G__55463__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,new cljs.core.Keyword(null,"result","result",1415092211)], null),cljs.core.deref.call(null,mut_ret)):G__55463__$1);
var G__55463__$3 = ((cljs.core.seq.call(null,new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(res)))?cljs.core.vary_meta.call(null,G__55463__$2,cljs.core.update,new cljs.core.Keyword("fulcro.client.primitives","refresh","fulcro.client.primitives/refresh",481513561),((function (G__55463,G__55463__$1,G__55463__$2,value,error,mut_ret,map__55445,map__55445__$1,ast,query_SINGLEQUOTE_,key,dispatch_key,params,env__$2,type,call_QMARK_,res,target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate){
return (function (p1__55405_SHARP_,p2__55406_SHARP_){
return cljs.core.into.call(null,(function (){var or__4131__auto__ = p1__55405_SHARP_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),p2__55406_SHARP_);
});})(G__55463,G__55463__$1,G__55463__$2,value,error,mut_ret,map__55445,map__55445__$1,ast,query_SINGLEQUOTE_,key,dispatch_key,params,env__$2,type,call_QMARK_,res,target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate))
,new cljs.core.Keyword(null,"refresh","refresh",1947415525).cljs$core$IFn$_invoke$arity$1(res)):G__55463__$2);
if(cljs.core.truth_(cljs.core.deref.call(null,error))){
return cljs.core.assoc.call(null,G__55463__$3,key,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.primitives","error","fulcro.client.primitives/error",1510344092),cljs.core.deref.call(null,error)], null));
} else {
return G__55463__$3;
}
}
}
});})(target__$1,map__55417,map__55417__$1,env__$1,replacement_root_path,path,map__55411,map__55411__$1,config,read,mutate))
;
var G__55468 = cljs.core.reduce.call(null,step,(((target__$1 == null))?cljs.core.PersistentArrayMap.EMPTY:cljs.core.PersistentVector.EMPTY),query);
var G__55468__$1 = (((target__$1 == null))?fulcro.client.impl.parser.path_meta.call(null,G__55468,path,query):G__55468);
if(cljs.core.truth_(replacement_root_path)){
return fulcro.client.impl.parser.substitute_root_path_for_ident.call(null,G__55468__$1,replacement_root_path,query);
} else {
return G__55468__$1;
}
});
fulcro$client$impl$parser$parser_$_self = function(env,query,target){
switch(arguments.length){
case 2:
return fulcro$client$impl$parser$parser_$_self__2.call(this,env,query);
case 3:
return fulcro$client$impl$parser$parser_$_self__3.call(this,env,query,target);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fulcro$client$impl$parser$parser_$_self.cljs$core$IFn$_invoke$arity$2 = fulcro$client$impl$parser$parser_$_self__2;
fulcro$client$impl$parser$parser_$_self.cljs$core$IFn$_invoke$arity$3 = fulcro$client$impl$parser$parser_$_self__3;
return fulcro$client$impl$parser$parser_$_self;
})()
;})(map__55411,map__55411__$1,config,read,mutate))
});
fulcro.client.impl.parser.dispatch = (function fulcro$client$impl$parser$dispatch(_,k,___$1){
return k;
});

//# sourceMappingURL=fulcro.client.impl.parser.js.map
