goog.provide('fulcro_css.css_injection');
goog.require('cljs.core');
goog.require('fulcro.client.primitives');
goog.require('cljs.spec.alpha');
goog.require('garden.core');
goog.require('fulcro_css.css');
goog.require('fulcro.logging');
goog.require('fulcro.client.dom');
fulcro_css.css_injection.component_css_includes_with_depth = (function fulcro_css$css_injection$component_css_includes_with_depth(component,breadth,depth){
var includes = fulcro_css.css.get_includes.call(null,component);
return cljs.core.into.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (includes){
return (function (p1__68221_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("fulcro-css.css-injection","depth","fulcro-css.css-injection/depth",1176672176),new cljs.core.Keyword("fulcro-css.css-injection","breadth","fulcro-css.css-injection/breadth",401097606),new cljs.core.Keyword("fulcro-css.css-injection","component","fulcro-css.css-injection/component",-518469322)],[(depth + (1)),breadth,p1__68221_SHARP_]);
});})(includes))
),includes),cljs.core.mapcat.call(null,((function (includes){
return (function (p1__68222_SHARP_){
return fulcro_css.css_injection.component_css_includes_with_depth.call(null,p1__68222_SHARP_,breadth,(depth + (1)));
});})(includes))
,includes));
});
/**
 * Scan the given component and return an ordered vector of the css rules in depth-first order.
 *   `order` can be :depth-first (default) or :breadth-first
 */
fulcro_css.css_injection.find_css_nodes = (function fulcro_css$css_injection$find_css_nodes(p__68234){
var map__68236 = p__68234;
var map__68236__$1 = (((((!((map__68236 == null))))?(((((map__68236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68236):map__68236);
var component = cljs.core.get.call(null,map__68236__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var order = cljs.core.get.call(null,map__68236__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var state_map = cljs.core.get.call(null,map__68236__$1,new cljs.core.Keyword(null,"state-map","state-map",-1313872128));
var query = ((cljs.core.map_QMARK_.call(null,state_map))?fulcro.client.primitives.get_query.call(null,component,state_map):fulcro.client.primitives.get_query.call(null,component));
var ast = fulcro.client.primitives.query__GT_ast.call(null,query);
var breadth = cljs.core.atom.call(null,(0));
var traverse = ((function (query,ast,breadth,map__68236,map__68236__$1,component,order,state_map){
return (function fulcro_css$css_injection$find_css_nodes_$_traverse_STAR_(p__68246,depth){
var map__68247 = p__68246;
var map__68247__$1 = (((((!((map__68247 == null))))?(((((map__68247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68247.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68247):map__68247);
var children = cljs.core.get.call(null,map__68247__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var component__$1 = cljs.core.get.call(null,map__68247__$1,new cljs.core.Keyword(null,"component","component",1555936782));
return cljs.core.into.call(null,(cljs.core.truth_((function (){var and__4120__auto__ = component__$1;
if(cljs.core.truth_(and__4120__auto__)){
return fulcro_css.css.CSS_QMARK_.call(null,component__$1);
} else {
return and__4120__auto__;
}
})())?cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro-css.css-injection","depth","fulcro-css.css-injection/depth",1176672176),depth,new cljs.core.Keyword("fulcro-css.css-injection","breadth","fulcro-css.css-injection/breadth",401097606),cljs.core.swap_BANG_.call(null,breadth,cljs.core.inc),new cljs.core.Keyword("fulcro-css.css-injection","component","fulcro-css.css-injection/component",-518469322),component__$1], null)], null),fulcro_css.css_injection.component_css_includes_with_depth.call(null,component__$1,cljs.core.deref.call(null,breadth),depth)):cljs.core.PersistentVector.EMPTY),cljs.core.mapcat.call(null,((function (map__68247,map__68247__$1,children,component__$1,query,ast,breadth,map__68236,map__68236__$1,component,order,state_map){
return (function (p1__68228_SHARP_){
return fulcro_css$css_injection$find_css_nodes_$_traverse_STAR_.call(null,p1__68228_SHARP_,(depth + (1)));
});})(map__68247,map__68247__$1,children,component__$1,query,ast,breadth,map__68236,map__68236__$1,component,order,state_map))
,cljs.core.seq.call(null,children)));
});})(query,ast,breadth,map__68236,map__68236__$1,component,order,state_map))
;
var nodes = traverse(ast,(0));
var ordered_nodes = ((cljs.core._EQ_.call(null,order,new cljs.core.Keyword(null,"breadth-first","breadth-first",141527627)))?cljs.core.sort_by.call(null,new cljs.core.Keyword("fulcro-css.css-injection","breadth","fulcro-css.css-injection/breadth",401097606),nodes):cljs.core.sort_by.call(null,((function (query,ast,breadth,traverse,nodes,map__68236,map__68236__$1,component,order,state_map){
return (function (p1__68230_SHARP_){
return (- new cljs.core.Keyword("fulcro-css.css-injection","depth","fulcro-css.css-injection/depth",1176672176).cljs$core$IFn$_invoke$arity$1(p1__68230_SHARP_));
});})(query,ast,breadth,traverse,nodes,map__68236,map__68236__$1,component,order,state_map))
,nodes));
var unique_nodes = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword("fulcro-css.css-injection","component","fulcro-css.css-injection/component",-518469322),ordered_nodes));
if(cljs.core.truth_(query)){
} else {
try{fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro-css.css-injection",new cljs.core.Keyword(null,"line","line",212345235),42], null),new cljs.core.Keyword(null,"error","error",-978969032),"Auto-include was used for CSS, but the component had no query! No CSS Found.");
}catch (e68252){if((e68252 instanceof Error)){
var e__54502__auto___68446 = e68252;
fulcro.logging._log.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"fulcro-css.css-injection",new cljs.core.Keyword(null,"line","line",212345235),42], null),new cljs.core.Keyword(null,"error","error",-978969032),"Log statement failed (arguments did not evaluate).",e__54502__auto___68446);
} else {
throw e68252;

}
}}

return unique_nodes;
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("fulcro-css.css-injection","find-css-nodes","fulcro-css.css-injection/find-css-nodes",-1611178617,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),cljs.core.seq_QMARK_,null,null),new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),null,null,null));
var get_rules_68452 = (function (components){
return cljs.core.reduce.call(null,(function (p1__68258_SHARP_,p2__68260_SHARP_){
return cljs.core.into.call(null,p1__68258_SHARP_,fulcro_css.css.get_css_rules.call(null,p2__68260_SHARP_));
}),cljs.core.PersistentVector.EMPTY,components);
});
/**
 * Compute the stringified CSS based on the given props. This can be used to generate a
 *  server-side version of CSS for the initial DOM, and is used the other injection functions to compute
 *  the CSS.
 * 
 *  Props are as described in `style-element`.
 *  
 */
fulcro_css.css_injection.compute_css = ((function (get_rules_68452){
return (function fulcro_css$css_injection$compute_css(props){
var map__68268 = props;
var map__68268__$1 = (((((!((map__68268 == null))))?(((((map__68268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68268):map__68268);
var component = cljs.core.get.call(null,map__68268__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var auto_include_QMARK_ = cljs.core.get.call(null,map__68268__$1,new cljs.core.Keyword(null,"auto-include?","auto-include?",-351901260));
var rules = ((auto_include_QMARK_ === false)?(function (){var G__68286 = component;
if((G__68286 == null)){
return null;
} else {
return fulcro_css.css.get_css.call(null,G__68286);
}
})():(function (){var G__68287 = fulcro_css.css_injection.find_css_nodes.call(null,props);
if((G__68287 == null)){
return null;
} else {
return get_rules_68452(G__68287);
}
})());
var css = garden.core.css.call(null,rules);
return css;
});})(get_rules_68452))
;
if((typeof fulcro_css !== 'undefined') && (typeof fulcro_css.css_injection !== 'undefined') && (typeof fulcro_css.css_injection.StyleElement !== 'undefined')){
} else {
/**
 * @constructor
 * @nocollapse
 */
fulcro_css.css_injection.StyleElement = (function fulcro_css$css_injection$StyleElement(){
var this__60617__auto__ = this;
React.Component.apply(this__60617__auto__,arguments);

if((!((this__60617__auto__.initLocalState == null)))){
this__60617__auto__.state = this__60617__auto__.initLocalState();
} else {
this__60617__auto__.state = ({});
}

return this__60617__auto__;
});

goog.object.extend(fulcro_css.css_injection.StyleElement.prototype,React.Component.prototype,fulcro.client.primitives.default_component_prototype);
}

fulcro.client.primitives._register_component_BANG_.call(null,new cljs.core.Keyword("fulcro-css.css-injection","StyleElement","fulcro-css.css-injection/StyleElement",-325653727),fulcro_css.css_injection.StyleElement);

var x68299_68460 = fulcro_css.css_injection.StyleElement.prototype;
x68299_68460.render = ((function (x68299_68460){
return (function (){
var this__59535__auto__ = this;
var this$ = this__59535__auto__;
var _STAR_reconciler_STAR__orig_val__68300 = fulcro.client.primitives._STAR_reconciler_STAR_;
var _STAR_depth_STAR__orig_val__68301 = fulcro.client.primitives._STAR_depth_STAR_;
var _STAR_shared_STAR__orig_val__68302 = fulcro.client.primitives._STAR_shared_STAR_;
var _STAR_instrument_STAR__orig_val__68303 = fulcro.client.primitives._STAR_instrument_STAR_;
var _STAR_parent_STAR__orig_val__68304 = fulcro.client.primitives._STAR_parent_STAR_;
var _STAR_reconciler_STAR__temp_val__68305 = fulcro.client.primitives.get_reconciler.call(null,this__59535__auto__);
var _STAR_depth_STAR__temp_val__68306 = (fulcro.client.primitives.depth.call(null,this__59535__auto__) + (1));
var _STAR_shared_STAR__temp_val__68307 = fulcro.client.primitives.shared.call(null,this__59535__auto__);
var _STAR_instrument_STAR__temp_val__68308 = fulcro.client.primitives.instrument.call(null,this__59535__auto__);
var _STAR_parent_STAR__temp_val__68309 = this__59535__auto__;
fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__temp_val__68305;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__temp_val__68306;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__temp_val__68307;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__temp_val__68308;

fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__temp_val__68309;

try{var map__68315 = fulcro.client.primitives.props.call(null,this$);
var map__68315__$1 = (((((!((map__68315 == null))))?(((((map__68315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68315):map__68315);
var order = cljs.core.get.call(null,map__68315__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var key = cljs.core.get.call(null,map__68315__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
return fulcro.client.dom.macro_create_element.call(null,"style",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dangerouslySetInnerHTML","dangerouslySetInnerHTML",-554971138),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__html","__html",674048345),fulcro.client.primitives.get_state.call(null,this$,new cljs.core.Keyword(null,"css","css",1135045163))], null)], null)], null),null);
}finally {fulcro.client.primitives._STAR_parent_STAR_ = _STAR_parent_STAR__orig_val__68304;

fulcro.client.primitives._STAR_instrument_STAR_ = _STAR_instrument_STAR__orig_val__68303;

fulcro.client.primitives._STAR_shared_STAR_ = _STAR_shared_STAR__orig_val__68302;

fulcro.client.primitives._STAR_depth_STAR_ = _STAR_depth_STAR__orig_val__68301;

fulcro.client.primitives._STAR_reconciler_STAR_ = _STAR_reconciler_STAR__orig_val__68300;
}});})(x68299_68460))
;

x68299_68460.componentDidMount = ((function (x68299_68460){
return (function (){
var this__59519__auto__ = this;
var this$ = this__59519__auto__;
var reconciler__59520__auto__ = fulcro.client.primitives.get_reconciler.call(null,this__59519__auto__);
var lifecycle__59521__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"lifecycle","lifecycle",341496205)], null));
var indexer__59522__auto__ = cljs.core.get_in.call(null,reconciler__59520__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
goog.object.set(this__59519__auto__,"fulcro$mounted",true);

if((indexer__59522__auto__ == null)){
} else {
fulcro.client.impl.protocols.index_component_BANG_(indexer__59522__auto__,this__59519__auto__);
}

if(cljs.core.truth_(lifecycle__59521__auto__)){
lifecycle__59521__auto__.call(null,this__59519__auto__,new cljs.core.Keyword(null,"mount","mount",-1560582470));
} else {
}

var css = fulcro_css.css_injection.compute_css.call(null,fulcro.client.primitives.props.call(null,this$));
return fulcro.client.primitives.set_state_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),css], null));
});})(x68299_68460))
;


fulcro_css.css_injection.StyleElement.prototype.constructor = fulcro_css.css_injection.StyleElement;

fulcro_css.css_injection.StyleElement.prototype.constructor.displayName = "fulcro-css.css-injection/StyleElement";

fulcro_css.css_injection.StyleElement.prototype.fulcro$isComponent = true;

var x68381_68478 = fulcro_css.css_injection.StyleElement;


var x68382_68480 = fulcro_css.css_injection.StyleElement.prototype;


fulcro_css.css_injection.StyleElement.cljs$lang$type = true;

fulcro_css.css_injection.StyleElement.cljs$lang$ctorStr = "fulcro-css.css-injection/StyleElement";

fulcro_css.css_injection.StyleElement.cljs$lang$ctorPrWriter = (function (this__60620__auto__,writer__60621__auto__,opt__60622__auto__){
return cljs.core._write(writer__60621__auto__,"fulcro-css.css-injection/StyleElement");
});
var factory_68481 = fulcro.client.primitives.factory.call(null,fulcro_css.css_injection.StyleElement);
/**
 * Renders a style element. Valid props are:
 * 
 *   - `:component`: (REQUIRED) The UI component to pull CSS from. Class or instance allowed.
 *   - `:order`: (optional)  `:depth-first` (default) or `:breadth-first` (legacy order)
 *   - `:react-key` : (optional) A React key. Changing the key will force it to update the CSS (which is otherwise caches for performance)
 *   - `:auto-include?`: (optional) When set to true (default) it will use the component query to recursively scan for
 *     CSS instead of explicit includes. When set to (exactly) `false` then it ONLY uses the user-declared inclusions on
 *     the component.
 * 
 *  The resulting React style element avoids re-rendering unless the props change, and the CSS is cached at component mount; therefore
 *  this element will avoid all overhead on refresh. In development you may wish to have the CSS change on hot code reload, in which case
 *  you can simply change the `:react-key` on the props to force a re-mount (which will recompute the CSS).
 *  
 */
fulcro_css.css_injection.style_element = ((function (factory_68481){
return (function fulcro_css$css_injection$style_element(props){
var component = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(props);
var props__$1 = (function (){var G__68396 = props;
if(fulcro.client.primitives.component_QMARK_.call(null,component)){
return cljs.core.update.call(null,cljs.core.assoc.call(null,G__68396,new cljs.core.Keyword(null,"state-map","state-map",-1313872128),(function (){var G__68398 = component;
if((G__68398 == null)){
return null;
} else {
return fulcro.client.primitives.component__GT_state_map.call(null,G__68398);
}
})()),new cljs.core.Keyword(null,"component","component",1555936782),fulcro.client.primitives.react_type);
} else {
return G__68396;
}
})();
return factory_68481.call(null,props__$1);
});})(factory_68481))
;
/**
 * (Re)place the STYLE element with the provided ID on the document's low-level DOM with the co-located CSS of
 *   the specified component.
 * 
 *   The `options` is the same as passed to `style-element`.
 * 
 *   ONLY WORKS FOR CLJS, since otherwise there is no DOM to change.
 */
fulcro_css.css_injection.upsert_css = (function fulcro_css$css_injection$upsert_css(id,options){
fulcro_css.css.remove_from_dom.call(null,id);

var style_ele = document.createElement("style");
var css = fulcro_css.css_injection.compute_css.call(null,options);
style_ele.innerHTML = css;

style_ele.setAttribute("id",id);

return document.body.appendChild(style_ele);
});

//# sourceMappingURL=fulcro_css.css_injection.js.map
