goog.provide('fulcro_css.css_implementation');
goog.require('cljs.core');
goog.require('cljs.tagged_literals');
goog.require('fulcro_css.css_protocols');
goog.require('clojure.string');
/**
 * Replaces slashes and dots with underscore.
 */
fulcro_css.css_implementation.cssify = (function fulcro_css$css_implementation$cssify(str){
if(cljs.core.truth_(str)){
return clojure.string.replace.call(null,str,/[.\/]/,"_");
} else {
return null;
}
});
fulcro_css.css_implementation.fq_component = (function fulcro_css$css_implementation$fq_component(comp_class){
var temp__5718__auto__ = comp_class.displayName;
if(cljs.core.truth_(temp__5718__auto__)){
var nm = temp__5718__auto__;
return nm;
} else {
return "unknown/unknown";
}
});
/**
 * Generates a string name of a localized CSS class. This function combines the fully-qualified name of the given class
 *   with the (optional) specified name.
 */
fulcro_css.css_implementation.local_class = (function fulcro_css$css_implementation$local_class(var_args){
var G__54396 = arguments.length;
switch (G__54396) {
case 1:
return fulcro_css.css_implementation.local_class.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro_css.css_implementation.local_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_css.css_implementation.local_class.cljs$core$IFn$_invoke$arity$1 = (function (comp_class){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(fulcro_css.css_implementation.cssify.call(null,fulcro_css.css_implementation.fq_component.call(null,comp_class)));
});

fulcro_css.css_implementation.local_class.cljs$core$IFn$_invoke$arity$2 = (function (comp_class,nm){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(fulcro_css.css_implementation.cssify.call(null,fulcro_css.css_implementation.fq_component.call(null,comp_class))),"__",cljs.core.name.call(null,nm)].join('');
});

fulcro_css.css_implementation.local_class.cljs$lang$maxFixedArity = 2;

fulcro_css.css_implementation.set_classname = (function fulcro_css$css_implementation$set_classname(m,subclasses){
return cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"className","className",-1983287057),subclasses),new cljs.core.Keyword(null,"class","class",-2030961996)));
});
/**
 * Returns true if the given component has css
 */
fulcro_css.css_implementation.CSS_QMARK_ = (function fulcro_css$css_implementation$CSS_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.fulcro_css$css_protocols$CSS$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Returns true if the component has global rules
 */
fulcro_css.css_implementation.Global_QMARK_ = (function fulcro_css$css_implementation$Global_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.fulcro_css$css_protocols$Global$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Get the *raw* value from the global-rules of a component.
 */
fulcro_css.css_implementation.get_global_rules = (function fulcro_css$css_implementation$get_global_rules(component){
if(fulcro_css.css_implementation.Global_QMARK_.call(null,component)){
return fulcro_css.css_protocols.global_rules(component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Get the *raw* value from the local-rules of a component.
 */
fulcro_css.css_implementation.get_local_rules = (function fulcro_css$css_implementation$get_local_rules(component){
if(fulcro_css.css_implementation.CSS_QMARK_.call(null,component)){
return fulcro_css.css_protocols.local_rules(component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Returns true if the given string starts with one of [. $ &$ &.]
 */
fulcro_css.css_implementation.prefixed_name_QMARK_ = (function fulcro_css$css_implementation$prefixed_name_QMARK_(nm){
return (!((cljs.core.re_matches.call(null,/(\.|\$|&\.|&\$).*/,nm) == null)));
});
/**
 * Returns the prefix of a string. [. $ &$ &.]
 */
fulcro_css.css_implementation.get_prefix = (function fulcro_css$css_implementation$get_prefix(nm){
var vec__54446 = cljs.core.re_matches.call(null,/(\.|\$|&\.|&\$).*/,nm);
var _ = cljs.core.nth.call(null,vec__54446,(0),null);
var prefix = cljs.core.nth.call(null,vec__54446,(1),null);
return prefix;
});
/**
 * Returns true if the given keyword starts with one of [. $ &$ &.]
 */
fulcro_css.css_implementation.prefixed_keyword_QMARK_ = (function fulcro_css$css_implementation$prefixed_keyword_QMARK_(kw){
return (((kw instanceof cljs.core.Keyword)) && (fulcro_css.css_implementation.prefixed_name_QMARK_.call(null,cljs.core.name.call(null,kw))));
});
/**
 * Removes the prefix of a string.
 */
fulcro_css.css_implementation.remove_prefix = (function fulcro_css$css_implementation$remove_prefix(nm){
return cljs.core.subs.call(null,nm,cljs.core.count.call(null,fulcro_css.css_implementation.get_prefix.call(null,nm)));
});
/**
 * Removes the prefix of a keyword.
 */
fulcro_css.css_implementation.remove_prefix_kw = (function fulcro_css$css_implementation$remove_prefix_kw(kw){
return cljs.core.keyword.call(null,fulcro_css.css_implementation.remove_prefix.call(null,cljs.core.name.call(null,kw)));
});
/**
 * Returns the list of components from the include-children method of a component
 */
fulcro_css.css_implementation.get_includes = (function fulcro_css$css_implementation$get_includes(component){
if(fulcro_css.css_implementation.CSS_QMARK_.call(null,component)){
return fulcro_css.css_protocols.include_children(component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Recursively finds all includes starting at the given component.
 */
fulcro_css.css_implementation.get_nested_includes = (function fulcro_css$css_implementation$get_nested_includes(component){
var direct_children = fulcro_css.css_implementation.get_includes.call(null,component);
if(cljs.core.empty_QMARK_.call(null,direct_children)){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.concat.call(null,direct_children,cljs.core.reduce.call(null,((function (direct_children){
return (function (p1__54487_SHARP_,p2__54488_SHARP_){
return cljs.core.concat.call(null,p1__54487_SHARP_,fulcro_css.css_implementation.get_nested_includes.call(null,p2__54488_SHARP_));
});})(direct_children))
,cljs.core.PersistentVector.EMPTY,direct_children));
}
});
fulcro_css.css_implementation.localize_name = (function fulcro_css$css_implementation$localize_name(nm,comp){
var no_prefix = fulcro_css.css_implementation.remove_prefix.call(null,nm);
var prefix = fulcro_css.css_implementation.get_prefix.call(null,nm);
var G__54493 = prefix;
switch (G__54493) {
case ".":
case "&.":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),fulcro_css.css_implementation.local_class.call(null,comp,cljs.core.keyword.call(null,no_prefix))].join('');

break;
case "$":
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no_prefix)].join('');

break;
case "&$":
return ["&.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no_prefix)].join('');

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54493)].join('')));

}
});
fulcro_css.css_implementation.localize_kw = (function fulcro_css$css_implementation$localize_kw(kw,comp){
return cljs.core.keyword.call(null,fulcro_css.css_implementation.localize_name.call(null,cljs.core.name.call(null,kw),comp));
});
/**
 * Gives the localized classname for the given keyword.
 */
fulcro_css.css_implementation.kw__GT_localized_classname = (function fulcro_css$css_implementation$kw__GT_localized_classname(comp,kw){
var nm = cljs.core.name.call(null,kw);
var prefix = fulcro_css.css_implementation.get_prefix.call(null,nm);
var no_prefix = cljs.core.subs.call(null,nm,cljs.core.count.call(null,prefix));
var G__54503 = prefix;
switch (G__54503) {
case "$":
case "&$":
return no_prefix;

break;
case ".":
case "&.":
return fulcro_css.css_implementation.local_class.call(null,comp,no_prefix);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54503)].join('')));

}
});
fulcro_css.css_implementation.selector_QMARK_ = (function fulcro_css$css_implementation$selector_QMARK_(x){
try{return cljs.core._EQ_.call(null,garden.selectors.CSSSelector,cljs.core.type.call(null,x));
}catch (e54507){var e = e54507;
return false;
}});
/**
 * Gets all the keywords that are present in a selector
 */
fulcro_css.css_implementation.get_selector_keywords = (function fulcro_css$css_implementation$get_selector_keywords(selector){
var val = new cljs.core.Keyword(null,"selector","selector",762528866).cljs$core$IFn$_invoke$arity$1(selector);
var classnames = cljs.core.filter.call(null,((function (val){
return (function (p1__54510_SHARP_){
return cljs.core.re_matches.call(null,/[.$].*/,p1__54510_SHARP_);
});})(val))
,clojure.string.split.call(null,val,/ /));
return cljs.core.map.call(null,cljs.core.keyword,classnames);
});
/**
 * Gets all used classnames in from the given rules as keywords
 */
fulcro_css.css_implementation.get_class_keys = (function fulcro_css$css_implementation$get_class_keys(rules){
var flattened_rules = cljs.core.flatten.call(null,rules);
var selectors = cljs.core.filter.call(null,fulcro_css.css_implementation.selector_QMARK_,flattened_rules);
var prefixed_kws = cljs.core.filter.call(null,fulcro_css.css_implementation.prefixed_keyword_QMARK_,flattened_rules);
return cljs.core.distinct.call(null,cljs.core.concat.call(null,cljs.core.flatten.call(null,cljs.core.map.call(null,fulcro_css.css_implementation.get_selector_keywords,selectors)),prefixed_kws));
});
/**
 * Returns a map from user-given CSS rule names to localized names of the given component.
 */
fulcro_css.css_implementation.get_classnames = (function fulcro_css$css_implementation$get_classnames(comp){
var local_class_keys = fulcro_css.css_implementation.get_class_keys.call(null,fulcro_css.css_implementation.get_local_rules.call(null,comp));
var global_class_keys = cljs.core.map.call(null,fulcro_css.css_implementation.remove_prefix_kw,fulcro_css.css_implementation.get_class_keys.call(null,fulcro_css.css_implementation.get_global_rules.call(null,comp)));
var local_classnames = cljs.core.zipmap.call(null,cljs.core.map.call(null,fulcro_css.css_implementation.remove_prefix_kw,local_class_keys),cljs.core.map.call(null,((function (local_class_keys,global_class_keys){
return (function (p1__54525_SHARP_){
return fulcro_css.css_implementation.kw__GT_localized_classname.call(null,comp,p1__54525_SHARP_);
});})(local_class_keys,global_class_keys))
,local_class_keys));
var global_classnames = cljs.core.zipmap.call(null,global_class_keys,cljs.core.map.call(null,cljs.core.name,global_class_keys));
return cljs.core.merge.call(null,local_classnames,global_classnames);
});

//# sourceMappingURL=fulcro_css.css_implementation.js.map
