goog.provide('fulcro.inspect.helpers');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('fulcro.client.primitives');
goog.require('fulcro.client.mutations');
goog.require('fulcro.inspect.lib.local_storage');
fulcro.inspect.helpers.om_ident_QMARK_ = (function fulcro$inspect$helpers$om_ident_QMARK_(x){
return ((cljs.core.vector_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && ((cljs.core.first.call(null,x) instanceof cljs.core.Keyword)));
});
fulcro.inspect.helpers.query_component = (function fulcro$inspect$helpers$query_component(var_args){
var G__65641 = arguments.length;
switch (G__65641) {
case 1:
return fulcro.inspect.helpers.query_component.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.inspect.helpers.query_component.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.inspect.helpers.query_component.cljs$core$IFn$_invoke$arity$1 = (function (this$){
var component = fulcro.client.primitives.react_type.call(null,this$);
var ref = fulcro.client.primitives.get_ident.call(null,this$);
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)));
var query = fulcro.client.primitives.get_query.call(null,component);
return fulcro.client.primitives.db__GT_tree.call(null,query,cljs.core.get_in.call(null,state,ref),state);
});

fulcro.inspect.helpers.query_component.cljs$core$IFn$_invoke$arity$2 = (function (this$,focus_path){
var component = fulcro.client.primitives.react_type.call(null,this$);
var ref = fulcro.client.primitives.get_ident.call(null,this$);
var state = cljs.core.deref.call(null,fulcro.client.primitives.app_state.call(null,fulcro.client.primitives.get_reconciler.call(null,this$)));
var query = fulcro.client.primitives.focus_query.call(null,fulcro.client.primitives.get_query.call(null,component),focus_path);
return cljs.core.get_in.call(null,fulcro.client.primitives.db__GT_tree.call(null,query,cljs.core.get_in.call(null,state,ref),state),focus_path);
});

fulcro.inspect.helpers.query_component.cljs$lang$maxFixedArity = 2;

fulcro.inspect.helpers.swap_entity_BANG_ = (function fulcro$inspect$helpers$swap_entity_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65810 = arguments.length;
var i__4731__auto___65811 = (0);
while(true){
if((i__4731__auto___65811 < len__4730__auto___65810)){
args__4736__auto__.push((arguments[i__4731__auto___65811]));

var G__65813 = (i__4731__auto___65811 + (1));
i__4731__auto___65811 = G__65813;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fulcro.inspect.helpers.swap_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fulcro.inspect.helpers.swap_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__65651,args){
var map__65652 = p__65651;
var map__65652__$1 = (((((!((map__65652 == null))))?(((((map__65652.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65652.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65652):map__65652);
var state = cljs.core.get.call(null,map__65652__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__65652__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,cljs.core.update_in,ref,args);
});

fulcro.inspect.helpers.swap_entity_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fulcro.inspect.helpers.swap_entity_BANG_.cljs$lang$applyTo = (function (seq65645){
var G__65646 = cljs.core.first.call(null,seq65645);
var seq65645__$1 = cljs.core.next.call(null,seq65645);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65646,seq65645__$1);
});

fulcro.inspect.helpers.resolve_path = (function fulcro$inspect$helpers$resolve_path(state,path){
var G__65662 = path;
var vec__65663 = G__65662;
var seq__65664 = cljs.core.seq.call(null,vec__65663);
var first__65665 = cljs.core.first.call(null,seq__65664);
var seq__65664__$1 = cljs.core.next.call(null,seq__65664);
var h = first__65665;
var t = seq__65664__$1;
var new_path = cljs.core.PersistentVector.EMPTY;
var G__65662__$1 = G__65662;
var new_path__$1 = new_path;
while(true){
var vec__65673 = G__65662__$1;
var seq__65674 = cljs.core.seq.call(null,vec__65673);
var first__65675 = cljs.core.first.call(null,seq__65674);
var seq__65674__$1 = cljs.core.next.call(null,seq__65674);
var h__$1 = first__65675;
var t__$1 = seq__65674__$1;
var new_path__$2 = new_path__$1;
if(cljs.core.truth_(h__$1)){
var np = cljs.core.conj.call(null,new_path__$2,h__$1);
var c = cljs.core.get_in.call(null,state,np);
if(fulcro.inspect.helpers.om_ident_QMARK_.call(null,c)){
var G__65819 = t__$1;
var G__65820 = c;
G__65662__$1 = G__65819;
new_path__$1 = G__65820;
continue;
} else {
var G__65821 = t__$1;
var G__65822 = cljs.core.conj.call(null,new_path__$2,h__$1);
G__65662__$1 = G__65821;
new_path__$1 = G__65822;
continue;
}
} else {
return new_path__$2;
}
break;
}
});
/**
 * Like get-in, but will resolve path before reading it.
 */
fulcro.inspect.helpers.get_in_path = (function fulcro$inspect$helpers$get_in_path(state,path){
return cljs.core.get_in.call(null,state,fulcro.inspect.helpers.resolve_path.call(null,state,path));
});
fulcro.inspect.helpers.swap_in_BANG_ = (function fulcro$inspect$helpers$swap_in_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65823 = arguments.length;
var i__4731__auto___65824 = (0);
while(true){
if((i__4731__auto___65824 < len__4730__auto___65823)){
args__4736__auto__.push((arguments[i__4731__auto___65824]));

var G__65825 = (i__4731__auto___65824 + (1));
i__4731__auto___65824 = G__65825;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.inspect.helpers.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.inspect.helpers.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__65689,path,args){
var map__65690 = p__65689;
var map__65690__$1 = (((((!((map__65690 == null))))?(((((map__65690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65690):map__65690);
var state = cljs.core.get.call(null,map__65690__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__65690__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var path__$1 = fulcro.inspect.helpers.resolve_path.call(null,cljs.core.deref.call(null,state),cljs.core.into.call(null,ref,path));
if(cljs.core.truth_((function (){var and__4120__auto__ = path__$1;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,state),path__$1);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,cljs.core.update_in,path__$1,args);
} else {
return null;
}
});

fulcro.inspect.helpers.swap_in_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.inspect.helpers.swap_in_BANG_.cljs$lang$applyTo = (function (seq65679){
var G__65680 = cljs.core.first.call(null,seq65679);
var seq65679__$1 = cljs.core.next.call(null,seq65679);
var G__65681 = cljs.core.first.call(null,seq65679__$1);
var seq65679__$2 = cljs.core.next.call(null,seq65679__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65680,G__65681,seq65679__$2);
});

/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 *   The named parameters can be specified any number of times. They are:
 *   - set: A vector (path) to a list in your app state where this new object's ident should be set.
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 */
fulcro.inspect.helpers.integrate_ident = (function fulcro$inspect$helpers$integrate_ident(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65828 = arguments.length;
var i__4731__auto___65829 = (0);
while(true){
if((i__4731__auto___65829 < len__4730__auto___65828)){
args__4736__auto__.push((arguments[i__4731__auto___65829]));

var G__65830 = (i__4731__auto___65829 + (1));
i__4731__auto___65829 = G__65830;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.map_QMARK_.call(null,state)){
} else {
throw (new Error("Assert failed: (map? state)"));
}

var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__65705){
var vec__65706 = p__65705;
var command = cljs.core.nth.call(null,vec__65706,(0),null);
var data_path = cljs.core.nth.call(null,vec__65706,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__65706,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__65706,command,data_path,actions){
return (function (p1__65695_SHARP_){
return cljs.core._EQ_.call(null,p1__65695_SHARP_,ident);
});})(vec__65706,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__65706,command,data_path,actions))
;
var G__65710 = command;
var G__65710__$1 = (((G__65710 instanceof cljs.core.Keyword))?G__65710.fqn:null);
switch (G__65710__$1) {
case "set":
return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for prepend must target an app-state vector."].join(''),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,((function (G__65710,G__65710__$1,already_has_ident_at_path_QMARK_,vec__65706,command,data_path,actions){
return (function (p1__65696_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__65696_SHARP_);
});})(G__65710,G__65710__$1,already_has_ident_at_path_QMARK_,vec__65706,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_(data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for append must target an app-state vector."].join(''),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.conj,ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = ((cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector))));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join(''),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join(''),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.inspect.helpers.integrate_ident.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fulcro.inspect.helpers.integrate_ident.cljs$lang$applyTo = (function (seq65698){
var G__65699 = cljs.core.first.call(null,seq65698);
var seq65698__$1 = cljs.core.next.call(null,seq65698);
var G__65700 = cljs.core.first.call(null,seq65698__$1);
var seq65698__$2 = cljs.core.next.call(null,seq65698__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65699,G__65700,seq65698__$2);
});

fulcro.inspect.helpers.merge_entity = (function fulcro$inspect$helpers$merge_entity(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65841 = arguments.length;
var i__4731__auto___65842 = (0);
while(true){
if((i__4731__auto___65842 < len__4730__auto___65841)){
args__4736__auto__.push((arguments[i__4731__auto___65842]));

var G__65843 = (i__4731__auto___65842 + (1));
i__4731__auto___65842 = G__65843;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic = (function (state,x,data,named_parameters){

var idents = cljs.core.dissoc.call(null,fulcro.client.primitives.tree__GT_db.call(null,(function (){
if((typeof fulcro !== 'undefined') && (typeof fulcro.inspect !== 'undefined') && (typeof fulcro.inspect.helpers !== 'undefined') && (typeof fulcro.inspect.helpers.t_fulcro$inspect$helpers65722 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {fulcro.client.primitives.IQuery}
 * @implements {cljs.core.IWithMeta}
*/
fulcro.inspect.helpers.t_fulcro$inspect$helpers65722 = (function (state,x,data,named_parameters,meta65723){
this.state = state;
this.x = x;
this.data = data;
this.named_parameters = named_parameters;
this.meta65723 = meta65723;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_65724,meta65723__$1){
var self__ = this;
var _65724__$1 = this;
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers65722(self__.state,self__.x,self__.data,self__.named_parameters,meta65723__$1));
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_65724){
var self__ = this;
var _65724__$1 = this;
return self__.meta65723;
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.prototype.fulcro$client$primitives$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.prototype.fulcro$client$primitives$IQuery$query$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),fulcro.client.primitives.get_query.call(null,self__.x)], null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"named-parameters","named-parameters",2053922585,null),new cljs.core.Symbol(null,"meta65723","meta65723",221800159,null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.cljs$lang$type = true;

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.cljs$lang$ctorStr = "fulcro.inspect.helpers/t_fulcro$inspect$helpers65722";

fulcro.inspect.helpers.t_fulcro$inspect$helpers65722.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"fulcro.inspect.helpers/t_fulcro$inspect$helpers65722");
});

/**
 * Positional factory function for fulcro.inspect.helpers/t_fulcro$inspect$helpers65722.
 */
fulcro.inspect.helpers.__GT_t_fulcro$inspect$helpers65722 = (function fulcro$inspect$helpers$__GT_t_fulcro$inspect$helpers65722(state__$1,x__$1,data__$1,named_parameters__$1,meta65723){
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers65722(state__$1,x__$1,data__$1,named_parameters__$1,meta65723));
});

}

return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers65722(state,x,data,named_parameters,cljs.core.PersistentArrayMap.EMPTY));
})()
,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),data], null),true),new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),new cljs.core.Keyword("fulcro.client.primitives","tables","fulcro.client.primitives/tables",-1418944816));
var root_ident = fulcro.client.primitives.ident(x,data);
var state__$1 = cljs.core.merge_with.call(null,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state,idents);
if(cljs.core.seq.call(null,named_parameters)){
return cljs.core.apply.call(null,fulcro.inspect.helpers.integrate_ident,state__$1,root_ident,named_parameters);
} else {
return state__$1;
}
});

fulcro.inspect.helpers.merge_entity.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
fulcro.inspect.helpers.merge_entity.cljs$lang$applyTo = (function (seq65715){
var G__65716 = cljs.core.first.call(null,seq65715);
var seq65715__$1 = cljs.core.next.call(null,seq65715);
var G__65717 = cljs.core.first.call(null,seq65715__$1);
var seq65715__$2 = cljs.core.next.call(null,seq65715__$1);
var G__65718 = cljs.core.first.call(null,seq65715__$2);
var seq65715__$3 = cljs.core.next.call(null,seq65715__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65716,G__65717,G__65718,seq65715__$3);
});

fulcro.inspect.helpers.create_entity_BANG_ = (function fulcro$inspect$helpers$create_entity_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___65854 = arguments.length;
var i__4731__auto___65855 = (0);
while(true){
if((i__4731__auto___65855 < len__4730__auto___65854)){
args__4736__auto__.push((arguments[i__4731__auto___65855]));

var G__65856 = (i__4731__auto___65855 + (1));
i__4731__auto___65855 = G__65856;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__65742,x,data,named_parameters){
var map__65743 = p__65742;
var map__65743__$1 = (((((!((map__65743 == null))))?(((((map__65743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65743):map__65743);
var state = cljs.core.get.call(null,map__65743__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__65743__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var named_parameters__$1 = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,((function (map__65743,map__65743__$1,state,ref){
return (function (p__65747){
var vec__65748 = p__65747;
var op = cljs.core.nth.call(null,vec__65748,(0),null);
var path = cljs.core.nth.call(null,vec__65748,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [op,cljs.core.conj.call(null,ref,path)], null);
});})(map__65743,map__65743__$1,state,ref))
,cljs.core.partition.call(null,(2),named_parameters)));
var data_SINGLEQUOTE_ = (cljs.core.truth_(new cljs.core.Keyword("fulcro.inspect.helpers","initialized","fulcro.inspect.helpers/initialized",-1739021626).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data)))?data:fulcro.client.primitives.get_initial_state.call(null,x,data));
cljs.core.apply.call(null,cljs.core.swap_BANG_,state,fulcro.inspect.helpers.merge_entity,x,data_SINGLEQUOTE_,named_parameters__$1);

return data_SINGLEQUOTE_;
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$applyTo = (function (seq65737){
var G__65738 = cljs.core.first.call(null,seq65737);
var seq65737__$1 = cljs.core.next.call(null,seq65737);
var G__65739 = cljs.core.first.call(null,seq65737__$1);
var seq65737__$2 = cljs.core.next.call(null,seq65737__$1);
var G__65740 = cljs.core.first.call(null,seq65737__$2);
var seq65737__$3 = cljs.core.next.call(null,seq65737__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65738,G__65739,G__65740,seq65737__$3);
});

fulcro.inspect.helpers.dissoc_in = (function fulcro$inspect$helpers$dissoc_in(m,path){
var G__65754 = m;
if(cljs.core.truth_(cljs.core.get_in.call(null,m,cljs.core.butlast.call(null,path)))){
return cljs.core.update_in.call(null,G__65754,cljs.core.butlast.call(null,path),cljs.core.dissoc,cljs.core.last.call(null,path));
} else {
return G__65754;
}
});
fulcro.inspect.helpers.deep_remove_ref = (function fulcro$inspect$helpers$deep_remove_ref(state,ref){

var item = cljs.core.get_in.call(null,state,ref);
var idents = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.comp.call(null,cljs.core.keep.call(null,((function (item){
return (function (v){
if(fulcro.inspect.helpers.om_ident_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null);
} else {
if(((cljs.core.vector_QMARK_.call(null,v)) && (cljs.core.every_QMARK_.call(null,fulcro.inspect.helpers.om_ident_QMARK_,v)))){
return v;
} else {
return null;
}
}
});})(item))
),cljs.core.cat),cljs.core.vals.call(null,item));
return cljs.core.reduce.call(null,((function (item,idents){
return (function (s,i){
return fulcro.inspect.helpers.deep_remove_ref.call(null,s,i);
});})(item,idents))
,fulcro.inspect.helpers.dissoc_in.call(null,state,ref),idents);
});
fulcro.inspect.helpers.remove_edge_BANG_ = (function fulcro$inspect$helpers$remove_edge_BANG_(p__65762,field){
var map__65763 = p__65762;
var map__65763__$1 = (((((!((map__65763 == null))))?(((((map__65763.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65763.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65763):map__65763);
var state = cljs.core.get.call(null,map__65763__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__65763__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var children = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,ref,field));
if(fulcro.inspect.helpers.om_ident_QMARK_.call(null,children)){
return cljs.core.swap_BANG_.call(null,state,cljs.core.comp.call(null,((function (children,map__65763,map__65763__$1,state,ref){
return (function (p1__65758_SHARP_){
return cljs.core.update_in.call(null,p1__65758_SHARP_,ref,cljs.core.dissoc,field);
});})(children,map__65763,map__65763__$1,state,ref))
,((function (children,map__65763,map__65763__$1,state,ref){
return (function (p1__65759_SHARP_){
return fulcro.inspect.helpers.deep_remove_ref.call(null,p1__65759_SHARP_,children);
});})(children,map__65763,map__65763__$1,state,ref))
));
} else {
if(cljs.core.seq.call(null,children)){
return cljs.core.swap_BANG_.call(null,state,cljs.core.comp.call(null,((function (children,map__65763,map__65763__$1,state,ref){
return (function (p1__65760_SHARP_){
return cljs.core.assoc_in.call(null,p1__65760_SHARP_,cljs.core.conj.call(null,ref,field),cljs.core.PersistentVector.EMPTY);
});})(children,map__65763,map__65763__$1,state,ref))
,((function (children,map__65763,map__65763__$1,state,ref){
return (function (p1__65761_SHARP_){
return cljs.core.reduce.call(null,fulcro.inspect.helpers.deep_remove_ref,p1__65761_SHARP_,children);
});})(children,map__65763,map__65763__$1,state,ref))
));
} else {
return null;
}
}
});
fulcro.inspect.helpers.vec_remove_index = (function fulcro$inspect$helpers$vec_remove_index(i,v){

return cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.subvec.call(null,v,(0),i),cljs.core.subvec.call(null,v,(i + (1)),cljs.core.count.call(null,v))));
});
cljs.core._add_method(fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.inspect.helpers","persistent-set-props","fulcro.inspect.helpers/persistent-set-props",-1753072879,null),(function (fulcro_incoming_env,_,p__65770){
var map__65771 = p__65770;
var map__65771__$1 = (((((!((map__65771 == null))))?(((((map__65771.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65771.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65771):map__65771);
var local_key = cljs.core.get.call(null,map__65771__$1,new cljs.core.Keyword("fulcro.inspect.helpers","local-key","fulcro.inspect.helpers/local-key",-858551382));
var storage_key = cljs.core.get.call(null,map__65771__$1,new cljs.core.Keyword("fulcro.inspect.helpers","storage-key","fulcro.inspect.helpers/storage-key",1801490937));
var value = cljs.core.get.call(null,map__65771__$1,new cljs.core.Keyword("fulcro.inspect.helpers","value","fulcro.inspect.helpers/value",1147993961));
return cljs.core.merge.call(null,(function (){var env = fulcro_incoming_env;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (env,map__65771,map__65771__$1,local_key,storage_key,value){
return (function (){
fulcro.inspect.lib.local_storage.set_BANG_.call(null,storage_key,value);

return fulcro.inspect.helpers.swap_entity_BANG_.call(null,env,cljs.core.assoc,local_key,value);
});})(env,map__65771,map__65771__$1,local_key,storage_key,value))
], null);
})());
}));
fulcro.inspect.helpers.persistent_set_BANG_ = (function fulcro$inspect$helpers$persistent_set_BANG_(comp,local_key,storage_key,value){
return fulcro.client.primitives.transact_BANG_.call(null,comp,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.List(null,new cljs.core.Symbol("fulcro.inspect.helpers","persistent-set-props","fulcro.inspect.helpers/persistent-set-props",-1753072879,null),(new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("fulcro.inspect.helpers","local-key","fulcro.inspect.helpers/local-key",-858551382),local_key,new cljs.core.Keyword("fulcro.inspect.helpers","storage-key","fulcro.inspect.helpers/storage-key",1801490937),storage_key,new cljs.core.Keyword("fulcro.inspect.helpers","value","fulcro.inspect.helpers/value",1147993961),value], null),null,(1),null)),(2),null)),local_key], null));
});
fulcro.inspect.helpers.normalize_id = (function fulcro$inspect$helpers$normalize_id(id){
var temp__5718__auto__ = cljs.core.re_find.call(null,/(.+?)(-\d+)$/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(id));
if(cljs.core.truth_(temp__5718__auto__)){
var vec__65780 = temp__5718__auto__;
var _ = cljs.core.nth.call(null,vec__65780,(0),null);
var prefix = cljs.core.nth.call(null,vec__65780,(1),null);
if((id instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,cljs.core.subs.call(null,prefix,(1)));
} else {
if((id instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,prefix);
} else {
return prefix;

}
}
} else {
return id;
}
});
/**
 * Extracts the app uuid from a ident.
 */
fulcro.inspect.helpers.ref_app_uuid = (function fulcro$inspect$helpers$ref_app_uuid(ref){
if(((cljs.core.vector_QMARK_.call(null,ref)) && (cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,ref))))){
} else {
throw (new Error(["Assert failed: ","Ref with app it must be in the format: [:id-key [::app-id app-id]]","\n","(and (vector? ref) (vector? (second ref)))"].join('')));
}

var vec__65784 = ref;
var _ = cljs.core.nth.call(null,vec__65784,(0),null);
var vec__65787 = cljs.core.nth.call(null,vec__65784,(1),null);
var ___$1 = cljs.core.nth.call(null,vec__65787,(0),null);
var app_id = cljs.core.nth.call(null,vec__65787,(1),null);
return app_id;
});
fulcro.inspect.helpers.ref_app_id = (function fulcro$inspect$helpers$ref_app_id(state,ref){
var app_uuid = fulcro.inspect.helpers.ref_app_uuid.call(null,ref);
return cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.inspector","id","fulcro.inspect.ui.inspector/id",-803234094),app_uuid,new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233)], null));
});
/**
 * Read app uuid from a component
 */
fulcro.inspect.helpers.comp_app_uuid = (function fulcro$inspect$helpers$comp_app_uuid(comp){
return fulcro.inspect.helpers.ref_app_uuid.call(null,fulcro.client.primitives.get_ident.call(null,comp));
});
fulcro.inspect.helpers.all_apps = (function fulcro$inspect$helpers$all_apps(state){
return cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fulcro.inspect.ui.multi-inspector","multi-inspector","fulcro.inspect.ui.multi-inspector/multi-inspector",1353666037),"main",new cljs.core.Keyword("fulcro.inspect.ui.multi-inspector","inspectors","fulcro.inspect.ui.multi-inspector/inspectors",-1565317572)], null));
});
fulcro.inspect.helpers.matching_apps = (function fulcro$inspect$helpers$matching_apps(state,app_id){
return cljs.core.mapv.call(null,cljs.core.second,cljs.core.filterv.call(null,(function (p1__65793_SHARP_){
return cljs.core._EQ_.call(null,app_id,new cljs.core.Keyword("fulcro.inspect.core","app-id","fulcro.inspect.core/app-id",-1444290233).cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,state,p1__65793_SHARP_)));
}),fulcro.inspect.helpers.all_apps.call(null,state)));
});
fulcro.inspect.helpers.update_matching_apps = (function fulcro$inspect$helpers$update_matching_apps(state,app_id,f){
var apps = fulcro.inspect.helpers.matching_apps.call(null,state,app_id);
return cljs.core.reduce.call(null,((function (apps){
return (function (s,app){
return f.call(null,s,app);
});})(apps))
,state,apps);
});
fulcro.inspect.helpers.remote_mutation = (function fulcro$inspect$helpers$remote_mutation(p__65796,key){
var map__65797 = p__65796;
var map__65797__$1 = (((((!((map__65797 == null))))?(((((map__65797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65797):map__65797);
var ast = cljs.core.get.call(null,map__65797__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var ref = cljs.core.get.call(null,map__65797__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"key","key",-1516042587),key),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword("fulcro.inspect.core","app-uuid","fulcro.inspect.core/app-uuid",-1096445491)], null),fulcro.inspect.helpers.ref_app_uuid.call(null,ref));
});
fulcro.inspect.helpers.pprint = (function fulcro$inspect$helpers$pprint(x){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__65800_65889 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__65801_65890 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__65802_65891 = true;
var _STAR_print_fn_STAR__temp_val__65803_65892 = ((function (_STAR_print_newline_STAR__orig_val__65800_65889,_STAR_print_fn_STAR__orig_val__65801_65890,_STAR_print_newline_STAR__temp_val__65802_65891,sb__4661__auto__){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__65800_65889,_STAR_print_fn_STAR__orig_val__65801_65890,_STAR_print_newline_STAR__temp_val__65802_65891,sb__4661__auto__))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__65802_65891;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__65803_65892;

try{cljs.pprint.pprint.call(null,x);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__65801_65890;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__65800_65889;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
});

//# sourceMappingURL=fulcro.inspect.helpers.js.map
