goog.provide('fulcro.client.dom');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('fulcro.util');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
goog.require('goog.object');
goog.require('goog.dom');
goog.require('fulcro.client.dom_common');





































































































































































































fulcro.client.dom.element_marker = goog.object.get(React.createElement("div",null),"$$typeof");
/**
 * Returns true if the given arg is a react element.
 */
fulcro.client.dom.element_QMARK_ = (function fulcro$client$dom$element_QMARK_(x){
return ((cljs.core.object_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,fulcro.client.dom.element_marker,goog.object.get(x,"$$typeof"))));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"css","css",1135045163),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"map","map",1371690461),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null))))),new cljs.core.Keyword(null,"js-object","js-object",1830199158),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","object?","cljs.core/object?",2051371283,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null))))))),new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"collection","collection",-683361892),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","array?","cljs.core/array?",-1655912448,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)))),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"element","element",1974019749),new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null)))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"children","children",-940561982)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.maybe_impl.call(null,cljs.core.keyword_QMARK_,new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),cljs.spec.alpha.maybe_impl.call(null,cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"js-object","js-object",1830199158)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"%","%",-950237169,null))))),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","object?","cljs.core/object?",2051371283,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nil_QMARK_,(function (p1__65102_SHARP_){
return ((cljs.core.map_QMARK_.call(null,p1__65102_SHARP_)) && ((!(fulcro.client.dom.element_QMARK_.call(null,p1__65102_SHARP_)))));
}),(function (p1__65103_SHARP_){
return ((cljs.core.object_QMARK_.call(null,p1__65103_SHARP_)) && ((!(fulcro.client.dom.element_QMARK_.call(null,p1__65103_SHARP_)))));
})], null),null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"map","map",1371690461),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null))))),new cljs.core.Keyword(null,"js-object","js-object",1830199158),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","object?","cljs.core/object?",2051371283,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null))))))),cljs.spec.alpha.rep_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"collection","collection",-683361892),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","array?","cljs.core/array?",-1655912448,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)))),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"element","element",1974019749),new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null)),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"element","element",1974019749)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","array?","cljs.core/array?",-1655912448,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.string_QMARK_,cljs.core.number_QMARK_,(function (p1__65104_SHARP_){
return ((cljs.core.vector_QMARK_.call(null,p1__65104_SHARP_)) || (cljs.core.seq_QMARK_.call(null,p1__65104_SHARP_)) || (cljs.core.array_QMARK_.call(null,p1__65104_SHARP_)));
}),cljs.core.nil_QMARK_,fulcro.client.dom.element_QMARK_], null),null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","?","cljs.spec.alpha/?",1605136319,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"map","map",1371690461),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65102#","p1__65102#",-260479386,null))))),new cljs.core.Keyword(null,"js-object","js-object",1830199158),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),cljs.core.list(new cljs.core.Symbol("cljs.core","object?","cljs.core/object?",2051371283,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null),cljs.core.list(new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null),new cljs.core.Symbol(null,"p1__65103#","p1__65103#",741167563,null))))))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"collection","collection",-683361892),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),cljs.core.list(new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","seq?","cljs.core/seq?",-1302056292,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","array?","cljs.core/array?",-1655912448,null),new cljs.core.Symbol(null,"p1__65104#","p1__65104#",1987333539,null)))),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),new cljs.core.Keyword(null,"element","element",1974019749),new cljs.core.Symbol("fulcro.client.dom","element?","fulcro.client.dom/element?",-878482509,null)))], null)));
/**
 * Equivalent to React.render
 */
fulcro.client.dom.render = (function fulcro$client$dom$render(component,el){
return ReactDOM.render(component,el);
});
/**
 * Equivalent to React.renderToString. NOTE: You must require cljsjs.react.dom.server to use this function.
 */
fulcro.client.dom.render_to_str = (function fulcro$client$dom$render_to_str(c){
return ReactDOMServer.renderToString(c);
});
/**
 * Returns the dom node associated with a component's React ref.
 */
fulcro.client.dom.node = (function fulcro$client$dom$node(var_args){
var G__65187 = arguments.length;
switch (G__65187) {
case 1:
return fulcro.client.dom.node.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.dom.node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.dom.node.cljs$core$IFn$_invoke$arity$1 = (function (component){
return ReactDOM.findDOMNode(component);
});

fulcro.client.dom.node.cljs$core$IFn$_invoke$arity$2 = (function (component,name){
var G__65192 = component.refs;
var G__65192__$1 = (((G__65192 == null))?null:goog.object.get(G__65192,name));
if((G__65192__$1 == null)){
return null;
} else {
return ReactDOM.findDOMNode(G__65192__$1);
}
});

fulcro.client.dom.node.cljs$lang$maxFixedArity = 2;

/**
 * Create a DOM element for which there exists no corresponding function.
 * Useful to create DOM elements not included in React.DOM. Equivalent
 * to calling `js/React.createElement`
 */
fulcro.client.dom.create_element = (function fulcro$client$dom$create_element(var_args){
var G__65200 = arguments.length;
switch (G__65200) {
case 1:
return fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___67944 = arguments.length;
var i__4731__auto___67945 = (0);
while(true){
if((i__4731__auto___67945 < len__4730__auto___67944)){
args_arr__4751__auto__.push((arguments[i__4731__auto___67945]));

var G__67946 = (i__4731__auto___67945 + (1));
i__4731__auto___67945 = G__67946;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return fulcro.client.dom.create_element.call(null,tag,null);
});

fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag,opts){
return React.createElement(tag,opts);
});

fulcro.client.dom.create_element.cljs$core$IFn$_invoke$arity$variadic = (function (tag,opts,children){
return React.createElement(tag,opts,children);
});

/** @this {Function} */
fulcro.client.dom.create_element.cljs$lang$applyTo = (function (seq65196){
var G__65197 = cljs.core.first.call(null,seq65196);
var seq65196__$1 = cljs.core.next.call(null,seq65196);
var G__65198 = cljs.core.first.call(null,seq65196__$1);
var seq65196__$2 = cljs.core.next.call(null,seq65196__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65197,G__65198,seq65196__$2);
});

fulcro.client.dom.create_element.cljs$lang$maxFixedArity = (2);

/**
 * Given props, which can be nil, a js-obj or a clj map: returns a js object.
 */
fulcro.client.dom.convert_props = (function fulcro$client$dom$convert_props(props){
if((props == null)){
return ({});
} else {
if(cljs.core.map_QMARK_.call(null,props)){
return cljs.core.clj__GT_js.call(null,props);
} else {
return props;

}
}
});
/**
 * Used internally by the DOM element generation.
 */
fulcro.client.dom.macro_create_element_STAR_ = (function fulcro$client$dom$macro_create_element_STAR_(arr){
if(cljs.core.array_QMARK_.call(null,arr)){
} else {
throw (new Error("Assert failed: (array? arr)"));
}

return React.createElement.apply(null,arr);
});
/**
 * Updates the state of the wrapped input element.
 */
fulcro.client.dom.update_state = (function fulcro$client$dom$update_state(component,next_props,value){
var on_change = goog.object.getValueByKeys(component,"state","onChange");
var next_state = ({});
var inputRef = goog.object.get(next_props,"inputRef");
goog.object.extend(next_state,next_props,({"onChange": on_change}));

goog.object.set(next_state,"value",value);

if(cljs.core.truth_(inputRef)){
goog.object.remove(next_state,"inputRef");

goog.object.set(next_state,"ref",inputRef);
} else {
}

return component.setState(next_state);
});
if((typeof fulcro !== 'undefined') && (typeof fulcro.client !== 'undefined') && (typeof fulcro.client.dom !== 'undefined') && (typeof fulcro.client.dom.form_elements_QMARK_ !== 'undefined')){
} else {
fulcro.client.dom.form_elements_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["option",null,"select",null,"input",null,"textarea",null], null), null);
}
fulcro.client.dom.is_form_element_QMARK_ = (function fulcro$client$dom$is_form_element_QMARK_(element){
var tag = element.tagName;
var and__4120__auto__ = tag;
if(cljs.core.truth_(and__4120__auto__)){
return fulcro.client.dom.form_elements_QMARK_.call(null,clojure.string.lower_case.call(null,tag));
} else {
return and__4120__auto__;
}
});
fulcro.client.dom.wrap_form_element = (function fulcro$client$dom$wrap_form_element(element){
var ctor = (function (props){
var this$ = this;
this$.state = (function (){var state = ({"ref": goog.object.get(props,"inputRef")});
goog.object.extend(state,props,({"onChange": goog.bind(goog.object.get(this$,"onChange"),this$)}));

goog.object.remove(state,"inputRef");

return state;
})();

return React.Component.apply(this$,arguments);
});
ctor.displayName = ["wrapped-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(element)].join('');

goog.inherits(ctor,React.Component);

var x65246_67960 = ctor.prototype;
x65246_67960.onChange = ((function (x65246_67960,ctor){
return (function (event){
var this$ = this;
var temp__5720__auto__ = this$.props.onChange;
if(cljs.core.truth_(temp__5720__auto__)){
var handler = temp__5720__auto__;
handler.call(null,event);

return fulcro.client.dom.update_state.call(null,this$,this$.props,goog.object.getValueByKeys(event,"target","value"));
} else {
return null;
}
});})(x65246_67960,ctor))
;

x65246_67960.componentWillReceiveProps = ((function (x65246_67960,ctor){
return (function (new_props){
var this$ = this;
var state_value = goog.object.getValueByKeys(this$,"state","value");
var this_node = ReactDOM.findDOMNode(this$);
var value_node = (cljs.core.truth_(fulcro.client.dom.is_form_element_QMARK_.call(null,this_node))?this_node:goog.dom.findNode(this_node,((function (state_value,this_node,this$,x65246_67960,ctor){
return (function (p1__65232_SHARP_){
return fulcro.client.dom.is_form_element_QMARK_.call(null,p1__65232_SHARP_);
});})(state_value,this_node,this$,x65246_67960,ctor))
));
var element_value = goog.object.get(value_node,"value");
if(cljs.core.not_EQ_.call(null,state_value,element_value)){
return fulcro.client.dom.update_state.call(null,this$,new_props,element_value);
} else {
return fulcro.client.dom.update_state.call(null,this$,new_props,goog.object.get(new_props,"value"));
}
});})(x65246_67960,ctor))
;

x65246_67960.render = ((function (x65246_67960,ctor){
return (function (){
var this$ = this;
return React.createElement(element,this$.state);
});})(x65246_67960,ctor))
;


var real_factory = React.createFactory(ctor);
return ((function (real_factory,ctor){
return (function() { 
var G__67970__delegate = function (props,children){
var temp__5718__auto__ = goog.object.get(props,"ref");
if(cljs.core.truth_(temp__5718__auto__)){
var r = temp__5718__auto__;
if(typeof r === 'string'){
return cljs.core.apply.call(null,real_factory,props,children);
} else {
var p = ({});
goog.object.extend(p,props);

goog.object.set(p,"inputRef",r);

goog.object.remove(p,"ref");

return cljs.core.apply.call(null,real_factory,p,children);
}
} else {
return cljs.core.apply.call(null,real_factory,props,children);
}
};
var G__67970 = function (props,var_args){
var children = null;
if (arguments.length > 1) {
var G__67976__i = 0, G__67976__a = new Array(arguments.length -  1);
while (G__67976__i < G__67976__a.length) {G__67976__a[G__67976__i] = arguments[G__67976__i + 1]; ++G__67976__i;}
  children = new cljs.core.IndexedSeq(G__67976__a,0,null);
} 
return G__67970__delegate.call(this,props,children);};
G__67970.cljs$lang$maxFixedArity = 1;
G__67970.cljs$lang$applyTo = (function (arglist__67977){
var props = cljs.core.first(arglist__67977);
var children = cljs.core.rest(arglist__67977);
return G__67970__delegate(props,children);
});
G__67970.cljs$core$IFn$_invoke$arity$variadic = G__67970__delegate;
return G__67970;
})()
;
;})(real_factory,ctor))
});
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
fulcro.client.dom.wrapped_input = fulcro.client.dom.wrap_form_element.call(null,"input");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
fulcro.client.dom.wrapped_textarea = fulcro.client.dom.wrap_form_element.call(null,"textarea");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
fulcro.client.dom.wrapped_option = fulcro.client.dom.wrap_form_element.call(null,"option");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
fulcro.client.dom.wrapped_select = fulcro.client.dom.wrap_form_element.call(null,"select");
fulcro.client.dom.arr_append_STAR_ = (function fulcro$client$dom$arr_append_STAR_(arr,x){
arr.push(x);

return arr;
});
fulcro.client.dom.arr_append = (function fulcro$client$dom$arr_append(arr,tail){
return cljs.core.reduce.call(null,fulcro.client.dom.arr_append_STAR_,arr,fulcro.util.force_children.call(null,tail));
});
/**
 * Used internally by element generation.
 */
fulcro.client.dom.macro_create_wrapped_form_element = (function fulcro$client$dom$macro_create_wrapped_form_element(opts){
var tag = (opts[(0)]);
var props = (opts[(1)]);
var children = opts.splice((2));
var G__65273 = tag;
switch (G__65273) {
case "input":
return cljs.core.apply.call(null,fulcro.client.dom.wrapped_input,props,children);

break;
case "textarea":
return cljs.core.apply.call(null,fulcro.client.dom.wrapped_textarea,props,children);

break;
case "select":
return cljs.core.apply.call(null,fulcro.client.dom.wrapped_select,props,children);

break;
case "option":
return cljs.core.apply.call(null,fulcro.client.dom.wrapped_option,props,children);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__65273)].join('')));

}
});
/**
 * Runtime interpretation of props. Used internally by element generation when the macro cannot expand the element at compile time.
 */
fulcro.client.dom.macro_create_element = (function fulcro$client$dom$macro_create_element(var_args){
var G__65277 = arguments.length;
switch (G__65277) {
case 2:
return fulcro.client.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro.client.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2 = (function (type,args){
return fulcro.client.dom.macro_create_element.call(null,type,args,null);
});

fulcro.client.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3 = (function (type,args,csskw){
var vec__65284 = args;
var seq__65285 = cljs.core.seq.call(null,vec__65284);
var first__65286 = cljs.core.first.call(null,seq__65285);
var seq__65285__$1 = cljs.core.next.call(null,seq__65285);
var head = first__65286;
var tail = seq__65285__$1;
var f = (cljs.core.truth_(fulcro.client.dom.form_elements_QMARK_.call(null,type))?fulcro.client.dom.macro_create_wrapped_form_element:fulcro.client.dom.macro_create_element_STAR_);
if((head == null)){
return f.call(null,(function (){var G__65288 = [type,fulcro.client.dom_common.add_kwprops_to_props.call(null,({}),csskw)];
fulcro.client.dom.arr_append.call(null,G__65288,tail);

return G__65288;
})());
} else {
if(fulcro.client.dom.element_QMARK_.call(null,head)){
return f.call(null,(function (){var G__65289 = [type,fulcro.client.dom_common.add_kwprops_to_props.call(null,({}),csskw)];
fulcro.client.dom.arr_append.call(null,G__65289,args);

return G__65289;
})());
} else {
if(cljs.core.object_QMARK_.call(null,head)){
return f.call(null,(function (){var G__65291 = [type,fulcro.client.dom_common.add_kwprops_to_props.call(null,head,csskw)];
fulcro.client.dom.arr_append.call(null,G__65291,tail);

return G__65291;
})());
} else {
if(cljs.core.map_QMARK_.call(null,head)){
return f.call(null,(function (){var G__65293 = [type,cljs.core.clj__GT_js.call(null,fulcro.client.dom_common.add_kwprops_to_props.call(null,fulcro.client.dom_common.interpret_classes.call(null,head),csskw))];
fulcro.client.dom.arr_append.call(null,G__65293,tail);

return G__65293;
})());
} else {
return f.call(null,(function (){var G__65294 = [type,fulcro.client.dom_common.add_kwprops_to_props.call(null,({}),csskw)];
fulcro.client.dom.arr_append.call(null,G__65294,args);

return G__65294;
})());

}
}
}
}
});

fulcro.client.dom.macro_create_element.cljs$lang$maxFixedArity = 3;

/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (form "hello")
 * (form nil "hello")
 * 
 * These two are made equivalent at compile time
 * (form {:onClick f} "hello")
 * (form #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (form :#the-id.klass.other-klass "hello")
 * (form :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.form = (function fulcro$client$dom$form(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68007 = arguments.length;
var i__4731__auto___68008 = (0);
while(true){
if((i__4731__auto___68008 < len__4730__auto___68007)){
args__4736__auto__.push((arguments[i__4731__auto___68008]));

var G__68009 = (i__4731__auto___68008 + (1));
i__4731__auto___68008 = G__68009;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.form.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.form.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65330 = conformed_args__63534__auto__;
var map__65330__$1 = (((((!((map__65330 == null))))?(((((map__65330.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65330.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65330):map__65330);
var css__63537__auto__ = cljs.core.get.call(null,map__65330__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65330__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65330__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"form",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.form.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.form.cljs$lang$applyTo = (function (seq65321){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65321));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (audio "hello")
 * (audio nil "hello")
 * 
 * These two are made equivalent at compile time
 * (audio {:onClick f} "hello")
 * (audio #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (audio :#the-id.klass.other-klass "hello")
 * (audio :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.audio = (function fulcro$client$dom$audio(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68019 = arguments.length;
var i__4731__auto___68020 = (0);
while(true){
if((i__4731__auto___68020 < len__4730__auto___68019)){
args__4736__auto__.push((arguments[i__4731__auto___68020]));

var G__68025 = (i__4731__auto___68020 + (1));
i__4731__auto___68020 = G__68025;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.audio.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.audio.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65350 = conformed_args__63534__auto__;
var map__65350__$1 = (((((!((map__65350 == null))))?(((((map__65350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65350.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65350):map__65350);
var css__63537__auto__ = cljs.core.get.call(null,map__65350__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65350__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65350__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"audio",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.audio.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.audio.cljs$lang$applyTo = (function (seq65341){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65341));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (input "hello")
 * (input nil "hello")
 * 
 * These two are made equivalent at compile time
 * (input {:onClick f} "hello")
 * (input #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (input :#the-id.klass.other-klass "hello")
 * (input :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.input = (function fulcro$client$dom$input(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68046 = arguments.length;
var i__4731__auto___68047 = (0);
while(true){
if((i__4731__auto___68047 < len__4730__auto___68046)){
args__4736__auto__.push((arguments[i__4731__auto___68047]));

var G__68050 = (i__4731__auto___68047 + (1));
i__4731__auto___68047 = G__68050;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.input.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.input.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65364 = conformed_args__63534__auto__;
var map__65364__$1 = (((((!((map__65364 == null))))?(((((map__65364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65364.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65364):map__65364);
var css__63537__auto__ = cljs.core.get.call(null,map__65364__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65364__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65364__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"input",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.input.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.input.cljs$lang$applyTo = (function (seq65359){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65359));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menuitem "hello")
 * (menuitem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menuitem {:onClick f} "hello")
 * (menuitem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menuitem :#the-id.klass.other-klass "hello")
 * (menuitem :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.menuitem = (function fulcro$client$dom$menuitem(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68052 = arguments.length;
var i__4731__auto___68053 = (0);
while(true){
if((i__4731__auto___68053 < len__4730__auto___68052)){
args__4736__auto__.push((arguments[i__4731__auto___68053]));

var G__68054 = (i__4731__auto___68053 + (1));
i__4731__auto___68053 = G__68054;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65382 = conformed_args__63534__auto__;
var map__65382__$1 = (((((!((map__65382 == null))))?(((((map__65382.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65382.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65382):map__65382);
var css__63537__auto__ = cljs.core.get.call(null,map__65382__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65382__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65382__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"menuitem",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.menuitem.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.menuitem.cljs$lang$applyTo = (function (seq65376){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65376));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (radialGradient "hello")
 * (radialGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (radialGradient {:onClick f} "hello")
 * (radialGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (radialGradient :#the-id.klass.other-klass "hello")
 * (radialGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.radialGradient = (function fulcro$client$dom$radialGradient(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68055 = arguments.length;
var i__4731__auto___68056 = (0);
while(true){
if((i__4731__auto___68056 < len__4730__auto___68055)){
args__4736__auto__.push((arguments[i__4731__auto___68056]));

var G__68057 = (i__4731__auto___68056 + (1));
i__4731__auto___68056 = G__68057;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65394 = conformed_args__63534__auto__;
var map__65394__$1 = (((((!((map__65394 == null))))?(((((map__65394.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65394.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65394):map__65394);
var css__63537__auto__ = cljs.core.get.call(null,map__65394__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65394__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65394__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"radialGradient",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.radialGradient.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.radialGradient.cljs$lang$applyTo = (function (seq65389){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65389));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMerge "hello")
 * (feMerge nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMerge {:onClick f} "hello")
 * (feMerge #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMerge :#the-id.klass.other-klass "hello")
 * (feMerge :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feMerge = (function fulcro$client$dom$feMerge(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68058 = arguments.length;
var i__4731__auto___68059 = (0);
while(true){
if((i__4731__auto___68059 < len__4730__auto___68058)){
args__4736__auto__.push((arguments[i__4731__auto___68059]));

var G__68060 = (i__4731__auto___68059 + (1));
i__4731__auto___68059 = G__68060;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65411 = conformed_args__63534__auto__;
var map__65411__$1 = (((((!((map__65411 == null))))?(((((map__65411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65411):map__65411);
var css__63537__auto__ = cljs.core.get.call(null,map__65411__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65411__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65411__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feMerge",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feMerge.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feMerge.cljs$lang$applyTo = (function (seq65408){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65408));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (set "hello")
 * (set nil "hello")
 * 
 * These two are made equivalent at compile time
 * (set {:onClick f} "hello")
 * (set #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (set :#the-id.klass.other-klass "hello")
 * (set :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.set = (function fulcro$client$dom$set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68063 = arguments.length;
var i__4731__auto___68064 = (0);
while(true){
if((i__4731__auto___68064 < len__4730__auto___68063)){
args__4736__auto__.push((arguments[i__4731__auto___68064]));

var G__68065 = (i__4731__auto___68064 + (1));
i__4731__auto___68064 = G__68065;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.set.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65422 = conformed_args__63534__auto__;
var map__65422__$1 = (((((!((map__65422 == null))))?(((((map__65422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65422):map__65422);
var css__63537__auto__ = cljs.core.get.call(null,map__65422__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65422__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65422__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"set",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.set.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.set.cljs$lang$applyTo = (function (seq65418){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65418));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting "hello")
 * (feSpecularLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting {:onClick f} "hello")
 * (feSpecularLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpecularLighting :#the-id.klass.other-klass "hello")
 * (feSpecularLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feSpecularLighting = (function fulcro$client$dom$feSpecularLighting(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68069 = arguments.length;
var i__4731__auto___68070 = (0);
while(true){
if((i__4731__auto___68070 < len__4730__auto___68069)){
args__4736__auto__.push((arguments[i__4731__auto___68070]));

var G__68071 = (i__4731__auto___68070 + (1));
i__4731__auto___68070 = G__68071;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65429 = conformed_args__63534__auto__;
var map__65429__$1 = (((((!((map__65429 == null))))?(((((map__65429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65429):map__65429);
var css__63537__auto__ = cljs.core.get.call(null,map__65429__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65429__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65429__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feSpecularLighting",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feSpecularLighting.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feSpecularLighting.cljs$lang$applyTo = (function (seq65425){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65425));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (base "hello")
 * (base nil "hello")
 * 
 * These two are made equivalent at compile time
 * (base {:onClick f} "hello")
 * (base #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (base :#the-id.klass.other-klass "hello")
 * (base :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.base = (function fulcro$client$dom$base(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68077 = arguments.length;
var i__4731__auto___68078 = (0);
while(true){
if((i__4731__auto___68078 < len__4730__auto___68077)){
args__4736__auto__.push((arguments[i__4731__auto___68078]));

var G__68081 = (i__4731__auto___68078 + (1));
i__4731__auto___68078 = G__68081;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.base.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.base.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65437 = conformed_args__63534__auto__;
var map__65437__$1 = (((((!((map__65437 == null))))?(((((map__65437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65437):map__65437);
var css__63537__auto__ = cljs.core.get.call(null,map__65437__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65437__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65437__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"base",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.base.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.base.cljs$lang$applyTo = (function (seq65433){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65433));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h1 "hello")
 * (h1 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h1 {:onClick f} "hello")
 * (h1 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h1 :#the-id.klass.other-klass "hello")
 * (h1 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h1 = (function fulcro$client$dom$h1(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68084 = arguments.length;
var i__4731__auto___68085 = (0);
while(true){
if((i__4731__auto___68085 < len__4730__auto___68084)){
args__4736__auto__.push((arguments[i__4731__auto___68085]));

var G__68086 = (i__4731__auto___68085 + (1));
i__4731__auto___68085 = G__68086;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h1.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h1.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65446 = conformed_args__63534__auto__;
var map__65446__$1 = (((((!((map__65446 == null))))?(((((map__65446.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65446.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65446):map__65446);
var css__63537__auto__ = cljs.core.get.call(null,map__65446__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65446__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65446__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h1",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h1.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h1.cljs$lang$applyTo = (function (seq65443){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65443));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feOffset "hello")
 * (feOffset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feOffset {:onClick f} "hello")
 * (feOffset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feOffset :#the-id.klass.other-klass "hello")
 * (feOffset :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feOffset = (function fulcro$client$dom$feOffset(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68089 = arguments.length;
var i__4731__auto___68090 = (0);
while(true){
if((i__4731__auto___68090 < len__4730__auto___68089)){
args__4736__auto__.push((arguments[i__4731__auto___68090]));

var G__68091 = (i__4731__auto___68090 + (1));
i__4731__auto___68090 = G__68091;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65461 = conformed_args__63534__auto__;
var map__65461__$1 = (((((!((map__65461 == null))))?(((((map__65461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65461.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65461):map__65461);
var css__63537__auto__ = cljs.core.get.call(null,map__65461__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65461__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65461__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feOffset",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feOffset.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feOffset.cljs$lang$applyTo = (function (seq65452){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65452));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (embed "hello")
 * (embed nil "hello")
 * 
 * These two are made equivalent at compile time
 * (embed {:onClick f} "hello")
 * (embed #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (embed :#the-id.klass.other-klass "hello")
 * (embed :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.embed = (function fulcro$client$dom$embed(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68094 = arguments.length;
var i__4731__auto___68095 = (0);
while(true){
if((i__4731__auto___68095 < len__4730__auto___68094)){
args__4736__auto__.push((arguments[i__4731__auto___68095]));

var G__68096 = (i__4731__auto___68095 + (1));
i__4731__auto___68095 = G__68096;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.embed.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.embed.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65476 = conformed_args__63534__auto__;
var map__65476__$1 = (((((!((map__65476 == null))))?(((((map__65476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65476):map__65476);
var css__63537__auto__ = cljs.core.get.call(null,map__65476__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65476__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65476__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"embed",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.embed.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.embed.cljs$lang$applyTo = (function (seq65474){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65474));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateMotion "hello")
 * (animateMotion nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateMotion {:onClick f} "hello")
 * (animateMotion #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateMotion :#the-id.klass.other-klass "hello")
 * (animateMotion :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.animateMotion = (function fulcro$client$dom$animateMotion(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68104 = arguments.length;
var i__4731__auto___68105 = (0);
while(true){
if((i__4731__auto___68105 < len__4730__auto___68104)){
args__4736__auto__.push((arguments[i__4731__auto___68105]));

var G__68111 = (i__4731__auto___68105 + (1));
i__4731__auto___68105 = G__68111;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65492 = conformed_args__63534__auto__;
var map__65492__$1 = (((((!((map__65492 == null))))?(((((map__65492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65492.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65492):map__65492);
var css__63537__auto__ = cljs.core.get.call(null,map__65492__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65492__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65492__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"animateMotion",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.animateMotion.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.animateMotion.cljs$lang$applyTo = (function (seq65491){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65491));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h3 "hello")
 * (h3 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h3 {:onClick f} "hello")
 * (h3 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h3 :#the-id.klass.other-klass "hello")
 * (h3 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h3 = (function fulcro$client$dom$h3(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68123 = arguments.length;
var i__4731__auto___68125 = (0);
while(true){
if((i__4731__auto___68125 < len__4730__auto___68123)){
args__4736__auto__.push((arguments[i__4731__auto___68125]));

var G__68127 = (i__4731__auto___68125 + (1));
i__4731__auto___68125 = G__68127;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h3.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h3.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65510 = conformed_args__63534__auto__;
var map__65510__$1 = (((((!((map__65510 == null))))?(((((map__65510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65510):map__65510);
var css__63537__auto__ = cljs.core.get.call(null,map__65510__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65510__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65510__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h3",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h3.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h3.cljs$lang$applyTo = (function (seq65496){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65496));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (body "hello")
 * (body nil "hello")
 * 
 * These two are made equivalent at compile time
 * (body {:onClick f} "hello")
 * (body #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (body :#the-id.klass.other-klass "hello")
 * (body :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.body = (function fulcro$client$dom$body(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68139 = arguments.length;
var i__4731__auto___68140 = (0);
while(true){
if((i__4731__auto___68140 < len__4730__auto___68139)){
args__4736__auto__.push((arguments[i__4731__auto___68140]));

var G__68141 = (i__4731__auto___68140 + (1));
i__4731__auto___68140 = G__68141;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.body.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.body.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65537 = conformed_args__63534__auto__;
var map__65537__$1 = (((((!((map__65537 == null))))?(((((map__65537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65537):map__65537);
var css__63537__auto__ = cljs.core.get.call(null,map__65537__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65537__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65537__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"body",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.body.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.body.cljs$lang$applyTo = (function (seq65535){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65535));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hkern "hello")
 * (hkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hkern {:onClick f} "hello")
 * (hkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hkern :#the-id.klass.other-klass "hello")
 * (hkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.hkern = (function fulcro$client$dom$hkern(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68147 = arguments.length;
var i__4731__auto___68149 = (0);
while(true){
if((i__4731__auto___68149 < len__4730__auto___68147)){
args__4736__auto__.push((arguments[i__4731__auto___68149]));

var G__68151 = (i__4731__auto___68149 + (1));
i__4731__auto___68149 = G__68151;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.hkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.hkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65584 = conformed_args__63534__auto__;
var map__65584__$1 = (((((!((map__65584 == null))))?(((((map__65584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65584):map__65584);
var css__63537__auto__ = cljs.core.get.call(null,map__65584__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65584__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65584__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"hkern",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.hkern.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.hkern.cljs$lang$applyTo = (function (seq65566){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65566));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (keygen "hello")
 * (keygen nil "hello")
 * 
 * These two are made equivalent at compile time
 * (keygen {:onClick f} "hello")
 * (keygen #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (keygen :#the-id.klass.other-klass "hello")
 * (keygen :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.keygen = (function fulcro$client$dom$keygen(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68155 = arguments.length;
var i__4731__auto___68156 = (0);
while(true){
if((i__4731__auto___68156 < len__4730__auto___68155)){
args__4736__auto__.push((arguments[i__4731__auto___68156]));

var G__68157 = (i__4731__auto___68156 + (1));
i__4731__auto___68156 = G__68157;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.keygen.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.keygen.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65632 = conformed_args__63534__auto__;
var map__65632__$1 = (((((!((map__65632 == null))))?(((((map__65632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65632):map__65632);
var css__63537__auto__ = cljs.core.get.call(null,map__65632__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65632__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65632__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"keygen",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.keygen.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.keygen.cljs$lang$applyTo = (function (seq65612){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65612));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-format "hello")
 * (font-face-format nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-format {:onClick f} "hello")
 * (font-face-format #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-format :#the-id.klass.other-klass "hello")
 * (font-face-format :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font_face_format = (function fulcro$client$dom$font_face_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68159 = arguments.length;
var i__4731__auto___68160 = (0);
while(true){
if((i__4731__auto___68160 < len__4730__auto___68159)){
args__4736__auto__.push((arguments[i__4731__auto___68160]));

var G__68162 = (i__4731__auto___68160 + (1));
i__4731__auto___68160 = G__68162;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65636 = conformed_args__63534__auto__;
var map__65636__$1 = (((((!((map__65636 == null))))?(((((map__65636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65636):map__65636);
var css__63537__auto__ = cljs.core.get.call(null,map__65636__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65636__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65636__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font-face-format",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font_face_format.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font_face_format.cljs$lang$applyTo = (function (seq65634){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65634));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncA "hello")
 * (feFuncA nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncA {:onClick f} "hello")
 * (feFuncA #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncA :#the-id.klass.other-klass "hello")
 * (feFuncA :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feFuncA = (function fulcro$client$dom$feFuncA(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68164 = arguments.length;
var i__4731__auto___68165 = (0);
while(true){
if((i__4731__auto___68165 < len__4730__auto___68164)){
args__4736__auto__.push((arguments[i__4731__auto___68165]));

var G__68167 = (i__4731__auto___68165 + (1));
i__4731__auto___68165 = G__68167;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65642 = conformed_args__63534__auto__;
var map__65642__$1 = (((((!((map__65642 == null))))?(((((map__65642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65642):map__65642);
var css__63537__auto__ = cljs.core.get.call(null,map__65642__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65642__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65642__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feFuncA",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feFuncA.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feFuncA.cljs$lang$applyTo = (function (seq65638){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65638));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (progress "hello")
 * (progress nil "hello")
 * 
 * These two are made equivalent at compile time
 * (progress {:onClick f} "hello")
 * (progress #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (progress :#the-id.klass.other-klass "hello")
 * (progress :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.progress = (function fulcro$client$dom$progress(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68172 = arguments.length;
var i__4731__auto___68173 = (0);
while(true){
if((i__4731__auto___68173 < len__4730__auto___68172)){
args__4736__auto__.push((arguments[i__4731__auto___68173]));

var G__68174 = (i__4731__auto___68173 + (1));
i__4731__auto___68173 = G__68174;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.progress.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.progress.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65657 = conformed_args__63534__auto__;
var map__65657__$1 = (((((!((map__65657 == null))))?(((((map__65657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65657):map__65657);
var css__63537__auto__ = cljs.core.get.call(null,map__65657__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65657__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65657__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"progress",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.progress.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.progress.cljs$lang$applyTo = (function (seq65650){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65650));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (main "hello")
 * (main nil "hello")
 * 
 * These two are made equivalent at compile time
 * (main {:onClick f} "hello")
 * (main #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (main :#the-id.klass.other-klass "hello")
 * (main :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.main = (function fulcro$client$dom$main(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68181 = arguments.length;
var i__4731__auto___68182 = (0);
while(true){
if((i__4731__auto___68182 < len__4730__auto___68181)){
args__4736__auto__.push((arguments[i__4731__auto___68182]));

var G__68183 = (i__4731__auto___68182 + (1));
i__4731__auto___68182 = G__68183;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.main.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.main.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65670 = conformed_args__63534__auto__;
var map__65670__$1 = (((((!((map__65670 == null))))?(((((map__65670.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65670.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65670):map__65670);
var css__63537__auto__ = cljs.core.get.call(null,map__65670__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65670__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65670__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"main",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.main.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.main.cljs$lang$applyTo = (function (seq65666){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65666));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cite "hello")
 * (cite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cite {:onClick f} "hello")
 * (cite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cite :#the-id.klass.other-klass "hello")
 * (cite :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.cite = (function fulcro$client$dom$cite(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68191 = arguments.length;
var i__4731__auto___68192 = (0);
while(true){
if((i__4731__auto___68192 < len__4730__auto___68191)){
args__4736__auto__.push((arguments[i__4731__auto___68192]));

var G__68193 = (i__4731__auto___68192 + (1));
i__4731__auto___68192 = G__68193;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.cite.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.cite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65682 = conformed_args__63534__auto__;
var map__65682__$1 = (((((!((map__65682 == null))))?(((((map__65682.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65682.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65682):map__65682);
var css__63537__auto__ = cljs.core.get.call(null,map__65682__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65682__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65682__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"cite",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.cite.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.cite.cljs$lang$applyTo = (function (seq65678){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65678));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rect "hello")
 * (rect nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rect {:onClick f} "hello")
 * (rect #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rect :#the-id.klass.other-klass "hello")
 * (rect :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.rect = (function fulcro$client$dom$rect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68200 = arguments.length;
var i__4731__auto___68201 = (0);
while(true){
if((i__4731__auto___68201 < len__4730__auto___68200)){
args__4736__auto__.push((arguments[i__4731__auto___68201]));

var G__68202 = (i__4731__auto___68201 + (1));
i__4731__auto___68201 = G__68202;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.rect.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.rect.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65693 = conformed_args__63534__auto__;
var map__65693__$1 = (((((!((map__65693 == null))))?(((((map__65693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65693):map__65693);
var css__63537__auto__ = cljs.core.get.call(null,map__65693__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65693__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65693__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"rect",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.rect.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.rect.cljs$lang$applyTo = (function (seq65692){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65692));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tref "hello")
 * (tref nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tref {:onClick f} "hello")
 * (tref #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tref :#the-id.klass.other-klass "hello")
 * (tref :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.tref = (function fulcro$client$dom$tref(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68207 = arguments.length;
var i__4731__auto___68210 = (0);
while(true){
if((i__4731__auto___68210 < len__4730__auto___68207)){
args__4736__auto__.push((arguments[i__4731__auto___68210]));

var G__68211 = (i__4731__auto___68210 + (1));
i__4731__auto___68210 = G__68211;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.tref.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.tref.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65703 = conformed_args__63534__auto__;
var map__65703__$1 = (((((!((map__65703 == null))))?(((((map__65703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65703.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65703):map__65703);
var css__63537__auto__ = cljs.core.get.call(null,map__65703__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65703__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65703__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"tref",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.tref.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.tref.cljs$lang$applyTo = (function (seq65697){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65697));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshpatch "hello")
 * (meshpatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshpatch {:onClick f} "hello")
 * (meshpatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshpatch :#the-id.klass.other-klass "hello")
 * (meshpatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.meshpatch = (function fulcro$client$dom$meshpatch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68216 = arguments.length;
var i__4731__auto___68217 = (0);
while(true){
if((i__4731__auto___68217 < len__4730__auto___68216)){
args__4736__auto__.push((arguments[i__4731__auto___68217]));

var G__68219 = (i__4731__auto___68217 + (1));
i__4731__auto___68217 = G__68219;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65712 = conformed_args__63534__auto__;
var map__65712__$1 = (((((!((map__65712 == null))))?(((((map__65712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65712):map__65712);
var css__63537__auto__ = cljs.core.get.call(null,map__65712__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65712__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65712__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"meshpatch",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.meshpatch.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.meshpatch.cljs$lang$applyTo = (function (seq65711){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65711));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polyline "hello")
 * (polyline nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polyline {:onClick f} "hello")
 * (polyline #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polyline :#the-id.klass.other-klass "hello")
 * (polyline :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.polyline = (function fulcro$client$dom$polyline(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68226 = arguments.length;
var i__4731__auto___68227 = (0);
while(true){
if((i__4731__auto___68227 < len__4730__auto___68226)){
args__4736__auto__.push((arguments[i__4731__auto___68227]));

var G__68229 = (i__4731__auto___68227 + (1));
i__4731__auto___68227 = G__68229;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.polyline.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.polyline.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65719 = conformed_args__63534__auto__;
var map__65719__$1 = (((((!((map__65719 == null))))?(((((map__65719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65719):map__65719);
var css__63537__auto__ = cljs.core.get.call(null,map__65719__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65719__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65719__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"polyline",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.polyline.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.polyline.cljs$lang$applyTo = (function (seq65714){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65714));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (metadata "hello")
 * (metadata nil "hello")
 * 
 * These two are made equivalent at compile time
 * (metadata {:onClick f} "hello")
 * (metadata #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (metadata :#the-id.klass.other-klass "hello")
 * (metadata :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.metadata = (function fulcro$client$dom$metadata(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68242 = arguments.length;
var i__4731__auto___68243 = (0);
while(true){
if((i__4731__auto___68243 < len__4730__auto___68242)){
args__4736__auto__.push((arguments[i__4731__auto___68243]));

var G__68244 = (i__4731__auto___68243 + (1));
i__4731__auto___68243 = G__68244;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.metadata.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65727 = conformed_args__63534__auto__;
var map__65727__$1 = (((((!((map__65727 == null))))?(((((map__65727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65727):map__65727);
var css__63537__auto__ = cljs.core.get.call(null,map__65727__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65727__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65727__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"metadata",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.metadata.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.metadata.cljs$lang$applyTo = (function (seq65725){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65725));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (map "hello")
 * (map nil "hello")
 * 
 * These two are made equivalent at compile time
 * (map {:onClick f} "hello")
 * (map #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (map :#the-id.klass.other-klass "hello")
 * (map :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.map = (function fulcro$client$dom$map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68249 = arguments.length;
var i__4731__auto___68250 = (0);
while(true){
if((i__4731__auto___68250 < len__4730__auto___68249)){
args__4736__auto__.push((arguments[i__4731__auto___68250]));

var G__68251 = (i__4731__auto___68250 + (1));
i__4731__auto___68250 = G__68251;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.map.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65734 = conformed_args__63534__auto__;
var map__65734__$1 = (((((!((map__65734 == null))))?(((((map__65734.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65734.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65734):map__65734);
var css__63537__auto__ = cljs.core.get.call(null,map__65734__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65734__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65734__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"map",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.map.cljs$lang$applyTo = (function (seq65732){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65732));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (object "hello")
 * (object nil "hello")
 * 
 * These two are made equivalent at compile time
 * (object {:onClick f} "hello")
 * (object #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (object :#the-id.klass.other-klass "hello")
 * (object :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.object = (function fulcro$client$dom$object(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68255 = arguments.length;
var i__4731__auto___68256 = (0);
while(true){
if((i__4731__auto___68256 < len__4730__auto___68255)){
args__4736__auto__.push((arguments[i__4731__auto___68256]));

var G__68257 = (i__4731__auto___68256 + (1));
i__4731__auto___68256 = G__68257;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.object.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.object.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65745 = conformed_args__63534__auto__;
var map__65745__$1 = (((((!((map__65745 == null))))?(((((map__65745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65745):map__65745);
var css__63537__auto__ = cljs.core.get.call(null,map__65745__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65745__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65745__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"object",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.object.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.object.cljs$lang$applyTo = (function (seq65741){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65741));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (i "hello")
 * (i nil "hello")
 * 
 * These two are made equivalent at compile time
 * (i {:onClick f} "hello")
 * (i #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (i :#the-id.klass.other-klass "hello")
 * (i :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.i = (function fulcro$client$dom$i(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68269 = arguments.length;
var i__4731__auto___68272 = (0);
while(true){
if((i__4731__auto___68272 < len__4730__auto___68269)){
args__4736__auto__.push((arguments[i__4731__auto___68272]));

var G__68284 = (i__4731__auto___68272 + (1));
i__4731__auto___68272 = G__68284;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.i.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.i.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65752 = conformed_args__63534__auto__;
var map__65752__$1 = (((((!((map__65752 == null))))?(((((map__65752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65752.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65752):map__65752);
var css__63537__auto__ = cljs.core.get.call(null,map__65752__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65752__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65752__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"i",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.i.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.i.cljs$lang$applyTo = (function (seq65751){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65751));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-name "hello")
 * (font-face-name nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-name {:onClick f} "hello")
 * (font-face-name #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-name :#the-id.klass.other-klass "hello")
 * (font-face-name :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font_face_name = (function fulcro$client$dom$font_face_name(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68290 = arguments.length;
var i__4731__auto___68291 = (0);
while(true){
if((i__4731__auto___68291 < len__4730__auto___68290)){
args__4736__auto__.push((arguments[i__4731__auto___68291]));

var G__68292 = (i__4731__auto___68291 + (1));
i__4731__auto___68291 = G__68292;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65756 = conformed_args__63534__auto__;
var map__65756__$1 = (((((!((map__65756 == null))))?(((((map__65756.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65756.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65756):map__65756);
var css__63537__auto__ = cljs.core.get.call(null,map__65756__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65756__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65756__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font-face-name",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font_face_name.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font_face_name.cljs$lang$applyTo = (function (seq65755){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65755));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (p "hello")
 * (p nil "hello")
 * 
 * These two are made equivalent at compile time
 * (p {:onClick f} "hello")
 * (p #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (p :#the-id.klass.other-klass "hello")
 * (p :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.p = (function fulcro$client$dom$p(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68311 = arguments.length;
var i__4731__auto___68312 = (0);
while(true){
if((i__4731__auto___68312 < len__4730__auto___68311)){
args__4736__auto__.push((arguments[i__4731__auto___68312]));

var G__68314 = (i__4731__auto___68312 + (1));
i__4731__auto___68312 = G__68314;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.p.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.p.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65766 = conformed_args__63534__auto__;
var map__65766__$1 = (((((!((map__65766 == null))))?(((((map__65766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65766.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65766):map__65766);
var css__63537__auto__ = cljs.core.get.call(null,map__65766__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65766__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65766__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"p",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.p.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.p.cljs$lang$applyTo = (function (seq65765){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65765));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncR "hello")
 * (feFuncR nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncR {:onClick f} "hello")
 * (feFuncR #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncR :#the-id.klass.other-klass "hello")
 * (feFuncR :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feFuncR = (function fulcro$client$dom$feFuncR(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68329 = arguments.length;
var i__4731__auto___68332 = (0);
while(true){
if((i__4731__auto___68332 < len__4730__auto___68329)){
args__4736__auto__.push((arguments[i__4731__auto___68332]));

var G__68334 = (i__4731__auto___68332 + (1));
i__4731__auto___68332 = G__68334;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65776 = conformed_args__63534__auto__;
var map__65776__$1 = (((((!((map__65776 == null))))?(((((map__65776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65776.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65776):map__65776);
var css__63537__auto__ = cljs.core.get.call(null,map__65776__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65776__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65776__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feFuncR",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feFuncR.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feFuncR.cljs$lang$applyTo = (function (seq65774){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65774));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatchpath "hello")
 * (hatchpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatchpath {:onClick f} "hello")
 * (hatchpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatchpath :#the-id.klass.other-klass "hello")
 * (hatchpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.hatchpath = (function fulcro$client$dom$hatchpath(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68343 = arguments.length;
var i__4731__auto___68344 = (0);
while(true){
if((i__4731__auto___68344 < len__4730__auto___68343)){
args__4736__auto__.push((arguments[i__4731__auto___68344]));

var G__68347 = (i__4731__auto___68344 + (1));
i__4731__auto___68344 = G__68347;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65790 = conformed_args__63534__auto__;
var map__65790__$1 = (((((!((map__65790 == null))))?(((((map__65790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65790):map__65790);
var css__63537__auto__ = cljs.core.get.call(null,map__65790__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65790__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65790__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"hatchpath",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.hatchpath.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.hatchpath.cljs$lang$applyTo = (function (seq65783){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65783));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem "hello")
 * (altGlyphItem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem {:onClick f} "hello")
 * (altGlyphItem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphItem :#the-id.klass.other-klass "hello")
 * (altGlyphItem :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.altGlyphItem = (function fulcro$client$dom$altGlyphItem(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68362 = arguments.length;
var i__4731__auto___68363 = (0);
while(true){
if((i__4731__auto___68363 < len__4730__auto___68362)){
args__4736__auto__.push((arguments[i__4731__auto___68363]));

var G__68364 = (i__4731__auto___68363 + (1));
i__4731__auto___68363 = G__68364;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65794 = conformed_args__63534__auto__;
var map__65794__$1 = (((((!((map__65794 == null))))?(((((map__65794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65794.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65794):map__65794);
var css__63537__auto__ = cljs.core.get.call(null,map__65794__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65794__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65794__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"altGlyphItem",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.altGlyphItem.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.altGlyphItem.cljs$lang$applyTo = (function (seq65792){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65792));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (nav "hello")
 * (nav nil "hello")
 * 
 * These two are made equivalent at compile time
 * (nav {:onClick f} "hello")
 * (nav #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (nav :#the-id.klass.other-klass "hello")
 * (nav :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.nav = (function fulcro$client$dom$nav(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68374 = arguments.length;
var i__4731__auto___68375 = (0);
while(true){
if((i__4731__auto___68375 < len__4730__auto___68374)){
args__4736__auto__.push((arguments[i__4731__auto___68375]));

var G__68376 = (i__4731__auto___68375 + (1));
i__4731__auto___68375 = G__68376;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.nav.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.nav.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65804 = conformed_args__63534__auto__;
var map__65804__$1 = (((((!((map__65804 == null))))?(((((map__65804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65804):map__65804);
var css__63537__auto__ = cljs.core.get.call(null,map__65804__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65804__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65804__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"nav",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.nav.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.nav.cljs$lang$applyTo = (function (seq65799){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65799));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ruby "hello")
 * (ruby nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ruby {:onClick f} "hello")
 * (ruby #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ruby :#the-id.klass.other-klass "hello")
 * (ruby :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.ruby = (function fulcro$client$dom$ruby(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68386 = arguments.length;
var i__4731__auto___68387 = (0);
while(true){
if((i__4731__auto___68387 < len__4730__auto___68386)){
args__4736__auto__.push((arguments[i__4731__auto___68387]));

var G__68390 = (i__4731__auto___68387 + (1));
i__4731__auto___68387 = G__68390;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.ruby.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.ruby.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65809 = conformed_args__63534__auto__;
var map__65809__$1 = (((((!((map__65809 == null))))?(((((map__65809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65809):map__65809);
var css__63537__auto__ = cljs.core.get.call(null,map__65809__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65809__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65809__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"ruby",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.ruby.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.ruby.cljs$lang$applyTo = (function (seq65808){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65808));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (switch "hello")
 * (switch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (switch {:onClick f} "hello")
 * (switch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (switch :#the-id.klass.other-klass "hello")
 * (switch :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.switch$ = (function fulcro$client$dom$switch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68405 = arguments.length;
var i__4731__auto___68407 = (0);
while(true){
if((i__4731__auto___68407 < len__4730__auto___68405)){
args__4736__auto__.push((arguments[i__4731__auto___68407]));

var G__68409 = (i__4731__auto___68407 + (1));
i__4731__auto___68407 = G__68409;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.switch$.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.switch$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65826 = conformed_args__63534__auto__;
var map__65826__$1 = (((((!((map__65826 == null))))?(((((map__65826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65826.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65826):map__65826);
var css__63537__auto__ = cljs.core.get.call(null,map__65826__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65826__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65826__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"switch",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.switch$.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.switch$.cljs$lang$applyTo = (function (seq65814){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65814));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (a "hello")
 * (a nil "hello")
 * 
 * These two are made equivalent at compile time
 * (a {:onClick f} "hello")
 * (a #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (a :#the-id.klass.other-klass "hello")
 * (a :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.a = (function fulcro$client$dom$a(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68423 = arguments.length;
var i__4731__auto___68424 = (0);
while(true){
if((i__4731__auto___68424 < len__4730__auto___68423)){
args__4736__auto__.push((arguments[i__4731__auto___68424]));

var G__68427 = (i__4731__auto___68424 + (1));
i__4731__auto___68424 = G__68427;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.a.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.a.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65834 = conformed_args__63534__auto__;
var map__65834__$1 = (((((!((map__65834 == null))))?(((((map__65834.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65834.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65834):map__65834);
var css__63537__auto__ = cljs.core.get.call(null,map__65834__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65834__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65834__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"a",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.a.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.a.cljs$lang$applyTo = (function (seq65831){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65831));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (view "hello")
 * (view nil "hello")
 * 
 * These two are made equivalent at compile time
 * (view {:onClick f} "hello")
 * (view #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (view :#the-id.klass.other-klass "hello")
 * (view :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.view = (function fulcro$client$dom$view(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68432 = arguments.length;
var i__4731__auto___68434 = (0);
while(true){
if((i__4731__auto___68434 < len__4730__auto___68432)){
args__4736__auto__.push((arguments[i__4731__auto___68434]));

var G__68435 = (i__4731__auto___68434 + (1));
i__4731__auto___68434 = G__68435;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.view.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.view.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65839 = conformed_args__63534__auto__;
var map__65839__$1 = (((((!((map__65839 == null))))?(((((map__65839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65839.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65839):map__65839);
var css__63537__auto__ = cljs.core.get.call(null,map__65839__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65839__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65839__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"view",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.view.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.view.cljs$lang$applyTo = (function (seq65837){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65837));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menu "hello")
 * (menu nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menu {:onClick f} "hello")
 * (menu #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menu :#the-id.klass.other-klass "hello")
 * (menu :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.menu = (function fulcro$client$dom$menu(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68442 = arguments.length;
var i__4731__auto___68444 = (0);
while(true){
if((i__4731__auto___68444 < len__4730__auto___68442)){
args__4736__auto__.push((arguments[i__4731__auto___68444]));

var G__68445 = (i__4731__auto___68444 + (1));
i__4731__auto___68444 = G__68445;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.menu.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.menu.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65849 = conformed_args__63534__auto__;
var map__65849__$1 = (((((!((map__65849 == null))))?(((((map__65849.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65849.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65849):map__65849);
var css__63537__auto__ = cljs.core.get.call(null,map__65849__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65849__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65849__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"menu",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.menu.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.menu.cljs$lang$applyTo = (function (seq65847){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65847));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (blockquote "hello")
 * (blockquote nil "hello")
 * 
 * These two are made equivalent at compile time
 * (blockquote {:onClick f} "hello")
 * (blockquote #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (blockquote :#the-id.klass.other-klass "hello")
 * (blockquote :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.blockquote = (function fulcro$client$dom$blockquote(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68453 = arguments.length;
var i__4731__auto___68454 = (0);
while(true){
if((i__4731__auto___68454 < len__4730__auto___68453)){
args__4736__auto__.push((arguments[i__4731__auto___68454]));

var G__68456 = (i__4731__auto___68454 + (1));
i__4731__auto___68454 = G__68456;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65861 = conformed_args__63534__auto__;
var map__65861__$1 = (((((!((map__65861 == null))))?(((((map__65861.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65861.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65861):map__65861);
var css__63537__auto__ = cljs.core.get.call(null,map__65861__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65861__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65861__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"blockquote",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.blockquote.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.blockquote.cljs$lang$applyTo = (function (seq65857){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65857));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (img "hello")
 * (img nil "hello")
 * 
 * These two are made equivalent at compile time
 * (img {:onClick f} "hello")
 * (img #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (img :#the-id.klass.other-klass "hello")
 * (img :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.img = (function fulcro$client$dom$img(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68464 = arguments.length;
var i__4731__auto___68466 = (0);
while(true){
if((i__4731__auto___68466 < len__4730__auto___68464)){
args__4736__auto__.push((arguments[i__4731__auto___68466]));

var G__68470 = (i__4731__auto___68466 + (1));
i__4731__auto___68466 = G__68470;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.img.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.img.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65867 = conformed_args__63534__auto__;
var map__65867__$1 = (((((!((map__65867 == null))))?(((((map__65867.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65867.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65867):map__65867);
var css__63537__auto__ = cljs.core.get.call(null,map__65867__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65867__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65867__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"img",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.img.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.img.cljs$lang$applyTo = (function (seq65866){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65866));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncG "hello")
 * (feFuncG nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncG {:onClick f} "hello")
 * (feFuncG #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncG :#the-id.klass.other-klass "hello")
 * (feFuncG :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feFuncG = (function fulcro$client$dom$feFuncG(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68476 = arguments.length;
var i__4731__auto___68477 = (0);
while(true){
if((i__4731__auto___68477 < len__4730__auto___68476)){
args__4736__auto__.push((arguments[i__4731__auto___68477]));

var G__68479 = (i__4731__auto___68477 + (1));
i__4731__auto___68477 = G__68479;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65878 = conformed_args__63534__auto__;
var map__65878__$1 = (((((!((map__65878 == null))))?(((((map__65878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65878):map__65878);
var css__63537__auto__ = cljs.core.get.call(null,map__65878__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65878__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65878__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feFuncG",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feFuncG.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feFuncG.cljs$lang$applyTo = (function (seq65871){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65871));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (text "hello")
 * (text nil "hello")
 * 
 * These two are made equivalent at compile time
 * (text {:onClick f} "hello")
 * (text #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (text :#the-id.klass.other-klass "hello")
 * (text :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.text = (function fulcro$client$dom$text(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68485 = arguments.length;
var i__4731__auto___68486 = (0);
while(true){
if((i__4731__auto___68486 < len__4730__auto___68485)){
args__4736__auto__.push((arguments[i__4731__auto___68486]));

var G__68487 = (i__4731__auto___68486 + (1));
i__4731__auto___68486 = G__68487;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.text.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.text.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65886 = conformed_args__63534__auto__;
var map__65886__$1 = (((((!((map__65886 == null))))?(((((map__65886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65886):map__65886);
var css__63537__auto__ = cljs.core.get.call(null,map__65886__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65886__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65886__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"text",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.text.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.text.cljs$lang$applyTo = (function (seq65884){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65884));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (span "hello")
 * (span nil "hello")
 * 
 * These two are made equivalent at compile time
 * (span {:onClick f} "hello")
 * (span #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (span :#the-id.klass.other-klass "hello")
 * (span :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.span = (function fulcro$client$dom$span(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68488 = arguments.length;
var i__4731__auto___68490 = (0);
while(true){
if((i__4731__auto___68490 < len__4730__auto___68488)){
args__4736__auto__.push((arguments[i__4731__auto___68490]));

var G__68492 = (i__4731__auto___68490 + (1));
i__4731__auto___68490 = G__68492;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.span.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.span.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65900 = conformed_args__63534__auto__;
var map__65900__$1 = (((((!((map__65900 == null))))?(((((map__65900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65900):map__65900);
var css__63537__auto__ = cljs.core.get.call(null,map__65900__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65900__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65900__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"span",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.span.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.span.cljs$lang$applyTo = (function (seq65896){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65896));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (track "hello")
 * (track nil "hello")
 * 
 * These two are made equivalent at compile time
 * (track {:onClick f} "hello")
 * (track #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (track :#the-id.klass.other-klass "hello")
 * (track :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.track = (function fulcro$client$dom$track(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68501 = arguments.length;
var i__4731__auto___68502 = (0);
while(true){
if((i__4731__auto___68502 < len__4730__auto___68501)){
args__4736__auto__.push((arguments[i__4731__auto___68502]));

var G__68505 = (i__4731__auto___68502 + (1));
i__4731__auto___68502 = G__68505;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.track.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.track.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65908 = conformed_args__63534__auto__;
var map__65908__$1 = (((((!((map__65908 == null))))?(((((map__65908.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65908.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65908):map__65908);
var css__63537__auto__ = cljs.core.get.call(null,map__65908__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65908__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65908__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"track",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.track.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.track.cljs$lang$applyTo = (function (seq65903){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65903));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (data "hello")
 * (data nil "hello")
 * 
 * These two are made equivalent at compile time
 * (data {:onClick f} "hello")
 * (data #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (data :#the-id.klass.other-klass "hello")
 * (data :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.data = (function fulcro$client$dom$data(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68519 = arguments.length;
var i__4731__auto___68520 = (0);
while(true){
if((i__4731__auto___68520 < len__4730__auto___68519)){
args__4736__auto__.push((arguments[i__4731__auto___68520]));

var G__68522 = (i__4731__auto___68520 + (1));
i__4731__auto___68520 = G__68522;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.data.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.data.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65916 = conformed_args__63534__auto__;
var map__65916__$1 = (((((!((map__65916 == null))))?(((((map__65916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65916.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65916):map__65916);
var css__63537__auto__ = cljs.core.get.call(null,map__65916__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65916__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65916__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"data",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.data.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.data.cljs$lang$applyTo = (function (seq65914){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65914));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (u "hello")
 * (u nil "hello")
 * 
 * These two are made equivalent at compile time
 * (u {:onClick f} "hello")
 * (u #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (u :#the-id.klass.other-klass "hello")
 * (u :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.u = (function fulcro$client$dom$u(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68539 = arguments.length;
var i__4731__auto___68541 = (0);
while(true){
if((i__4731__auto___68541 < len__4730__auto___68539)){
args__4736__auto__.push((arguments[i__4731__auto___68541]));

var G__68543 = (i__4731__auto___68541 + (1));
i__4731__auto___68541 = G__68543;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.u.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.u.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65919 = conformed_args__63534__auto__;
var map__65919__$1 = (((((!((map__65919 == null))))?(((((map__65919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65919):map__65919);
var css__63537__auto__ = cljs.core.get.call(null,map__65919__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65919__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65919__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"u",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.u.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.u.cljs$lang$applyTo = (function (seq65918){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65918));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dl "hello")
 * (dl nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dl {:onClick f} "hello")
 * (dl #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dl :#the-id.klass.other-klass "hello")
 * (dl :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.dl = (function fulcro$client$dom$dl(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68552 = arguments.length;
var i__4731__auto___68553 = (0);
while(true){
if((i__4731__auto___68553 < len__4730__auto___68552)){
args__4736__auto__.push((arguments[i__4731__auto___68553]));

var G__68554 = (i__4731__auto___68553 + (1));
i__4731__auto___68553 = G__68554;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.dl.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.dl.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65922 = conformed_args__63534__auto__;
var map__65922__$1 = (((((!((map__65922 == null))))?(((((map__65922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65922):map__65922);
var css__63537__auto__ = cljs.core.get.call(null,map__65922__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65922__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65922__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"dl",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.dl.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.dl.cljs$lang$applyTo = (function (seq65921){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65921));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (select "hello")
 * (select nil "hello")
 * 
 * These two are made equivalent at compile time
 * (select {:onClick f} "hello")
 * (select #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (select :#the-id.klass.other-klass "hello")
 * (select :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.select = (function fulcro$client$dom$select(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68565 = arguments.length;
var i__4731__auto___68566 = (0);
while(true){
if((i__4731__auto___68566 < len__4730__auto___68565)){
args__4736__auto__.push((arguments[i__4731__auto___68566]));

var G__68567 = (i__4731__auto___68566 + (1));
i__4731__auto___68566 = G__68567;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.select.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.select.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65927 = conformed_args__63534__auto__;
var map__65927__$1 = (((((!((map__65927 == null))))?(((((map__65927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65927.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65927):map__65927);
var css__63537__auto__ = cljs.core.get.call(null,map__65927__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65927__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65927__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"select",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.select.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.select.cljs$lang$applyTo = (function (seq65924){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65924));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polygon "hello")
 * (polygon nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polygon {:onClick f} "hello")
 * (polygon #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polygon :#the-id.klass.other-klass "hello")
 * (polygon :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.polygon = (function fulcro$client$dom$polygon(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68572 = arguments.length;
var i__4731__auto___68573 = (0);
while(true){
if((i__4731__auto___68573 < len__4730__auto___68572)){
args__4736__auto__.push((arguments[i__4731__auto___68573]));

var G__68574 = (i__4731__auto___68573 + (1));
i__4731__auto___68573 = G__68574;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.polygon.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.polygon.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65931 = conformed_args__63534__auto__;
var map__65931__$1 = (((((!((map__65931 == null))))?(((((map__65931.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65931.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65931):map__65931);
var css__63537__auto__ = cljs.core.get.call(null,map__65931__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65931__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65931__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"polygon",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.polygon.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.polygon.cljs$lang$applyTo = (function (seq65930){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65930));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pattern "hello")
 * (pattern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pattern {:onClick f} "hello")
 * (pattern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pattern :#the-id.klass.other-klass "hello")
 * (pattern :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.pattern = (function fulcro$client$dom$pattern(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68577 = arguments.length;
var i__4731__auto___68578 = (0);
while(true){
if((i__4731__auto___68578 < len__4730__auto___68577)){
args__4736__auto__.push((arguments[i__4731__auto___68578]));

var G__68580 = (i__4731__auto___68578 + (1));
i__4731__auto___68578 = G__68580;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.pattern.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.pattern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65939 = conformed_args__63534__auto__;
var map__65939__$1 = (((((!((map__65939 == null))))?(((((map__65939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65939.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65939):map__65939);
var css__63537__auto__ = cljs.core.get.call(null,map__65939__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65939__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65939__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"pattern",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.pattern.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.pattern.cljs$lang$applyTo = (function (seq65937){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65937));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (html "hello")
 * (html nil "hello")
 * 
 * These two are made equivalent at compile time
 * (html {:onClick f} "hello")
 * (html #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (html :#the-id.klass.other-klass "hello")
 * (html :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.html = (function fulcro$client$dom$html(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68584 = arguments.length;
var i__4731__auto___68585 = (0);
while(true){
if((i__4731__auto___68585 < len__4730__auto___68584)){
args__4736__auto__.push((arguments[i__4731__auto___68585]));

var G__68588 = (i__4731__auto___68585 + (1));
i__4731__auto___68585 = G__68588;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.html.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.html.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65945 = conformed_args__63534__auto__;
var map__65945__$1 = (((((!((map__65945 == null))))?(((((map__65945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65945.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65945):map__65945);
var css__63537__auto__ = cljs.core.get.call(null,map__65945__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65945__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65945__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"html",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.html.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.html.cljs$lang$applyTo = (function (seq65943){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65943));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (foreignObject "hello")
 * (foreignObject nil "hello")
 * 
 * These two are made equivalent at compile time
 * (foreignObject {:onClick f} "hello")
 * (foreignObject #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (foreignObject :#the-id.klass.other-klass "hello")
 * (foreignObject :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.foreignObject = (function fulcro$client$dom$foreignObject(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68594 = arguments.length;
var i__4731__auto___68595 = (0);
while(true){
if((i__4731__auto___68595 < len__4730__auto___68594)){
args__4736__auto__.push((arguments[i__4731__auto___68595]));

var G__68596 = (i__4731__auto___68595 + (1));
i__4731__auto___68595 = G__68596;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65954 = conformed_args__63534__auto__;
var map__65954__$1 = (((((!((map__65954 == null))))?(((((map__65954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65954.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65954):map__65954);
var css__63537__auto__ = cljs.core.get.call(null,map__65954__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65954__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65954__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"foreignObject",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.foreignObject.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.foreignObject.cljs$lang$applyTo = (function (seq65953){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65953));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (thead "hello")
 * (thead nil "hello")
 * 
 * These two are made equivalent at compile time
 * (thead {:onClick f} "hello")
 * (thead #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (thead :#the-id.klass.other-klass "hello")
 * (thead :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.thead = (function fulcro$client$dom$thead(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68603 = arguments.length;
var i__4731__auto___68604 = (0);
while(true){
if((i__4731__auto___68604 < len__4730__auto___68603)){
args__4736__auto__.push((arguments[i__4731__auto___68604]));

var G__68605 = (i__4731__auto___68604 + (1));
i__4731__auto___68604 = G__68605;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.thead.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.thead.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65961 = conformed_args__63534__auto__;
var map__65961__$1 = (((((!((map__65961 == null))))?(((((map__65961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65961):map__65961);
var css__63537__auto__ = cljs.core.get.call(null,map__65961__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65961__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65961__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"thead",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.thead.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.thead.cljs$lang$applyTo = (function (seq65958){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65958));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (path "hello")
 * (path nil "hello")
 * 
 * These two are made equivalent at compile time
 * (path {:onClick f} "hello")
 * (path #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (path :#the-id.klass.other-klass "hello")
 * (path :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.path = (function fulcro$client$dom$path(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68614 = arguments.length;
var i__4731__auto___68615 = (0);
while(true){
if((i__4731__auto___68615 < len__4730__auto___68614)){
args__4736__auto__.push((arguments[i__4731__auto___68615]));

var G__68616 = (i__4731__auto___68615 + (1));
i__4731__auto___68615 = G__68616;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.path.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.path.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65966 = conformed_args__63534__auto__;
var map__65966__$1 = (((((!((map__65966 == null))))?(((((map__65966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65966):map__65966);
var css__63537__auto__ = cljs.core.get.call(null,map__65966__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65966__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65966__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"path",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.path.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.path.cljs$lang$applyTo = (function (seq65964){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65964));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (del "hello")
 * (del nil "hello")
 * 
 * These two are made equivalent at compile time
 * (del {:onClick f} "hello")
 * (del #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (del :#the-id.klass.other-klass "hello")
 * (del :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.del = (function fulcro$client$dom$del(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68624 = arguments.length;
var i__4731__auto___68625 = (0);
while(true){
if((i__4731__auto___68625 < len__4730__auto___68624)){
args__4736__auto__.push((arguments[i__4731__auto___68625]));

var G__68628 = (i__4731__auto___68625 + (1));
i__4731__auto___68625 = G__68628;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.del.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.del.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65974 = conformed_args__63534__auto__;
var map__65974__$1 = (((((!((map__65974 == null))))?(((((map__65974.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65974.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65974):map__65974);
var css__63537__auto__ = cljs.core.get.call(null,map__65974__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65974__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65974__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"del",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.del.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.del.cljs$lang$applyTo = (function (seq65968){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65968));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyph "hello")
 * (altGlyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyph {:onClick f} "hello")
 * (altGlyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyph :#the-id.klass.other-klass "hello")
 * (altGlyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.altGlyph = (function fulcro$client$dom$altGlyph(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68635 = arguments.length;
var i__4731__auto___68636 = (0);
while(true){
if((i__4731__auto___68636 < len__4730__auto___68635)){
args__4736__auto__.push((arguments[i__4731__auto___68636]));

var G__68638 = (i__4731__auto___68636 + (1));
i__4731__auto___68636 = G__68638;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65978 = conformed_args__63534__auto__;
var map__65978__$1 = (((((!((map__65978 == null))))?(((((map__65978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65978.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65978):map__65978);
var css__63537__auto__ = cljs.core.get.call(null,map__65978__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65978__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65978__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"altGlyph",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.altGlyph.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.altGlyph.cljs$lang$applyTo = (function (seq65977){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65977));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fieldset "hello")
 * (fieldset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fieldset {:onClick f} "hello")
 * (fieldset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fieldset :#the-id.klass.other-klass "hello")
 * (fieldset :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.fieldset = (function fulcro$client$dom$fieldset(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68649 = arguments.length;
var i__4731__auto___68650 = (0);
while(true){
if((i__4731__auto___68650 < len__4730__auto___68649)){
args__4736__auto__.push((arguments[i__4731__auto___68650]));

var G__68651 = (i__4731__auto___68650 + (1));
i__4731__auto___68650 = G__68651;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65983 = conformed_args__63534__auto__;
var map__65983__$1 = (((((!((map__65983 == null))))?(((((map__65983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65983.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65983):map__65983);
var css__63537__auto__ = cljs.core.get.call(null,map__65983__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65983__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65983__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"fieldset",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.fieldset.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.fieldset.cljs$lang$applyTo = (function (seq65981){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65981));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (aside "hello")
 * (aside nil "hello")
 * 
 * These two are made equivalent at compile time
 * (aside {:onClick f} "hello")
 * (aside #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (aside :#the-id.klass.other-klass "hello")
 * (aside :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.aside = (function fulcro$client$dom$aside(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68656 = arguments.length;
var i__4731__auto___68658 = (0);
while(true){
if((i__4731__auto___68658 < len__4730__auto___68656)){
args__4736__auto__.push((arguments[i__4731__auto___68658]));

var G__68661 = (i__4731__auto___68658 + (1));
i__4731__auto___68658 = G__68661;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.aside.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.aside.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65991 = conformed_args__63534__auto__;
var map__65991__$1 = (((((!((map__65991 == null))))?(((((map__65991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65991):map__65991);
var css__63537__auto__ = cljs.core.get.call(null,map__65991__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65991__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65991__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"aside",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.aside.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.aside.cljs$lang$applyTo = (function (seq65990){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65990));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feBlend "hello")
 * (feBlend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feBlend {:onClick f} "hello")
 * (feBlend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feBlend :#the-id.klass.other-klass "hello")
 * (feBlend :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feBlend = (function fulcro$client$dom$feBlend(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68671 = arguments.length;
var i__4731__auto___68672 = (0);
while(true){
if((i__4731__auto___68672 < len__4730__auto___68671)){
args__4736__auto__.push((arguments[i__4731__auto___68672]));

var G__68674 = (i__4731__auto___68672 + (1));
i__4731__auto___68672 = G__68674;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__65996 = conformed_args__63534__auto__;
var map__65996__$1 = (((((!((map__65996 == null))))?(((((map__65996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65996.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65996):map__65996);
var css__63537__auto__ = cljs.core.get.call(null,map__65996__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__65996__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__65996__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feBlend",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feBlend.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feBlend.cljs$lang$applyTo = (function (seq65995){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65995));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figure "hello")
 * (figure nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figure {:onClick f} "hello")
 * (figure #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figure :#the-id.klass.other-klass "hello")
 * (figure :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.figure = (function fulcro$client$dom$figure(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68678 = arguments.length;
var i__4731__auto___68679 = (0);
while(true){
if((i__4731__auto___68679 < len__4730__auto___68678)){
args__4736__auto__.push((arguments[i__4731__auto___68679]));

var G__68680 = (i__4731__auto___68679 + (1));
i__4731__auto___68679 = G__68680;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.figure.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.figure.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66000 = conformed_args__63534__auto__;
var map__66000__$1 = (((((!((map__66000 == null))))?(((((map__66000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66000):map__66000);
var css__63537__auto__ = cljs.core.get.call(null,map__66000__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66000__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66000__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"figure",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.figure.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.figure.cljs$lang$applyTo = (function (seq65999){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65999));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textPath "hello")
 * (textPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textPath {:onClick f} "hello")
 * (textPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textPath :#the-id.klass.other-klass "hello")
 * (textPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.textPath = (function fulcro$client$dom$textPath(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68695 = arguments.length;
var i__4731__auto___68696 = (0);
while(true){
if((i__4731__auto___68696 < len__4730__auto___68695)){
args__4736__auto__.push((arguments[i__4731__auto___68696]));

var G__68697 = (i__4731__auto___68696 + (1));
i__4731__auto___68696 = G__68697;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.textPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.textPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66006 = conformed_args__63534__auto__;
var map__66006__$1 = (((((!((map__66006 == null))))?(((((map__66006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66006):map__66006);
var css__63537__auto__ = cljs.core.get.call(null,map__66006__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66006__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66006__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"textPath",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.textPath.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.textPath.cljs$lang$applyTo = (function (seq66002){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66002));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figcaption "hello")
 * (figcaption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figcaption {:onClick f} "hello")
 * (figcaption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figcaption :#the-id.klass.other-klass "hello")
 * (figcaption :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.figcaption = (function fulcro$client$dom$figcaption(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68711 = arguments.length;
var i__4731__auto___68712 = (0);
while(true){
if((i__4731__auto___68712 < len__4730__auto___68711)){
args__4736__auto__.push((arguments[i__4731__auto___68712]));

var G__68713 = (i__4731__auto___68712 + (1));
i__4731__auto___68712 = G__68713;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66016 = conformed_args__63534__auto__;
var map__66016__$1 = (((((!((map__66016 == null))))?(((((map__66016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66016):map__66016);
var css__63537__auto__ = cljs.core.get.call(null,map__66016__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66016__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66016__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"figcaption",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.figcaption.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.figcaption.cljs$lang$applyTo = (function (seq66010){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66010));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mask "hello")
 * (mask nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mask {:onClick f} "hello")
 * (mask #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mask :#the-id.klass.other-klass "hello")
 * (mask :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.mask = (function fulcro$client$dom$mask(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68722 = arguments.length;
var i__4731__auto___68723 = (0);
while(true){
if((i__4731__auto___68723 < len__4730__auto___68722)){
args__4736__auto__.push((arguments[i__4731__auto___68723]));

var G__68724 = (i__4731__auto___68723 + (1));
i__4731__auto___68723 = G__68724;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.mask.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.mask.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66023 = conformed_args__63534__auto__;
var map__66023__$1 = (((((!((map__66023 == null))))?(((((map__66023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66023.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66023):map__66023);
var css__63537__auto__ = cljs.core.get.call(null,map__66023__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66023__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66023__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"mask",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.mask.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.mask.cljs$lang$applyTo = (function (seq66021){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66021));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (q "hello")
 * (q nil "hello")
 * 
 * These two are made equivalent at compile time
 * (q {:onClick f} "hello")
 * (q #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (q :#the-id.klass.other-klass "hello")
 * (q :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.q = (function fulcro$client$dom$q(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68739 = arguments.length;
var i__4731__auto___68740 = (0);
while(true){
if((i__4731__auto___68740 < len__4730__auto___68739)){
args__4736__auto__.push((arguments[i__4731__auto___68740]));

var G__68741 = (i__4731__auto___68740 + (1));
i__4731__auto___68740 = G__68741;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.q.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.q.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66029 = conformed_args__63534__auto__;
var map__66029__$1 = (((((!((map__66029 == null))))?(((((map__66029.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66029.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66029):map__66029);
var css__63537__auto__ = cljs.core.get.call(null,map__66029__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66029__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66029__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"q",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.q.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.q.cljs$lang$applyTo = (function (seq66026){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66026));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdi "hello")
 * (bdi nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdi {:onClick f} "hello")
 * (bdi #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdi :#the-id.klass.other-klass "hello")
 * (bdi :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.bdi = (function fulcro$client$dom$bdi(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68751 = arguments.length;
var i__4731__auto___68752 = (0);
while(true){
if((i__4731__auto___68752 < len__4730__auto___68751)){
args__4736__auto__.push((arguments[i__4731__auto___68752]));

var G__68753 = (i__4731__auto___68752 + (1));
i__4731__auto___68752 = G__68753;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.bdi.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.bdi.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66043 = conformed_args__63534__auto__;
var map__66043__$1 = (((((!((map__66043 == null))))?(((((map__66043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66043.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66043):map__66043);
var css__63537__auto__ = cljs.core.get.call(null,map__66043__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66043__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66043__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"bdi",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.bdi.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.bdi.cljs$lang$applyTo = (function (seq66038){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66038));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDistantLight "hello")
 * (feDistantLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDistantLight {:onClick f} "hello")
 * (feDistantLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDistantLight :#the-id.klass.other-klass "hello")
 * (feDistantLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feDistantLight = (function fulcro$client$dom$feDistantLight(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68766 = arguments.length;
var i__4731__auto___68767 = (0);
while(true){
if((i__4731__auto___68767 < len__4730__auto___68766)){
args__4736__auto__.push((arguments[i__4731__auto___68767]));

var G__68768 = (i__4731__auto___68767 + (1));
i__4731__auto___68767 = G__68768;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66050 = conformed_args__63534__auto__;
var map__66050__$1 = (((((!((map__66050 == null))))?(((((map__66050.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66050.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66050):map__66050);
var css__63537__auto__ = cljs.core.get.call(null,map__66050__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66050__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66050__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feDistantLight",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feDistantLight.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feDistantLight.cljs$lang$applyTo = (function (seq66048){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66048));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (video "hello")
 * (video nil "hello")
 * 
 * These two are made equivalent at compile time
 * (video {:onClick f} "hello")
 * (video #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (video :#the-id.klass.other-klass "hello")
 * (video :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.video = (function fulcro$client$dom$video(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68777 = arguments.length;
var i__4731__auto___68778 = (0);
while(true){
if((i__4731__auto___68778 < len__4730__auto___68777)){
args__4736__auto__.push((arguments[i__4731__auto___68778]));

var G__68779 = (i__4731__auto___68778 + (1));
i__4731__auto___68778 = G__68779;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.video.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.video.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66071 = conformed_args__63534__auto__;
var map__66071__$1 = (((((!((map__66071 == null))))?(((((map__66071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66071.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66071):map__66071);
var css__63537__auto__ = cljs.core.get.call(null,map__66071__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66071__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66071__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"video",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.video.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.video.cljs$lang$applyTo = (function (seq66063){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66063));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (address "hello")
 * (address nil "hello")
 * 
 * These two are made equivalent at compile time
 * (address {:onClick f} "hello")
 * (address #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (address :#the-id.klass.other-klass "hello")
 * (address :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.address = (function fulcro$client$dom$address(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68793 = arguments.length;
var i__4731__auto___68794 = (0);
while(true){
if((i__4731__auto___68794 < len__4730__auto___68793)){
args__4736__auto__.push((arguments[i__4731__auto___68794]));

var G__68795 = (i__4731__auto___68794 + (1));
i__4731__auto___68794 = G__68795;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.address.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.address.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66082 = conformed_args__63534__auto__;
var map__66082__$1 = (((((!((map__66082 == null))))?(((((map__66082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66082.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66082):map__66082);
var css__63537__auto__ = cljs.core.get.call(null,map__66082__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66082__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66082__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"address",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.address.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.address.cljs$lang$applyTo = (function (seq66079){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66079));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (caption "hello")
 * (caption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (caption {:onClick f} "hello")
 * (caption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (caption :#the-id.klass.other-klass "hello")
 * (caption :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.caption = (function fulcro$client$dom$caption(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68804 = arguments.length;
var i__4731__auto___68805 = (0);
while(true){
if((i__4731__auto___68805 < len__4730__auto___68804)){
args__4736__auto__.push((arguments[i__4731__auto___68805]));

var G__68808 = (i__4731__auto___68805 + (1));
i__4731__auto___68805 = G__68808;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.caption.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.caption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66085 = conformed_args__63534__auto__;
var map__66085__$1 = (((((!((map__66085 == null))))?(((((map__66085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66085.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66085):map__66085);
var css__63537__auto__ = cljs.core.get.call(null,map__66085__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66085__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66085__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"caption",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.caption.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.caption.cljs$lang$applyTo = (function (seq66084){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66084));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dd "hello")
 * (dd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dd {:onClick f} "hello")
 * (dd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dd :#the-id.klass.other-klass "hello")
 * (dd :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.dd = (function fulcro$client$dom$dd(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68811 = arguments.length;
var i__4731__auto___68812 = (0);
while(true){
if((i__4731__auto___68812 < len__4730__auto___68811)){
args__4736__auto__.push((arguments[i__4731__auto___68812]));

var G__68814 = (i__4731__auto___68812 + (1));
i__4731__auto___68812 = G__68814;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.dd.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.dd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66091 = conformed_args__63534__auto__;
var map__66091__$1 = (((((!((map__66091 == null))))?(((((map__66091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66091.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66091):map__66091);
var css__63537__auto__ = cljs.core.get.call(null,map__66091__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66091__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66091__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"dd",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.dd.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.dd.cljs$lang$applyTo = (function (seq66088){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66088));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rp "hello")
 * (rp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rp {:onClick f} "hello")
 * (rp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rp :#the-id.klass.other-klass "hello")
 * (rp :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.rp = (function fulcro$client$dom$rp(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68824 = arguments.length;
var i__4731__auto___68825 = (0);
while(true){
if((i__4731__auto___68825 < len__4730__auto___68824)){
args__4736__auto__.push((arguments[i__4731__auto___68825]));

var G__68826 = (i__4731__auto___68825 + (1));
i__4731__auto___68825 = G__68826;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.rp.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.rp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66098 = conformed_args__63534__auto__;
var map__66098__$1 = (((((!((map__66098 == null))))?(((((map__66098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66098):map__66098);
var css__63537__auto__ = cljs.core.get.call(null,map__66098__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66098__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66098__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"rp",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.rp.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.rp.cljs$lang$applyTo = (function (seq66094){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66094));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hr "hello")
 * (hr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hr {:onClick f} "hello")
 * (hr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hr :#the-id.klass.other-klass "hello")
 * (hr :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.hr = (function fulcro$client$dom$hr(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68836 = arguments.length;
var i__4731__auto___68837 = (0);
while(true){
if((i__4731__auto___68837 < len__4730__auto___68836)){
args__4736__auto__.push((arguments[i__4731__auto___68837]));

var G__68838 = (i__4731__auto___68837 + (1));
i__4731__auto___68837 = G__68838;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.hr.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.hr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66111 = conformed_args__63534__auto__;
var map__66111__$1 = (((((!((map__66111 == null))))?(((((map__66111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66111.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66111):map__66111);
var css__63537__auto__ = cljs.core.get.call(null,map__66111__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66111__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66111__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"hr",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.hr.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.hr.cljs$lang$applyTo = (function (seq66103){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66103));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meta "hello")
 * (meta nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meta {:onClick f} "hello")
 * (meta #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meta :#the-id.klass.other-klass "hello")
 * (meta :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.meta = (function fulcro$client$dom$meta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68841 = arguments.length;
var i__4731__auto___68842 = (0);
while(true){
if((i__4731__auto___68842 < len__4730__auto___68841)){
args__4736__auto__.push((arguments[i__4731__auto___68842]));

var G__68844 = (i__4731__auto___68842 + (1));
i__4731__auto___68842 = G__68844;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.meta.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66118 = conformed_args__63534__auto__;
var map__66118__$1 = (((((!((map__66118 == null))))?(((((map__66118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66118.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66118):map__66118);
var css__63537__auto__ = cljs.core.get.call(null,map__66118__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66118__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66118__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"meta",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.meta.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.meta.cljs$lang$applyTo = (function (seq66116){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66116));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tbody "hello")
 * (tbody nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tbody {:onClick f} "hello")
 * (tbody #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tbody :#the-id.klass.other-klass "hello")
 * (tbody :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.tbody = (function fulcro$client$dom$tbody(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68850 = arguments.length;
var i__4731__auto___68851 = (0);
while(true){
if((i__4731__auto___68851 < len__4730__auto___68850)){
args__4736__auto__.push((arguments[i__4731__auto___68851]));

var G__68852 = (i__4731__auto___68851 + (1));
i__4731__auto___68851 = G__68852;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.tbody.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.tbody.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66125 = conformed_args__63534__auto__;
var map__66125__$1 = (((((!((map__66125 == null))))?(((((map__66125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66125):map__66125);
var css__63537__auto__ = cljs.core.get.call(null,map__66125__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66125__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66125__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"tbody",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.tbody.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.tbody.cljs$lang$applyTo = (function (seq66124){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66124));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (desc "hello")
 * (desc nil "hello")
 * 
 * These two are made equivalent at compile time
 * (desc {:onClick f} "hello")
 * (desc #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (desc :#the-id.klass.other-klass "hello")
 * (desc :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.desc = (function fulcro$client$dom$desc(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68859 = arguments.length;
var i__4731__auto___68862 = (0);
while(true){
if((i__4731__auto___68862 < len__4730__auto___68859)){
args__4736__auto__.push((arguments[i__4731__auto___68862]));

var G__68864 = (i__4731__auto___68862 + (1));
i__4731__auto___68862 = G__68864;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.desc.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.desc.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66132 = conformed_args__63534__auto__;
var map__66132__$1 = (((((!((map__66132 == null))))?(((((map__66132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66132):map__66132);
var css__63537__auto__ = cljs.core.get.call(null,map__66132__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66132__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66132__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"desc",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.desc.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.desc.cljs$lang$applyTo = (function (seq66130){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66130));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (table "hello")
 * (table nil "hello")
 * 
 * These two are made equivalent at compile time
 * (table {:onClick f} "hello")
 * (table #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (table :#the-id.klass.other-klass "hello")
 * (table :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.table = (function fulcro$client$dom$table(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68871 = arguments.length;
var i__4731__auto___68872 = (0);
while(true){
if((i__4731__auto___68872 < len__4730__auto___68871)){
args__4736__auto__.push((arguments[i__4731__auto___68872]));

var G__68873 = (i__4731__auto___68872 + (1));
i__4731__auto___68872 = G__68873;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.table.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.table.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66143 = conformed_args__63534__auto__;
var map__66143__$1 = (((((!((map__66143 == null))))?(((((map__66143.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66143.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66143):map__66143);
var css__63537__auto__ = cljs.core.get.call(null,map__66143__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66143__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66143__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"table",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.table.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.table.cljs$lang$applyTo = (function (seq66140){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66140));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pre "hello")
 * (pre nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pre {:onClick f} "hello")
 * (pre #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pre :#the-id.klass.other-klass "hello")
 * (pre :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.pre = (function fulcro$client$dom$pre(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68879 = arguments.length;
var i__4731__auto___68880 = (0);
while(true){
if((i__4731__auto___68880 < len__4730__auto___68879)){
args__4736__auto__.push((arguments[i__4731__auto___68880]));

var G__68881 = (i__4731__auto___68880 + (1));
i__4731__auto___68880 = G__68881;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.pre.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.pre.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66161 = conformed_args__63534__auto__;
var map__66161__$1 = (((((!((map__66161 == null))))?(((((map__66161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66161.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66161):map__66161);
var css__63537__auto__ = cljs.core.get.call(null,map__66161__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66161__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66161__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"pre",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.pre.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.pre.cljs$lang$applyTo = (function (seq66155){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66155));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ul "hello")
 * (ul nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ul {:onClick f} "hello")
 * (ul #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ul :#the-id.klass.other-klass "hello")
 * (ul :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.ul = (function fulcro$client$dom$ul(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68887 = arguments.length;
var i__4731__auto___68888 = (0);
while(true){
if((i__4731__auto___68888 < len__4730__auto___68887)){
args__4736__auto__.push((arguments[i__4731__auto___68888]));

var G__68890 = (i__4731__auto___68888 + (1));
i__4731__auto___68888 = G__68890;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.ul.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.ul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66174 = conformed_args__63534__auto__;
var map__66174__$1 = (((((!((map__66174 == null))))?(((((map__66174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66174.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66174):map__66174);
var css__63537__auto__ = cljs.core.get.call(null,map__66174__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66174__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66174__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"ul",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.ul.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.ul.cljs$lang$applyTo = (function (seq66169){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66169));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix "hello")
 * (feConvolveMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix {:onClick f} "hello")
 * (feConvolveMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feConvolveMatrix :#the-id.klass.other-klass "hello")
 * (feConvolveMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feConvolveMatrix = (function fulcro$client$dom$feConvolveMatrix(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68904 = arguments.length;
var i__4731__auto___68905 = (0);
while(true){
if((i__4731__auto___68905 < len__4730__auto___68904)){
args__4736__auto__.push((arguments[i__4731__auto___68905]));

var G__68908 = (i__4731__auto___68905 + (1));
i__4731__auto___68905 = G__68908;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66186 = conformed_args__63534__auto__;
var map__66186__$1 = (((((!((map__66186 == null))))?(((((map__66186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66186):map__66186);
var css__63537__auto__ = cljs.core.get.call(null,map__66186__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66186__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66186__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feConvolveMatrix",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feConvolveMatrix.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feConvolveMatrix.cljs$lang$applyTo = (function (seq66182){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66182));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sup "hello")
 * (sup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sup {:onClick f} "hello")
 * (sup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sup :#the-id.klass.other-klass "hello")
 * (sup :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.sup = (function fulcro$client$dom$sup(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68922 = arguments.length;
var i__4731__auto___68923 = (0);
while(true){
if((i__4731__auto___68923 < len__4730__auto___68922)){
args__4736__auto__.push((arguments[i__4731__auto___68923]));

var G__68924 = (i__4731__auto___68923 + (1));
i__4731__auto___68923 = G__68924;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.sup.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.sup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66205 = conformed_args__63534__auto__;
var map__66205__$1 = (((((!((map__66205 == null))))?(((((map__66205.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66205.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66205):map__66205);
var css__63537__auto__ = cljs.core.get.call(null,map__66205__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66205__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66205__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"sup",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.sup.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.sup.cljs$lang$applyTo = (function (seq66195){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66195));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dfn "hello")
 * (dfn nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dfn {:onClick f} "hello")
 * (dfn #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dfn :#the-id.klass.other-klass "hello")
 * (dfn :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.dfn = (function fulcro$client$dom$dfn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68936 = arguments.length;
var i__4731__auto___68937 = (0);
while(true){
if((i__4731__auto___68937 < len__4730__auto___68936)){
args__4736__auto__.push((arguments[i__4731__auto___68937]));

var G__68938 = (i__4731__auto___68937 + (1));
i__4731__auto___68937 = G__68938;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.dfn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.dfn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66237 = conformed_args__63534__auto__;
var map__66237__$1 = (((((!((map__66237 == null))))?(((((map__66237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66237):map__66237);
var css__63537__auto__ = cljs.core.get.call(null,map__66237__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66237__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66237__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"dfn",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.dfn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.dfn.cljs$lang$applyTo = (function (seq66220){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66220));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sub "hello")
 * (sub nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sub {:onClick f} "hello")
 * (sub #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sub :#the-id.klass.other-klass "hello")
 * (sub :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.sub = (function fulcro$client$dom$sub(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68947 = arguments.length;
var i__4731__auto___68948 = (0);
while(true){
if((i__4731__auto___68948 < len__4730__auto___68947)){
args__4736__auto__.push((arguments[i__4731__auto___68948]));

var G__68951 = (i__4731__auto___68948 + (1));
i__4731__auto___68948 = G__68951;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66284 = conformed_args__63534__auto__;
var map__66284__$1 = (((((!((map__66284 == null))))?(((((map__66284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66284):map__66284);
var css__63537__auto__ = cljs.core.get.call(null,map__66284__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66284__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66284__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"sub",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.sub.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.sub.cljs$lang$applyTo = (function (seq66263){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66263));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mark "hello")
 * (mark nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mark {:onClick f} "hello")
 * (mark #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mark :#the-id.klass.other-klass "hello")
 * (mark :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.mark = (function fulcro$client$dom$mark(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68960 = arguments.length;
var i__4731__auto___68962 = (0);
while(true){
if((i__4731__auto___68962 < len__4730__auto___68960)){
args__4736__auto__.push((arguments[i__4731__auto___68962]));

var G__68965 = (i__4731__auto___68962 + (1));
i__4731__auto___68962 = G__68965;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.mark.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.mark.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66307 = conformed_args__63534__auto__;
var map__66307__$1 = (((((!((map__66307 == null))))?(((((map__66307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66307.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66307):map__66307);
var css__63537__auto__ = cljs.core.get.call(null,map__66307__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66307__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66307__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"mark",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.mark.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.mark.cljs$lang$applyTo = (function (seq66299){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66299));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap "hello")
 * (feDisplacementMap nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap {:onClick f} "hello")
 * (feDisplacementMap #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDisplacementMap :#the-id.klass.other-klass "hello")
 * (feDisplacementMap :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feDisplacementMap = (function fulcro$client$dom$feDisplacementMap(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68977 = arguments.length;
var i__4731__auto___68978 = (0);
while(true){
if((i__4731__auto___68978 < len__4730__auto___68977)){
args__4736__auto__.push((arguments[i__4731__auto___68978]));

var G__68979 = (i__4731__auto___68978 + (1));
i__4731__auto___68978 = G__68979;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66331 = conformed_args__63534__auto__;
var map__66331__$1 = (((((!((map__66331 == null))))?(((((map__66331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66331.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66331):map__66331);
var css__63537__auto__ = cljs.core.get.call(null,map__66331__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66331__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66331__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feDisplacementMap",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feDisplacementMap.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feDisplacementMap.cljs$lang$applyTo = (function (seq66322){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66322));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (unknown "hello")
 * (unknown nil "hello")
 * 
 * These two are made equivalent at compile time
 * (unknown {:onClick f} "hello")
 * (unknown #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (unknown :#the-id.klass.other-klass "hello")
 * (unknown :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.unknown = (function fulcro$client$dom$unknown(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68989 = arguments.length;
var i__4731__auto___68990 = (0);
while(true){
if((i__4731__auto___68990 < len__4730__auto___68989)){
args__4736__auto__.push((arguments[i__4731__auto___68990]));

var G__68991 = (i__4731__auto___68990 + (1));
i__4731__auto___68990 = G__68991;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.unknown.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.unknown.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66364 = conformed_args__63534__auto__;
var map__66364__$1 = (((((!((map__66364 == null))))?(((((map__66364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66364.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66364):map__66364);
var css__63537__auto__ = cljs.core.get.call(null,map__66364__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66364__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66364__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"unknown",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.unknown.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.unknown.cljs$lang$applyTo = (function (seq66350){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66350));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (script "hello")
 * (script nil "hello")
 * 
 * These two are made equivalent at compile time
 * (script {:onClick f} "hello")
 * (script #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (script :#the-id.klass.other-klass "hello")
 * (script :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.script = (function fulcro$client$dom$script(var_args){
var args__4736__auto__ = [];
var len__4730__auto___68998 = arguments.length;
var i__4731__auto___68999 = (0);
while(true){
if((i__4731__auto___68999 < len__4730__auto___68998)){
args__4736__auto__.push((arguments[i__4731__auto___68999]));

var G__69000 = (i__4731__auto___68999 + (1));
i__4731__auto___68999 = G__69000;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.script.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.script.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66399 = conformed_args__63534__auto__;
var map__66399__$1 = (((((!((map__66399 == null))))?(((((map__66399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66399):map__66399);
var css__63537__auto__ = cljs.core.get.call(null,map__66399__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66399__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66399__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"script",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.script.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.script.cljs$lang$applyTo = (function (seq66396){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66396));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTurbulence "hello")
 * (feTurbulence nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTurbulence {:onClick f} "hello")
 * (feTurbulence #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTurbulence :#the-id.klass.other-klass "hello")
 * (feTurbulence :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feTurbulence = (function fulcro$client$dom$feTurbulence(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69006 = arguments.length;
var i__4731__auto___69007 = (0);
while(true){
if((i__4731__auto___69007 < len__4730__auto___69006)){
args__4736__auto__.push((arguments[i__4731__auto___69007]));

var G__69009 = (i__4731__auto___69007 + (1));
i__4731__auto___69007 = G__69009;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66414 = conformed_args__63534__auto__;
var map__66414__$1 = (((((!((map__66414 == null))))?(((((map__66414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66414):map__66414);
var css__63537__auto__ = cljs.core.get.call(null,map__66414__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66414__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66414__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feTurbulence",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feTurbulence.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feTurbulence.cljs$lang$applyTo = (function (seq66406){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66406));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (big "hello")
 * (big nil "hello")
 * 
 * These two are made equivalent at compile time
 * (big {:onClick f} "hello")
 * (big #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (big :#the-id.klass.other-klass "hello")
 * (big :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.big = (function fulcro$client$dom$big(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69013 = arguments.length;
var i__4731__auto___69014 = (0);
while(true){
if((i__4731__auto___69014 < len__4730__auto___69013)){
args__4736__auto__.push((arguments[i__4731__auto___69014]));

var G__69015 = (i__4731__auto___69014 + (1));
i__4731__auto___69014 = G__69015;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.big.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.big.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66428 = conformed_args__63534__auto__;
var map__66428__$1 = (((((!((map__66428 == null))))?(((((map__66428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66428):map__66428);
var css__63537__auto__ = cljs.core.get.call(null,map__66428__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66428__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66428__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"big",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.big.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.big.cljs$lang$applyTo = (function (seq66423){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66423));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (button "hello")
 * (button nil "hello")
 * 
 * These two are made equivalent at compile time
 * (button {:onClick f} "hello")
 * (button #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (button :#the-id.klass.other-klass "hello")
 * (button :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.button = (function fulcro$client$dom$button(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69018 = arguments.length;
var i__4731__auto___69020 = (0);
while(true){
if((i__4731__auto___69020 < len__4730__auto___69018)){
args__4736__auto__.push((arguments[i__4731__auto___69020]));

var G__69021 = (i__4731__auto___69020 + (1));
i__4731__auto___69020 = G__69021;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.button.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.button.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66439 = conformed_args__63534__auto__;
var map__66439__$1 = (((((!((map__66439 == null))))?(((((map__66439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66439.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66439):map__66439);
var css__63537__auto__ = cljs.core.get.call(null,map__66439__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66439__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66439__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"button",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.button.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.button.cljs$lang$applyTo = (function (seq66434){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66434));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-uri "hello")
 * (font-face-uri nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-uri {:onClick f} "hello")
 * (font-face-uri #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-uri :#the-id.klass.other-klass "hello")
 * (font-face-uri :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font_face_uri = (function fulcro$client$dom$font_face_uri(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69031 = arguments.length;
var i__4731__auto___69032 = (0);
while(true){
if((i__4731__auto___69032 < len__4730__auto___69031)){
args__4736__auto__.push((arguments[i__4731__auto___69032]));

var G__69033 = (i__4731__auto___69032 + (1));
i__4731__auto___69032 = G__69033;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66455 = conformed_args__63534__auto__;
var map__66455__$1 = (((((!((map__66455 == null))))?(((((map__66455.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66455.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66455):map__66455);
var css__63537__auto__ = cljs.core.get.call(null,map__66455__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66455__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66455__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font-face-uri",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font_face_uri.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font_face_uri.cljs$lang$applyTo = (function (seq66449){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66449));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (wbr "hello")
 * (wbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (wbr {:onClick f} "hello")
 * (wbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (wbr :#the-id.klass.other-klass "hello")
 * (wbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.wbr = (function fulcro$client$dom$wbr(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69038 = arguments.length;
var i__4731__auto___69040 = (0);
while(true){
if((i__4731__auto___69040 < len__4730__auto___69038)){
args__4736__auto__.push((arguments[i__4731__auto___69040]));

var G__69041 = (i__4731__auto___69040 + (1));
i__4731__auto___69040 = G__69041;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.wbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.wbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66473 = conformed_args__63534__auto__;
var map__66473__$1 = (((((!((map__66473 == null))))?(((((map__66473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66473):map__66473);
var css__63537__auto__ = cljs.core.get.call(null,map__66473__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66473__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66473__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"wbr",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.wbr.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.wbr.cljs$lang$applyTo = (function (seq66465){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66465));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (symbol "hello")
 * (symbol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (symbol {:onClick f} "hello")
 * (symbol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (symbol :#the-id.klass.other-klass "hello")
 * (symbol :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.symbol = (function fulcro$client$dom$symbol(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69049 = arguments.length;
var i__4731__auto___69050 = (0);
while(true){
if((i__4731__auto___69050 < len__4730__auto___69049)){
args__4736__auto__.push((arguments[i__4731__auto___69050]));

var G__69051 = (i__4731__auto___69050 + (1));
i__4731__auto___69050 = G__69051;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.symbol.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.symbol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66486 = conformed_args__63534__auto__;
var map__66486__$1 = (((((!((map__66486 == null))))?(((((map__66486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66486):map__66486);
var css__63537__auto__ = cljs.core.get.call(null,map__66486__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66486__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66486__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"symbol",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.symbol.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.symbol.cljs$lang$applyTo = (function (seq66478){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66478));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (strong "hello")
 * (strong nil "hello")
 * 
 * These two are made equivalent at compile time
 * (strong {:onClick f} "hello")
 * (strong #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (strong :#the-id.klass.other-klass "hello")
 * (strong :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.strong = (function fulcro$client$dom$strong(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69063 = arguments.length;
var i__4731__auto___69064 = (0);
while(true){
if((i__4731__auto___69064 < len__4730__auto___69063)){
args__4736__auto__.push((arguments[i__4731__auto___69064]));

var G__69065 = (i__4731__auto___69064 + (1));
i__4731__auto___69064 = G__69065;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.strong.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.strong.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66495 = conformed_args__63534__auto__;
var map__66495__$1 = (((((!((map__66495 == null))))?(((((map__66495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66495.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66495):map__66495);
var css__63537__auto__ = cljs.core.get.call(null,map__66495__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66495__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66495__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"strong",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.strong.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.strong.cljs$lang$applyTo = (function (seq66489){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66489));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (use "hello")
 * (use nil "hello")
 * 
 * These two are made equivalent at compile time
 * (use {:onClick f} "hello")
 * (use #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (use :#the-id.klass.other-klass "hello")
 * (use :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.use = (function fulcro$client$dom$use(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69067 = arguments.length;
var i__4731__auto___69068 = (0);
while(true){
if((i__4731__auto___69068 < len__4730__auto___69067)){
args__4736__auto__.push((arguments[i__4731__auto___69068]));

var G__69069 = (i__4731__auto___69068 + (1));
i__4731__auto___69068 = G__69069;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.use.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.use.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66505 = conformed_args__63534__auto__;
var map__66505__$1 = (((((!((map__66505 == null))))?(((((map__66505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66505):map__66505);
var css__63537__auto__ = cljs.core.get.call(null,map__66505__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66505__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66505__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"use",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.use.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.use.cljs$lang$applyTo = (function (seq66503){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66503));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (solidcolor "hello")
 * (solidcolor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (solidcolor {:onClick f} "hello")
 * (solidcolor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (solidcolor :#the-id.klass.other-klass "hello")
 * (solidcolor :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.solidcolor = (function fulcro$client$dom$solidcolor(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69072 = arguments.length;
var i__4731__auto___69073 = (0);
while(true){
if((i__4731__auto___69073 < len__4730__auto___69072)){
args__4736__auto__.push((arguments[i__4731__auto___69073]));

var G__69076 = (i__4731__auto___69073 + (1));
i__4731__auto___69073 = G__69076;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66520 = conformed_args__63534__auto__;
var map__66520__$1 = (((((!((map__66520 == null))))?(((((map__66520.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66520.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66520):map__66520);
var css__63537__auto__ = cljs.core.get.call(null,map__66520__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66520__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66520__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"solidcolor",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.solidcolor.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.solidcolor.cljs$lang$applyTo = (function (seq66510){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66510));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fePointLight "hello")
 * (fePointLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fePointLight {:onClick f} "hello")
 * (fePointLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fePointLight :#the-id.klass.other-klass "hello")
 * (fePointLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.fePointLight = (function fulcro$client$dom$fePointLight(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69099 = arguments.length;
var i__4731__auto___69101 = (0);
while(true){
if((i__4731__auto___69101 < len__4730__auto___69099)){
args__4736__auto__.push((arguments[i__4731__auto___69101]));

var G__69103 = (i__4731__auto___69101 + (1));
i__4731__auto___69101 = G__69103;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66529 = conformed_args__63534__auto__;
var map__66529__$1 = (((((!((map__66529 == null))))?(((((map__66529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66529):map__66529);
var css__63537__auto__ = cljs.core.get.call(null,map__66529__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66529__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66529__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"fePointLight",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.fePointLight.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.fePointLight.cljs$lang$applyTo = (function (seq66524){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66524));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (li "hello")
 * (li nil "hello")
 * 
 * These two are made equivalent at compile time
 * (li {:onClick f} "hello")
 * (li #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (li :#the-id.klass.other-klass "hello")
 * (li :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.li = (function fulcro$client$dom$li(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69112 = arguments.length;
var i__4731__auto___69113 = (0);
while(true){
if((i__4731__auto___69113 < len__4730__auto___69112)){
args__4736__auto__.push((arguments[i__4731__auto___69113]));

var G__69114 = (i__4731__auto___69113 + (1));
i__4731__auto___69113 = G__69114;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.li.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.li.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66557 = conformed_args__63534__auto__;
var map__66557__$1 = (((((!((map__66557 == null))))?(((((map__66557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66557):map__66557);
var css__63537__auto__ = cljs.core.get.call(null,map__66557__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66557__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66557__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"li",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.li.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.li.cljs$lang$applyTo = (function (seq66552){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66552));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dt "hello")
 * (dt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dt {:onClick f} "hello")
 * (dt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dt :#the-id.klass.other-klass "hello")
 * (dt :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.dt = (function fulcro$client$dom$dt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69128 = arguments.length;
var i__4731__auto___69130 = (0);
while(true){
if((i__4731__auto___69130 < len__4730__auto___69128)){
args__4736__auto__.push((arguments[i__4731__auto___69130]));

var G__69132 = (i__4731__auto___69130 + (1));
i__4731__auto___69130 = G__69132;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.dt.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.dt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66573 = conformed_args__63534__auto__;
var map__66573__$1 = (((((!((map__66573 == null))))?(((((map__66573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66573):map__66573);
var css__63537__auto__ = cljs.core.get.call(null,map__66573__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66573__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66573__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"dt",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.dt.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.dt.cljs$lang$applyTo = (function (seq66566){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66566));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncB "hello")
 * (feFuncB nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncB {:onClick f} "hello")
 * (feFuncB #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncB :#the-id.klass.other-klass "hello")
 * (feFuncB :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feFuncB = (function fulcro$client$dom$feFuncB(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69141 = arguments.length;
var i__4731__auto___69142 = (0);
while(true){
if((i__4731__auto___69142 < len__4730__auto___69141)){
args__4736__auto__.push((arguments[i__4731__auto___69142]));

var G__69143 = (i__4731__auto___69142 + (1));
i__4731__auto___69142 = G__69143;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66589 = conformed_args__63534__auto__;
var map__66589__$1 = (((((!((map__66589 == null))))?(((((map__66589.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66589.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66589):map__66589);
var css__63537__auto__ = cljs.core.get.call(null,map__66589__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66589__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66589__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feFuncB",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feFuncB.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feFuncB.cljs$lang$applyTo = (function (seq66582){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66582));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (marker "hello")
 * (marker nil "hello")
 * 
 * These two are made equivalent at compile time
 * (marker {:onClick f} "hello")
 * (marker #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (marker :#the-id.klass.other-klass "hello")
 * (marker :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.marker = (function fulcro$client$dom$marker(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69157 = arguments.length;
var i__4731__auto___69159 = (0);
while(true){
if((i__4731__auto___69159 < len__4730__auto___69157)){
args__4736__auto__.push((arguments[i__4731__auto___69159]));

var G__69160 = (i__4731__auto___69159 + (1));
i__4731__auto___69159 = G__69160;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.marker.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.marker.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66619 = conformed_args__63534__auto__;
var map__66619__$1 = (((((!((map__66619 == null))))?(((((map__66619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66619):map__66619);
var css__63537__auto__ = cljs.core.get.call(null,map__66619__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66619__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66619__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"marker",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.marker.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.marker.cljs$lang$applyTo = (function (seq66611){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66611));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer "hello")
 * (feComponentTransfer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer {:onClick f} "hello")
 * (feComponentTransfer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComponentTransfer :#the-id.klass.other-klass "hello")
 * (feComponentTransfer :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feComponentTransfer = (function fulcro$client$dom$feComponentTransfer(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69177 = arguments.length;
var i__4731__auto___69178 = (0);
while(true){
if((i__4731__auto___69178 < len__4730__auto___69177)){
args__4736__auto__.push((arguments[i__4731__auto___69178]));

var G__69179 = (i__4731__auto___69178 + (1));
i__4731__auto___69178 = G__69179;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66635 = conformed_args__63534__auto__;
var map__66635__$1 = (((((!((map__66635 == null))))?(((((map__66635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66635):map__66635);
var css__63537__auto__ = cljs.core.get.call(null,map__66635__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66635__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66635__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feComponentTransfer",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feComponentTransfer.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feComponentTransfer.cljs$lang$applyTo = (function (seq66628){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66628));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (td "hello")
 * (td nil "hello")
 * 
 * These two are made equivalent at compile time
 * (td {:onClick f} "hello")
 * (td #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (td :#the-id.klass.other-klass "hello")
 * (td :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.td = (function fulcro$client$dom$td(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69198 = arguments.length;
var i__4731__auto___69199 = (0);
while(true){
if((i__4731__auto___69199 < len__4730__auto___69198)){
args__4736__auto__.push((arguments[i__4731__auto___69199]));

var G__69204 = (i__4731__auto___69199 + (1));
i__4731__auto___69199 = G__69204;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.td.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.td.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66651 = conformed_args__63534__auto__;
var map__66651__$1 = (((((!((map__66651 == null))))?(((((map__66651.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66651.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66651):map__66651);
var css__63537__auto__ = cljs.core.get.call(null,map__66651__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66651__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66651__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"td",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.td.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.td.cljs$lang$applyTo = (function (seq66643){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66643));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tr "hello")
 * (tr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tr {:onClick f} "hello")
 * (tr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tr :#the-id.klass.other-klass "hello")
 * (tr :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.tr = (function fulcro$client$dom$tr(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69221 = arguments.length;
var i__4731__auto___69223 = (0);
while(true){
if((i__4731__auto___69223 < len__4730__auto___69221)){
args__4736__auto__.push((arguments[i__4731__auto___69223]));

var G__69224 = (i__4731__auto___69223 + (1));
i__4731__auto___69223 = G__69224;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.tr.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.tr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66682 = conformed_args__63534__auto__;
var map__66682__$1 = (((((!((map__66682 == null))))?(((((map__66682.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66682.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66682):map__66682);
var css__63537__auto__ = cljs.core.get.call(null,map__66682__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66682__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66682__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"tr",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.tr.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.tr.cljs$lang$applyTo = (function (seq66660){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66660));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (circle "hello")
 * (circle nil "hello")
 * 
 * These two are made equivalent at compile time
 * (circle {:onClick f} "hello")
 * (circle #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (circle :#the-id.klass.other-klass "hello")
 * (circle :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.circle = (function fulcro$client$dom$circle(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69242 = arguments.length;
var i__4731__auto___69243 = (0);
while(true){
if((i__4731__auto___69243 < len__4730__auto___69242)){
args__4736__auto__.push((arguments[i__4731__auto___69243]));

var G__69246 = (i__4731__auto___69243 + (1));
i__4731__auto___69243 = G__69246;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.circle.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.circle.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66698 = conformed_args__63534__auto__;
var map__66698__$1 = (((((!((map__66698 == null))))?(((((map__66698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66698):map__66698);
var css__63537__auto__ = cljs.core.get.call(null,map__66698__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66698__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66698__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"circle",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.circle.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.circle.cljs$lang$applyTo = (function (seq66688){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66688));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (section "hello")
 * (section nil "hello")
 * 
 * These two are made equivalent at compile time
 * (section {:onClick f} "hello")
 * (section #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (section :#the-id.klass.other-klass "hello")
 * (section :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.section = (function fulcro$client$dom$section(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69262 = arguments.length;
var i__4731__auto___69263 = (0);
while(true){
if((i__4731__auto___69263 < len__4730__auto___69262)){
args__4736__auto__.push((arguments[i__4731__auto___69263]));

var G__69265 = (i__4731__auto___69263 + (1));
i__4731__auto___69263 = G__69265;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.section.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.section.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66710 = conformed_args__63534__auto__;
var map__66710__$1 = (((((!((map__66710 == null))))?(((((map__66710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66710):map__66710);
var css__63537__auto__ = cljs.core.get.call(null,map__66710__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66710__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66710__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"section",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.section.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.section.cljs$lang$applyTo = (function (seq66706){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66706));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDropShadow "hello")
 * (feDropShadow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDropShadow {:onClick f} "hello")
 * (feDropShadow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDropShadow :#the-id.klass.other-klass "hello")
 * (feDropShadow :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feDropShadow = (function fulcro$client$dom$feDropShadow(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69277 = arguments.length;
var i__4731__auto___69278 = (0);
while(true){
if((i__4731__auto___69278 < len__4730__auto___69277)){
args__4736__auto__.push((arguments[i__4731__auto___69278]));

var G__69280 = (i__4731__auto___69278 + (1));
i__4731__auto___69278 = G__69280;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66723 = conformed_args__63534__auto__;
var map__66723__$1 = (((((!((map__66723 == null))))?(((((map__66723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66723.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66723):map__66723);
var css__63537__auto__ = cljs.core.get.call(null,map__66723__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66723__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66723__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feDropShadow",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feDropShadow.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feDropShadow.cljs$lang$applyTo = (function (seq66719){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66719));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (th "hello")
 * (th nil "hello")
 * 
 * These two are made equivalent at compile time
 * (th {:onClick f} "hello")
 * (th #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (th :#the-id.klass.other-klass "hello")
 * (th :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.th = (function fulcro$client$dom$th(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69296 = arguments.length;
var i__4731__auto___69297 = (0);
while(true){
if((i__4731__auto___69297 < len__4730__auto___69296)){
args__4736__auto__.push((arguments[i__4731__auto___69297]));

var G__69302 = (i__4731__auto___69297 + (1));
i__4731__auto___69297 = G__69302;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.th.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.th.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66752 = conformed_args__63534__auto__;
var map__66752__$1 = (((((!((map__66752 == null))))?(((((map__66752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66752.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66752):map__66752);
var css__63537__auto__ = cljs.core.get.call(null,map__66752__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66752__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66752__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"th",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.th.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.th.cljs$lang$applyTo = (function (seq66748){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66748));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (time "hello")
 * (time nil "hello")
 * 
 * These two are made equivalent at compile time
 * (time {:onClick f} "hello")
 * (time #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (time :#the-id.klass.other-klass "hello")
 * (time :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.time = (function fulcro$client$dom$time(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69316 = arguments.length;
var i__4731__auto___69317 = (0);
while(true){
if((i__4731__auto___69317 < len__4730__auto___69316)){
args__4736__auto__.push((arguments[i__4731__auto___69317]));

var G__69322 = (i__4731__auto___69317 + (1));
i__4731__auto___69317 = G__69322;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.time.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.time.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66767 = conformed_args__63534__auto__;
var map__66767__$1 = (((((!((map__66767 == null))))?(((((map__66767.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66767.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66767):map__66767);
var css__63537__auto__ = cljs.core.get.call(null,map__66767__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66767__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66767__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"time",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.time.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.time.cljs$lang$applyTo = (function (seq66762){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66762));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (optgroup "hello")
 * (optgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (optgroup {:onClick f} "hello")
 * (optgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (optgroup :#the-id.klass.other-klass "hello")
 * (optgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.optgroup = (function fulcro$client$dom$optgroup(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69338 = arguments.length;
var i__4731__auto___69340 = (0);
while(true){
if((i__4731__auto___69340 < len__4730__auto___69338)){
args__4736__auto__.push((arguments[i__4731__auto___69340]));

var G__69341 = (i__4731__auto___69340 + (1));
i__4731__auto___69340 = G__69341;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66781 = conformed_args__63534__auto__;
var map__66781__$1 = (((((!((map__66781 == null))))?(((((map__66781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66781):map__66781);
var css__63537__auto__ = cljs.core.get.call(null,map__66781__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66781__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66781__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"optgroup",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.optgroup.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.optgroup.cljs$lang$applyTo = (function (seq66776){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66776));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (iframe "hello")
 * (iframe nil "hello")
 * 
 * These two are made equivalent at compile time
 * (iframe {:onClick f} "hello")
 * (iframe #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (iframe :#the-id.klass.other-klass "hello")
 * (iframe :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.iframe = (function fulcro$client$dom$iframe(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69361 = arguments.length;
var i__4731__auto___69362 = (0);
while(true){
if((i__4731__auto___69362 < len__4730__auto___69361)){
args__4736__auto__.push((arguments[i__4731__auto___69362]));

var G__69368 = (i__4731__auto___69362 + (1));
i__4731__auto___69362 = G__69368;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.iframe.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.iframe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66793 = conformed_args__63534__auto__;
var map__66793__$1 = (((((!((map__66793 == null))))?(((((map__66793.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66793.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66793):map__66793);
var css__63537__auto__ = cljs.core.get.call(null,map__66793__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66793__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66793__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"iframe",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.iframe.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.iframe.cljs$lang$applyTo = (function (seq66792){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66792));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (color-profile "hello")
 * (color-profile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (color-profile {:onClick f} "hello")
 * (color-profile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (color-profile :#the-id.klass.other-klass "hello")
 * (color-profile :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.color_profile = (function fulcro$client$dom$color_profile(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69383 = arguments.length;
var i__4731__auto___69384 = (0);
while(true){
if((i__4731__auto___69384 < len__4730__auto___69383)){
args__4736__auto__.push((arguments[i__4731__auto___69384]));

var G__69385 = (i__4731__auto___69384 + (1));
i__4731__auto___69384 = G__69385;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66801 = conformed_args__63534__auto__;
var map__66801__$1 = (((((!((map__66801 == null))))?(((((map__66801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66801):map__66801);
var css__63537__auto__ = cljs.core.get.call(null,map__66801__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66801__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66801__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"color-profile",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.color_profile.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.color_profile.cljs$lang$applyTo = (function (seq66798){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66798));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (legend "hello")
 * (legend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (legend {:onClick f} "hello")
 * (legend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (legend :#the-id.klass.other-klass "hello")
 * (legend :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.legend = (function fulcro$client$dom$legend(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69391 = arguments.length;
var i__4731__auto___69393 = (0);
while(true){
if((i__4731__auto___69393 < len__4730__auto___69391)){
args__4736__auto__.push((arguments[i__4731__auto___69393]));

var G__69394 = (i__4731__auto___69393 + (1));
i__4731__auto___69393 = G__69394;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.legend.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.legend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66811 = conformed_args__63534__auto__;
var map__66811__$1 = (((((!((map__66811 == null))))?(((((map__66811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66811.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66811):map__66811);
var css__63537__auto__ = cljs.core.get.call(null,map__66811__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66811__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66811__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"legend",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.legend.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.legend.cljs$lang$applyTo = (function (seq66810){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66810));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (em "hello")
 * (em nil "hello")
 * 
 * These two are made equivalent at compile time
 * (em {:onClick f} "hello")
 * (em #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (em :#the-id.klass.other-klass "hello")
 * (em :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.em = (function fulcro$client$dom$em(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69398 = arguments.length;
var i__4731__auto___69402 = (0);
while(true){
if((i__4731__auto___69402 < len__4730__auto___69398)){
args__4736__auto__.push((arguments[i__4731__auto___69402]));

var G__69408 = (i__4731__auto___69402 + (1));
i__4731__auto___69402 = G__69408;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.em.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.em.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66816 = conformed_args__63534__auto__;
var map__66816__$1 = (((((!((map__66816 == null))))?(((((map__66816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66816):map__66816);
var css__63537__auto__ = cljs.core.get.call(null,map__66816__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66816__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66816__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"em",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.em.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.em.cljs$lang$applyTo = (function (seq66815){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66815));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (kbd "hello")
 * (kbd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (kbd {:onClick f} "hello")
 * (kbd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (kbd :#the-id.klass.other-klass "hello")
 * (kbd :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.kbd = (function fulcro$client$dom$kbd(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69420 = arguments.length;
var i__4731__auto___69421 = (0);
while(true){
if((i__4731__auto___69421 < len__4730__auto___69420)){
args__4736__auto__.push((arguments[i__4731__auto___69421]));

var G__69422 = (i__4731__auto___69421 + (1));
i__4731__auto___69421 = G__69422;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.kbd.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.kbd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66822 = conformed_args__63534__auto__;
var map__66822__$1 = (((((!((map__66822 == null))))?(((((map__66822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66822.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66822):map__66822);
var css__63537__auto__ = cljs.core.get.call(null,map__66822__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66822__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66822__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"kbd",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.kbd.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.kbd.cljs$lang$applyTo = (function (seq66821){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66821));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (article "hello")
 * (article nil "hello")
 * 
 * These two are made equivalent at compile time
 * (article {:onClick f} "hello")
 * (article #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (article :#the-id.klass.other-klass "hello")
 * (article :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.article = (function fulcro$client$dom$article(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69451 = arguments.length;
var i__4731__auto___69452 = (0);
while(true){
if((i__4731__auto___69452 < len__4730__auto___69451)){
args__4736__auto__.push((arguments[i__4731__auto___69452]));

var G__69453 = (i__4731__auto___69452 + (1));
i__4731__auto___69452 = G__69453;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.article.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.article.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66838 = conformed_args__63534__auto__;
var map__66838__$1 = (((((!((map__66838 == null))))?(((((map__66838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66838):map__66838);
var css__63537__auto__ = cljs.core.get.call(null,map__66838__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66838__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66838__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"article",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.article.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.article.cljs$lang$applyTo = (function (seq66832){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66832));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateColor "hello")
 * (animateColor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateColor {:onClick f} "hello")
 * (animateColor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateColor :#the-id.klass.other-klass "hello")
 * (animateColor :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.animateColor = (function fulcro$client$dom$animateColor(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69459 = arguments.length;
var i__4731__auto___69460 = (0);
while(true){
if((i__4731__auto___69460 < len__4730__auto___69459)){
args__4736__auto__.push((arguments[i__4731__auto___69460]));

var G__69461 = (i__4731__auto___69460 + (1));
i__4731__auto___69460 = G__69461;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66841 = conformed_args__63534__auto__;
var map__66841__$1 = (((((!((map__66841 == null))))?(((((map__66841.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66841.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66841):map__66841);
var css__63537__auto__ = cljs.core.get.call(null,map__66841__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66841__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66841__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"animateColor",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.animateColor.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.animateColor.cljs$lang$applyTo = (function (seq66840){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66840));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (clipPath "hello")
 * (clipPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (clipPath {:onClick f} "hello")
 * (clipPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (clipPath :#the-id.klass.other-klass "hello")
 * (clipPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.clipPath = (function fulcro$client$dom$clipPath(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69467 = arguments.length;
var i__4731__auto___69468 = (0);
while(true){
if((i__4731__auto___69468 < len__4730__auto___69467)){
args__4736__auto__.push((arguments[i__4731__auto___69468]));

var G__69469 = (i__4731__auto___69468 + (1));
i__4731__auto___69468 = G__69469;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66846 = conformed_args__63534__auto__;
var map__66846__$1 = (((((!((map__66846 == null))))?(((((map__66846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66846.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66846):map__66846);
var css__63537__auto__ = cljs.core.get.call(null,map__66846__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66846__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66846__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"clipPath",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.clipPath.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.clipPath.cljs$lang$applyTo = (function (seq66844){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66844));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (abbr "hello")
 * (abbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (abbr {:onClick f} "hello")
 * (abbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (abbr :#the-id.klass.other-klass "hello")
 * (abbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.abbr = (function fulcro$client$dom$abbr(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69479 = arguments.length;
var i__4731__auto___69480 = (0);
while(true){
if((i__4731__auto___69480 < len__4730__auto___69479)){
args__4736__auto__.push((arguments[i__4731__auto___69480]));

var G__69481 = (i__4731__auto___69480 + (1));
i__4731__auto___69480 = G__69481;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.abbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.abbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66853 = conformed_args__63534__auto__;
var map__66853__$1 = (((((!((map__66853 == null))))?(((((map__66853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66853):map__66853);
var css__63537__auto__ = cljs.core.get.call(null,map__66853__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66853__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66853__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"abbr",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.abbr.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.abbr.cljs$lang$applyTo = (function (seq66851){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66851));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef "hello")
 * (altGlyphDef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef {:onClick f} "hello")
 * (altGlyphDef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphDef :#the-id.klass.other-klass "hello")
 * (altGlyphDef :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.altGlyphDef = (function fulcro$client$dom$altGlyphDef(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69491 = arguments.length;
var i__4731__auto___69492 = (0);
while(true){
if((i__4731__auto___69492 < len__4730__auto___69491)){
args__4736__auto__.push((arguments[i__4731__auto___69492]));

var G__69493 = (i__4731__auto___69492 + (1));
i__4731__auto___69492 = G__69493;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66860 = conformed_args__63534__auto__;
var map__66860__$1 = (((((!((map__66860 == null))))?(((((map__66860.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66860.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66860):map__66860);
var css__63537__auto__ = cljs.core.get.call(null,map__66860__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66860__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66860__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"altGlyphDef",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.altGlyphDef.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.altGlyphDef.cljs$lang$applyTo = (function (seq66858){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66858));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshrow "hello")
 * (meshrow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshrow {:onClick f} "hello")
 * (meshrow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshrow :#the-id.klass.other-klass "hello")
 * (meshrow :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.meshrow = (function fulcro$client$dom$meshrow(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69536 = arguments.length;
var i__4731__auto___69538 = (0);
while(true){
if((i__4731__auto___69538 < len__4730__auto___69536)){
args__4736__auto__.push((arguments[i__4731__auto___69538]));

var G__69539 = (i__4731__auto___69538 + (1));
i__4731__auto___69538 = G__69539;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66866 = conformed_args__63534__auto__;
var map__66866__$1 = (((((!((map__66866 == null))))?(((((map__66866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66866.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66866):map__66866);
var css__63537__auto__ = cljs.core.get.call(null,map__66866__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66866__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66866__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"meshrow",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.meshrow.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.meshrow.cljs$lang$applyTo = (function (seq66864){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66864));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cursor "hello")
 * (cursor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cursor {:onClick f} "hello")
 * (cursor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cursor :#the-id.klass.other-klass "hello")
 * (cursor :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.cursor = (function fulcro$client$dom$cursor(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69563 = arguments.length;
var i__4731__auto___69565 = (0);
while(true){
if((i__4731__auto___69565 < len__4730__auto___69563)){
args__4736__auto__.push((arguments[i__4731__auto___69565]));

var G__69568 = (i__4731__auto___69565 + (1));
i__4731__auto___69565 = G__69568;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.cursor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66869 = conformed_args__63534__auto__;
var map__66869__$1 = (((((!((map__66869 == null))))?(((((map__66869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66869.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66869):map__66869);
var css__63537__auto__ = cljs.core.get.call(null,map__66869__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66869__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66869__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"cursor",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.cursor.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.cursor.cljs$lang$applyTo = (function (seq66868){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66868));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animate "hello")
 * (animate nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animate {:onClick f} "hello")
 * (animate #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animate :#the-id.klass.other-klass "hello")
 * (animate :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.animate = (function fulcro$client$dom$animate(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69588 = arguments.length;
var i__4731__auto___69589 = (0);
while(true){
if((i__4731__auto___69589 < len__4730__auto___69588)){
args__4736__auto__.push((arguments[i__4731__auto___69589]));

var G__69590 = (i__4731__auto___69589 + (1));
i__4731__auto___69589 = G__69590;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.animate.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.animate.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66876 = conformed_args__63534__auto__;
var map__66876__$1 = (((((!((map__66876 == null))))?(((((map__66876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66876):map__66876);
var css__63537__auto__ = cljs.core.get.call(null,map__66876__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66876__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66876__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"animate",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.animate.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.animate.cljs$lang$applyTo = (function (seq66871){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66871));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (source "hello")
 * (source nil "hello")
 * 
 * These two are made equivalent at compile time
 * (source {:onClick f} "hello")
 * (source #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (source :#the-id.klass.other-klass "hello")
 * (source :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.source = (function fulcro$client$dom$source(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69593 = arguments.length;
var i__4731__auto___69594 = (0);
while(true){
if((i__4731__auto___69594 < len__4730__auto___69593)){
args__4736__auto__.push((arguments[i__4731__auto___69594]));

var G__69595 = (i__4731__auto___69594 + (1));
i__4731__auto___69594 = G__69595;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.source.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.source.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66888 = conformed_args__63534__auto__;
var map__66888__$1 = (((((!((map__66888 == null))))?(((((map__66888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66888.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66888):map__66888);
var css__63537__auto__ = cljs.core.get.call(null,map__66888__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66888__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66888__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"source",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.source.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.source.cljs$lang$applyTo = (function (seq66882){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66882));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (output "hello")
 * (output nil "hello")
 * 
 * These two are made equivalent at compile time
 * (output {:onClick f} "hello")
 * (output #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (output :#the-id.klass.other-klass "hello")
 * (output :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.output = (function fulcro$client$dom$output(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69599 = arguments.length;
var i__4731__auto___69600 = (0);
while(true){
if((i__4731__auto___69600 < len__4730__auto___69599)){
args__4736__auto__.push((arguments[i__4731__auto___69600]));

var G__69602 = (i__4731__auto___69600 + (1));
i__4731__auto___69600 = G__69602;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.output.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.output.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66897 = conformed_args__63534__auto__;
var map__66897__$1 = (((((!((map__66897 == null))))?(((((map__66897.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66897.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66897):map__66897);
var css__63537__auto__ = cljs.core.get.call(null,map__66897__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66897__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66897__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"output",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.output.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.output.cljs$lang$applyTo = (function (seq66892){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66892));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face "hello")
 * (font-face nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face {:onClick f} "hello")
 * (font-face #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face :#the-id.klass.other-klass "hello")
 * (font-face :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font_face = (function fulcro$client$dom$font_face(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69610 = arguments.length;
var i__4731__auto___69613 = (0);
while(true){
if((i__4731__auto___69613 < len__4730__auto___69610)){
args__4736__auto__.push((arguments[i__4731__auto___69613]));

var G__69614 = (i__4731__auto___69613 + (1));
i__4731__auto___69613 = G__69614;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font_face.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66914 = conformed_args__63534__auto__;
var map__66914__$1 = (((((!((map__66914 == null))))?(((((map__66914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66914):map__66914);
var css__63537__auto__ = cljs.core.get.call(null,map__66914__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66914__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66914__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font-face",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font_face.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font_face.cljs$lang$applyTo = (function (seq66910){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66910));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMergeNode "hello")
 * (feMergeNode nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMergeNode {:onClick f} "hello")
 * (feMergeNode #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMergeNode :#the-id.klass.other-klass "hello")
 * (feMergeNode :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feMergeNode = (function fulcro$client$dom$feMergeNode(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69641 = arguments.length;
var i__4731__auto___69643 = (0);
while(true){
if((i__4731__auto___69643 < len__4730__auto___69641)){
args__4736__auto__.push((arguments[i__4731__auto___69643]));

var G__69645 = (i__4731__auto___69643 + (1));
i__4731__auto___69643 = G__69645;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66925 = conformed_args__63534__auto__;
var map__66925__$1 = (((((!((map__66925 == null))))?(((((map__66925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66925):map__66925);
var css__63537__auto__ = cljs.core.get.call(null,map__66925__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66925__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66925__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feMergeNode",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feMergeNode.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feMergeNode.cljs$lang$applyTo = (function (seq66918){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66918));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpotLight "hello")
 * (feSpotLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpotLight {:onClick f} "hello")
 * (feSpotLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpotLight :#the-id.klass.other-klass "hello")
 * (feSpotLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feSpotLight = (function fulcro$client$dom$feSpotLight(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69647 = arguments.length;
var i__4731__auto___69648 = (0);
while(true){
if((i__4731__auto___69648 < len__4730__auto___69647)){
args__4736__auto__.push((arguments[i__4731__auto___69648]));

var G__69649 = (i__4731__auto___69648 + (1));
i__4731__auto___69648 = G__69649;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66972 = conformed_args__63534__auto__;
var map__66972__$1 = (((((!((map__66972 == null))))?(((((map__66972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66972):map__66972);
var css__63537__auto__ = cljs.core.get.call(null,map__66972__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66972__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66972__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feSpotLight",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feSpotLight.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feSpotLight.cljs$lang$applyTo = (function (seq66955){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66955));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (header "hello")
 * (header nil "hello")
 * 
 * These two are made equivalent at compile time
 * (header {:onClick f} "hello")
 * (header #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (header :#the-id.klass.other-klass "hello")
 * (header :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.header = (function fulcro$client$dom$header(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69653 = arguments.length;
var i__4731__auto___69654 = (0);
while(true){
if((i__4731__auto___69654 < len__4730__auto___69653)){
args__4736__auto__.push((arguments[i__4731__auto___69654]));

var G__69655 = (i__4731__auto___69654 + (1));
i__4731__auto___69654 = G__69655;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.header.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.header.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__66986 = conformed_args__63534__auto__;
var map__66986__$1 = (((((!((map__66986 == null))))?(((((map__66986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__66986):map__66986);
var css__63537__auto__ = cljs.core.get.call(null,map__66986__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__66986__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__66986__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"header",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.header.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.header.cljs$lang$applyTo = (function (seq66978){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66978));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (datalist "hello")
 * (datalist nil "hello")
 * 
 * These two are made equivalent at compile time
 * (datalist {:onClick f} "hello")
 * (datalist #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (datalist :#the-id.klass.other-klass "hello")
 * (datalist :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.datalist = (function fulcro$client$dom$datalist(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69658 = arguments.length;
var i__4731__auto___69659 = (0);
while(true){
if((i__4731__auto___69659 < len__4730__auto___69658)){
args__4736__auto__.push((arguments[i__4731__auto___69659]));

var G__69661 = (i__4731__auto___69659 + (1));
i__4731__auto___69659 = G__69661;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.datalist.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.datalist.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67018 = conformed_args__63534__auto__;
var map__67018__$1 = (((((!((map__67018 == null))))?(((((map__67018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67018.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67018):map__67018);
var css__63537__auto__ = cljs.core.get.call(null,map__67018__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67018__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67018__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"datalist",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.datalist.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.datalist.cljs$lang$applyTo = (function (seq67011){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67011));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tfoot "hello")
 * (tfoot nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tfoot {:onClick f} "hello")
 * (tfoot #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tfoot :#the-id.klass.other-klass "hello")
 * (tfoot :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.tfoot = (function fulcro$client$dom$tfoot(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69664 = arguments.length;
var i__4731__auto___69665 = (0);
while(true){
if((i__4731__auto___69665 < len__4730__auto___69664)){
args__4736__auto__.push((arguments[i__4731__auto___69665]));

var G__69666 = (i__4731__auto___69665 + (1));
i__4731__auto___69665 = G__69666;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67047 = conformed_args__63534__auto__;
var map__67047__$1 = (((((!((map__67047 == null))))?(((((map__67047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67047):map__67047);
var css__63537__auto__ = cljs.core.get.call(null,map__67047__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67047__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67047__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"tfoot",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.tfoot.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.tfoot.cljs$lang$applyTo = (function (seq67044){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67044));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (s "hello")
 * (s nil "hello")
 * 
 * These two are made equivalent at compile time
 * (s {:onClick f} "hello")
 * (s #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (s :#the-id.klass.other-klass "hello")
 * (s :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.s = (function fulcro$client$dom$s(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69669 = arguments.length;
var i__4731__auto___69670 = (0);
while(true){
if((i__4731__auto___69670 < len__4730__auto___69669)){
args__4736__auto__.push((arguments[i__4731__auto___69670]));

var G__69671 = (i__4731__auto___69670 + (1));
i__4731__auto___69670 = G__69671;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.s.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.s.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67079 = conformed_args__63534__auto__;
var map__67079__$1 = (((((!((map__67079 == null))))?(((((map__67079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67079):map__67079);
var css__63537__auto__ = cljs.core.get.call(null,map__67079__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67079__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67079__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"s",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.s.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.s.cljs$lang$applyTo = (function (seq67074){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67074));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatch "hello")
 * (hatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatch {:onClick f} "hello")
 * (hatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatch :#the-id.klass.other-klass "hello")
 * (hatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.hatch = (function fulcro$client$dom$hatch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69682 = arguments.length;
var i__4731__auto___69691 = (0);
while(true){
if((i__4731__auto___69691 < len__4730__auto___69682)){
args__4736__auto__.push((arguments[i__4731__auto___69691]));

var G__69712 = (i__4731__auto___69691 + (1));
i__4731__auto___69691 = G__69712;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.hatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.hatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67121 = conformed_args__63534__auto__;
var map__67121__$1 = (((((!((map__67121 == null))))?(((((map__67121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67121.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67121):map__67121);
var css__63537__auto__ = cljs.core.get.call(null,map__67121__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67121__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67121__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"hatch",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.hatch.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.hatch.cljs$lang$applyTo = (function (seq67096){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67096));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ins "hello")
 * (ins nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ins {:onClick f} "hello")
 * (ins #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ins :#the-id.klass.other-klass "hello")
 * (ins :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.ins = (function fulcro$client$dom$ins(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69732 = arguments.length;
var i__4731__auto___69733 = (0);
while(true){
if((i__4731__auto___69733 < len__4730__auto___69732)){
args__4736__auto__.push((arguments[i__4731__auto___69733]));

var G__69734 = (i__4731__auto___69733 + (1));
i__4731__auto___69733 = G__69734;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.ins.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.ins.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67131 = conformed_args__63534__auto__;
var map__67131__$1 = (((((!((map__67131 == null))))?(((((map__67131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67131.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67131):map__67131);
var css__63537__auto__ = cljs.core.get.call(null,map__67131__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67131__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67131__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"ins",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.ins.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.ins.cljs$lang$applyTo = (function (seq67125){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67125));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (footer "hello")
 * (footer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (footer {:onClick f} "hello")
 * (footer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (footer :#the-id.klass.other-klass "hello")
 * (footer :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.footer = (function fulcro$client$dom$footer(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69748 = arguments.length;
var i__4731__auto___69751 = (0);
while(true){
if((i__4731__auto___69751 < len__4730__auto___69748)){
args__4736__auto__.push((arguments[i__4731__auto___69751]));

var G__69756 = (i__4731__auto___69751 + (1));
i__4731__auto___69751 = G__69756;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.footer.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.footer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67151 = conformed_args__63534__auto__;
var map__67151__$1 = (((((!((map__67151 == null))))?(((((map__67151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67151.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67151):map__67151);
var css__63537__auto__ = cljs.core.get.call(null,map__67151__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67151__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67151__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"footer",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.footer.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.footer.cljs$lang$applyTo = (function (seq67149){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67149));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mpath "hello")
 * (mpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mpath {:onClick f} "hello")
 * (mpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mpath :#the-id.klass.other-klass "hello")
 * (mpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.mpath = (function fulcro$client$dom$mpath(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69780 = arguments.length;
var i__4731__auto___69781 = (0);
while(true){
if((i__4731__auto___69781 < len__4730__auto___69780)){
args__4736__auto__.push((arguments[i__4731__auto___69781]));

var G__69782 = (i__4731__auto___69781 + (1));
i__4731__auto___69781 = G__69782;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.mpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.mpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67164 = conformed_args__63534__auto__;
var map__67164__$1 = (((((!((map__67164 == null))))?(((((map__67164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67164):map__67164);
var css__63537__auto__ = cljs.core.get.call(null,map__67164__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67164__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67164__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"mpath",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.mpath.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.mpath.cljs$lang$applyTo = (function (seq67163){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67163));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (title "hello")
 * (title nil "hello")
 * 
 * These two are made equivalent at compile time
 * (title {:onClick f} "hello")
 * (title #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (title :#the-id.klass.other-klass "hello")
 * (title :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.title = (function fulcro$client$dom$title(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69786 = arguments.length;
var i__4731__auto___69787 = (0);
while(true){
if((i__4731__auto___69787 < len__4730__auto___69786)){
args__4736__auto__.push((arguments[i__4731__auto___69787]));

var G__69788 = (i__4731__auto___69787 + (1));
i__4731__auto___69787 = G__69788;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.title.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.title.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67167 = conformed_args__63534__auto__;
var map__67167__$1 = (((((!((map__67167 == null))))?(((((map__67167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67167.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67167):map__67167);
var css__63537__auto__ = cljs.core.get.call(null,map__67167__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67167__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67167__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"title",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.title.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.title.cljs$lang$applyTo = (function (seq67166){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67166));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h5 "hello")
 * (h5 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h5 {:onClick f} "hello")
 * (h5 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h5 :#the-id.klass.other-klass "hello")
 * (h5 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h5 = (function fulcro$client$dom$h5(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69791 = arguments.length;
var i__4731__auto___69792 = (0);
while(true){
if((i__4731__auto___69792 < len__4730__auto___69791)){
args__4736__auto__.push((arguments[i__4731__auto___69792]));

var G__69793 = (i__4731__auto___69792 + (1));
i__4731__auto___69792 = G__69793;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h5.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h5.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67185 = conformed_args__63534__auto__;
var map__67185__$1 = (((((!((map__67185 == null))))?(((((map__67185.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67185.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67185):map__67185);
var css__63537__auto__ = cljs.core.get.call(null,map__67185__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67185__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67185__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h5",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h5.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h5.cljs$lang$applyTo = (function (seq67176){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67176));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshgradient "hello")
 * (meshgradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshgradient {:onClick f} "hello")
 * (meshgradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshgradient :#the-id.klass.other-klass "hello")
 * (meshgradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.meshgradient = (function fulcro$client$dom$meshgradient(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69803 = arguments.length;
var i__4731__auto___69804 = (0);
while(true){
if((i__4731__auto___69804 < len__4730__auto___69803)){
args__4736__auto__.push((arguments[i__4731__auto___69804]));

var G__69806 = (i__4731__auto___69804 + (1));
i__4731__auto___69804 = G__69806;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67197 = conformed_args__63534__auto__;
var map__67197__$1 = (((((!((map__67197 == null))))?(((((map__67197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67197):map__67197);
var css__63537__auto__ = cljs.core.get.call(null,map__67197__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67197__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67197__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"meshgradient",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.meshgradient.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.meshgradient.cljs$lang$applyTo = (function (seq67193){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67193));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (canvas "hello")
 * (canvas nil "hello")
 * 
 * These two are made equivalent at compile time
 * (canvas {:onClick f} "hello")
 * (canvas #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (canvas :#the-id.klass.other-klass "hello")
 * (canvas :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.canvas = (function fulcro$client$dom$canvas(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69816 = arguments.length;
var i__4731__auto___69817 = (0);
while(true){
if((i__4731__auto___69817 < len__4730__auto___69816)){
args__4736__auto__.push((arguments[i__4731__auto___69817]));

var G__69818 = (i__4731__auto___69817 + (1));
i__4731__auto___69817 = G__69818;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.canvas.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.canvas.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67207 = conformed_args__63534__auto__;
var map__67207__$1 = (((((!((map__67207 == null))))?(((((map__67207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67207.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67207):map__67207);
var css__63537__auto__ = cljs.core.get.call(null,map__67207__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67207__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67207__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"canvas",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.canvas.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.canvas.cljs$lang$applyTo = (function (seq67199){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67199));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (param "hello")
 * (param nil "hello")
 * 
 * These two are made equivalent at compile time
 * (param {:onClick f} "hello")
 * (param #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (param :#the-id.klass.other-klass "hello")
 * (param :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.param = (function fulcro$client$dom$param(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69829 = arguments.length;
var i__4731__auto___69830 = (0);
while(true){
if((i__4731__auto___69830 < len__4730__auto___69829)){
args__4736__auto__.push((arguments[i__4731__auto___69830]));

var G__69831 = (i__4731__auto___69830 + (1));
i__4731__auto___69830 = G__69831;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.param.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.param.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67214 = conformed_args__63534__auto__;
var map__67214__$1 = (((((!((map__67214 == null))))?(((((map__67214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67214):map__67214);
var css__63537__auto__ = cljs.core.get.call(null,map__67214__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67214__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67214__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"param",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.param.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.param.cljs$lang$applyTo = (function (seq67211){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67211));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font "hello")
 * (font nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font {:onClick f} "hello")
 * (font #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font :#the-id.klass.other-klass "hello")
 * (font :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font = (function fulcro$client$dom$font(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69853 = arguments.length;
var i__4731__auto___69854 = (0);
while(true){
if((i__4731__auto___69854 < len__4730__auto___69853)){
args__4736__auto__.push((arguments[i__4731__auto___69854]));

var G__69855 = (i__4731__auto___69854 + (1));
i__4731__auto___69854 = G__69855;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67236 = conformed_args__63534__auto__;
var map__67236__$1 = (((((!((map__67236 == null))))?(((((map__67236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67236):map__67236);
var css__63537__auto__ = cljs.core.get.call(null,map__67236__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67236__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67236__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font.cljs$lang$applyTo = (function (seq67235){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67235));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (div "hello")
 * (div nil "hello")
 * 
 * These two are made equivalent at compile time
 * (div {:onClick f} "hello")
 * (div #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (div :#the-id.klass.other-klass "hello")
 * (div :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.div = (function fulcro$client$dom$div(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69858 = arguments.length;
var i__4731__auto___69859 = (0);
while(true){
if((i__4731__auto___69859 < len__4730__auto___69858)){
args__4736__auto__.push((arguments[i__4731__auto___69859]));

var G__69861 = (i__4731__auto___69859 + (1));
i__4731__auto___69859 = G__69861;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.div.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67249 = conformed_args__63534__auto__;
var map__67249__$1 = (((((!((map__67249 == null))))?(((((map__67249.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67249.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67249):map__67249);
var css__63537__auto__ = cljs.core.get.call(null,map__67249__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67249__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67249__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"div",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.div.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.div.cljs$lang$applyTo = (function (seq67243){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67243));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (option "hello")
 * (option nil "hello")
 * 
 * These two are made equivalent at compile time
 * (option {:onClick f} "hello")
 * (option #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (option :#the-id.klass.other-klass "hello")
 * (option :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.option = (function fulcro$client$dom$option(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69863 = arguments.length;
var i__4731__auto___69864 = (0);
while(true){
if((i__4731__auto___69864 < len__4730__auto___69863)){
args__4736__auto__.push((arguments[i__4731__auto___69864]));

var G__69865 = (i__4731__auto___69864 + (1));
i__4731__auto___69864 = G__69865;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.option.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.option.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67261 = conformed_args__63534__auto__;
var map__67261__$1 = (((((!((map__67261 == null))))?(((((map__67261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67261):map__67261);
var css__63537__auto__ = cljs.core.get.call(null,map__67261__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67261__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67261__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"option",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.option.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.option.cljs$lang$applyTo = (function (seq67258){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67258));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFlood "hello")
 * (feFlood nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFlood {:onClick f} "hello")
 * (feFlood #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFlood :#the-id.klass.other-klass "hello")
 * (feFlood :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feFlood = (function fulcro$client$dom$feFlood(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69868 = arguments.length;
var i__4731__auto___69869 = (0);
while(true){
if((i__4731__auto___69869 < len__4730__auto___69868)){
args__4736__auto__.push((arguments[i__4731__auto___69869]));

var G__69870 = (i__4731__auto___69869 + (1));
i__4731__auto___69869 = G__69870;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67277 = conformed_args__63534__auto__;
var map__67277__$1 = (((((!((map__67277 == null))))?(((((map__67277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67277):map__67277);
var css__63537__auto__ = cljs.core.get.call(null,map__67277__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67277__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67277__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feFlood",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feFlood.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feFlood.cljs$lang$applyTo = (function (seq67272){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67272));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (summary "hello")
 * (summary nil "hello")
 * 
 * These two are made equivalent at compile time
 * (summary {:onClick f} "hello")
 * (summary #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (summary :#the-id.klass.other-klass "hello")
 * (summary :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.summary = (function fulcro$client$dom$summary(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69912 = arguments.length;
var i__4731__auto___69913 = (0);
while(true){
if((i__4731__auto___69913 < len__4730__auto___69912)){
args__4736__auto__.push((arguments[i__4731__auto___69913]));

var G__69914 = (i__4731__auto___69913 + (1));
i__4731__auto___69913 = G__69914;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.summary.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.summary.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67302 = conformed_args__63534__auto__;
var map__67302__$1 = (((((!((map__67302 == null))))?(((((map__67302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67302.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67302):map__67302);
var css__63537__auto__ = cljs.core.get.call(null,map__67302__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67302__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67302__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"summary",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.summary.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.summary.cljs$lang$applyTo = (function (seq67301){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67301));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMorphology "hello")
 * (feMorphology nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMorphology {:onClick f} "hello")
 * (feMorphology #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMorphology :#the-id.klass.other-klass "hello")
 * (feMorphology :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feMorphology = (function fulcro$client$dom$feMorphology(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69917 = arguments.length;
var i__4731__auto___69920 = (0);
while(true){
if((i__4731__auto___69920 < len__4730__auto___69917)){
args__4736__auto__.push((arguments[i__4731__auto___69920]));

var G__69921 = (i__4731__auto___69920 + (1));
i__4731__auto___69920 = G__69921;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67310 = conformed_args__63534__auto__;
var map__67310__$1 = (((((!((map__67310 == null))))?(((((map__67310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67310):map__67310);
var css__63537__auto__ = cljs.core.get.call(null,map__67310__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67310__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67310__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feMorphology",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feMorphology.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feMorphology.cljs$lang$applyTo = (function (seq67306){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67306));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (samp "hello")
 * (samp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (samp {:onClick f} "hello")
 * (samp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (samp :#the-id.klass.other-klass "hello")
 * (samp :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.samp = (function fulcro$client$dom$samp(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69958 = arguments.length;
var i__4731__auto___69959 = (0);
while(true){
if((i__4731__auto___69959 < len__4730__auto___69958)){
args__4736__auto__.push((arguments[i__4731__auto___69959]));

var G__69961 = (i__4731__auto___69959 + (1));
i__4731__auto___69959 = G__69961;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.samp.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.samp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67327 = conformed_args__63534__auto__;
var map__67327__$1 = (((((!((map__67327 == null))))?(((((map__67327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67327.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67327):map__67327);
var css__63537__auto__ = cljs.core.get.call(null,map__67327__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67327__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67327__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"samp",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.samp.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.samp.cljs$lang$applyTo = (function (seq67322){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67322));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyphRef "hello")
 * (glyphRef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyphRef {:onClick f} "hello")
 * (glyphRef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyphRef :#the-id.klass.other-klass "hello")
 * (glyphRef :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.glyphRef = (function fulcro$client$dom$glyphRef(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69966 = arguments.length;
var i__4731__auto___69967 = (0);
while(true){
if((i__4731__auto___69967 < len__4730__auto___69966)){
args__4736__auto__.push((arguments[i__4731__auto___69967]));

var G__69968 = (i__4731__auto___69967 + (1));
i__4731__auto___69967 = G__69968;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67331 = conformed_args__63534__auto__;
var map__67331__$1 = (((((!((map__67331 == null))))?(((((map__67331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67331.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67331):map__67331);
var css__63537__auto__ = cljs.core.get.call(null,map__67331__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67331__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67331__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"glyphRef",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.glyphRef.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.glyphRef.cljs$lang$applyTo = (function (seq67329){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67329));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (small "hello")
 * (small nil "hello")
 * 
 * These two are made equivalent at compile time
 * (small {:onClick f} "hello")
 * (small #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (small :#the-id.klass.other-klass "hello")
 * (small :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.small = (function fulcro$client$dom$small(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69970 = arguments.length;
var i__4731__auto___69971 = (0);
while(true){
if((i__4731__auto___69971 < len__4730__auto___69970)){
args__4736__auto__.push((arguments[i__4731__auto___69971]));

var G__69972 = (i__4731__auto___69971 + (1));
i__4731__auto___69971 = G__69972;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.small.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.small.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67339 = conformed_args__63534__auto__;
var map__67339__$1 = (((((!((map__67339 == null))))?(((((map__67339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67339):map__67339);
var css__63537__auto__ = cljs.core.get.call(null,map__67339__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67339__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67339__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"small",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.small.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.small.cljs$lang$applyTo = (function (seq67337){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67337));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (style "hello")
 * (style nil "hello")
 * 
 * These two are made equivalent at compile time
 * (style {:onClick f} "hello")
 * (style #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (style :#the-id.klass.other-klass "hello")
 * (style :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.style = (function fulcro$client$dom$style(var_args){
var args__4736__auto__ = [];
var len__4730__auto___69977 = arguments.length;
var i__4731__auto___69978 = (0);
while(true){
if((i__4731__auto___69978 < len__4730__auto___69977)){
args__4736__auto__.push((arguments[i__4731__auto___69978]));

var G__69979 = (i__4731__auto___69978 + (1));
i__4731__auto___69978 = G__69979;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.style.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.style.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67346 = conformed_args__63534__auto__;
var map__67346__$1 = (((((!((map__67346 == null))))?(((((map__67346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67346):map__67346);
var css__63537__auto__ = cljs.core.get.call(null,map__67346__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67346__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67346__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"style",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.style.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.style.cljs$lang$applyTo = (function (seq67345){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67345));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textarea "hello")
 * (textarea nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textarea {:onClick f} "hello")
 * (textarea #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textarea :#the-id.klass.other-klass "hello")
 * (textarea :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.textarea = (function fulcro$client$dom$textarea(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70001 = arguments.length;
var i__4731__auto___70002 = (0);
while(true){
if((i__4731__auto___70002 < len__4730__auto___70001)){
args__4736__auto__.push((arguments[i__4731__auto___70002]));

var G__70003 = (i__4731__auto___70002 + (1));
i__4731__auto___70002 = G__70003;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.textarea.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.textarea.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67355 = conformed_args__63534__auto__;
var map__67355__$1 = (((((!((map__67355 == null))))?(((((map__67355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67355.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67355):map__67355);
var css__63537__auto__ = cljs.core.get.call(null,map__67355__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67355__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67355__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"textarea",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.textarea.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.textarea.cljs$lang$applyTo = (function (seq67353){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67353));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur "hello")
 * (feGaussianBlur nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur {:onClick f} "hello")
 * (feGaussianBlur #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feGaussianBlur :#the-id.klass.other-klass "hello")
 * (feGaussianBlur :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feGaussianBlur = (function fulcro$client$dom$feGaussianBlur(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70015 = arguments.length;
var i__4731__auto___70016 = (0);
while(true){
if((i__4731__auto___70016 < len__4730__auto___70015)){
args__4736__auto__.push((arguments[i__4731__auto___70016]));

var G__70036 = (i__4731__auto___70016 + (1));
i__4731__auto___70016 = G__70036;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67360 = conformed_args__63534__auto__;
var map__67360__$1 = (((((!((map__67360 == null))))?(((((map__67360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67360):map__67360);
var css__63537__auto__ = cljs.core.get.call(null,map__67360__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67360__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67360__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feGaussianBlur",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feGaussianBlur.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feGaussianBlur.cljs$lang$applyTo = (function (seq67359){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67359));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h4 "hello")
 * (h4 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h4 {:onClick f} "hello")
 * (h4 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h4 :#the-id.klass.other-klass "hello")
 * (h4 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h4 = (function fulcro$client$dom$h4(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70039 = arguments.length;
var i__4731__auto___70040 = (0);
while(true){
if((i__4731__auto___70040 < len__4730__auto___70039)){
args__4736__auto__.push((arguments[i__4731__auto___70040]));

var G__70041 = (i__4731__auto___70040 + (1));
i__4731__auto___70040 = G__70041;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h4.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h4.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67366 = conformed_args__63534__auto__;
var map__67366__$1 = (((((!((map__67366 == null))))?(((((map__67366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67366):map__67366);
var css__63537__auto__ = cljs.core.get.call(null,map__67366__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67366__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67366__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h4",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h4.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h4.cljs$lang$applyTo = (function (seq67365){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67365));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (head "hello")
 * (head nil "hello")
 * 
 * These two are made equivalent at compile time
 * (head {:onClick f} "hello")
 * (head #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (head :#the-id.klass.other-klass "hello")
 * (head :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.head = (function fulcro$client$dom$head(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70045 = arguments.length;
var i__4731__auto___70046 = (0);
while(true){
if((i__4731__auto___70046 < len__4730__auto___70045)){
args__4736__auto__.push((arguments[i__4731__auto___70046]));

var G__70047 = (i__4731__auto___70046 + (1));
i__4731__auto___70046 = G__70047;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.head.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.head.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67369 = conformed_args__63534__auto__;
var map__67369__$1 = (((((!((map__67369 == null))))?(((((map__67369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67369):map__67369);
var css__63537__auto__ = cljs.core.get.call(null,map__67369__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67369__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67369__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"head",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.head.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.head.cljs$lang$applyTo = (function (seq67368){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67368));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (g "hello")
 * (g nil "hello")
 * 
 * These two are made equivalent at compile time
 * (g {:onClick f} "hello")
 * (g #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (g :#the-id.klass.other-klass "hello")
 * (g :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.g = (function fulcro$client$dom$g(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70049 = arguments.length;
var i__4731__auto___70050 = (0);
while(true){
if((i__4731__auto___70050 < len__4730__auto___70049)){
args__4736__auto__.push((arguments[i__4731__auto___70050]));

var G__70051 = (i__4731__auto___70050 + (1));
i__4731__auto___70050 = G__70051;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.g.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.g.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67380 = conformed_args__63534__auto__;
var map__67380__$1 = (((((!((map__67380 == null))))?(((((map__67380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67380):map__67380);
var css__63537__auto__ = cljs.core.get.call(null,map__67380__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67380__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67380__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"g",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.g.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.g.cljs$lang$applyTo = (function (seq67378){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67378));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (missing-glyph "hello")
 * (missing-glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (missing-glyph {:onClick f} "hello")
 * (missing-glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (missing-glyph :#the-id.klass.other-klass "hello")
 * (missing-glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.missing_glyph = (function fulcro$client$dom$missing_glyph(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70055 = arguments.length;
var i__4731__auto___70056 = (0);
while(true){
if((i__4731__auto___70056 < len__4730__auto___70055)){
args__4736__auto__.push((arguments[i__4731__auto___70056]));

var G__70057 = (i__4731__auto___70056 + (1));
i__4731__auto___70056 = G__70057;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67396 = conformed_args__63534__auto__;
var map__67396__$1 = (((((!((map__67396 == null))))?(((((map__67396.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67396.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67396):map__67396);
var css__63537__auto__ = cljs.core.get.call(null,map__67396__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67396__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67396__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"missing-glyph",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.missing_glyph.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.missing_glyph.cljs$lang$applyTo = (function (seq67390){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67390));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (stop "hello")
 * (stop nil "hello")
 * 
 * These two are made equivalent at compile time
 * (stop {:onClick f} "hello")
 * (stop #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (stop :#the-id.klass.other-klass "hello")
 * (stop :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.stop = (function fulcro$client$dom$stop(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70061 = arguments.length;
var i__4731__auto___70062 = (0);
while(true){
if((i__4731__auto___70062 < len__4730__auto___70061)){
args__4736__auto__.push((arguments[i__4731__auto___70062]));

var G__70063 = (i__4731__auto___70062 + (1));
i__4731__auto___70062 = G__70063;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.stop.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.stop.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67407 = conformed_args__63534__auto__;
var map__67407__$1 = (((((!((map__67407 == null))))?(((((map__67407.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67407.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67407):map__67407);
var css__63537__auto__ = cljs.core.get.call(null,map__67407__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67407__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67407__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"stop",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.stop.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.stop.cljs$lang$applyTo = (function (seq67402){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67402));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting "hello")
 * (feDiffuseLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting {:onClick f} "hello")
 * (feDiffuseLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDiffuseLighting :#the-id.klass.other-klass "hello")
 * (feDiffuseLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feDiffuseLighting = (function fulcro$client$dom$feDiffuseLighting(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70065 = arguments.length;
var i__4731__auto___70066 = (0);
while(true){
if((i__4731__auto___70066 < len__4730__auto___70065)){
args__4736__auto__.push((arguments[i__4731__auto___70066]));

var G__70067 = (i__4731__auto___70066 + (1));
i__4731__auto___70066 = G__70067;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67423 = conformed_args__63534__auto__;
var map__67423__$1 = (((((!((map__67423 == null))))?(((((map__67423.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67423.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67423):map__67423);
var css__63537__auto__ = cljs.core.get.call(null,map__67423__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67423__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67423__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feDiffuseLighting",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feDiffuseLighting.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feDiffuseLighting.cljs$lang$applyTo = (function (seq67419){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67419));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (filter "hello")
 * (filter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (filter {:onClick f} "hello")
 * (filter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (filter :#the-id.klass.other-klass "hello")
 * (filter :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.filter = (function fulcro$client$dom$filter(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70070 = arguments.length;
var i__4731__auto___70071 = (0);
while(true){
if((i__4731__auto___70071 < len__4730__auto___70070)){
args__4736__auto__.push((arguments[i__4731__auto___70071]));

var G__70075 = (i__4731__auto___70071 + (1));
i__4731__auto___70071 = G__70075;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.filter.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.filter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67431 = conformed_args__63534__auto__;
var map__67431__$1 = (((((!((map__67431 == null))))?(((((map__67431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67431):map__67431);
var css__63537__auto__ = cljs.core.get.call(null,map__67431__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67431__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67431__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"filter",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.filter.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.filter.cljs$lang$applyTo = (function (seq67428){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67428));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComposite "hello")
 * (feComposite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComposite {:onClick f} "hello")
 * (feComposite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComposite :#the-id.klass.other-klass "hello")
 * (feComposite :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feComposite = (function fulcro$client$dom$feComposite(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70131 = arguments.length;
var i__4731__auto___70132 = (0);
while(true){
if((i__4731__auto___70132 < len__4730__auto___70131)){
args__4736__auto__.push((arguments[i__4731__auto___70132]));

var G__70133 = (i__4731__auto___70132 + (1));
i__4731__auto___70132 = G__70133;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67440 = conformed_args__63534__auto__;
var map__67440__$1 = (((((!((map__67440 == null))))?(((((map__67440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67440):map__67440);
var css__63537__auto__ = cljs.core.get.call(null,map__67440__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67440__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67440__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feComposite",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feComposite.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feComposite.cljs$lang$applyTo = (function (seq67437){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67437));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mesh "hello")
 * (mesh nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mesh {:onClick f} "hello")
 * (mesh #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mesh :#the-id.klass.other-klass "hello")
 * (mesh :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.mesh = (function fulcro$client$dom$mesh(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70148 = arguments.length;
var i__4731__auto___70151 = (0);
while(true){
if((i__4731__auto___70151 < len__4730__auto___70148)){
args__4736__auto__.push((arguments[i__4731__auto___70151]));

var G__70156 = (i__4731__auto___70151 + (1));
i__4731__auto___70151 = G__70156;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.mesh.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.mesh.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67444 = conformed_args__63534__auto__;
var map__67444__$1 = (((((!((map__67444 == null))))?(((((map__67444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67444):map__67444);
var css__63537__auto__ = cljs.core.get.call(null,map__67444__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67444__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67444__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"mesh",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.mesh.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.mesh.cljs$lang$applyTo = (function (seq67442){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67442));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (var "hello")
 * (var nil "hello")
 * 
 * These two are made equivalent at compile time
 * (var {:onClick f} "hello")
 * (var #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (var :#the-id.klass.other-klass "hello")
 * (var :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.var$ = (function fulcro$client$dom$var(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70181 = arguments.length;
var i__4731__auto___70182 = (0);
while(true){
if((i__4731__auto___70182 < len__4730__auto___70181)){
args__4736__auto__.push((arguments[i__4731__auto___70182]));

var G__70184 = (i__4731__auto___70182 + (1));
i__4731__auto___70182 = G__70184;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.var$.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.var$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67447 = conformed_args__63534__auto__;
var map__67447__$1 = (((((!((map__67447 == null))))?(((((map__67447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67447):map__67447);
var css__63537__auto__ = cljs.core.get.call(null,map__67447__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67447__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67447__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"var",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.var$.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.var$.cljs$lang$applyTo = (function (seq67446){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67446));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tspan "hello")
 * (tspan nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tspan {:onClick f} "hello")
 * (tspan #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tspan :#the-id.klass.other-klass "hello")
 * (tspan :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.tspan = (function fulcro$client$dom$tspan(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70187 = arguments.length;
var i__4731__auto___70188 = (0);
while(true){
if((i__4731__auto___70188 < len__4730__auto___70187)){
args__4736__auto__.push((arguments[i__4731__auto___70188]));

var G__70189 = (i__4731__auto___70188 + (1));
i__4731__auto___70188 = G__70189;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.tspan.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.tspan.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67451 = conformed_args__63534__auto__;
var map__67451__$1 = (((((!((map__67451 == null))))?(((((map__67451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67451):map__67451);
var css__63537__auto__ = cljs.core.get.call(null,map__67451__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67451__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67451__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"tspan",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.tspan.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.tspan.cljs$lang$applyTo = (function (seq67449){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67449));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ol "hello")
 * (ol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ol {:onClick f} "hello")
 * (ol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ol :#the-id.klass.other-klass "hello")
 * (ol :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.ol = (function fulcro$client$dom$ol(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70192 = arguments.length;
var i__4731__auto___70193 = (0);
while(true){
if((i__4731__auto___70193 < len__4730__auto___70192)){
args__4736__auto__.push((arguments[i__4731__auto___70193]));

var G__70195 = (i__4731__auto___70193 + (1));
i__4731__auto___70193 = G__70195;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.ol.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.ol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67454 = conformed_args__63534__auto__;
var map__67454__$1 = (((((!((map__67454 == null))))?(((((map__67454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67454):map__67454);
var css__63537__auto__ = cljs.core.get.call(null,map__67454__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67454__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67454__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"ol",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.ol.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.ol.cljs$lang$applyTo = (function (seq67453){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67453));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (details "hello")
 * (details nil "hello")
 * 
 * These two are made equivalent at compile time
 * (details {:onClick f} "hello")
 * (details #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (details :#the-id.klass.other-klass "hello")
 * (details :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.details = (function fulcro$client$dom$details(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70198 = arguments.length;
var i__4731__auto___70199 = (0);
while(true){
if((i__4731__auto___70199 < len__4730__auto___70198)){
args__4736__auto__.push((arguments[i__4731__auto___70199]));

var G__70200 = (i__4731__auto___70199 + (1));
i__4731__auto___70199 = G__70200;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.details.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.details.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67457 = conformed_args__63534__auto__;
var map__67457__$1 = (((((!((map__67457 == null))))?(((((map__67457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67457):map__67457);
var css__63537__auto__ = cljs.core.get.call(null,map__67457__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67457__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67457__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"details",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.details.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.details.cljs$lang$applyTo = (function (seq67456){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67456));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (line "hello")
 * (line nil "hello")
 * 
 * These two are made equivalent at compile time
 * (line {:onClick f} "hello")
 * (line #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (line :#the-id.klass.other-klass "hello")
 * (line :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.line = (function fulcro$client$dom$line(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70215 = arguments.length;
var i__4731__auto___70217 = (0);
while(true){
if((i__4731__auto___70217 < len__4730__auto___70215)){
args__4736__auto__.push((arguments[i__4731__auto___70217]));

var G__70218 = (i__4731__auto___70217 + (1));
i__4731__auto___70217 = G__70218;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.line.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.line.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67463 = conformed_args__63534__auto__;
var map__67463__$1 = (((((!((map__67463 == null))))?(((((map__67463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67463.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67463):map__67463);
var css__63537__auto__ = cljs.core.get.call(null,map__67463__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67463__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67463__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"line",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.line.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.line.cljs$lang$applyTo = (function (seq67462){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67462));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (col "hello")
 * (col nil "hello")
 * 
 * These two are made equivalent at compile time
 * (col {:onClick f} "hello")
 * (col #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (col :#the-id.klass.other-klass "hello")
 * (col :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.col = (function fulcro$client$dom$col(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70240 = arguments.length;
var i__4731__auto___70241 = (0);
while(true){
if((i__4731__auto___70241 < len__4730__auto___70240)){
args__4736__auto__.push((arguments[i__4731__auto___70241]));

var G__70242 = (i__4731__auto___70241 + (1));
i__4731__auto___70241 = G__70242;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.col.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.col.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67469 = conformed_args__63534__auto__;
var map__67469__$1 = (((((!((map__67469 == null))))?(((((map__67469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67469):map__67469);
var css__63537__auto__ = cljs.core.get.call(null,map__67469__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67469__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67469__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"col",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.col.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.col.cljs$lang$applyTo = (function (seq67466){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67466));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (label "hello")
 * (label nil "hello")
 * 
 * These two are made equivalent at compile time
 * (label {:onClick f} "hello")
 * (label #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (label :#the-id.klass.other-klass "hello")
 * (label :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.label = (function fulcro$client$dom$label(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70258 = arguments.length;
var i__4731__auto___70259 = (0);
while(true){
if((i__4731__auto___70259 < len__4730__auto___70258)){
args__4736__auto__.push((arguments[i__4731__auto___70259]));

var G__70260 = (i__4731__auto___70259 + (1));
i__4731__auto___70259 = G__70260;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.label.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.label.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67472 = conformed_args__63534__auto__;
var map__67472__$1 = (((((!((map__67472 == null))))?(((((map__67472.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67472.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67472):map__67472);
var css__63537__auto__ = cljs.core.get.call(null,map__67472__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67472__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67472__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"label",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.label.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.label.cljs$lang$applyTo = (function (seq67471){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67471));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (picture "hello")
 * (picture nil "hello")
 * 
 * These two are made equivalent at compile time
 * (picture {:onClick f} "hello")
 * (picture #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (picture :#the-id.klass.other-klass "hello")
 * (picture :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.picture = (function fulcro$client$dom$picture(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70272 = arguments.length;
var i__4731__auto___70273 = (0);
while(true){
if((i__4731__auto___70273 < len__4730__auto___70272)){
args__4736__auto__.push((arguments[i__4731__auto___70273]));

var G__70275 = (i__4731__auto___70273 + (1));
i__4731__auto___70273 = G__70275;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.picture.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.picture.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67482 = conformed_args__63534__auto__;
var map__67482__$1 = (((((!((map__67482 == null))))?(((((map__67482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67482.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67482):map__67482);
var css__63537__auto__ = cljs.core.get.call(null,map__67482__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67482__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67482__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"picture",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.picture.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.picture.cljs$lang$applyTo = (function (seq67475){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67475));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rt "hello")
 * (rt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rt {:onClick f} "hello")
 * (rt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rt :#the-id.klass.other-klass "hello")
 * (rt :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.rt = (function fulcro$client$dom$rt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70288 = arguments.length;
var i__4731__auto___70289 = (0);
while(true){
if((i__4731__auto___70289 < len__4730__auto___70288)){
args__4736__auto__.push((arguments[i__4731__auto___70289]));

var G__70292 = (i__4731__auto___70289 + (1));
i__4731__auto___70289 = G__70292;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.rt.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.rt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67490 = conformed_args__63534__auto__;
var map__67490__$1 = (((((!((map__67490 == null))))?(((((map__67490.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67490.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67490):map__67490);
var css__63537__auto__ = cljs.core.get.call(null,map__67490__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67490__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67490__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"rt",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.rt.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.rt.cljs$lang$applyTo = (function (seq67488){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67488));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h6 "hello")
 * (h6 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h6 {:onClick f} "hello")
 * (h6 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h6 :#the-id.klass.other-klass "hello")
 * (h6 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h6 = (function fulcro$client$dom$h6(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70303 = arguments.length;
var i__4731__auto___70305 = (0);
while(true){
if((i__4731__auto___70305 < len__4730__auto___70303)){
args__4736__auto__.push((arguments[i__4731__auto___70305]));

var G__70308 = (i__4731__auto___70305 + (1));
i__4731__auto___70305 = G__70308;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h6.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h6.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67497 = conformed_args__63534__auto__;
var map__67497__$1 = (((((!((map__67497 == null))))?(((((map__67497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67497.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67497):map__67497);
var css__63537__auto__ = cljs.core.get.call(null,map__67497__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67497__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67497__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h6",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h6.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h6.cljs$lang$applyTo = (function (seq67494){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67494));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (vkern "hello")
 * (vkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (vkern {:onClick f} "hello")
 * (vkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (vkern :#the-id.klass.other-klass "hello")
 * (vkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.vkern = (function fulcro$client$dom$vkern(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70315 = arguments.length;
var i__4731__auto___70316 = (0);
while(true){
if((i__4731__auto___70316 < len__4730__auto___70315)){
args__4736__auto__.push((arguments[i__4731__auto___70316]));

var G__70318 = (i__4731__auto___70316 + (1));
i__4731__auto___70316 = G__70318;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.vkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.vkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67507 = conformed_args__63534__auto__;
var map__67507__$1 = (((((!((map__67507 == null))))?(((((map__67507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67507):map__67507);
var css__63537__auto__ = cljs.core.get.call(null,map__67507__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67507__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67507__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"vkern",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.vkern.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.vkern.cljs$lang$applyTo = (function (seq67503){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67503));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (link "hello")
 * (link nil "hello")
 * 
 * These two are made equivalent at compile time
 * (link {:onClick f} "hello")
 * (link #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (link :#the-id.klass.other-klass "hello")
 * (link :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.link = (function fulcro$client$dom$link(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70325 = arguments.length;
var i__4731__auto___70326 = (0);
while(true){
if((i__4731__auto___70326 < len__4730__auto___70325)){
args__4736__auto__.push((arguments[i__4731__auto___70326]));

var G__70327 = (i__4731__auto___70326 + (1));
i__4731__auto___70326 = G__70327;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.link.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.link.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67514 = conformed_args__63534__auto__;
var map__67514__$1 = (((((!((map__67514 == null))))?(((((map__67514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67514):map__67514);
var css__63537__auto__ = cljs.core.get.call(null,map__67514__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67514__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67514__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"link",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.link.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.link.cljs$lang$applyTo = (function (seq67513){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67513));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (defs "hello")
 * (defs nil "hello")
 * 
 * These two are made equivalent at compile time
 * (defs {:onClick f} "hello")
 * (defs #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (defs :#the-id.klass.other-klass "hello")
 * (defs :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.defs = (function fulcro$client$dom$defs(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70340 = arguments.length;
var i__4731__auto___70341 = (0);
while(true){
if((i__4731__auto___70341 < len__4730__auto___70340)){
args__4736__auto__.push((arguments[i__4731__auto___70341]));

var G__70343 = (i__4731__auto___70341 + (1));
i__4731__auto___70341 = G__70343;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.defs.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.defs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67524 = conformed_args__63534__auto__;
var map__67524__$1 = (((((!((map__67524 == null))))?(((((map__67524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67524):map__67524);
var css__63537__auto__ = cljs.core.get.call(null,map__67524__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67524__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67524__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"defs",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.defs.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.defs.cljs$lang$applyTo = (function (seq67521){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67521));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyph "hello")
 * (glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyph {:onClick f} "hello")
 * (glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyph :#the-id.klass.other-klass "hello")
 * (glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.glyph = (function fulcro$client$dom$glyph(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70351 = arguments.length;
var i__4731__auto___70352 = (0);
while(true){
if((i__4731__auto___70352 < len__4730__auto___70351)){
args__4736__auto__.push((arguments[i__4731__auto___70352]));

var G__70354 = (i__4731__auto___70352 + (1));
i__4731__auto___70352 = G__70354;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67552 = conformed_args__63534__auto__;
var map__67552__$1 = (((((!((map__67552 == null))))?(((((map__67552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67552):map__67552);
var css__63537__auto__ = cljs.core.get.call(null,map__67552__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67552__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67552__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"glyph",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.glyph.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.glyph.cljs$lang$applyTo = (function (seq67542){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67542));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (colgroup "hello")
 * (colgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (colgroup {:onClick f} "hello")
 * (colgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (colgroup :#the-id.klass.other-klass "hello")
 * (colgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.colgroup = (function fulcro$client$dom$colgroup(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70368 = arguments.length;
var i__4731__auto___70370 = (0);
while(true){
if((i__4731__auto___70370 < len__4730__auto___70368)){
args__4736__auto__.push((arguments[i__4731__auto___70370]));

var G__70373 = (i__4731__auto___70370 + (1));
i__4731__auto___70370 = G__70373;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67565 = conformed_args__63534__auto__;
var map__67565__$1 = (((((!((map__67565 == null))))?(((((map__67565.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67565.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67565):map__67565);
var css__63537__auto__ = cljs.core.get.call(null,map__67565__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67565__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67565__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"colgroup",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.colgroup.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.colgroup.cljs$lang$applyTo = (function (seq67563){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67563));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meter "hello")
 * (meter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meter {:onClick f} "hello")
 * (meter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meter :#the-id.klass.other-klass "hello")
 * (meter :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.meter = (function fulcro$client$dom$meter(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70383 = arguments.length;
var i__4731__auto___70385 = (0);
while(true){
if((i__4731__auto___70385 < len__4730__auto___70383)){
args__4736__auto__.push((arguments[i__4731__auto___70385]));

var G__70388 = (i__4731__auto___70385 + (1));
i__4731__auto___70385 = G__70388;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.meter.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.meter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67588 = conformed_args__63534__auto__;
var map__67588__$1 = (((((!((map__67588 == null))))?(((((map__67588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67588):map__67588);
var css__63537__auto__ = cljs.core.get.call(null,map__67588__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67588__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67588__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"meter",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.meter.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.meter.cljs$lang$applyTo = (function (seq67577){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67577));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdo "hello")
 * (bdo nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdo {:onClick f} "hello")
 * (bdo #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdo :#the-id.klass.other-klass "hello")
 * (bdo :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.bdo = (function fulcro$client$dom$bdo(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70398 = arguments.length;
var i__4731__auto___70399 = (0);
while(true){
if((i__4731__auto___70399 < len__4730__auto___70398)){
args__4736__auto__.push((arguments[i__4731__auto___70399]));

var G__70401 = (i__4731__auto___70399 + (1));
i__4731__auto___70399 = G__70401;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.bdo.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.bdo.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67612 = conformed_args__63534__auto__;
var map__67612__$1 = (((((!((map__67612 == null))))?(((((map__67612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67612):map__67612);
var css__63537__auto__ = cljs.core.get.call(null,map__67612__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67612__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67612__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"bdo",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.bdo.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.bdo.cljs$lang$applyTo = (function (seq67601){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67601));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feImage "hello")
 * (feImage nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feImage {:onClick f} "hello")
 * (feImage #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feImage :#the-id.klass.other-klass "hello")
 * (feImage :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feImage = (function fulcro$client$dom$feImage(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70411 = arguments.length;
var i__4731__auto___70412 = (0);
while(true){
if((i__4731__auto___70412 < len__4730__auto___70411)){
args__4736__auto__.push((arguments[i__4731__auto___70412]));

var G__70414 = (i__4731__auto___70412 + (1));
i__4731__auto___70412 = G__70414;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feImage.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feImage.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67644 = conformed_args__63534__auto__;
var map__67644__$1 = (((((!((map__67644 == null))))?(((((map__67644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67644):map__67644);
var css__63537__auto__ = cljs.core.get.call(null,map__67644__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67644__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67644__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feImage",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feImage.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feImage.cljs$lang$applyTo = (function (seq67618){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67618));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (b "hello")
 * (b nil "hello")
 * 
 * These two are made equivalent at compile time
 * (b {:onClick f} "hello")
 * (b #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (b :#the-id.klass.other-klass "hello")
 * (b :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.b = (function fulcro$client$dom$b(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70428 = arguments.length;
var i__4731__auto___70429 = (0);
while(true){
if((i__4731__auto___70429 < len__4730__auto___70428)){
args__4736__auto__.push((arguments[i__4731__auto___70429]));

var G__70430 = (i__4731__auto___70429 + (1));
i__4731__auto___70429 = G__70430;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.b.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.b.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67679 = conformed_args__63534__auto__;
var map__67679__$1 = (((((!((map__67679 == null))))?(((((map__67679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67679):map__67679);
var css__63537__auto__ = cljs.core.get.call(null,map__67679__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67679__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67679__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"b",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.b.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.b.cljs$lang$applyTo = (function (seq67663){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67663));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (svg "hello")
 * (svg nil "hello")
 * 
 * These two are made equivalent at compile time
 * (svg {:onClick f} "hello")
 * (svg #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (svg :#the-id.klass.other-klass "hello")
 * (svg :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.svg = (function fulcro$client$dom$svg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70438 = arguments.length;
var i__4731__auto___70439 = (0);
while(true){
if((i__4731__auto___70439 < len__4730__auto___70438)){
args__4736__auto__.push((arguments[i__4731__auto___70439]));

var G__70442 = (i__4731__auto___70439 + (1));
i__4731__auto___70439 = G__70442;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.svg.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67715 = conformed_args__63534__auto__;
var map__67715__$1 = (((((!((map__67715 == null))))?(((((map__67715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67715):map__67715);
var css__63537__auto__ = cljs.core.get.call(null,map__67715__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67715__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67715__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"svg",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.svg.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.svg.cljs$lang$applyTo = (function (seq67706){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67706));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTile "hello")
 * (feTile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTile {:onClick f} "hello")
 * (feTile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTile :#the-id.klass.other-klass "hello")
 * (feTile :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feTile = (function fulcro$client$dom$feTile(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70448 = arguments.length;
var i__4731__auto___70449 = (0);
while(true){
if((i__4731__auto___70449 < len__4730__auto___70448)){
args__4736__auto__.push((arguments[i__4731__auto___70449]));

var G__70450 = (i__4731__auto___70449 + (1));
i__4731__auto___70449 = G__70450;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feTile.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feTile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67736 = conformed_args__63534__auto__;
var map__67736__$1 = (((((!((map__67736 == null))))?(((((map__67736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67736):map__67736);
var css__63537__auto__ = cljs.core.get.call(null,map__67736__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67736__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67736__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feTile",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feTile.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feTile.cljs$lang$applyTo = (function (seq67728){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67728));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ellipse "hello")
 * (ellipse nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ellipse {:onClick f} "hello")
 * (ellipse #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ellipse :#the-id.klass.other-klass "hello")
 * (ellipse :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.ellipse = (function fulcro$client$dom$ellipse(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70474 = arguments.length;
var i__4731__auto___70475 = (0);
while(true){
if((i__4731__auto___70475 < len__4730__auto___70474)){
args__4736__auto__.push((arguments[i__4731__auto___70475]));

var G__70477 = (i__4731__auto___70475 + (1));
i__4731__auto___70475 = G__70477;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67764 = conformed_args__63534__auto__;
var map__67764__$1 = (((((!((map__67764 == null))))?(((((map__67764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67764):map__67764);
var css__63537__auto__ = cljs.core.get.call(null,map__67764__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67764__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67764__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"ellipse",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.ellipse.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.ellipse.cljs$lang$applyTo = (function (seq67751){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67751));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (code "hello")
 * (code nil "hello")
 * 
 * These two are made equivalent at compile time
 * (code {:onClick f} "hello")
 * (code #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (code :#the-id.klass.other-klass "hello")
 * (code :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.code = (function fulcro$client$dom$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70488 = arguments.length;
var i__4731__auto___70489 = (0);
while(true){
if((i__4731__auto___70489 < len__4730__auto___70488)){
args__4736__auto__.push((arguments[i__4731__auto___70489]));

var G__70492 = (i__4731__auto___70489 + (1));
i__4731__auto___70489 = G__70492;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.code.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.code.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67773 = conformed_args__63534__auto__;
var map__67773__$1 = (((((!((map__67773 == null))))?(((((map__67773.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67773.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67773):map__67773);
var css__63537__auto__ = cljs.core.get.call(null,map__67773__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67773__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67773__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"code",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.code.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.code.cljs$lang$applyTo = (function (seq67769){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67769));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dialog "hello")
 * (dialog nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dialog {:onClick f} "hello")
 * (dialog #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dialog :#the-id.klass.other-klass "hello")
 * (dialog :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.dialog = (function fulcro$client$dom$dialog(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70517 = arguments.length;
var i__4731__auto___70519 = (0);
while(true){
if((i__4731__auto___70519 < len__4730__auto___70517)){
args__4736__auto__.push((arguments[i__4731__auto___70519]));

var G__70523 = (i__4731__auto___70519 + (1));
i__4731__auto___70519 = G__70523;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.dialog.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.dialog.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67782 = conformed_args__63534__auto__;
var map__67782__$1 = (((((!((map__67782 == null))))?(((((map__67782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67782.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67782):map__67782);
var css__63537__auto__ = cljs.core.get.call(null,map__67782__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67782__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67782__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"dialog",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.dialog.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.dialog.cljs$lang$applyTo = (function (seq67780){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67780));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (linearGradient "hello")
 * (linearGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (linearGradient {:onClick f} "hello")
 * (linearGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (linearGradient :#the-id.klass.other-klass "hello")
 * (linearGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.linearGradient = (function fulcro$client$dom$linearGradient(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70545 = arguments.length;
var i__4731__auto___70547 = (0);
while(true){
if((i__4731__auto___70547 < len__4730__auto___70545)){
args__4736__auto__.push((arguments[i__4731__auto___70547]));

var G__70550 = (i__4731__auto___70547 + (1));
i__4731__auto___70547 = G__70550;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67794 = conformed_args__63534__auto__;
var map__67794__$1 = (((((!((map__67794 == null))))?(((((map__67794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67794.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67794):map__67794);
var css__63537__auto__ = cljs.core.get.call(null,map__67794__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67794__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67794__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"linearGradient",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.linearGradient.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.linearGradient.cljs$lang$applyTo = (function (seq67792){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67792));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (discard "hello")
 * (discard nil "hello")
 * 
 * These two are made equivalent at compile time
 * (discard {:onClick f} "hello")
 * (discard #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (discard :#the-id.klass.other-klass "hello")
 * (discard :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.discard = (function fulcro$client$dom$discard(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70575 = arguments.length;
var i__4731__auto___70576 = (0);
while(true){
if((i__4731__auto___70576 < len__4730__auto___70575)){
args__4736__auto__.push((arguments[i__4731__auto___70576]));

var G__70580 = (i__4731__auto___70576 + (1));
i__4731__auto___70576 = G__70580;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.discard.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.discard.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67802 = conformed_args__63534__auto__;
var map__67802__$1 = (((((!((map__67802 == null))))?(((((map__67802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67802):map__67802);
var css__63537__auto__ = cljs.core.get.call(null,map__67802__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67802__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67802__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"discard",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.discard.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.discard.cljs$lang$applyTo = (function (seq67799){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67799));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-src "hello")
 * (font-face-src nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-src {:onClick f} "hello")
 * (font-face-src #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-src :#the-id.klass.other-klass "hello")
 * (font-face-src :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.font_face_src = (function fulcro$client$dom$font_face_src(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70606 = arguments.length;
var i__4731__auto___70607 = (0);
while(true){
if((i__4731__auto___70607 < len__4730__auto___70606)){
args__4736__auto__.push((arguments[i__4731__auto___70607]));

var G__70611 = (i__4731__auto___70607 + (1));
i__4731__auto___70607 = G__70611;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67818 = conformed_args__63534__auto__;
var map__67818__$1 = (((((!((map__67818 == null))))?(((((map__67818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67818.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67818):map__67818);
var css__63537__auto__ = cljs.core.get.call(null,map__67818__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67818__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67818__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"font-face-src",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.font_face_src.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.font_face_src.cljs$lang$applyTo = (function (seq67807){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67807));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (noscript "hello")
 * (noscript nil "hello")
 * 
 * These two are made equivalent at compile time
 * (noscript {:onClick f} "hello")
 * (noscript #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (noscript :#the-id.klass.other-klass "hello")
 * (noscript :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.noscript = (function fulcro$client$dom$noscript(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70617 = arguments.length;
var i__4731__auto___70618 = (0);
while(true){
if((i__4731__auto___70618 < len__4730__auto___70617)){
args__4736__auto__.push((arguments[i__4731__auto___70618]));

var G__70620 = (i__4731__auto___70618 + (1));
i__4731__auto___70618 = G__70620;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.noscript.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.noscript.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67821 = conformed_args__63534__auto__;
var map__67821__$1 = (((((!((map__67821 == null))))?(((((map__67821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67821):map__67821);
var css__63537__auto__ = cljs.core.get.call(null,map__67821__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67821__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67821__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"noscript",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.noscript.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.noscript.cljs$lang$applyTo = (function (seq67820){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67820));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateTransform "hello")
 * (animateTransform nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateTransform {:onClick f} "hello")
 * (animateTransform #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateTransform :#the-id.klass.other-klass "hello")
 * (animateTransform :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.animateTransform = (function fulcro$client$dom$animateTransform(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70627 = arguments.length;
var i__4731__auto___70628 = (0);
while(true){
if((i__4731__auto___70628 < len__4730__auto___70627)){
args__4736__auto__.push((arguments[i__4731__auto___70628]));

var G__70629 = (i__4731__auto___70628 + (1));
i__4731__auto___70628 = G__70629;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67824 = conformed_args__63534__auto__;
var map__67824__$1 = (((((!((map__67824 == null))))?(((((map__67824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67824):map__67824);
var css__63537__auto__ = cljs.core.get.call(null,map__67824__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67824__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67824__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"animateTransform",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.animateTransform.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.animateTransform.cljs$lang$applyTo = (function (seq67823){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67823));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix "hello")
 * (feColorMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix {:onClick f} "hello")
 * (feColorMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feColorMatrix :#the-id.klass.other-klass "hello")
 * (feColorMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.feColorMatrix = (function fulcro$client$dom$feColorMatrix(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70637 = arguments.length;
var i__4731__auto___70639 = (0);
while(true){
if((i__4731__auto___70639 < len__4730__auto___70637)){
args__4736__auto__.push((arguments[i__4731__auto___70639]));

var G__70641 = (i__4731__auto___70639 + (1));
i__4731__auto___70639 = G__70641;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67828 = conformed_args__63534__auto__;
var map__67828__$1 = (((((!((map__67828 == null))))?(((((map__67828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67828.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67828):map__67828);
var css__63537__auto__ = cljs.core.get.call(null,map__67828__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67828__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67828__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"feColorMatrix",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.feColorMatrix.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.feColorMatrix.cljs$lang$applyTo = (function (seq67827){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67827));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h2 "hello")
 * (h2 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h2 {:onClick f} "hello")
 * (h2 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h2 :#the-id.klass.other-klass "hello")
 * (h2 :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.h2 = (function fulcro$client$dom$h2(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70650 = arguments.length;
var i__4731__auto___70652 = (0);
while(true){
if((i__4731__auto___70652 < len__4730__auto___70650)){
args__4736__auto__.push((arguments[i__4731__auto___70652]));

var G__70655 = (i__4731__auto___70652 + (1));
i__4731__auto___70652 = G__70655;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.h2.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.h2.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67832 = conformed_args__63534__auto__;
var map__67832__$1 = (((((!((map__67832 == null))))?(((((map__67832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67832):map__67832);
var css__63537__auto__ = cljs.core.get.call(null,map__67832__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67832__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67832__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"h2",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.h2.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.h2.cljs$lang$applyTo = (function (seq67831){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67831));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (area "hello")
 * (area nil "hello")
 * 
 * These two are made equivalent at compile time
 * (area {:onClick f} "hello")
 * (area #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (area :#the-id.klass.other-klass "hello")
 * (area :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.area = (function fulcro$client$dom$area(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70661 = arguments.length;
var i__4731__auto___70662 = (0);
while(true){
if((i__4731__auto___70662 < len__4730__auto___70661)){
args__4736__auto__.push((arguments[i__4731__auto___70662]));

var G__70664 = (i__4731__auto___70662 + (1));
i__4731__auto___70662 = G__70664;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.area.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.area.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67836 = conformed_args__63534__auto__;
var map__67836__$1 = (((((!((map__67836 == null))))?(((((map__67836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67836):map__67836);
var css__63537__auto__ = cljs.core.get.call(null,map__67836__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67836__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67836__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"area",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.area.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.area.cljs$lang$applyTo = (function (seq67834){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67834));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (br "hello")
 * (br nil "hello")
 * 
 * These two are made equivalent at compile time
 * (br {:onClick f} "hello")
 * (br #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (br :#the-id.klass.other-klass "hello")
 * (br :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.br = (function fulcro$client$dom$br(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70677 = arguments.length;
var i__4731__auto___70678 = (0);
while(true){
if((i__4731__auto___70678 < len__4730__auto___70677)){
args__4736__auto__.push((arguments[i__4731__auto___70678]));

var G__70679 = (i__4731__auto___70678 + (1));
i__4731__auto___70678 = G__70679;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.br.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.br.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67845 = conformed_args__63534__auto__;
var map__67845__$1 = (((((!((map__67845 == null))))?(((((map__67845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67845.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67845):map__67845);
var css__63537__auto__ = cljs.core.get.call(null,map__67845__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67845__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67845__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"br",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.br.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.br.cljs$lang$applyTo = (function (seq67839){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67839));
});


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (image "hello")
 * (image nil "hello")
 * 
 * These two are made equivalent at compile time
 * (image {:onClick f} "hello")
 * (image #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (image :#the-id.klass.other-klass "hello")
 * (image :#the-id.klass.other-klass {:onClick f} "hello")
 */
fulcro.client.dom.image = (function fulcro$client$dom$image(var_args){
var args__4736__auto__ = [];
var len__4730__auto___70689 = arguments.length;
var i__4731__auto___70690 = (0);
while(true){
if((i__4731__auto___70690 < len__4730__auto___70689)){
args__4736__auto__.push((arguments[i__4731__auto___70690]));

var G__70692 = (i__4731__auto___70690 + (1));
i__4731__auto___70690 = G__70692;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fulcro.client.dom.image.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fulcro.client.dom.image.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__63534__auto__ = fulcro.util.conform_BANG_.call(null,new cljs.core.Keyword("fulcro.client.dom","dom-element-args","fulcro.client.dom/dom-element-args",1547208006),args);
var map__67853 = conformed_args__63534__auto__;
var map__67853__$1 = (((((!((map__67853 == null))))?(((((map__67853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__67853):map__67853);
var css__63537__auto__ = cljs.core.get.call(null,map__67853__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__63535__auto__ = cljs.core.get.call(null,map__67853__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__63536__auto__ = cljs.core.get.call(null,map__67853__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__63536__auto____$1 = cljs.core.mapv.call(null,cljs.core.second,children__63536__auto__);
var attrs_value__63538__auto__ = (function (){var or__4131__auto__ = cljs.core.second.call(null,attrs__63535__auto__);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return fulcro.client.dom.macro_create_element.call(null,"image",cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__63538__auto__], null),children__63536__auto____$1),css__63537__auto__);
});

fulcro.client.dom.image.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fulcro.client.dom.image.cljs$lang$applyTo = (function (seq67849){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67849));
});


//# sourceMappingURL=fulcro.client.dom.js.map
