goog.provide('shadow.object');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.data');
goog.require('cljs.core.async.impl.protocols');
goog.require('shadow.util');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._id[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._id["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
}
});

shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._type[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._type["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
}
});

shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._data[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._data["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
}
});

/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._update[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$,update_fn);
} else {
var m__4431__auto__ = (shadow.object._update["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
}
});

shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$,cause);
} else {
var m__4431__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type(this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__60874 = arguments.length;
switch (G__60874) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type(oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
});

shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type(oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
});

shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3;

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__4131__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id(obj),shadow.object._id(obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id(obj),(function (){var temp__5720__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5720__auto__)){
var oid = temp__5720__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id(oref));
if(cljs.core.truth_(temp__5720__auto__)){
var parent_id = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type(parent),parent_type)){
return parent;
} else {
var G__61624 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__61624;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id(parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,((function (parent_id,child_ids,instances){
return (function (p1__60889_SHARP_){
return cljs.core.get.call(null,instances,p1__60889_SHARP_);
});})(parent_id,child_ids,instances))
,child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__60894 = arguments.length;
switch (G__60894) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
});

shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
});

shadow.object.tree_seq.cljs$lang$maxFixedArity = 2;

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type(type));
return cljs.core.filter.call(null,((function (type_kw){
return (function (p1__60896_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type(p1__60896_SHARP_));
});})(type_kw))
,shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__60900){
var map__60901 = p__60900;
var map__60901__$1 = (((((!((map__60901 == null))))?(((((map__60901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60901.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__60901):map__60901);
var oref = map__60901__$1;
var parent = cljs.core.get.call(null,map__60901__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__60906 = arguments.length;
switch (G__60906) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
});

shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type(type));
return cljs.core.filter.call(null,((function (type_kw){
return (function (p1__60904_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type(p1__60904_SHARP_));
});})(type_kw))
,shadow.object.get_siblings.call(null,oref));
});

shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2;

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5718__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5718__auto__)){
var obj = temp__5718__auto__;
return obj;
} else {
var temp__5720__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5720__auto__)){
var parent = temp__5720__auto__;
var G__61639 = parent;
dom = G__61639;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61640 = arguments.length;
var i__4731__auto___61641 = (0);
while(true){
if((i__4731__auto___61641 < len__4730__auto___61640)){
args__4736__auto__.push((arguments[i__4731__auto___61641]));

var G__61642 = (i__4731__auto___61641 + (1));
i__4731__auto___61641 = G__61642;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5720__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5720__auto__)){
var reactions_to_trigger = temp__5720__auto__;
var seq__60925 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__60926 = null;
var count__60927 = (0);
var i__60928 = (0);
while(true){
if((i__60928 < count__60927)){
var rfn = cljs.core._nth(chunk__60926,i__60928);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__61644 = seq__60925;
var G__61645 = chunk__60926;
var G__61646 = count__60927;
var G__61647 = (i__60928 + (1));
seq__60925 = G__61644;
chunk__60926 = G__61645;
count__60927 = G__61646;
i__60928 = G__61647;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__60925);
if(temp__5720__auto____$1){
var seq__60925__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__60925__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__60925__$1);
var G__61649 = cljs.core.chunk_rest.call(null,seq__60925__$1);
var G__61650 = c__4550__auto__;
var G__61651 = cljs.core.count.call(null,c__4550__auto__);
var G__61652 = (0);
seq__60925 = G__61649;
chunk__60926 = G__61650;
count__60927 = G__61651;
i__60928 = G__61652;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__60925__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__61654 = cljs.core.next.call(null,seq__60925__$1);
var G__61655 = null;
var G__61656 = (0);
var G__61657 = (0);
seq__60925 = G__61654;
chunk__60926 = G__61655;
count__60927 = G__61656;
i__60928 = G__61657;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});

shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq60918){
var G__60919 = cljs.core.first.call(null,seq60918);
var seq60918__$1 = cljs.core.next.call(null,seq60918);
var G__60920 = cljs.core.first.call(null,seq60918__$1);
var seq60918__$2 = cljs.core.next.call(null,seq60918__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60919,G__60920,seq60918__$2);
});

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__60944_61659 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__60945_61660 = null;
var count__60946_61661 = (0);
var i__60947_61662 = (0);
while(true){
if((i__60947_61662 < count__60946_61661)){
var child_61663 = cljs.core._nth(chunk__60945_61660,i__60947_61662);
shadow.object.do_notify_tree.call(null,child_61663,ev,notify_fn);


var G__61664 = seq__60944_61659;
var G__61665 = chunk__60945_61660;
var G__61666 = count__60946_61661;
var G__61667 = (i__60947_61662 + (1));
seq__60944_61659 = G__61664;
chunk__60945_61660 = G__61665;
count__60946_61661 = G__61666;
i__60947_61662 = G__61667;
continue;
} else {
var temp__5720__auto___61668 = cljs.core.seq.call(null,seq__60944_61659);
if(temp__5720__auto___61668){
var seq__60944_61669__$1 = temp__5720__auto___61668;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__60944_61669__$1)){
var c__4550__auto___61670 = cljs.core.chunk_first.call(null,seq__60944_61669__$1);
var G__61671 = cljs.core.chunk_rest.call(null,seq__60944_61669__$1);
var G__61672 = c__4550__auto___61670;
var G__61673 = cljs.core.count.call(null,c__4550__auto___61670);
var G__61674 = (0);
seq__60944_61659 = G__61671;
chunk__60945_61660 = G__61672;
count__60946_61661 = G__61673;
i__60947_61662 = G__61674;
continue;
} else {
var child_61676 = cljs.core.first.call(null,seq__60944_61669__$1);
shadow.object.do_notify_tree.call(null,child_61676,ev,notify_fn);


var G__61677 = cljs.core.next.call(null,seq__60944_61669__$1);
var G__61678 = null;
var G__61679 = (0);
var G__61680 = (0);
seq__60944_61659 = G__61677;
chunk__60945_61660 = G__61678;
count__60946_61661 = G__61679;
i__60947_61662 = G__61680;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61681 = arguments.length;
var i__4731__auto___61682 = (0);
while(true){
if((i__4731__auto___61682 < len__4730__auto___61681)){
args__4736__auto__.push((arguments[i__4731__auto___61682]));

var G__61684 = (i__4731__auto___61682 + (1));
i__4731__auto___61682 = G__61684;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
});

shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq60955){
var G__60956 = cljs.core.first.call(null,seq60955);
var seq60955__$1 = cljs.core.next.call(null,seq60955);
var G__60957 = cljs.core.first.call(null,seq60955__$1);
var seq60955__$2 = cljs.core.next.call(null,seq60955__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60956,G__60957,seq60955__$2);
});

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61686 = arguments.length;
var i__4731__auto___61687 = (0);
while(true){
if((i__4731__auto___61687 < len__4730__auto___61686)){
args__4736__auto__.push((arguments[i__4731__auto___61687]));

var G__61688 = (i__4731__auto___61687 + (1));
i__4731__auto___61687 = G__61688;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__61690 = shadow.object.get_parent.call(null,current);
current = G__61690;
continue;
} else {
return null;
}
break;
}
});

shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq60960){
var G__60961 = cljs.core.first.call(null,seq60960);
var seq60960__$1 = cljs.core.next.call(null,seq60960);
var G__60962 = cljs.core.first.call(null,seq60960__$1);
var seq60960__$2 = cljs.core.next.call(null,seq60960__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60961,G__60962,seq60960__$2);
});

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61693 = arguments.length;
var i__4731__auto___61694 = (0);
while(true){
if((i__4731__auto___61694 < len__4730__auto___61693)){
args__4736__auto__.push((arguments[i__4731__auto___61694]));

var G__61696 = (i__4731__auto___61694 + (1));
i__4731__auto___61694 = G__61696;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id(oref);
var data = shadow.object._data(oref);
var work_fn = ((function (id,data){
return (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});})(id,data))
;
return shadow.object._update(oref,work_fn);
});

shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq60970){
var G__60971 = cljs.core.first.call(null,seq60970);
var seq60970__$1 = cljs.core.next.call(null,seq60970);
var G__60972 = cljs.core.first.call(null,seq60970__$1);
var seq60970__$2 = cljs.core.next.call(null,seq60970__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60971,G__60972,seq60970__$2);
});

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id(child);
var parent_id = shadow.object._id(parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,((function (child_id,parent_id){
return (function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
});})(child_id,parent_id))
);

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5718__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5718__auto__)){
var custom_remove = temp__5718__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__60987 = arguments.length;
switch (G__60987) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
});

shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_(oref,cause);
});

shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2;

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type(oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__60988 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__60989 = null;
var count__60990 = (0);
var i__60991 = (0);
while(true){
if((i__60991 < count__60990)){
var vec__61011 = cljs.core._nth(chunk__60989,i__60991);
var ev = cljs.core.nth.call(null,vec__61011,(0),null);
var handler = cljs.core.nth.call(null,vec__61011,(1),null);
var ev_def = vec__61011;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_61722__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__60988,chunk__60989,count__60990,i__60991,vec__61011,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__60988,chunk__60989,count__60990,i__60991,vec__61011,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__60988,chunk__60989,count__60990,i__60991,handler_61722__$1,vec__61011,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_61722__$1.call(null,oref,e,el);
});})(seq__60988,chunk__60989,count__60990,i__60991,handler_61722__$1,vec__61011,ev,handler,ev_def))
);


var G__61726 = seq__60988;
var G__61727 = chunk__60989;
var G__61728 = count__60990;
var G__61729 = (i__60991 + (1));
seq__60988 = G__61726;
chunk__60989 = G__61727;
count__60990 = G__61728;
i__60991 = G__61729;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__60988);
if(temp__5720__auto__){
var seq__60988__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__60988__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__60988__$1);
var G__61731 = cljs.core.chunk_rest.call(null,seq__60988__$1);
var G__61732 = c__4550__auto__;
var G__61733 = cljs.core.count.call(null,c__4550__auto__);
var G__61734 = (0);
seq__60988 = G__61731;
chunk__60989 = G__61732;
count__60990 = G__61733;
i__60991 = G__61734;
continue;
} else {
var vec__61023 = cljs.core.first.call(null,seq__60988__$1);
var ev = cljs.core.nth.call(null,vec__61023,(0),null);
var handler = cljs.core.nth.call(null,vec__61023,(1),null);
var ev_def = vec__61023;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_61738__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__60988,chunk__60989,count__60990,i__60991,vec__61023,ev,handler,ev_def,seq__60988__$1,temp__5720__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__60988,chunk__60989,count__60990,i__60991,vec__61023,ev,handler,ev_def,seq__60988__$1,temp__5720__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__60988,chunk__60989,count__60990,i__60991,handler_61738__$1,vec__61023,ev,handler,ev_def,seq__60988__$1,temp__5720__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_61738__$1.call(null,oref,e,el);
});})(seq__60988,chunk__60989,count__60990,i__60991,handler_61738__$1,vec__61023,ev,handler,ev_def,seq__60988__$1,temp__5720__auto__))
);


var G__61741 = cljs.core.next.call(null,seq__60988__$1);
var G__61742 = null;
var G__61743 = (0);
var G__61744 = (0);
seq__60988 = G__61741;
chunk__60989 = G__61742;
count__60990 = G__61743;
i__60991 = G__61744;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__61032){
var vec__61033 = p__61032;
var event = cljs.core.nth.call(null,vec__61033,(0),null);
var handler = cljs.core.nth.call(null,vec__61033,(1),null);
if(cljs.core.truth_((function (){var and__4120__auto__ = event;
if(cljs.core.truth_(and__4120__auto__)){
return handler;
} else {
return and__4120__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61766 = arguments.length;
var i__4731__auto___61767 = (0);
while(true){
if((i__4731__auto___61767 < len__4730__auto___61766)){
args__4736__auto__.push((arguments[i__4731__auto___61767]));

var G__61768 = (i__4731__auto___61767 + (1));
i__4731__auto___61767 = G__61768;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e61064){if((e61064 instanceof Object)){
var e = e61064;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e61064;

}
}});

shadow.object.define.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.object.define.cljs$lang$applyTo = (function (seq61049){
var G__61050 = cljs.core.first.call(null,seq61049);
var seq61049__$1 = cljs.core.next.call(null,seq61049);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61050,seq61049__$1);
});

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__61076 = arguments.length;
switch (G__61076) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
});

shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
});

shadow.object.make_dom.cljs$lang$maxFixedArity = 4;

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id(obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k61084,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__61094 = k61084;
var G__61094__$1 = (((G__61094 instanceof cljs.core.Keyword))?G__61094.fqn:null);
switch (G__61094__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k61084,else__4388__auto__);

}
});

shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__61098){
var vec__61099 = p__61098;
var k__4408__auto__ = cljs.core.nth.call(null,vec__61099,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__61099,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.object.Watch{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61083){
var self__ = this;
var G__61083__$1 = this;
return (new cljs.core.RecordIter((0),G__61083__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
(this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61086,other61087){
var self__ = this;
var this61086__$1 = this;
return (((!((other61087 == null)))) && ((this61086__$1.constructor === other61087.constructor)) && (cljs.core._EQ_.call(null,this61086__$1.key,other61087.key)) && (cljs.core._EQ_.call(null,this61086__$1.handler,other61087.handler)) && (cljs.core._EQ_.call(null,this61086__$1.__extmap,other61087.__extmap)));
});

shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__61083){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__61137 = cljs.core.keyword_identical_QMARK_;
var expr__61138 = k__4393__auto__;
if(cljs.core.truth_(pred__61137.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__61138))){
return (new shadow.object.Watch(G__61083,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61137.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__61138))){
return (new shadow.object.Watch(self__.key,G__61083,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__61083),null));
}
}
});

shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__61083){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__61083,self__.__extmap,self__.__hash));
});

shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4391__auto__,(0)),cljs.core._nth(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
});

shadow.object.Watch.cljs$lang$type = true;

shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
});

shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.object/Watch");
});

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__61090){
var extmap__4424__auto__ = (function (){var G__61155 = cljs.core.dissoc.call(null,G__61090,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__61090)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__61155);
} else {
return G__61155;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__61090),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__61090),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.result_chan,handler);
});

shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
});

shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
});

shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
});

shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write(writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
});

shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
});

shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id(this$__$1),shadow.object._id(other))));
});

shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null)));
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return self__.watches = cljs.core.remove.call(null,((function (this$__$1){
return (function (p1__61161_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__61161_SHARP_));
});})(this$__$1))
,self__.watches);
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
self__.data = new$;

var seq__61185 = cljs.core.seq.call(null,self__.watches);
var chunk__61186 = null;
var count__61187 = (0);
var i__61188 = (0);
while(true){
if((i__61188 < count__61187)){
var map__61201 = cljs.core._nth(chunk__61186,i__61188);
var map__61201__$1 = (((((!((map__61201 == null))))?(((((map__61201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61201.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61201):map__61201);
var watch = map__61201__$1;
var key = cljs.core.get.call(null,map__61201__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__61201__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__61843 = seq__61185;
var G__61844 = chunk__61186;
var G__61845 = count__61187;
var G__61846 = (i__61188 + (1));
seq__61185 = G__61843;
chunk__61186 = G__61844;
count__61187 = G__61845;
i__61188 = G__61846;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__61185);
if(temp__5720__auto__){
var seq__61185__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61185__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__61185__$1);
var G__61848 = cljs.core.chunk_rest.call(null,seq__61185__$1);
var G__61849 = c__4550__auto__;
var G__61850 = cljs.core.count.call(null,c__4550__auto__);
var G__61851 = (0);
seq__61185 = G__61848;
chunk__61186 = G__61849;
count__61187 = G__61850;
i__61188 = G__61851;
continue;
} else {
var map__61217 = cljs.core.first.call(null,seq__61185__$1);
var map__61217__$1 = (((((!((map__61217 == null))))?(((((map__61217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61217.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61217):map__61217);
var watch = map__61217__$1;
var key = cljs.core.get.call(null,map__61217__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__61217__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__61866 = cljs.core.next.call(null,seq__61185__$1);
var G__61867 = null;
var G__61868 = (0);
var G__61869 = (0);
seq__61185 = G__61866;
chunk__61186 = G__61867;
count__61187 = G__61868;
i__61188 = G__61869;
continue;
}
} else {
return null;
}
}
break;
}
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__61224_61871 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__61225_61872 = null;
var count__61226_61873 = (0);
var i__61227_61874 = (0);
while(true){
if((i__61227_61874 < count__61226_61873)){
var child_61875 = cljs.core._nth(chunk__61225_61872,i__61227_61874);
shadow.object._destroy_BANG_(child_61875,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__61876 = seq__61224_61871;
var G__61877 = chunk__61225_61872;
var G__61878 = count__61226_61873;
var G__61879 = (i__61227_61874 + (1));
seq__61224_61871 = G__61876;
chunk__61225_61872 = G__61877;
count__61226_61873 = G__61878;
i__61227_61874 = G__61879;
continue;
} else {
var temp__5720__auto___61880 = cljs.core.seq.call(null,seq__61224_61871);
if(temp__5720__auto___61880){
var seq__61224_61881__$1 = temp__5720__auto___61880;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61224_61881__$1)){
var c__4550__auto___61882 = cljs.core.chunk_first.call(null,seq__61224_61881__$1);
var G__61883 = cljs.core.chunk_rest.call(null,seq__61224_61881__$1);
var G__61884 = c__4550__auto___61882;
var G__61885 = cljs.core.count.call(null,c__4550__auto___61882);
var G__61886 = (0);
seq__61224_61871 = G__61883;
chunk__61225_61872 = G__61884;
count__61226_61873 = G__61885;
i__61227_61874 = G__61886;
continue;
} else {
var child_61887 = cljs.core.first.call(null,seq__61224_61881__$1);
shadow.object._destroy_BANG_(child_61887,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__61888 = cljs.core.next.call(null,seq__61224_61881__$1);
var G__61889 = null;
var G__61890 = (0);
var G__61891 = (0);
seq__61224_61871 = G__61888;
chunk__61225_61872 = G__61889;
count__61226_61873 = G__61890;
i__61227_61874 = G__61891;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_61896 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_61896 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_61896);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
});

shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
});

shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
});

shadow.object.ObjectRef.cljs$lang$type = true;

shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef";

shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"shadow.object/ObjectRef");
});

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__61251 = arguments.length;
switch (G__61251) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
});

shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
});

shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3;

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__61266 = arguments.length;
switch (G__61266) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
});

shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,((function (attr__$1){
return (function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
});})(attr__$1))
);
});

shadow.object.bind_change.cljs$lang$maxFixedArity = 4;

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__4736__auto__ = [];
var len__4730__auto___61922 = arguments.length;
var i__4731__auto___61923 = (0);
while(true){
if((i__4731__auto___61923 < len__4730__auto___61922)){
args__4736__auto__.push((arguments[i__4731__auto___61923]));

var G__61927 = (i__4731__auto___61923 + (1));
i__4731__auto___61923 = G__61927;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_61944 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5718__auto___61945 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5718__auto___61945)){
var dom_61946 = temp__5718__auto___61945;
shadow.dom.set_data.call(null,dom_61946,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_61946,dom_events_61944);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_61946);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_61946);
} else {
var temp__5720__auto___61947 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___61947)){
var dom_fn_61950 = temp__5720__auto___61947;
var dom_61954 = shadow.dom.build.call(null,dom_fn_61950.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_61954,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_61954);

shadow.object.bind_dom_events.call(null,oref,dom_61954,dom_events_61944);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_61954);
} else {
}
}

var temp__5720__auto___61956 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___61956)){
var watches_61958 = temp__5720__auto___61956;
var seq__61325_61960 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_61958));
var chunk__61326_61963 = null;
var count__61327_61964 = (0);
var i__61328_61965 = (0);
while(true){
if((i__61328_61965 < count__61327_61964)){
var vec__61347_61969 = cljs.core._nth(chunk__61326_61963,i__61328_61965);
var attr_61970 = cljs.core.nth.call(null,vec__61347_61969,(0),null);
var handler_61971 = cljs.core.nth.call(null,vec__61347_61969,(1),null);
shadow.object.bind_change.call(null,oref,attr_61970,((function (seq__61325_61960,chunk__61326_61963,count__61327_61964,i__61328_61965,vec__61347_61969,attr_61970,handler_61971,watches_61958,temp__5720__auto___61956,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_61971.call(null,oref,old,new$);
});})(seq__61325_61960,chunk__61326_61963,count__61327_61964,i__61328_61965,vec__61347_61969,attr_61970,handler_61971,watches_61958,temp__5720__auto___61956,oid,parent,result_chan,odef,obj,oref))
);


var G__61977 = seq__61325_61960;
var G__61978 = chunk__61326_61963;
var G__61979 = count__61327_61964;
var G__61980 = (i__61328_61965 + (1));
seq__61325_61960 = G__61977;
chunk__61326_61963 = G__61978;
count__61327_61964 = G__61979;
i__61328_61965 = G__61980;
continue;
} else {
var temp__5720__auto___61981__$1 = cljs.core.seq.call(null,seq__61325_61960);
if(temp__5720__auto___61981__$1){
var seq__61325_61982__$1 = temp__5720__auto___61981__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61325_61982__$1)){
var c__4550__auto___61983 = cljs.core.chunk_first.call(null,seq__61325_61982__$1);
var G__61984 = cljs.core.chunk_rest.call(null,seq__61325_61982__$1);
var G__61985 = c__4550__auto___61983;
var G__61986 = cljs.core.count.call(null,c__4550__auto___61983);
var G__61987 = (0);
seq__61325_61960 = G__61984;
chunk__61326_61963 = G__61985;
count__61327_61964 = G__61986;
i__61328_61965 = G__61987;
continue;
} else {
var vec__61361_61988 = cljs.core.first.call(null,seq__61325_61982__$1);
var attr_61989 = cljs.core.nth.call(null,vec__61361_61988,(0),null);
var handler_61990 = cljs.core.nth.call(null,vec__61361_61988,(1),null);
shadow.object.bind_change.call(null,oref,attr_61989,((function (seq__61325_61960,chunk__61326_61963,count__61327_61964,i__61328_61965,vec__61361_61988,attr_61989,handler_61990,seq__61325_61982__$1,temp__5720__auto___61981__$1,watches_61958,temp__5720__auto___61956,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_61990.call(null,oref,old,new$);
});})(seq__61325_61960,chunk__61326_61963,count__61327_61964,i__61328_61965,vec__61361_61988,attr_61989,handler_61990,seq__61325_61982__$1,temp__5720__auto___61981__$1,watches_61958,temp__5720__auto___61956,oid,parent,result_chan,odef,obj,oref))
);


var G__61998 = cljs.core.next.call(null,seq__61325_61982__$1);
var G__61999 = null;
var G__62000 = (0);
var G__62001 = (0);
seq__61325_61960 = G__61998;
chunk__61326_61963 = G__61999;
count__61327_61964 = G__62000;
i__61328_61965 = G__62001;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
});

shadow.object.create.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.create.cljs$lang$applyTo = (function (seq61294){
var G__61295 = cljs.core.first.call(null,seq61294);
var seq61294__$1 = cljs.core.next.call(null,seq61294);
var G__61296 = cljs.core.first.call(null,seq61294__$1);
var seq61294__$2 = cljs.core.next.call(null,seq61294__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61295,G__61296,seq61294__$2);
});

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__61371 = arguments.length;
switch (G__61371) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
});

shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = ((function (attr__$1){
return (function (p1__61366_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__61366_SHARP_));
});})(attr__$1))
;
var node = cljs.core.atom.call(null,node_get(cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,((function (attr__$1,node_get,node,bind_key){
return (function (old,new$){
var new_node = node_get(new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
});})(attr__$1,node_get,node,bind_key))
);

return cljs.core.deref.call(null,node);
});

shadow.object.bind_simple.cljs$lang$maxFixedArity = 3;

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = ((function (attr__$1,curval){
return (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});})(attr__$1,curval))
;
var child = cljs.core.atom.call(null,make_child_fn(curval));
shadow.object.bind_change.call(null,oref,attr__$1,((function (attr__$1,curval,make_child_fn,child){
return (function (old,new$){
var new_child = make_child_fn(new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
});})(attr__$1,curval,make_child_fn,child))
);

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__61405_62015 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__61406_62016 = null;
var count__61407_62017 = (0);
var i__61408_62018 = (0);
while(true){
if((i__61408_62018 < count__61407_62017)){
var obj_62019 = cljs.core._nth(chunk__61406_62016,i__61408_62018);
var obj_62020__$1 = shadow.object.get_from_dom.call(null,obj_62019);
shadow.object.destroy_BANG_.call(null,obj_62020__$1);


var G__62024 = seq__61405_62015;
var G__62025 = chunk__61406_62016;
var G__62026 = count__61407_62017;
var G__62027 = (i__61408_62018 + (1));
seq__61405_62015 = G__62024;
chunk__61406_62016 = G__62025;
count__61407_62017 = G__62026;
i__61408_62018 = G__62027;
continue;
} else {
var temp__5720__auto___62029 = cljs.core.seq.call(null,seq__61405_62015);
if(temp__5720__auto___62029){
var seq__61405_62031__$1 = temp__5720__auto___62029;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61405_62031__$1)){
var c__4550__auto___62032 = cljs.core.chunk_first.call(null,seq__61405_62031__$1);
var G__62033 = cljs.core.chunk_rest.call(null,seq__61405_62031__$1);
var G__62034 = c__4550__auto___62032;
var G__62035 = cljs.core.count.call(null,c__4550__auto___62032);
var G__62036 = (0);
seq__61405_62015 = G__62033;
chunk__61406_62016 = G__62034;
count__61407_62017 = G__62035;
i__61408_62018 = G__62036;
continue;
} else {
var obj_62037 = cljs.core.first.call(null,seq__61405_62031__$1);
var obj_62038__$1 = shadow.object.get_from_dom.call(null,obj_62037);
shadow.object.destroy_BANG_.call(null,obj_62038__$1);


var G__62039 = cljs.core.next.call(null,seq__61405_62031__$1);
var G__62040 = null;
var G__62041 = (0);
var G__62042 = (0);
seq__61405_62015 = G__62039;
chunk__61406_62016 = G__62040;
count__61407_62017 = G__62041;
i__61408_62018 = G__62042;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__61444 = arguments.length;
switch (G__61444) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__61431_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__61431_SHARP_);
}));
});

shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = ((function (attr__$1,update_children,coll_dom){
return (function (p__61451){
var vec__61452 = p__61451;
var key = cljs.core.nth.call(null,vec__61452,(0),null);
var val = cljs.core.nth.call(null,vec__61452,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,((function (obj,vec__61452,key,val,attr__$1,update_children,coll_dom){
return (function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
});})(obj,vec__61452,key,val,attr__$1,update_children,coll_dom))
);

return obj;
});})(attr__$1,update_children,coll_dom))
;
var seq__61456_62063 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__61457_62064 = null;
var count__61458_62065 = (0);
var i__61459_62066 = (0);
while(true){
if((i__61459_62066 < count__61458_62065)){
var item_62072 = cljs.core._nth(chunk__61457_62064,i__61459_62066);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_62072));


var G__62074 = seq__61456_62063;
var G__62075 = chunk__61457_62064;
var G__62076 = count__61458_62065;
var G__62077 = (i__61459_62066 + (1));
seq__61456_62063 = G__62074;
chunk__61457_62064 = G__62075;
count__61458_62065 = G__62076;
i__61459_62066 = G__62077;
continue;
} else {
var temp__5720__auto___62079 = cljs.core.seq.call(null,seq__61456_62063);
if(temp__5720__auto___62079){
var seq__61456_62083__$1 = temp__5720__auto___62079;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61456_62083__$1)){
var c__4550__auto___62084 = cljs.core.chunk_first.call(null,seq__61456_62083__$1);
var G__62086 = cljs.core.chunk_rest.call(null,seq__61456_62083__$1);
var G__62087 = c__4550__auto___62084;
var G__62088 = cljs.core.count.call(null,c__4550__auto___62084);
var G__62089 = (0);
seq__61456_62063 = G__62086;
chunk__61457_62064 = G__62087;
count__61458_62065 = G__62088;
i__61459_62066 = G__62089;
continue;
} else {
var item_62090 = cljs.core.first.call(null,seq__61456_62083__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_62090));


var G__62091 = cljs.core.next.call(null,seq__61456_62083__$1);
var G__62092 = null;
var G__62093 = (0);
var G__62094 = (0);
seq__61456_62063 = G__62091;
chunk__61457_62064 = G__62092;
count__61458_62065 = G__62093;
i__61459_62066 = G__62094;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,((function (attr__$1,update_children,coll_dom,make_item_fn){
return (function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__4222__auto__ = count_new;
var y__4223__auto__ = count_children;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var n__4607__auto___62102 = count_children__$1;
var idx_62105 = (0);
while(true){
if((idx_62105 < n__4607__auto___62102)){
var cn_62107 = cljs.core.nth.call(null,children__$1,idx_62105);
var cc_62108 = shadow.object.get_from_dom.call(null,cn_62107);
var ckey_62109 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_62108);
var cval_62110 = cljs.core.get.call(null,cc_62108,item_key);
var vec__61477_62111 = cljs.core.nth.call(null,new_coll,idx_62105);
var nkey_62112 = cljs.core.nth.call(null,vec__61477_62111,(0),null);
var nval_62113 = cljs.core.nth.call(null,vec__61477_62111,(1),null);
if(((cljs.core._EQ_.call(null,ckey_62109,nkey_62112)) && (cljs.core._EQ_.call(null,cval_62110,nval_62113)))){
} else {
var new_obj_62116 = make_item_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_62112,nval_62113], null));
shadow.dom.replace_node.call(null,cn_62107,new_obj_62116);

shadow.object.destroy_BANG_.call(null,cc_62108);

shadow.object.notify_tree_BANG_.call(null,new_obj_62116,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__62118 = (idx_62105 + (1));
idx_62105 = G__62118;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__61487_62122 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__61488_62123 = null;
var count__61489_62124 = (0);
var i__61490_62125 = (0);
while(true){
if((i__61490_62125 < count__61489_62124)){
var item_62133 = cljs.core._nth(chunk__61488_62123,i__61490_62125);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_62133));


var G__62134 = seq__61487_62122;
var G__62135 = chunk__61488_62123;
var G__62136 = count__61489_62124;
var G__62137 = (i__61490_62125 + (1));
seq__61487_62122 = G__62134;
chunk__61488_62123 = G__62135;
count__61489_62124 = G__62136;
i__61490_62125 = G__62137;
continue;
} else {
var temp__5720__auto___62139 = cljs.core.seq.call(null,seq__61487_62122);
if(temp__5720__auto___62139){
var seq__61487_62142__$1 = temp__5720__auto___62139;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61487_62142__$1)){
var c__4550__auto___62146 = cljs.core.chunk_first.call(null,seq__61487_62142__$1);
var G__62148 = cljs.core.chunk_rest.call(null,seq__61487_62142__$1);
var G__62149 = c__4550__auto___62146;
var G__62150 = cljs.core.count.call(null,c__4550__auto___62146);
var G__62151 = (0);
seq__61487_62122 = G__62148;
chunk__61488_62123 = G__62149;
count__61489_62124 = G__62150;
i__61490_62125 = G__62151;
continue;
} else {
var item_62157 = cljs.core.first.call(null,seq__61487_62142__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_62157));


var G__62158 = cljs.core.next.call(null,seq__61487_62142__$1);
var G__62159 = null;
var G__62160 = (0);
var G__62161 = (0);
seq__61487_62122 = G__62158;
chunk__61488_62123 = G__62159;
count__61489_62124 = G__62160;
i__61490_62125 = G__62161;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
});})(attr__$1,update_children,coll_dom,make_item_fn))
);

return coll_dom;
});

shadow.object.bind_children.cljs$lang$maxFixedArity = 6;

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__4120__auto__ = key;
if(cljs.core.truth_(and__4120__auto__)){
return path;
} else {
return and__4120__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id(oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type(oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data(oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__61523_62186 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__61524_62187 = null;
var count__61525_62188 = (0);
var i__61526_62189 = (0);
while(true){
if((i__61526_62189 < count__61525_62188)){
var vec__61542_62192 = cljs.core._nth(chunk__61524_62187,i__61526_62189);
var id_62193 = cljs.core.nth.call(null,vec__61542_62192,(0),null);
var oref_62194 = cljs.core.nth.call(null,vec__61542_62192,(1),null);
shadow.object.info.call(null,"dump",id_62193,cljs.core.pr_str.call(null,shadow.object._type(oref_62194)),cljs.core.deref.call(null,shadow.object._data(oref_62194)));


var G__62199 = seq__61523_62186;
var G__62200 = chunk__61524_62187;
var G__62201 = count__61525_62188;
var G__62202 = (i__61526_62189 + (1));
seq__61523_62186 = G__62199;
chunk__61524_62187 = G__62200;
count__61525_62188 = G__62201;
i__61526_62189 = G__62202;
continue;
} else {
var temp__5720__auto___62204 = cljs.core.seq.call(null,seq__61523_62186);
if(temp__5720__auto___62204){
var seq__61523_62205__$1 = temp__5720__auto___62204;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61523_62205__$1)){
var c__4550__auto___62206 = cljs.core.chunk_first.call(null,seq__61523_62205__$1);
var G__62207 = cljs.core.chunk_rest.call(null,seq__61523_62205__$1);
var G__62208 = c__4550__auto___62206;
var G__62209 = cljs.core.count.call(null,c__4550__auto___62206);
var G__62210 = (0);
seq__61523_62186 = G__62207;
chunk__61524_62187 = G__62208;
count__61525_62188 = G__62209;
i__61526_62189 = G__62210;
continue;
} else {
var vec__61550_62211 = cljs.core.first.call(null,seq__61523_62205__$1);
var id_62212 = cljs.core.nth.call(null,vec__61550_62211,(0),null);
var oref_62213 = cljs.core.nth.call(null,vec__61550_62211,(1),null);
shadow.object.info.call(null,"dump",id_62212,cljs.core.pr_str.call(null,shadow.object._type(oref_62213)),cljs.core.deref.call(null,shadow.object._data(oref_62213)));


var G__62217 = cljs.core.next.call(null,seq__61523_62205__$1);
var G__62218 = null;
var G__62219 = (0);
var G__62220 = (0);
seq__61523_62186 = G__62217;
chunk__61524_62187 = G__62218;
count__61525_62188 = G__62219;
i__61526_62189 = G__62220;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
