(ns com.wsscode.pathom.eql-provider
  (:require [edn-query-language.core :as eql])
  (:use [criterium.core])
  (:import (clojure.lang PersistentVector PersistentArrayMap PersistentHashMap)))

(defprotocol IProvideEQLAst
  (-eql-ast [this]))

(extend-protocol IProvideEQLAst
  PersistentVector
  (-eql-ast [this] (eql/query->ast this))

  PersistentArrayMap
  (-eql-ast [this] this)

  PersistentHashMap
  (-eql-ast [this] this))

(def sample [:foo])
(def sample2 (eql/query->ast [:foo]))

(defn ast-from [query-or-ast]
  (if (vector? query-or-ast)
    (eql/query->ast query-or-ast)
    query-or-ast))

(comment
  (-> [:foo]
      (-eql-ast)
      (-eql-ast))

  (type (hash-map :foo "bar"))
  (type {})
  (type (into {} (map (juxt identity identity)) (range 8)))

  (with-progress-reporting (bench (ast-from sample) :verbose))
  ;Evaluation count : 148959480 in 60 samples of 2482658 calls.
  ;Execution time sample mean : 392.296474 ns
  ;Execution time mean : 392.325395 ns
  ;Execution time sample std-deviation : 4.358066 ns
  ;Execution time std-deviation : 4.436980 ns
  ;Execution time lower quantile : 386.781631 ns ( 2.5%)
  ;Execution time upper quantile : 403.677564 ns (97.5%)
  ;Overhead used : 7.413436 ns

  (with-progress-reporting (bench (-eql-ast sample) :verbose))
  ;Execution time sample mean : 319.541284 ns
  ;Execution time mean : 319.566631 ns
  ;Execution time sample std-deviation : 3.802107 ns
  ;Execution time std-deviation : 3.865676 ns
  ;Execution time lower quantile : 314.989290 ns ( 2.5%)
  ;Execution time upper quantile : 328.782094 ns (97.5%)
  ;Overhead used : 7.413436 ns

  (with-progress-reporting (bench (ast-from sample2) :verbose))
  ;Evaluation count : 16998798 in 6 samples of 2833133 calls.
  ;Execution time sample mean : 29.307508 ns
  ;Execution time mean : 29.268364 ns
  ;Execution time sample std-deviation : 1.453476 ns
  ;Execution time std-deviation : 1.592277 ns
  ;Execution time lower quantile : 27.529705 ns ( 2.5%)
  ;Execution time upper quantile : 31.069611 ns (97.5%)
  ;Overhead used : 6.205109 ns

  (with-progress-reporting (bench (-eql-ast sample2) :verbose))
  ;Evaluation count : 4980661500 in 60 samples of 83011025 calls.
  ;Execution time sample mean : 3.427408 ns
  ;Execution time mean : 3.428416 ns
  ;Execution time sample std-deviation : 0.277057 ns
  ;Execution time std-deviation : 0.292912 ns
  ;Execution time lower quantile : 3.187843 ns ( 2.5%)
  ;Execution time upper quantile : 4.413889 ns (97.5%)
  ;Overhead used : 7.413436 ns

  (with-progress-reporting (quick-bench sample2 :verbose))

  (time
    (dotimes [_ 100000]
      (ast-from sample)))

  (time
    (dotimes [_ 100000]
      (ast-from sample2)))

  (time
    (dotimes [_ 100000]
      (-eql-ast sample)))

  (time
    (dotimes [_ 100000]
      (-eql-ast sample2))))
