(ns union-resolver-test
  ""
  (:require
    [clojure.test :refer :all]
    [clojure.core.async :as async :refer [go <! >! put! chan]]
    [com.wsscode.pathom.core :as p]
    [com.wsscode.pathom.connect :as pc]
    [taoensso.timbre :as log]))

(pc/defresolver input-group=>cases-union
  [_ {:nexus.input-group/keys [id] :as input}]
  {::pc/docstring "Resolve Cases by InputGroup, union query."
   ::pc/input     #{:nexus.input-group/id}
   ::pc/output    [{:nexus.input-group/cases-union [:nexus.case.image-annotation/id
                                                    :nexus.case.test-case/id]}]}
  {:nexus.input-group/cases-union [{:nexus.case.image-annotation/id 1}
                                   {:nexus.case.test-case/id 1}]})
(def debug-parser
  (p/parallel-parser
    {::p/env     {::p/reader               [p/map-reader
                                            pc/parallel-reader
                                            pc/open-ident-reader
                                            p/env-placeholder-reader]
                  ::p/placeholder-prefixes #{">"}}
     ::p/mutate  pc/mutate-async
     ::p/plugins [(pc/connect-plugin {::pc/register [input-group=>cases-union
                                                     (pc/constantly-resolver :nexus.project/historic-cases "foo")]})
                  p/error-handler-plugin
                  p/trace-plugin]}))
(def query
  [{[:nexus.input-group/id 1]
    [{:nexus.input-group/cases-union {:nexus.case.image-annotation/id [:nexus.case.image-annotation/id]
                                      :nexus.case.test-case/id        [:nexus.case.test-case/id]}}]}])

(comment
  (async/<!! (debug-parser {} query)))
