(ns demo.core
  (:require [com.wsscode.pathom.core :as p]
            [om.next :as om]))

(def items
  [{:type :character :name "Eric Cartman" :age 10}
   {:type :post :title "Post title"}])

(def root-reader
  {:items
   (fn [env]
     ; now this can be simplified
     (p/join-seq (assoc env ::p/reader p/map-reader
                            ::p/union-path :type)
                 items))})

(def parser (om/parser {:read p/pathom-read}))

(defn parse [env query]
  (parser (assoc env ::p/reader root-reader) query))

(parse {} [{:items {:character [:name :age]
                    :post      [:title :type]}}])
