goog.provide('com.wsscode.pathom3.cache');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom3.cache","cached","com.wsscode.pathom3.cache/cached",1166544733,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Keyword(null,"f","f",-1597136552)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.map_QMARK_,cljs.core.any_QMARK_,cljs.core.fn_QMARK_], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));


/**
 * Try to read some value from a cache, otherwise run and cache it.
 * 
 *   cache-container is a keyword for the cache container name, consider that the environment
 *   has multiple cache atoms. If the cache-container key is not present in the env, the
 *   cache will be ignored and will always run f.
 * 
 *   cache-key is how you decide, in that cache container, what key should be used for
 *   this cache try.
 * 
 *   f needs to a function of zero arguments.
 * 
 *   Example:
 * 
 *    (cached ::my-cache {::my-cache (atom {})} [3 :foo]
 *      (fn [] (run-expensive-operation)))
 * @type {function(!cljs.core.Keyword, !cljs.core.IMap, *, !Function): *}
 */
com.wsscode.pathom3.cache.cached = (function com$wsscode$pathom3$cache$cached(cache_container,env,cache_key,f){
var map__43528 = cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Keyword(null,"f","f",-1597136552)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.core.map_QMARK_,cljs.core.any_QMARK_,cljs.core.fn_QMARK_], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"cache-container","cache-container",-1291615136),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null);
var map__43528__$1 = (((((!((map__43528 == null))))?(((((map__43528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43528.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43528):map__43528);
var retspec43517 = cljs.core.get.call(null,map__43528__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var argspec43516 = cljs.core.get.call(null,map__43528__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_(argspec43516)){
com.fulcrologic.guardrails.core.run_check.call(null,true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/cache.cljc:5 cached's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),argspec43516,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cache_container,env,cache_key,f], null));
} else {
}

var f43519 = (function (cache_container__$1,env__$1,cache_key__$1,f__$1){
var temp__5718__auto__ = cljs.core.get.call(null,env__$1,cache_container__$1);
if(cljs.core.truth_(temp__5718__auto__)){
var cache_STAR_ = temp__5718__auto__;
var temp__5718__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,cache_STAR_),cache_key__$1);
if(cljs.core.truth_(temp__5718__auto____$1)){
var cached_value = temp__5718__auto____$1;
return cached_value;
} else {
var res = f__$1.call(null);
cljs.core.swap_BANG_.call(null,cache_STAR_,cljs.core.assoc,cache_key__$1,res);

return res;
}
} else {
return f__$1.call(null);
}
});
var ret43518 = f43519(cache_container,env,cache_key,f);
if(cljs.core.truth_(retspec43517)){
com.fulcrologic.guardrails.core.run_check.call(null,false,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/cache.cljc:5 cached's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),retspec43517,ret43518);
} else {
}

return ret43518;
});

//# sourceMappingURL=com.wsscode.pathom3.cache.js.map
