goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.call(null,(function (p__46153){
var vec__46155 = p__46153;
var ns = cljs.core.nth.call(null,vec__46155,(0),null);
var vars__$1 = cljs.core.nth.call(null,vec__46155,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block.call(null,(function (){var env = cljs.test.get_current_env.call(null);
var once_fixtures = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__46162 = cljs.test.execution_strategy.call(null,once_fixtures,each_fixtures);
var G__46162__$1 = (((G__46162 instanceof cljs.core.Keyword))?G__46162.fqn:null);
switch (G__46162__$1) {
case "async":
return cljs.test.wrap_map_fixtures.call(null,once_fixtures,cljs.core.mapcat.call(null,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.filter.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures.call(null,each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.join_fixtures.call(null,once_fixtures).call(null,(function (){
var seq__46165 = cljs.core.seq.call(null,vars__$1);
var chunk__46166 = null;
var count__46167 = (0);
var i__46168 = (0);
while(true){
if((i__46168 < count__46167)){
var v = cljs.core._nth(chunk__46166,i__46168);
var temp__5720__auto___46466 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
if(cljs.core.truth_(temp__5720__auto___46466)){
var t_46467 = temp__5720__auto___46466;
each_fixture_fn.call(null,((function (seq__46165,chunk__46166,count__46167,i__46168,t_46467,temp__5720__auto___46466,v,each_fixture_fn,G__46162,G__46162__$1,env,once_fixtures,each_fixtures,vec__46155,ns,vars__$1){
return (function (){
return cljs.test.run_block.call(null,cljs.test.test_var_block_STAR_.call(null,v,cljs.test.disable_async.call(null,t_46467)));
});})(seq__46165,chunk__46166,count__46167,i__46168,t_46467,temp__5720__auto___46466,v,each_fixture_fn,G__46162,G__46162__$1,env,once_fixtures,each_fixtures,vec__46155,ns,vars__$1))
);
} else {
}


var G__46470 = seq__46165;
var G__46471 = chunk__46166;
var G__46472 = count__46167;
var G__46473 = (i__46168 + (1));
seq__46165 = G__46470;
chunk__46166 = G__46471;
count__46167 = G__46472;
i__46168 = G__46473;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46165);
if(temp__5720__auto__){
var seq__46165__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46165__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46165__$1);
var G__46481 = cljs.core.chunk_rest.call(null,seq__46165__$1);
var G__46482 = c__4556__auto__;
var G__46483 = cljs.core.count.call(null,c__4556__auto__);
var G__46484 = (0);
seq__46165 = G__46481;
chunk__46166 = G__46482;
count__46167 = G__46483;
i__46168 = G__46484;
continue;
} else {
var v = cljs.core.first.call(null,seq__46165__$1);
var temp__5720__auto___46486__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
if(cljs.core.truth_(temp__5720__auto___46486__$1)){
var t_46487 = temp__5720__auto___46486__$1;
each_fixture_fn.call(null,((function (seq__46165,chunk__46166,count__46167,i__46168,t_46487,temp__5720__auto___46486__$1,v,seq__46165__$1,temp__5720__auto__,each_fixture_fn,G__46162,G__46162__$1,env,once_fixtures,each_fixtures,vec__46155,ns,vars__$1){
return (function (){
return cljs.test.run_block.call(null,cljs.test.test_var_block_STAR_.call(null,v,cljs.test.disable_async.call(null,t_46487)));
});})(seq__46165,chunk__46166,count__46167,i__46168,t_46487,temp__5720__auto___46486__$1,v,seq__46165__$1,temp__5720__auto__,each_fixture_fn,G__46162,G__46162__$1,env,once_fixtures,each_fixtures,vec__46155,ns,vars__$1))
);
} else {
}


var G__46493 = cljs.core.next.call(null,seq__46165__$1);
var G__46494 = null;
var G__46495 = (0);
var G__46496 = (0);
seq__46165 = G__46493;
chunk__46166 = G__46494;
count__46167 = G__46495;
i__46168 = G__46496;
continue;
}
} else {
return null;
}
}
break;
}
}));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46162__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,(function (p1__46151_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46151_SHARP_));
}),vars)));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__46208 = shadow.test.env.get_test_ns_info.call(null,ns);
var map__46208__$1 = (((((!((map__46208 == null))))?(((((map__46208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46208.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46208):map__46208);
var test_ns = map__46208__$1;
var vars = cljs.core.get.call(null,map__46208__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.call(null,["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join(''));
})], null);
} else {
return shadow.test.test_vars_grouped_block.call(null,vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__46222,vars){
var map__46223 = p__46222;
var map__46223__$1 = (((((!((map__46223 == null))))?(((((map__46223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46223):map__46223);
var env = map__46223__$1;
var report_fn = cljs.core.get.call(null,map__46223__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__46231_46514 = cljs.core.seq.call(null,shadow.test.env.get_tests.call(null));
var chunk__46233_46515 = null;
var count__46234_46516 = (0);
var i__46235_46517 = (0);
while(true){
if((i__46235_46517 < count__46234_46516)){
var vec__46277_46518 = cljs.core._nth(chunk__46233_46515,i__46235_46517);
var test_ns_46519 = cljs.core.nth.call(null,vec__46277_46518,(0),null);
var ns_info_46520 = cljs.core.nth.call(null,vec__46277_46518,(1),null);
var map__46282_46523 = ns_info_46520;
var map__46282_46524__$1 = (((((!((map__46282_46523 == null))))?(((((map__46282_46523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46282_46523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46282_46523):map__46282_46523);
var fixtures_46525 = cljs.core.get.call(null,map__46282_46524__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5720__auto___46527 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_46525);
if(cljs.core.truth_(temp__5720__auto___46527)){
var fix_46530 = temp__5720__auto___46527;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,test_ns_46519,fix_46530);
} else {
}

var temp__5720__auto___46531 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_46525);
if(cljs.core.truth_(temp__5720__auto___46531)){
var fix_46532 = temp__5720__auto___46531;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,test_ns_46519,fix_46532);
} else {
}


var G__46535 = seq__46231_46514;
var G__46536 = chunk__46233_46515;
var G__46537 = count__46234_46516;
var G__46538 = (i__46235_46517 + (1));
seq__46231_46514 = G__46535;
chunk__46233_46515 = G__46536;
count__46234_46516 = G__46537;
i__46235_46517 = G__46538;
continue;
} else {
var temp__5720__auto___46541 = cljs.core.seq.call(null,seq__46231_46514);
if(temp__5720__auto___46541){
var seq__46231_46542__$1 = temp__5720__auto___46541;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46231_46542__$1)){
var c__4556__auto___46544 = cljs.core.chunk_first.call(null,seq__46231_46542__$1);
var G__46545 = cljs.core.chunk_rest.call(null,seq__46231_46542__$1);
var G__46546 = c__4556__auto___46544;
var G__46547 = cljs.core.count.call(null,c__4556__auto___46544);
var G__46548 = (0);
seq__46231_46514 = G__46545;
chunk__46233_46515 = G__46546;
count__46234_46516 = G__46547;
i__46235_46517 = G__46548;
continue;
} else {
var vec__46294_46549 = cljs.core.first.call(null,seq__46231_46542__$1);
var test_ns_46550 = cljs.core.nth.call(null,vec__46294_46549,(0),null);
var ns_info_46551 = cljs.core.nth.call(null,vec__46294_46549,(1),null);
var map__46298_46552 = ns_info_46551;
var map__46298_46553__$1 = (((((!((map__46298_46552 == null))))?(((((map__46298_46552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46298_46552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46298_46552):map__46298_46552);
var fixtures_46554 = cljs.core.get.call(null,map__46298_46553__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5720__auto___46558__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_46554);
if(cljs.core.truth_(temp__5720__auto___46558__$1)){
var fix_46562 = temp__5720__auto___46558__$1;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,test_ns_46550,fix_46562);
} else {
}

var temp__5720__auto___46565__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_46554);
if(cljs.core.truth_(temp__5720__auto___46565__$1)){
var fix_46566 = temp__5720__auto___46565__$1;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,test_ns_46550,fix_46566);
} else {
}


var G__46570 = cljs.core.next.call(null,seq__46231_46542__$1);
var G__46571 = null;
var G__46572 = (0);
var G__46573 = (0);
seq__46231_46514 = G__46570;
chunk__46233_46515 = G__46571;
count__46234_46516 = G__46572;
i__46235_46517 = G__46573;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count.call(null,vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.map.call(null,(function (p1__46220_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46220_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_.call(null,block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.call(null,block,(function (){
var map__46328 = cljs.test.get_current_env.call(null);
var map__46328__$1 = (((((!((map__46328 == null))))?(((((map__46328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46328):map__46328);
var env = map__46328__$1;
var report_fn = cljs.core.get.call(null,map__46328__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.call(null,map__46328__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.call(null,report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.call(null,report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__46349 = arguments.length;
switch (G__46349) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.call(null,cljs.test.empty_env.call(null),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__46379 = arguments.length;
switch (G__46379) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.call(null,cljs.test.empty_env.call(null),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__46399 = shadow.test.env.get_test_ns_info.call(null,ns);
var map__46399__$1 = (((((!((map__46399 == null))))?(((((map__46399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46399):map__46399);
var vars = cljs.core.get.call(null,map__46399__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__46414 = arguments.length;
switch (G__46414) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.call(null,cljs.test.empty_env.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.call(null,env,shadow.test.env.get_test_namespaces.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_.call(null,namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.call(null,(function (p1__46409_SHARP_){
return cljs.core.contains_QMARK_.call(null,namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46409_SHARP_)));
}),shadow.test.env.get_test_vars.call(null));
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__46437 = arguments.length;
switch (G__46437) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.call(null,cljs.test.empty_env.call(null),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.call(null,env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.call(null,env,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,(function (p1__46433_SHARP_){
var or__4126__auto__ = (re == null);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return cljs.core.re_matches.call(null,re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__46433_SHARP_));
}
}),shadow.test.env.get_test_namespaces.call(null))));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
