goog.provide('shadow.object');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

var shadow$object$IObject$_id$dyn_48036 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.object._id[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.object._id["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
});
shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
return shadow$object$IObject$_id$dyn_48036(this$);
}
});

var shadow$object$IObject$_type$dyn_48037 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.object._type[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.object._type["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
});
shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
return shadow$object$IObject$_type$dyn_48037(this$);
}
});

var shadow$object$IObject$_data$dyn_48038 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.object._data[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.object._data["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
});
shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
return shadow$object$IObject$_data$dyn_48038(this$);
}
});

var shadow$object$IObject$_update$dyn_48039 = (function (this$,update_fn){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.object._update[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,update_fn);
} else {
var m__4426__auto__ = (shadow.object._update["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
});
/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
return shadow$object$IObject$_update$dyn_48039(this$,update_fn);
}
});

var shadow$object$IObject$_destroy_BANG_$dyn_48041 = (function (this$,cause){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,cause);
} else {
var m__4426__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
});
shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
return shadow$object$IObject$_destroy_BANG_$dyn_48041(this$,cause);
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type(this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__47097 = arguments.length;
switch (G__47097) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type(oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
}));

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type(oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
}));

(shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3);

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__4126__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id(obj),shadow.object._id(obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id(obj),(function (){var temp__5720__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5720__auto__)){
var oid = temp__5720__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id(oref));
if(cljs.core.truth_(temp__5720__auto__)){
var parent_id = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type(parent),parent_type)){
return parent;
} else {
var G__48063 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__48063;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id(parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,(function (p1__47149_SHARP_){
return cljs.core.get.call(null,instances,p1__47149_SHARP_);
}),child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__47164 = arguments.length;
switch (G__47164) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
}));

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
}));

(shadow.object.tree_seq.cljs$lang$maxFixedArity = 2);

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type(type));
return cljs.core.filter.call(null,(function (p1__47170_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type(p1__47170_SHARP_));
}),shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__47176){
var map__47177 = p__47176;
var map__47177__$1 = (((((!((map__47177 == null))))?(((((map__47177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47177.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47177):map__47177);
var oref = map__47177__$1;
var parent = cljs.core.get.call(null,map__47177__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__47183 = arguments.length;
switch (G__47183) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
}));

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type(type));
return cljs.core.filter.call(null,(function (p1__47181_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type(p1__47181_SHARP_));
}),shadow.object.get_siblings.call(null,oref));
}));

(shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2);

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5718__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5718__auto__)){
var obj = temp__5718__auto__;
return obj;
} else {
var temp__5720__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5720__auto__)){
var parent = temp__5720__auto__;
var G__48075 = parent;
dom = G__48075;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48076 = arguments.length;
var i__4737__auto___48077 = (0);
while(true){
if((i__4737__auto___48077 < len__4736__auto___48076)){
args__4742__auto__.push((arguments[i__4737__auto___48077]));

var G__48078 = (i__4737__auto___48077 + (1));
i__4737__auto___48077 = G__48078;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5720__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5720__auto__)){
var reactions_to_trigger = temp__5720__auto__;
var seq__47203 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__47204 = null;
var count__47205 = (0);
var i__47206 = (0);
while(true){
if((i__47206 < count__47205)){
var rfn = cljs.core._nth(chunk__47204,i__47206);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__48080 = seq__47203;
var G__48081 = chunk__47204;
var G__48082 = count__47205;
var G__48083 = (i__47206 + (1));
seq__47203 = G__48080;
chunk__47204 = G__48081;
count__47205 = G__48082;
i__47206 = G__48083;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__47203);
if(temp__5720__auto____$1){
var seq__47203__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47203__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__47203__$1);
var G__48084 = cljs.core.chunk_rest.call(null,seq__47203__$1);
var G__48085 = c__4556__auto__;
var G__48086 = cljs.core.count.call(null,c__4556__auto__);
var G__48087 = (0);
seq__47203 = G__48084;
chunk__47204 = G__48085;
count__47205 = G__48086;
i__47206 = G__48087;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__47203__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__48088 = cljs.core.next.call(null,seq__47203__$1);
var G__48089 = null;
var G__48090 = (0);
var G__48091 = (0);
seq__47203 = G__48088;
chunk__47204 = G__48089;
count__47205 = G__48090;
i__47206 = G__48091;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));

(shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq47193){
var G__47194 = cljs.core.first.call(null,seq47193);
var seq47193__$1 = cljs.core.next.call(null,seq47193);
var G__47195 = cljs.core.first.call(null,seq47193__$1);
var seq47193__$2 = cljs.core.next.call(null,seq47193__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47194,G__47195,seq47193__$2);
}));

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__47262_48093 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__47263_48094 = null;
var count__47264_48095 = (0);
var i__47265_48096 = (0);
while(true){
if((i__47265_48096 < count__47264_48095)){
var child_48097 = cljs.core._nth(chunk__47263_48094,i__47265_48096);
shadow.object.do_notify_tree.call(null,child_48097,ev,notify_fn);


var G__48098 = seq__47262_48093;
var G__48099 = chunk__47263_48094;
var G__48100 = count__47264_48095;
var G__48101 = (i__47265_48096 + (1));
seq__47262_48093 = G__48098;
chunk__47263_48094 = G__48099;
count__47264_48095 = G__48100;
i__47265_48096 = G__48101;
continue;
} else {
var temp__5720__auto___48103 = cljs.core.seq.call(null,seq__47262_48093);
if(temp__5720__auto___48103){
var seq__47262_48104__$1 = temp__5720__auto___48103;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47262_48104__$1)){
var c__4556__auto___48105 = cljs.core.chunk_first.call(null,seq__47262_48104__$1);
var G__48106 = cljs.core.chunk_rest.call(null,seq__47262_48104__$1);
var G__48107 = c__4556__auto___48105;
var G__48108 = cljs.core.count.call(null,c__4556__auto___48105);
var G__48109 = (0);
seq__47262_48093 = G__48106;
chunk__47263_48094 = G__48107;
count__47264_48095 = G__48108;
i__47265_48096 = G__48109;
continue;
} else {
var child_48111 = cljs.core.first.call(null,seq__47262_48104__$1);
shadow.object.do_notify_tree.call(null,child_48111,ev,notify_fn);


var G__48112 = cljs.core.next.call(null,seq__47262_48104__$1);
var G__48113 = null;
var G__48114 = (0);
var G__48115 = (0);
seq__47262_48093 = G__48112;
chunk__47263_48094 = G__48113;
count__47264_48095 = G__48114;
i__47265_48096 = G__48115;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48117 = arguments.length;
var i__4737__auto___48118 = (0);
while(true){
if((i__4737__auto___48118 < len__4736__auto___48117)){
args__4742__auto__.push((arguments[i__4737__auto___48118]));

var G__48119 = (i__4737__auto___48118 + (1));
i__4737__auto___48118 = G__48119;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
}));

(shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq47304){
var G__47305 = cljs.core.first.call(null,seq47304);
var seq47304__$1 = cljs.core.next.call(null,seq47304);
var G__47306 = cljs.core.first.call(null,seq47304__$1);
var seq47304__$2 = cljs.core.next.call(null,seq47304__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47305,G__47306,seq47304__$2);
}));

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48126 = arguments.length;
var i__4737__auto___48127 = (0);
while(true){
if((i__4737__auto___48127 < len__4736__auto___48126)){
args__4742__auto__.push((arguments[i__4737__auto___48127]));

var G__48129 = (i__4737__auto___48127 + (1));
i__4737__auto___48127 = G__48129;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__48130 = shadow.object.get_parent.call(null,current);
current = G__48130;
continue;
} else {
return null;
}
break;
}
}));

(shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq47326){
var G__47327 = cljs.core.first.call(null,seq47326);
var seq47326__$1 = cljs.core.next.call(null,seq47326);
var G__47329 = cljs.core.first.call(null,seq47326__$1);
var seq47326__$2 = cljs.core.next.call(null,seq47326__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47327,G__47329,seq47326__$2);
}));

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48136 = arguments.length;
var i__4737__auto___48137 = (0);
while(true){
if((i__4737__auto___48137 < len__4736__auto___48136)){
args__4742__auto__.push((arguments[i__4737__auto___48137]));

var G__48138 = (i__4737__auto___48137 + (1));
i__4737__auto___48137 = G__48138;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id(oref);
var data = shadow.object._data(oref);
var work_fn = (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});
return shadow.object._update(oref,work_fn);
}));

(shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq47339){
var G__47340 = cljs.core.first.call(null,seq47339);
var seq47339__$1 = cljs.core.next.call(null,seq47339);
var G__47341 = cljs.core.first.call(null,seq47339__$1);
var seq47339__$2 = cljs.core.next.call(null,seq47339__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47340,G__47341,seq47339__$2);
}));

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id(child);
var parent_id = shadow.object._id(parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,(function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
}));

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5718__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5718__auto__)){
var custom_remove = temp__5718__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__47421 = arguments.length;
switch (G__47421) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
}));

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_(oref,cause);
}));

(shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2);

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type(oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__47440 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__47441 = null;
var count__47442 = (0);
var i__47443 = (0);
while(true){
if((i__47443 < count__47442)){
var vec__47489 = cljs.core._nth(chunk__47441,i__47443);
var ev = cljs.core.nth.call(null,vec__47489,(0),null);
var handler = cljs.core.nth.call(null,vec__47489,(1),null);
var ev_def = vec__47489;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_48155__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47440,chunk__47441,count__47442,i__47443,vec__47489,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47440,chunk__47441,count__47442,i__47443,vec__47489,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47440,chunk__47441,count__47442,i__47443,handler_48155__$1,vec__47489,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_48155__$1.call(null,oref,e,el);
});})(seq__47440,chunk__47441,count__47442,i__47443,handler_48155__$1,vec__47489,ev,handler,ev_def))
);


var G__48157 = seq__47440;
var G__48158 = chunk__47441;
var G__48159 = count__47442;
var G__48160 = (i__47443 + (1));
seq__47440 = G__48157;
chunk__47441 = G__48158;
count__47442 = G__48159;
i__47443 = G__48160;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47440);
if(temp__5720__auto__){
var seq__47440__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47440__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__47440__$1);
var G__48164 = cljs.core.chunk_rest.call(null,seq__47440__$1);
var G__48165 = c__4556__auto__;
var G__48166 = cljs.core.count.call(null,c__4556__auto__);
var G__48167 = (0);
seq__47440 = G__48164;
chunk__47441 = G__48165;
count__47442 = G__48166;
i__47443 = G__48167;
continue;
} else {
var vec__47503 = cljs.core.first.call(null,seq__47440__$1);
var ev = cljs.core.nth.call(null,vec__47503,(0),null);
var handler = cljs.core.nth.call(null,vec__47503,(1),null);
var ev_def = vec__47503;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_48170__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47440,chunk__47441,count__47442,i__47443,vec__47503,ev,handler,ev_def,seq__47440__$1,temp__5720__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47440,chunk__47441,count__47442,i__47443,vec__47503,ev,handler,ev_def,seq__47440__$1,temp__5720__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47440,chunk__47441,count__47442,i__47443,handler_48170__$1,vec__47503,ev,handler,ev_def,seq__47440__$1,temp__5720__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_48170__$1.call(null,oref,e,el);
});})(seq__47440,chunk__47441,count__47442,i__47443,handler_48170__$1,vec__47503,ev,handler,ev_def,seq__47440__$1,temp__5720__auto__))
);


var G__48179 = cljs.core.next.call(null,seq__47440__$1);
var G__48180 = null;
var G__48181 = (0);
var G__48182 = (0);
seq__47440 = G__48179;
chunk__47441 = G__48180;
count__47442 = G__48181;
i__47443 = G__48182;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__47524){
var vec__47526 = p__47524;
var event = cljs.core.nth.call(null,vec__47526,(0),null);
var handler = cljs.core.nth.call(null,vec__47526,(1),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = event;
if(cljs.core.truth_(and__4115__auto__)){
return handler;
} else {
return and__4115__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48201 = arguments.length;
var i__4737__auto___48202 = (0);
while(true){
if((i__4737__auto___48202 < len__4736__auto___48201)){
args__4742__auto__.push((arguments[i__4737__auto___48202]));

var G__48203 = (i__4737__auto___48202 + (1));
i__4737__auto___48202 = G__48203;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e47569){if((e47569 instanceof Object)){
var e = e47569;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e47569;

}
}}));

(shadow.object.define.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.object.define.cljs$lang$applyTo = (function (seq47547){
var G__47548 = cljs.core.first.call(null,seq47547);
var seq47547__$1 = cljs.core.next.call(null,seq47547);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47548,seq47547__$1);
}));

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__47589 = arguments.length;
switch (G__47589) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
}));

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
}));

(shadow.object.make_dom.cljs$lang$maxFixedArity = 4);

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id(obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k47603,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47612 = k47603;
var G__47612__$1 = (((G__47612 instanceof cljs.core.Keyword))?G__47612.fqn:null);
switch (G__47612__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47603,else__4383__auto__);

}
}));

(shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__47617){
var vec__47618 = p__47617;
var k__4403__auto__ = cljs.core.nth.call(null,vec__47618,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__47618,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#shadow.object.Watch{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47602){
var self__ = this;
var G__47602__$1 = this;
return (new cljs.core.RecordIter((0),G__47602__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47604,other47605){
var self__ = this;
var this47604__$1 = this;
return (((!((other47605 == null)))) && ((this47604__$1.constructor === other47605.constructor)) && (cljs.core._EQ_.call(null,this47604__$1.key,other47605.key)) && (cljs.core._EQ_.call(null,this47604__$1.handler,other47605.handler)) && (cljs.core._EQ_.call(null,this47604__$1.__extmap,other47605.__extmap)));
}));

(shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__47602){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47670 = cljs.core.keyword_identical_QMARK_;
var expr__47671 = k__4388__auto__;
if(cljs.core.truth_(pred__47670.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__47671))){
return (new shadow.object.Watch(G__47602,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47670.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__47671))){
return (new shadow.object.Watch(self__.key,G__47602,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__47602),null));
}
}
}));

(shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__47602){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__47602,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
}));

(shadow.object.Watch.cljs$lang$type = true);

(shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
}));

(shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.object/Watch");
}));

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__47609){
var extmap__4419__auto__ = (function (){var G__47711 = cljs.core.dissoc.call(null,G__47609,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__47609)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47711);
} else {
return G__47711;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__47609),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__47609),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.result_chan,handler);
}));

(shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write(writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id(this$__$1),shadow.object._id(other))));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null))));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.remove.call(null,(function (p1__47739_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__47739_SHARP_));
}),self__.watches));
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
(self__.data = new$);

var seq__47826 = cljs.core.seq.call(null,self__.watches);
var chunk__47827 = null;
var count__47828 = (0);
var i__47829 = (0);
while(true){
if((i__47829 < count__47828)){
var map__47847 = cljs.core._nth(chunk__47827,i__47829);
var map__47847__$1 = (((((!((map__47847 == null))))?(((((map__47847.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47847.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47847):map__47847);
var watch = map__47847__$1;
var key = cljs.core.get.call(null,map__47847__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47847__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48310 = seq__47826;
var G__48311 = chunk__47827;
var G__48312 = count__47828;
var G__48313 = (i__47829 + (1));
seq__47826 = G__48310;
chunk__47827 = G__48311;
count__47828 = G__48312;
i__47829 = G__48313;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47826);
if(temp__5720__auto__){
var seq__47826__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47826__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__47826__$1);
var G__48314 = cljs.core.chunk_rest.call(null,seq__47826__$1);
var G__48315 = c__4556__auto__;
var G__48316 = cljs.core.count.call(null,c__4556__auto__);
var G__48317 = (0);
seq__47826 = G__48314;
chunk__47827 = G__48315;
count__47828 = G__48316;
i__47829 = G__48317;
continue;
} else {
var map__47869 = cljs.core.first.call(null,seq__47826__$1);
var map__47869__$1 = (((((!((map__47869 == null))))?(((((map__47869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47869.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47869):map__47869);
var watch = map__47869__$1;
var key = cljs.core.get.call(null,map__47869__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47869__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48320 = cljs.core.next.call(null,seq__47826__$1);
var G__48321 = null;
var G__48322 = (0);
var G__48323 = (0);
seq__47826 = G__48320;
chunk__47827 = G__48321;
count__47828 = G__48322;
i__47829 = G__48323;
continue;
}
} else {
return null;
}
}
break;
}
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__47875_48325 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__47876_48326 = null;
var count__47877_48327 = (0);
var i__47878_48328 = (0);
while(true){
if((i__47878_48328 < count__47877_48327)){
var child_48329 = cljs.core._nth(chunk__47876_48326,i__47878_48328);
shadow.object._destroy_BANG_(child_48329,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48330 = seq__47875_48325;
var G__48331 = chunk__47876_48326;
var G__48332 = count__47877_48327;
var G__48333 = (i__47878_48328 + (1));
seq__47875_48325 = G__48330;
chunk__47876_48326 = G__48331;
count__47877_48327 = G__48332;
i__47878_48328 = G__48333;
continue;
} else {
var temp__5720__auto___48335 = cljs.core.seq.call(null,seq__47875_48325);
if(temp__5720__auto___48335){
var seq__47875_48336__$1 = temp__5720__auto___48335;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47875_48336__$1)){
var c__4556__auto___48337 = cljs.core.chunk_first.call(null,seq__47875_48336__$1);
var G__48338 = cljs.core.chunk_rest.call(null,seq__47875_48336__$1);
var G__48339 = c__4556__auto___48337;
var G__48340 = cljs.core.count.call(null,c__4556__auto___48337);
var G__48341 = (0);
seq__47875_48325 = G__48338;
chunk__47876_48326 = G__48339;
count__47877_48327 = G__48340;
i__47878_48328 = G__48341;
continue;
} else {
var child_48342 = cljs.core.first.call(null,seq__47875_48336__$1);
shadow.object._destroy_BANG_(child_48342,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48343 = cljs.core.next.call(null,seq__47875_48336__$1);
var G__48344 = null;
var G__48345 = (0);
var G__48346 = (0);
seq__47875_48325 = G__48343;
chunk__47876_48326 = G__48344;
count__47877_48327 = G__48345;
i__47878_48328 = G__48346;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_48350 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_48350 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_48350);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
}));

(shadow.object.ObjectRef.cljs$lang$type = true);

(shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef");

(shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.object/ObjectRef");
}));

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__47901 = arguments.length;
switch (G__47901) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
}));

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
}));

(shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3);

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__47907 = arguments.length;
switch (G__47907) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
}));

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,(function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
}));
}));

(shadow.object.bind_change.cljs$lang$maxFixedArity = 4);

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48387 = arguments.length;
var i__4737__auto___48388 = (0);
while(true){
if((i__4737__auto___48388 < len__4736__auto___48387)){
args__4742__auto__.push((arguments[i__4737__auto___48388]));

var G__48389 = (i__4737__auto___48388 + (1));
i__4737__auto___48388 = G__48389;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_48402 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5718__auto___48403 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5718__auto___48403)){
var dom_48404 = temp__5718__auto___48403;
shadow.dom.set_data.call(null,dom_48404,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_48404,dom_events_48402);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48404);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48404);
} else {
var temp__5720__auto___48406 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___48406)){
var dom_fn_48407 = temp__5720__auto___48406;
var dom_48408 = shadow.dom.build.call(null,dom_fn_48407.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_48408,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48408);

shadow.object.bind_dom_events.call(null,oref,dom_48408,dom_events_48402);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48408);
} else {
}
}

var temp__5720__auto___48410 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___48410)){
var watches_48412 = temp__5720__auto___48410;
var seq__47935_48413 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_48412));
var chunk__47936_48414 = null;
var count__47937_48415 = (0);
var i__47938_48416 = (0);
while(true){
if((i__47938_48416 < count__47937_48415)){
var vec__47949_48418 = cljs.core._nth(chunk__47936_48414,i__47938_48416);
var attr_48419 = cljs.core.nth.call(null,vec__47949_48418,(0),null);
var handler_48420 = cljs.core.nth.call(null,vec__47949_48418,(1),null);
shadow.object.bind_change.call(null,oref,attr_48419,((function (seq__47935_48413,chunk__47936_48414,count__47937_48415,i__47938_48416,vec__47949_48418,attr_48419,handler_48420,watches_48412,temp__5720__auto___48410,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48420.call(null,oref,old,new$);
});})(seq__47935_48413,chunk__47936_48414,count__47937_48415,i__47938_48416,vec__47949_48418,attr_48419,handler_48420,watches_48412,temp__5720__auto___48410,oid,parent,result_chan,odef,obj,oref))
);


var G__48423 = seq__47935_48413;
var G__48424 = chunk__47936_48414;
var G__48425 = count__47937_48415;
var G__48426 = (i__47938_48416 + (1));
seq__47935_48413 = G__48423;
chunk__47936_48414 = G__48424;
count__47937_48415 = G__48425;
i__47938_48416 = G__48426;
continue;
} else {
var temp__5720__auto___48429__$1 = cljs.core.seq.call(null,seq__47935_48413);
if(temp__5720__auto___48429__$1){
var seq__47935_48430__$1 = temp__5720__auto___48429__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47935_48430__$1)){
var c__4556__auto___48432 = cljs.core.chunk_first.call(null,seq__47935_48430__$1);
var G__48433 = cljs.core.chunk_rest.call(null,seq__47935_48430__$1);
var G__48434 = c__4556__auto___48432;
var G__48435 = cljs.core.count.call(null,c__4556__auto___48432);
var G__48436 = (0);
seq__47935_48413 = G__48433;
chunk__47936_48414 = G__48434;
count__47937_48415 = G__48435;
i__47938_48416 = G__48436;
continue;
} else {
var vec__47952_48437 = cljs.core.first.call(null,seq__47935_48430__$1);
var attr_48438 = cljs.core.nth.call(null,vec__47952_48437,(0),null);
var handler_48439 = cljs.core.nth.call(null,vec__47952_48437,(1),null);
shadow.object.bind_change.call(null,oref,attr_48438,((function (seq__47935_48413,chunk__47936_48414,count__47937_48415,i__47938_48416,vec__47952_48437,attr_48438,handler_48439,seq__47935_48430__$1,temp__5720__auto___48429__$1,watches_48412,temp__5720__auto___48410,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48439.call(null,oref,old,new$);
});})(seq__47935_48413,chunk__47936_48414,count__47937_48415,i__47938_48416,vec__47952_48437,attr_48438,handler_48439,seq__47935_48430__$1,temp__5720__auto___48429__$1,watches_48412,temp__5720__auto___48410,oid,parent,result_chan,odef,obj,oref))
);


var G__48445 = cljs.core.next.call(null,seq__47935_48430__$1);
var G__48446 = null;
var G__48447 = (0);
var G__48448 = (0);
seq__47935_48413 = G__48445;
chunk__47936_48414 = G__48446;
count__47937_48415 = G__48447;
i__47938_48416 = G__48448;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
}));

(shadow.object.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.create.cljs$lang$applyTo = (function (seq47911){
var G__47912 = cljs.core.first.call(null,seq47911);
var seq47911__$1 = cljs.core.next.call(null,seq47911);
var G__47913 = cljs.core.first.call(null,seq47911__$1);
var seq47911__$2 = cljs.core.next.call(null,seq47911__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47912,G__47913,seq47911__$2);
}));

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__47958 = arguments.length;
switch (G__47958) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
}));

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = (function (p1__47956_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__47956_SHARP_));
});
var node = cljs.core.atom.call(null,node_get(cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_node = node_get(new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
}));

return cljs.core.deref.call(null,node);
}));

(shadow.object.bind_simple.cljs$lang$maxFixedArity = 3);

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});
var child = cljs.core.atom.call(null,make_child_fn(curval));
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_child = make_child_fn(new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}));

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__47973_48459 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__47974_48460 = null;
var count__47975_48461 = (0);
var i__47976_48462 = (0);
while(true){
if((i__47976_48462 < count__47975_48461)){
var obj_48466 = cljs.core._nth(chunk__47974_48460,i__47976_48462);
var obj_48467__$1 = shadow.object.get_from_dom.call(null,obj_48466);
shadow.object.destroy_BANG_.call(null,obj_48467__$1);


var G__48468 = seq__47973_48459;
var G__48469 = chunk__47974_48460;
var G__48470 = count__47975_48461;
var G__48471 = (i__47976_48462 + (1));
seq__47973_48459 = G__48468;
chunk__47974_48460 = G__48469;
count__47975_48461 = G__48470;
i__47976_48462 = G__48471;
continue;
} else {
var temp__5720__auto___48472 = cljs.core.seq.call(null,seq__47973_48459);
if(temp__5720__auto___48472){
var seq__47973_48473__$1 = temp__5720__auto___48472;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47973_48473__$1)){
var c__4556__auto___48475 = cljs.core.chunk_first.call(null,seq__47973_48473__$1);
var G__48477 = cljs.core.chunk_rest.call(null,seq__47973_48473__$1);
var G__48478 = c__4556__auto___48475;
var G__48479 = cljs.core.count.call(null,c__4556__auto___48475);
var G__48480 = (0);
seq__47973_48459 = G__48477;
chunk__47974_48460 = G__48478;
count__47975_48461 = G__48479;
i__47976_48462 = G__48480;
continue;
} else {
var obj_48482 = cljs.core.first.call(null,seq__47973_48473__$1);
var obj_48483__$1 = shadow.object.get_from_dom.call(null,obj_48482);
shadow.object.destroy_BANG_.call(null,obj_48483__$1);


var G__48487 = cljs.core.next.call(null,seq__47973_48473__$1);
var G__48488 = null;
var G__48489 = (0);
var G__48490 = (0);
seq__47973_48459 = G__48487;
chunk__47974_48460 = G__48488;
count__47975_48461 = G__48489;
i__47976_48462 = G__48490;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__47982 = arguments.length;
switch (G__47982) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__47980_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__47980_SHARP_);
}));
}));

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = (function (p__47987){
var vec__47988 = p__47987;
var key = cljs.core.nth.call(null,vec__47988,(0),null);
var val = cljs.core.nth.call(null,vec__47988,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,(function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
}));

return obj;
});
var seq__47995_48495 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__47996_48496 = null;
var count__47997_48497 = (0);
var i__47998_48498 = (0);
while(true){
if((i__47998_48498 < count__47997_48497)){
var item_48502 = cljs.core._nth(chunk__47996_48496,i__47998_48498);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_48502));


var G__48503 = seq__47995_48495;
var G__48504 = chunk__47996_48496;
var G__48505 = count__47997_48497;
var G__48506 = (i__47998_48498 + (1));
seq__47995_48495 = G__48503;
chunk__47996_48496 = G__48504;
count__47997_48497 = G__48505;
i__47998_48498 = G__48506;
continue;
} else {
var temp__5720__auto___48507 = cljs.core.seq.call(null,seq__47995_48495);
if(temp__5720__auto___48507){
var seq__47995_48508__$1 = temp__5720__auto___48507;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47995_48508__$1)){
var c__4556__auto___48509 = cljs.core.chunk_first.call(null,seq__47995_48508__$1);
var G__48510 = cljs.core.chunk_rest.call(null,seq__47995_48508__$1);
var G__48511 = c__4556__auto___48509;
var G__48512 = cljs.core.count.call(null,c__4556__auto___48509);
var G__48513 = (0);
seq__47995_48495 = G__48510;
chunk__47996_48496 = G__48511;
count__47997_48497 = G__48512;
i__47998_48498 = G__48513;
continue;
} else {
var item_48514 = cljs.core.first.call(null,seq__47995_48508__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_48514));


var G__48515 = cljs.core.next.call(null,seq__47995_48508__$1);
var G__48516 = null;
var G__48517 = (0);
var G__48518 = (0);
seq__47995_48495 = G__48515;
chunk__47996_48496 = G__48516;
count__47997_48497 = G__48517;
i__47998_48498 = G__48518;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,(function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__4217__auto__ = count_new;
var y__4218__auto__ = count_children;
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})();
var n__4613__auto___48520 = count_children__$1;
var idx_48521 = (0);
while(true){
if((idx_48521 < n__4613__auto___48520)){
var cn_48522 = cljs.core.nth.call(null,children__$1,idx_48521);
var cc_48523 = shadow.object.get_from_dom.call(null,cn_48522);
var ckey_48524 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_48523);
var cval_48525 = cljs.core.get.call(null,cc_48523,item_key);
var vec__48005_48526 = cljs.core.nth.call(null,new_coll,idx_48521);
var nkey_48527 = cljs.core.nth.call(null,vec__48005_48526,(0),null);
var nval_48528 = cljs.core.nth.call(null,vec__48005_48526,(1),null);
if(((cljs.core._EQ_.call(null,ckey_48524,nkey_48527)) && (cljs.core._EQ_.call(null,cval_48525,nval_48528)))){
} else {
var new_obj_48529 = make_item_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_48527,nval_48528], null));
shadow.dom.replace_node.call(null,cn_48522,new_obj_48529);

shadow.object.destroy_BANG_.call(null,cc_48523);

shadow.object.notify_tree_BANG_.call(null,new_obj_48529,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__48530 = (idx_48521 + (1));
idx_48521 = G__48530;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__48009_48534 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__48010_48535 = null;
var count__48011_48536 = (0);
var i__48012_48537 = (0);
while(true){
if((i__48012_48537 < count__48011_48536)){
var item_48538 = cljs.core._nth(chunk__48010_48535,i__48012_48537);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_48538));


var G__48539 = seq__48009_48534;
var G__48540 = chunk__48010_48535;
var G__48541 = count__48011_48536;
var G__48542 = (i__48012_48537 + (1));
seq__48009_48534 = G__48539;
chunk__48010_48535 = G__48540;
count__48011_48536 = G__48541;
i__48012_48537 = G__48542;
continue;
} else {
var temp__5720__auto___48543 = cljs.core.seq.call(null,seq__48009_48534);
if(temp__5720__auto___48543){
var seq__48009_48544__$1 = temp__5720__auto___48543;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48009_48544__$1)){
var c__4556__auto___48545 = cljs.core.chunk_first.call(null,seq__48009_48544__$1);
var G__48546 = cljs.core.chunk_rest.call(null,seq__48009_48544__$1);
var G__48547 = c__4556__auto___48545;
var G__48548 = cljs.core.count.call(null,c__4556__auto___48545);
var G__48549 = (0);
seq__48009_48534 = G__48546;
chunk__48010_48535 = G__48547;
count__48011_48536 = G__48548;
i__48012_48537 = G__48549;
continue;
} else {
var item_48550 = cljs.core.first.call(null,seq__48009_48544__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn(item_48550));


var G__48551 = cljs.core.next.call(null,seq__48009_48544__$1);
var G__48552 = null;
var G__48553 = (0);
var G__48554 = (0);
seq__48009_48534 = G__48551;
chunk__48010_48535 = G__48552;
count__48011_48536 = G__48553;
i__48012_48537 = G__48554;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
}));

return coll_dom;
}));

(shadow.object.bind_children.cljs$lang$maxFixedArity = 6);

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__4115__auto__ = key;
if(cljs.core.truth_(and__4115__auto__)){
return path;
} else {
return and__4115__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id(oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type(oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data(oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__48016_48555 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__48017_48556 = null;
var count__48018_48557 = (0);
var i__48019_48558 = (0);
while(true){
if((i__48019_48558 < count__48018_48557)){
var vec__48028_48559 = cljs.core._nth(chunk__48017_48556,i__48019_48558);
var id_48560 = cljs.core.nth.call(null,vec__48028_48559,(0),null);
var oref_48561 = cljs.core.nth.call(null,vec__48028_48559,(1),null);
shadow.object.info.call(null,"dump",id_48560,cljs.core.pr_str.call(null,shadow.object._type(oref_48561)),cljs.core.deref.call(null,shadow.object._data(oref_48561)));


var G__48562 = seq__48016_48555;
var G__48563 = chunk__48017_48556;
var G__48564 = count__48018_48557;
var G__48565 = (i__48019_48558 + (1));
seq__48016_48555 = G__48562;
chunk__48017_48556 = G__48563;
count__48018_48557 = G__48564;
i__48019_48558 = G__48565;
continue;
} else {
var temp__5720__auto___48566 = cljs.core.seq.call(null,seq__48016_48555);
if(temp__5720__auto___48566){
var seq__48016_48567__$1 = temp__5720__auto___48566;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48016_48567__$1)){
var c__4556__auto___48568 = cljs.core.chunk_first.call(null,seq__48016_48567__$1);
var G__48569 = cljs.core.chunk_rest.call(null,seq__48016_48567__$1);
var G__48570 = c__4556__auto___48568;
var G__48571 = cljs.core.count.call(null,c__4556__auto___48568);
var G__48572 = (0);
seq__48016_48555 = G__48569;
chunk__48017_48556 = G__48570;
count__48018_48557 = G__48571;
i__48019_48558 = G__48572;
continue;
} else {
var vec__48031_48573 = cljs.core.first.call(null,seq__48016_48567__$1);
var id_48574 = cljs.core.nth.call(null,vec__48031_48573,(0),null);
var oref_48575 = cljs.core.nth.call(null,vec__48031_48573,(1),null);
shadow.object.info.call(null,"dump",id_48574,cljs.core.pr_str.call(null,shadow.object._type(oref_48575)),cljs.core.deref.call(null,shadow.object._data(oref_48575)));


var G__48576 = cljs.core.next.call(null,seq__48016_48567__$1);
var G__48577 = null;
var G__48578 = (0);
var G__48579 = (0);
seq__48016_48555 = G__48576;
chunk__48017_48556 = G__48577;
count__48018_48557 = G__48578;
i__48019_48558 = G__48579;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
