goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47072 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47072(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47078 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47078(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom(el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__45558 = arguments.length;
switch (G__45558) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__45580 = arguments.length;
switch (G__45580) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__45587 = arguments.length;
switch (G__45587) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__45607 = arguments.length;
switch (G__45607) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__45633 = arguments.length;
switch (G__45633) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__45662 = arguments.length;
switch (G__45662) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e45681){if((e45681 instanceof Object)){
var e = e45681;
return console.log("didnt support attachEvent",el,e);
} else {
throw e45681;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__45703 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__45704 = null;
var count__45705 = (0);
var i__45706 = (0);
while(true){
if((i__45706 < count__45705)){
var el = cljs.core._nth(chunk__45704,i__45706);
var handler_47100__$1 = ((function (seq__45703,chunk__45704,count__45705,i__45706,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__45703,chunk__45704,count__45705,i__45706,el))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_47100__$1);


var G__47102 = seq__45703;
var G__47103 = chunk__45704;
var G__47104 = count__45705;
var G__47105 = (i__45706 + (1));
seq__45703 = G__47102;
chunk__45704 = G__47103;
count__45705 = G__47104;
i__45706 = G__47105;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__45703);
if(temp__5720__auto__){
var seq__45703__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45703__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__45703__$1);
var G__47107 = cljs.core.chunk_rest.call(null,seq__45703__$1);
var G__47108 = c__4556__auto__;
var G__47109 = cljs.core.count.call(null,c__4556__auto__);
var G__47110 = (0);
seq__45703 = G__47107;
chunk__45704 = G__47108;
count__45705 = G__47109;
i__45706 = G__47110;
continue;
} else {
var el = cljs.core.first.call(null,seq__45703__$1);
var handler_47113__$1 = ((function (seq__45703,chunk__45704,count__45705,i__45706,el,seq__45703__$1,temp__5720__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__45703,chunk__45704,count__45705,i__45706,el,seq__45703__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_47113__$1);


var G__47115 = cljs.core.next.call(null,seq__45703__$1);
var G__47116 = null;
var G__47117 = (0);
var G__47118 = (0);
seq__45703 = G__47115;
chunk__45704 = G__47116;
count__45705 = G__47117;
i__45706 = G__47118;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__45736 = arguments.length;
switch (G__45736) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__45757 = cljs.core.seq.call(null,events);
var chunk__45758 = null;
var count__45759 = (0);
var i__45760 = (0);
while(true){
if((i__45760 < count__45759)){
var vec__45776 = cljs.core._nth(chunk__45758,i__45760);
var k = cljs.core.nth.call(null,vec__45776,(0),null);
var v = cljs.core.nth.call(null,vec__45776,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47130 = seq__45757;
var G__47131 = chunk__45758;
var G__47132 = count__45759;
var G__47133 = (i__45760 + (1));
seq__45757 = G__47130;
chunk__45758 = G__47131;
count__45759 = G__47132;
i__45760 = G__47133;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__45757);
if(temp__5720__auto__){
var seq__45757__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45757__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__45757__$1);
var G__47136 = cljs.core.chunk_rest.call(null,seq__45757__$1);
var G__47137 = c__4556__auto__;
var G__47138 = cljs.core.count.call(null,c__4556__auto__);
var G__47139 = (0);
seq__45757 = G__47136;
chunk__45758 = G__47137;
count__45759 = G__47138;
i__45760 = G__47139;
continue;
} else {
var vec__45789 = cljs.core.first.call(null,seq__45757__$1);
var k = cljs.core.nth.call(null,vec__45789,(0),null);
var v = cljs.core.nth.call(null,vec__45789,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47142 = cljs.core.next.call(null,seq__45757__$1);
var G__47143 = null;
var G__47144 = (0);
var G__47145 = (0);
seq__45757 = G__47142;
chunk__45758 = G__47143;
count__45759 = G__47144;
i__45760 = G__47145;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__45805 = cljs.core.seq.call(null,styles);
var chunk__45806 = null;
var count__45807 = (0);
var i__45808 = (0);
while(true){
if((i__45808 < count__45807)){
var vec__45829 = cljs.core._nth(chunk__45806,i__45808);
var k = cljs.core.nth.call(null,vec__45829,(0),null);
var v = cljs.core.nth.call(null,vec__45829,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47150 = seq__45805;
var G__47151 = chunk__45806;
var G__47152 = count__45807;
var G__47153 = (i__45808 + (1));
seq__45805 = G__47150;
chunk__45806 = G__47151;
count__45807 = G__47152;
i__45808 = G__47153;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__45805);
if(temp__5720__auto__){
var seq__45805__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45805__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__45805__$1);
var G__47154 = cljs.core.chunk_rest.call(null,seq__45805__$1);
var G__47155 = c__4556__auto__;
var G__47156 = cljs.core.count.call(null,c__4556__auto__);
var G__47157 = (0);
seq__45805 = G__47154;
chunk__45806 = G__47155;
count__45807 = G__47156;
i__45808 = G__47157;
continue;
} else {
var vec__45834 = cljs.core.first.call(null,seq__45805__$1);
var k = cljs.core.nth.call(null,vec__45834,(0),null);
var v = cljs.core.nth.call(null,vec__45834,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47158 = cljs.core.next.call(null,seq__45805__$1);
var G__47159 = null;
var G__47160 = (0);
var G__47161 = (0);
seq__45805 = G__47158;
chunk__45806 = G__47159;
count__45807 = G__47160;
i__45808 = G__47161;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__45843_47165 = key;
var G__45843_47166__$1 = (((G__45843_47165 instanceof cljs.core.Keyword))?G__45843_47165.fqn:null);
switch (G__45843_47166__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47172 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_47172,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_47172,"aria-");
}
})())){
el.setAttribute(ks_47172,value);
} else {
(el[ks_47172] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__45918){
var map__45922 = p__45918;
var map__45922__$1 = (((((!((map__45922 == null))))?(((((map__45922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45922):map__45922);
var props = map__45922__$1;
var class$ = cljs.core.get.call(null,map__45922__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__45929 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__45929,(0),null);
var tag_id = cljs.core.nth.call(null,vec__45929,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__45929,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__45939 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__45939,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__45939;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__45948 = arguments.length;
switch (G__45948) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__45975){
var vec__45977 = p__45975;
var seq__45978 = cljs.core.seq.call(null,vec__45977);
var first__45979 = cljs.core.first.call(null,seq__45978);
var seq__45978__$1 = cljs.core.next.call(null,seq__45978);
var nn = first__45979;
var first__45979__$1 = cljs.core.first.call(null,seq__45978__$1);
var seq__45978__$2 = cljs.core.next.call(null,seq__45978__$1);
var np = first__45979__$1;
var nc = seq__45978__$2;
var node = vec__45977;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__45998 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__45998,(0),null);
var node_children = cljs.core.nth.call(null,vec__45998,(1),null);
var seq__46001_47210 = cljs.core.seq.call(null,node_children);
var chunk__46002_47211 = null;
var count__46003_47212 = (0);
var i__46004_47213 = (0);
while(true){
if((i__46004_47213 < count__46003_47212)){
var child_struct_47214 = cljs.core._nth(chunk__46002_47211,i__46004_47213);
var children_47215 = shadow.dom.dom_node.call(null,child_struct_47214);
if(cljs.core.seq_QMARK_.call(null,children_47215)){
var seq__46061_47217 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47215));
var chunk__46063_47218 = null;
var count__46064_47219 = (0);
var i__46065_47220 = (0);
while(true){
if((i__46065_47220 < count__46064_47219)){
var child_47222 = cljs.core._nth(chunk__46063_47218,i__46065_47220);
if(cljs.core.truth_(child_47222)){
shadow.dom.append.call(null,node,child_47222);


var G__47223 = seq__46061_47217;
var G__47224 = chunk__46063_47218;
var G__47225 = count__46064_47219;
var G__47226 = (i__46065_47220 + (1));
seq__46061_47217 = G__47223;
chunk__46063_47218 = G__47224;
count__46064_47219 = G__47225;
i__46065_47220 = G__47226;
continue;
} else {
var G__47227 = seq__46061_47217;
var G__47228 = chunk__46063_47218;
var G__47229 = count__46064_47219;
var G__47230 = (i__46065_47220 + (1));
seq__46061_47217 = G__47227;
chunk__46063_47218 = G__47228;
count__46064_47219 = G__47229;
i__46065_47220 = G__47230;
continue;
}
} else {
var temp__5720__auto___47231 = cljs.core.seq.call(null,seq__46061_47217);
if(temp__5720__auto___47231){
var seq__46061_47232__$1 = temp__5720__auto___47231;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46061_47232__$1)){
var c__4556__auto___47233 = cljs.core.chunk_first.call(null,seq__46061_47232__$1);
var G__47235 = cljs.core.chunk_rest.call(null,seq__46061_47232__$1);
var G__47236 = c__4556__auto___47233;
var G__47237 = cljs.core.count.call(null,c__4556__auto___47233);
var G__47238 = (0);
seq__46061_47217 = G__47235;
chunk__46063_47218 = G__47236;
count__46064_47219 = G__47237;
i__46065_47220 = G__47238;
continue;
} else {
var child_47240 = cljs.core.first.call(null,seq__46061_47232__$1);
if(cljs.core.truth_(child_47240)){
shadow.dom.append.call(null,node,child_47240);


var G__47241 = cljs.core.next.call(null,seq__46061_47232__$1);
var G__47242 = null;
var G__47243 = (0);
var G__47244 = (0);
seq__46061_47217 = G__47241;
chunk__46063_47218 = G__47242;
count__46064_47219 = G__47243;
i__46065_47220 = G__47244;
continue;
} else {
var G__47245 = cljs.core.next.call(null,seq__46061_47232__$1);
var G__47246 = null;
var G__47247 = (0);
var G__47248 = (0);
seq__46061_47217 = G__47245;
chunk__46063_47218 = G__47246;
count__46064_47219 = G__47247;
i__46065_47220 = G__47248;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47215);
}


var G__47250 = seq__46001_47210;
var G__47251 = chunk__46002_47211;
var G__47252 = count__46003_47212;
var G__47253 = (i__46004_47213 + (1));
seq__46001_47210 = G__47250;
chunk__46002_47211 = G__47251;
count__46003_47212 = G__47252;
i__46004_47213 = G__47253;
continue;
} else {
var temp__5720__auto___47254 = cljs.core.seq.call(null,seq__46001_47210);
if(temp__5720__auto___47254){
var seq__46001_47255__$1 = temp__5720__auto___47254;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46001_47255__$1)){
var c__4556__auto___47257 = cljs.core.chunk_first.call(null,seq__46001_47255__$1);
var G__47258 = cljs.core.chunk_rest.call(null,seq__46001_47255__$1);
var G__47259 = c__4556__auto___47257;
var G__47260 = cljs.core.count.call(null,c__4556__auto___47257);
var G__47261 = (0);
seq__46001_47210 = G__47258;
chunk__46002_47211 = G__47259;
count__46003_47212 = G__47260;
i__46004_47213 = G__47261;
continue;
} else {
var child_struct_47266 = cljs.core.first.call(null,seq__46001_47255__$1);
var children_47267 = shadow.dom.dom_node.call(null,child_struct_47266);
if(cljs.core.seq_QMARK_.call(null,children_47267)){
var seq__46090_47268 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47267));
var chunk__46092_47269 = null;
var count__46093_47270 = (0);
var i__46094_47271 = (0);
while(true){
if((i__46094_47271 < count__46093_47270)){
var child_47272 = cljs.core._nth(chunk__46092_47269,i__46094_47271);
if(cljs.core.truth_(child_47272)){
shadow.dom.append.call(null,node,child_47272);


var G__47273 = seq__46090_47268;
var G__47274 = chunk__46092_47269;
var G__47275 = count__46093_47270;
var G__47276 = (i__46094_47271 + (1));
seq__46090_47268 = G__47273;
chunk__46092_47269 = G__47274;
count__46093_47270 = G__47275;
i__46094_47271 = G__47276;
continue;
} else {
var G__47278 = seq__46090_47268;
var G__47279 = chunk__46092_47269;
var G__47280 = count__46093_47270;
var G__47281 = (i__46094_47271 + (1));
seq__46090_47268 = G__47278;
chunk__46092_47269 = G__47279;
count__46093_47270 = G__47280;
i__46094_47271 = G__47281;
continue;
}
} else {
var temp__5720__auto___47282__$1 = cljs.core.seq.call(null,seq__46090_47268);
if(temp__5720__auto___47282__$1){
var seq__46090_47283__$1 = temp__5720__auto___47282__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46090_47283__$1)){
var c__4556__auto___47284 = cljs.core.chunk_first.call(null,seq__46090_47283__$1);
var G__47285 = cljs.core.chunk_rest.call(null,seq__46090_47283__$1);
var G__47286 = c__4556__auto___47284;
var G__47287 = cljs.core.count.call(null,c__4556__auto___47284);
var G__47288 = (0);
seq__46090_47268 = G__47285;
chunk__46092_47269 = G__47286;
count__46093_47270 = G__47287;
i__46094_47271 = G__47288;
continue;
} else {
var child_47289 = cljs.core.first.call(null,seq__46090_47283__$1);
if(cljs.core.truth_(child_47289)){
shadow.dom.append.call(null,node,child_47289);


var G__47290 = cljs.core.next.call(null,seq__46090_47283__$1);
var G__47291 = null;
var G__47292 = (0);
var G__47293 = (0);
seq__46090_47268 = G__47290;
chunk__46092_47269 = G__47291;
count__46093_47270 = G__47292;
i__46094_47271 = G__47293;
continue;
} else {
var G__47294 = cljs.core.next.call(null,seq__46090_47283__$1);
var G__47295 = null;
var G__47296 = (0);
var G__47297 = (0);
seq__46090_47268 = G__47294;
chunk__46092_47269 = G__47295;
count__46093_47270 = G__47296;
i__46094_47271 = G__47297;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47267);
}


var G__47299 = cljs.core.next.call(null,seq__46001_47255__$1);
var G__47300 = null;
var G__47301 = (0);
var G__47302 = (0);
seq__46001_47210 = G__47299;
chunk__46002_47211 = G__47300;
count__46003_47212 = G__47301;
i__46004_47213 = G__47302;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46131 = cljs.core.seq.call(null,node);
var chunk__46132 = null;
var count__46133 = (0);
var i__46134 = (0);
while(true){
if((i__46134 < count__46133)){
var n = cljs.core._nth(chunk__46132,i__46134);
shadow.dom.remove.call(null,n);


var G__47312 = seq__46131;
var G__47313 = chunk__46132;
var G__47314 = count__46133;
var G__47315 = (i__46134 + (1));
seq__46131 = G__47312;
chunk__46132 = G__47313;
count__46133 = G__47314;
i__46134 = G__47315;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46131);
if(temp__5720__auto__){
var seq__46131__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46131__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46131__$1);
var G__47316 = cljs.core.chunk_rest.call(null,seq__46131__$1);
var G__47317 = c__4556__auto__;
var G__47318 = cljs.core.count.call(null,c__4556__auto__);
var G__47319 = (0);
seq__46131 = G__47316;
chunk__46132 = G__47317;
count__46133 = G__47318;
i__46134 = G__47319;
continue;
} else {
var n = cljs.core.first.call(null,seq__46131__$1);
shadow.dom.remove.call(null,n);


var G__47320 = cljs.core.next.call(null,seq__46131__$1);
var G__47321 = null;
var G__47322 = (0);
var G__47323 = (0);
seq__46131 = G__47320;
chunk__46132 = G__47321;
count__46133 = G__47322;
i__46134 = G__47323;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46144 = arguments.length;
switch (G__46144) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node.call(null,el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46177 = arguments.length;
switch (G__46177) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node.call(null,el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46212 = arguments.length;
switch (G__46212) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node.call(null,node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47344 = arguments.length;
var i__4737__auto___47345 = (0);
while(true){
if((i__4737__auto___47345 < len__4736__auto___47344)){
args__4742__auto__.push((arguments[i__4737__auto___47345]));

var G__47346 = (i__4737__auto___47345 + (1));
i__4737__auto___47345 = G__47346;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46271_47348 = cljs.core.seq.call(null,nodes);
var chunk__46272_47349 = null;
var count__46273_47350 = (0);
var i__46274_47351 = (0);
while(true){
if((i__46274_47351 < count__46273_47350)){
var node_47353 = cljs.core._nth(chunk__46272_47349,i__46274_47351);
fragment.appendChild(shadow.dom._to_dom(node_47353));


var G__47354 = seq__46271_47348;
var G__47355 = chunk__46272_47349;
var G__47356 = count__46273_47350;
var G__47357 = (i__46274_47351 + (1));
seq__46271_47348 = G__47354;
chunk__46272_47349 = G__47355;
count__46273_47350 = G__47356;
i__46274_47351 = G__47357;
continue;
} else {
var temp__5720__auto___47358 = cljs.core.seq.call(null,seq__46271_47348);
if(temp__5720__auto___47358){
var seq__46271_47360__$1 = temp__5720__auto___47358;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46271_47360__$1)){
var c__4556__auto___47362 = cljs.core.chunk_first.call(null,seq__46271_47360__$1);
var G__47363 = cljs.core.chunk_rest.call(null,seq__46271_47360__$1);
var G__47364 = c__4556__auto___47362;
var G__47365 = cljs.core.count.call(null,c__4556__auto___47362);
var G__47366 = (0);
seq__46271_47348 = G__47363;
chunk__46272_47349 = G__47364;
count__46273_47350 = G__47365;
i__46274_47351 = G__47366;
continue;
} else {
var node_47369 = cljs.core.first.call(null,seq__46271_47360__$1);
fragment.appendChild(shadow.dom._to_dom(node_47369));


var G__47370 = cljs.core.next.call(null,seq__46271_47360__$1);
var G__47371 = null;
var G__47372 = (0);
var G__47373 = (0);
seq__46271_47348 = G__47370;
chunk__46272_47349 = G__47371;
count__46273_47350 = G__47372;
i__46274_47351 = G__47373;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46268){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46268));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46331_47378 = cljs.core.seq.call(null,scripts);
var chunk__46332_47379 = null;
var count__46333_47380 = (0);
var i__46334_47381 = (0);
while(true){
if((i__46334_47381 < count__46333_47380)){
var vec__46358_47382 = cljs.core._nth(chunk__46332_47379,i__46334_47381);
var script_tag_47383 = cljs.core.nth.call(null,vec__46358_47382,(0),null);
var script_body_47384 = cljs.core.nth.call(null,vec__46358_47382,(1),null);
eval(script_body_47384);


var G__47385 = seq__46331_47378;
var G__47386 = chunk__46332_47379;
var G__47387 = count__46333_47380;
var G__47388 = (i__46334_47381 + (1));
seq__46331_47378 = G__47385;
chunk__46332_47379 = G__47386;
count__46333_47380 = G__47387;
i__46334_47381 = G__47388;
continue;
} else {
var temp__5720__auto___47389 = cljs.core.seq.call(null,seq__46331_47378);
if(temp__5720__auto___47389){
var seq__46331_47390__$1 = temp__5720__auto___47389;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46331_47390__$1)){
var c__4556__auto___47391 = cljs.core.chunk_first.call(null,seq__46331_47390__$1);
var G__47392 = cljs.core.chunk_rest.call(null,seq__46331_47390__$1);
var G__47393 = c__4556__auto___47391;
var G__47394 = cljs.core.count.call(null,c__4556__auto___47391);
var G__47395 = (0);
seq__46331_47378 = G__47392;
chunk__46332_47379 = G__47393;
count__46333_47380 = G__47394;
i__46334_47381 = G__47395;
continue;
} else {
var vec__46372_47396 = cljs.core.first.call(null,seq__46331_47390__$1);
var script_tag_47397 = cljs.core.nth.call(null,vec__46372_47396,(0),null);
var script_body_47398 = cljs.core.nth.call(null,vec__46372_47396,(1),null);
eval(script_body_47398);


var G__47400 = cljs.core.next.call(null,seq__46331_47390__$1);
var G__47401 = null;
var G__47402 = (0);
var G__47403 = (0);
seq__46331_47378 = G__47400;
chunk__46332_47379 = G__47401;
count__46333_47380 = G__47402;
i__46334_47381 = G__47403;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,(function (s__$1,p__46380){
var vec__46385 = p__46380;
var script_tag = cljs.core.nth.call(null,vec__46385,(0),null);
var script_body = cljs.core.nth.call(null,vec__46385,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46420 = arguments.length;
switch (G__46420) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__46450 = cljs.core.seq.call(null,style_keys);
var chunk__46451 = null;
var count__46452 = (0);
var i__46453 = (0);
while(true){
if((i__46453 < count__46452)){
var it = cljs.core._nth(chunk__46451,i__46453);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47436 = seq__46450;
var G__47437 = chunk__46451;
var G__47438 = count__46452;
var G__47439 = (i__46453 + (1));
seq__46450 = G__47436;
chunk__46451 = G__47437;
count__46452 = G__47438;
i__46453 = G__47439;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46450);
if(temp__5720__auto__){
var seq__46450__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46450__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46450__$1);
var G__47454 = cljs.core.chunk_rest.call(null,seq__46450__$1);
var G__47455 = c__4556__auto__;
var G__47456 = cljs.core.count.call(null,c__4556__auto__);
var G__47457 = (0);
seq__46450 = G__47454;
chunk__46451 = G__47455;
count__46452 = G__47456;
i__46453 = G__47457;
continue;
} else {
var it = cljs.core.first.call(null,seq__46450__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47460 = cljs.core.next.call(null,seq__46450__$1);
var G__47461 = null;
var G__47462 = (0);
var G__47463 = (0);
seq__46450 = G__47460;
chunk__46451 = G__47461;
count__46452 = G__47462;
i__46453 = G__47463;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46475,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46506 = k46475;
var G__46506__$1 = (((G__46506 instanceof cljs.core.Keyword))?G__46506.fqn:null);
switch (G__46506__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46475,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__46510){
var vec__46511 = p__46510;
var k__4403__auto__ = cljs.core.nth.call(null,vec__46511,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__46511,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46474){
var self__ = this;
var G__46474__$1 = this;
return (new cljs.core.RecordIter((0),G__46474__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46476,other46477){
var self__ = this;
var this46476__$1 = this;
return (((!((other46477 == null)))) && ((this46476__$1.constructor === other46477.constructor)) && (cljs.core._EQ_.call(null,this46476__$1.x,other46477.x)) && (cljs.core._EQ_.call(null,this46476__$1.y,other46477.y)) && (cljs.core._EQ_.call(null,this46476__$1.__extmap,other46477.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46474){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46577 = cljs.core.keyword_identical_QMARK_;
var expr__46578 = k__4388__auto__;
if(cljs.core.truth_(pred__46577.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46578))){
return (new shadow.dom.Coordinate(G__46474,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46577.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46578))){
return (new shadow.dom.Coordinate(self__.x,G__46474,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__46474),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46474){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46474,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46485){
var extmap__4419__auto__ = (function (){var G__46599 = cljs.core.dissoc.call(null,G__46485,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__46485)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46599);
} else {
return G__46599;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46485),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46485),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46623,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46630 = k46623;
var G__46630__$1 = (((G__46630 instanceof cljs.core.Keyword))?G__46630.fqn:null);
switch (G__46630__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46623,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__46634){
var vec__46635 = p__46634;
var k__4403__auto__ = cljs.core.nth.call(null,vec__46635,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__46635,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46622){
var self__ = this;
var G__46622__$1 = this;
return (new cljs.core.RecordIter((0),G__46622__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46624,other46625){
var self__ = this;
var this46624__$1 = this;
return (((!((other46625 == null)))) && ((this46624__$1.constructor === other46625.constructor)) && (cljs.core._EQ_.call(null,this46624__$1.w,other46625.w)) && (cljs.core._EQ_.call(null,this46624__$1.h,other46625.h)) && (cljs.core._EQ_.call(null,this46624__$1.__extmap,other46625.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46622){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46742 = cljs.core.keyword_identical_QMARK_;
var expr__46743 = k__4388__auto__;
if(cljs.core.truth_(pred__46742.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46743))){
return (new shadow.dom.Size(G__46622,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46742.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46743))){
return (new shadow.dom.Size(self__.w,G__46622,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__46622),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46622){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46622,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46626){
var extmap__4419__auto__ = (function (){var G__46782 = cljs.core.dissoc.call(null,G__46626,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__46626)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46782);
} else {
return G__46782;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46626),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46626),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47595 = (i + (1));
var G__47596 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__47595;
ret = G__47596;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__46811){
var vec__46812 = p__46811;
var k = cljs.core.nth.call(null,vec__46812,(0),null);
var v = cljs.core.nth.call(null,vec__46812,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46817 = arguments.length;
switch (G__46817) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47610 = ps;
var G__47611 = (i + (1));
el__$1 = G__47610;
i = G__47611;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,(function (){
return shadow.dom.parents.call(null,parent);
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46854 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46854,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46854,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46854,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46859_47631 = cljs.core.seq.call(null,props);
var chunk__46860_47632 = null;
var count__46861_47633 = (0);
var i__46862_47634 = (0);
while(true){
if((i__46862_47634 < count__46861_47633)){
var vec__46880_47636 = cljs.core._nth(chunk__46860_47632,i__46862_47634);
var k_47637 = cljs.core.nth.call(null,vec__46880_47636,(0),null);
var v_47638 = cljs.core.nth.call(null,vec__46880_47636,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace.call(null,k_47637);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47637),v_47638);


var G__47643 = seq__46859_47631;
var G__47644 = chunk__46860_47632;
var G__47645 = count__46861_47633;
var G__47646 = (i__46862_47634 + (1));
seq__46859_47631 = G__47643;
chunk__46860_47632 = G__47644;
count__46861_47633 = G__47645;
i__46862_47634 = G__47646;
continue;
} else {
var temp__5720__auto___47647 = cljs.core.seq.call(null,seq__46859_47631);
if(temp__5720__auto___47647){
var seq__46859_47648__$1 = temp__5720__auto___47647;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46859_47648__$1)){
var c__4556__auto___47649 = cljs.core.chunk_first.call(null,seq__46859_47648__$1);
var G__47651 = cljs.core.chunk_rest.call(null,seq__46859_47648__$1);
var G__47652 = c__4556__auto___47649;
var G__47653 = cljs.core.count.call(null,c__4556__auto___47649);
var G__47654 = (0);
seq__46859_47631 = G__47651;
chunk__46860_47632 = G__47652;
count__46861_47633 = G__47653;
i__46862_47634 = G__47654;
continue;
} else {
var vec__46887_47656 = cljs.core.first.call(null,seq__46859_47648__$1);
var k_47657 = cljs.core.nth.call(null,vec__46887_47656,(0),null);
var v_47658 = cljs.core.nth.call(null,vec__46887_47656,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace.call(null,k_47657);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47657),v_47658);


var G__47663 = cljs.core.next.call(null,seq__46859_47648__$1);
var G__47664 = null;
var G__47665 = (0);
var G__47666 = (0);
seq__46859_47631 = G__47663;
chunk__46860_47632 = G__47664;
count__46861_47633 = G__47665;
i__46862_47634 = G__47666;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg(el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46903 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__46903,(0),null);
var node_children = cljs.core.nth.call(null,vec__46903,(1),null);
var seq__46908_47676 = cljs.core.seq.call(null,node_children);
var chunk__46910_47677 = null;
var count__46911_47678 = (0);
var i__46912_47679 = (0);
while(true){
if((i__46912_47679 < count__46911_47678)){
var child_struct_47681 = cljs.core._nth(chunk__46910_47677,i__46912_47679);
if((!((child_struct_47681 == null)))){
if(typeof child_struct_47681 === 'string'){
var text_47683 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47683),child_struct_47681].join(''));
} else {
var children_47685 = shadow.dom.svg_node.call(null,child_struct_47681);
if(cljs.core.seq_QMARK_.call(null,children_47685)){
var seq__46946_47686 = cljs.core.seq.call(null,children_47685);
var chunk__46948_47687 = null;
var count__46949_47688 = (0);
var i__46950_47689 = (0);
while(true){
if((i__46950_47689 < count__46949_47688)){
var child_47690 = cljs.core._nth(chunk__46948_47687,i__46950_47689);
if(cljs.core.truth_(child_47690)){
node.appendChild(child_47690);


var G__47691 = seq__46946_47686;
var G__47692 = chunk__46948_47687;
var G__47693 = count__46949_47688;
var G__47694 = (i__46950_47689 + (1));
seq__46946_47686 = G__47691;
chunk__46948_47687 = G__47692;
count__46949_47688 = G__47693;
i__46950_47689 = G__47694;
continue;
} else {
var G__47695 = seq__46946_47686;
var G__47696 = chunk__46948_47687;
var G__47697 = count__46949_47688;
var G__47698 = (i__46950_47689 + (1));
seq__46946_47686 = G__47695;
chunk__46948_47687 = G__47696;
count__46949_47688 = G__47697;
i__46950_47689 = G__47698;
continue;
}
} else {
var temp__5720__auto___47699 = cljs.core.seq.call(null,seq__46946_47686);
if(temp__5720__auto___47699){
var seq__46946_47700__$1 = temp__5720__auto___47699;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46946_47700__$1)){
var c__4556__auto___47701 = cljs.core.chunk_first.call(null,seq__46946_47700__$1);
var G__47702 = cljs.core.chunk_rest.call(null,seq__46946_47700__$1);
var G__47703 = c__4556__auto___47701;
var G__47704 = cljs.core.count.call(null,c__4556__auto___47701);
var G__47705 = (0);
seq__46946_47686 = G__47702;
chunk__46948_47687 = G__47703;
count__46949_47688 = G__47704;
i__46950_47689 = G__47705;
continue;
} else {
var child_47706 = cljs.core.first.call(null,seq__46946_47700__$1);
if(cljs.core.truth_(child_47706)){
node.appendChild(child_47706);


var G__47707 = cljs.core.next.call(null,seq__46946_47700__$1);
var G__47708 = null;
var G__47709 = (0);
var G__47710 = (0);
seq__46946_47686 = G__47707;
chunk__46948_47687 = G__47708;
count__46949_47688 = G__47709;
i__46950_47689 = G__47710;
continue;
} else {
var G__47716 = cljs.core.next.call(null,seq__46946_47700__$1);
var G__47717 = null;
var G__47718 = (0);
var G__47719 = (0);
seq__46946_47686 = G__47716;
chunk__46948_47687 = G__47717;
count__46949_47688 = G__47718;
i__46950_47689 = G__47719;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47685);
}
}


var G__47720 = seq__46908_47676;
var G__47721 = chunk__46910_47677;
var G__47722 = count__46911_47678;
var G__47723 = (i__46912_47679 + (1));
seq__46908_47676 = G__47720;
chunk__46910_47677 = G__47721;
count__46911_47678 = G__47722;
i__46912_47679 = G__47723;
continue;
} else {
var G__47725 = seq__46908_47676;
var G__47726 = chunk__46910_47677;
var G__47727 = count__46911_47678;
var G__47728 = (i__46912_47679 + (1));
seq__46908_47676 = G__47725;
chunk__46910_47677 = G__47726;
count__46911_47678 = G__47727;
i__46912_47679 = G__47728;
continue;
}
} else {
var temp__5720__auto___47730 = cljs.core.seq.call(null,seq__46908_47676);
if(temp__5720__auto___47730){
var seq__46908_47732__$1 = temp__5720__auto___47730;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46908_47732__$1)){
var c__4556__auto___47733 = cljs.core.chunk_first.call(null,seq__46908_47732__$1);
var G__47735 = cljs.core.chunk_rest.call(null,seq__46908_47732__$1);
var G__47736 = c__4556__auto___47733;
var G__47737 = cljs.core.count.call(null,c__4556__auto___47733);
var G__47738 = (0);
seq__46908_47676 = G__47735;
chunk__46910_47677 = G__47736;
count__46911_47678 = G__47737;
i__46912_47679 = G__47738;
continue;
} else {
var child_struct_47742 = cljs.core.first.call(null,seq__46908_47732__$1);
if((!((child_struct_47742 == null)))){
if(typeof child_struct_47742 === 'string'){
var text_47745 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47745),child_struct_47742].join(''));
} else {
var children_47748 = shadow.dom.svg_node.call(null,child_struct_47742);
if(cljs.core.seq_QMARK_.call(null,children_47748)){
var seq__46970_47750 = cljs.core.seq.call(null,children_47748);
var chunk__46972_47751 = null;
var count__46973_47752 = (0);
var i__46974_47753 = (0);
while(true){
if((i__46974_47753 < count__46973_47752)){
var child_47755 = cljs.core._nth(chunk__46972_47751,i__46974_47753);
if(cljs.core.truth_(child_47755)){
node.appendChild(child_47755);


var G__47756 = seq__46970_47750;
var G__47757 = chunk__46972_47751;
var G__47758 = count__46973_47752;
var G__47759 = (i__46974_47753 + (1));
seq__46970_47750 = G__47756;
chunk__46972_47751 = G__47757;
count__46973_47752 = G__47758;
i__46974_47753 = G__47759;
continue;
} else {
var G__47760 = seq__46970_47750;
var G__47761 = chunk__46972_47751;
var G__47762 = count__46973_47752;
var G__47763 = (i__46974_47753 + (1));
seq__46970_47750 = G__47760;
chunk__46972_47751 = G__47761;
count__46973_47752 = G__47762;
i__46974_47753 = G__47763;
continue;
}
} else {
var temp__5720__auto___47764__$1 = cljs.core.seq.call(null,seq__46970_47750);
if(temp__5720__auto___47764__$1){
var seq__46970_47765__$1 = temp__5720__auto___47764__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46970_47765__$1)){
var c__4556__auto___47770 = cljs.core.chunk_first.call(null,seq__46970_47765__$1);
var G__47771 = cljs.core.chunk_rest.call(null,seq__46970_47765__$1);
var G__47772 = c__4556__auto___47770;
var G__47773 = cljs.core.count.call(null,c__4556__auto___47770);
var G__47774 = (0);
seq__46970_47750 = G__47771;
chunk__46972_47751 = G__47772;
count__46973_47752 = G__47773;
i__46974_47753 = G__47774;
continue;
} else {
var child_47778 = cljs.core.first.call(null,seq__46970_47765__$1);
if(cljs.core.truth_(child_47778)){
node.appendChild(child_47778);


var G__47780 = cljs.core.next.call(null,seq__46970_47765__$1);
var G__47781 = null;
var G__47782 = (0);
var G__47783 = (0);
seq__46970_47750 = G__47780;
chunk__46972_47751 = G__47781;
count__46973_47752 = G__47782;
i__46974_47753 = G__47783;
continue;
} else {
var G__47789 = cljs.core.next.call(null,seq__46970_47765__$1);
var G__47790 = null;
var G__47791 = (0);
var G__47792 = (0);
seq__46970_47750 = G__47789;
chunk__46972_47751 = G__47790;
count__46973_47752 = G__47791;
i__46974_47753 = G__47792;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47748);
}
}


var G__47793 = cljs.core.next.call(null,seq__46908_47732__$1);
var G__47794 = null;
var G__47795 = (0);
var G__47796 = (0);
seq__46908_47676 = G__47793;
chunk__46910_47677 = G__47794;
count__46911_47678 = G__47795;
i__46912_47679 = G__47796;
continue;
} else {
var G__47797 = cljs.core.next.call(null,seq__46908_47732__$1);
var G__47798 = null;
var G__47799 = (0);
var G__47800 = (0);
seq__46908_47676 = G__47797;
chunk__46910_47677 = G__47798;
count__46911_47678 = G__47799;
i__46912_47679 = G__47800;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47807 = arguments.length;
var i__4737__auto___47809 = (0);
while(true){
if((i__4737__auto___47809 < len__4736__auto___47807)){
args__4742__auto__.push((arguments[i__4737__auto___47809]));

var G__47813 = (i__4737__auto___47809 + (1));
i__4737__auto___47809 = G__47813;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47014){
var G__47015 = cljs.core.first.call(null,seq47014);
var seq47014__$1 = cljs.core.next.call(null,seq47014);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47015,seq47014__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47021 = arguments.length;
switch (G__47021) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__42104__auto___47838 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_47030){
var state_val_47031 = (state_47030[(1)]);
if((state_val_47031 === (1))){
var state_47030__$1 = state_47030;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47030__$1,(2),once_or_cleanup);
} else {
if((state_val_47031 === (2))){
var inst_47026 = (state_47030[(2)]);
var inst_47028 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_47030__$1 = (function (){var statearr_47036 = state_47030;
(statearr_47036[(7)] = inst_47026);

return statearr_47036;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47030__$1,inst_47028);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__41875__auto__ = null;
var shadow$dom$state_machine__41875__auto____0 = (function (){
var statearr_47037 = [null,null,null,null,null,null,null,null];
(statearr_47037[(0)] = shadow$dom$state_machine__41875__auto__);

(statearr_47037[(1)] = (1));

return statearr_47037;
});
var shadow$dom$state_machine__41875__auto____1 = (function (state_47030){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_47030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e47042){var ex__41878__auto__ = e47042;
var statearr_47043_47853 = state_47030;
(statearr_47043_47853[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_47030[(4)]))){
var statearr_47044_47858 = state_47030;
(statearr_47044_47858[(1)] = cljs.core.first.call(null,(state_47030[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47860 = state_47030;
state_47030 = G__47860;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
shadow$dom$state_machine__41875__auto__ = function(state_47030){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__41875__auto____0.call(this);
case 1:
return shadow$dom$state_machine__41875__auto____1.call(this,state_47030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__41875__auto____0;
shadow$dom$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__41875__auto____1;
return shadow$dom$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_47046 = f__42105__auto__();
(statearr_47046[(6)] = c__42104__auto___47838);

return statearr_47046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
