goog.provide('shadow.cljs.devtools.client.env');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.active_modules_ref = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
}
shadow.cljs.devtools.client.env.module_loaded = (function shadow$cljs$devtools$client$env$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.env.active_modules_ref,cljs.core.conj.call(null,cljs.core._deref(shadow.cljs.devtools.client.env.active_modules_ref),cljs.core.keyword.call(null,name)));
});
shadow.cljs.devtools.client.env.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$env$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.env.active_modules_ref),module);
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.runtime_id !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.runtime_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
}
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.enabled = goog.define("shadow.cljs.devtools.client.env.enabled",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.autoload = goog.define("shadow.cljs.devtools.client.env.autoload",true);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.module_format = goog.define("shadow.cljs.devtools.client.env.module_format","goog");
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.reload_with_state = goog.define("shadow.cljs.devtools.client.env.reload_with_state",false);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.build_id = goog.define("shadow.cljs.devtools.client.env.build_id","");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.proc_id = goog.define("shadow.cljs.devtools.client.env.proc_id","");
/**
 * @define {number}
 */
shadow.cljs.devtools.client.env.worker_client_id = goog.define("shadow.cljs.devtools.client.env.worker_client_id",(0));
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.server_host = goog.define("shadow.cljs.devtools.client.env.server_host","");
/**
 * @define {number}
 */
shadow.cljs.devtools.client.env.server_port = goog.define("shadow.cljs.devtools.client.env.server_port",(8200));
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.repl_pprint = goog.define("shadow.cljs.devtools.client.env.repl_pprint",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.use_document_host = goog.define("shadow.cljs.devtools.client.env.use_document_host",true);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.devtools_url = goog.define("shadow.cljs.devtools.client.env.devtools_url","");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.reload_strategy = goog.define("shadow.cljs.devtools.client.env.reload_strategy","optimized");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.server_token = goog.define("shadow.cljs.devtools.client.env.server_token","missing");
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ssl = goog.define("shadow.cljs.devtools.client.env.ssl",false);
/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ignore_warnings = goog.define("shadow.cljs.devtools.client.env.ignore_warnings",false);
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.log_style = goog.define("shadow.cljs.devtools.client.env.log_style","font-weight: bold;");
/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.custom_notify_fn = goog.define("shadow.cljs.devtools.client.env.custom_notify_fn","");
shadow.cljs.devtools.client.env.devtools_info = (function shadow$cljs$devtools$client$env$devtools_info(){
return ({"server_port": shadow.cljs.devtools.client.env.server_port, "server_host": shadow.cljs.devtools.client.env.server_host, "build_id": shadow.cljs.devtools.client.env.build_id, "proc_id": shadow.cljs.devtools.client.env.proc_id, "runtime_id": shadow.cljs.devtools.client.env.runtime_id, "ssl": shadow.cljs.devtools.client.env.ssl});
});
shadow.cljs.devtools.client.env.get_server_host = (function shadow$cljs$devtools$client$env$get_server_host(){
if(cljs.core.truth_(((shadow.cljs.devtools.client.env.use_document_host)?(function (){var and__4115__auto__ = goog.global.location;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.seq.call(null,goog.global.location.hostname);
} else {
return and__4115__auto__;
}
})():false))){
return goog.global.location.hostname;
} else {
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.server_host)){
return shadow.cljs.devtools.client.env.server_host;
} else {
return "localhost";

}
}
});
shadow.cljs.devtools.client.env.get_url_base = (function shadow$cljs$devtools$client$env$get_url_base(){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.devtools_url)){
return shadow.cljs.devtools.client.env.devtools_url;
} else {
return ["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_server_host.call(null)),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port)].join('');
}
});
shadow.cljs.devtools.client.env.get_ws_url_base = (function shadow$cljs$devtools$client$env$get_ws_url_base(){
return clojure.string.replace.call(null,shadow.cljs.devtools.client.env.get_url_base.call(null),/^http/,"ws");
});
shadow.cljs.devtools.client.env.get_ws_relay_url = (function shadow$cljs$devtools$client$env$get_ws_relay_url(){
return [shadow.cljs.devtools.client.env.get_ws_url_base.call(null),"/api/remote-relay?server-token=",shadow.cljs.devtools.client.env.server_token].join('');
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.reset_print_fn_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.reset_print_fn_ref = cljs.core.atom.call(null,null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.was_print_newline !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.was_print_newline = cljs.core._STAR_print_newline_STAR_;
}
shadow.cljs.devtools.client.env.set_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$set_print_fns_BANG_(msg_fn){
var original_print_fn = cljs.core._STAR_print_fn_STAR_;
var original_print_err_fn = cljs.core._STAR_print_err_fn_STAR_;
(cljs.core._STAR_print_newline_STAR_ = true);

(cljs.core.enable_console_print_BANG_ = (function (){
return null;
}));

cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,(function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_reset_print_fns_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = shadow.cljs.devtools.client.env.was_print_newline);

cljs.core.set_print_fn_BANG_.call(null,original_print_fn);

return cljs.core.set_print_err_fn_BANG_.call(null,original_print_err_fn);
}));

cljs.core.set_print_fn_BANG_.call(null,(function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn(s){
msg_fn.call(null,new cljs.core.Keyword(null,"stdout","stdout",-531490018),s);

if(cljs.core.truth_((function (){var and__4115__auto__ = original_print_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,s,"\n");
} else {
return and__4115__auto__;
}
})())){
return original_print_fn.call(null,s);
} else {
return null;
}
}));

return cljs.core.set_print_err_fn_BANG_.call(null,(function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn(s){
msg_fn.call(null,new cljs.core.Keyword(null,"stderr","stderr",-1571650309),s);

if(cljs.core.truth_((function (){var and__4115__auto__ = original_print_err_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,s,"\n");
} else {
return and__4115__auto__;
}
})())){
return original_print_err_fn.call(null,s);
} else {
return null;
}
}));
});
shadow.cljs.devtools.client.env.reset_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$reset_print_fns_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var x = temp__5720__auto__;
x.call(null);

return cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,null);
} else {
return null;
}
});
shadow.cljs.devtools.client.env.patch_goog_BANG_ = (function shadow$cljs$devtools$client$env$patch_goog_BANG_(){
if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
(goog.provide = goog.constructNamespace_);

return (goog.isProvided_ = cljs.core.constantly.call(null,false));
} else {
return null;
}
});
shadow.cljs.devtools.client.env.add_warnings_to_info = (function shadow$cljs$devtools$client$env$add_warnings_to_info(p__44862){
var map__44863 = p__44862;
var map__44863__$1 = (((((!((map__44863 == null))))?(((((map__44863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44863):map__44863);
var msg = map__44863__$1;
var info = cljs.core.get.call(null,map__44863__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__4529__auto__ = (function shadow$cljs$devtools$client$env$add_warnings_to_info_$_iter__44866(s__44867){
return (new cljs.core.LazySeq(null,(function (){
var s__44867__$1 = s__44867;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__44867__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var map__44875 = cljs.core.first.call(null,xs__6277__auto__);
var map__44875__$1 = (((((!((map__44875 == null))))?(((((map__44875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44875):map__44875);
var src = map__44875__$1;
var resource_name = cljs.core.get.call(null,map__44875__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__44875__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4525__auto__ = ((function (s__44867__$1,map__44875,map__44875__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__44863,map__44863__$1,msg,info){
return (function shadow$cljs$devtools$client$env$add_warnings_to_info_$_iter__44866_$_iter__44869(s__44870){
return (new cljs.core.LazySeq(null,((function (s__44867__$1,map__44875,map__44875__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__44863,map__44863__$1,msg,info){
return (function (){
var s__44870__$1 = s__44870;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__44870__$1);
if(temp__5720__auto____$1){
var s__44870__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__44870__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__44870__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__44872 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__44871 = (0);
while(true){
if((i__44871 < size__4528__auto__)){
var warning = cljs.core._nth(c__4527__auto__,i__44871);
cljs.core.chunk_append.call(null,b__44872,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__45311 = (i__44871 + (1));
i__44871 = G__45311;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__44872),shadow$cljs$devtools$client$env$add_warnings_to_info_$_iter__44866_$_iter__44869.call(null,cljs.core.chunk_rest.call(null,s__44870__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__44872),null);
}
} else {
var warning = cljs.core.first.call(null,s__44870__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$env$add_warnings_to_info_$_iter__44866_$_iter__44869.call(null,cljs.core.rest.call(null,s__44870__$2)));
}
} else {
return null;
}
break;
}
});})(s__44867__$1,map__44875,map__44875__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__44863,map__44863__$1,msg,info))
,null,null));
});})(s__44867__$1,map__44875,map__44875__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__44863,map__44863__$1,msg,info))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__(warnings));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,shadow$cljs$devtools$client$env$add_warnings_to_info_$_iter__44866.call(null,cljs.core.rest.call(null,s__44867__$1)));
} else {
var G__45313 = cljs.core.rest.call(null,s__44867__$1);
s__44867__$1 = G__45313;
continue;
}
} else {
var G__45315 = cljs.core.rest.call(null,s__44867__$1);
s__44867__$1 = G__45315;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
return cljs.core.assoc_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.Keyword(null,"warnings","warnings",-735437651)], null),warnings);
});
shadow.cljs.devtools.client.env.custom_notify_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"build-complete","build-complete",-501868472),null,new cljs.core.Keyword(null,"build-init","build-init",-1115755563),null,new cljs.core.Keyword(null,"build-failure","build-failure",-2107487466),null,new cljs.core.Keyword(null,"build-start","build-start",-959649480),null], null), null);
shadow.cljs.devtools.client.env.run_custom_notify_BANG_ = (function shadow$cljs$devtools$client$env$run_custom_notify_BANG_(msg){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.custom_notify_fn)){
var fn = goog.getObjectByName(shadow.cljs.devtools.client.env.custom_notify_fn,$CLJS);
if((!(cljs.core.fn_QMARK_.call(null,fn)))){
return console.warn("couldn't find custom :build-notify",shadow.cljs.devtools.client.env.custom_notify_fn);
} else {
try{return fn(msg);
}catch (e44963){var e = e44963;
console.error("Failed to run custom :build-notify",shadow.cljs.devtools.client.env.custom_notify_fn);

return console.error(e);
}}
} else {
return null;
}
});
shadow.cljs.devtools.client.env.make_task_fn = (function shadow$cljs$devtools$client$env$make_task_fn(p__44970,p__44971){
var map__44974 = p__44970;
var map__44974__$1 = (((((!((map__44974 == null))))?(((((map__44974.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44974.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44974):map__44974);
var log_missing_fn = cljs.core.get.call(null,map__44974__$1,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765));
var log_call_async = cljs.core.get.call(null,map__44974__$1,new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192));
var log_call = cljs.core.get.call(null,map__44974__$1,new cljs.core.Keyword(null,"log-call","log-call",412404391));
var map__44975 = p__44971;
var map__44975__$1 = (((((!((map__44975 == null))))?(((((map__44975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44975):map__44975);
var fn_sym = cljs.core.get.call(null,map__44975__$1,new cljs.core.Keyword(null,"fn-sym","fn-sym",1423988510));
var fn_str = cljs.core.get.call(null,map__44975__$1,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402));
var async = cljs.core.get.call(null,map__44975__$1,new cljs.core.Keyword(null,"async","async",1050769601));
return (function (next){
try{var fn_obj = goog.getObjectByName(fn_str,$CLJS);
if((fn_obj == null)){
if(cljs.core.truth_(log_missing_fn)){
log_missing_fn.call(null,fn_sym);
} else {
}

return next.call(null);
} else {
if(cljs.core.truth_(async)){
if(cljs.core.truth_(log_call_async)){
log_call_async.call(null,fn_sym);
} else {
}

return fn_obj(next);
} else {
if(cljs.core.truth_(log_call)){
log_call.call(null,fn_sym);
} else {
}

fn_obj();

return next.call(null);

}
}
}catch (e44986){var ex = e44986;
console.warn("error when calling lifecycle function",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym),ex);

return next.call(null);
}});
});
shadow.cljs.devtools.client.env.do_js_reload_STAR_ = (function shadow$cljs$devtools$client$env$do_js_reload_STAR_(failure_fn,p__45000){
var vec__45001 = p__45000;
var seq__45002 = cljs.core.seq.call(null,vec__45001);
var first__45003 = cljs.core.first.call(null,seq__45002);
var seq__45002__$1 = cljs.core.next.call(null,seq__45002);
var task = first__45003;
var remaining_tasks = seq__45002__$1;
if(cljs.core.truth_(task)){
try{return task.call(null,(function (){
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,remaining_tasks);
}));
}catch (e45005){var e = e45005;
return failure_fn.call(null,e,task,remaining_tasks);
}} else {
return null;
}
});
/**
 * should pass the :build-complete message and an additional callback
 * which performs the actual loading of the code (sync)
 * will call all before/after callbacks in order
 */
shadow.cljs.devtools.client.env.do_js_reload = (function shadow$cljs$devtools$client$env$do_js_reload(var_args){
var G__45014 = arguments.length;
switch (G__45014) {
case 2:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2 = (function (msg,load_code_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,(function (){
return null;
}));
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3 = (function (msg,load_code_fn,complete_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,complete_fn,(function (error,task,remaining){
return console.warn("JS reload failed",error);
}));
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4 = (function (p__45032,load_code_fn,complete_fn,failure_fn){
var map__45033 = p__45032;
var map__45033__$1 = (((((!((map__45033 == null))))?(((((map__45033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45033.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45033):map__45033);
var msg = map__45033__$1;
var reload_info = cljs.core.get.call(null,map__45033__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var load_tasks = cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.reverse.call(null,cljs.core.map.call(null,(function (p1__45008_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__45008_SHARP_);
}),new cljs.core.Keyword(null,"before-load","before-load",-2060117064).cljs$core$IFn$_invoke$arity$1(reload_info)))),(function (next){
load_code_fn.call(null);

return next.call(null);
})),cljs.core.map.call(null,(function (p1__45010_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__45010_SHARP_);
})),new cljs.core.Keyword(null,"after-load","after-load",-1278503285).cljs$core$IFn$_invoke$arity$1(reload_info)),(function (next){
complete_fn.call(null);

return next.call(null);
}));
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,load_tasks);
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$lang$maxFixedArity = 4);

shadow.cljs.devtools.client.env.before_load_src = (function shadow$cljs$devtools$client$env$before_load_src(p__45047){
var map__45049 = p__45047;
var map__45049__$1 = (((((!((map__45049 == null))))?(((((map__45049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45049.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45049):map__45049);
var src = map__45049__$1;
var type = cljs.core.get.call(null,map__45049__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var ns = cljs.core.get.call(null,map__45049__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"cljs","cljs",1492417629),type)){
var seq__45053 = cljs.core.seq.call(null,goog.global.SHADOW_NS_RESET);
var chunk__45054 = null;
var count__45055 = (0);
var i__45056 = (0);
while(true){
if((i__45056 < count__45055)){
var x = cljs.core._nth(chunk__45054,i__45056);
x.call(null,ns);


var G__45411 = seq__45053;
var G__45412 = chunk__45054;
var G__45413 = count__45055;
var G__45414 = (i__45056 + (1));
seq__45053 = G__45411;
chunk__45054 = G__45412;
count__45055 = G__45413;
i__45056 = G__45414;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__45053);
if(temp__5720__auto__){
var seq__45053__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45053__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__45053__$1);
var G__45417 = cljs.core.chunk_rest.call(null,seq__45053__$1);
var G__45418 = c__4556__auto__;
var G__45419 = cljs.core.count.call(null,c__4556__auto__);
var G__45420 = (0);
seq__45053 = G__45417;
chunk__45054 = G__45418;
count__45055 = G__45419;
i__45056 = G__45420;
continue;
} else {
var x = cljs.core.first.call(null,seq__45053__$1);
x.call(null,ns);


var G__45421 = cljs.core.next.call(null,seq__45053__$1);
var G__45422 = null;
var G__45423 = (0);
var G__45424 = (0);
seq__45053 = G__45421;
chunk__45054 = G__45422;
count__45055 = G__45423;
i__45056 = G__45424;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
shadow.cljs.devtools.client.env.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$env$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.env.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.env.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$env$src_is_loaded_QMARK_(p__45079){
var map__45082 = p__45079;
var map__45082__$1 = (((((!((map__45082 == null))))?(((((map__45082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45082.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45082):map__45082);
var src = map__45082__$1;
var resource_id = cljs.core.get.call(null,map__45082__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__45082__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4126__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.env.goog_base_rc,resource_id);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return shadow.cljs.devtools.client.env.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.env.prefilter_sources = (function shadow$cljs$devtools$client$env$prefilter_sources(reload_info,sources){
return cljs.core.remove.call(null,(function (p__45086){
var map__45088 = p__45086;
var map__45088__$1 = (((((!((map__45088 == null))))?(((((map__45088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45088.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45088):map__45088);
var ns = cljs.core.get.call(null,map__45088__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
}),cljs.core.filter.call(null,(function (p__45099){
var map__45100 = p__45099;
var map__45100__$1 = (((((!((map__45100 == null))))?(((((map__45100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45100):map__45100);
var rc = map__45100__$1;
var module = cljs.core.get.call(null,map__45100__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.env.module_is_active_QMARK_.call(null,module)));
}),sources));
});
shadow.cljs.devtools.client.env.filter_sources_to_get_optimized = (function shadow$cljs$devtools$client$env$filter_sources_to_get_optimized(p__45107,reload_info){
var map__45108 = p__45107;
var map__45108__$1 = (((((!((map__45108 == null))))?(((((map__45108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45108):map__45108);
var info = map__45108__$1;
var sources = cljs.core.get.call(null,map__45108__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__45108__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p__45114){
var map__45115 = p__45114;
var map__45115__$1 = (((((!((map__45115 == null))))?(((((map__45115.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45115.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45115):map__45115);
var src = map__45115__$1;
var ns = cljs.core.get.call(null,map__45115__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__45115__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
}),shadow.cljs.devtools.client.env.prefilter_sources.call(null,reload_info,sources)));
});
shadow.cljs.devtools.client.env.filter_sources_to_get_full = (function shadow$cljs$devtools$client$env$filter_sources_to_get_full(p__45146,reload_info){
var map__45148 = p__45146;
var map__45148__$1 = (((((!((map__45148 == null))))?(((((map__45148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45148.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45148):map__45148);
var info = map__45148__$1;
var sources = cljs.core.get.call(null,map__45148__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__45148__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var affected = cljs.core.PersistentHashSet.EMPTY;
var sources_to_get = cljs.core.PersistentVector.EMPTY;
var G__45155 = shadow.cljs.devtools.client.env.prefilter_sources.call(null,reload_info,sources);
var vec__45157 = G__45155;
var seq__45158 = cljs.core.seq.call(null,vec__45157);
var first__45159 = cljs.core.first.call(null,seq__45158);
var seq__45158__$1 = cljs.core.next.call(null,seq__45158);
var src = first__45159;
var more = seq__45158__$1;
var affected__$1 = affected;
var sources_to_get__$1 = sources_to_get;
var G__45155__$1 = G__45155;
while(true){
var affected__$2 = affected__$1;
var sources_to_get__$2 = sources_to_get__$1;
var vec__45197 = G__45155__$1;
var seq__45198 = cljs.core.seq.call(null,vec__45197);
var first__45199 = cljs.core.first.call(null,seq__45198);
var seq__45198__$1 = cljs.core.next.call(null,seq__45198);
var src__$1 = first__45199;
var more__$1 = seq__45198__$1;
if(cljs.core.not(src__$1)){
return sources_to_get__$2;
} else {
var map__45204 = src__$1;
var map__45204__$1 = (((((!((map__45204 == null))))?(((((map__45204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45204.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45204):map__45204);
var ns = cljs.core.get.call(null,map__45204__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__45204__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var deps = cljs.core.get.call(null,map__45204__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var provides = cljs.core.get.call(null,map__45204__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var should_reload_QMARK_ = (function (){var or__4126__auto__ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.not(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_.call(null,src__$1));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
var and__4115__auto__ = (function (){var or__4126__auto____$2 = cljs.core.contains_QMARK_.call(null,compiled,resource_id);
if(or__4126__auto____$2){
return or__4126__auto____$2;
} else {
return cljs.core.some.call(null,affected__$2,deps);
}
})();
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src__$1));
} else {
return and__4115__auto__;
}
}
}
})();
if(cljs.core.not(should_reload_QMARK_)){
var G__45464 = affected__$2;
var G__45465 = sources_to_get__$2;
var G__45466 = more__$1;
affected__$1 = G__45464;
sources_to_get__$1 = G__45465;
G__45155__$1 = G__45466;
continue;
} else {
var G__45468 = clojure.set.union.call(null,affected__$2,provides);
var G__45469 = cljs.core.conj.call(null,sources_to_get__$2,src__$1);
var G__45470 = more__$1;
affected__$1 = G__45468;
sources_to_get__$1 = G__45469;
G__45155__$1 = G__45470;
continue;
}
}
break;
}
});
shadow.cljs.devtools.client.env.filter_reload_sources = (function shadow$cljs$devtools$client$env$filter_reload_sources(info,reload_info){
if(cljs.core._EQ_.call(null,"full",shadow.cljs.devtools.client.env.reload_strategy)){
return shadow.cljs.devtools.client.env.filter_sources_to_get_full.call(null,info,reload_info);
} else {
return shadow.cljs.devtools.client.env.filter_sources_to_get_optimized.call(null,info,reload_info);
}
});

//# sourceMappingURL=shadow.cljs.devtools.client.env.js.map
