goog.provide('com.wsscode.pathom3.interface$.smart_map');

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode-cached","com.wsscode.pathom3.interface.smart-map/keys-mode-cached",2034157318),"null",new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode-reachable","com.wsscode.pathom3.interface.smart-map/keys-mode-reachable",1014945831),"null"], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode-cached","com.wsscode.pathom3.interface.smart-map/keys-mode-cached",2034157318),null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode-reachable","com.wsscode.pathom3.interface.smart-map/keys-mode-reachable",1014945831),null], null), null));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom3.interface.smart-map","with-keys-mode","com.wsscode.pathom3.interface.smart-map/with-keys-mode",-1519822492,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),null,null,null));


/**
 * Configure how the Smart Map should respond to `keys`.
 * 
 *   Available modes:
 * 
 *   ::keys-mode-cached (default): in this mode, keys will return only the keys that are
 *   currently cached in the Smart Map. This is the safest mode, given it will only
 *   read things from memory.
 * 
 *   ::keys-mode-reachable: in this mode, keys will list all possible keys that Pathom can
 *   reach given the current indexes and available data. Be careful with this mode, on large
 *   graphs there is a risk that a scan operation (like printing it) may trigger a large amount of resolver
 *   processing.
 * @type {function(!cljs.core.IMap, *): !cljs.core.IMap}
 */
com.wsscode.pathom3.interface$.smart_map.with_keys_mode = (function com$wsscode$pathom3$interface$smart_map$with_keys_mode(env,key_mode){
var map__69821 = cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"key-mode","key-mode",1967248630),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),null,null,null);
var map__69821__$1 = (((((!((map__69821 == null))))?(((((map__69821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69821):map__69821);
var argspec69815 = cljs.core.get.call(null,map__69821__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var retspec69816 = cljs.core.get.call(null,map__69821__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
if(cljs.core.truth_(argspec69815)){
com.fulcrologic.guardrails.core.run_check.call(null,true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:22 with-keys-mode's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),argspec69815,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [env,key_mode], null));
} else {
}

var f69818 = (function (env__$1,key_mode__$1){
return cljs.core.assoc.call(null,env__$1,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272),key_mode__$1);
});
var ret69817 = f69818(env,key_mode);
if(cljs.core.truth_(retspec69816)){
com.fulcrologic.guardrails.core.run_check.call(null,false,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:22 with-keys-mode's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),retspec69816,ret69817);
} else {
}

return ret69817;
});
/**
 * If x is a composite data structure, return the data wrapped by smart maps.
 */
com.wsscode.pathom3.interface$.smart_map.wrap_smart_map = (function com$wsscode$pathom3$interface$smart_map$wrap_smart_map(env,x){
if(com.wsscode.misc.core.native_map_QMARK_.call(null,x)){
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,env,x);
} else {
if(cljs.core.sequential_QMARK_.call(null,x)){
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.mapv.call(null,(function (p1__69823_SHARP_){
return com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,p1__69823_SHARP_);
}),x);
} else {
return cljs.core.map.call(null,(function (p1__69824_SHARP_){
return com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,p1__69824_SHARP_);
}),x);
}
} else {
if(cljs.core.set_QMARK_.call(null,x)){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,(function (p1__69825_SHARP_){
return com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,p1__69825_SHARP_);
})),x);
} else {
return x;

}
}
}
});
/**
 * Get a property from a smart map.
 * 
 *   First it checks if the property is available in the cache-tree, if not it triggers
 *   the connect engine to lookup for the property. After the lookup is triggered the
 *   cache-tree will be updated in place, note this has a mutable effect in this data,
 *   but this change is consistent.
 * 
 *   Repeated lookups will use the cache-tree and should be as fast as reading from a
 *   regular Clojure map.
 */
com.wsscode.pathom3.interface$.smart_map.sm_get = (function com$wsscode$pathom3$interface$smart_map$sm_get(var_args){
var G__69827 = arguments.length;
switch (G__69827) {
case 2:
return com.wsscode.pathom3.interface$.smart_map.sm_get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return com.wsscode.pathom3.interface$.smart_map.sm_get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.pathom3.interface$.smart_map.sm_get.cljs$core$IFn$_invoke$arity$2 = (function (env,k){
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,env,k,null);
}));

(com.wsscode.pathom3.interface$.smart_map.sm_get.cljs$core$IFn$_invoke$arity$3 = (function (p__69828,k,default_value){
var map__69829 = p__69828;
var map__69829__$1 = (((((!((map__69829 == null))))?(((((map__69829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69829):map__69829);
var env = map__69829__$1;
var entity_tree_STAR_ = cljs.core.get.call(null,map__69829__$1,new cljs.core.Keyword("com.wsscode.pathom3.entity-tree","entity-tree*","com.wsscode.pathom3.entity-tree/entity-tree*",1259415691));
var ent_tree = cljs.core.deref.call(null,entity_tree_STAR_);
var temp__5718__auto__ = cljs.core.find.call(null,ent_tree,k);
if(cljs.core.truth_(temp__5718__auto__)){
var x = temp__5718__auto__;
return com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,cljs.core.val.call(null,x));
} else {
var ast = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"prop","prop",-515168332),new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),k,new cljs.core.Keyword(null,"key","key",-1516042587),k], null)], null)], null);
com.wsscode.pathom3.connect.runner.run_graph_BANG_.call(null,env,ast,entity_tree_STAR_);

return com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,cljs.core.get.call(null,cljs.core.deref.call(null,entity_tree_STAR_),k,default_value));
}
}));

(com.wsscode.pathom3.interface$.smart_map.sm_get.cljs$lang$maxFixedArity = 3);

/**
 * Creates a new smart map by adding k v to the initial context.
 * 
 *   When you read information in the smart map, that information is cached into an internal
 *   atom, and any dependencies that were required to get to the requested data is also
 *   included in this atom.
 * 
 *   When you assoc into a smart map, it will discard all the data loaded by Pathom itself
 *   and will be like you have assoced in the original map and created a new smart object.
 */
com.wsscode.pathom3.interface$.smart_map.sm_assoc = (function com$wsscode$pathom3$interface$smart_map$sm_assoc(env,k,v){
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,env,cljs.core.assoc.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","source-context","com.wsscode.pathom3.interface.smart-map/source-context",2024777912).cljs$core$IFn$_invoke$arity$1(env),k,v));
});
/**
 * Creates a new smart map by adding k v to the initial context.
 * 
 *   When you read information in the smart map, that information is cached into an internal
 *   atom, and any dependencies that were required to get to the requested data is also
 *   included in this atom.
 * 
 *   When you assoc into a smart map, it will discard all the data loaded by Pathom itself
 *   and will be like you have assoced in the original map and created a new smart object.
 */
com.wsscode.pathom3.interface$.smart_map.sm_dissoc = (function com$wsscode$pathom3$interface$smart_map$sm_dissoc(env,k){
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,env,cljs.core.dissoc.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","source-context","com.wsscode.pathom3.interface.smart-map/source-context",2024777912).cljs$core$IFn$_invoke$arity$1(env),k));
});
/**
 * Retrieve the keys in the smart map cache-tree.
 */
com.wsscode.pathom3.interface$.smart_map.sm_keys = (function com$wsscode$pathom3$interface$smart_map$sm_keys(p__69831){
var map__69832 = p__69831;
var map__69832__$1 = (((((!((map__69832 == null))))?(((((map__69832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69832):map__69832);
var env = map__69832__$1;
var keys_mode = cljs.core.get.call(null,map__69832__$1,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode","com.wsscode.pathom3.interface.smart-map/keys-mode",-1726018272));
var G__69834 = keys_mode;
var G__69834__$1 = (((G__69834 instanceof cljs.core.Keyword))?G__69834.fqn:null);
switch (G__69834__$1) {
case "com.wsscode.pathom3.interface.smart-map/keys-mode-reachable":
return com.wsscode.pathom3.connect.indexes.reachable_attributes.call(null,env,com.wsscode.pathom3.entity_tree.entity.call(null,env));

break;
default:
return cljs.core.keys.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,env));

}
});
/**
 * Check if a property is present in the cache-tree.
 */
com.wsscode.pathom3.interface$.smart_map.sm_contains_QMARK_ = (function com$wsscode$pathom3$interface$smart_map$sm_contains_QMARK_(env,k){
return cljs.core.contains_QMARK_.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,env),k);
});
/**
 * Returns meta data of smart map, which is the same as the meta data from context
 * map used to create the smart map.
 */
com.wsscode.pathom3.interface$.smart_map.sm_meta = (function com$wsscode$pathom3$interface$smart_map$sm_meta(env){
return cljs.core.meta.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,env));
});
/**
 * Return a new smart-map with the given meta.
 */
com.wsscode.pathom3.interface$.smart_map.sm_with_meta = (function com$wsscode$pathom3$interface$smart_map$sm_with_meta(env,meta){
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,env,cljs.core.with_meta.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,env),meta));
});
/**
 * Check if attribute can be found in the smart map.
 */
com.wsscode.pathom3.interface$.smart_map.sm_find = (function com$wsscode$pathom3$interface$smart_map$sm_find(env,k){
if(((com.wsscode.pathom3.interface$.smart_map.sm_contains_QMARK_.call(null,env,k)) || (com.wsscode.pathom3.connect.indexes.attribute_reachable_QMARK_.call(null,env,com.wsscode.pathom3.entity_tree.entity.call(null,env),k)))){
return com.wsscode.misc.core.make_map_entry.call(null,k,com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,env,k));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
com.wsscode.pathom3.interface$.smart_map.SmartMapEntry = (function (env,key){
this.env = env;
this.key = key;
this.cljs$lang$protocol_mask$partition0$ = 162425631;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__69836 = k;
switch (G__69836) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),cljs.core._val(node__$1),null));

break;
default:
return null;

}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.indexOf = (function() {
var G__69893 = null;
var G__69893__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__69893__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__69893 = function(x,start){
switch(arguments.length){
case 1:
return G__69893__1.call(this,x);
case 2:
return G__69893__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__69893.cljs$core$IFn$_invoke$arity$1 = G__69893__1;
G__69893.cljs$core$IFn$_invoke$arity$2 = G__69893__2;
return G__69893;
})()
);

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.lastIndexOf = (function() {
var G__69894 = null;
var G__69894__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__69894__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__69894 = function(x,start){
switch(arguments.length){
case 1:
return G__69894__1.call(this,x);
case 2:
return G__69894__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__69894.cljs$core$IFn$_invoke$arity$1 = G__69894__1;
G__69894.cljs$core$IFn$_invoke$arity$2 = G__69894__2;
return G__69894;
})()
);

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth(node__$1,k,null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth(node__$1,k,not_found);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return cljs.core._val(node__$1);
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return cljs.core._val(node__$1);
} else {
return not_found;

}
}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return cljs.core._assoc_n(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,cljs.core._val(node__$1)], null),n,v);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,self__.env,self__.key);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._val(node__$1);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([cljs.core._val(node__$1),self__.key],(0),null));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f,start);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,cljs.core._val(node__$1)], null),k,v);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,cljs.core._val(node__$1)],(0),null));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,cljs.core._val(node__$1)], null),meta);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,cljs.core.val,o], null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.call = (function (unused__10669__auto__){
var self__ = this;
var self__ = this;
var G__69837 = (arguments.length - (1));
switch (G__69837) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.apply = (function (self__,args69835){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args69835)));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return cljs.core._nth(node,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return cljs.core._nth(node,k,not_found);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"env","env",-175281708,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.cljs$lang$type = true);

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.cljs$lang$ctorStr = "com.wsscode.pathom3.interface.smart-map/SmartMapEntry");

(com.wsscode.pathom3.interface$.smart_map.SmartMapEntry.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.wsscode.pathom3.interface.smart-map/SmartMapEntry");
}));

/**
 * Positional factory function for com.wsscode.pathom3.interface.smart-map/SmartMapEntry.
 */
com.wsscode.pathom3.interface$.smart_map.__GT_SmartMapEntry = (function com$wsscode$pathom3$interface$smart_map$__GT_SmartMapEntry(env,key){
return (new com.wsscode.pathom3.interface$.smart_map.SmartMapEntry(env,key));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
com.wsscode.pathom3.interface$.smart_map.SmartMap = (function (env){
this.env = env;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IFind$_find$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_find.call(null,self__.env,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.toString = (function (){
var self__ = this;
var _ = this;
return cljs.core.pr_str_STAR_.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.equiv = (function (other){
var self__ = this;
var _ = this;
return cljs.core._equiv(com.wsscode.pathom3.entity_tree.entity.call(null,self__.env),other);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.keys = (function (){
var self__ = this;
var _ = this;
return cljs.core.es6_iterator.call(null,com.wsscode.pathom3.interface$.smart_map.sm_keys.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.entries = (function (){
var self__ = this;
var _ = this;
return cljs.core.es6_entries_iterator.call(null,cljs.core.seq.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env)));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.values = (function (){
var self__ = this;
var _ = this;
return cljs.core.es6_iterator.call(null,cljs.core.vals.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env)));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.has = (function (k){
var self__ = this;
var _ = this;
return com.wsscode.pathom3.interface$.smart_map.sm_contains_QMARK_.call(null,self__.env,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.get = (function (k,not_found){
var self__ = this;
var _ = this;
return cljs.core._lookup(com.wsscode.pathom3.entity_tree.entity.call(null,self__.env),k,not_found);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.forEach = (function (f){
var self__ = this;
var _ = this;
var seq__69841 = cljs.core.seq.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
var chunk__69842 = null;
var count__69843 = (0);
var i__69844 = (0);
while(true){
if((i__69844 < count__69843)){
var vec__69851 = cljs.core._nth(chunk__69842,i__69844);
var k = cljs.core.nth.call(null,vec__69851,(0),null);
var v = cljs.core.nth.call(null,vec__69851,(1),null);
f.call(null,v,k);


var G__69898 = seq__69841;
var G__69899 = chunk__69842;
var G__69900 = count__69843;
var G__69901 = (i__69844 + (1));
seq__69841 = G__69898;
chunk__69842 = G__69899;
count__69843 = G__69900;
i__69844 = G__69901;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__69841);
if(temp__5720__auto__){
var seq__69841__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69841__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__69841__$1);
var G__69902 = cljs.core.chunk_rest.call(null,seq__69841__$1);
var G__69903 = c__4556__auto__;
var G__69904 = cljs.core.count.call(null,c__4556__auto__);
var G__69905 = (0);
seq__69841 = G__69902;
chunk__69842 = G__69903;
count__69843 = G__69904;
i__69844 = G__69905;
continue;
} else {
var vec__69854 = cljs.core.first.call(null,seq__69841__$1);
var k = cljs.core.nth.call(null,vec__69854,(0),null);
var v = cljs.core.nth.call(null,vec__69854,(1),null);
f.call(null,v,k);


var G__69906 = cljs.core.next.call(null,seq__69841__$1);
var G__69907 = null;
var G__69908 = (0);
var G__69909 = (0);
seq__69841 = G__69906;
chunk__69842 = G__69907;
count__69843 = G__69908;
i__69844 = G__69909;
continue;
}
} else {
return null;
}
}
break;
}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,self__.env,k,null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,not_found){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,self__.env,k,not_found);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.reduce_kv.call(null,(function (cur,k,v){
return f.call(null,cur,k,com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,self__.env,v));
}),init,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.transformer_iterator.call(null,cljs.core.map.call(null,(function (p1__69839_SHARP_){
return (new com.wsscode.pathom3.interface$.smart_map.SmartMapEntry(self__.env,p1__69839_SHARP_));
})),cljs.core._iterator(com.wsscode.pathom3.interface$.smart_map.sm_keys.call(null,self__.env)),false);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_meta.call(null,self__.env);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,self__.env,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.count.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash.call(null,com.wsscode.pathom3.entity_tree.entity.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
return cljs.core._equiv(com.wsscode.pathom3.entity_tree.entity.call(null,self__.env),other);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core._with_meta(com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,self__.env,cljs.core.PersistentArrayMap.EMPTY),cljs.core.meta);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.call(null,coll__$1,f);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.call(null,coll__$1,f,start);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_dissoc.call(null,self__.env,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_assoc.call(null,self__.env,k,v);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_contains_QMARK_.call(null,self__.env,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.map.call(null,(function (p1__69838_SHARP_){
return (new com.wsscode.pathom3.interface$.smart_map.SmartMapEntry(self__.env,p1__69838_SHARP_));
}),com.wsscode.pathom3.interface$.smart_map.sm_keys.call(null,self__.env));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return com.wsscode.pathom3.interface$.smart_map.sm_with_meta.call(null,self__.env,new_meta);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq.call(null,entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first.call(null,es);
if(cljs.core.vector_QMARK_.call(null,e)){
var G__69910 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__69911 = cljs.core.next.call(null,es);
ret = G__69910;
es = G__69911;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.call = (function (unused__10669__auto__){
var self__ = this;
var self__ = this;
var G__69857 = (arguments.length - (1));
switch (G__69857) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.apply = (function (self__,args69840){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args69840)));
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,self__.env,k);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var _ = this;
return com.wsscode.pathom3.interface$.smart_map.sm_get.call(null,self__.env,k,not_found);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"env","env",-175281708,null)], null);
}));

(com.wsscode.pathom3.interface$.smart_map.SmartMap.cljs$lang$type = true);

(com.wsscode.pathom3.interface$.smart_map.SmartMap.cljs$lang$ctorStr = "com.wsscode.pathom3.interface.smart-map/SmartMap");

(com.wsscode.pathom3.interface$.smart_map.SmartMap.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.wsscode.pathom3.interface.smart-map/SmartMap");
}));

/**
 * Positional factory function for com.wsscode.pathom3.interface.smart-map/SmartMap.
 */
com.wsscode.pathom3.interface$.smart_map.__GT_SmartMap = (function com$wsscode$pathom3$interface$smart_map$__GT_SmartMap(env){
return (new com.wsscode.pathom3.interface$.smart_map.SmartMap(env));
});

com.wsscode.pathom3.interface$.smart_map.smart_map_QMARK_ = (function com$wsscode$pathom3$interface$smart_map$smart_map_QMARK_(x){
return (x instanceof com.wsscode.pathom3.interface$.smart_map.SmartMap);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),new cljs.core.Symbol("com.wsscode.pathom3.interface.smart-map","smart-map?","com.wsscode.pathom3.interface.smart-map/smart-map?",-82729690,null),com.wsscode.pathom3.interface$.smart_map.smart_map_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom3.interface.smart-map","sm-env","com.wsscode.pathom3.interface.smart-map/sm-env",1528066351,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),null,null,null));


/**
 * Extract the env map from the smart map.
 * @type {function(*): !cljs.core.IMap}
 */
com.wsscode.pathom3.interface$.smart_map.sm_env = (function com$wsscode$pathom3$interface$smart_map$sm_env(smart_map){
var map__69862 = cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"smart-map","smart-map",-1020965746),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),null,null,null);
var map__69862__$1 = (((((!((map__69862 == null))))?(((((map__69862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69862):map__69862);
var retspec69859 = cljs.core.get.call(null,map__69862__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var argspec69858 = cljs.core.get.call(null,map__69862__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_(argspec69858)){
com.fulcrologic.guardrails.core.run_check.call(null,true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:334 sm-env's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),argspec69858,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [smart_map], null));
} else {
}

var f69861 = (function (smart_map__$1){
return smart_map__$1.env;
});
var ret69860 = f69861(smart_map);
if(cljs.core.truth_(retspec69859)){
com.fulcrologic.guardrails.core.run_check.call(null,false,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:334 sm-env's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),retspec69859,ret69860);
} else {
}

return ret69860;
});
/**
 * Return the a map containing the value of the key requested, plus the graph running
 *   analysis, use for debugging. Note that if the value is cached, there will be a blank
 *   stats.
 */
com.wsscode.pathom3.interface$.smart_map.sm_get_debug = (function com$wsscode$pathom3$interface$smart_map$sm_get_debug(sm,k){
var map__69864 = com.wsscode.pathom3.interface$.smart_map.sm_env.call(null,sm);
var map__69864__$1 = (((((!((map__69864 == null))))?(((((map__69864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69864.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69864):map__69864);
var env = map__69864__$1;
var entity_tree_STAR_ = cljs.core.get.call(null,map__69864__$1,new cljs.core.Keyword("com.wsscode.pathom3.entity-tree","entity-tree*","com.wsscode.pathom3.entity-tree/entity-tree*",1259415691));
var ast = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"prop","prop",-515168332),new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),k,new cljs.core.Keyword(null,"key","key",-1516042587),k], null)], null)], null);
var run_stats = com.wsscode.pathom3.connect.runner.run_graph_BANG_.call(null,env,ast,entity_tree_STAR_);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.pathom3.connect.runner","run-stats","com.wsscode.pathom3.connect.runner/run-stats",1718909061),com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,com.wsscode.pathom3.interface$.smart_map.with_keys_mode.call(null,com.wsscode.pathom3.connect.runner.stats.stats_index,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","keys-mode-reachable","com.wsscode.pathom3.interface.smart-map/keys-mode-reachable",1014945831)),run_stats),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","value","com.wsscode.pathom3.interface.smart-map/value",644642267),com.wsscode.pathom3.interface$.smart_map.wrap_smart_map.call(null,env,cljs.core.get.call(null,cljs.core.deref.call(null,entity_tree_STAR_),k))], null);
});
/**
 * Assoc on the smart map in place, this function mutates the current cache and return
 *   the same instance of smart map.
 * 
 *   You should use this only in cases where the optimization is required, try starting
 *   with the immutable versions first, given this has side effects and so more error phone.
 */
com.wsscode.pathom3.interface$.smart_map.sm_assoc_BANG_ = (function com$wsscode$pathom3$interface$smart_map$sm_assoc_BANG_(smart_map,k,v){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword("com.wsscode.pathom3.entity-tree","entity-tree*","com.wsscode.pathom3.entity-tree/entity-tree*",1259415691).cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.interface$.smart_map.sm_env.call(null,smart_map)),cljs.core.assoc,k,v);

return smart_map;
});
/**
 * Dissoc on the smart map in place, this function mutates the current cache and return
 *   the same instance of smart map.
 * 
 *   You should use this only in cases where the optimization is required, try starting
 *   with the immutable versions first, given this has side effects and so more error phone.
 */
com.wsscode.pathom3.interface$.smart_map.sm_dissoc_BANG_ = (function com$wsscode$pathom3$interface$smart_map$sm_dissoc_BANG_(smart_map,k){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword("com.wsscode.pathom3.entity-tree","entity-tree*","com.wsscode.pathom3.entity-tree/entity-tree*",1259415691).cljs$core$IFn$_invoke$arity$1(com.wsscode.pathom3.interface$.smart_map.sm_env.call(null,smart_map)),cljs.core.dissoc,k);

return smart_map;
});
com.wsscode.pathom3.interface$.smart_map.sm_touch_ast_BANG_ = (function com$wsscode$pathom3$interface$smart_map$sm_touch_ast_BANG_(smart_map,ast){
var env = com.wsscode.pathom3.interface$.smart_map.sm_env.call(null,smart_map);
com.wsscode.pathom3.connect.runner.run_graph_BANG_.call(null,env,ast,new cljs.core.Keyword("com.wsscode.pathom3.entity-tree","entity-tree*","com.wsscode.pathom3.entity-tree/entity-tree*",1259415691).cljs$core$IFn$_invoke$arity$1(env));

return smart_map;
});
/**
 * Will pre-fetch data in a smart map, given the EQL request. Use this to optimize the
 *   load of data ahead of time, instead of pulling one by one lazily.
 */
com.wsscode.pathom3.interface$.smart_map.sm_touch_BANG_ = (function com$wsscode$pathom3$interface$smart_map$sm_touch_BANG_(smart_map,eql){
return com.wsscode.pathom3.interface$.smart_map.sm_touch_ast_BANG_.call(null,smart_map,edn_query_language.core.query__GT_ast.call(null,eql));
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",1759270567,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),new cljs.core.Keyword(null,"arity-2","arity-2",-1366521503),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),new cljs.core.Keyword(null,"arity-2","arity-2",-1366521503),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))),cljs.spec.alpha.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"arity-1","arity-1",105892478),new cljs.core.Keyword(null,"arity-2","arity-2",-1366521503)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__69875){
return cljs.core.map_QMARK_.call(null,G__69875);
})], null),(function (G__69875){
return cljs.core.map_QMARK_.call(null,G__69875);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)]))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))], null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"context","context",-830191113)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__69876){
return cljs.core.map_QMARK_.call(null,G__69876);
})], null),(function (G__69876){
return cljs.core.map_QMARK_.call(null,G__69876);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)])),cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null))], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","or","cljs.spec.alpha/or",-831679639,null),new cljs.core.Keyword(null,"arity-1","arity-1",105892478),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),new cljs.core.Keyword(null,"arity-2","arity-2",-1366521503),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null))),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null,null));


/**
 * Create a new smart map.
 * 
 *   Smart maps are a special data structure that realizes properties using Pathom resolvers.
 * 
 *   They work like maps and can be used interchangeable with it.
 * 
 *   To create a smart map you need send an environment with the indexes and a context
 *   map with the initial context data:
 * 
 *    (smart-map (pci/register [resolver1 resolver2]) {:some "context"})
 * 
 *   When the value of a property of the smart map is a map, that map will also be cast
 *   into a smart map, including maps inside collections.
 */
com.wsscode.pathom3.interface$.smart_map.smart_map = (function com$wsscode$pathom3$interface$smart_map$smart_map(var_args){
var G__69878 = arguments.length;
switch (G__69878) {
case 1:
return com.wsscode.pathom3.interface$.smart_map.smart_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.pathom3.interface$.smart_map.smart_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.pathom3.interface$.smart_map.smart_map.cljs$core$IFn$_invoke$arity$1 = (function (env){
var map__69879 = cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__69880){
return cljs.core.map_QMARK_.call(null,G__69880);
})], null),(function (G__69880){
return cljs.core.map_QMARK_.call(null,G__69880);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)]))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null))),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null,null);
var map__69879__$1 = (((((!((map__69879 == null))))?(((((map__69879.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69879.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69879):map__69879);
var argspec69867 = cljs.core.get.call(null,map__69879__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var retspec69868 = cljs.core.get.call(null,map__69879__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
if(cljs.core.truth_(argspec69867)){
com.fulcrologic.guardrails.core.run_check.call(null,true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:387 smart-map's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),argspec69867,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [env], null));
} else {
}

var f69870 = (function (env__$1){
return com.wsscode.pathom3.interface$.smart_map.smart_map.call(null,env__$1,cljs.core.PersistentArrayMap.EMPTY);
});
var ret69869 = f69870(env);
if(cljs.core.truth_(retspec69868)){
com.fulcrologic.guardrails.core.run_check.call(null,false,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:387 smart-map's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),retspec69868,ret69869);
} else {
}

return ret69869;
}));

(com.wsscode.pathom3.interface$.smart_map.smart_map.cljs$core$IFn$_invoke$arity$2 = (function (env,context){
var map__69882 = cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"env","env",-1815813235),new cljs.core.Keyword(null,"context","context",-830191113)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.map_spec_impl.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"req-un","req-un",1074571008),new cljs.core.Keyword(null,"opt-un","opt-un",883442496),new cljs.core.Keyword(null,"gfn","gfn",791517474),new cljs.core.Keyword(null,"pred-exprs","pred-exprs",1792271395),new cljs.core.Keyword(null,"keys-pred","keys-pred",858984739),new cljs.core.Keyword(null,"opt-keys","opt-keys",1262688261),new cljs.core.Keyword(null,"req-specs","req-specs",553962313),new cljs.core.Keyword(null,"req","req",-326448303),new cljs.core.Keyword(null,"req-keys","req-keys",514319221),new cljs.core.Keyword(null,"opt-specs","opt-specs",-384905450),new cljs.core.Keyword(null,"pred-forms","pred-forms",172611832),new cljs.core.Keyword(null,"opt","opt",-794706369)],[null,null,null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (G__69883){
return cljs.core.map_QMARK_.call(null,G__69883);
})], null),(function (G__69883){
return cljs.core.map_QMARK_.call(null,G__69883);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),cljs.core.PersistentVector.EMPTY,null,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol(null,"%","%",-950237169,null)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)])),cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","keys","cljs.spec.alpha/keys",1109346032,null),new cljs.core.Keyword(null,"opt","opt",-794706369),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("com.wsscode.pathom3.connect.indexes","index-oir","com.wsscode.pathom3.connect.indexes/index-oir",-418434909)], null)),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null)),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","smart-map","com.wsscode.pathom3.interface.smart-map/smart-map",118739040),null,null,null);
var map__69882__$1 = (((((!((map__69882 == null))))?(((((map__69882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69882):map__69882);
var argspec69871 = cljs.core.get.call(null,map__69882__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var retspec69872 = cljs.core.get.call(null,map__69882__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
if(cljs.core.truth_(argspec69871)){
com.fulcrologic.guardrails.core.run_check.call(null,true,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:387 smart-map's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),argspec69871,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [env,context], null));
} else {
}

var f69874 = (function (env__$1,context__$1){
return com.wsscode.pathom3.interface$.smart_map.__GT_SmartMap.call(null,cljs.core.assoc.call(null,com.wsscode.pathom3.entity_tree.with_entity.call(null,env__$1,context__$1),new cljs.core.Keyword("com.wsscode.pathom3.interface.smart-map","source-context","com.wsscode.pathom3.interface.smart-map/source-context",2024777912),context__$1));
});
var ret69873 = f69874(env,context);
if(cljs.core.truth_(retspec69872)){
com.fulcrologic.guardrails.core.run_check.call(null,false,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),"com/wsscode/pathom3/interface/smart_map.cljc:387 smart-map's",new cljs.core.Keyword(null,"emit-spec?","emit-spec?",-837774868),true,new cljs.core.Keyword(null,"log-level","log-level",862121670),null,new cljs.core.Keyword(null,"throw?","throw?",-2036749118),true,new cljs.core.Keyword(null,"vararg?","vararg?",1908105777),false], null),retspec69872,ret69873);
} else {
}

return ret69873;
}));

(com.wsscode.pathom3.interface$.smart_map.smart_map.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.wsscode.pathom3.interface.smart_map.js.map
