goog.provide('com.wsscode.misc.core');
com.wsscode.misc.core.atom_QMARK_ = (function com$wsscode$misc$core$atom_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (32768))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IDeref$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,x);
}
});
com.wsscode.misc.core.cljc_random_uuid = (function com$wsscode$misc$core$cljc_random_uuid(){
return cljs.core.random_uuid.call(null);
});
/**
 * Returns a lazy sequence of the elements of coll, removing any elements that
 *   return duplicate values when passed to a function f.
 */
com.wsscode.misc.core.distinct_by = (function com$wsscode$misc$core$distinct_by(var_args){
var G__67383 = arguments.length;
switch (G__67383) {
case 1:
return com.wsscode.misc.core.distinct_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.core.distinct_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.core.distinct_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return (function() {
var G__67396 = null;
var G__67396__0 = (function (){
return rf.call(null);
});
var G__67396__1 = (function (result){
return rf.call(null,result);
});
var G__67396__2 = (function (result,x){
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,seen),fx)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.call(null,cljs.core._deref(seen),fx));

return rf.call(null,result,x);
}
});
G__67396 = function(result,x){
switch(arguments.length){
case 0:
return G__67396__0.call(this);
case 1:
return G__67396__1.call(this,result);
case 2:
return G__67396__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__67396.cljs$core$IFn$_invoke$arity$0 = G__67396__0;
G__67396.cljs$core$IFn$_invoke$arity$1 = G__67396__1;
G__67396.cljs$core$IFn$_invoke$arity$2 = G__67396__2;
return G__67396;
})()
});
}));

(com.wsscode.misc.core.distinct_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var step = (function com$wsscode$misc$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__67384,seen__$1){
while(true){
var vec__67385 = p__67384;
var x = cljs.core.nth.call(null,vec__67385,(0),null);
var xs__$1 = vec__67385;
var temp__5720__auto__ = cljs.core.seq.call(null,xs__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var fx = f.call(null,x);
if(cljs.core.contains_QMARK_.call(null,seen__$1,fx)){
var G__67397 = cljs.core.rest.call(null,s);
var G__67398 = seen__$1;
p__67384 = G__67397;
seen__$1 = G__67398;
continue;
} else {
return cljs.core.cons.call(null,x,com$wsscode$misc$core$step.call(null,cljs.core.rest.call(null,s),cljs.core.conj.call(null,seen__$1,fx)));
}
} else {
return null;
}
break;
}
})(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
}));

(com.wsscode.misc.core.distinct_by.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence removing consecutive duplicates in coll when passed to a function f.
 *   Returns a transducer when no collection is provided.
 */
com.wsscode.misc.core.dedupe_by = (function com$wsscode$misc$core$dedupe_by(var_args){
var G__67389 = arguments.length;
switch (G__67389) {
case 1:
return com.wsscode.misc.core.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.core.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.core.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var pv = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword("com.wsscode.misc.core","none","com.wsscode.misc.core/none",1151350520));
return (function() {
var G__67400 = null;
var G__67400__0 = (function (){
return rf.call(null);
});
var G__67400__1 = (function (result){
return rf.call(null,result);
});
var G__67400__2 = (function (result,x){
var prior = cljs.core.deref.call(null,pv);
var fx = f.call(null,x);
cljs.core.vreset_BANG_.call(null,pv,fx);

if(cljs.core._EQ_.call(null,prior,fx)){
return result;
} else {
return rf.call(null,result,x);
}
});
G__67400 = function(result,x){
switch(arguments.length){
case 0:
return G__67400__0.call(this);
case 1:
return G__67400__1.call(this,result);
case 2:
return G__67400__2.call(this,result,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__67400.cljs$core$IFn$_invoke$arity$0 = G__67400__0;
G__67400.cljs$core$IFn$_invoke$arity$1 = G__67400__1;
G__67400.cljs$core$IFn$_invoke$arity$2 = G__67400__2;
return G__67400;
})()
});
}));

(com.wsscode.misc.core.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.sequence.call(null,com.wsscode.misc.core.dedupe_by.call(null,f),coll);
}));

(com.wsscode.misc.core.dedupe_by.cljs$lang$maxFixedArity = 2);

/**
 * Like group by, but will keep only the last result.
 */
com.wsscode.misc.core.index_by = (function com$wsscode$misc$core$index_by(f,coll){
return cljs.core.reduce.call(null,(function (m,x){
return cljs.core.assoc.call(null,m,f.call(null,x),x);
}),cljs.core.PersistentArrayMap.EMPTY,coll);
});
com.wsscode.misc.core.sconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY);
com.wsscode.misc.core.vconj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY);
/**
 * Return a blank immutable queue or create one from coll.
 */
com.wsscode.misc.core.queue = (function com$wsscode$misc$core$queue(var_args){
var G__67391 = arguments.length;
switch (G__67391) {
case 0:
return com.wsscode.misc.core.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.misc.core.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.core.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
}));

(com.wsscode.misc.core.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.call(null,com.wsscode.misc.core.queue.call(null),coll);
}));

(com.wsscode.misc.core.queue.cljs$lang$maxFixedArity = 1);

/**
 * CLJC helper to create MapEntry.
 */
com.wsscode.misc.core.make_map_entry = (function com$wsscode$misc$core$make_map_entry(k,v){
return (new cljs.core.MapEntry(k,v,null));
});
/**
 * Map over the given hash-map keys.
 * 
 *   Example:
 *  (map-keys #(str/replace (name %) "_" "-") {"foo_bar" 1}) => {"foo-bar" 1}
 *   
 */
com.wsscode.misc.core.map_keys = (function com$wsscode$misc$core$map_keys(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (x){
return com.wsscode.misc.core.make_map_entry.call(null,f.call(null,cljs.core.key.call(null,x)),cljs.core.val.call(null,x));
})),m);
});
/**
 * Map over the given hash-map vals.
 * 
 *   Example:
 *  (map-vals inc {:a 1 :b 2})
 *   
 */
com.wsscode.misc.core.map_vals = (function com$wsscode$misc$core$map_vals(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (x){
return com.wsscode.misc.core.make_map_entry.call(null,cljs.core.key.call(null,x),f.call(null,cljs.core.val.call(null,x)));
})),m);
});
/**
 * Return the map keys, as a set. This also checks if the entry is a map, otherwise
 *   returns nil (instead of throw).
 */
com.wsscode.misc.core.keys_set = (function com$wsscode$misc$core$keys_set(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.keys.call(null,m));
} else {
return null;
}
});
/**
 * Additive merging.
 * 
 *   When merging maps, it does a deep merge.
 *   When merging sets, makes a union of them.
 * 
 *   When value of the right side is nil, the left side will be kept.
 * 
 *   For the rest works as standard merge.
 */
com.wsscode.misc.core.merge_grow = (function com$wsscode$misc$core$merge_grow(var_args){
var G__67393 = arguments.length;
switch (G__67393) {
case 0:
return com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentArrayMap.EMPTY;
}));

(com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
}));

(com.wsscode.misc.core.merge_grow.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
if(((cljs.core.set_QMARK_.call(null,a)) && (cljs.core.set_QMARK_.call(null,b)))){
return clojure.set.union.call(null,a,b);
} else {
if(((cljs.core.map_QMARK_.call(null,a)) && (cljs.core.map_QMARK_.call(null,b)))){
return cljs.core.merge_with.call(null,com.wsscode.misc.core.merge_grow,a,b);
} else {
if((b == null)){
return a;
} else {
return b;

}
}
}
}));

(com.wsscode.misc.core.merge_grow.cljs$lang$maxFixedArity = 2);

/**
 * Does nothing.
 */
com.wsscode.misc.core.noop = (function com$wsscode$misc$core$noop(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67415 = arguments.length;
var i__4737__auto___67416 = (0);
while(true){
if((i__4737__auto___67416 < len__4736__auto___67415)){
args__4742__auto__.push((arguments[i__4737__auto___67416]));

var G__67417 = (i__4737__auto___67416 + (1));
i__4737__auto___67416 = G__67417;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.wsscode.misc.core.noop.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.wsscode.misc.core.noop.cljs$core$IFn$_invoke$arity$variadic = (function (_){
return null;
}));

(com.wsscode.misc.core.noop.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.wsscode.misc.core.noop.cljs$lang$applyTo = (function (seq67394){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67394));
}));

com.wsscode.misc.core.round = (function com$wsscode$misc$core$round(x){
return Math.round(x);
});
com.wsscode.misc.core.now_ms = (function com$wsscode$misc$core$now_ms(){
return cljs.core.system_time.call(null);
});
com.wsscode.misc.core.native_map_QMARK_ = (function com$wsscode$misc$core$native_map_QMARK_(x){
return (((x instanceof cljs.core.PersistentArrayMap)) || ((x instanceof cljs.core.PersistentHashMap)));
});

//# sourceMappingURL=com.wsscode.misc.core.js.map
