goog.provide('com.wsscode.js_interop.js_proxy');
if((typeof com !== 'undefined') && (typeof com.wsscode !== 'undefined') && (typeof com.wsscode.js_interop !== 'undefined') && (typeof com.wsscode.js_interop.js_proxy !== 'undefined') && (typeof com.wsscode.js_interop.js_proxy.kw_cache !== 'undefined')){
} else {
com.wsscode.js_interop.js_proxy.kw_cache = ({});
}
/**
 * Like keyword, but will cache the string for faster lookup after first usage.
 */
com.wsscode.js_interop.js_proxy.cached_keyword = (function com$wsscode$js_interop$js_proxy$cached_keyword(s){
var or__4126__auto__ = (com.wsscode.js_interop.js_proxy.kw_cache[s]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var kw = cljs.core.keyword.call(null,s);
goog.object.set(com.wsscode.js_interop.js_proxy.kw_cache,s,kw);

return kw;
}
});
/**
 * Wrapping on JS .push, arity design for compatibility with transducer usage.
 */
com.wsscode.js_interop.js_proxy.array_push = (function com$wsscode$js_interop$js_proxy$array_push(var_args){
var G__50326 = arguments.length;
switch (G__50326) {
case 1:
return com.wsscode.js_interop.js_proxy.array_push.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.js_interop.js_proxy.array_push.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.js_interop.js_proxy.array_push.cljs$core$IFn$_invoke$arity$1 = (function (res){
return res;
}));

(com.wsscode.js_interop.js_proxy.array_push.cljs$core$IFn$_invoke$arity$2 = (function (res,x){
var G__50327 = res;
G__50327.push(x);

return G__50327;
}));

(com.wsscode.js_interop.js_proxy.array_push.cljs$lang$maxFixedArity = 2);

/**
 * Its the into-array fn with add support for transducers.
 */
com.wsscode.js_interop.js_proxy.into_js_array = (function com$wsscode$js_interop$js_proxy$into_js_array(xform,from){
return cljs.core.transduce.call(null,xform,com.wsscode.js_interop.js_proxy.array_push,[],from);
});
/**
 * Proxy some Map Type from Clojurescript via JSON proxy API.
 */
com.wsscode.js_interop.js_proxy.js_proxy = (function com$wsscode$js_interop$js_proxy$js_proxy(x){
if(((cljs.core.sequential_QMARK_.call(null,x)) || (cljs.core.set_QMARK_.call(null,x)))){
return com.wsscode.js_interop.js_proxy.into_js_array.call(null,cljs.core.map.call(null,com.wsscode.js_interop.js_proxy.js_proxy),x);
} else {
if(cljs.core.associative_QMARK_.call(null,x)){
return com.wsscode.js_interop.js_proxy.map_proxy.call(null,x);
} else {
return x;

}
}
});
com.wsscode.js_interop.js_proxy.map_proxy_get = (function com$wsscode$js_interop$js_proxy$map_proxy_get(t,k){
var G__50328 = k;
switch (G__50328) {
case "__source-structure":
return t;

break;
default:
return com.wsscode.js_interop.js_proxy.js_proxy.call(null,cljs.core.get.call(null,t,com.wsscode.js_interop.js_proxy.cached_keyword.call(null,k)));

}
});
com.wsscode.js_interop.js_proxy.map_proxy_own_keys = (function com$wsscode$js_interop$js_proxy$map_proxy_own_keys(t,_,internal_cache){
var or__4126__auto__ = (internal_cache["__keys"]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var ks = com.wsscode.js_interop.js_proxy.into_js_array.call(null,cljs.core.map.call(null,(function (p1__50329_SHARP_){
return cljs.core.subs.call(null,cljs.core.pr_str.call(null,p1__50329_SHARP_),(1));
})),cljs.core.keys.call(null,t));
(internal_cache["__keys"] = ks);

return ks;
}
});
com.wsscode.js_interop.js_proxy.map_proxy_has = (function com$wsscode$js_interop$js_proxy$map_proxy_has(t,k){
return cljs.core.contains_QMARK_.call(null,t,com.wsscode.js_interop.js_proxy.cached_keyword.call(null,k));
});
com.wsscode.js_interop.js_proxy.map_proxy_property_descriptor = (function com$wsscode$js_interop$js_proxy$map_proxy_property_descriptor(t,k){
var temp__5718__auto__ = cljs.core.find.call(null,t,cljs.core.keyword.call(null,k));
if(cljs.core.truth_(temp__5718__auto__)){
var x = temp__5718__auto__;
return ({"value": cljs.core.val.call(null,x), "writable": true, "enumerable": true, "configurable": true});
} else {
return undefined;
}
});
/**
 * Creates a JS proxy to wrap a Clojurescript immutable map like data type.
 */
com.wsscode.js_interop.js_proxy.map_proxy = (function com$wsscode$js_interop$js_proxy$map_proxy(m){
var internal_cache = ({});
return (new Proxy(m,({"get": com.wsscode.js_interop.js_proxy.map_proxy_get, "ownKeys": (function (p1__50330_SHARP_,p2__50331_SHARP_){
return com.wsscode.js_interop.js_proxy.map_proxy_own_keys.call(null,p1__50330_SHARP_,p2__50331_SHARP_,internal_cache);
}), "has": com.wsscode.js_interop.js_proxy.map_proxy_has, "getOwnPropertyDescriptor": com.wsscode.js_interop.js_proxy.map_proxy_property_descriptor})));
});
/**
 * Shorter name for js-proxy.
 */
com.wsscode.js_interop.js_proxy.jsp = (function com$wsscode$js_interop$js_proxy$jsp(x){
return com.wsscode.js_interop.js_proxy.js_proxy.call(null,x);
});

//# sourceMappingURL=com.wsscode.js_interop.js_proxy.js.map
