goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__42216 = arguments.length;
switch (G__42216) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42220 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42220 = (function (f,blockable,meta42221){
this.f = f;
this.blockable = blockable;
this.meta42221 = meta42221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42222,meta42221__$1){
var self__ = this;
var _42222__$1 = this;
return (new cljs.core.async.t_cljs$core$async42220(self__.f,self__.blockable,meta42221__$1));
}));

(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42222){
var self__ = this;
var _42222__$1 = this;
return self__.meta42221;
}));

(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async42220.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async42220.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta42221","meta42221",1176662607,null)], null);
}));

(cljs.core.async.t_cljs$core$async42220.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42220.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42220");

(cljs.core.async.t_cljs$core$async42220.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42220");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42220.
 */
cljs.core.async.__GT_t_cljs$core$async42220 = (function cljs$core$async$__GT_t_cljs$core$async42220(f__$1,blockable__$1,meta42221){
return (new cljs.core.async.t_cljs$core$async42220(f__$1,blockable__$1,meta42221));
});

}

return (new cljs.core.async.t_cljs$core$async42220(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__42246 = arguments.length;
switch (G__42246) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__42253 = arguments.length;
switch (G__42253) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__42262 = arguments.length;
switch (G__42262) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_45517 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_45517);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_45517);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__42288 = arguments.length;
switch (G__42288) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___45527 = n;
var x_45528 = (0);
while(true){
if((x_45528 < n__4613__auto___45527)){
(a[x_45528] = x_45528);

var G__45529 = (x_45528 + (1));
x_45528 = G__45529;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42311 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42311 = (function (flag,meta42312){
this.flag = flag;
this.meta42312 = meta42312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42313,meta42312__$1){
var self__ = this;
var _42313__$1 = this;
return (new cljs.core.async.t_cljs$core$async42311(self__.flag,meta42312__$1));
}));

(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42313){
var self__ = this;
var _42313__$1 = this;
return self__.meta42312;
}));

(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42311.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async42311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta42312","meta42312",298670957,null)], null);
}));

(cljs.core.async.t_cljs$core$async42311.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42311.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42311");

(cljs.core.async.t_cljs$core$async42311.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42311");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42311.
 */
cljs.core.async.__GT_t_cljs$core$async42311 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async42311(flag__$1,meta42312){
return (new cljs.core.async.t_cljs$core$async42311(flag__$1,meta42312));
});

}

return (new cljs.core.async.t_cljs$core$async42311(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async42326 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42326 = (function (flag,cb,meta42327){
this.flag = flag;
this.cb = cb;
this.meta42327 = meta42327;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42328,meta42327__$1){
var self__ = this;
var _42328__$1 = this;
return (new cljs.core.async.t_cljs$core$async42326(self__.flag,self__.cb,meta42327__$1));
}));

(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42328){
var self__ = this;
var _42328__$1 = this;
return self__.meta42327;
}));

(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async42326.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async42326.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta42327","meta42327",-1557802727,null)], null);
}));

(cljs.core.async.t_cljs$core$async42326.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async42326.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42326");

(cljs.core.async.t_cljs$core$async42326.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async42326");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async42326.
 */
cljs.core.async.__GT_t_cljs$core$async42326 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async42326(flag__$1,cb__$1,meta42327){
return (new cljs.core.async.t_cljs$core$async42326(flag__$1,cb__$1,meta42327));
});

}

return (new cljs.core.async.t_cljs$core$async42326(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42337_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42337_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__42338_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42338_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__45543 = (i + (1));
i = G__45543;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45547 = arguments.length;
var i__4737__auto___45548 = (0);
while(true){
if((i__4737__auto___45548 < len__4736__auto___45547)){
args__4742__auto__.push((arguments[i__4737__auto___45548]));

var G__45564 = (i__4737__auto___45548 + (1));
i__4737__auto___45548 = G__45564;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__42362){
var map__42366 = p__42362;
var map__42366__$1 = (((((!((map__42366 == null))))?(((((map__42366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42366):map__42366);
var opts = map__42366__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq42355){
var G__42356 = cljs.core.first.call(null,seq42355);
var seq42355__$1 = cljs.core.next.call(null,seq42355);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42356,seq42355__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__42384 = arguments.length;
switch (G__42384) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__42104__auto___45588 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_42461){
var state_val_42462 = (state_42461[(1)]);
if((state_val_42462 === (7))){
var inst_42439 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
var statearr_42473_45591 = state_42461__$1;
(statearr_42473_45591[(2)] = inst_42439);

(statearr_42473_45591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (1))){
var state_42461__$1 = state_42461;
var statearr_42475_45600 = state_42461__$1;
(statearr_42475_45600[(2)] = null);

(statearr_42475_45600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (4))){
var inst_42412 = (state_42461[(7)]);
var inst_42412__$1 = (state_42461[(2)]);
var inst_42414 = (inst_42412__$1 == null);
var state_42461__$1 = (function (){var statearr_42484 = state_42461;
(statearr_42484[(7)] = inst_42412__$1);

return statearr_42484;
})();
if(cljs.core.truth_(inst_42414)){
var statearr_42485_45605 = state_42461__$1;
(statearr_42485_45605[(1)] = (5));

} else {
var statearr_42486_45610 = state_42461__$1;
(statearr_42486_45610[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (13))){
var state_42461__$1 = state_42461;
var statearr_42489_45613 = state_42461__$1;
(statearr_42489_45613[(2)] = null);

(statearr_42489_45613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (6))){
var inst_42412 = (state_42461[(7)]);
var state_42461__$1 = state_42461;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42461__$1,(11),to,inst_42412);
} else {
if((state_val_42462 === (3))){
var inst_42441 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42461__$1,inst_42441);
} else {
if((state_val_42462 === (12))){
var state_42461__$1 = state_42461;
var statearr_42495_45617 = state_42461__$1;
(statearr_42495_45617[(2)] = null);

(statearr_42495_45617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (2))){
var state_42461__$1 = state_42461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42461__$1,(4),from);
} else {
if((state_val_42462 === (11))){
var inst_42432 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
if(cljs.core.truth_(inst_42432)){
var statearr_42496_45620 = state_42461__$1;
(statearr_42496_45620[(1)] = (12));

} else {
var statearr_42498_45621 = state_42461__$1;
(statearr_42498_45621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (9))){
var state_42461__$1 = state_42461;
var statearr_42502_45622 = state_42461__$1;
(statearr_42502_45622[(2)] = null);

(statearr_42502_45622[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (5))){
var state_42461__$1 = state_42461;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42504_45624 = state_42461__$1;
(statearr_42504_45624[(1)] = (8));

} else {
var statearr_42512_45626 = state_42461__$1;
(statearr_42512_45626[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (14))){
var inst_42437 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
var statearr_42519_45628 = state_42461__$1;
(statearr_42519_45628[(2)] = inst_42437);

(statearr_42519_45628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (10))){
var inst_42429 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
var statearr_42521_45632 = state_42461__$1;
(statearr_42521_45632[(2)] = inst_42429);

(statearr_42521_45632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42462 === (8))){
var inst_42426 = cljs.core.async.close_BANG_.call(null,to);
var state_42461__$1 = state_42461;
var statearr_42525_45636 = state_42461__$1;
(statearr_42525_45636[(2)] = inst_42426);

(statearr_42525_45636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_42527 = [null,null,null,null,null,null,null,null];
(statearr_42527[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_42527[(1)] = (1));

return statearr_42527;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_42461){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42529){var ex__41878__auto__ = e42529;
var statearr_42531_45637 = state_42461;
(statearr_42531_45637[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42461[(4)]))){
var statearr_42532_45643 = state_42461;
(statearr_42532_45643[(1)] = cljs.core.first.call(null,(state_42461[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45645 = state_42461;
state_42461 = G__45645;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_42461){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_42461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_42540 = f__42105__auto__();
(statearr_42540[(6)] = c__42104__auto___45588);

return statearr_42540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__42550){
var vec__42553 = p__42550;
var v = cljs.core.nth.call(null,vec__42553,(0),null);
var p = cljs.core.nth.call(null,vec__42553,(1),null);
var job = vec__42553;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__42104__auto___45660 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_42561){
var state_val_42562 = (state_42561[(1)]);
if((state_val_42562 === (1))){
var state_42561__$1 = state_42561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42561__$1,(2),res,v);
} else {
if((state_val_42562 === (2))){
var inst_42558 = (state_42561[(2)]);
var inst_42559 = cljs.core.async.close_BANG_.call(null,res);
var state_42561__$1 = (function (){var statearr_42564 = state_42561;
(statearr_42564[(7)] = inst_42558);

return statearr_42564;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42561__$1,inst_42559);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_42572 = [null,null,null,null,null,null,null,null];
(statearr_42572[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__);

(statearr_42572[(1)] = (1));

return statearr_42572;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1 = (function (state_42561){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42573){var ex__41878__auto__ = e42573;
var statearr_42574_45670 = state_42561;
(statearr_42574_45670[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42561[(4)]))){
var statearr_42575_45673 = state_42561;
(statearr_42575_45673[(1)] = cljs.core.first.call(null,(state_42561[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45679 = state_42561;
state_42561 = G__45679;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = function(state_42561){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1.call(this,state_42561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_42576 = f__42105__auto__();
(statearr_42576[(6)] = c__42104__auto___45660);

return statearr_42576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__42577){
var vec__42578 = p__42577;
var v = cljs.core.nth.call(null,vec__42578,(0),null);
var p = cljs.core.nth.call(null,vec__42578,(1),null);
var job = vec__42578;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___45682 = n;
var __45683 = (0);
while(true){
if((__45683 < n__4613__auto___45682)){
var G__42581_45684 = type;
var G__42581_45685__$1 = (((G__42581_45684 instanceof cljs.core.Keyword))?G__42581_45684.fqn:null);
switch (G__42581_45685__$1) {
case "compute":
var c__42104__auto___45687 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__45683,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = ((function (__45683,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function (state_42605){
var state_val_42606 = (state_42605[(1)]);
if((state_val_42606 === (1))){
var state_42605__$1 = state_42605;
var statearr_42611_45689 = state_42605__$1;
(statearr_42611_45689[(2)] = null);

(statearr_42611_45689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42606 === (2))){
var state_42605__$1 = state_42605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42605__$1,(4),jobs);
} else {
if((state_val_42606 === (3))){
var inst_42602 = (state_42605[(2)]);
var state_42605__$1 = state_42605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42605__$1,inst_42602);
} else {
if((state_val_42606 === (4))){
var inst_42592 = (state_42605[(2)]);
var inst_42595 = process(inst_42592);
var state_42605__$1 = state_42605;
if(cljs.core.truth_(inst_42595)){
var statearr_42614_45695 = state_42605__$1;
(statearr_42614_45695[(1)] = (5));

} else {
var statearr_42617_45696 = state_42605__$1;
(statearr_42617_45696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42606 === (5))){
var state_42605__$1 = state_42605;
var statearr_42619_45698 = state_42605__$1;
(statearr_42619_45698[(2)] = null);

(statearr_42619_45698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42606 === (6))){
var state_42605__$1 = state_42605;
var statearr_42623_45700 = state_42605__$1;
(statearr_42623_45700[(2)] = null);

(statearr_42623_45700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42606 === (7))){
var inst_42600 = (state_42605[(2)]);
var state_42605__$1 = state_42605;
var statearr_42624_45708 = state_42605__$1;
(statearr_42624_45708[(2)] = inst_42600);

(statearr_42624_45708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45683,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
;
return ((function (__45683,switch__41874__auto__,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_42636 = [null,null,null,null,null,null,null];
(statearr_42636[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__);

(statearr_42636[(1)] = (1));

return statearr_42636;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1 = (function (state_42605){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42640){var ex__41878__auto__ = e42640;
var statearr_42642_45711 = state_42605;
(statearr_42642_45711[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42605[(4)]))){
var statearr_42643_45712 = state_42605;
(statearr_42643_45712[(1)] = cljs.core.first.call(null,(state_42605[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45713 = state_42605;
state_42605 = G__45713;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = function(state_42605){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1.call(this,state_42605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__;
})()
;})(__45683,switch__41874__auto__,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
})();
var state__42106__auto__ = (function (){var statearr_42644 = f__42105__auto__();
(statearr_42644[(6)] = c__42104__auto___45687);

return statearr_42644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
});})(__45683,c__42104__auto___45687,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
);


break;
case "async":
var c__42104__auto___45714 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__45683,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = ((function (__45683,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function (state_42661){
var state_val_42662 = (state_42661[(1)]);
if((state_val_42662 === (1))){
var state_42661__$1 = state_42661;
var statearr_42670_45721 = state_42661__$1;
(statearr_42670_45721[(2)] = null);

(statearr_42670_45721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42662 === (2))){
var state_42661__$1 = state_42661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42661__$1,(4),jobs);
} else {
if((state_val_42662 === (3))){
var inst_42658 = (state_42661[(2)]);
var state_42661__$1 = state_42661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42661__$1,inst_42658);
} else {
if((state_val_42662 === (4))){
var inst_42648 = (state_42661[(2)]);
var inst_42650 = async(inst_42648);
var state_42661__$1 = state_42661;
if(cljs.core.truth_(inst_42650)){
var statearr_42672_45728 = state_42661__$1;
(statearr_42672_45728[(1)] = (5));

} else {
var statearr_42673_45730 = state_42661__$1;
(statearr_42673_45730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42662 === (5))){
var state_42661__$1 = state_42661;
var statearr_42677_45731 = state_42661__$1;
(statearr_42677_45731[(2)] = null);

(statearr_42677_45731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42662 === (6))){
var state_42661__$1 = state_42661;
var statearr_42679_45733 = state_42661__$1;
(statearr_42679_45733[(2)] = null);

(statearr_42679_45733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42662 === (7))){
var inst_42656 = (state_42661[(2)]);
var state_42661__$1 = state_42661;
var statearr_42680_45734 = state_42661__$1;
(statearr_42680_45734[(2)] = inst_42656);

(statearr_42680_45734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__45683,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
;
return ((function (__45683,switch__41874__auto__,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_42681 = [null,null,null,null,null,null,null];
(statearr_42681[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__);

(statearr_42681[(1)] = (1));

return statearr_42681;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1 = (function (state_42661){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42690){var ex__41878__auto__ = e42690;
var statearr_42692_45740 = state_42661;
(statearr_42692_45740[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42661[(4)]))){
var statearr_42693_45741 = state_42661;
(statearr_42693_45741[(1)] = cljs.core.first.call(null,(state_42661[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45742 = state_42661;
state_42661 = G__45742;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = function(state_42661){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1.call(this,state_42661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__;
})()
;})(__45683,switch__41874__auto__,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
})();
var state__42106__auto__ = (function (){var statearr_42702 = f__42105__auto__();
(statearr_42702[(6)] = c__42104__auto___45714);

return statearr_42702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
});})(__45683,c__42104__auto___45714,G__42581_45684,G__42581_45685__$1,n__4613__auto___45682,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42581_45685__$1)].join('')));

}

var G__45744 = (__45683 + (1));
__45683 = G__45744;
continue;
} else {
}
break;
}

var c__42104__auto___45747 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_42746){
var state_val_42747 = (state_42746[(1)]);
if((state_val_42747 === (7))){
var inst_42735 = (state_42746[(2)]);
var state_42746__$1 = state_42746;
var statearr_42756_45749 = state_42746__$1;
(statearr_42756_45749[(2)] = inst_42735);

(statearr_42756_45749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42747 === (1))){
var state_42746__$1 = state_42746;
var statearr_42758_45750 = state_42746__$1;
(statearr_42758_45750[(2)] = null);

(statearr_42758_45750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42747 === (4))){
var inst_42712 = (state_42746[(7)]);
var inst_42712__$1 = (state_42746[(2)]);
var inst_42713 = (inst_42712__$1 == null);
var state_42746__$1 = (function (){var statearr_42761 = state_42746;
(statearr_42761[(7)] = inst_42712__$1);

return statearr_42761;
})();
if(cljs.core.truth_(inst_42713)){
var statearr_42762_45755 = state_42746__$1;
(statearr_42762_45755[(1)] = (5));

} else {
var statearr_42763_45756 = state_42746__$1;
(statearr_42763_45756[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42747 === (6))){
var inst_42717 = (state_42746[(8)]);
var inst_42712 = (state_42746[(7)]);
var inst_42717__$1 = cljs.core.async.chan.call(null,(1));
var inst_42724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42725 = [inst_42712,inst_42717__$1];
var inst_42726 = (new cljs.core.PersistentVector(null,2,(5),inst_42724,inst_42725,null));
var state_42746__$1 = (function (){var statearr_42766 = state_42746;
(statearr_42766[(8)] = inst_42717__$1);

return statearr_42766;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42746__$1,(8),jobs,inst_42726);
} else {
if((state_val_42747 === (3))){
var inst_42737 = (state_42746[(2)]);
var state_42746__$1 = state_42746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42746__$1,inst_42737);
} else {
if((state_val_42747 === (2))){
var state_42746__$1 = state_42746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42746__$1,(4),from);
} else {
if((state_val_42747 === (9))){
var inst_42731 = (state_42746[(2)]);
var state_42746__$1 = (function (){var statearr_42772 = state_42746;
(statearr_42772[(9)] = inst_42731);

return statearr_42772;
})();
var statearr_42773_45767 = state_42746__$1;
(statearr_42773_45767[(2)] = null);

(statearr_42773_45767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42747 === (5))){
var inst_42715 = cljs.core.async.close_BANG_.call(null,jobs);
var state_42746__$1 = state_42746;
var statearr_42776_45773 = state_42746__$1;
(statearr_42776_45773[(2)] = inst_42715);

(statearr_42776_45773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42747 === (8))){
var inst_42717 = (state_42746[(8)]);
var inst_42728 = (state_42746[(2)]);
var state_42746__$1 = (function (){var statearr_42779 = state_42746;
(statearr_42779[(10)] = inst_42728);

return statearr_42779;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42746__$1,(9),results,inst_42717);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_42790 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42790[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__);

(statearr_42790[(1)] = (1));

return statearr_42790;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1 = (function (state_42746){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42792){var ex__41878__auto__ = e42792;
var statearr_42797_45784 = state_42746;
(statearr_42797_45784[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42746[(4)]))){
var statearr_42800_45792 = state_42746;
(statearr_42800_45792[(1)] = cljs.core.first.call(null,(state_42746[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45795 = state_42746;
state_42746 = G__45795;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = function(state_42746){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1.call(this,state_42746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_42816 = f__42105__auto__();
(statearr_42816[(6)] = c__42104__auto___45747);

return statearr_42816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


var c__42104__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_42861){
var state_val_42862 = (state_42861[(1)]);
if((state_val_42862 === (7))){
var inst_42857 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42863_45809 = state_42861__$1;
(statearr_42863_45809[(2)] = inst_42857);

(statearr_42863_45809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (20))){
var state_42861__$1 = state_42861;
var statearr_42866_45817 = state_42861__$1;
(statearr_42866_45817[(2)] = null);

(statearr_42866_45817[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (1))){
var state_42861__$1 = state_42861;
var statearr_42867_45818 = state_42861__$1;
(statearr_42867_45818[(2)] = null);

(statearr_42867_45818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (4))){
var inst_42824 = (state_42861[(7)]);
var inst_42824__$1 = (state_42861[(2)]);
var inst_42825 = (inst_42824__$1 == null);
var state_42861__$1 = (function (){var statearr_42868 = state_42861;
(statearr_42868[(7)] = inst_42824__$1);

return statearr_42868;
})();
if(cljs.core.truth_(inst_42825)){
var statearr_42869_45821 = state_42861__$1;
(statearr_42869_45821[(1)] = (5));

} else {
var statearr_42870_45823 = state_42861__$1;
(statearr_42870_45823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (15))){
var inst_42838 = (state_42861[(8)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42861__$1,(18),to,inst_42838);
} else {
if((state_val_42862 === (21))){
var inst_42852 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42871_45827 = state_42861__$1;
(statearr_42871_45827[(2)] = inst_42852);

(statearr_42871_45827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (13))){
var inst_42854 = (state_42861[(2)]);
var state_42861__$1 = (function (){var statearr_42875 = state_42861;
(statearr_42875[(9)] = inst_42854);

return statearr_42875;
})();
var statearr_42876_45828 = state_42861__$1;
(statearr_42876_45828[(2)] = null);

(statearr_42876_45828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (6))){
var inst_42824 = (state_42861[(7)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42861__$1,(11),inst_42824);
} else {
if((state_val_42862 === (17))){
var inst_42846 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
if(cljs.core.truth_(inst_42846)){
var statearr_42880_45832 = state_42861__$1;
(statearr_42880_45832[(1)] = (19));

} else {
var statearr_42881_45833 = state_42861__$1;
(statearr_42881_45833[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (3))){
var inst_42859 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42861__$1,inst_42859);
} else {
if((state_val_42862 === (12))){
var inst_42834 = (state_42861[(10)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42861__$1,(14),inst_42834);
} else {
if((state_val_42862 === (2))){
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42861__$1,(4),results);
} else {
if((state_val_42862 === (19))){
var state_42861__$1 = state_42861;
var statearr_42883_45837 = state_42861__$1;
(statearr_42883_45837[(2)] = null);

(statearr_42883_45837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (11))){
var inst_42834 = (state_42861[(2)]);
var state_42861__$1 = (function (){var statearr_42884 = state_42861;
(statearr_42884[(10)] = inst_42834);

return statearr_42884;
})();
var statearr_42886_45838 = state_42861__$1;
(statearr_42886_45838[(2)] = null);

(statearr_42886_45838[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (9))){
var state_42861__$1 = state_42861;
var statearr_42887_45840 = state_42861__$1;
(statearr_42887_45840[(2)] = null);

(statearr_42887_45840[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (5))){
var state_42861__$1 = state_42861;
if(cljs.core.truth_(close_QMARK_)){
var statearr_42888_45841 = state_42861__$1;
(statearr_42888_45841[(1)] = (8));

} else {
var statearr_42889_45842 = state_42861__$1;
(statearr_42889_45842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (14))){
var inst_42838 = (state_42861[(8)]);
var inst_42838__$1 = (state_42861[(2)]);
var inst_42839 = (inst_42838__$1 == null);
var inst_42840 = cljs.core.not(inst_42839);
var state_42861__$1 = (function (){var statearr_42890 = state_42861;
(statearr_42890[(8)] = inst_42838__$1);

return statearr_42890;
})();
if(inst_42840){
var statearr_42891_45849 = state_42861__$1;
(statearr_42891_45849[(1)] = (15));

} else {
var statearr_42892_45850 = state_42861__$1;
(statearr_42892_45850[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (16))){
var state_42861__$1 = state_42861;
var statearr_42893_45851 = state_42861__$1;
(statearr_42893_45851[(2)] = false);

(statearr_42893_45851[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (10))){
var inst_42831 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42894_45853 = state_42861__$1;
(statearr_42894_45853[(2)] = inst_42831);

(statearr_42894_45853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (18))){
var inst_42843 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42895_45854 = state_42861__$1;
(statearr_42895_45854[(2)] = inst_42843);

(statearr_42895_45854[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42862 === (8))){
var inst_42828 = cljs.core.async.close_BANG_.call(null,to);
var state_42861__$1 = state_42861;
var statearr_42896_45855 = state_42861__$1;
(statearr_42896_45855[(2)] = inst_42828);

(statearr_42896_45855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_42897 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42897[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__);

(statearr_42897[(1)] = (1));

return statearr_42897;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1 = (function (state_42861){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e42898){var ex__41878__auto__ = e42898;
var statearr_42902_45868 = state_42861;
(statearr_42902_45868[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42861[(4)]))){
var statearr_42903_45871 = state_42861;
(statearr_42903_45871[(1)] = cljs.core.first.call(null,(state_42861[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45874 = state_42861;
state_42861 = G__45874;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__ = function(state_42861){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1.call(this,state_42861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_42906 = f__42105__auto__();
(statearr_42906[(6)] = c__42104__auto__);

return statearr_42906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

return c__42104__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__42908 = arguments.length;
switch (G__42908) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__42919 = arguments.length;
switch (G__42919) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__42937 = arguments.length;
switch (G__42937) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__42104__auto___45940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_42988){
var state_val_42989 = (state_42988[(1)]);
if((state_val_42989 === (7))){
var inst_42984 = (state_42988[(2)]);
var state_42988__$1 = state_42988;
var statearr_42990_45942 = state_42988__$1;
(statearr_42990_45942[(2)] = inst_42984);

(statearr_42990_45942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (1))){
var state_42988__$1 = state_42988;
var statearr_42991_45947 = state_42988__$1;
(statearr_42991_45947[(2)] = null);

(statearr_42991_45947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (4))){
var inst_42965 = (state_42988[(7)]);
var inst_42965__$1 = (state_42988[(2)]);
var inst_42966 = (inst_42965__$1 == null);
var state_42988__$1 = (function (){var statearr_42993 = state_42988;
(statearr_42993[(7)] = inst_42965__$1);

return statearr_42993;
})();
if(cljs.core.truth_(inst_42966)){
var statearr_43006_45952 = state_42988__$1;
(statearr_43006_45952[(1)] = (5));

} else {
var statearr_43007_45954 = state_42988__$1;
(statearr_43007_45954[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (13))){
var state_42988__$1 = state_42988;
var statearr_43009_45961 = state_42988__$1;
(statearr_43009_45961[(2)] = null);

(statearr_43009_45961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (6))){
var inst_42965 = (state_42988[(7)]);
var inst_42971 = p.call(null,inst_42965);
var state_42988__$1 = state_42988;
if(cljs.core.truth_(inst_42971)){
var statearr_43010_45962 = state_42988__$1;
(statearr_43010_45962[(1)] = (9));

} else {
var statearr_43011_45963 = state_42988__$1;
(statearr_43011_45963[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (3))){
var inst_42986 = (state_42988[(2)]);
var state_42988__$1 = state_42988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42988__$1,inst_42986);
} else {
if((state_val_42989 === (12))){
var state_42988__$1 = state_42988;
var statearr_43014_45969 = state_42988__$1;
(statearr_43014_45969[(2)] = null);

(statearr_43014_45969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (2))){
var state_42988__$1 = state_42988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42988__$1,(4),ch);
} else {
if((state_val_42989 === (11))){
var inst_42965 = (state_42988[(7)]);
var inst_42975 = (state_42988[(2)]);
var state_42988__$1 = state_42988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_42988__$1,(8),inst_42975,inst_42965);
} else {
if((state_val_42989 === (9))){
var state_42988__$1 = state_42988;
var statearr_43015_45971 = state_42988__$1;
(statearr_43015_45971[(2)] = tc);

(statearr_43015_45971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (5))){
var inst_42968 = cljs.core.async.close_BANG_.call(null,tc);
var inst_42969 = cljs.core.async.close_BANG_.call(null,fc);
var state_42988__$1 = (function (){var statearr_43016 = state_42988;
(statearr_43016[(8)] = inst_42968);

return statearr_43016;
})();
var statearr_43017_45976 = state_42988__$1;
(statearr_43017_45976[(2)] = inst_42969);

(statearr_43017_45976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (14))){
var inst_42982 = (state_42988[(2)]);
var state_42988__$1 = state_42988;
var statearr_43018_45981 = state_42988__$1;
(statearr_43018_45981[(2)] = inst_42982);

(statearr_43018_45981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (10))){
var state_42988__$1 = state_42988;
var statearr_43019_45989 = state_42988__$1;
(statearr_43019_45989[(2)] = fc);

(statearr_43019_45989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42989 === (8))){
var inst_42977 = (state_42988[(2)]);
var state_42988__$1 = state_42988;
if(cljs.core.truth_(inst_42977)){
var statearr_43021_45994 = state_42988__$1;
(statearr_43021_45994[(1)] = (12));

} else {
var statearr_43022_45997 = state_42988__$1;
(statearr_43022_45997[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_43027 = [null,null,null,null,null,null,null,null,null];
(statearr_43027[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_43027[(1)] = (1));

return statearr_43027;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_42988){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_42988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e43033){var ex__41878__auto__ = e43033;
var statearr_43035_46005 = state_42988;
(statearr_43035_46005[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_42988[(4)]))){
var statearr_43042_46006 = state_42988;
(statearr_43042_46006[(1)] = cljs.core.first.call(null,(state_42988[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46013 = state_42988;
state_42988 = G__46013;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_42988){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_42988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_43049 = f__42105__auto__();
(statearr_43049[(6)] = c__42104__auto___45940);

return statearr_43049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__42104__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_43084){
var state_val_43086 = (state_43084[(1)]);
if((state_val_43086 === (7))){
var inst_43078 = (state_43084[(2)]);
var state_43084__$1 = state_43084;
var statearr_43097_46015 = state_43084__$1;
(statearr_43097_46015[(2)] = inst_43078);

(statearr_43097_46015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (1))){
var inst_43052 = init;
var inst_43053 = inst_43052;
var state_43084__$1 = (function (){var statearr_43102 = state_43084;
(statearr_43102[(7)] = inst_43053);

return statearr_43102;
})();
var statearr_43108_46016 = state_43084__$1;
(statearr_43108_46016[(2)] = null);

(statearr_43108_46016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (4))){
var inst_43056 = (state_43084[(8)]);
var inst_43056__$1 = (state_43084[(2)]);
var inst_43061 = (inst_43056__$1 == null);
var state_43084__$1 = (function (){var statearr_43117 = state_43084;
(statearr_43117[(8)] = inst_43056__$1);

return statearr_43117;
})();
if(cljs.core.truth_(inst_43061)){
var statearr_43123_46020 = state_43084__$1;
(statearr_43123_46020[(1)] = (5));

} else {
var statearr_43126_46021 = state_43084__$1;
(statearr_43126_46021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (6))){
var inst_43056 = (state_43084[(8)]);
var inst_43065 = (state_43084[(9)]);
var inst_43053 = (state_43084[(7)]);
var inst_43065__$1 = f.call(null,inst_43053,inst_43056);
var inst_43066 = cljs.core.reduced_QMARK_.call(null,inst_43065__$1);
var state_43084__$1 = (function (){var statearr_43133 = state_43084;
(statearr_43133[(9)] = inst_43065__$1);

return statearr_43133;
})();
if(inst_43066){
var statearr_43135_46027 = state_43084__$1;
(statearr_43135_46027[(1)] = (8));

} else {
var statearr_43136_46028 = state_43084__$1;
(statearr_43136_46028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (3))){
var inst_43080 = (state_43084[(2)]);
var state_43084__$1 = state_43084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43084__$1,inst_43080);
} else {
if((state_val_43086 === (2))){
var state_43084__$1 = state_43084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43084__$1,(4),ch);
} else {
if((state_val_43086 === (9))){
var inst_43065 = (state_43084[(9)]);
var inst_43053 = inst_43065;
var state_43084__$1 = (function (){var statearr_43137 = state_43084;
(statearr_43137[(7)] = inst_43053);

return statearr_43137;
})();
var statearr_43139_46029 = state_43084__$1;
(statearr_43139_46029[(2)] = null);

(statearr_43139_46029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (5))){
var inst_43053 = (state_43084[(7)]);
var state_43084__$1 = state_43084;
var statearr_43140_46030 = state_43084__$1;
(statearr_43140_46030[(2)] = inst_43053);

(statearr_43140_46030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (10))){
var inst_43076 = (state_43084[(2)]);
var state_43084__$1 = state_43084;
var statearr_43142_46037 = state_43084__$1;
(statearr_43142_46037[(2)] = inst_43076);

(statearr_43142_46037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43086 === (8))){
var inst_43065 = (state_43084[(9)]);
var inst_43072 = cljs.core.deref.call(null,inst_43065);
var state_43084__$1 = state_43084;
var statearr_43147_46039 = state_43084__$1;
(statearr_43147_46039[(2)] = inst_43072);

(statearr_43147_46039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__41875__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41875__auto____0 = (function (){
var statearr_43148 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43148[(0)] = cljs$core$async$reduce_$_state_machine__41875__auto__);

(statearr_43148[(1)] = (1));

return statearr_43148;
});
var cljs$core$async$reduce_$_state_machine__41875__auto____1 = (function (state_43084){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_43084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e43149){var ex__41878__auto__ = e43149;
var statearr_43150_46049 = state_43084;
(statearr_43150_46049[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_43084[(4)]))){
var statearr_43151_46054 = state_43084;
(statearr_43151_46054[(1)] = cljs.core.first.call(null,(state_43084[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46055 = state_43084;
state_43084 = G__46055;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41875__auto__ = function(state_43084){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41875__auto____1.call(this,state_43084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41875__auto____0;
cljs$core$async$reduce_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41875__auto____1;
return cljs$core$async$reduce_$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_43152 = f__42105__auto__();
(statearr_43152[(6)] = c__42104__auto__);

return statearr_43152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

return c__42104__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__42104__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_43161){
var state_val_43162 = (state_43161[(1)]);
if((state_val_43162 === (1))){
var inst_43156 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_43161__$1 = state_43161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43161__$1,(2),inst_43156);
} else {
if((state_val_43162 === (2))){
var inst_43158 = (state_43161[(2)]);
var inst_43159 = f__$1.call(null,inst_43158);
var state_43161__$1 = state_43161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43161__$1,inst_43159);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__41875__auto__ = null;
var cljs$core$async$transduce_$_state_machine__41875__auto____0 = (function (){
var statearr_43175 = [null,null,null,null,null,null,null];
(statearr_43175[(0)] = cljs$core$async$transduce_$_state_machine__41875__auto__);

(statearr_43175[(1)] = (1));

return statearr_43175;
});
var cljs$core$async$transduce_$_state_machine__41875__auto____1 = (function (state_43161){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_43161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e43176){var ex__41878__auto__ = e43176;
var statearr_43177_46067 = state_43161;
(statearr_43177_46067[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_43161[(4)]))){
var statearr_43178_46068 = state_43161;
(statearr_43178_46068[(1)] = cljs.core.first.call(null,(state_43161[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46069 = state_43161;
state_43161 = G__46069;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__41875__auto__ = function(state_43161){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__41875__auto____1.call(this,state_43161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__41875__auto____0;
cljs$core$async$transduce_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__41875__auto____1;
return cljs$core$async$transduce_$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_43181 = f__42105__auto__();
(statearr_43181[(6)] = c__42104__auto__);

return statearr_43181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

return c__42104__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__43183 = arguments.length;
switch (G__43183) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__42104__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_43215){
var state_val_43216 = (state_43215[(1)]);
if((state_val_43216 === (7))){
var inst_43197 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43221_46078 = state_43215__$1;
(statearr_43221_46078[(2)] = inst_43197);

(statearr_43221_46078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (1))){
var inst_43191 = cljs.core.seq.call(null,coll);
var inst_43192 = inst_43191;
var state_43215__$1 = (function (){var statearr_43222 = state_43215;
(statearr_43222[(7)] = inst_43192);

return statearr_43222;
})();
var statearr_43223_46081 = state_43215__$1;
(statearr_43223_46081[(2)] = null);

(statearr_43223_46081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (4))){
var inst_43192 = (state_43215[(7)]);
var inst_43195 = cljs.core.first.call(null,inst_43192);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43215__$1,(7),ch,inst_43195);
} else {
if((state_val_43216 === (13))){
var inst_43209 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43225_46083 = state_43215__$1;
(statearr_43225_46083[(2)] = inst_43209);

(statearr_43225_46083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (6))){
var inst_43200 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
if(cljs.core.truth_(inst_43200)){
var statearr_43227_46087 = state_43215__$1;
(statearr_43227_46087[(1)] = (8));

} else {
var statearr_43228_46102 = state_43215__$1;
(statearr_43228_46102[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (3))){
var inst_43213 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43215__$1,inst_43213);
} else {
if((state_val_43216 === (12))){
var state_43215__$1 = state_43215;
var statearr_43229_46103 = state_43215__$1;
(statearr_43229_46103[(2)] = null);

(statearr_43229_46103[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (2))){
var inst_43192 = (state_43215[(7)]);
var state_43215__$1 = state_43215;
if(cljs.core.truth_(inst_43192)){
var statearr_43233_46106 = state_43215__$1;
(statearr_43233_46106[(1)] = (4));

} else {
var statearr_43234_46107 = state_43215__$1;
(statearr_43234_46107[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (11))){
var inst_43206 = cljs.core.async.close_BANG_.call(null,ch);
var state_43215__$1 = state_43215;
var statearr_43238_46109 = state_43215__$1;
(statearr_43238_46109[(2)] = inst_43206);

(statearr_43238_46109[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (9))){
var state_43215__$1 = state_43215;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43240_46110 = state_43215__$1;
(statearr_43240_46110[(1)] = (11));

} else {
var statearr_43241_46111 = state_43215__$1;
(statearr_43241_46111[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (5))){
var inst_43192 = (state_43215[(7)]);
var state_43215__$1 = state_43215;
var statearr_43244_46113 = state_43215__$1;
(statearr_43244_46113[(2)] = inst_43192);

(statearr_43244_46113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (10))){
var inst_43211 = (state_43215[(2)]);
var state_43215__$1 = state_43215;
var statearr_43248_46114 = state_43215__$1;
(statearr_43248_46114[(2)] = inst_43211);

(statearr_43248_46114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43216 === (8))){
var inst_43192 = (state_43215[(7)]);
var inst_43202 = cljs.core.next.call(null,inst_43192);
var inst_43192__$1 = inst_43202;
var state_43215__$1 = (function (){var statearr_43251 = state_43215;
(statearr_43251[(7)] = inst_43192__$1);

return statearr_43251;
})();
var statearr_43252_46118 = state_43215__$1;
(statearr_43252_46118[(2)] = null);

(statearr_43252_46118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_43256 = [null,null,null,null,null,null,null,null];
(statearr_43256[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_43256[(1)] = (1));

return statearr_43256;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_43215){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_43215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e43260){var ex__41878__auto__ = e43260;
var statearr_43262_46119 = state_43215;
(statearr_43262_46119[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_43215[(4)]))){
var statearr_43264_46120 = state_43215;
(statearr_43264_46120[(1)] = cljs.core.first.call(null,(state_43215[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46121 = state_43215;
state_43215 = G__46121;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_43215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_43215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_43268 = f__42105__auto__();
(statearr_43268[(6)] = c__42104__auto__);

return statearr_43268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

return c__42104__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__43276 = arguments.length;
switch (G__43276) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46127 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46127(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46141 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46141(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46143 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46143(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46149 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46149(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43319 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43319 = (function (ch,cs,meta43320){
this.ch = ch;
this.cs = cs;
this.meta43320 = meta43320;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43321,meta43320__$1){
var self__ = this;
var _43321__$1 = this;
return (new cljs.core.async.t_cljs$core$async43319(self__.ch,self__.cs,meta43320__$1));
}));

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43321){
var self__ = this;
var _43321__$1 = this;
return self__.meta43320;
}));

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async43319.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async43319.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta43320","meta43320",-874712958,null)], null);
}));

(cljs.core.async.t_cljs$core$async43319.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43319.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43319");

(cljs.core.async.t_cljs$core$async43319.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43319");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43319.
 */
cljs.core.async.__GT_t_cljs$core$async43319 = (function cljs$core$async$mult_$___GT_t_cljs$core$async43319(ch__$1,cs__$1,meta43320){
return (new cljs.core.async.t_cljs$core$async43319(ch__$1,cs__$1,meta43320));
});

}

return (new cljs.core.async.t_cljs$core$async43319(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__42104__auto___46176 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_43533){
var state_val_43534 = (state_43533[(1)]);
if((state_val_43534 === (7))){
var inst_43529 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43538_46178 = state_43533__$1;
(statearr_43538_46178[(2)] = inst_43529);

(statearr_43538_46178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (20))){
var inst_43421 = (state_43533[(7)]);
var inst_43436 = cljs.core.first.call(null,inst_43421);
var inst_43437 = cljs.core.nth.call(null,inst_43436,(0),null);
var inst_43438 = cljs.core.nth.call(null,inst_43436,(1),null);
var state_43533__$1 = (function (){var statearr_43539 = state_43533;
(statearr_43539[(8)] = inst_43437);

return statearr_43539;
})();
if(cljs.core.truth_(inst_43438)){
var statearr_43540_46180 = state_43533__$1;
(statearr_43540_46180[(1)] = (22));

} else {
var statearr_43541_46181 = state_43533__$1;
(statearr_43541_46181[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (27))){
var inst_43468 = (state_43533[(9)]);
var inst_43466 = (state_43533[(10)]);
var inst_43386 = (state_43533[(11)]);
var inst_43474 = (state_43533[(12)]);
var inst_43474__$1 = cljs.core._nth(inst_43466,inst_43468);
var inst_43475 = cljs.core.async.put_BANG_.call(null,inst_43474__$1,inst_43386,done);
var state_43533__$1 = (function (){var statearr_43545 = state_43533;
(statearr_43545[(12)] = inst_43474__$1);

return statearr_43545;
})();
if(cljs.core.truth_(inst_43475)){
var statearr_43547_46183 = state_43533__$1;
(statearr_43547_46183[(1)] = (30));

} else {
var statearr_43550_46184 = state_43533__$1;
(statearr_43550_46184[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (1))){
var state_43533__$1 = state_43533;
var statearr_43553_46187 = state_43533__$1;
(statearr_43553_46187[(2)] = null);

(statearr_43553_46187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (24))){
var inst_43421 = (state_43533[(7)]);
var inst_43443 = (state_43533[(2)]);
var inst_43444 = cljs.core.next.call(null,inst_43421);
var inst_43395 = inst_43444;
var inst_43396 = null;
var inst_43397 = (0);
var inst_43398 = (0);
var state_43533__$1 = (function (){var statearr_43555 = state_43533;
(statearr_43555[(13)] = inst_43397);

(statearr_43555[(14)] = inst_43398);

(statearr_43555[(15)] = inst_43396);

(statearr_43555[(16)] = inst_43443);

(statearr_43555[(17)] = inst_43395);

return statearr_43555;
})();
var statearr_43556_46196 = state_43533__$1;
(statearr_43556_46196[(2)] = null);

(statearr_43556_46196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (39))){
var state_43533__$1 = state_43533;
var statearr_43561_46201 = state_43533__$1;
(statearr_43561_46201[(2)] = null);

(statearr_43561_46201[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (4))){
var inst_43386 = (state_43533[(11)]);
var inst_43386__$1 = (state_43533[(2)]);
var inst_43387 = (inst_43386__$1 == null);
var state_43533__$1 = (function (){var statearr_43562 = state_43533;
(statearr_43562[(11)] = inst_43386__$1);

return statearr_43562;
})();
if(cljs.core.truth_(inst_43387)){
var statearr_43563_46207 = state_43533__$1;
(statearr_43563_46207[(1)] = (5));

} else {
var statearr_43564_46210 = state_43533__$1;
(statearr_43564_46210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (15))){
var inst_43397 = (state_43533[(13)]);
var inst_43398 = (state_43533[(14)]);
var inst_43396 = (state_43533[(15)]);
var inst_43395 = (state_43533[(17)]);
var inst_43417 = (state_43533[(2)]);
var inst_43418 = (inst_43398 + (1));
var tmp43557 = inst_43397;
var tmp43558 = inst_43396;
var tmp43559 = inst_43395;
var inst_43395__$1 = tmp43559;
var inst_43396__$1 = tmp43558;
var inst_43397__$1 = tmp43557;
var inst_43398__$1 = inst_43418;
var state_43533__$1 = (function (){var statearr_43565 = state_43533;
(statearr_43565[(13)] = inst_43397__$1);

(statearr_43565[(14)] = inst_43398__$1);

(statearr_43565[(15)] = inst_43396__$1);

(statearr_43565[(18)] = inst_43417);

(statearr_43565[(17)] = inst_43395__$1);

return statearr_43565;
})();
var statearr_43566_46221 = state_43533__$1;
(statearr_43566_46221[(2)] = null);

(statearr_43566_46221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (21))){
var inst_43447 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43573_46224 = state_43533__$1;
(statearr_43573_46224[(2)] = inst_43447);

(statearr_43573_46224[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (31))){
var inst_43474 = (state_43533[(12)]);
var inst_43480 = cljs.core.async.untap_STAR_(m,inst_43474);
var state_43533__$1 = state_43533;
var statearr_43575_46227 = state_43533__$1;
(statearr_43575_46227[(2)] = inst_43480);

(statearr_43575_46227[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (32))){
var inst_43465 = (state_43533[(19)]);
var inst_43467 = (state_43533[(20)]);
var inst_43468 = (state_43533[(9)]);
var inst_43466 = (state_43533[(10)]);
var inst_43482 = (state_43533[(2)]);
var inst_43484 = (inst_43468 + (1));
var tmp43570 = inst_43465;
var tmp43571 = inst_43467;
var tmp43572 = inst_43466;
var inst_43465__$1 = tmp43570;
var inst_43466__$1 = tmp43572;
var inst_43467__$1 = tmp43571;
var inst_43468__$1 = inst_43484;
var state_43533__$1 = (function (){var statearr_43576 = state_43533;
(statearr_43576[(19)] = inst_43465__$1);

(statearr_43576[(20)] = inst_43467__$1);

(statearr_43576[(9)] = inst_43468__$1);

(statearr_43576[(10)] = inst_43466__$1);

(statearr_43576[(21)] = inst_43482);

return statearr_43576;
})();
var statearr_43578_46246 = state_43533__$1;
(statearr_43578_46246[(2)] = null);

(statearr_43578_46246[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (40))){
var inst_43502 = (state_43533[(22)]);
var inst_43506 = cljs.core.async.untap_STAR_(m,inst_43502);
var state_43533__$1 = state_43533;
var statearr_43582_46249 = state_43533__$1;
(statearr_43582_46249[(2)] = inst_43506);

(statearr_43582_46249[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (33))){
var inst_43487 = (state_43533[(23)]);
var inst_43489 = cljs.core.chunked_seq_QMARK_.call(null,inst_43487);
var state_43533__$1 = state_43533;
if(inst_43489){
var statearr_43590_46254 = state_43533__$1;
(statearr_43590_46254[(1)] = (36));

} else {
var statearr_43591_46257 = state_43533__$1;
(statearr_43591_46257[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (13))){
var inst_43411 = (state_43533[(24)]);
var inst_43414 = cljs.core.async.close_BANG_.call(null,inst_43411);
var state_43533__$1 = state_43533;
var statearr_43592_46258 = state_43533__$1;
(statearr_43592_46258[(2)] = inst_43414);

(statearr_43592_46258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (22))){
var inst_43437 = (state_43533[(8)]);
var inst_43440 = cljs.core.async.close_BANG_.call(null,inst_43437);
var state_43533__$1 = state_43533;
var statearr_43593_46264 = state_43533__$1;
(statearr_43593_46264[(2)] = inst_43440);

(statearr_43593_46264[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (36))){
var inst_43487 = (state_43533[(23)]);
var inst_43491 = cljs.core.chunk_first.call(null,inst_43487);
var inst_43495 = cljs.core.chunk_rest.call(null,inst_43487);
var inst_43496 = cljs.core.count.call(null,inst_43491);
var inst_43465 = inst_43495;
var inst_43466 = inst_43491;
var inst_43467 = inst_43496;
var inst_43468 = (0);
var state_43533__$1 = (function (){var statearr_43595 = state_43533;
(statearr_43595[(19)] = inst_43465);

(statearr_43595[(20)] = inst_43467);

(statearr_43595[(9)] = inst_43468);

(statearr_43595[(10)] = inst_43466);

return statearr_43595;
})();
var statearr_43596_46270 = state_43533__$1;
(statearr_43596_46270[(2)] = null);

(statearr_43596_46270[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (41))){
var inst_43487 = (state_43533[(23)]);
var inst_43508 = (state_43533[(2)]);
var inst_43509 = cljs.core.next.call(null,inst_43487);
var inst_43465 = inst_43509;
var inst_43466 = null;
var inst_43467 = (0);
var inst_43468 = (0);
var state_43533__$1 = (function (){var statearr_43597 = state_43533;
(statearr_43597[(19)] = inst_43465);

(statearr_43597[(20)] = inst_43467);

(statearr_43597[(9)] = inst_43468);

(statearr_43597[(25)] = inst_43508);

(statearr_43597[(10)] = inst_43466);

return statearr_43597;
})();
var statearr_43598_46275 = state_43533__$1;
(statearr_43598_46275[(2)] = null);

(statearr_43598_46275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (43))){
var state_43533__$1 = state_43533;
var statearr_43600_46288 = state_43533__$1;
(statearr_43600_46288[(2)] = null);

(statearr_43600_46288[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (29))){
var inst_43517 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43602_46289 = state_43533__$1;
(statearr_43602_46289[(2)] = inst_43517);

(statearr_43602_46289[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (44))){
var inst_43526 = (state_43533[(2)]);
var state_43533__$1 = (function (){var statearr_43604 = state_43533;
(statearr_43604[(26)] = inst_43526);

return statearr_43604;
})();
var statearr_43605_46297 = state_43533__$1;
(statearr_43605_46297[(2)] = null);

(statearr_43605_46297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (6))){
var inst_43457 = (state_43533[(27)]);
var inst_43456 = cljs.core.deref.call(null,cs);
var inst_43457__$1 = cljs.core.keys.call(null,inst_43456);
var inst_43458 = cljs.core.count.call(null,inst_43457__$1);
var inst_43459 = cljs.core.reset_BANG_.call(null,dctr,inst_43458);
var inst_43464 = cljs.core.seq.call(null,inst_43457__$1);
var inst_43465 = inst_43464;
var inst_43466 = null;
var inst_43467 = (0);
var inst_43468 = (0);
var state_43533__$1 = (function (){var statearr_43606 = state_43533;
(statearr_43606[(19)] = inst_43465);

(statearr_43606[(27)] = inst_43457__$1);

(statearr_43606[(20)] = inst_43467);

(statearr_43606[(28)] = inst_43459);

(statearr_43606[(9)] = inst_43468);

(statearr_43606[(10)] = inst_43466);

return statearr_43606;
})();
var statearr_43608_46301 = state_43533__$1;
(statearr_43608_46301[(2)] = null);

(statearr_43608_46301[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (28))){
var inst_43465 = (state_43533[(19)]);
var inst_43487 = (state_43533[(23)]);
var inst_43487__$1 = cljs.core.seq.call(null,inst_43465);
var state_43533__$1 = (function (){var statearr_43609 = state_43533;
(statearr_43609[(23)] = inst_43487__$1);

return statearr_43609;
})();
if(inst_43487__$1){
var statearr_43610_46312 = state_43533__$1;
(statearr_43610_46312[(1)] = (33));

} else {
var statearr_43611_46314 = state_43533__$1;
(statearr_43611_46314[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (25))){
var inst_43467 = (state_43533[(20)]);
var inst_43468 = (state_43533[(9)]);
var inst_43470 = (inst_43468 < inst_43467);
var inst_43471 = inst_43470;
var state_43533__$1 = state_43533;
if(cljs.core.truth_(inst_43471)){
var statearr_43612_46322 = state_43533__$1;
(statearr_43612_46322[(1)] = (27));

} else {
var statearr_43613_46323 = state_43533__$1;
(statearr_43613_46323[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (34))){
var state_43533__$1 = state_43533;
var statearr_43614_46325 = state_43533__$1;
(statearr_43614_46325[(2)] = null);

(statearr_43614_46325[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (17))){
var state_43533__$1 = state_43533;
var statearr_43615_46327 = state_43533__$1;
(statearr_43615_46327[(2)] = null);

(statearr_43615_46327[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (3))){
var inst_43531 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43533__$1,inst_43531);
} else {
if((state_val_43534 === (12))){
var inst_43452 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43616_46330 = state_43533__$1;
(statearr_43616_46330[(2)] = inst_43452);

(statearr_43616_46330[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (2))){
var state_43533__$1 = state_43533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43533__$1,(4),ch);
} else {
if((state_val_43534 === (23))){
var state_43533__$1 = state_43533;
var statearr_43617_46335 = state_43533__$1;
(statearr_43617_46335[(2)] = null);

(statearr_43617_46335[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (35))){
var inst_43515 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43618_46339 = state_43533__$1;
(statearr_43618_46339[(2)] = inst_43515);

(statearr_43618_46339[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (19))){
var inst_43421 = (state_43533[(7)]);
var inst_43428 = cljs.core.chunk_first.call(null,inst_43421);
var inst_43429 = cljs.core.chunk_rest.call(null,inst_43421);
var inst_43430 = cljs.core.count.call(null,inst_43428);
var inst_43395 = inst_43429;
var inst_43396 = inst_43428;
var inst_43397 = inst_43430;
var inst_43398 = (0);
var state_43533__$1 = (function (){var statearr_43619 = state_43533;
(statearr_43619[(13)] = inst_43397);

(statearr_43619[(14)] = inst_43398);

(statearr_43619[(15)] = inst_43396);

(statearr_43619[(17)] = inst_43395);

return statearr_43619;
})();
var statearr_43620_46354 = state_43533__$1;
(statearr_43620_46354[(2)] = null);

(statearr_43620_46354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (11))){
var inst_43421 = (state_43533[(7)]);
var inst_43395 = (state_43533[(17)]);
var inst_43421__$1 = cljs.core.seq.call(null,inst_43395);
var state_43533__$1 = (function (){var statearr_43622 = state_43533;
(statearr_43622[(7)] = inst_43421__$1);

return statearr_43622;
})();
if(inst_43421__$1){
var statearr_43623_46361 = state_43533__$1;
(statearr_43623_46361[(1)] = (16));

} else {
var statearr_43624_46362 = state_43533__$1;
(statearr_43624_46362[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (9))){
var inst_43454 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43625_46392 = state_43533__$1;
(statearr_43625_46392[(2)] = inst_43454);

(statearr_43625_46392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (5))){
var inst_43393 = cljs.core.deref.call(null,cs);
var inst_43394 = cljs.core.seq.call(null,inst_43393);
var inst_43395 = inst_43394;
var inst_43396 = null;
var inst_43397 = (0);
var inst_43398 = (0);
var state_43533__$1 = (function (){var statearr_43627 = state_43533;
(statearr_43627[(13)] = inst_43397);

(statearr_43627[(14)] = inst_43398);

(statearr_43627[(15)] = inst_43396);

(statearr_43627[(17)] = inst_43395);

return statearr_43627;
})();
var statearr_43633_46406 = state_43533__$1;
(statearr_43633_46406[(2)] = null);

(statearr_43633_46406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (14))){
var state_43533__$1 = state_43533;
var statearr_43635_46407 = state_43533__$1;
(statearr_43635_46407[(2)] = null);

(statearr_43635_46407[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (45))){
var inst_43523 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43637_46408 = state_43533__$1;
(statearr_43637_46408[(2)] = inst_43523);

(statearr_43637_46408[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (26))){
var inst_43457 = (state_43533[(27)]);
var inst_43519 = (state_43533[(2)]);
var inst_43520 = cljs.core.seq.call(null,inst_43457);
var state_43533__$1 = (function (){var statearr_43640 = state_43533;
(statearr_43640[(29)] = inst_43519);

return statearr_43640;
})();
if(inst_43520){
var statearr_43642_46410 = state_43533__$1;
(statearr_43642_46410[(1)] = (42));

} else {
var statearr_43643_46412 = state_43533__$1;
(statearr_43643_46412[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (16))){
var inst_43421 = (state_43533[(7)]);
var inst_43423 = cljs.core.chunked_seq_QMARK_.call(null,inst_43421);
var state_43533__$1 = state_43533;
if(inst_43423){
var statearr_43645_46417 = state_43533__$1;
(statearr_43645_46417[(1)] = (19));

} else {
var statearr_43646_46419 = state_43533__$1;
(statearr_43646_46419[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (38))){
var inst_43512 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43650_46421 = state_43533__$1;
(statearr_43650_46421[(2)] = inst_43512);

(statearr_43650_46421[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (30))){
var state_43533__$1 = state_43533;
var statearr_43654_46423 = state_43533__$1;
(statearr_43654_46423[(2)] = null);

(statearr_43654_46423[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (10))){
var inst_43398 = (state_43533[(14)]);
var inst_43396 = (state_43533[(15)]);
var inst_43409 = cljs.core._nth(inst_43396,inst_43398);
var inst_43411 = cljs.core.nth.call(null,inst_43409,(0),null);
var inst_43412 = cljs.core.nth.call(null,inst_43409,(1),null);
var state_43533__$1 = (function (){var statearr_43655 = state_43533;
(statearr_43655[(24)] = inst_43411);

return statearr_43655;
})();
if(cljs.core.truth_(inst_43412)){
var statearr_43656_46427 = state_43533__$1;
(statearr_43656_46427[(1)] = (13));

} else {
var statearr_43657_46428 = state_43533__$1;
(statearr_43657_46428[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (18))){
var inst_43450 = (state_43533[(2)]);
var state_43533__$1 = state_43533;
var statearr_43658_46432 = state_43533__$1;
(statearr_43658_46432[(2)] = inst_43450);

(statearr_43658_46432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (42))){
var state_43533__$1 = state_43533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43533__$1,(45),dchan);
} else {
if((state_val_43534 === (37))){
var inst_43487 = (state_43533[(23)]);
var inst_43502 = (state_43533[(22)]);
var inst_43386 = (state_43533[(11)]);
var inst_43502__$1 = cljs.core.first.call(null,inst_43487);
var inst_43503 = cljs.core.async.put_BANG_.call(null,inst_43502__$1,inst_43386,done);
var state_43533__$1 = (function (){var statearr_43660 = state_43533;
(statearr_43660[(22)] = inst_43502__$1);

return statearr_43660;
})();
if(cljs.core.truth_(inst_43503)){
var statearr_43661_46438 = state_43533__$1;
(statearr_43661_46438[(1)] = (39));

} else {
var statearr_43662_46440 = state_43533__$1;
(statearr_43662_46440[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43534 === (8))){
var inst_43397 = (state_43533[(13)]);
var inst_43398 = (state_43533[(14)]);
var inst_43401 = (inst_43398 < inst_43397);
var inst_43402 = inst_43401;
var state_43533__$1 = state_43533;
if(cljs.core.truth_(inst_43402)){
var statearr_43666_46443 = state_43533__$1;
(statearr_43666_46443[(1)] = (10));

} else {
var statearr_43667_46444 = state_43533__$1;
(statearr_43667_46444[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__41875__auto__ = null;
var cljs$core$async$mult_$_state_machine__41875__auto____0 = (function (){
var statearr_43669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43669[(0)] = cljs$core$async$mult_$_state_machine__41875__auto__);

(statearr_43669[(1)] = (1));

return statearr_43669;
});
var cljs$core$async$mult_$_state_machine__41875__auto____1 = (function (state_43533){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_43533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e43672){var ex__41878__auto__ = e43672;
var statearr_43673_46448 = state_43533;
(statearr_43673_46448[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_43533[(4)]))){
var statearr_43677_46449 = state_43533;
(statearr_43677_46449[(1)] = cljs.core.first.call(null,(state_43533[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46454 = state_43533;
state_43533 = G__46454;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41875__auto__ = function(state_43533){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41875__auto____1.call(this,state_43533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41875__auto____0;
cljs$core$async$mult_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41875__auto____1;
return cljs$core$async$mult_$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_43681 = f__42105__auto__();
(statearr_43681[(6)] = c__42104__auto___46176);

return statearr_43681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__43683 = arguments.length;
switch (G__43683) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46462 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46462(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_46480 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_46480(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_46488 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_46488(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_46499 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_46499(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_46509 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_46509(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46528 = arguments.length;
var i__4737__auto___46529 = (0);
while(true){
if((i__4737__auto___46529 < len__4736__auto___46528)){
args__4742__auto__.push((arguments[i__4737__auto___46529]));

var G__46543 = (i__4737__auto___46529 + (1));
i__4737__auto___46529 = G__46543;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__43735){
var map__43738 = p__43735;
var map__43738__$1 = (((((!((map__43738 == null))))?(((((map__43738.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43738.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43738):map__43738);
var opts = map__43738__$1;
var statearr_43744_46560 = state;
(statearr_43744_46560[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_43752_46564 = state;
(statearr_43752_46564[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_43758_46567 = state;
(statearr_43758_46567[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq43725){
var G__43726 = cljs.core.first.call(null,seq43725);
var seq43725__$1 = cljs.core.next.call(null,seq43725);
var G__43727 = cljs.core.first.call(null,seq43725__$1);
var seq43725__$2 = cljs.core.next.call(null,seq43725__$1);
var G__43728 = cljs.core.first.call(null,seq43725__$2);
var seq43725__$3 = cljs.core.next.call(null,seq43725__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43726,G__43727,G__43728,seq43725__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43774 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43774 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta43775){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta43775 = meta43775;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43776,meta43775__$1){
var self__ = this;
var _43776__$1 = this;
return (new cljs.core.async.t_cljs$core$async43774(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta43775__$1));
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43776){
var self__ = this;
var _43776__$1 = this;
return self__.meta43775;
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43774.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async43774.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta43775","meta43775",480629499,null)], null);
}));

(cljs.core.async.t_cljs$core$async43774.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43774.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43774");

(cljs.core.async.t_cljs$core$async43774.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async43774");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43774.
 */
cljs.core.async.__GT_t_cljs$core$async43774 = (function cljs$core$async$mix_$___GT_t_cljs$core$async43774(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43775){
return (new cljs.core.async.t_cljs$core$async43774(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta43775));
});

}

return (new cljs.core.async.t_cljs$core$async43774(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42104__auto___46621 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_43912){
var state_val_43913 = (state_43912[(1)]);
if((state_val_43913 === (7))){
var inst_43819 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
var statearr_43919_46641 = state_43912__$1;
(statearr_43919_46641[(2)] = inst_43819);

(statearr_43919_46641[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (20))){
var inst_43831 = (state_43912[(7)]);
var state_43912__$1 = state_43912;
var statearr_43920_46642 = state_43912__$1;
(statearr_43920_46642[(2)] = inst_43831);

(statearr_43920_46642[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (27))){
var state_43912__$1 = state_43912;
var statearr_43921_46644 = state_43912__$1;
(statearr_43921_46644[(2)] = null);

(statearr_43921_46644[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (1))){
var inst_43806 = (state_43912[(8)]);
var inst_43806__$1 = calc_state();
var inst_43808 = (inst_43806__$1 == null);
var inst_43809 = cljs.core.not(inst_43808);
var state_43912__$1 = (function (){var statearr_43923 = state_43912;
(statearr_43923[(8)] = inst_43806__$1);

return statearr_43923;
})();
if(inst_43809){
var statearr_43924_46650 = state_43912__$1;
(statearr_43924_46650[(1)] = (2));

} else {
var statearr_43925_46654 = state_43912__$1;
(statearr_43925_46654[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (24))){
var inst_43868 = (state_43912[(9)]);
var inst_43855 = (state_43912[(10)]);
var inst_43883 = (state_43912[(11)]);
var inst_43883__$1 = inst_43855.call(null,inst_43868);
var state_43912__$1 = (function (){var statearr_43926 = state_43912;
(statearr_43926[(11)] = inst_43883__$1);

return statearr_43926;
})();
if(cljs.core.truth_(inst_43883__$1)){
var statearr_43927_46655 = state_43912__$1;
(statearr_43927_46655[(1)] = (29));

} else {
var statearr_43931_46657 = state_43912__$1;
(statearr_43931_46657[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (4))){
var inst_43822 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43822)){
var statearr_43938_46658 = state_43912__$1;
(statearr_43938_46658[(1)] = (8));

} else {
var statearr_43939_46659 = state_43912__$1;
(statearr_43939_46659[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (15))){
var inst_43849 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43849)){
var statearr_43940_46662 = state_43912__$1;
(statearr_43940_46662[(1)] = (19));

} else {
var statearr_43941_46663 = state_43912__$1;
(statearr_43941_46663[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (21))){
var inst_43854 = (state_43912[(12)]);
var inst_43854__$1 = (state_43912[(2)]);
var inst_43855 = cljs.core.get.call(null,inst_43854__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43856 = cljs.core.get.call(null,inst_43854__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43857 = cljs.core.get.call(null,inst_43854__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_43912__$1 = (function (){var statearr_43946 = state_43912;
(statearr_43946[(13)] = inst_43856);

(statearr_43946[(10)] = inst_43855);

(statearr_43946[(12)] = inst_43854__$1);

return statearr_43946;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_43912__$1,(22),inst_43857);
} else {
if((state_val_43913 === (31))){
var inst_43892 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43892)){
var statearr_43951_46672 = state_43912__$1;
(statearr_43951_46672[(1)] = (32));

} else {
var statearr_43952_46674 = state_43912__$1;
(statearr_43952_46674[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (32))){
var inst_43864 = (state_43912[(14)]);
var state_43912__$1 = state_43912;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_43912__$1,(35),out,inst_43864);
} else {
if((state_val_43913 === (33))){
var inst_43854 = (state_43912[(12)]);
var inst_43831 = inst_43854;
var state_43912__$1 = (function (){var statearr_43953 = state_43912;
(statearr_43953[(7)] = inst_43831);

return statearr_43953;
})();
var statearr_43957_46684 = state_43912__$1;
(statearr_43957_46684[(2)] = null);

(statearr_43957_46684[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (13))){
var inst_43831 = (state_43912[(7)]);
var inst_43838 = inst_43831.cljs$lang$protocol_mask$partition0$;
var inst_43839 = (inst_43838 & (64));
var inst_43840 = inst_43831.cljs$core$ISeq$;
var inst_43841 = (cljs.core.PROTOCOL_SENTINEL === inst_43840);
var inst_43842 = ((inst_43839) || (inst_43841));
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43842)){
var statearr_43958_46714 = state_43912__$1;
(statearr_43958_46714[(1)] = (16));

} else {
var statearr_43959_46715 = state_43912__$1;
(statearr_43959_46715[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (22))){
var inst_43868 = (state_43912[(9)]);
var inst_43864 = (state_43912[(14)]);
var inst_43862 = (state_43912[(2)]);
var inst_43864__$1 = cljs.core.nth.call(null,inst_43862,(0),null);
var inst_43868__$1 = cljs.core.nth.call(null,inst_43862,(1),null);
var inst_43869 = (inst_43864__$1 == null);
var inst_43870 = cljs.core._EQ_.call(null,inst_43868__$1,change);
var inst_43871 = ((inst_43869) || (inst_43870));
var state_43912__$1 = (function (){var statearr_43963 = state_43912;
(statearr_43963[(9)] = inst_43868__$1);

(statearr_43963[(14)] = inst_43864__$1);

return statearr_43963;
})();
if(cljs.core.truth_(inst_43871)){
var statearr_43964_46721 = state_43912__$1;
(statearr_43964_46721[(1)] = (23));

} else {
var statearr_43965_46728 = state_43912__$1;
(statearr_43965_46728[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (36))){
var inst_43854 = (state_43912[(12)]);
var inst_43831 = inst_43854;
var state_43912__$1 = (function (){var statearr_43966 = state_43912;
(statearr_43966[(7)] = inst_43831);

return statearr_43966;
})();
var statearr_43967_46730 = state_43912__$1;
(statearr_43967_46730[(2)] = null);

(statearr_43967_46730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (29))){
var inst_43883 = (state_43912[(11)]);
var state_43912__$1 = state_43912;
var statearr_43968_46731 = state_43912__$1;
(statearr_43968_46731[(2)] = inst_43883);

(statearr_43968_46731[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (6))){
var state_43912__$1 = state_43912;
var statearr_43969_46733 = state_43912__$1;
(statearr_43969_46733[(2)] = false);

(statearr_43969_46733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (28))){
var inst_43879 = (state_43912[(2)]);
var inst_43880 = calc_state();
var inst_43831 = inst_43880;
var state_43912__$1 = (function (){var statearr_43971 = state_43912;
(statearr_43971[(7)] = inst_43831);

(statearr_43971[(15)] = inst_43879);

return statearr_43971;
})();
var statearr_43973_46740 = state_43912__$1;
(statearr_43973_46740[(2)] = null);

(statearr_43973_46740[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (25))){
var inst_43906 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
var statearr_43974_46741 = state_43912__$1;
(statearr_43974_46741[(2)] = inst_43906);

(statearr_43974_46741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (34))){
var inst_43904 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
var statearr_43975_46745 = state_43912__$1;
(statearr_43975_46745[(2)] = inst_43904);

(statearr_43975_46745[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (17))){
var state_43912__$1 = state_43912;
var statearr_43976_46746 = state_43912__$1;
(statearr_43976_46746[(2)] = false);

(statearr_43976_46746[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (3))){
var state_43912__$1 = state_43912;
var statearr_43979_46747 = state_43912__$1;
(statearr_43979_46747[(2)] = false);

(statearr_43979_46747[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (12))){
var inst_43908 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43912__$1,inst_43908);
} else {
if((state_val_43913 === (2))){
var inst_43806 = (state_43912[(8)]);
var inst_43811 = inst_43806.cljs$lang$protocol_mask$partition0$;
var inst_43812 = (inst_43811 & (64));
var inst_43813 = inst_43806.cljs$core$ISeq$;
var inst_43814 = (cljs.core.PROTOCOL_SENTINEL === inst_43813);
var inst_43815 = ((inst_43812) || (inst_43814));
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43815)){
var statearr_43981_46750 = state_43912__$1;
(statearr_43981_46750[(1)] = (5));

} else {
var statearr_43982_46752 = state_43912__$1;
(statearr_43982_46752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (23))){
var inst_43864 = (state_43912[(14)]);
var inst_43873 = (inst_43864 == null);
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43873)){
var statearr_43987_46760 = state_43912__$1;
(statearr_43987_46760[(1)] = (26));

} else {
var statearr_43988_46761 = state_43912__$1;
(statearr_43988_46761[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (35))){
var inst_43895 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
if(cljs.core.truth_(inst_43895)){
var statearr_43995_46762 = state_43912__$1;
(statearr_43995_46762[(1)] = (36));

} else {
var statearr_43996_46763 = state_43912__$1;
(statearr_43996_46763[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (19))){
var inst_43831 = (state_43912[(7)]);
var inst_43851 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43831);
var state_43912__$1 = state_43912;
var statearr_44000_46764 = state_43912__$1;
(statearr_44000_46764[(2)] = inst_43851);

(statearr_44000_46764[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (11))){
var inst_43831 = (state_43912[(7)]);
var inst_43835 = (inst_43831 == null);
var inst_43836 = cljs.core.not(inst_43835);
var state_43912__$1 = state_43912;
if(inst_43836){
var statearr_44001_46766 = state_43912__$1;
(statearr_44001_46766[(1)] = (13));

} else {
var statearr_44002_46767 = state_43912__$1;
(statearr_44002_46767[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (9))){
var inst_43806 = (state_43912[(8)]);
var state_43912__$1 = state_43912;
var statearr_44003_46768 = state_43912__$1;
(statearr_44003_46768[(2)] = inst_43806);

(statearr_44003_46768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (5))){
var state_43912__$1 = state_43912;
var statearr_44004_46770 = state_43912__$1;
(statearr_44004_46770[(2)] = true);

(statearr_44004_46770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (14))){
var state_43912__$1 = state_43912;
var statearr_44005_46771 = state_43912__$1;
(statearr_44005_46771[(2)] = false);

(statearr_44005_46771[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (26))){
var inst_43868 = (state_43912[(9)]);
var inst_43876 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_43868);
var state_43912__$1 = state_43912;
var statearr_44006_46772 = state_43912__$1;
(statearr_44006_46772[(2)] = inst_43876);

(statearr_44006_46772[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (16))){
var state_43912__$1 = state_43912;
var statearr_44007_46776 = state_43912__$1;
(statearr_44007_46776[(2)] = true);

(statearr_44007_46776[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (38))){
var inst_43900 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
var statearr_44008_46783 = state_43912__$1;
(statearr_44008_46783[(2)] = inst_43900);

(statearr_44008_46783[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (30))){
var inst_43856 = (state_43912[(13)]);
var inst_43868 = (state_43912[(9)]);
var inst_43855 = (state_43912[(10)]);
var inst_43887 = cljs.core.empty_QMARK_.call(null,inst_43855);
var inst_43888 = inst_43856.call(null,inst_43868);
var inst_43889 = cljs.core.not(inst_43888);
var inst_43890 = ((inst_43887) && (inst_43889));
var state_43912__$1 = state_43912;
var statearr_44009_46784 = state_43912__$1;
(statearr_44009_46784[(2)] = inst_43890);

(statearr_44009_46784[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (10))){
var inst_43806 = (state_43912[(8)]);
var inst_43827 = (state_43912[(2)]);
var inst_43828 = cljs.core.get.call(null,inst_43827,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_43829 = cljs.core.get.call(null,inst_43827,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_43830 = cljs.core.get.call(null,inst_43827,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_43831 = inst_43806;
var state_43912__$1 = (function (){var statearr_44011 = state_43912;
(statearr_44011[(16)] = inst_43830);

(statearr_44011[(7)] = inst_43831);

(statearr_44011[(17)] = inst_43829);

(statearr_44011[(18)] = inst_43828);

return statearr_44011;
})();
var statearr_44014_46785 = state_43912__$1;
(statearr_44014_46785[(2)] = null);

(statearr_44014_46785[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (18))){
var inst_43846 = (state_43912[(2)]);
var state_43912__$1 = state_43912;
var statearr_44016_46786 = state_43912__$1;
(statearr_44016_46786[(2)] = inst_43846);

(statearr_44016_46786[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (37))){
var state_43912__$1 = state_43912;
var statearr_44017_46787 = state_43912__$1;
(statearr_44017_46787[(2)] = null);

(statearr_44017_46787[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43913 === (8))){
var inst_43806 = (state_43912[(8)]);
var inst_43824 = cljs.core.apply.call(null,cljs.core.hash_map,inst_43806);
var state_43912__$1 = state_43912;
var statearr_44019_46794 = state_43912__$1;
(statearr_44019_46794[(2)] = inst_43824);

(statearr_44019_46794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__41875__auto__ = null;
var cljs$core$async$mix_$_state_machine__41875__auto____0 = (function (){
var statearr_44020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44020[(0)] = cljs$core$async$mix_$_state_machine__41875__auto__);

(statearr_44020[(1)] = (1));

return statearr_44020;
});
var cljs$core$async$mix_$_state_machine__41875__auto____1 = (function (state_43912){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_43912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44021){var ex__41878__auto__ = e44021;
var statearr_44024_46795 = state_43912;
(statearr_44024_46795[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_43912[(4)]))){
var statearr_44025_46796 = state_43912;
(statearr_44025_46796[(1)] = cljs.core.first.call(null,(state_43912[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46797 = state_43912;
state_43912 = G__46797;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41875__auto__ = function(state_43912){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41875__auto____1.call(this,state_43912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41875__auto____0;
cljs$core$async$mix_$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41875__auto____1;
return cljs$core$async$mix_$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44026 = f__42105__auto__();
(statearr_44026[(6)] = c__42104__auto___46621);

return statearr_44026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_46799 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_46799(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_46804 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_46804(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_46809 = (function() {
var G__46810 = null;
var G__46810__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__46810__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__46810 = function(p,v){
switch(arguments.length){
case 1:
return G__46810__1.call(this,p);
case 2:
return G__46810__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46810.cljs$core$IFn$_invoke$arity$1 = G__46810__1;
G__46810.cljs$core$IFn$_invoke$arity$2 = G__46810__2;
return G__46810;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__44104 = arguments.length;
switch (G__44104) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46809(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_46809(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__44125 = arguments.length;
switch (G__44125) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__44118_SHARP_){
if(cljs.core.truth_(p1__44118_SHARP_.call(null,topic))){
return p1__44118_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__44118_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44134 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44134 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta44135){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta44135 = meta44135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44136,meta44135__$1){
var self__ = this;
var _44136__$1 = this;
return (new cljs.core.async.t_cljs$core$async44134(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta44135__$1));
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44136){
var self__ = this;
var _44136__$1 = this;
return self__.meta44135;
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async44134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async44134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta44135","meta44135",-1120144759,null)], null);
}));

(cljs.core.async.t_cljs$core$async44134.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44134");

(cljs.core.async.t_cljs$core$async44134.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44134");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44134.
 */
cljs.core.async.__GT_t_cljs$core$async44134 = (function cljs$core$async$__GT_t_cljs$core$async44134(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44135){
return (new cljs.core.async.t_cljs$core$async44134(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta44135));
});

}

return (new cljs.core.async.t_cljs$core$async44134(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__42104__auto___46831 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44259){
var state_val_44260 = (state_44259[(1)]);
if((state_val_44260 === (7))){
var inst_44254 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44266_46832 = state_44259__$1;
(statearr_44266_46832[(2)] = inst_44254);

(statearr_44266_46832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (20))){
var state_44259__$1 = state_44259;
var statearr_44271_46833 = state_44259__$1;
(statearr_44271_46833[(2)] = null);

(statearr_44271_46833[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (1))){
var state_44259__$1 = state_44259;
var statearr_44273_46834 = state_44259__$1;
(statearr_44273_46834[(2)] = null);

(statearr_44273_46834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (24))){
var inst_44230 = (state_44259[(7)]);
var inst_44246 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_44230);
var state_44259__$1 = state_44259;
var statearr_44275_46836 = state_44259__$1;
(statearr_44275_46836[(2)] = inst_44246);

(statearr_44275_46836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (4))){
var inst_44168 = (state_44259[(8)]);
var inst_44168__$1 = (state_44259[(2)]);
var inst_44172 = (inst_44168__$1 == null);
var state_44259__$1 = (function (){var statearr_44276 = state_44259;
(statearr_44276[(8)] = inst_44168__$1);

return statearr_44276;
})();
if(cljs.core.truth_(inst_44172)){
var statearr_44277_46840 = state_44259__$1;
(statearr_44277_46840[(1)] = (5));

} else {
var statearr_44278_46841 = state_44259__$1;
(statearr_44278_46841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (15))){
var inst_44224 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44279_46842 = state_44259__$1;
(statearr_44279_46842[(2)] = inst_44224);

(statearr_44279_46842[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (21))){
var inst_44251 = (state_44259[(2)]);
var state_44259__$1 = (function (){var statearr_44283 = state_44259;
(statearr_44283[(9)] = inst_44251);

return statearr_44283;
})();
var statearr_44284_46844 = state_44259__$1;
(statearr_44284_46844[(2)] = null);

(statearr_44284_46844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (13))){
var inst_44203 = (state_44259[(10)]);
var inst_44206 = cljs.core.chunked_seq_QMARK_.call(null,inst_44203);
var state_44259__$1 = state_44259;
if(inst_44206){
var statearr_44285_46846 = state_44259__$1;
(statearr_44285_46846[(1)] = (16));

} else {
var statearr_44286_46847 = state_44259__$1;
(statearr_44286_46847[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (22))){
var inst_44242 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
if(cljs.core.truth_(inst_44242)){
var statearr_44288_46849 = state_44259__$1;
(statearr_44288_46849[(1)] = (23));

} else {
var statearr_44289_46852 = state_44259__$1;
(statearr_44289_46852[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (6))){
var inst_44238 = (state_44259[(11)]);
var inst_44168 = (state_44259[(8)]);
var inst_44230 = (state_44259[(7)]);
var inst_44230__$1 = topic_fn.call(null,inst_44168);
var inst_44237 = cljs.core.deref.call(null,mults);
var inst_44238__$1 = cljs.core.get.call(null,inst_44237,inst_44230__$1);
var state_44259__$1 = (function (){var statearr_44291 = state_44259;
(statearr_44291[(11)] = inst_44238__$1);

(statearr_44291[(7)] = inst_44230__$1);

return statearr_44291;
})();
if(cljs.core.truth_(inst_44238__$1)){
var statearr_44292_46857 = state_44259__$1;
(statearr_44292_46857[(1)] = (19));

} else {
var statearr_44293_46858 = state_44259__$1;
(statearr_44293_46858[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (25))){
var inst_44248 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44294_46863 = state_44259__$1;
(statearr_44294_46863[(2)] = inst_44248);

(statearr_44294_46863[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (17))){
var inst_44203 = (state_44259[(10)]);
var inst_44215 = cljs.core.first.call(null,inst_44203);
var inst_44216 = cljs.core.async.muxch_STAR_(inst_44215);
var inst_44217 = cljs.core.async.close_BANG_.call(null,inst_44216);
var inst_44218 = cljs.core.next.call(null,inst_44203);
var inst_44185 = inst_44218;
var inst_44186 = null;
var inst_44187 = (0);
var inst_44188 = (0);
var state_44259__$1 = (function (){var statearr_44298 = state_44259;
(statearr_44298[(12)] = inst_44188);

(statearr_44298[(13)] = inst_44187);

(statearr_44298[(14)] = inst_44185);

(statearr_44298[(15)] = inst_44217);

(statearr_44298[(16)] = inst_44186);

return statearr_44298;
})();
var statearr_44304_46874 = state_44259__$1;
(statearr_44304_46874[(2)] = null);

(statearr_44304_46874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (3))){
var inst_44256 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44259__$1,inst_44256);
} else {
if((state_val_44260 === (12))){
var inst_44226 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44306_46878 = state_44259__$1;
(statearr_44306_46878[(2)] = inst_44226);

(statearr_44306_46878[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (2))){
var state_44259__$1 = state_44259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44259__$1,(4),ch);
} else {
if((state_val_44260 === (23))){
var state_44259__$1 = state_44259;
var statearr_44308_46879 = state_44259__$1;
(statearr_44308_46879[(2)] = null);

(statearr_44308_46879[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (19))){
var inst_44238 = (state_44259[(11)]);
var inst_44168 = (state_44259[(8)]);
var inst_44240 = cljs.core.async.muxch_STAR_(inst_44238);
var state_44259__$1 = state_44259;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44259__$1,(22),inst_44240,inst_44168);
} else {
if((state_val_44260 === (11))){
var inst_44185 = (state_44259[(14)]);
var inst_44203 = (state_44259[(10)]);
var inst_44203__$1 = cljs.core.seq.call(null,inst_44185);
var state_44259__$1 = (function (){var statearr_44310 = state_44259;
(statearr_44310[(10)] = inst_44203__$1);

return statearr_44310;
})();
if(inst_44203__$1){
var statearr_44311_46883 = state_44259__$1;
(statearr_44311_46883[(1)] = (13));

} else {
var statearr_44312_46884 = state_44259__$1;
(statearr_44312_46884[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (9))){
var inst_44228 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44317_46885 = state_44259__$1;
(statearr_44317_46885[(2)] = inst_44228);

(statearr_44317_46885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (5))){
var inst_44181 = cljs.core.deref.call(null,mults);
var inst_44182 = cljs.core.vals.call(null,inst_44181);
var inst_44183 = cljs.core.seq.call(null,inst_44182);
var inst_44185 = inst_44183;
var inst_44186 = null;
var inst_44187 = (0);
var inst_44188 = (0);
var state_44259__$1 = (function (){var statearr_44322 = state_44259;
(statearr_44322[(12)] = inst_44188);

(statearr_44322[(13)] = inst_44187);

(statearr_44322[(14)] = inst_44185);

(statearr_44322[(16)] = inst_44186);

return statearr_44322;
})();
var statearr_44323_46891 = state_44259__$1;
(statearr_44323_46891[(2)] = null);

(statearr_44323_46891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (14))){
var state_44259__$1 = state_44259;
var statearr_44331_46896 = state_44259__$1;
(statearr_44331_46896[(2)] = null);

(statearr_44331_46896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (16))){
var inst_44203 = (state_44259[(10)]);
var inst_44208 = cljs.core.chunk_first.call(null,inst_44203);
var inst_44209 = cljs.core.chunk_rest.call(null,inst_44203);
var inst_44210 = cljs.core.count.call(null,inst_44208);
var inst_44185 = inst_44209;
var inst_44186 = inst_44208;
var inst_44187 = inst_44210;
var inst_44188 = (0);
var state_44259__$1 = (function (){var statearr_44333 = state_44259;
(statearr_44333[(12)] = inst_44188);

(statearr_44333[(13)] = inst_44187);

(statearr_44333[(14)] = inst_44185);

(statearr_44333[(16)] = inst_44186);

return statearr_44333;
})();
var statearr_44334_46902 = state_44259__$1;
(statearr_44334_46902[(2)] = null);

(statearr_44334_46902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (10))){
var inst_44188 = (state_44259[(12)]);
var inst_44187 = (state_44259[(13)]);
var inst_44185 = (state_44259[(14)]);
var inst_44186 = (state_44259[(16)]);
var inst_44197 = cljs.core._nth(inst_44186,inst_44188);
var inst_44198 = cljs.core.async.muxch_STAR_(inst_44197);
var inst_44199 = cljs.core.async.close_BANG_.call(null,inst_44198);
var inst_44200 = (inst_44188 + (1));
var tmp44328 = inst_44187;
var tmp44329 = inst_44185;
var tmp44330 = inst_44186;
var inst_44185__$1 = tmp44329;
var inst_44186__$1 = tmp44330;
var inst_44187__$1 = tmp44328;
var inst_44188__$1 = inst_44200;
var state_44259__$1 = (function (){var statearr_44339 = state_44259;
(statearr_44339[(12)] = inst_44188__$1);

(statearr_44339[(17)] = inst_44199);

(statearr_44339[(13)] = inst_44187__$1);

(statearr_44339[(14)] = inst_44185__$1);

(statearr_44339[(16)] = inst_44186__$1);

return statearr_44339;
})();
var statearr_44340_46906 = state_44259__$1;
(statearr_44340_46906[(2)] = null);

(statearr_44340_46906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (18))){
var inst_44221 = (state_44259[(2)]);
var state_44259__$1 = state_44259;
var statearr_44341_46907 = state_44259__$1;
(statearr_44341_46907[(2)] = inst_44221);

(statearr_44341_46907[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44260 === (8))){
var inst_44188 = (state_44259[(12)]);
var inst_44187 = (state_44259[(13)]);
var inst_44193 = (inst_44188 < inst_44187);
var inst_44195 = inst_44193;
var state_44259__$1 = state_44259;
if(cljs.core.truth_(inst_44195)){
var statearr_44342_46914 = state_44259__$1;
(statearr_44342_46914[(1)] = (10));

} else {
var statearr_44343_46915 = state_44259__$1;
(statearr_44343_46915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_44344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44344[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_44344[(1)] = (1));

return statearr_44344;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_44259){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44345){var ex__41878__auto__ = e44345;
var statearr_44346_46922 = state_44259;
(statearr_44346_46922[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44259[(4)]))){
var statearr_44347_46923 = state_44259;
(statearr_44347_46923[(1)] = cljs.core.first.call(null,(state_44259[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46924 = state_44259;
state_44259 = G__46924;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_44259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_44259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44348 = f__42105__auto__();
(statearr_44348[(6)] = c__42104__auto___46831);

return statearr_44348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__44363 = arguments.length;
switch (G__44363) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__44373 = arguments.length;
switch (G__44373) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__44382 = arguments.length;
switch (G__44382) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__42104__auto___46942 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44442){
var state_val_44444 = (state_44442[(1)]);
if((state_val_44444 === (7))){
var state_44442__$1 = state_44442;
var statearr_44446_46944 = state_44442__$1;
(statearr_44446_46944[(2)] = null);

(statearr_44446_46944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (1))){
var state_44442__$1 = state_44442;
var statearr_44447_46945 = state_44442__$1;
(statearr_44447_46945[(2)] = null);

(statearr_44447_46945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (4))){
var inst_44386 = (state_44442[(7)]);
var inst_44385 = (state_44442[(8)]);
var inst_44397 = (inst_44386 < inst_44385);
var state_44442__$1 = state_44442;
if(cljs.core.truth_(inst_44397)){
var statearr_44451_46952 = state_44442__$1;
(statearr_44451_46952[(1)] = (6));

} else {
var statearr_44452_46953 = state_44442__$1;
(statearr_44452_46953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (15))){
var inst_44426 = (state_44442[(9)]);
var inst_44431 = cljs.core.apply.call(null,f,inst_44426);
var state_44442__$1 = state_44442;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44442__$1,(17),out,inst_44431);
} else {
if((state_val_44444 === (13))){
var inst_44426 = (state_44442[(9)]);
var inst_44426__$1 = (state_44442[(2)]);
var inst_44427 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_44426__$1);
var state_44442__$1 = (function (){var statearr_44454 = state_44442;
(statearr_44454[(9)] = inst_44426__$1);

return statearr_44454;
})();
if(cljs.core.truth_(inst_44427)){
var statearr_44455_46954 = state_44442__$1;
(statearr_44455_46954[(1)] = (14));

} else {
var statearr_44456_46955 = state_44442__$1;
(statearr_44456_46955[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (6))){
var state_44442__$1 = state_44442;
var statearr_44457_46956 = state_44442__$1;
(statearr_44457_46956[(2)] = null);

(statearr_44457_46956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (17))){
var inst_44433 = (state_44442[(2)]);
var state_44442__$1 = (function (){var statearr_44464 = state_44442;
(statearr_44464[(10)] = inst_44433);

return statearr_44464;
})();
var statearr_44465_46957 = state_44442__$1;
(statearr_44465_46957[(2)] = null);

(statearr_44465_46957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (3))){
var inst_44438 = (state_44442[(2)]);
var state_44442__$1 = state_44442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44442__$1,inst_44438);
} else {
if((state_val_44444 === (12))){
var _ = (function (){var statearr_44466 = state_44442;
(statearr_44466[(4)] = cljs.core.rest.call(null,(state_44442[(4)])));

return statearr_44466;
})();
var state_44442__$1 = state_44442;
var ex44463 = (state_44442__$1[(2)]);
var statearr_44468_46959 = state_44442__$1;
(statearr_44468_46959[(5)] = ex44463);


if((ex44463 instanceof Object)){
var statearr_44469_46960 = state_44442__$1;
(statearr_44469_46960[(1)] = (11));

(statearr_44469_46960[(5)] = null);

} else {
throw ex44463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (2))){
var inst_44384 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_44385 = cnt;
var inst_44386 = (0);
var state_44442__$1 = (function (){var statearr_44484 = state_44442;
(statearr_44484[(11)] = inst_44384);

(statearr_44484[(7)] = inst_44386);

(statearr_44484[(8)] = inst_44385);

return statearr_44484;
})();
var statearr_44488_46961 = state_44442__$1;
(statearr_44488_46961[(2)] = null);

(statearr_44488_46961[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (11))){
var inst_44405 = (state_44442[(2)]);
var inst_44406 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_44442__$1 = (function (){var statearr_44489 = state_44442;
(statearr_44489[(12)] = inst_44405);

return statearr_44489;
})();
var statearr_44490_46968 = state_44442__$1;
(statearr_44490_46968[(2)] = inst_44406);

(statearr_44490_46968[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (9))){
var inst_44386 = (state_44442[(7)]);
var _ = (function (){var statearr_44491 = state_44442;
(statearr_44491[(4)] = cljs.core.cons.call(null,(12),(state_44442[(4)])));

return statearr_44491;
})();
var inst_44412 = chs__$1.call(null,inst_44386);
var inst_44413 = done.call(null,inst_44386);
var inst_44414 = cljs.core.async.take_BANG_.call(null,inst_44412,inst_44413);
var ___$1 = (function (){var statearr_44492 = state_44442;
(statearr_44492[(4)] = cljs.core.rest.call(null,(state_44442[(4)])));

return statearr_44492;
})();
var state_44442__$1 = state_44442;
var statearr_44493_46981 = state_44442__$1;
(statearr_44493_46981[(2)] = inst_44414);

(statearr_44493_46981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (5))){
var inst_44424 = (state_44442[(2)]);
var state_44442__$1 = (function (){var statearr_44495 = state_44442;
(statearr_44495[(13)] = inst_44424);

return statearr_44495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44442__$1,(13),dchan);
} else {
if((state_val_44444 === (14))){
var inst_44429 = cljs.core.async.close_BANG_.call(null,out);
var state_44442__$1 = state_44442;
var statearr_44496_46985 = state_44442__$1;
(statearr_44496_46985[(2)] = inst_44429);

(statearr_44496_46985[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (16))){
var inst_44436 = (state_44442[(2)]);
var state_44442__$1 = state_44442;
var statearr_44498_46986 = state_44442__$1;
(statearr_44498_46986[(2)] = inst_44436);

(statearr_44498_46986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (10))){
var inst_44386 = (state_44442[(7)]);
var inst_44417 = (state_44442[(2)]);
var inst_44418 = (inst_44386 + (1));
var inst_44386__$1 = inst_44418;
var state_44442__$1 = (function (){var statearr_44500 = state_44442;
(statearr_44500[(14)] = inst_44417);

(statearr_44500[(7)] = inst_44386__$1);

return statearr_44500;
})();
var statearr_44507_46987 = state_44442__$1;
(statearr_44507_46987[(2)] = null);

(statearr_44507_46987[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44444 === (8))){
var inst_44422 = (state_44442[(2)]);
var state_44442__$1 = state_44442;
var statearr_44508_46992 = state_44442__$1;
(statearr_44508_46992[(2)] = inst_44422);

(statearr_44508_46992[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_44514 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44514[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_44514[(1)] = (1));

return statearr_44514;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_44442){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44515){var ex__41878__auto__ = e44515;
var statearr_44516_46993 = state_44442;
(statearr_44516_46993[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44442[(4)]))){
var statearr_44518_46994 = state_44442;
(statearr_44518_46994[(1)] = cljs.core.first.call(null,(state_44442[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46995 = state_44442;
state_44442 = G__46995;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_44442){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_44442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44521 = f__42105__auto__();
(statearr_44521[(6)] = c__42104__auto___46942);

return statearr_44521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__44526 = arguments.length;
switch (G__44526) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47008 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44567){
var state_val_44568 = (state_44567[(1)]);
if((state_val_44568 === (7))){
var inst_44545 = (state_44567[(7)]);
var inst_44546 = (state_44567[(8)]);
var inst_44545__$1 = (state_44567[(2)]);
var inst_44546__$1 = cljs.core.nth.call(null,inst_44545__$1,(0),null);
var inst_44547 = cljs.core.nth.call(null,inst_44545__$1,(1),null);
var inst_44548 = (inst_44546__$1 == null);
var state_44567__$1 = (function (){var statearr_44573 = state_44567;
(statearr_44573[(9)] = inst_44547);

(statearr_44573[(7)] = inst_44545__$1);

(statearr_44573[(8)] = inst_44546__$1);

return statearr_44573;
})();
if(cljs.core.truth_(inst_44548)){
var statearr_44574_47016 = state_44567__$1;
(statearr_44574_47016[(1)] = (8));

} else {
var statearr_44575_47017 = state_44567__$1;
(statearr_44575_47017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (1))){
var inst_44535 = cljs.core.vec.call(null,chs);
var inst_44536 = inst_44535;
var state_44567__$1 = (function (){var statearr_44576 = state_44567;
(statearr_44576[(10)] = inst_44536);

return statearr_44576;
})();
var statearr_44581_47018 = state_44567__$1;
(statearr_44581_47018[(2)] = null);

(statearr_44581_47018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (4))){
var inst_44536 = (state_44567[(10)]);
var state_44567__$1 = state_44567;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44567__$1,(7),inst_44536);
} else {
if((state_val_44568 === (6))){
var inst_44563 = (state_44567[(2)]);
var state_44567__$1 = state_44567;
var statearr_44588_47019 = state_44567__$1;
(statearr_44588_47019[(2)] = inst_44563);

(statearr_44588_47019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (3))){
var inst_44565 = (state_44567[(2)]);
var state_44567__$1 = state_44567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44567__$1,inst_44565);
} else {
if((state_val_44568 === (2))){
var inst_44536 = (state_44567[(10)]);
var inst_44538 = cljs.core.count.call(null,inst_44536);
var inst_44539 = (inst_44538 > (0));
var state_44567__$1 = state_44567;
if(cljs.core.truth_(inst_44539)){
var statearr_44592_47022 = state_44567__$1;
(statearr_44592_47022[(1)] = (4));

} else {
var statearr_44595_47023 = state_44567__$1;
(statearr_44595_47023[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (11))){
var inst_44536 = (state_44567[(10)]);
var inst_44555 = (state_44567[(2)]);
var tmp44589 = inst_44536;
var inst_44536__$1 = tmp44589;
var state_44567__$1 = (function (){var statearr_44596 = state_44567;
(statearr_44596[(11)] = inst_44555);

(statearr_44596[(10)] = inst_44536__$1);

return statearr_44596;
})();
var statearr_44597_47024 = state_44567__$1;
(statearr_44597_47024[(2)] = null);

(statearr_44597_47024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (9))){
var inst_44546 = (state_44567[(8)]);
var state_44567__$1 = state_44567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44567__$1,(11),out,inst_44546);
} else {
if((state_val_44568 === (5))){
var inst_44561 = cljs.core.async.close_BANG_.call(null,out);
var state_44567__$1 = state_44567;
var statearr_44602_47027 = state_44567__$1;
(statearr_44602_47027[(2)] = inst_44561);

(statearr_44602_47027[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (10))){
var inst_44559 = (state_44567[(2)]);
var state_44567__$1 = state_44567;
var statearr_44604_47032 = state_44567__$1;
(statearr_44604_47032[(2)] = inst_44559);

(statearr_44604_47032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44568 === (8))){
var inst_44547 = (state_44567[(9)]);
var inst_44545 = (state_44567[(7)]);
var inst_44546 = (state_44567[(8)]);
var inst_44536 = (state_44567[(10)]);
var inst_44550 = (function (){var cs = inst_44536;
var vec__44541 = inst_44545;
var v = inst_44546;
var c = inst_44547;
return (function (p1__44524_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__44524_SHARP_);
});
})();
var inst_44551 = cljs.core.filterv.call(null,inst_44550,inst_44536);
var inst_44536__$1 = inst_44551;
var state_44567__$1 = (function (){var statearr_44612 = state_44567;
(statearr_44612[(10)] = inst_44536__$1);

return statearr_44612;
})();
var statearr_44613_47033 = state_44567__$1;
(statearr_44613_47033[(2)] = null);

(statearr_44613_47033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_44616 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44616[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_44616[(1)] = (1));

return statearr_44616;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_44567){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44617){var ex__41878__auto__ = e44617;
var statearr_44618_47039 = state_44567;
(statearr_44618_47039[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44567[(4)]))){
var statearr_44619_47040 = state_44567;
(statearr_44619_47040[(1)] = cljs.core.first.call(null,(state_44567[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47041 = state_44567;
state_44567 = G__47041;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_44567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_44567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44623 = f__42105__auto__();
(statearr_44623[(6)] = c__42104__auto___47008);

return statearr_44623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__44635 = arguments.length;
switch (G__44635) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44670){
var state_val_44671 = (state_44670[(1)]);
if((state_val_44671 === (7))){
var inst_44649 = (state_44670[(7)]);
var inst_44649__$1 = (state_44670[(2)]);
var inst_44652 = (inst_44649__$1 == null);
var inst_44653 = cljs.core.not(inst_44652);
var state_44670__$1 = (function (){var statearr_44675 = state_44670;
(statearr_44675[(7)] = inst_44649__$1);

return statearr_44675;
})();
if(inst_44653){
var statearr_44676_47048 = state_44670__$1;
(statearr_44676_47048[(1)] = (8));

} else {
var statearr_44677_47049 = state_44670__$1;
(statearr_44677_47049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (1))){
var inst_44639 = (0);
var state_44670__$1 = (function (){var statearr_44682 = state_44670;
(statearr_44682[(8)] = inst_44639);

return statearr_44682;
})();
var statearr_44683_47050 = state_44670__$1;
(statearr_44683_47050[(2)] = null);

(statearr_44683_47050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (4))){
var state_44670__$1 = state_44670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44670__$1,(7),ch);
} else {
if((state_val_44671 === (6))){
var inst_44665 = (state_44670[(2)]);
var state_44670__$1 = state_44670;
var statearr_44684_47053 = state_44670__$1;
(statearr_44684_47053[(2)] = inst_44665);

(statearr_44684_47053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (3))){
var inst_44667 = (state_44670[(2)]);
var inst_44668 = cljs.core.async.close_BANG_.call(null,out);
var state_44670__$1 = (function (){var statearr_44685 = state_44670;
(statearr_44685[(9)] = inst_44667);

return statearr_44685;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44670__$1,inst_44668);
} else {
if((state_val_44671 === (2))){
var inst_44639 = (state_44670[(8)]);
var inst_44645 = (inst_44639 < n);
var state_44670__$1 = state_44670;
if(cljs.core.truth_(inst_44645)){
var statearr_44686_47054 = state_44670__$1;
(statearr_44686_47054[(1)] = (4));

} else {
var statearr_44687_47055 = state_44670__$1;
(statearr_44687_47055[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (11))){
var inst_44639 = (state_44670[(8)]);
var inst_44656 = (state_44670[(2)]);
var inst_44657 = (inst_44639 + (1));
var inst_44639__$1 = inst_44657;
var state_44670__$1 = (function (){var statearr_44688 = state_44670;
(statearr_44688[(8)] = inst_44639__$1);

(statearr_44688[(10)] = inst_44656);

return statearr_44688;
})();
var statearr_44689_47059 = state_44670__$1;
(statearr_44689_47059[(2)] = null);

(statearr_44689_47059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (9))){
var state_44670__$1 = state_44670;
var statearr_44692_47060 = state_44670__$1;
(statearr_44692_47060[(2)] = null);

(statearr_44692_47060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (5))){
var state_44670__$1 = state_44670;
var statearr_44693_47062 = state_44670__$1;
(statearr_44693_47062[(2)] = null);

(statearr_44693_47062[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (10))){
var inst_44662 = (state_44670[(2)]);
var state_44670__$1 = state_44670;
var statearr_44694_47063 = state_44670__$1;
(statearr_44694_47063[(2)] = inst_44662);

(statearr_44694_47063[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44671 === (8))){
var inst_44649 = (state_44670[(7)]);
var state_44670__$1 = state_44670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44670__$1,(11),out,inst_44649);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_44699 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44699[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_44699[(1)] = (1));

return statearr_44699;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_44670){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44700){var ex__41878__auto__ = e44700;
var statearr_44701_47069 = state_44670;
(statearr_44701_47069[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44670[(4)]))){
var statearr_44702_47071 = state_44670;
(statearr_44702_47071[(1)] = cljs.core.first.call(null,(state_44670[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47073 = state_44670;
state_44670 = G__47073;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_44670){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_44670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44703 = f__42105__auto__();
(statearr_44703[(6)] = c__42104__auto___47047);

return statearr_44703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44707 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44707 = (function (f,ch,meta44708){
this.f = f;
this.ch = ch;
this.meta44708 = meta44708;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44709,meta44708__$1){
var self__ = this;
var _44709__$1 = this;
return (new cljs.core.async.t_cljs$core$async44707(self__.f,self__.ch,meta44708__$1));
}));

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44709){
var self__ = this;
var _44709__$1 = this;
return self__.meta44708;
}));

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44715 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44715 = (function (f,ch,meta44708,_,fn1,meta44716){
this.f = f;
this.ch = ch;
this.meta44708 = meta44708;
this._ = _;
this.fn1 = fn1;
this.meta44716 = meta44716;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44717,meta44716__$1){
var self__ = this;
var _44717__$1 = this;
return (new cljs.core.async.t_cljs$core$async44715(self__.f,self__.ch,self__.meta44708,self__._,self__.fn1,meta44716__$1));
}));

(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44717){
var self__ = this;
var _44717__$1 = this;
return self__.meta44716;
}));

(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44715.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__44705_SHARP_){
return f1.call(null,(((p1__44705_SHARP_ == null))?null:self__.f.call(null,p1__44705_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async44715.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44708","meta44708",-2091188752,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async44707","cljs.core.async/t_cljs$core$async44707",656171247,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta44716","meta44716",1169039261,null)], null);
}));

(cljs.core.async.t_cljs$core$async44715.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44715.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44715");

(cljs.core.async.t_cljs$core$async44715.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44715");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44715.
 */
cljs.core.async.__GT_t_cljs$core$async44715 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44715(f__$1,ch__$1,meta44708__$1,___$2,fn1__$1,meta44716){
return (new cljs.core.async.t_cljs$core$async44715(f__$1,ch__$1,meta44708__$1,___$2,fn1__$1,meta44716));
});

}

return (new cljs.core.async.t_cljs$core$async44715(self__.f,self__.ch,self__.meta44708,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44707.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async44707.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44708","meta44708",-2091188752,null)], null);
}));

(cljs.core.async.t_cljs$core$async44707.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44707.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44707");

(cljs.core.async.t_cljs$core$async44707.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44707");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44707.
 */
cljs.core.async.__GT_t_cljs$core$async44707 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async44707(f__$1,ch__$1,meta44708){
return (new cljs.core.async.t_cljs$core$async44707(f__$1,ch__$1,meta44708));
});

}

return (new cljs.core.async.t_cljs$core$async44707(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44740 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44740 = (function (f,ch,meta44741){
this.f = f;
this.ch = ch;
this.meta44741 = meta44741;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44742,meta44741__$1){
var self__ = this;
var _44742__$1 = this;
return (new cljs.core.async.t_cljs$core$async44740(self__.f,self__.ch,meta44741__$1));
}));

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44742){
var self__ = this;
var _44742__$1 = this;
return self__.meta44741;
}));

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44740.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async44740.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44741","meta44741",1467980277,null)], null);
}));

(cljs.core.async.t_cljs$core$async44740.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44740.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44740");

(cljs.core.async.t_cljs$core$async44740.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44740");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44740.
 */
cljs.core.async.__GT_t_cljs$core$async44740 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async44740(f__$1,ch__$1,meta44741){
return (new cljs.core.async.t_cljs$core$async44740(f__$1,ch__$1,meta44741));
});

}

return (new cljs.core.async.t_cljs$core$async44740(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44765 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44765 = (function (p,ch,meta44766){
this.p = p;
this.ch = ch;
this.meta44766 = meta44766;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44767,meta44766__$1){
var self__ = this;
var _44767__$1 = this;
return (new cljs.core.async.t_cljs$core$async44765(self__.p,self__.ch,meta44766__$1));
}));

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44767){
var self__ = this;
var _44767__$1 = this;
return self__.meta44766;
}));

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44765.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async44765.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta44766","meta44766",-1007280203,null)], null);
}));

(cljs.core.async.t_cljs$core$async44765.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44765.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44765");

(cljs.core.async.t_cljs$core$async44765.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44765");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44765.
 */
cljs.core.async.__GT_t_cljs$core$async44765 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async44765(p__$1,ch__$1,meta44766){
return (new cljs.core.async.t_cljs$core$async44765(p__$1,ch__$1,meta44766));
});

}

return (new cljs.core.async.t_cljs$core$async44765(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__44774 = arguments.length;
switch (G__44774) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47101 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44803){
var state_val_44804 = (state_44803[(1)]);
if((state_val_44804 === (7))){
var inst_44798 = (state_44803[(2)]);
var state_44803__$1 = state_44803;
var statearr_44806_47106 = state_44803__$1;
(statearr_44806_47106[(2)] = inst_44798);

(statearr_44806_47106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (1))){
var state_44803__$1 = state_44803;
var statearr_44808_47112 = state_44803__$1;
(statearr_44808_47112[(2)] = null);

(statearr_44808_47112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (4))){
var inst_44782 = (state_44803[(7)]);
var inst_44782__$1 = (state_44803[(2)]);
var inst_44785 = (inst_44782__$1 == null);
var state_44803__$1 = (function (){var statearr_44809 = state_44803;
(statearr_44809[(7)] = inst_44782__$1);

return statearr_44809;
})();
if(cljs.core.truth_(inst_44785)){
var statearr_44810_47119 = state_44803__$1;
(statearr_44810_47119[(1)] = (5));

} else {
var statearr_44811_47120 = state_44803__$1;
(statearr_44811_47120[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (6))){
var inst_44782 = (state_44803[(7)]);
var inst_44789 = p.call(null,inst_44782);
var state_44803__$1 = state_44803;
if(cljs.core.truth_(inst_44789)){
var statearr_44816_47122 = state_44803__$1;
(statearr_44816_47122[(1)] = (8));

} else {
var statearr_44819_47123 = state_44803__$1;
(statearr_44819_47123[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (3))){
var inst_44800 = (state_44803[(2)]);
var state_44803__$1 = state_44803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44803__$1,inst_44800);
} else {
if((state_val_44804 === (2))){
var state_44803__$1 = state_44803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44803__$1,(4),ch);
} else {
if((state_val_44804 === (11))){
var inst_44792 = (state_44803[(2)]);
var state_44803__$1 = state_44803;
var statearr_44821_47125 = state_44803__$1;
(statearr_44821_47125[(2)] = inst_44792);

(statearr_44821_47125[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (9))){
var state_44803__$1 = state_44803;
var statearr_44825_47126 = state_44803__$1;
(statearr_44825_47126[(2)] = null);

(statearr_44825_47126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (5))){
var inst_44787 = cljs.core.async.close_BANG_.call(null,out);
var state_44803__$1 = state_44803;
var statearr_44826_47128 = state_44803__$1;
(statearr_44826_47128[(2)] = inst_44787);

(statearr_44826_47128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (10))){
var inst_44795 = (state_44803[(2)]);
var state_44803__$1 = (function (){var statearr_44827 = state_44803;
(statearr_44827[(8)] = inst_44795);

return statearr_44827;
})();
var statearr_44828_47129 = state_44803__$1;
(statearr_44828_47129[(2)] = null);

(statearr_44828_47129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44804 === (8))){
var inst_44782 = (state_44803[(7)]);
var state_44803__$1 = state_44803;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44803__$1,(11),out,inst_44782);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_44836 = [null,null,null,null,null,null,null,null,null];
(statearr_44836[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_44836[(1)] = (1));

return statearr_44836;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_44803){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e44846){var ex__41878__auto__ = e44846;
var statearr_44847_47141 = state_44803;
(statearr_44847_47141[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44803[(4)]))){
var statearr_44848_47146 = state_44803;
(statearr_44848_47146[(1)] = cljs.core.first.call(null,(state_44803[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47147 = state_44803;
state_44803 = G__47147;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_44803){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_44803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_44852 = f__42105__auto__();
(statearr_44852[(6)] = c__42104__auto___47101);

return statearr_44852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__44857 = arguments.length;
switch (G__44857) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__42104__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_44956){
var state_val_44957 = (state_44956[(1)]);
if((state_val_44957 === (7))){
var inst_44951 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_44964_47163 = state_44956__$1;
(statearr_44964_47163[(2)] = inst_44951);

(statearr_44964_47163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (20))){
var inst_44918 = (state_44956[(7)]);
var inst_44932 = (state_44956[(2)]);
var inst_44933 = cljs.core.next.call(null,inst_44918);
var inst_44897 = inst_44933;
var inst_44898 = null;
var inst_44899 = (0);
var inst_44900 = (0);
var state_44956__$1 = (function (){var statearr_44966 = state_44956;
(statearr_44966[(8)] = inst_44897);

(statearr_44966[(9)] = inst_44898);

(statearr_44966[(10)] = inst_44932);

(statearr_44966[(11)] = inst_44899);

(statearr_44966[(12)] = inst_44900);

return statearr_44966;
})();
var statearr_44968_47168 = state_44956__$1;
(statearr_44968_47168[(2)] = null);

(statearr_44968_47168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (1))){
var state_44956__$1 = state_44956;
var statearr_44976_47169 = state_44956__$1;
(statearr_44976_47169[(2)] = null);

(statearr_44976_47169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (4))){
var inst_44886 = (state_44956[(13)]);
var inst_44886__$1 = (state_44956[(2)]);
var inst_44887 = (inst_44886__$1 == null);
var state_44956__$1 = (function (){var statearr_44978 = state_44956;
(statearr_44978[(13)] = inst_44886__$1);

return statearr_44978;
})();
if(cljs.core.truth_(inst_44887)){
var statearr_44979_47171 = state_44956__$1;
(statearr_44979_47171[(1)] = (5));

} else {
var statearr_44981_47173 = state_44956__$1;
(statearr_44981_47173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (15))){
var state_44956__$1 = state_44956;
var statearr_44985_47174 = state_44956__$1;
(statearr_44985_47174[(2)] = null);

(statearr_44985_47174[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (21))){
var state_44956__$1 = state_44956;
var statearr_44988_47175 = state_44956__$1;
(statearr_44988_47175[(2)] = null);

(statearr_44988_47175[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (13))){
var inst_44897 = (state_44956[(8)]);
var inst_44898 = (state_44956[(9)]);
var inst_44899 = (state_44956[(11)]);
var inst_44900 = (state_44956[(12)]);
var inst_44913 = (state_44956[(2)]);
var inst_44915 = (inst_44900 + (1));
var tmp44982 = inst_44897;
var tmp44983 = inst_44898;
var tmp44984 = inst_44899;
var inst_44897__$1 = tmp44982;
var inst_44898__$1 = tmp44983;
var inst_44899__$1 = tmp44984;
var inst_44900__$1 = inst_44915;
var state_44956__$1 = (function (){var statearr_44990 = state_44956;
(statearr_44990[(8)] = inst_44897__$1);

(statearr_44990[(9)] = inst_44898__$1);

(statearr_44990[(11)] = inst_44899__$1);

(statearr_44990[(14)] = inst_44913);

(statearr_44990[(12)] = inst_44900__$1);

return statearr_44990;
})();
var statearr_44995_47179 = state_44956__$1;
(statearr_44995_47179[(2)] = null);

(statearr_44995_47179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (22))){
var state_44956__$1 = state_44956;
var statearr_45004_47180 = state_44956__$1;
(statearr_45004_47180[(2)] = null);

(statearr_45004_47180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (6))){
var inst_44886 = (state_44956[(13)]);
var inst_44895 = f.call(null,inst_44886);
var inst_44896 = cljs.core.seq.call(null,inst_44895);
var inst_44897 = inst_44896;
var inst_44898 = null;
var inst_44899 = (0);
var inst_44900 = (0);
var state_44956__$1 = (function (){var statearr_45007 = state_44956;
(statearr_45007[(8)] = inst_44897);

(statearr_45007[(9)] = inst_44898);

(statearr_45007[(11)] = inst_44899);

(statearr_45007[(12)] = inst_44900);

return statearr_45007;
})();
var statearr_45011_47184 = state_44956__$1;
(statearr_45011_47184[(2)] = null);

(statearr_45011_47184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (17))){
var inst_44918 = (state_44956[(7)]);
var inst_44923 = cljs.core.chunk_first.call(null,inst_44918);
var inst_44924 = cljs.core.chunk_rest.call(null,inst_44918);
var inst_44925 = cljs.core.count.call(null,inst_44923);
var inst_44897 = inst_44924;
var inst_44898 = inst_44923;
var inst_44899 = inst_44925;
var inst_44900 = (0);
var state_44956__$1 = (function (){var statearr_45013 = state_44956;
(statearr_45013[(8)] = inst_44897);

(statearr_45013[(9)] = inst_44898);

(statearr_45013[(11)] = inst_44899);

(statearr_45013[(12)] = inst_44900);

return statearr_45013;
})();
var statearr_45015_47185 = state_44956__$1;
(statearr_45015_47185[(2)] = null);

(statearr_45015_47185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (3))){
var inst_44953 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44956__$1,inst_44953);
} else {
if((state_val_44957 === (12))){
var inst_44941 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_45018_47187 = state_44956__$1;
(statearr_45018_47187[(2)] = inst_44941);

(statearr_45018_47187[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (2))){
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44956__$1,(4),in$);
} else {
if((state_val_44957 === (23))){
var inst_44949 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_45022_47189 = state_44956__$1;
(statearr_45022_47189[(2)] = inst_44949);

(statearr_45022_47189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (19))){
var inst_44936 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_45029_47190 = state_44956__$1;
(statearr_45029_47190[(2)] = inst_44936);

(statearr_45029_47190[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (11))){
var inst_44897 = (state_44956[(8)]);
var inst_44918 = (state_44956[(7)]);
var inst_44918__$1 = cljs.core.seq.call(null,inst_44897);
var state_44956__$1 = (function (){var statearr_45034 = state_44956;
(statearr_45034[(7)] = inst_44918__$1);

return statearr_45034;
})();
if(inst_44918__$1){
var statearr_45036_47191 = state_44956__$1;
(statearr_45036_47191[(1)] = (14));

} else {
var statearr_45037_47192 = state_44956__$1;
(statearr_45037_47192[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (9))){
var inst_44943 = (state_44956[(2)]);
var inst_44944 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_44956__$1 = (function (){var statearr_45038 = state_44956;
(statearr_45038[(15)] = inst_44943);

return statearr_45038;
})();
if(cljs.core.truth_(inst_44944)){
var statearr_45039_47196 = state_44956__$1;
(statearr_45039_47196[(1)] = (21));

} else {
var statearr_45040_47197 = state_44956__$1;
(statearr_45040_47197[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (5))){
var inst_44889 = cljs.core.async.close_BANG_.call(null,out);
var state_44956__$1 = state_44956;
var statearr_45041_47198 = state_44956__$1;
(statearr_45041_47198[(2)] = inst_44889);

(statearr_45041_47198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (14))){
var inst_44918 = (state_44956[(7)]);
var inst_44920 = cljs.core.chunked_seq_QMARK_.call(null,inst_44918);
var state_44956__$1 = state_44956;
if(inst_44920){
var statearr_45042_47199 = state_44956__$1;
(statearr_45042_47199[(1)] = (17));

} else {
var statearr_45043_47200 = state_44956__$1;
(statearr_45043_47200[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (16))){
var inst_44939 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_45045_47202 = state_44956__$1;
(statearr_45045_47202[(2)] = inst_44939);

(statearr_45045_47202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44957 === (10))){
var inst_44898 = (state_44956[(9)]);
var inst_44900 = (state_44956[(12)]);
var inst_44910 = cljs.core._nth(inst_44898,inst_44900);
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44956__$1,(13),out,inst_44910);
} else {
if((state_val_44957 === (18))){
var inst_44918 = (state_44956[(7)]);
var inst_44928 = cljs.core.first.call(null,inst_44918);
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_44956__$1,(20),out,inst_44928);
} else {
if((state_val_44957 === (8))){
var inst_44899 = (state_44956[(11)]);
var inst_44900 = (state_44956[(12)]);
var inst_44903 = (inst_44900 < inst_44899);
var inst_44904 = inst_44903;
var state_44956__$1 = state_44956;
if(cljs.core.truth_(inst_44904)){
var statearr_45060_47216 = state_44956__$1;
(statearr_45060_47216[(1)] = (10));

} else {
var statearr_45061_47221 = state_44956__$1;
(statearr_45061_47221[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____0 = (function (){
var statearr_45064 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45064[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__);

(statearr_45064[(1)] = (1));

return statearr_45064;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____1 = (function (state_44956){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_44956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e45067){var ex__41878__auto__ = e45067;
var statearr_45068_47234 = state_44956;
(statearr_45068_47234[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_44956[(4)]))){
var statearr_45071_47239 = state_44956;
(statearr_45071_47239[(1)] = cljs.core.first.call(null,(state_44956[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47249 = state_44956;
state_44956 = G__47249;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__ = function(state_44956){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____1.call(this,state_44956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41875__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_45073 = f__42105__auto__();
(statearr_45073[(6)] = c__42104__auto__);

return statearr_45073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));

return c__42104__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45081 = arguments.length;
switch (G__45081) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45090 = arguments.length;
switch (G__45090) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45106 = arguments.length;
switch (G__45106) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47303 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_45141){
var state_val_45142 = (state_45141[(1)]);
if((state_val_45142 === (7))){
var inst_45136 = (state_45141[(2)]);
var state_45141__$1 = state_45141;
var statearr_45145_47307 = state_45141__$1;
(statearr_45145_47307[(2)] = inst_45136);

(statearr_45145_47307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (1))){
var inst_45118 = null;
var state_45141__$1 = (function (){var statearr_45147 = state_45141;
(statearr_45147[(7)] = inst_45118);

return statearr_45147;
})();
var statearr_45150_47308 = state_45141__$1;
(statearr_45150_47308[(2)] = null);

(statearr_45150_47308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (4))){
var inst_45121 = (state_45141[(8)]);
var inst_45121__$1 = (state_45141[(2)]);
var inst_45122 = (inst_45121__$1 == null);
var inst_45123 = cljs.core.not(inst_45122);
var state_45141__$1 = (function (){var statearr_45151 = state_45141;
(statearr_45151[(8)] = inst_45121__$1);

return statearr_45151;
})();
if(inst_45123){
var statearr_45156_47309 = state_45141__$1;
(statearr_45156_47309[(1)] = (5));

} else {
var statearr_45160_47310 = state_45141__$1;
(statearr_45160_47310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (6))){
var state_45141__$1 = state_45141;
var statearr_45161_47311 = state_45141__$1;
(statearr_45161_47311[(2)] = null);

(statearr_45161_47311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (3))){
var inst_45138 = (state_45141[(2)]);
var inst_45139 = cljs.core.async.close_BANG_.call(null,out);
var state_45141__$1 = (function (){var statearr_45165 = state_45141;
(statearr_45165[(9)] = inst_45138);

return statearr_45165;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45141__$1,inst_45139);
} else {
if((state_val_45142 === (2))){
var state_45141__$1 = state_45141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45141__$1,(4),ch);
} else {
if((state_val_45142 === (11))){
var inst_45121 = (state_45141[(8)]);
var inst_45130 = (state_45141[(2)]);
var inst_45118 = inst_45121;
var state_45141__$1 = (function (){var statearr_45169 = state_45141;
(statearr_45169[(7)] = inst_45118);

(statearr_45169[(10)] = inst_45130);

return statearr_45169;
})();
var statearr_45170_47324 = state_45141__$1;
(statearr_45170_47324[(2)] = null);

(statearr_45170_47324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (9))){
var inst_45121 = (state_45141[(8)]);
var state_45141__$1 = state_45141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45141__$1,(11),out,inst_45121);
} else {
if((state_val_45142 === (5))){
var inst_45118 = (state_45141[(7)]);
var inst_45121 = (state_45141[(8)]);
var inst_45125 = cljs.core._EQ_.call(null,inst_45121,inst_45118);
var state_45141__$1 = state_45141;
if(inst_45125){
var statearr_45172_47330 = state_45141__$1;
(statearr_45172_47330[(1)] = (8));

} else {
var statearr_45173_47331 = state_45141__$1;
(statearr_45173_47331[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (10))){
var inst_45133 = (state_45141[(2)]);
var state_45141__$1 = state_45141;
var statearr_45176_47332 = state_45141__$1;
(statearr_45176_47332[(2)] = inst_45133);

(statearr_45176_47332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45142 === (8))){
var inst_45118 = (state_45141[(7)]);
var tmp45171 = inst_45118;
var inst_45118__$1 = tmp45171;
var state_45141__$1 = (function (){var statearr_45181 = state_45141;
(statearr_45181[(7)] = inst_45118__$1);

return statearr_45181;
})();
var statearr_45182_47334 = state_45141__$1;
(statearr_45182_47334[(2)] = null);

(statearr_45182_47334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_45187 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45187[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_45187[(1)] = (1));

return statearr_45187;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_45141){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_45141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e45188){var ex__41878__auto__ = e45188;
var statearr_45189_47335 = state_45141;
(statearr_45189_47335[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_45141[(4)]))){
var statearr_45192_47337 = state_45141;
(statearr_45192_47337[(1)] = cljs.core.first.call(null,(state_45141[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47338 = state_45141;
state_45141 = G__47338;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_45141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_45141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_45196 = f__42105__auto__();
(statearr_45196[(6)] = c__42104__auto___47303);

return statearr_45196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45216 = arguments.length;
switch (G__45216) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47343 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_45267){
var state_val_45268 = (state_45267[(1)]);
if((state_val_45268 === (7))){
var inst_45263 = (state_45267[(2)]);
var state_45267__$1 = state_45267;
var statearr_45270_47347 = state_45267__$1;
(statearr_45270_47347[(2)] = inst_45263);

(statearr_45270_47347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (1))){
var inst_45229 = (new Array(n));
var inst_45230 = inst_45229;
var inst_45231 = (0);
var state_45267__$1 = (function (){var statearr_45271 = state_45267;
(statearr_45271[(7)] = inst_45230);

(statearr_45271[(8)] = inst_45231);

return statearr_45271;
})();
var statearr_45272_47352 = state_45267__$1;
(statearr_45272_47352[(2)] = null);

(statearr_45272_47352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (4))){
var inst_45235 = (state_45267[(9)]);
var inst_45235__$1 = (state_45267[(2)]);
var inst_45236 = (inst_45235__$1 == null);
var inst_45237 = cljs.core.not(inst_45236);
var state_45267__$1 = (function (){var statearr_45273 = state_45267;
(statearr_45273[(9)] = inst_45235__$1);

return statearr_45273;
})();
if(inst_45237){
var statearr_45274_47359 = state_45267__$1;
(statearr_45274_47359[(1)] = (5));

} else {
var statearr_45275_47361 = state_45267__$1;
(statearr_45275_47361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (15))){
var inst_45257 = (state_45267[(2)]);
var state_45267__$1 = state_45267;
var statearr_45282_47368 = state_45267__$1;
(statearr_45282_47368[(2)] = inst_45257);

(statearr_45282_47368[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (13))){
var state_45267__$1 = state_45267;
var statearr_45283_47375 = state_45267__$1;
(statearr_45283_47375[(2)] = null);

(statearr_45283_47375[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (6))){
var inst_45231 = (state_45267[(8)]);
var inst_45253 = (inst_45231 > (0));
var state_45267__$1 = state_45267;
if(cljs.core.truth_(inst_45253)){
var statearr_45284_47376 = state_45267__$1;
(statearr_45284_47376[(1)] = (12));

} else {
var statearr_45285_47377 = state_45267__$1;
(statearr_45285_47377[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (3))){
var inst_45265 = (state_45267[(2)]);
var state_45267__$1 = state_45267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45267__$1,inst_45265);
} else {
if((state_val_45268 === (12))){
var inst_45230 = (state_45267[(7)]);
var inst_45255 = cljs.core.vec.call(null,inst_45230);
var state_45267__$1 = state_45267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45267__$1,(15),out,inst_45255);
} else {
if((state_val_45268 === (2))){
var state_45267__$1 = state_45267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45267__$1,(4),ch);
} else {
if((state_val_45268 === (11))){
var inst_45247 = (state_45267[(2)]);
var inst_45248 = (new Array(n));
var inst_45230 = inst_45248;
var inst_45231 = (0);
var state_45267__$1 = (function (){var statearr_45288 = state_45267;
(statearr_45288[(7)] = inst_45230);

(statearr_45288[(10)] = inst_45247);

(statearr_45288[(8)] = inst_45231);

return statearr_45288;
})();
var statearr_45289_47399 = state_45267__$1;
(statearr_45289_47399[(2)] = null);

(statearr_45289_47399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (9))){
var inst_45230 = (state_45267[(7)]);
var inst_45245 = cljs.core.vec.call(null,inst_45230);
var state_45267__$1 = state_45267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45267__$1,(11),out,inst_45245);
} else {
if((state_val_45268 === (5))){
var inst_45230 = (state_45267[(7)]);
var inst_45240 = (state_45267[(11)]);
var inst_45231 = (state_45267[(8)]);
var inst_45235 = (state_45267[(9)]);
var inst_45239 = (inst_45230[inst_45231] = inst_45235);
var inst_45240__$1 = (inst_45231 + (1));
var inst_45241 = (inst_45240__$1 < n);
var state_45267__$1 = (function (){var statearr_45291 = state_45267;
(statearr_45291[(12)] = inst_45239);

(statearr_45291[(11)] = inst_45240__$1);

return statearr_45291;
})();
if(cljs.core.truth_(inst_45241)){
var statearr_45292_47412 = state_45267__$1;
(statearr_45292_47412[(1)] = (8));

} else {
var statearr_45293_47413 = state_45267__$1;
(statearr_45293_47413[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (14))){
var inst_45260 = (state_45267[(2)]);
var inst_45261 = cljs.core.async.close_BANG_.call(null,out);
var state_45267__$1 = (function (){var statearr_45299 = state_45267;
(statearr_45299[(13)] = inst_45260);

return statearr_45299;
})();
var statearr_45300_47420 = state_45267__$1;
(statearr_45300_47420[(2)] = inst_45261);

(statearr_45300_47420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (10))){
var inst_45251 = (state_45267[(2)]);
var state_45267__$1 = state_45267;
var statearr_45301_47422 = state_45267__$1;
(statearr_45301_47422[(2)] = inst_45251);

(statearr_45301_47422[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45268 === (8))){
var inst_45230 = (state_45267[(7)]);
var inst_45240 = (state_45267[(11)]);
var tmp45296 = inst_45230;
var inst_45230__$1 = tmp45296;
var inst_45231 = inst_45240;
var state_45267__$1 = (function (){var statearr_45302 = state_45267;
(statearr_45302[(7)] = inst_45230__$1);

(statearr_45302[(8)] = inst_45231);

return statearr_45302;
})();
var statearr_45303_47429 = state_45267__$1;
(statearr_45303_47429[(2)] = null);

(statearr_45303_47429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_45304 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45304[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_45304[(1)] = (1));

return statearr_45304;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_45267){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_45267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e45306){var ex__41878__auto__ = e45306;
var statearr_45307_47434 = state_45267;
(statearr_45307_47434[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_45267[(4)]))){
var statearr_45308_47435 = state_45267;
(statearr_45308_47435[(1)] = cljs.core.first.call(null,(state_45267[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47448 = state_45267;
state_45267 = G__47448;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_45267){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_45267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_45309 = f__42105__auto__();
(statearr_45309[(6)] = c__42104__auto___47343);

return statearr_45309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__45312 = arguments.length;
switch (G__45312) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__42104__auto___47468 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42105__auto__ = (function (){var switch__41874__auto__ = (function (state_45372){
var state_val_45373 = (state_45372[(1)]);
if((state_val_45373 === (7))){
var inst_45363 = (state_45372[(2)]);
var state_45372__$1 = state_45372;
var statearr_45388_47470 = state_45372__$1;
(statearr_45388_47470[(2)] = inst_45363);

(statearr_45388_47470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (1))){
var inst_45317 = [];
var inst_45318 = inst_45317;
var inst_45319 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_45372__$1 = (function (){var statearr_45389 = state_45372;
(statearr_45389[(7)] = inst_45318);

(statearr_45389[(8)] = inst_45319);

return statearr_45389;
})();
var statearr_45391_47474 = state_45372__$1;
(statearr_45391_47474[(2)] = null);

(statearr_45391_47474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (4))){
var inst_45323 = (state_45372[(9)]);
var inst_45323__$1 = (state_45372[(2)]);
var inst_45324 = (inst_45323__$1 == null);
var inst_45325 = cljs.core.not(inst_45324);
var state_45372__$1 = (function (){var statearr_45395 = state_45372;
(statearr_45395[(9)] = inst_45323__$1);

return statearr_45395;
})();
if(inst_45325){
var statearr_45396_47479 = state_45372__$1;
(statearr_45396_47479[(1)] = (5));

} else {
var statearr_45397_47480 = state_45372__$1;
(statearr_45397_47480[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (15))){
var inst_45357 = (state_45372[(2)]);
var state_45372__$1 = state_45372;
var statearr_45400_47483 = state_45372__$1;
(statearr_45400_47483[(2)] = inst_45357);

(statearr_45400_47483[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (13))){
var state_45372__$1 = state_45372;
var statearr_45404_47488 = state_45372__$1;
(statearr_45404_47488[(2)] = null);

(statearr_45404_47488[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (6))){
var inst_45318 = (state_45372[(7)]);
var inst_45352 = inst_45318.length;
var inst_45353 = (inst_45352 > (0));
var state_45372__$1 = state_45372;
if(cljs.core.truth_(inst_45353)){
var statearr_45406_47492 = state_45372__$1;
(statearr_45406_47492[(1)] = (12));

} else {
var statearr_45407_47495 = state_45372__$1;
(statearr_45407_47495[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (3))){
var inst_45365 = (state_45372[(2)]);
var state_45372__$1 = state_45372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45372__$1,inst_45365);
} else {
if((state_val_45373 === (12))){
var inst_45318 = (state_45372[(7)]);
var inst_45355 = cljs.core.vec.call(null,inst_45318);
var state_45372__$1 = state_45372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45372__$1,(15),out,inst_45355);
} else {
if((state_val_45373 === (2))){
var state_45372__$1 = state_45372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45372__$1,(4),ch);
} else {
if((state_val_45373 === (11))){
var inst_45323 = (state_45372[(9)]);
var inst_45327 = (state_45372[(10)]);
var inst_45341 = (state_45372[(2)]);
var inst_45342 = [];
var inst_45347 = inst_45342.push(inst_45323);
var inst_45318 = inst_45342;
var inst_45319 = inst_45327;
var state_45372__$1 = (function (){var statearr_45415 = state_45372;
(statearr_45415[(11)] = inst_45347);

(statearr_45415[(12)] = inst_45341);

(statearr_45415[(7)] = inst_45318);

(statearr_45415[(8)] = inst_45319);

return statearr_45415;
})();
var statearr_45416_47502 = state_45372__$1;
(statearr_45416_47502[(2)] = null);

(statearr_45416_47502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (9))){
var inst_45318 = (state_45372[(7)]);
var inst_45339 = cljs.core.vec.call(null,inst_45318);
var state_45372__$1 = state_45372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45372__$1,(11),out,inst_45339);
} else {
if((state_val_45373 === (5))){
var inst_45323 = (state_45372[(9)]);
var inst_45327 = (state_45372[(10)]);
var inst_45319 = (state_45372[(8)]);
var inst_45327__$1 = f.call(null,inst_45323);
var inst_45328 = cljs.core._EQ_.call(null,inst_45327__$1,inst_45319);
var inst_45329 = cljs.core.keyword_identical_QMARK_.call(null,inst_45319,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_45330 = ((inst_45328) || (inst_45329));
var state_45372__$1 = (function (){var statearr_45430 = state_45372;
(statearr_45430[(10)] = inst_45327__$1);

return statearr_45430;
})();
if(cljs.core.truth_(inst_45330)){
var statearr_45431_47510 = state_45372__$1;
(statearr_45431_47510[(1)] = (8));

} else {
var statearr_45432_47511 = state_45372__$1;
(statearr_45432_47511[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (14))){
var inst_45360 = (state_45372[(2)]);
var inst_45361 = cljs.core.async.close_BANG_.call(null,out);
var state_45372__$1 = (function (){var statearr_45437 = state_45372;
(statearr_45437[(13)] = inst_45360);

return statearr_45437;
})();
var statearr_45440_47514 = state_45372__$1;
(statearr_45440_47514[(2)] = inst_45361);

(statearr_45440_47514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (10))){
var inst_45350 = (state_45372[(2)]);
var state_45372__$1 = state_45372;
var statearr_45442_47519 = state_45372__$1;
(statearr_45442_47519[(2)] = inst_45350);

(statearr_45442_47519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45373 === (8))){
var inst_45323 = (state_45372[(9)]);
var inst_45327 = (state_45372[(10)]);
var inst_45318 = (state_45372[(7)]);
var inst_45332 = inst_45318.push(inst_45323);
var tmp45435 = inst_45318;
var inst_45318__$1 = tmp45435;
var inst_45319 = inst_45327;
var state_45372__$1 = (function (){var statearr_45446 = state_45372;
(statearr_45446[(14)] = inst_45332);

(statearr_45446[(7)] = inst_45318__$1);

(statearr_45446[(8)] = inst_45319);

return statearr_45446;
})();
var statearr_45447_47529 = state_45372__$1;
(statearr_45447_47529[(2)] = null);

(statearr_45447_47529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41875__auto__ = null;
var cljs$core$async$state_machine__41875__auto____0 = (function (){
var statearr_45449 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45449[(0)] = cljs$core$async$state_machine__41875__auto__);

(statearr_45449[(1)] = (1));

return statearr_45449;
});
var cljs$core$async$state_machine__41875__auto____1 = (function (state_45372){
while(true){
var ret_value__41876__auto__ = (function (){try{while(true){
var result__41877__auto__ = switch__41874__auto__(state_45372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41877__auto__;
}
break;
}
}catch (e45451){var ex__41878__auto__ = e45451;
var statearr_45452_47530 = state_45372;
(statearr_45452_47530[(2)] = ex__41878__auto__);


if(cljs.core.seq.call(null,(state_45372[(4)]))){
var statearr_45455_47531 = state_45372;
(statearr_45455_47531[(1)] = cljs.core.first.call(null,(state_45372[(4)])));

} else {
throw ex__41878__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41876__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47534 = state_45372;
state_45372 = G__47534;
continue;
} else {
return ret_value__41876__auto__;
}
break;
}
});
cljs$core$async$state_machine__41875__auto__ = function(state_45372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41875__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41875__auto____1.call(this,state_45372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41875__auto____0;
cljs$core$async$state_machine__41875__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41875__auto____1;
return cljs$core$async$state_machine__41875__auto__;
})()
})();
var state__42106__auto__ = (function (){var statearr_45456 = f__42105__auto__();
(statearr_45456[(6)] = c__42104__auto___47468);

return statearr_45456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42106__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
