goog.provide('cljs.core.async.impl.channels');
cljs.core.async.impl.channels.box = (function cljs$core$async$impl$channels$box(val){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.impl !== 'undefined') && (typeof cljs.core.async.impl.channels !== 'undefined') && (typeof cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979 = (function (val,meta39980){
this.val = val;
this.meta39980 = meta39980;
this.cljs$lang$protocol_mask$partition0$ = 425984;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39981,meta39980__$1){
var self__ = this;
var _39981__$1 = this;
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979(self__.val,meta39980__$1));
}));

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39981){
var self__ = this;
var _39981__$1 = this;
return self__.meta39980;
}));

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.val;
}));

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta39980","meta39980",1340690812,null)], null);
}));

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.cljs$lang$type = true);

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.cljs$lang$ctorStr = "cljs.core.async.impl.channels/t_cljs$core$async$impl$channels39979");

(cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async.impl.channels/t_cljs$core$async$impl$channels39979");
}));

/**
 * Positional factory function for cljs.core.async.impl.channels/t_cljs$core$async$impl$channels39979.
 */
cljs.core.async.impl.channels.__GT_t_cljs$core$async$impl$channels39979 = (function cljs$core$async$impl$channels$box_$___GT_t_cljs$core$async$impl$channels39979(val__$1,meta39980){
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979(val__$1,meta39980));
});

}

return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels39979(val,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.async.impl.channels.PutBox = (function (handler,val){
this.handler = handler;
this.val = val;
});

(cljs.core.async.impl.channels.PutBox.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.async.impl.channels.PutBox.cljs$lang$type = true);

(cljs.core.async.impl.channels.PutBox.cljs$lang$ctorStr = "cljs.core.async.impl.channels/PutBox");

(cljs.core.async.impl.channels.PutBox.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async.impl.channels/PutBox");
}));

/**
 * Positional factory function for cljs.core.async.impl.channels/PutBox.
 */
cljs.core.async.impl.channels.__GT_PutBox = (function cljs$core$async$impl$channels$__GT_PutBox(handler,val){
return (new cljs.core.async.impl.channels.PutBox(handler,val));
});

cljs.core.async.impl.channels.put_active_QMARK_ = (function cljs$core$async$impl$channels$put_active_QMARK_(box){
return cljs.core.async.impl.protocols.active_QMARK_(box.handler);
});
cljs.core.async.impl.channels.MAX_DIRTY = (64);

/**
 * @interface
 */
cljs.core.async.impl.channels.MMC = function(){};

var cljs$core$async$impl$channels$MMC$abort$dyn_40268 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (cljs.core.async.impl.channels.abort[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (cljs.core.async.impl.channels.abort["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"MMC.abort",this$);
}
}
});
cljs.core.async.impl.channels.abort = (function cljs$core$async$impl$channels$abort(this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$async$impl$channels$MMC$abort$arity$1 == null)))))){
return this$.cljs$core$async$impl$channels$MMC$abort$arity$1(this$);
} else {
return cljs$core$async$impl$channels$MMC$abort$dyn_40268(this$);
}
});


/**
* @constructor
 * @implements {cljs.core.async.impl.channels.MMC}
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
*/
cljs.core.async.impl.channels.ManyToManyChannel = (function (takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
this.takes = takes;
this.dirty_takes = dirty_takes;
this.puts = puts;
this.dirty_puts = dirty_puts;
this.buf = buf;
this.closed = closed;
this.add_BANG_ = add_BANG_;
});
(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
while(true){
var putter_40285 = self__.puts.pop();
if((putter_40285 == null)){
} else {
var put_handler_40289 = putter_40285.handler;
var val_40290 = putter_40285.val;
if(cljs.core.async.impl.protocols.active_QMARK_(put_handler_40289)){
var put_cb_40291 = cljs.core.async.impl.protocols.commit(put_handler_40289);
cljs.core.async.impl.dispatch.run.call(null,((function (put_cb_40291,put_handler_40289,val_40290,putter_40285,this$__$1){
return (function (){
return put_cb_40291.call(null,true);
});})(put_cb_40291,put_handler_40289,val_40290,putter_40285,this$__$1))
);
} else {
continue;
}
}
break;
}

self__.puts.cleanup(cljs.core.constantly.call(null,false));

return cljs.core.async.impl.protocols.close_BANG_(this$__$1);
}));

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (this$,val,handler){
var self__ = this;
var this$__$1 = this;
if((!((val == null)))){
} else {
throw (new Error(["Assert failed: ","Can't put nil on a channel","\n","(not (nil? val))"].join('')));
}

var closed__$1 = self__.closed;
if(((closed__$1) || ((!(cljs.core.async.impl.protocols.active_QMARK_(handler)))))){
return cljs.core.async.impl.channels.box.call(null,(!(closed__$1)));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = self__.buf;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(cljs.core.async.impl.protocols.full_QMARK_(self__.buf));
} else {
return and__4115__auto__;
}
})())){
cljs.core.async.impl.protocols.commit(handler);

var done_QMARK_ = cljs.core.reduced_QMARK_.call(null,self__.add_BANG_.call(null,self__.buf,val));
var take_cbs = (function (){var takers = cljs.core.PersistentVector.EMPTY;
while(true){
if((((self__.takes.length > (0))) && ((cljs.core.count.call(null,self__.buf) > (0))))){
var taker = self__.takes.pop();
if(cljs.core.async.impl.protocols.active_QMARK_(taker)){
var ret = cljs.core.async.impl.protocols.commit(taker);
var val__$1 = cljs.core.async.impl.protocols.remove_BANG_(self__.buf);
var G__40300 = cljs.core.conj.call(null,takers,((function (takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1){
return (function (){
return ret.call(null,val__$1);
});})(takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1))
);
takers = G__40300;
continue;
} else {
var G__40301 = takers;
takers = G__40301;
continue;
}
} else {
return takers;
}
break;
}
})();
if(done_QMARK_){
cljs.core.async.impl.channels.abort(this$__$1);
} else {
}

if(cljs.core.seq.call(null,take_cbs)){
var seq__40053_40304 = cljs.core.seq.call(null,take_cbs);
var chunk__40054_40305 = null;
var count__40055_40306 = (0);
var i__40056_40307 = (0);
while(true){
if((i__40056_40307 < count__40055_40306)){
var f_40308 = cljs.core._nth(chunk__40054_40305,i__40056_40307);
cljs.core.async.impl.dispatch.run.call(null,f_40308);


var G__40311 = seq__40053_40304;
var G__40312 = chunk__40054_40305;
var G__40313 = count__40055_40306;
var G__40314 = (i__40056_40307 + (1));
seq__40053_40304 = G__40311;
chunk__40054_40305 = G__40312;
count__40055_40306 = G__40313;
i__40056_40307 = G__40314;
continue;
} else {
var temp__5720__auto___40315 = cljs.core.seq.call(null,seq__40053_40304);
if(temp__5720__auto___40315){
var seq__40053_40319__$1 = temp__5720__auto___40315;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40053_40319__$1)){
var c__4556__auto___40322 = cljs.core.chunk_first.call(null,seq__40053_40319__$1);
var G__40323 = cljs.core.chunk_rest.call(null,seq__40053_40319__$1);
var G__40324 = c__4556__auto___40322;
var G__40325 = cljs.core.count.call(null,c__4556__auto___40322);
var G__40326 = (0);
seq__40053_40304 = G__40323;
chunk__40054_40305 = G__40324;
count__40055_40306 = G__40325;
i__40056_40307 = G__40326;
continue;
} else {
var f_40327 = cljs.core.first.call(null,seq__40053_40319__$1);
cljs.core.async.impl.dispatch.run.call(null,f_40327);


var G__40328 = cljs.core.next.call(null,seq__40053_40319__$1);
var G__40329 = null;
var G__40330 = (0);
var G__40331 = (0);
seq__40053_40304 = G__40328;
chunk__40054_40305 = G__40329;
count__40055_40306 = G__40330;
i__40056_40307 = G__40331;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.core.async.impl.channels.box.call(null,true);
} else {
var taker = (function (){while(true){
var taker = self__.takes.pop();
if(cljs.core.truth_(taker)){
if(cljs.core.truth_(cljs.core.async.impl.protocols.active_QMARK_(taker))){
return taker;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(taker)){
var take_cb = cljs.core.async.impl.protocols.commit(taker);
cljs.core.async.impl.protocols.commit(handler);

cljs.core.async.impl.dispatch.run.call(null,(function (){
return take_cb.call(null,val);
}));

return cljs.core.async.impl.channels.box.call(null,true);
} else {
if((self__.dirty_puts > (64))){
(self__.dirty_puts = (0));

self__.puts.cleanup(cljs.core.async.impl.channels.put_active_QMARK_);
} else {
(self__.dirty_puts = (self__.dirty_puts + (1)));
}

if(cljs.core.truth_(cljs.core.async.impl.protocols.blockable_QMARK_(handler))){
if((self__.puts.length < (1024))){
} else {
throw (new Error(["Assert failed: ",["No more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((1024))," pending puts are allowed on a single channel."," Consider using a windowed buffer."].join(''),"\n","(< (.-length puts) impl/MAX-QUEUE-SIZE)"].join('')));
}

self__.puts.unbounded_unshift((new cljs.core.async.impl.channels.PutBox(handler,val)));
} else {
}

return null;
}
}
}
}));

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
if((!(cljs.core.async.impl.protocols.active_QMARK_(handler)))){
return null;
} else {
if((((!((self__.buf == null)))) && ((cljs.core.count.call(null,self__.buf) > (0))))){
var temp__5718__auto__ = cljs.core.async.impl.protocols.commit(handler);
if(cljs.core.truth_(temp__5718__auto__)){
var take_cb = temp__5718__auto__;
var val = cljs.core.async.impl.protocols.remove_BANG_(self__.buf);
var vec__40074 = ((((cljs.core.not(cljs.core.async.impl.protocols.full_QMARK_(self__.buf))) && ((self__.puts.length > (0)))))?(function (){var cbs = cljs.core.PersistentVector.EMPTY;
while(true){
var putter = self__.puts.pop();
var put_handler = putter.handler;
var val__$1 = putter.val;
var cb = ((cljs.core.async.impl.protocols.active_QMARK_(put_handler))?cljs.core.async.impl.protocols.commit(put_handler):false);
var cbs__$1 = (cljs.core.truth_(cb)?cljs.core.conj.call(null,cbs,cb):cbs);
var done_QMARK_ = (cljs.core.truth_(cb)?cljs.core.reduced_QMARK_.call(null,self__.add_BANG_.call(null,self__.buf,val__$1)):null);
if(((cljs.core.not(done_QMARK_)) && (cljs.core.not(cljs.core.async.impl.protocols.full_QMARK_(self__.buf))) && ((self__.puts.length > (0))))){
var G__40369 = cbs__$1;
cbs = G__40369;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [done_QMARK_,cbs__$1], null);
}
break;
}
})():null);
var done_QMARK_ = cljs.core.nth.call(null,vec__40074,(0),null);
var cbs = cljs.core.nth.call(null,vec__40074,(1),null);
if(cljs.core.truth_(done_QMARK_)){
cljs.core.async.impl.channels.abort(this$__$1);
} else {
}

var seq__40103_40371 = cljs.core.seq.call(null,cbs);
var chunk__40104_40372 = null;
var count__40105_40373 = (0);
var i__40106_40374 = (0);
while(true){
if((i__40106_40374 < count__40105_40373)){
var cb_40377 = cljs.core._nth(chunk__40104_40372,i__40106_40374);
cljs.core.async.impl.dispatch.run.call(null,((function (seq__40103_40371,chunk__40104_40372,count__40105_40373,i__40106_40374,cb_40377,val,vec__40074,done_QMARK_,cbs,take_cb,temp__5718__auto__,this$__$1){
return (function (){
return cb_40377.call(null,true);
});})(seq__40103_40371,chunk__40104_40372,count__40105_40373,i__40106_40374,cb_40377,val,vec__40074,done_QMARK_,cbs,take_cb,temp__5718__auto__,this$__$1))
);


var G__40382 = seq__40103_40371;
var G__40383 = chunk__40104_40372;
var G__40384 = count__40105_40373;
var G__40385 = (i__40106_40374 + (1));
seq__40103_40371 = G__40382;
chunk__40104_40372 = G__40383;
count__40105_40373 = G__40384;
i__40106_40374 = G__40385;
continue;
} else {
var temp__5720__auto___40391 = cljs.core.seq.call(null,seq__40103_40371);
if(temp__5720__auto___40391){
var seq__40103_40396__$1 = temp__5720__auto___40391;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40103_40396__$1)){
var c__4556__auto___40398 = cljs.core.chunk_first.call(null,seq__40103_40396__$1);
var G__40400 = cljs.core.chunk_rest.call(null,seq__40103_40396__$1);
var G__40401 = c__4556__auto___40398;
var G__40402 = cljs.core.count.call(null,c__4556__auto___40398);
var G__40403 = (0);
seq__40103_40371 = G__40400;
chunk__40104_40372 = G__40401;
count__40105_40373 = G__40402;
i__40106_40374 = G__40403;
continue;
} else {
var cb_40411 = cljs.core.first.call(null,seq__40103_40396__$1);
cljs.core.async.impl.dispatch.run.call(null,((function (seq__40103_40371,chunk__40104_40372,count__40105_40373,i__40106_40374,cb_40411,seq__40103_40396__$1,temp__5720__auto___40391,val,vec__40074,done_QMARK_,cbs,take_cb,temp__5718__auto__,this$__$1){
return (function (){
return cb_40411.call(null,true);
});})(seq__40103_40371,chunk__40104_40372,count__40105_40373,i__40106_40374,cb_40411,seq__40103_40396__$1,temp__5720__auto___40391,val,vec__40074,done_QMARK_,cbs,take_cb,temp__5718__auto__,this$__$1))
);


var G__40420 = cljs.core.next.call(null,seq__40103_40396__$1);
var G__40421 = null;
var G__40422 = (0);
var G__40423 = (0);
seq__40103_40371 = G__40420;
chunk__40104_40372 = G__40421;
count__40105_40373 = G__40422;
i__40106_40374 = G__40423;
continue;
}
} else {
}
}
break;
}

return cljs.core.async.impl.channels.box.call(null,val);
} else {
return null;
}
} else {
var putter = (function (){while(true){
var putter = self__.puts.pop();
if(cljs.core.truth_(putter)){
if(cljs.core.async.impl.protocols.active_QMARK_(putter.handler)){
return putter;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(putter)){
var put_cb = cljs.core.async.impl.protocols.commit(putter.handler);
cljs.core.async.impl.protocols.commit(handler);

cljs.core.async.impl.dispatch.run.call(null,(function (){
return put_cb.call(null,true);
}));

return cljs.core.async.impl.channels.box.call(null,putter.val);
} else {
if(cljs.core.truth_(self__.closed)){
if(cljs.core.truth_(self__.buf)){
self__.add_BANG_.call(null,self__.buf);
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_(handler);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit(handler);
} else {
return and__4115__auto__;
}
})())){
var has_val = (function (){var and__4115__auto__ = self__.buf;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.count.call(null,self__.buf) > (0));
} else {
return and__4115__auto__;
}
})();
var val = (cljs.core.truth_(has_val)?cljs.core.async.impl.protocols.remove_BANG_(self__.buf):null);
return cljs.core.async.impl.channels.box.call(null,val);
} else {
return null;
}
} else {
if((self__.dirty_takes > (64))){
(self__.dirty_takes = (0));

self__.takes.cleanup(cljs.core.async.impl.protocols.active_QMARK_);
} else {
(self__.dirty_takes = (self__.dirty_takes + (1)));
}

if(cljs.core.truth_(cljs.core.async.impl.protocols.blockable_QMARK_(handler))){
if((self__.takes.length < (1024))){
} else {
throw (new Error(["Assert failed: ",["No more than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((1024))," pending takes are allowed on a single channel."].join(''),"\n","(< (.-length takes) impl/MAX-QUEUE-SIZE)"].join('')));
}

self__.takes.unbounded_unshift(handler);
} else {
}

return null;
}
}
}
}
}));

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.closed;
}));

(cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(self__.closed){
return null;
} else {
(self__.closed = true);

if(cljs.core.truth_((function (){var and__4115__auto__ = self__.buf;
if(cljs.core.truth_(and__4115__auto__)){
return (self__.puts.length === (0));
} else {
return and__4115__auto__;
}
})())){
self__.add_BANG_.call(null,self__.buf);
} else {
}

while(true){
var taker_40443 = self__.takes.pop();
if((taker_40443 == null)){
} else {
if(cljs.core.async.impl.protocols.active_QMARK_(taker_40443)){
var take_cb_40444 = cljs.core.async.impl.protocols.commit(taker_40443);
var val_40445 = (cljs.core.truth_((function (){var and__4115__auto__ = self__.buf;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.count.call(null,self__.buf) > (0));
} else {
return and__4115__auto__;
}
})())?cljs.core.async.impl.protocols.remove_BANG_(self__.buf):null);
cljs.core.async.impl.dispatch.run.call(null,((function (take_cb_40444,val_40445,taker_40443,this$__$1){
return (function (){
return take_cb_40444.call(null,val_40445);
});})(take_cb_40444,val_40445,taker_40443,this$__$1))
);
} else {
}

continue;
}
break;
}

if(cljs.core.truth_(self__.buf)){
cljs.core.async.impl.protocols.close_buf_BANG_(self__.buf);
} else {
}

return null;
}
}));

(cljs.core.async.impl.channels.ManyToManyChannel.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"takes","takes",298247964,null),cljs.core.with_meta(new cljs.core.Symbol(null,"dirty-takes","dirty-takes",575642138,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"puts","puts",-1883877054,null),cljs.core.with_meta(new cljs.core.Symbol(null,"dirty-puts","dirty-puts",57041148,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"closed","closed",720856168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"add!","add!",2046056845,null)], null);
}));

(cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$type = true);

(cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorStr = "cljs.core.async.impl.channels/ManyToManyChannel");

(cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async.impl.channels/ManyToManyChannel");
}));

/**
 * Positional factory function for cljs.core.async.impl.channels/ManyToManyChannel.
 */
cljs.core.async.impl.channels.__GT_ManyToManyChannel = (function cljs$core$async$impl$channels$__GT_ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
return (new cljs.core.async.impl.channels.ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_));
});

cljs.core.async.impl.channels.ex_handler = (function cljs$core$async$impl$channels$ex_handler(ex){
console.log(ex);

return null;
});
cljs.core.async.impl.channels.handle = (function cljs$core$async$impl$channels$handle(buf,exh,t){
var else$ = (function (){var or__4126__auto__ = exh;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.impl.channels.ex_handler;
}
})().call(null,t);
if((else$ == null)){
return buf;
} else {
return cljs.core.async.impl.protocols.add_BANG_.call(null,buf,else$);
}
});
cljs.core.async.impl.channels.chan = (function cljs$core$async$impl$channels$chan(var_args){
var G__40203 = arguments.length;
switch (G__40203) {
case 1:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf){
return cljs.core.async.impl.channels.chan.call(null,buf,null);
}));

(cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf,xform){
return cljs.core.async.impl.channels.chan.call(null,buf,xform,null);
}));

(cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf,xform,exh){
return (new cljs.core.async.impl.channels.ManyToManyChannel(cljs.core.async.impl.buffers.ring_buffer.call(null,(32)),(0),cljs.core.async.impl.buffers.ring_buffer.call(null,(32)),(0),buf,false,(function (){var add_BANG_ = (cljs.core.truth_(xform)?xform.call(null,cljs.core.async.impl.protocols.add_BANG_):cljs.core.async.impl.protocols.add_BANG_);
return (function() {
var G__40459 = null;
var G__40459__1 = (function (buf__$1){
try{return add_BANG_.call(null,buf__$1);
}catch (e40229){var t = e40229;
return cljs.core.async.impl.channels.handle.call(null,buf__$1,exh,t);
}});
var G__40459__2 = (function (buf__$1,val){
try{return add_BANG_.call(null,buf__$1,val);
}catch (e40230){var t = e40230;
return cljs.core.async.impl.channels.handle.call(null,buf__$1,exh,t);
}});
G__40459 = function(buf__$1,val){
switch(arguments.length){
case 1:
return G__40459__1.call(this,buf__$1);
case 2:
return G__40459__2.call(this,buf__$1,val);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40459.cljs$core$IFn$_invoke$arity$1 = G__40459__1;
G__40459.cljs$core$IFn$_invoke$arity$2 = G__40459__2;
return G__40459;
})()
})()));
}));

(cljs.core.async.impl.channels.chan.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.impl.channels.js.map
