goog.provide('shadow.object');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.data');
goog.require('cljs.core.async.impl.protocols');
goog.require('shadow.util');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._id[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._id["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
}
});

shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._type[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._type["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
}
});

shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._data[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$);
} else {
var m__4485__auto__ = (shadow.object._data["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
}
});

/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._update[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$,update_fn);
} else {
var m__4485__auto__ = (shadow.object._update["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
}
});

shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return m__4488__auto__.call(null,this$,cause);
} else {
var m__4485__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__4485__auto__ == null)))){
return m__4485__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type.call(null,this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__47156 = arguments.length;
switch (G__47156) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
}));

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
}));

(shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3);

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__4185__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),shadow.object._id.call(null,obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),(function (){var temp__5735__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5735__auto__)){
var oid = temp__5735__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id.call(null,oref));
if(cljs.core.truth_(temp__5735__auto__)){
var parent_id = temp__5735__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type.call(null,parent),parent_type)){
return parent;
} else {
var G__47857 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__47857;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id.call(null,parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,(function (p1__47238_SHARP_){
return cljs.core.get.call(null,instances,p1__47238_SHARP_);
}),child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__47266 = arguments.length;
switch (G__47266) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
}));

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
}));

(shadow.object.tree_seq.cljs$lang$maxFixedArity = 2);

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__47287_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__47287_SHARP_));
}),shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__47311){
var map__47314 = p__47311;
var map__47314__$1 = (((((!((map__47314 == null))))?(((((map__47314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47314.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47314):map__47314);
var oref = map__47314__$1;
var parent = cljs.core.get.call(null,map__47314__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__47338 = arguments.length;
switch (G__47338) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
}));

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__47335_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__47335_SHARP_));
}),shadow.object.get_siblings.call(null,oref));
}));

(shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2);

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5733__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5733__auto__)){
var obj = temp__5733__auto__;
return obj;
} else {
var temp__5735__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5735__auto__)){
var parent = temp__5735__auto__;
var G__47882 = parent;
dom = G__47882;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47883 = arguments.length;
var i__4790__auto___47884 = (0);
while(true){
if((i__4790__auto___47884 < len__4789__auto___47883)){
args__4795__auto__.push((arguments[i__4790__auto___47884]));

var G__47885 = (i__4790__auto___47884 + (1));
i__4790__auto___47884 = G__47885;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5735__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5735__auto__)){
var reactions_to_trigger = temp__5735__auto__;
var seq__47369 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__47370 = null;
var count__47371 = (0);
var i__47372 = (0);
while(true){
if((i__47372 < count__47371)){
var rfn = cljs.core._nth.call(null,chunk__47370,i__47372);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__47886 = seq__47369;
var G__47887 = chunk__47370;
var G__47888 = count__47371;
var G__47889 = (i__47372 + (1));
seq__47369 = G__47886;
chunk__47370 = G__47887;
count__47371 = G__47888;
i__47372 = G__47889;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__47369);
if(temp__5735__auto____$1){
var seq__47369__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47369__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__47369__$1);
var G__47890 = cljs.core.chunk_rest.call(null,seq__47369__$1);
var G__47891 = c__4609__auto__;
var G__47892 = cljs.core.count.call(null,c__4609__auto__);
var G__47893 = (0);
seq__47369 = G__47890;
chunk__47370 = G__47891;
count__47371 = G__47892;
i__47372 = G__47893;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__47369__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__47895 = cljs.core.next.call(null,seq__47369__$1);
var G__47896 = null;
var G__47897 = (0);
var G__47898 = (0);
seq__47369 = G__47895;
chunk__47370 = G__47896;
count__47371 = G__47897;
i__47372 = G__47898;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));

(shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq47361){
var G__47362 = cljs.core.first.call(null,seq47361);
var seq47361__$1 = cljs.core.next.call(null,seq47361);
var G__47363 = cljs.core.first.call(null,seq47361__$1);
var seq47361__$2 = cljs.core.next.call(null,seq47361__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47362,G__47363,seq47361__$2);
}));

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__47431_47899 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__47432_47900 = null;
var count__47433_47901 = (0);
var i__47434_47902 = (0);
while(true){
if((i__47434_47902 < count__47433_47901)){
var child_47903 = cljs.core._nth.call(null,chunk__47432_47900,i__47434_47902);
shadow.object.do_notify_tree.call(null,child_47903,ev,notify_fn);


var G__47904 = seq__47431_47899;
var G__47905 = chunk__47432_47900;
var G__47906 = count__47433_47901;
var G__47907 = (i__47434_47902 + (1));
seq__47431_47899 = G__47904;
chunk__47432_47900 = G__47905;
count__47433_47901 = G__47906;
i__47434_47902 = G__47907;
continue;
} else {
var temp__5735__auto___47908 = cljs.core.seq.call(null,seq__47431_47899);
if(temp__5735__auto___47908){
var seq__47431_47909__$1 = temp__5735__auto___47908;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47431_47909__$1)){
var c__4609__auto___47910 = cljs.core.chunk_first.call(null,seq__47431_47909__$1);
var G__47911 = cljs.core.chunk_rest.call(null,seq__47431_47909__$1);
var G__47912 = c__4609__auto___47910;
var G__47913 = cljs.core.count.call(null,c__4609__auto___47910);
var G__47914 = (0);
seq__47431_47899 = G__47911;
chunk__47432_47900 = G__47912;
count__47433_47901 = G__47913;
i__47434_47902 = G__47914;
continue;
} else {
var child_47918 = cljs.core.first.call(null,seq__47431_47909__$1);
shadow.object.do_notify_tree.call(null,child_47918,ev,notify_fn);


var G__47919 = cljs.core.next.call(null,seq__47431_47909__$1);
var G__47920 = null;
var G__47921 = (0);
var G__47922 = (0);
seq__47431_47899 = G__47919;
chunk__47432_47900 = G__47920;
count__47433_47901 = G__47921;
i__47434_47902 = G__47922;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47925 = arguments.length;
var i__4790__auto___47926 = (0);
while(true){
if((i__4790__auto___47926 < len__4789__auto___47925)){
args__4795__auto__.push((arguments[i__4790__auto___47926]));

var G__47927 = (i__4790__auto___47926 + (1));
i__4790__auto___47926 = G__47927;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
}));

(shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq47440){
var G__47441 = cljs.core.first.call(null,seq47440);
var seq47440__$1 = cljs.core.next.call(null,seq47440);
var G__47442 = cljs.core.first.call(null,seq47440__$1);
var seq47440__$2 = cljs.core.next.call(null,seq47440__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47441,G__47442,seq47440__$2);
}));

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47930 = arguments.length;
var i__4790__auto___47931 = (0);
while(true){
if((i__4790__auto___47931 < len__4789__auto___47930)){
args__4795__auto__.push((arguments[i__4790__auto___47931]));

var G__47932 = (i__4790__auto___47931 + (1));
i__4790__auto___47931 = G__47932;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__47935 = shadow.object.get_parent.call(null,current);
current = G__47935;
continue;
} else {
return null;
}
break;
}
}));

(shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq47461){
var G__47462 = cljs.core.first.call(null,seq47461);
var seq47461__$1 = cljs.core.next.call(null,seq47461);
var G__47463 = cljs.core.first.call(null,seq47461__$1);
var seq47461__$2 = cljs.core.next.call(null,seq47461__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47462,G__47463,seq47461__$2);
}));

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47936 = arguments.length;
var i__4790__auto___47937 = (0);
while(true){
if((i__4790__auto___47937 < len__4789__auto___47936)){
args__4795__auto__.push((arguments[i__4790__auto___47937]));

var G__47938 = (i__4790__auto___47937 + (1));
i__4790__auto___47937 = G__47938;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id.call(null,oref);
var data = shadow.object._data.call(null,oref);
var work_fn = (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});
return shadow.object._update.call(null,oref,work_fn);
}));

(shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq47467){
var G__47468 = cljs.core.first.call(null,seq47467);
var seq47467__$1 = cljs.core.next.call(null,seq47467);
var G__47469 = cljs.core.first.call(null,seq47467__$1);
var seq47467__$2 = cljs.core.next.call(null,seq47467__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47468,G__47469,seq47467__$2);
}));

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id.call(null,child);
var parent_id = shadow.object._id.call(null,parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,(function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
}));

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5733__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5733__auto__)){
var custom_remove = temp__5733__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__47489 = arguments.length;
switch (G__47489) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
}));

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_.call(null,oref,cause);
}));

(shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2);

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type.call(null,oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__47495 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__47496 = null;
var count__47497 = (0);
var i__47498 = (0);
while(true){
if((i__47498 < count__47497)){
var vec__47511 = cljs.core._nth.call(null,chunk__47496,i__47498);
var ev = cljs.core.nth.call(null,vec__47511,(0),null);
var handler = cljs.core.nth.call(null,vec__47511,(1),null);
var ev_def = vec__47511;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_47958__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47495,chunk__47496,count__47497,i__47498,vec__47511,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47495,chunk__47496,count__47497,i__47498,vec__47511,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47495,chunk__47496,count__47497,i__47498,handler_47958__$1,vec__47511,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_47958__$1.call(null,oref,e,el);
});})(seq__47495,chunk__47496,count__47497,i__47498,handler_47958__$1,vec__47511,ev,handler,ev_def))
);


var G__47959 = seq__47495;
var G__47960 = chunk__47496;
var G__47961 = count__47497;
var G__47962 = (i__47498 + (1));
seq__47495 = G__47959;
chunk__47496 = G__47960;
count__47497 = G__47961;
i__47498 = G__47962;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__47495);
if(temp__5735__auto__){
var seq__47495__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47495__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__47495__$1);
var G__47963 = cljs.core.chunk_rest.call(null,seq__47495__$1);
var G__47964 = c__4609__auto__;
var G__47965 = cljs.core.count.call(null,c__4609__auto__);
var G__47966 = (0);
seq__47495 = G__47963;
chunk__47496 = G__47964;
count__47497 = G__47965;
i__47498 = G__47966;
continue;
} else {
var vec__47515 = cljs.core.first.call(null,seq__47495__$1);
var ev = cljs.core.nth.call(null,vec__47515,(0),null);
var handler = cljs.core.nth.call(null,vec__47515,(1),null);
var ev_def = vec__47515;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_47967__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47495,chunk__47496,count__47497,i__47498,vec__47515,ev,handler,ev_def,seq__47495__$1,temp__5735__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47495,chunk__47496,count__47497,i__47498,vec__47515,ev,handler,ev_def,seq__47495__$1,temp__5735__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47495,chunk__47496,count__47497,i__47498,handler_47967__$1,vec__47515,ev,handler,ev_def,seq__47495__$1,temp__5735__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_47967__$1.call(null,oref,e,el);
});})(seq__47495,chunk__47496,count__47497,i__47498,handler_47967__$1,vec__47515,ev,handler,ev_def,seq__47495__$1,temp__5735__auto__))
);


var G__47970 = cljs.core.next.call(null,seq__47495__$1);
var G__47971 = null;
var G__47972 = (0);
var G__47973 = (0);
seq__47495 = G__47970;
chunk__47496 = G__47971;
count__47497 = G__47972;
i__47498 = G__47973;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__47521){
var vec__47522 = p__47521;
var event = cljs.core.nth.call(null,vec__47522,(0),null);
var handler = cljs.core.nth.call(null,vec__47522,(1),null);
if(cljs.core.truth_((function (){var and__4174__auto__ = event;
if(cljs.core.truth_(and__4174__auto__)){
return handler;
} else {
return and__4174__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__4795__auto__ = [];
var len__4789__auto___47983 = arguments.length;
var i__4790__auto___47984 = (0);
while(true){
if((i__4790__auto___47984 < len__4789__auto___47983)){
args__4795__auto__.push((arguments[i__4790__auto___47984]));

var G__47985 = (i__4790__auto___47984 + (1));
i__4790__auto___47984 = G__47985;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e47599){if((e47599 instanceof Object)){
var e = e47599;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e47599;

}
}}));

(shadow.object.define.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.object.define.cljs$lang$applyTo = (function (seq47576){
var G__47577 = cljs.core.first.call(null,seq47576);
var seq47576__$1 = cljs.core.next.call(null,seq47576);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47577,seq47576__$1);
}));

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__47656 = arguments.length;
switch (G__47656) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
}));

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
}));

(shadow.object.make_dom.cljs$lang$maxFixedArity = 4);

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id.call(null,obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k47701,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__47717 = k47701;
var G__47717__$1 = (((G__47717 instanceof cljs.core.Keyword))?G__47717.fqn:null);
switch (G__47717__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47701,else__4442__auto__);

}
}));

(shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4461__auto__,p__47719){
var vec__47721 = p__47719;
var k__4462__auto__ = cljs.core.nth.call(null,vec__47721,(0),null);
var v__4463__auto__ = cljs.core.nth.call(null,vec__47721,(1),null);
return f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__);
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4454__auto__,pr_pair__4456__auto__,"#shadow.object.Watch{",", ","}",opts__4455__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47700){
var self__ = this;
var G__47700__$1 = this;
return (new cljs.core.RecordIter((0),G__47700__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__4436__auto__));
}).call(null,this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47706,other47707){
var self__ = this;
var this47706__$1 = this;
return (((!((other47707 == null)))) && ((this47706__$1.constructor === other47707.constructor)) && (cljs.core._EQ_.call(null,this47706__$1.key,other47707.key)) && (cljs.core._EQ_.call(null,this47706__$1.handler,other47707.handler)) && (cljs.core._EQ_.call(null,this47706__$1.__extmap,other47707.__extmap)));
}));

(shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__47700){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__47734 = cljs.core.keyword_identical_QMARK_;
var expr__47735 = k__4447__auto__;
if(cljs.core.truth_(pred__47734.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__47735))){
return (new shadow.object.Watch(G__47700,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47734.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__47735))){
return (new shadow.object.Watch(self__.key,G__47700,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4447__auto__,G__47700),null));
}
}
}));

(shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__47700){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__47700,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4445__auto__,(0)),cljs.core._nth.call(null,entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
}));

(shadow.object.Watch.cljs$lang$type = true);

(shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
}));

(shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write.call(null,writer__4483__auto__,"shadow.object/Watch");
}));

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__47709){
var extmap__4478__auto__ = (function (){var G__47740 = cljs.core.dissoc.call(null,G__47709,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__47709)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47740);
} else {
return G__47740;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__47709),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__47709),null,cljs.core.not_empty.call(null,extmap__4478__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.result_chan,handler);
}));

(shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write.call(null,writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id.call(null,this$__$1),shadow.object._id.call(null,other))));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null))));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.remove.call(null,(function (p1__47741_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__47741_SHARP_));
}),self__.watches));
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
(self__.data = new$);

var seq__47745 = cljs.core.seq.call(null,self__.watches);
var chunk__47746 = null;
var count__47747 = (0);
var i__47748 = (0);
while(true){
if((i__47748 < count__47747)){
var map__47753 = cljs.core._nth.call(null,chunk__47746,i__47748);
var map__47753__$1 = (((((!((map__47753 == null))))?(((((map__47753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47753.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47753):map__47753);
var watch = map__47753__$1;
var key = cljs.core.get.call(null,map__47753__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47753__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48069 = seq__47745;
var G__48070 = chunk__47746;
var G__48071 = count__47747;
var G__48072 = (i__47748 + (1));
seq__47745 = G__48069;
chunk__47746 = G__48070;
count__47747 = G__48071;
i__47748 = G__48072;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__47745);
if(temp__5735__auto__){
var seq__47745__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47745__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__47745__$1);
var G__48076 = cljs.core.chunk_rest.call(null,seq__47745__$1);
var G__48077 = c__4609__auto__;
var G__48078 = cljs.core.count.call(null,c__4609__auto__);
var G__48079 = (0);
seq__47745 = G__48076;
chunk__47746 = G__48077;
count__47747 = G__48078;
i__47748 = G__48079;
continue;
} else {
var map__47755 = cljs.core.first.call(null,seq__47745__$1);
var map__47755__$1 = (((((!((map__47755 == null))))?(((((map__47755.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47755.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47755):map__47755);
var watch = map__47755__$1;
var key = cljs.core.get.call(null,map__47755__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47755__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48080 = cljs.core.next.call(null,seq__47745__$1);
var G__48081 = null;
var G__48082 = (0);
var G__48083 = (0);
seq__47745 = G__48080;
chunk__47746 = G__48081;
count__47747 = G__48082;
i__47748 = G__48083;
continue;
}
} else {
return null;
}
}
break;
}
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__47757_48084 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__47758_48085 = null;
var count__47759_48086 = (0);
var i__47760_48087 = (0);
while(true){
if((i__47760_48087 < count__47759_48086)){
var child_48088 = cljs.core._nth.call(null,chunk__47758_48085,i__47760_48087);
shadow.object._destroy_BANG_.call(null,child_48088,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48089 = seq__47757_48084;
var G__48090 = chunk__47758_48085;
var G__48091 = count__47759_48086;
var G__48092 = (i__47760_48087 + (1));
seq__47757_48084 = G__48089;
chunk__47758_48085 = G__48090;
count__47759_48086 = G__48091;
i__47760_48087 = G__48092;
continue;
} else {
var temp__5735__auto___48093 = cljs.core.seq.call(null,seq__47757_48084);
if(temp__5735__auto___48093){
var seq__47757_48094__$1 = temp__5735__auto___48093;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47757_48094__$1)){
var c__4609__auto___48095 = cljs.core.chunk_first.call(null,seq__47757_48094__$1);
var G__48096 = cljs.core.chunk_rest.call(null,seq__47757_48094__$1);
var G__48097 = c__4609__auto___48095;
var G__48098 = cljs.core.count.call(null,c__4609__auto___48095);
var G__48099 = (0);
seq__47757_48084 = G__48096;
chunk__47758_48085 = G__48097;
count__47759_48086 = G__48098;
i__47760_48087 = G__48099;
continue;
} else {
var child_48100 = cljs.core.first.call(null,seq__47757_48094__$1);
shadow.object._destroy_BANG_.call(null,child_48100,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48101 = cljs.core.next.call(null,seq__47757_48094__$1);
var G__48102 = null;
var G__48103 = (0);
var G__48104 = (0);
seq__47757_48084 = G__48101;
chunk__47758_48085 = G__48102;
count__47759_48086 = G__48103;
i__47760_48087 = G__48104;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_48107 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_48107 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_48107);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
}));

(shadow.object.ObjectRef.cljs$lang$type = true);

(shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef");

(shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.object/ObjectRef");
}));

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__47763 = arguments.length;
switch (G__47763) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
}));

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
}));

(shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3);

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__47765 = arguments.length;
switch (G__47765) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
}));

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,(function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
}));
}));

(shadow.object.bind_change.cljs$lang$maxFixedArity = 4);

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__4795__auto__ = [];
var len__4789__auto___48143 = arguments.length;
var i__4790__auto___48147 = (0);
while(true){
if((i__4790__auto___48147 < len__4789__auto___48143)){
args__4795__auto__.push((arguments[i__4790__auto___48147]));

var G__48148 = (i__4790__auto___48147 + (1));
i__4790__auto___48147 = G__48148;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_48149 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5733__auto___48150 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5733__auto___48150)){
var dom_48151 = temp__5733__auto___48150;
shadow.dom.set_data.call(null,dom_48151,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_48151,dom_events_48149);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48151);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48151);
} else {
var temp__5735__auto___48152 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5735__auto___48152)){
var dom_fn_48153 = temp__5735__auto___48152;
var dom_48154 = shadow.dom.build.call(null,dom_fn_48153.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_48154,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48154);

shadow.object.bind_dom_events.call(null,oref,dom_48154,dom_events_48149);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48154);
} else {
}
}

var temp__5735__auto___48156 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5735__auto___48156)){
var watches_48157 = temp__5735__auto___48156;
var seq__47770_48158 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_48157));
var chunk__47771_48159 = null;
var count__47772_48160 = (0);
var i__47773_48161 = (0);
while(true){
if((i__47773_48161 < count__47772_48160)){
var vec__47780_48162 = cljs.core._nth.call(null,chunk__47771_48159,i__47773_48161);
var attr_48163 = cljs.core.nth.call(null,vec__47780_48162,(0),null);
var handler_48164 = cljs.core.nth.call(null,vec__47780_48162,(1),null);
shadow.object.bind_change.call(null,oref,attr_48163,((function (seq__47770_48158,chunk__47771_48159,count__47772_48160,i__47773_48161,vec__47780_48162,attr_48163,handler_48164,watches_48157,temp__5735__auto___48156,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48164.call(null,oref,old,new$);
});})(seq__47770_48158,chunk__47771_48159,count__47772_48160,i__47773_48161,vec__47780_48162,attr_48163,handler_48164,watches_48157,temp__5735__auto___48156,oid,parent,result_chan,odef,obj,oref))
);


var G__48165 = seq__47770_48158;
var G__48166 = chunk__47771_48159;
var G__48167 = count__47772_48160;
var G__48168 = (i__47773_48161 + (1));
seq__47770_48158 = G__48165;
chunk__47771_48159 = G__48166;
count__47772_48160 = G__48167;
i__47773_48161 = G__48168;
continue;
} else {
var temp__5735__auto___48169__$1 = cljs.core.seq.call(null,seq__47770_48158);
if(temp__5735__auto___48169__$1){
var seq__47770_48171__$1 = temp__5735__auto___48169__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47770_48171__$1)){
var c__4609__auto___48174 = cljs.core.chunk_first.call(null,seq__47770_48171__$1);
var G__48175 = cljs.core.chunk_rest.call(null,seq__47770_48171__$1);
var G__48176 = c__4609__auto___48174;
var G__48177 = cljs.core.count.call(null,c__4609__auto___48174);
var G__48178 = (0);
seq__47770_48158 = G__48175;
chunk__47771_48159 = G__48176;
count__47772_48160 = G__48177;
i__47773_48161 = G__48178;
continue;
} else {
var vec__47783_48179 = cljs.core.first.call(null,seq__47770_48171__$1);
var attr_48180 = cljs.core.nth.call(null,vec__47783_48179,(0),null);
var handler_48181 = cljs.core.nth.call(null,vec__47783_48179,(1),null);
shadow.object.bind_change.call(null,oref,attr_48180,((function (seq__47770_48158,chunk__47771_48159,count__47772_48160,i__47773_48161,vec__47783_48179,attr_48180,handler_48181,seq__47770_48171__$1,temp__5735__auto___48169__$1,watches_48157,temp__5735__auto___48156,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48181.call(null,oref,old,new$);
});})(seq__47770_48158,chunk__47771_48159,count__47772_48160,i__47773_48161,vec__47783_48179,attr_48180,handler_48181,seq__47770_48171__$1,temp__5735__auto___48169__$1,watches_48157,temp__5735__auto___48156,oid,parent,result_chan,odef,obj,oref))
);


var G__48182 = cljs.core.next.call(null,seq__47770_48171__$1);
var G__48183 = null;
var G__48184 = (0);
var G__48185 = (0);
seq__47770_48158 = G__48182;
chunk__47771_48159 = G__48183;
count__47772_48160 = G__48184;
i__47773_48161 = G__48185;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
}));

(shadow.object.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.create.cljs$lang$applyTo = (function (seq47767){
var G__47768 = cljs.core.first.call(null,seq47767);
var seq47767__$1 = cljs.core.next.call(null,seq47767);
var G__47769 = cljs.core.first.call(null,seq47767__$1);
var seq47767__$2 = cljs.core.next.call(null,seq47767__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47768,G__47769,seq47767__$2);
}));

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__47788 = arguments.length;
switch (G__47788) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
}));

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = (function (p1__47786_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__47786_SHARP_));
});
var node = cljs.core.atom.call(null,node_get.call(null,cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_node = node_get.call(null,new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
}));

return cljs.core.deref.call(null,node);
}));

(shadow.object.bind_simple.cljs$lang$maxFixedArity = 3);

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});
var child = cljs.core.atom.call(null,make_child_fn.call(null,curval));
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_child = make_child_fn.call(null,new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}));

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__47789_48190 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__47790_48191 = null;
var count__47791_48192 = (0);
var i__47792_48193 = (0);
while(true){
if((i__47792_48193 < count__47791_48192)){
var obj_48194 = cljs.core._nth.call(null,chunk__47790_48191,i__47792_48193);
var obj_48195__$1 = shadow.object.get_from_dom.call(null,obj_48194);
shadow.object.destroy_BANG_.call(null,obj_48195__$1);


var G__48196 = seq__47789_48190;
var G__48197 = chunk__47790_48191;
var G__48198 = count__47791_48192;
var G__48199 = (i__47792_48193 + (1));
seq__47789_48190 = G__48196;
chunk__47790_48191 = G__48197;
count__47791_48192 = G__48198;
i__47792_48193 = G__48199;
continue;
} else {
var temp__5735__auto___48200 = cljs.core.seq.call(null,seq__47789_48190);
if(temp__5735__auto___48200){
var seq__47789_48201__$1 = temp__5735__auto___48200;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47789_48201__$1)){
var c__4609__auto___48202 = cljs.core.chunk_first.call(null,seq__47789_48201__$1);
var G__48203 = cljs.core.chunk_rest.call(null,seq__47789_48201__$1);
var G__48204 = c__4609__auto___48202;
var G__48205 = cljs.core.count.call(null,c__4609__auto___48202);
var G__48206 = (0);
seq__47789_48190 = G__48203;
chunk__47790_48191 = G__48204;
count__47791_48192 = G__48205;
i__47792_48193 = G__48206;
continue;
} else {
var obj_48207 = cljs.core.first.call(null,seq__47789_48201__$1);
var obj_48208__$1 = shadow.object.get_from_dom.call(null,obj_48207);
shadow.object.destroy_BANG_.call(null,obj_48208__$1);


var G__48209 = cljs.core.next.call(null,seq__47789_48201__$1);
var G__48210 = null;
var G__48211 = (0);
var G__48212 = (0);
seq__47789_48190 = G__48209;
chunk__47790_48191 = G__48210;
count__47791_48192 = G__48211;
i__47792_48193 = G__48212;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__47795 = arguments.length;
switch (G__47795) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__47793_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__47793_SHARP_);
}));
}));

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = (function (p__47796){
var vec__47797 = p__47796;
var key = cljs.core.nth.call(null,vec__47797,(0),null);
var val = cljs.core.nth.call(null,vec__47797,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,(function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
}));

return obj;
});
var seq__47800_48216 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__47801_48217 = null;
var count__47802_48218 = (0);
var i__47803_48219 = (0);
while(true){
if((i__47803_48219 < count__47802_48218)){
var item_48220 = cljs.core._nth.call(null,chunk__47801_48217,i__47803_48219);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48220));


var G__48221 = seq__47800_48216;
var G__48222 = chunk__47801_48217;
var G__48223 = count__47802_48218;
var G__48224 = (i__47803_48219 + (1));
seq__47800_48216 = G__48221;
chunk__47801_48217 = G__48222;
count__47802_48218 = G__48223;
i__47803_48219 = G__48224;
continue;
} else {
var temp__5735__auto___48225 = cljs.core.seq.call(null,seq__47800_48216);
if(temp__5735__auto___48225){
var seq__47800_48226__$1 = temp__5735__auto___48225;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47800_48226__$1)){
var c__4609__auto___48227 = cljs.core.chunk_first.call(null,seq__47800_48226__$1);
var G__48228 = cljs.core.chunk_rest.call(null,seq__47800_48226__$1);
var G__48229 = c__4609__auto___48227;
var G__48230 = cljs.core.count.call(null,c__4609__auto___48227);
var G__48231 = (0);
seq__47800_48216 = G__48228;
chunk__47801_48217 = G__48229;
count__47802_48218 = G__48230;
i__47803_48219 = G__48231;
continue;
} else {
var item_48232 = cljs.core.first.call(null,seq__47800_48226__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48232));


var G__48233 = cljs.core.next.call(null,seq__47800_48226__$1);
var G__48234 = null;
var G__48235 = (0);
var G__48236 = (0);
seq__47800_48216 = G__48233;
chunk__47801_48217 = G__48234;
count__47802_48218 = G__48235;
i__47803_48219 = G__48236;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,(function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__4276__auto__ = count_new;
var y__4277__auto__ = count_children;
return ((x__4276__auto__ < y__4277__auto__) ? x__4276__auto__ : y__4277__auto__);
})();
var n__4666__auto___48239 = count_children__$1;
var idx_48240 = (0);
while(true){
if((idx_48240 < n__4666__auto___48239)){
var cn_48241 = cljs.core.nth.call(null,children__$1,idx_48240);
var cc_48242 = shadow.object.get_from_dom.call(null,cn_48241);
var ckey_48243 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_48242);
var cval_48244 = cljs.core.get.call(null,cc_48242,item_key);
var vec__47804_48245 = cljs.core.nth.call(null,new_coll,idx_48240);
var nkey_48246 = cljs.core.nth.call(null,vec__47804_48245,(0),null);
var nval_48247 = cljs.core.nth.call(null,vec__47804_48245,(1),null);
if(((cljs.core._EQ_.call(null,ckey_48243,nkey_48246)) && (cljs.core._EQ_.call(null,cval_48244,nval_48247)))){
} else {
var new_obj_48248 = make_item_fn.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_48246,nval_48247], null));
shadow.dom.replace_node.call(null,cn_48241,new_obj_48248);

shadow.object.destroy_BANG_.call(null,cc_48242);

shadow.object.notify_tree_BANG_.call(null,new_obj_48248,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__48250 = (idx_48240 + (1));
idx_48240 = G__48250;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__47807_48251 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__47808_48252 = null;
var count__47809_48253 = (0);
var i__47810_48254 = (0);
while(true){
if((i__47810_48254 < count__47809_48253)){
var item_48256 = cljs.core._nth.call(null,chunk__47808_48252,i__47810_48254);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48256));


var G__48257 = seq__47807_48251;
var G__48258 = chunk__47808_48252;
var G__48259 = count__47809_48253;
var G__48260 = (i__47810_48254 + (1));
seq__47807_48251 = G__48257;
chunk__47808_48252 = G__48258;
count__47809_48253 = G__48259;
i__47810_48254 = G__48260;
continue;
} else {
var temp__5735__auto___48261 = cljs.core.seq.call(null,seq__47807_48251);
if(temp__5735__auto___48261){
var seq__47807_48262__$1 = temp__5735__auto___48261;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47807_48262__$1)){
var c__4609__auto___48263 = cljs.core.chunk_first.call(null,seq__47807_48262__$1);
var G__48264 = cljs.core.chunk_rest.call(null,seq__47807_48262__$1);
var G__48265 = c__4609__auto___48263;
var G__48266 = cljs.core.count.call(null,c__4609__auto___48263);
var G__48267 = (0);
seq__47807_48251 = G__48264;
chunk__47808_48252 = G__48265;
count__47809_48253 = G__48266;
i__47810_48254 = G__48267;
continue;
} else {
var item_48268 = cljs.core.first.call(null,seq__47807_48262__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48268));


var G__48270 = cljs.core.next.call(null,seq__47807_48262__$1);
var G__48273 = null;
var G__48274 = (0);
var G__48275 = (0);
seq__47807_48251 = G__48270;
chunk__47808_48252 = G__48273;
count__47809_48253 = G__48274;
i__47810_48254 = G__48275;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
}));

return coll_dom;
}));

(shadow.object.bind_children.cljs$lang$maxFixedArity = 6);

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__4174__auto__ = key;
if(cljs.core.truth_(and__4174__auto__)){
return path;
} else {
return and__4174__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id.call(null,oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type.call(null,oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data.call(null,oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__47812_48276 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__47813_48277 = null;
var count__47814_48278 = (0);
var i__47815_48279 = (0);
while(true){
if((i__47815_48279 < count__47814_48278)){
var vec__47822_48280 = cljs.core._nth.call(null,chunk__47813_48277,i__47815_48279);
var id_48281 = cljs.core.nth.call(null,vec__47822_48280,(0),null);
var oref_48282 = cljs.core.nth.call(null,vec__47822_48280,(1),null);
shadow.object.info.call(null,"dump",id_48281,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_48282)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_48282)));


var G__48283 = seq__47812_48276;
var G__48284 = chunk__47813_48277;
var G__48285 = count__47814_48278;
var G__48286 = (i__47815_48279 + (1));
seq__47812_48276 = G__48283;
chunk__47813_48277 = G__48284;
count__47814_48278 = G__48285;
i__47815_48279 = G__48286;
continue;
} else {
var temp__5735__auto___48287 = cljs.core.seq.call(null,seq__47812_48276);
if(temp__5735__auto___48287){
var seq__47812_48288__$1 = temp__5735__auto___48287;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47812_48288__$1)){
var c__4609__auto___48289 = cljs.core.chunk_first.call(null,seq__47812_48288__$1);
var G__48290 = cljs.core.chunk_rest.call(null,seq__47812_48288__$1);
var G__48291 = c__4609__auto___48289;
var G__48292 = cljs.core.count.call(null,c__4609__auto___48289);
var G__48293 = (0);
seq__47812_48276 = G__48290;
chunk__47813_48277 = G__48291;
count__47814_48278 = G__48292;
i__47815_48279 = G__48293;
continue;
} else {
var vec__47826_48294 = cljs.core.first.call(null,seq__47812_48288__$1);
var id_48295 = cljs.core.nth.call(null,vec__47826_48294,(0),null);
var oref_48296 = cljs.core.nth.call(null,vec__47826_48294,(1),null);
shadow.object.info.call(null,"dump",id_48295,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_48296)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_48296)));


var G__48297 = cljs.core.next.call(null,seq__47812_48288__$1);
var G__48298 = null;
var G__48299 = (0);
var G__48300 = (0);
seq__47812_48276 = G__48297;
chunk__47813_48277 = G__48298;
count__47814_48278 = G__48299;
i__47815_48279 = G__48300;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
