goog.provide('shadow.xhr');
shadow.xhr.result_chain = (function shadow$xhr$result_chain(res,handler){
return goog.result.chain(res,handler);
});
shadow.xhr.result_combine = (function shadow$xhr$result_combine(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48511 = arguments.length;
var i__4737__auto___48512 = (0);
while(true){
if((i__4737__auto___48512 < len__4736__auto___48511)){
args__4742__auto__.push((arguments[i__4737__auto___48512]));

var G__48514 = (i__4737__auto___48512 + (1));
i__4737__auto___48512 = G__48514;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic = (function (results){
return cljs.core.apply.call(null,goog.result.combine,results);
}));

(shadow.xhr.result_combine.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.xhr.result_combine.cljs$lang$applyTo = (function (seq48292){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq48292));
}));

shadow.xhr.result_wait_on_success = (function shadow$xhr$result_wait_on_success(res,callback){
return goog.result.waitOnSuccess(res,callback);
});
shadow.xhr.result_success_QMARK_ = (function shadow$xhr$result_success_QMARK_(res){
return cljs.core._EQ_.call(null,goog.result.Result.State.SUCCESS,res.getState());
});
shadow.xhr.result_value = (function shadow$xhr$result_value(res){
return res.getValue();
});
shadow.xhr.result_immediate = (function shadow$xhr$result_immediate(value){
return goog.result.successfulResult(value);
});
shadow.xhr.result_error = (function shadow$xhr$result_error(res,callback){
return goog.result.waitOnError(res,callback);
});
shadow.xhr.edn_transform = (function shadow$xhr$edn_transform(body){
return cljs.reader.read_string.call(null,body);
});
shadow.xhr.json_transform = (function shadow$xhr$json_transform(body){
return cljs.core.js__GT_clj.call(null,JSON.parse(body));
});
shadow.xhr.goog_keys = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"timeout","timeout",-318625318),"timeoutMs",new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),"withCredentials",new cljs.core.Keyword(null,"headers","headers",-835030129),"headers",new cljs.core.Keyword(null,"mime-type","mime-type",1058646439),"mimeType"], null);
shadow.xhr.make_request_options = (function shadow$xhr$make_request_options(options){
var obj = ({});
var seq__48316_48525 = cljs.core.seq.call(null,options);
var chunk__48317_48526 = null;
var count__48318_48527 = (0);
var i__48319_48528 = (0);
while(true){
if((i__48319_48528 < count__48318_48527)){
var vec__48330_48531 = cljs.core._nth(chunk__48317_48526,i__48319_48528);
var k_48532 = cljs.core.nth.call(null,vec__48330_48531,(0),null);
var v_48533 = cljs.core.nth.call(null,vec__48330_48531,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_48532)] = cljs.core.clj__GT_js.call(null,v_48533));


var G__48535 = seq__48316_48525;
var G__48536 = chunk__48317_48526;
var G__48537 = count__48318_48527;
var G__48538 = (i__48319_48528 + (1));
seq__48316_48525 = G__48535;
chunk__48317_48526 = G__48536;
count__48318_48527 = G__48537;
i__48319_48528 = G__48538;
continue;
} else {
var temp__5720__auto___48539 = cljs.core.seq.call(null,seq__48316_48525);
if(temp__5720__auto___48539){
var seq__48316_48540__$1 = temp__5720__auto___48539;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48316_48540__$1)){
var c__4556__auto___48541 = cljs.core.chunk_first.call(null,seq__48316_48540__$1);
var G__48547 = cljs.core.chunk_rest.call(null,seq__48316_48540__$1);
var G__48548 = c__4556__auto___48541;
var G__48549 = cljs.core.count.call(null,c__4556__auto___48541);
var G__48550 = (0);
seq__48316_48525 = G__48547;
chunk__48317_48526 = G__48548;
count__48318_48527 = G__48549;
i__48319_48528 = G__48550;
continue;
} else {
var vec__48338_48554 = cljs.core.first.call(null,seq__48316_48540__$1);
var k_48555 = cljs.core.nth.call(null,vec__48338_48554,(0),null);
var v_48556 = cljs.core.nth.call(null,vec__48338_48554,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_48555)] = cljs.core.clj__GT_js.call(null,v_48556));


var G__48558 = cljs.core.next.call(null,seq__48316_48540__$1);
var G__48559 = null;
var G__48560 = (0);
var G__48561 = (0);
seq__48316_48525 = G__48558;
chunk__48317_48526 = G__48559;
count__48318_48527 = G__48560;
i__48319_48528 = G__48561;
continue;
}
} else {
}
}
break;
}

return obj;
});
shadow.xhr.content_transforms = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 5, ["text/edn",shadow.xhr.edn_transform,"application/edn",shadow.xhr.edn_transform,"application/json",shadow.xhr.json_transform,"text/html",cljs.core.identity,"text/plain",cljs.core.identity], null));
shadow.xhr.register_transform = (function shadow$xhr$register_transform(content_type,transform_fn){
return cljs.core.swap_BANG_.call(null,shadow.xhr.content_transforms,cljs.core.assoc,content_type,transform_fn);
});
shadow.xhr.auto_transform = (function shadow$xhr$auto_transform(req){
var content_type = (function (){var ct = clojure.string.lower_case.call(null,req.getResponseHeader("Content-Type"));
var sep = ct.indexOf(";");
if(cljs.core.not_EQ_.call(null,(-1),sep)){
return ct.substring((0),sep);
} else {
return ct;
}
})();
var transform_fn = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.xhr.content_transforms),content_type);
if((transform_fn == null)){
throw cljs.core.ex_info.call(null,"unsupported content-type",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"req","req",-326448303),req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type], null));
} else {
return transform_fn.call(null,req.responseText);
}
});
shadow.xhr.make_url = (function shadow$xhr$make_url(url,params){
return goog.uri.utils.appendParamsFromMap(url,cljs.core.clj__GT_js.call(null,params));
});
shadow.xhr.transform_request_body = (function shadow$xhr$transform_request_body(data){
if(typeof data === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain; charset=utf-8",data], null);
} else {
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (2147483648))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IPrintWithWriter$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/edn; charset=utf-8",cljs.core.pr_str.call(null,data)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["application/octet-stream",data], null);

}
}
});
shadow.xhr.as_url = (function shadow$xhr$as_url(input){
if(typeof input === 'string'){
return input;
} else {
if(((cljs.core.vector_QMARK_.call(null,input)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,input))) && (typeof cljs.core.first.call(null,input) === 'string') && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,input))))){
var vec__48369 = input;
var url = cljs.core.nth.call(null,vec__48369,(0),null);
var params = cljs.core.nth.call(null,vec__48369,(1),null);
return shadow.xhr.make_url.call(null,url,params);
} else {
throw cljs.core.ex_info.call(null,"doesnt look like an url",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),input], null));

}
}
});
shadow.xhr.e__GT_data = (function shadow$xhr$e__GT_data(e){
return e;
});
shadow.xhr.event_handler = (function shadow$xhr$event_handler(req,events,event_type){
return (function (e){
if(cljs.core.map_QMARK_.call(null,events)){
var temp__5720__auto__ = cljs.core.get.call(null,events,event_type);
if(cljs.core.truth_(temp__5720__auto__)){
var c = temp__5720__auto__;
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;
}
} else {
if((!((events == null)))){
return cljs.core.async.put_BANG_.call(null,events,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;

}
}
});
});
shadow.xhr.request_ok_QMARK_ = (function shadow$xhr$request_ok_QMARK_(status){
return cljs.core._EQ_.call(null,(200),status);
});
shadow.xhr.request_error_QMARK_ = (function shadow$xhr$request_error_QMARK_(status){
return (status >= (400));
});
/**
 * creates a channel and performs xhr request like (chan :GET "/something")
 * 
 * accepts url as string or [url params]
 * 
 * this channel will receive one message [status body req] on load
 * loadend will close the result channel, so you will get nil results on request errors/timeouts
 * 
 * use options hash to pass in extra channels
 * 
 * (chan :POST "/something" some-data {:events chan-or-map
 *                                       :upload chan-or-map})
 * 
 * when given a chan that channels receives messages in form of [event-type event-data req]
 * when given a map a channel is expected for each eventtype and will receive [event-data req]
 * {:timeout some-chan}, if no channel for a given event is present, no message is sent
 * 
 * event types are :loadstart :progress :abort :error :timeout :loadend :load (see xhr spec)
 * only exception is that status >= 500 does not return a result and produces an error event instead
 */
shadow.xhr.chan = (function shadow$xhr$chan(var_args){
var G__48410 = arguments.length;
switch (G__48410) {
case 2:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.chan.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.chan.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,p__48418){
var map__48419 = p__48418;
var map__48419__$1 = (((((!((map__48419 == null))))?(((((map__48419.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48419.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48419):map__48419);
var options = map__48419__$1;
var events = cljs.core.get.call(null,map__48419__$1,new cljs.core.Keyword(null,"events","events",1792552201));
var upload = cljs.core.get.call(null,map__48419__$1,new cljs.core.Keyword(null,"upload","upload",-255769218));
var body_only = cljs.core.get.call(null,map__48419__$1,new cljs.core.Keyword(null,"body-only","body-only",-698120682));
var req = (new XMLHttpRequest());
var body_QMARK_ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
var vec__48421 = ((body_QMARK_)?shadow.xhr.transform_request_body.call(null,data):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null));
var content_type = cljs.core.nth.call(null,vec__48421,(0),null);
var body = cljs.core.nth.call(null,vec__48421,(1),null);
var result_chan = cljs.core.async.chan.call(null,(1));
if(cljs.core.truth_(((body_QMARK_)?upload:false))){
shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"error","error",-978969032),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"error","error",-978969032)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"load","load",-1318641184),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));
} else {
}

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadend","loadend",1430560564),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadend","loadend",1430560564));
return (function (e){
callback(e);

return cljs.core.async.close_BANG_.call(null,result_chan);
});
})());

var error_handler_48628 = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"error","error",-978969032));
shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"error","error",-978969032),error_handler_48628);

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"load","load",-1318641184),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"load","load",-1318641184));
return (function (e){
var status = req.status;
var body__$1 = (function (){var temp__5718__auto__ = new cljs.core.Keyword(null,"transform","transform",1381301764).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5718__auto__)){
var transform = temp__5718__auto__;
return transform.call(null,req.responseText,req);
} else {
return shadow.xhr.auto_transform.call(null,req);
}
})();
if(shadow.xhr.request_error_QMARK_.call(null,status)){
return error_handler_48628(e);
} else {
callback(e);

if(cljs.core.truth_(body_only)){
return cljs.core.async.put_BANG_.call(null,result_chan,body__$1);
} else {
return cljs.core.async.put_BANG_.call(null,result_chan,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,body__$1,req], null));
}
}
});
})());

req.open(cljs.core.name.call(null,method),shadow.xhr.as_url.call(null,url),true);

(req.responseType = "text");

(req.withCredentials = (!(new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235).cljs$core$IFn$_invoke$arity$1(options) === false)));

if(body_QMARK_){
req.setRequestHeader("Content-Type",content_type);
} else {
}

if(body_QMARK_){
req.send(body);
} else {
req.send();
}

return result_chan;
}));

(shadow.xhr.chan.cljs$lang$maxFixedArity = 4);

shadow.xhr.request = (function shadow$xhr$request(var_args){
var G__48455 = arguments.length;
switch (G__48455) {
case 2:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.request.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.request.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,options){
if((((!(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"DELETE","DELETE",1688673772),null,new cljs.core.Keyword(null,"GET","GET",1736591026),null], null), null),method)))) && ((data == null)))){
throw cljs.core.ex_info.call(null,"request needs data",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"options","options",99638489),options], null));
} else {
}

var body_QMARK_ = (!(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method)) || ((data == null)))));
var vec__48461 = shadow.xhr.transform_request_body.call(null,data);
var content_type = cljs.core.nth.call(null,vec__48461,(0),null);
var body = cljs.core.nth.call(null,vec__48461,(1),null);
var req = goog.labs.net.xhr.send(cljs.core.name.call(null,method),(cljs.core.truth_(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method))?data:false))?shadow.xhr.make_url.call(null,url,data):url),((body_QMARK_)?body:null),shadow.xhr.make_request_options.call(null,((body_QMARK_)?cljs.core.assoc_in.call(null,options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Content-Type"], null),content_type):options)));
var req__$1 = goog.result.SimpleResult.fromPromise(req);
return goog.result.transform(req__$1,shadow.xhr.auto_transform);
}));

(shadow.xhr.request.cljs$lang$maxFixedArity = 4);

shadow.xhr.upload = (function shadow$xhr$upload(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48643 = arguments.length;
var i__4737__auto___48644 = (0);
while(true){
if((i__4737__auto___48644 < len__4736__auto___48643)){
args__4742__auto__.push((arguments[i__4737__auto___48644]));

var G__48645 = (i__4737__auto___48644 + (1));
i__4737__auto___48644 = G__48645;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic = (function (url,file,events){
var xhr = (new XMLHttpRequest());
var seq__48474_48646 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),events));
var chunk__48476_48647 = null;
var count__48477_48648 = (0);
var i__48478_48649 = (0);
while(true){
if((i__48478_48649 < count__48477_48648)){
var vec__48487_48650 = cljs.core._nth(chunk__48476_48647,i__48478_48649);
var ev_id_48651 = cljs.core.nth.call(null,vec__48487_48650,(0),null);
var ev_handler_48652 = cljs.core.nth.call(null,vec__48487_48650,(1),null);
var target_48653 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_48651))?(xhr["upload"]):xhr);
target_48653.addEventListener(cljs.core.name.call(null,ev_id_48651),ev_handler_48652);


var G__48655 = seq__48474_48646;
var G__48656 = chunk__48476_48647;
var G__48657 = count__48477_48648;
var G__48658 = (i__48478_48649 + (1));
seq__48474_48646 = G__48655;
chunk__48476_48647 = G__48656;
count__48477_48648 = G__48657;
i__48478_48649 = G__48658;
continue;
} else {
var temp__5720__auto___48661 = cljs.core.seq.call(null,seq__48474_48646);
if(temp__5720__auto___48661){
var seq__48474_48662__$1 = temp__5720__auto___48661;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48474_48662__$1)){
var c__4556__auto___48663 = cljs.core.chunk_first.call(null,seq__48474_48662__$1);
var G__48664 = cljs.core.chunk_rest.call(null,seq__48474_48662__$1);
var G__48665 = c__4556__auto___48663;
var G__48666 = cljs.core.count.call(null,c__4556__auto___48663);
var G__48667 = (0);
seq__48474_48646 = G__48664;
chunk__48476_48647 = G__48665;
count__48477_48648 = G__48666;
i__48478_48649 = G__48667;
continue;
} else {
var vec__48495_48669 = cljs.core.first.call(null,seq__48474_48662__$1);
var ev_id_48670 = cljs.core.nth.call(null,vec__48495_48669,(0),null);
var ev_handler_48671 = cljs.core.nth.call(null,vec__48495_48669,(1),null);
var target_48676 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_48670))?(xhr["upload"]):xhr);
target_48676.addEventListener(cljs.core.name.call(null,ev_id_48670),ev_handler_48671);


var G__48679 = cljs.core.next.call(null,seq__48474_48662__$1);
var G__48680 = null;
var G__48681 = (0);
var G__48682 = (0);
seq__48474_48646 = G__48679;
chunk__48476_48647 = G__48680;
count__48477_48648 = G__48681;
i__48478_48649 = G__48682;
continue;
}
} else {
}
}
break;
}

var G__48502 = xhr;
G__48502.open("PUT",url);

G__48502.send(file);

return G__48502;
}));

(shadow.xhr.upload.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.xhr.upload.cljs$lang$applyTo = (function (seq48469){
var G__48470 = cljs.core.first.call(null,seq48469);
var seq48469__$1 = cljs.core.next.call(null,seq48469);
var G__48471 = cljs.core.first.call(null,seq48469__$1);
var seq48469__$2 = cljs.core.next.call(null,seq48469__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48470,G__48471,seq48469__$2);
}));


//# sourceMappingURL=shadow.xhr.js.map
