goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.call(null,(function (p__46559){
var vec__46560 = p__46559;
var ns = cljs.core.nth.call(null,vec__46560,(0),null);
var vars__$1 = cljs.core.nth.call(null,vec__46560,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block.call(null,(function (){var env = cljs.test.get_current_env.call(null);
var once_fixtures = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__46564 = cljs.test.execution_strategy.call(null,once_fixtures,each_fixtures);
var G__46564__$1 = (((G__46564 instanceof cljs.core.Keyword))?G__46564.fqn:null);
switch (G__46564__$1) {
case "async":
return cljs.test.wrap_map_fixtures.call(null,once_fixtures,cljs.core.mapcat.call(null,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.filter.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures.call(null,each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.join_fixtures.call(null,once_fixtures).call(null,(function (){
var seq__46589 = cljs.core.seq.call(null,vars__$1);
var chunk__46590 = null;
var count__46592 = (0);
var i__46593 = (0);
while(true){
if((i__46593 < count__46592)){
var v = cljs.core._nth(chunk__46590,i__46593);
var temp__5720__auto___46934 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
if(cljs.core.truth_(temp__5720__auto___46934)){
var t_46936 = temp__5720__auto___46934;
each_fixture_fn.call(null,((function (seq__46589,chunk__46590,count__46592,i__46593,t_46936,temp__5720__auto___46934,v,each_fixture_fn,G__46564,G__46564__$1,env,once_fixtures,each_fixtures,vec__46560,ns,vars__$1){
return (function (){
return cljs.test.run_block.call(null,cljs.test.test_var_block_STAR_.call(null,v,cljs.test.disable_async.call(null,t_46936)));
});})(seq__46589,chunk__46590,count__46592,i__46593,t_46936,temp__5720__auto___46934,v,each_fixture_fn,G__46564,G__46564__$1,env,once_fixtures,each_fixtures,vec__46560,ns,vars__$1))
);
} else {
}


var G__46947 = seq__46589;
var G__46948 = chunk__46590;
var G__46949 = count__46592;
var G__46950 = (i__46593 + (1));
seq__46589 = G__46947;
chunk__46590 = G__46948;
count__46592 = G__46949;
i__46593 = G__46950;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46589);
if(temp__5720__auto__){
var seq__46589__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46589__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46589__$1);
var G__46951 = cljs.core.chunk_rest.call(null,seq__46589__$1);
var G__46952 = c__4556__auto__;
var G__46953 = cljs.core.count.call(null,c__4556__auto__);
var G__46954 = (0);
seq__46589 = G__46951;
chunk__46590 = G__46952;
count__46592 = G__46953;
i__46593 = G__46954;
continue;
} else {
var v = cljs.core.first.call(null,seq__46589__$1);
var temp__5720__auto___46955__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v));
if(cljs.core.truth_(temp__5720__auto___46955__$1)){
var t_46956 = temp__5720__auto___46955__$1;
each_fixture_fn.call(null,((function (seq__46589,chunk__46590,count__46592,i__46593,t_46956,temp__5720__auto___46955__$1,v,seq__46589__$1,temp__5720__auto__,each_fixture_fn,G__46564,G__46564__$1,env,once_fixtures,each_fixtures,vec__46560,ns,vars__$1){
return (function (){
return cljs.test.run_block.call(null,cljs.test.test_var_block_STAR_.call(null,v,cljs.test.disable_async.call(null,t_46956)));
});})(seq__46589,chunk__46590,count__46592,i__46593,t_46956,temp__5720__auto___46955__$1,v,seq__46589__$1,temp__5720__auto__,each_fixture_fn,G__46564,G__46564__$1,env,once_fixtures,each_fixtures,vec__46560,ns,vars__$1))
);
} else {
}


var G__46964 = cljs.core.next.call(null,seq__46589__$1);
var G__46965 = null;
var G__46966 = (0);
var G__46967 = (0);
seq__46589 = G__46964;
chunk__46590 = G__46965;
count__46592 = G__46966;
i__46593 = G__46967;
continue;
}
} else {
return null;
}
}
break;
}
}));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46564__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,(function (p1__46555_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46555_SHARP_));
}),vars)));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__46717 = shadow.test.env.get_test_ns_info.call(null,ns);
var map__46717__$1 = (((((!((map__46717 == null))))?(((((map__46717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46717):map__46717);
var test_ns = map__46717__$1;
var vars = cljs.core.get.call(null,map__46717__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.call(null,["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join(''));
})], null);
} else {
return shadow.test.test_vars_grouped_block.call(null,vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__46724,vars){
var map__46728 = p__46724;
var map__46728__$1 = (((((!((map__46728 == null))))?(((((map__46728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46728.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46728):map__46728);
var env = map__46728__$1;
var report_fn = cljs.core.get.call(null,map__46728__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_.call(null,cljs.core.assoc.call(null,env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__46774_46985 = cljs.core.seq.call(null,shadow.test.env.get_tests.call(null));
var chunk__46776_46986 = null;
var count__46777_46987 = (0);
var i__46778_46988 = (0);
while(true){
if((i__46778_46988 < count__46777_46987)){
var vec__46808_46991 = cljs.core._nth(chunk__46776_46986,i__46778_46988);
var test_ns_46992 = cljs.core.nth.call(null,vec__46808_46991,(0),null);
var ns_info_46993 = cljs.core.nth.call(null,vec__46808_46991,(1),null);
var map__46811_46996 = ns_info_46993;
var map__46811_46997__$1 = (((((!((map__46811_46996 == null))))?(((((map__46811_46996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46811_46996.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46811_46996):map__46811_46996);
var fixtures_46998 = cljs.core.get.call(null,map__46811_46997__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5720__auto___47000 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_46998);
if(cljs.core.truth_(temp__5720__auto___47000)){
var fix_47001 = temp__5720__auto___47000;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,test_ns_46992,fix_47001);
} else {
}

var temp__5720__auto___47002 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_46998);
if(cljs.core.truth_(temp__5720__auto___47002)){
var fix_47004 = temp__5720__auto___47002;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,test_ns_46992,fix_47004);
} else {
}


var G__47005 = seq__46774_46985;
var G__47006 = chunk__46776_46986;
var G__47007 = count__46777_46987;
var G__47008 = (i__46778_46988 + (1));
seq__46774_46985 = G__47005;
chunk__46776_46986 = G__47006;
count__46777_46987 = G__47007;
i__46778_46988 = G__47008;
continue;
} else {
var temp__5720__auto___47011 = cljs.core.seq.call(null,seq__46774_46985);
if(temp__5720__auto___47011){
var seq__46774_47012__$1 = temp__5720__auto___47011;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46774_47012__$1)){
var c__4556__auto___47013 = cljs.core.chunk_first.call(null,seq__46774_47012__$1);
var G__47014 = cljs.core.chunk_rest.call(null,seq__46774_47012__$1);
var G__47015 = c__4556__auto___47013;
var G__47016 = cljs.core.count.call(null,c__4556__auto___47013);
var G__47017 = (0);
seq__46774_46985 = G__47014;
chunk__46776_46986 = G__47015;
count__46777_46987 = G__47016;
i__46778_46988 = G__47017;
continue;
} else {
var vec__46826_47018 = cljs.core.first.call(null,seq__46774_47012__$1);
var test_ns_47019 = cljs.core.nth.call(null,vec__46826_47018,(0),null);
var ns_info_47020 = cljs.core.nth.call(null,vec__46826_47018,(1),null);
var map__46829_47023 = ns_info_47020;
var map__46829_47024__$1 = (((((!((map__46829_47023 == null))))?(((((map__46829_47023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46829_47023.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46829_47023):map__46829_47023);
var fixtures_47025 = cljs.core.get.call(null,map__46829_47024__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5720__auto___47028__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_47025);
if(cljs.core.truth_(temp__5720__auto___47028__$1)){
var fix_47029 = temp__5720__auto___47028__$1;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,test_ns_47019,fix_47029);
} else {
}

var temp__5720__auto___47030__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_47025);
if(cljs.core.truth_(temp__5720__auto___47030__$1)){
var fix_47031 = temp__5720__auto___47030__$1;
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,test_ns_47019,fix_47031);
} else {
}


var G__47033 = cljs.core.next.call(null,seq__46774_47012__$1);
var G__47034 = null;
var G__47035 = (0);
var G__47036 = (0);
seq__46774_46985 = G__47033;
chunk__46776_46986 = G__47034;
count__46777_46987 = G__47035;
i__46778_46988 = G__47036;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count.call(null,vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.map.call(null,(function (p1__46721_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46721_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_.call(null,block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.call(null,block,(function (){
var map__46846 = cljs.test.get_current_env.call(null);
var map__46846__$1 = (((((!((map__46846 == null))))?(((((map__46846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46846.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46846):map__46846);
var env = map__46846__$1;
var report_fn = cljs.core.get.call(null,map__46846__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.call(null,map__46846__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.call(null,report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.call(null,report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__46856 = arguments.length;
switch (G__46856) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.call(null,cljs.test.empty_env.call(null),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__46860 = arguments.length;
switch (G__46860) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.call(null,cljs.test.empty_env.call(null),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__46861 = shadow.test.env.get_test_ns_info.call(null,ns);
var map__46861__$1 = (((((!((map__46861 == null))))?(((((map__46861.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46861.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46861):map__46861);
var vars = cljs.core.get.call(null,map__46861__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__46865 = arguments.length;
switch (G__46865) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.call(null,cljs.test.empty_env.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.call(null,env,shadow.test.env.get_test_namespaces.call(null));
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_.call(null,namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.call(null,(function (p1__46863_SHARP_){
return cljs.core.contains_QMARK_.call(null,namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__46863_SHARP_)));
}),shadow.test.env.get_test_vars.call(null));
return cljs.test.run_block.call(null,shadow.test.finish_test_run.call(null,cljs.core.into.call(null,shadow.test.prepare_test_run.call(null,env,vars),shadow.test.test_vars_grouped_block.call(null,vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__46902 = arguments.length;
switch (G__46902) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.call(null,cljs.test.empty_env.call(null),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.call(null,env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.call(null,env,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,(function (p1__46900_SHARP_){
var or__4126__auto__ = (re == null);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return cljs.core.re_matches.call(null,re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__46900_SHARP_));
}
}),shadow.test.env.get_test_namespaces.call(null))));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
