goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47201 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47201(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47203 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47203(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom(el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__45882 = arguments.length;
switch (G__45882) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__45889 = arguments.length;
switch (G__45889) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__45897 = arguments.length;
switch (G__45897) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__45909 = arguments.length;
switch (G__45909) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__45923 = arguments.length;
switch (G__45923) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__45943 = arguments.length;
switch (G__45943) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e45955){if((e45955 instanceof Object)){
var e = e45955;
return console.log("didnt support attachEvent",el,e);
} else {
throw e45955;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__45963 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__45964 = null;
var count__45965 = (0);
var i__45966 = (0);
while(true){
if((i__45966 < count__45965)){
var el = cljs.core._nth(chunk__45964,i__45966);
var handler_47271__$1 = ((function (seq__45963,chunk__45964,count__45965,i__45966,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__45963,chunk__45964,count__45965,i__45966,el))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_47271__$1);


var G__47272 = seq__45963;
var G__47273 = chunk__45964;
var G__47274 = count__45965;
var G__47275 = (i__45966 + (1));
seq__45963 = G__47272;
chunk__45964 = G__47273;
count__45965 = G__47274;
i__45966 = G__47275;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__45963);
if(temp__5720__auto__){
var seq__45963__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45963__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__45963__$1);
var G__47277 = cljs.core.chunk_rest.call(null,seq__45963__$1);
var G__47278 = c__4556__auto__;
var G__47279 = cljs.core.count.call(null,c__4556__auto__);
var G__47280 = (0);
seq__45963 = G__47277;
chunk__45964 = G__47278;
count__45965 = G__47279;
i__45966 = G__47280;
continue;
} else {
var el = cljs.core.first.call(null,seq__45963__$1);
var handler_47282__$1 = ((function (seq__45963,chunk__45964,count__45965,i__45966,el,seq__45963__$1,temp__5720__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__45963,chunk__45964,count__45965,i__45966,el,seq__45963__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name.call(null,ev),handler_47282__$1);


var G__47285 = cljs.core.next.call(null,seq__45963__$1);
var G__47286 = null;
var G__47287 = (0);
var G__47288 = (0);
seq__45963 = G__47285;
chunk__45964 = G__47286;
count__45965 = G__47287;
i__45966 = G__47288;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__45994 = arguments.length;
switch (G__45994) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46006 = cljs.core.seq.call(null,events);
var chunk__46007 = null;
var count__46008 = (0);
var i__46009 = (0);
while(true){
if((i__46009 < count__46008)){
var vec__46021 = cljs.core._nth(chunk__46007,i__46009);
var k = cljs.core.nth.call(null,vec__46021,(0),null);
var v = cljs.core.nth.call(null,vec__46021,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47297 = seq__46006;
var G__47298 = chunk__46007;
var G__47299 = count__46008;
var G__47300 = (i__46009 + (1));
seq__46006 = G__47297;
chunk__46007 = G__47298;
count__46008 = G__47299;
i__46009 = G__47300;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46006);
if(temp__5720__auto__){
var seq__46006__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46006__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46006__$1);
var G__47305 = cljs.core.chunk_rest.call(null,seq__46006__$1);
var G__47306 = c__4556__auto__;
var G__47307 = cljs.core.count.call(null,c__4556__auto__);
var G__47308 = (0);
seq__46006 = G__47305;
chunk__46007 = G__47306;
count__46008 = G__47307;
i__46009 = G__47308;
continue;
} else {
var vec__46028 = cljs.core.first.call(null,seq__46006__$1);
var k = cljs.core.nth.call(null,vec__46028,(0),null);
var v = cljs.core.nth.call(null,vec__46028,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47311 = cljs.core.next.call(null,seq__46006__$1);
var G__47312 = null;
var G__47313 = (0);
var G__47314 = (0);
seq__46006 = G__47311;
chunk__46007 = G__47312;
count__46008 = G__47313;
i__46009 = G__47314;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__46035 = cljs.core.seq.call(null,styles);
var chunk__46036 = null;
var count__46037 = (0);
var i__46038 = (0);
while(true){
if((i__46038 < count__46037)){
var vec__46057 = cljs.core._nth(chunk__46036,i__46038);
var k = cljs.core.nth.call(null,vec__46057,(0),null);
var v = cljs.core.nth.call(null,vec__46057,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47317 = seq__46035;
var G__47318 = chunk__46036;
var G__47319 = count__46037;
var G__47320 = (i__46038 + (1));
seq__46035 = G__47317;
chunk__46036 = G__47318;
count__46037 = G__47319;
i__46038 = G__47320;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46035);
if(temp__5720__auto__){
var seq__46035__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46035__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46035__$1);
var G__47322 = cljs.core.chunk_rest.call(null,seq__46035__$1);
var G__47323 = c__4556__auto__;
var G__47324 = cljs.core.count.call(null,c__4556__auto__);
var G__47325 = (0);
seq__46035 = G__47322;
chunk__46036 = G__47323;
count__46037 = G__47324;
i__46038 = G__47325;
continue;
} else {
var vec__46065 = cljs.core.first.call(null,seq__46035__$1);
var k = cljs.core.nth.call(null,vec__46065,(0),null);
var v = cljs.core.nth.call(null,vec__46065,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47327 = cljs.core.next.call(null,seq__46035__$1);
var G__47328 = null;
var G__47329 = (0);
var G__47330 = (0);
seq__46035 = G__47327;
chunk__46036 = G__47328;
count__46037 = G__47329;
i__46038 = G__47330;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46075_47332 = key;
var G__46075_47333__$1 = (((G__46075_47332 instanceof cljs.core.Keyword))?G__46075_47332.fqn:null);
switch (G__46075_47333__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47342 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_47342,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_47342,"aria-");
}
})())){
el.setAttribute(ks_47342,value);
} else {
(el[ks_47342] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46110){
var map__46112 = p__46110;
var map__46112__$1 = (((((!((map__46112 == null))))?(((((map__46112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46112):map__46112);
var props = map__46112__$1;
var class$ = cljs.core.get.call(null,map__46112__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46115 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46115,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46115,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46115,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__46120 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__46120,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46120;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46125 = arguments.length;
switch (G__46125) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46130){
var vec__46132 = p__46130;
var seq__46133 = cljs.core.seq.call(null,vec__46132);
var first__46134 = cljs.core.first.call(null,seq__46133);
var seq__46133__$1 = cljs.core.next.call(null,seq__46133);
var nn = first__46134;
var first__46134__$1 = cljs.core.first.call(null,seq__46133__$1);
var seq__46133__$2 = cljs.core.next.call(null,seq__46133__$1);
var np = first__46134__$1;
var nc = seq__46133__$2;
var node = vec__46132;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46138 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__46138,(0),null);
var node_children = cljs.core.nth.call(null,vec__46138,(1),null);
var seq__46141_47377 = cljs.core.seq.call(null,node_children);
var chunk__46142_47378 = null;
var count__46143_47379 = (0);
var i__46144_47380 = (0);
while(true){
if((i__46144_47380 < count__46143_47379)){
var child_struct_47381 = cljs.core._nth(chunk__46142_47378,i__46144_47380);
var children_47382 = shadow.dom.dom_node.call(null,child_struct_47381);
if(cljs.core.seq_QMARK_.call(null,children_47382)){
var seq__46199_47383 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47382));
var chunk__46201_47384 = null;
var count__46202_47385 = (0);
var i__46203_47386 = (0);
while(true){
if((i__46203_47386 < count__46202_47385)){
var child_47389 = cljs.core._nth(chunk__46201_47384,i__46203_47386);
if(cljs.core.truth_(child_47389)){
shadow.dom.append.call(null,node,child_47389);


var G__47391 = seq__46199_47383;
var G__47392 = chunk__46201_47384;
var G__47393 = count__46202_47385;
var G__47394 = (i__46203_47386 + (1));
seq__46199_47383 = G__47391;
chunk__46201_47384 = G__47392;
count__46202_47385 = G__47393;
i__46203_47386 = G__47394;
continue;
} else {
var G__47395 = seq__46199_47383;
var G__47396 = chunk__46201_47384;
var G__47397 = count__46202_47385;
var G__47398 = (i__46203_47386 + (1));
seq__46199_47383 = G__47395;
chunk__46201_47384 = G__47396;
count__46202_47385 = G__47397;
i__46203_47386 = G__47398;
continue;
}
} else {
var temp__5720__auto___47399 = cljs.core.seq.call(null,seq__46199_47383);
if(temp__5720__auto___47399){
var seq__46199_47400__$1 = temp__5720__auto___47399;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46199_47400__$1)){
var c__4556__auto___47401 = cljs.core.chunk_first.call(null,seq__46199_47400__$1);
var G__47402 = cljs.core.chunk_rest.call(null,seq__46199_47400__$1);
var G__47403 = c__4556__auto___47401;
var G__47404 = cljs.core.count.call(null,c__4556__auto___47401);
var G__47405 = (0);
seq__46199_47383 = G__47402;
chunk__46201_47384 = G__47403;
count__46202_47385 = G__47404;
i__46203_47386 = G__47405;
continue;
} else {
var child_47407 = cljs.core.first.call(null,seq__46199_47400__$1);
if(cljs.core.truth_(child_47407)){
shadow.dom.append.call(null,node,child_47407);


var G__47408 = cljs.core.next.call(null,seq__46199_47400__$1);
var G__47409 = null;
var G__47410 = (0);
var G__47411 = (0);
seq__46199_47383 = G__47408;
chunk__46201_47384 = G__47409;
count__46202_47385 = G__47410;
i__46203_47386 = G__47411;
continue;
} else {
var G__47412 = cljs.core.next.call(null,seq__46199_47400__$1);
var G__47413 = null;
var G__47414 = (0);
var G__47415 = (0);
seq__46199_47383 = G__47412;
chunk__46201_47384 = G__47413;
count__46202_47385 = G__47414;
i__46203_47386 = G__47415;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47382);
}


var G__47416 = seq__46141_47377;
var G__47417 = chunk__46142_47378;
var G__47418 = count__46143_47379;
var G__47419 = (i__46144_47380 + (1));
seq__46141_47377 = G__47416;
chunk__46142_47378 = G__47417;
count__46143_47379 = G__47418;
i__46144_47380 = G__47419;
continue;
} else {
var temp__5720__auto___47421 = cljs.core.seq.call(null,seq__46141_47377);
if(temp__5720__auto___47421){
var seq__46141_47422__$1 = temp__5720__auto___47421;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46141_47422__$1)){
var c__4556__auto___47423 = cljs.core.chunk_first.call(null,seq__46141_47422__$1);
var G__47424 = cljs.core.chunk_rest.call(null,seq__46141_47422__$1);
var G__47425 = c__4556__auto___47423;
var G__47426 = cljs.core.count.call(null,c__4556__auto___47423);
var G__47427 = (0);
seq__46141_47377 = G__47424;
chunk__46142_47378 = G__47425;
count__46143_47379 = G__47426;
i__46144_47380 = G__47427;
continue;
} else {
var child_struct_47429 = cljs.core.first.call(null,seq__46141_47422__$1);
var children_47431 = shadow.dom.dom_node.call(null,child_struct_47429);
if(cljs.core.seq_QMARK_.call(null,children_47431)){
var seq__46229_47432 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47431));
var chunk__46231_47433 = null;
var count__46232_47434 = (0);
var i__46233_47435 = (0);
while(true){
if((i__46233_47435 < count__46232_47434)){
var child_47440 = cljs.core._nth(chunk__46231_47433,i__46233_47435);
if(cljs.core.truth_(child_47440)){
shadow.dom.append.call(null,node,child_47440);


var G__47442 = seq__46229_47432;
var G__47443 = chunk__46231_47433;
var G__47444 = count__46232_47434;
var G__47445 = (i__46233_47435 + (1));
seq__46229_47432 = G__47442;
chunk__46231_47433 = G__47443;
count__46232_47434 = G__47444;
i__46233_47435 = G__47445;
continue;
} else {
var G__47449 = seq__46229_47432;
var G__47450 = chunk__46231_47433;
var G__47451 = count__46232_47434;
var G__47452 = (i__46233_47435 + (1));
seq__46229_47432 = G__47449;
chunk__46231_47433 = G__47450;
count__46232_47434 = G__47451;
i__46233_47435 = G__47452;
continue;
}
} else {
var temp__5720__auto___47453__$1 = cljs.core.seq.call(null,seq__46229_47432);
if(temp__5720__auto___47453__$1){
var seq__46229_47455__$1 = temp__5720__auto___47453__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46229_47455__$1)){
var c__4556__auto___47456 = cljs.core.chunk_first.call(null,seq__46229_47455__$1);
var G__47457 = cljs.core.chunk_rest.call(null,seq__46229_47455__$1);
var G__47458 = c__4556__auto___47456;
var G__47459 = cljs.core.count.call(null,c__4556__auto___47456);
var G__47460 = (0);
seq__46229_47432 = G__47457;
chunk__46231_47433 = G__47458;
count__46232_47434 = G__47459;
i__46233_47435 = G__47460;
continue;
} else {
var child_47461 = cljs.core.first.call(null,seq__46229_47455__$1);
if(cljs.core.truth_(child_47461)){
shadow.dom.append.call(null,node,child_47461);


var G__47462 = cljs.core.next.call(null,seq__46229_47455__$1);
var G__47463 = null;
var G__47464 = (0);
var G__47465 = (0);
seq__46229_47432 = G__47462;
chunk__46231_47433 = G__47463;
count__46232_47434 = G__47464;
i__46233_47435 = G__47465;
continue;
} else {
var G__47466 = cljs.core.next.call(null,seq__46229_47455__$1);
var G__47467 = null;
var G__47468 = (0);
var G__47469 = (0);
seq__46229_47432 = G__47466;
chunk__46231_47433 = G__47467;
count__46232_47434 = G__47468;
i__46233_47435 = G__47469;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47431);
}


var G__47472 = cljs.core.next.call(null,seq__46141_47422__$1);
var G__47473 = null;
var G__47474 = (0);
var G__47475 = (0);
seq__46141_47377 = G__47472;
chunk__46142_47378 = G__47473;
count__46143_47379 = G__47474;
i__46144_47380 = G__47475;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46296 = cljs.core.seq.call(null,node);
var chunk__46297 = null;
var count__46298 = (0);
var i__46299 = (0);
while(true){
if((i__46299 < count__46298)){
var n = cljs.core._nth(chunk__46297,i__46299);
shadow.dom.remove.call(null,n);


var G__47487 = seq__46296;
var G__47488 = chunk__46297;
var G__47489 = count__46298;
var G__47490 = (i__46299 + (1));
seq__46296 = G__47487;
chunk__46297 = G__47488;
count__46298 = G__47489;
i__46299 = G__47490;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46296);
if(temp__5720__auto__){
var seq__46296__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46296__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46296__$1);
var G__47495 = cljs.core.chunk_rest.call(null,seq__46296__$1);
var G__47496 = c__4556__auto__;
var G__47497 = cljs.core.count.call(null,c__4556__auto__);
var G__47498 = (0);
seq__46296 = G__47495;
chunk__46297 = G__47496;
count__46298 = G__47497;
i__46299 = G__47498;
continue;
} else {
var n = cljs.core.first.call(null,seq__46296__$1);
shadow.dom.remove.call(null,n);


var G__47503 = cljs.core.next.call(null,seq__46296__$1);
var G__47504 = null;
var G__47505 = (0);
var G__47506 = (0);
seq__46296 = G__47503;
chunk__46297 = G__47504;
count__46298 = G__47505;
i__46299 = G__47506;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46324 = arguments.length;
switch (G__46324) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node.call(null,el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46345 = arguments.length;
switch (G__46345) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node.call(null,el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46373 = arguments.length;
switch (G__46373) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node.call(null,node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47571 = arguments.length;
var i__4737__auto___47572 = (0);
while(true){
if((i__4737__auto___47572 < len__4736__auto___47571)){
args__4742__auto__.push((arguments[i__4737__auto___47572]));

var G__47574 = (i__4737__auto___47572 + (1));
i__4737__auto___47572 = G__47574;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46403_47577 = cljs.core.seq.call(null,nodes);
var chunk__46404_47578 = null;
var count__46405_47579 = (0);
var i__46406_47580 = (0);
while(true){
if((i__46406_47580 < count__46405_47579)){
var node_47581 = cljs.core._nth(chunk__46404_47578,i__46406_47580);
fragment.appendChild(shadow.dom._to_dom(node_47581));


var G__47584 = seq__46403_47577;
var G__47585 = chunk__46404_47578;
var G__47586 = count__46405_47579;
var G__47587 = (i__46406_47580 + (1));
seq__46403_47577 = G__47584;
chunk__46404_47578 = G__47585;
count__46405_47579 = G__47586;
i__46406_47580 = G__47587;
continue;
} else {
var temp__5720__auto___47588 = cljs.core.seq.call(null,seq__46403_47577);
if(temp__5720__auto___47588){
var seq__46403_47589__$1 = temp__5720__auto___47588;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46403_47589__$1)){
var c__4556__auto___47590 = cljs.core.chunk_first.call(null,seq__46403_47589__$1);
var G__47591 = cljs.core.chunk_rest.call(null,seq__46403_47589__$1);
var G__47592 = c__4556__auto___47590;
var G__47593 = cljs.core.count.call(null,c__4556__auto___47590);
var G__47594 = (0);
seq__46403_47577 = G__47591;
chunk__46404_47578 = G__47592;
count__46405_47579 = G__47593;
i__46406_47580 = G__47594;
continue;
} else {
var node_47595 = cljs.core.first.call(null,seq__46403_47589__$1);
fragment.appendChild(shadow.dom._to_dom(node_47595));


var G__47596 = cljs.core.next.call(null,seq__46403_47589__$1);
var G__47597 = null;
var G__47598 = (0);
var G__47599 = (0);
seq__46403_47577 = G__47596;
chunk__46404_47578 = G__47597;
count__46405_47579 = G__47598;
i__46406_47580 = G__47599;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46398){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46398));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46424_47606 = cljs.core.seq.call(null,scripts);
var chunk__46425_47607 = null;
var count__46426_47608 = (0);
var i__46427_47609 = (0);
while(true){
if((i__46427_47609 < count__46426_47608)){
var vec__46438_47610 = cljs.core._nth(chunk__46425_47607,i__46427_47609);
var script_tag_47611 = cljs.core.nth.call(null,vec__46438_47610,(0),null);
var script_body_47612 = cljs.core.nth.call(null,vec__46438_47610,(1),null);
eval(script_body_47612);


var G__47615 = seq__46424_47606;
var G__47616 = chunk__46425_47607;
var G__47617 = count__46426_47608;
var G__47618 = (i__46427_47609 + (1));
seq__46424_47606 = G__47615;
chunk__46425_47607 = G__47616;
count__46426_47608 = G__47617;
i__46427_47609 = G__47618;
continue;
} else {
var temp__5720__auto___47620 = cljs.core.seq.call(null,seq__46424_47606);
if(temp__5720__auto___47620){
var seq__46424_47621__$1 = temp__5720__auto___47620;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46424_47621__$1)){
var c__4556__auto___47622 = cljs.core.chunk_first.call(null,seq__46424_47621__$1);
var G__47623 = cljs.core.chunk_rest.call(null,seq__46424_47621__$1);
var G__47624 = c__4556__auto___47622;
var G__47625 = cljs.core.count.call(null,c__4556__auto___47622);
var G__47626 = (0);
seq__46424_47606 = G__47623;
chunk__46425_47607 = G__47624;
count__46426_47608 = G__47625;
i__46427_47609 = G__47626;
continue;
} else {
var vec__46442_47630 = cljs.core.first.call(null,seq__46424_47621__$1);
var script_tag_47631 = cljs.core.nth.call(null,vec__46442_47630,(0),null);
var script_body_47632 = cljs.core.nth.call(null,vec__46442_47630,(1),null);
eval(script_body_47632);


var G__47635 = cljs.core.next.call(null,seq__46424_47621__$1);
var G__47636 = null;
var G__47637 = (0);
var G__47638 = (0);
seq__46424_47606 = G__47635;
chunk__46425_47607 = G__47636;
count__46426_47608 = G__47637;
i__46427_47609 = G__47638;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,(function (s__$1,p__46446){
var vec__46447 = p__46446;
var script_tag = cljs.core.nth.call(null,vec__46447,(0),null);
var script_body = cljs.core.nth.call(null,vec__46447,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46459 = arguments.length;
switch (G__46459) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__46483 = cljs.core.seq.call(null,style_keys);
var chunk__46484 = null;
var count__46485 = (0);
var i__46486 = (0);
while(true){
if((i__46486 < count__46485)){
var it = cljs.core._nth(chunk__46484,i__46486);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47667 = seq__46483;
var G__47668 = chunk__46484;
var G__47669 = count__46485;
var G__47670 = (i__46486 + (1));
seq__46483 = G__47667;
chunk__46484 = G__47668;
count__46485 = G__47669;
i__46486 = G__47670;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46483);
if(temp__5720__auto__){
var seq__46483__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46483__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__46483__$1);
var G__47674 = cljs.core.chunk_rest.call(null,seq__46483__$1);
var G__47675 = c__4556__auto__;
var G__47676 = cljs.core.count.call(null,c__4556__auto__);
var G__47677 = (0);
seq__46483 = G__47674;
chunk__46484 = G__47675;
count__46485 = G__47676;
i__46486 = G__47677;
continue;
} else {
var it = cljs.core.first.call(null,seq__46483__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47681 = cljs.core.next.call(null,seq__46483__$1);
var G__47682 = null;
var G__47683 = (0);
var G__47684 = (0);
seq__46483 = G__47681;
chunk__46484 = G__47682;
count__46485 = G__47683;
i__46486 = G__47684;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46515,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46525 = k46515;
var G__46525__$1 = (((G__46525 instanceof cljs.core.Keyword))?G__46525.fqn:null);
switch (G__46525__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46515,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__46532){
var vec__46537 = p__46532;
var k__4403__auto__ = cljs.core.nth.call(null,vec__46537,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__46537,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46514){
var self__ = this;
var G__46514__$1 = this;
return (new cljs.core.RecordIter((0),G__46514__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46516,other46517){
var self__ = this;
var this46516__$1 = this;
return (((!((other46517 == null)))) && ((this46516__$1.constructor === other46517.constructor)) && (cljs.core._EQ_.call(null,this46516__$1.x,other46517.x)) && (cljs.core._EQ_.call(null,this46516__$1.y,other46517.y)) && (cljs.core._EQ_.call(null,this46516__$1.__extmap,other46517.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46514){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46586 = cljs.core.keyword_identical_QMARK_;
var expr__46587 = k__4388__auto__;
if(cljs.core.truth_(pred__46586.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46587))){
return (new shadow.dom.Coordinate(G__46514,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46586.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46587))){
return (new shadow.dom.Coordinate(self__.x,G__46514,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__46514),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46514){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46514,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46520){
var extmap__4419__auto__ = (function (){var G__46638 = cljs.core.dissoc.call(null,G__46520,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__46520)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46638);
} else {
return G__46638;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46520),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46520),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46662,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46678 = k46662;
var G__46678__$1 = (((G__46678 instanceof cljs.core.Keyword))?G__46678.fqn:null);
switch (G__46678__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k46662,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__46680){
var vec__46683 = p__46680;
var k__4403__auto__ = cljs.core.nth.call(null,vec__46683,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__46683,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46661){
var self__ = this;
var G__46661__$1 = this;
return (new cljs.core.RecordIter((0),G__46661__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46663,other46664){
var self__ = this;
var this46663__$1 = this;
return (((!((other46664 == null)))) && ((this46663__$1.constructor === other46664.constructor)) && (cljs.core._EQ_.call(null,this46663__$1.w,other46664.w)) && (cljs.core._EQ_.call(null,this46663__$1.h,other46664.h)) && (cljs.core._EQ_.call(null,this46663__$1.__extmap,other46664.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta(cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46661){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46740 = cljs.core.keyword_identical_QMARK_;
var expr__46741 = k__4388__auto__;
if(cljs.core.truth_(pred__46740.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46741))){
return (new shadow.dom.Size(G__46661,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__46740.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46741))){
return (new shadow.dom.Size(self__.w,G__46661,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__46661),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46661){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46661,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46666){
var extmap__4419__auto__ = (function (){var G__46796 = cljs.core.dissoc.call(null,G__46666,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__46666)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__46796);
} else {
return G__46796;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46666),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46666),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47842 = (i + (1));
var G__47843 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__47842;
ret = G__47843;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__46838){
var vec__46841 = p__46838;
var k = cljs.core.nth.call(null,vec__46841,(0),null);
var v = cljs.core.nth.call(null,vec__46841,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46847 = arguments.length;
switch (G__46847) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47873 = ps;
var G__47874 = (i + (1));
el__$1 = G__47873;
i = G__47874;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,(function (){
return shadow.dom.parents.call(null,parent);
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46883 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46883,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46883,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46883,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46886_47894 = cljs.core.seq.call(null,props);
var chunk__46887_47895 = null;
var count__46888_47896 = (0);
var i__46889_47897 = (0);
while(true){
if((i__46889_47897 < count__46888_47896)){
var vec__46924_47899 = cljs.core._nth(chunk__46887_47895,i__46889_47897);
var k_47900 = cljs.core.nth.call(null,vec__46924_47899,(0),null);
var v_47901 = cljs.core.nth.call(null,vec__46924_47899,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace.call(null,k_47900);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47900),v_47901);


var G__47908 = seq__46886_47894;
var G__47909 = chunk__46887_47895;
var G__47910 = count__46888_47896;
var G__47911 = (i__46889_47897 + (1));
seq__46886_47894 = G__47908;
chunk__46887_47895 = G__47909;
count__46888_47896 = G__47910;
i__46889_47897 = G__47911;
continue;
} else {
var temp__5720__auto___47912 = cljs.core.seq.call(null,seq__46886_47894);
if(temp__5720__auto___47912){
var seq__46886_47914__$1 = temp__5720__auto___47912;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46886_47914__$1)){
var c__4556__auto___47916 = cljs.core.chunk_first.call(null,seq__46886_47914__$1);
var G__47917 = cljs.core.chunk_rest.call(null,seq__46886_47914__$1);
var G__47918 = c__4556__auto___47916;
var G__47919 = cljs.core.count.call(null,c__4556__auto___47916);
var G__47920 = (0);
seq__46886_47894 = G__47917;
chunk__46887_47895 = G__47918;
count__46888_47896 = G__47919;
i__46889_47897 = G__47920;
continue;
} else {
var vec__46928_47922 = cljs.core.first.call(null,seq__46886_47914__$1);
var k_47923 = cljs.core.nth.call(null,vec__46928_47922,(0),null);
var v_47924 = cljs.core.nth.call(null,vec__46928_47922,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace.call(null,k_47923);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47923),v_47924);


var G__47929 = cljs.core.next.call(null,seq__46886_47914__$1);
var G__47930 = null;
var G__47931 = (0);
var G__47932 = (0);
seq__46886_47894 = G__47929;
chunk__46887_47895 = G__47930;
count__46888_47896 = G__47931;
i__46889_47897 = G__47932;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg(el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46938 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__46938,(0),null);
var node_children = cljs.core.nth.call(null,vec__46938,(1),null);
var seq__46941_47944 = cljs.core.seq.call(null,node_children);
var chunk__46943_47945 = null;
var count__46944_47946 = (0);
var i__46945_47947 = (0);
while(true){
if((i__46945_47947 < count__46944_47946)){
var child_struct_47948 = cljs.core._nth(chunk__46943_47945,i__46945_47947);
if((!((child_struct_47948 == null)))){
if(typeof child_struct_47948 === 'string'){
var text_47949 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47949),child_struct_47948].join(''));
} else {
var children_47951 = shadow.dom.svg_node.call(null,child_struct_47948);
if(cljs.core.seq_QMARK_.call(null,children_47951)){
var seq__47075_47952 = cljs.core.seq.call(null,children_47951);
var chunk__47077_47953 = null;
var count__47078_47954 = (0);
var i__47079_47955 = (0);
while(true){
if((i__47079_47955 < count__47078_47954)){
var child_47957 = cljs.core._nth(chunk__47077_47953,i__47079_47955);
if(cljs.core.truth_(child_47957)){
node.appendChild(child_47957);


var G__47959 = seq__47075_47952;
var G__47960 = chunk__47077_47953;
var G__47961 = count__47078_47954;
var G__47962 = (i__47079_47955 + (1));
seq__47075_47952 = G__47959;
chunk__47077_47953 = G__47960;
count__47078_47954 = G__47961;
i__47079_47955 = G__47962;
continue;
} else {
var G__47964 = seq__47075_47952;
var G__47965 = chunk__47077_47953;
var G__47966 = count__47078_47954;
var G__47967 = (i__47079_47955 + (1));
seq__47075_47952 = G__47964;
chunk__47077_47953 = G__47965;
count__47078_47954 = G__47966;
i__47079_47955 = G__47967;
continue;
}
} else {
var temp__5720__auto___47969 = cljs.core.seq.call(null,seq__47075_47952);
if(temp__5720__auto___47969){
var seq__47075_47970__$1 = temp__5720__auto___47969;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47075_47970__$1)){
var c__4556__auto___47971 = cljs.core.chunk_first.call(null,seq__47075_47970__$1);
var G__47972 = cljs.core.chunk_rest.call(null,seq__47075_47970__$1);
var G__47973 = c__4556__auto___47971;
var G__47974 = cljs.core.count.call(null,c__4556__auto___47971);
var G__47975 = (0);
seq__47075_47952 = G__47972;
chunk__47077_47953 = G__47973;
count__47078_47954 = G__47974;
i__47079_47955 = G__47975;
continue;
} else {
var child_47980 = cljs.core.first.call(null,seq__47075_47970__$1);
if(cljs.core.truth_(child_47980)){
node.appendChild(child_47980);


var G__47983 = cljs.core.next.call(null,seq__47075_47970__$1);
var G__47984 = null;
var G__47985 = (0);
var G__47986 = (0);
seq__47075_47952 = G__47983;
chunk__47077_47953 = G__47984;
count__47078_47954 = G__47985;
i__47079_47955 = G__47986;
continue;
} else {
var G__47991 = cljs.core.next.call(null,seq__47075_47970__$1);
var G__47992 = null;
var G__47993 = (0);
var G__47994 = (0);
seq__47075_47952 = G__47991;
chunk__47077_47953 = G__47992;
count__47078_47954 = G__47993;
i__47079_47955 = G__47994;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47951);
}
}


var G__47998 = seq__46941_47944;
var G__47999 = chunk__46943_47945;
var G__48000 = count__46944_47946;
var G__48001 = (i__46945_47947 + (1));
seq__46941_47944 = G__47998;
chunk__46943_47945 = G__47999;
count__46944_47946 = G__48000;
i__46945_47947 = G__48001;
continue;
} else {
var G__48002 = seq__46941_47944;
var G__48003 = chunk__46943_47945;
var G__48004 = count__46944_47946;
var G__48005 = (i__46945_47947 + (1));
seq__46941_47944 = G__48002;
chunk__46943_47945 = G__48003;
count__46944_47946 = G__48004;
i__46945_47947 = G__48005;
continue;
}
} else {
var temp__5720__auto___48007 = cljs.core.seq.call(null,seq__46941_47944);
if(temp__5720__auto___48007){
var seq__46941_48008__$1 = temp__5720__auto___48007;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46941_48008__$1)){
var c__4556__auto___48010 = cljs.core.chunk_first.call(null,seq__46941_48008__$1);
var G__48011 = cljs.core.chunk_rest.call(null,seq__46941_48008__$1);
var G__48012 = c__4556__auto___48010;
var G__48013 = cljs.core.count.call(null,c__4556__auto___48010);
var G__48014 = (0);
seq__46941_47944 = G__48011;
chunk__46943_47945 = G__48012;
count__46944_47946 = G__48013;
i__46945_47947 = G__48014;
continue;
} else {
var child_struct_48015 = cljs.core.first.call(null,seq__46941_48008__$1);
if((!((child_struct_48015 == null)))){
if(typeof child_struct_48015 === 'string'){
var text_48019 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48019),child_struct_48015].join(''));
} else {
var children_48021 = shadow.dom.svg_node.call(null,child_struct_48015);
if(cljs.core.seq_QMARK_.call(null,children_48021)){
var seq__47094_48023 = cljs.core.seq.call(null,children_48021);
var chunk__47096_48024 = null;
var count__47097_48025 = (0);
var i__47098_48026 = (0);
while(true){
if((i__47098_48026 < count__47097_48025)){
var child_48027 = cljs.core._nth(chunk__47096_48024,i__47098_48026);
if(cljs.core.truth_(child_48027)){
node.appendChild(child_48027);


var G__48031 = seq__47094_48023;
var G__48032 = chunk__47096_48024;
var G__48033 = count__47097_48025;
var G__48034 = (i__47098_48026 + (1));
seq__47094_48023 = G__48031;
chunk__47096_48024 = G__48032;
count__47097_48025 = G__48033;
i__47098_48026 = G__48034;
continue;
} else {
var G__48035 = seq__47094_48023;
var G__48036 = chunk__47096_48024;
var G__48037 = count__47097_48025;
var G__48038 = (i__47098_48026 + (1));
seq__47094_48023 = G__48035;
chunk__47096_48024 = G__48036;
count__47097_48025 = G__48037;
i__47098_48026 = G__48038;
continue;
}
} else {
var temp__5720__auto___48039__$1 = cljs.core.seq.call(null,seq__47094_48023);
if(temp__5720__auto___48039__$1){
var seq__47094_48042__$1 = temp__5720__auto___48039__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47094_48042__$1)){
var c__4556__auto___48044 = cljs.core.chunk_first.call(null,seq__47094_48042__$1);
var G__48046 = cljs.core.chunk_rest.call(null,seq__47094_48042__$1);
var G__48047 = c__4556__auto___48044;
var G__48048 = cljs.core.count.call(null,c__4556__auto___48044);
var G__48049 = (0);
seq__47094_48023 = G__48046;
chunk__47096_48024 = G__48047;
count__47097_48025 = G__48048;
i__47098_48026 = G__48049;
continue;
} else {
var child_48054 = cljs.core.first.call(null,seq__47094_48042__$1);
if(cljs.core.truth_(child_48054)){
node.appendChild(child_48054);


var G__48057 = cljs.core.next.call(null,seq__47094_48042__$1);
var G__48058 = null;
var G__48059 = (0);
var G__48060 = (0);
seq__47094_48023 = G__48057;
chunk__47096_48024 = G__48058;
count__47097_48025 = G__48059;
i__47098_48026 = G__48060;
continue;
} else {
var G__48061 = cljs.core.next.call(null,seq__47094_48042__$1);
var G__48062 = null;
var G__48063 = (0);
var G__48064 = (0);
seq__47094_48023 = G__48061;
chunk__47096_48024 = G__48062;
count__47097_48025 = G__48063;
i__47098_48026 = G__48064;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48021);
}
}


var G__48066 = cljs.core.next.call(null,seq__46941_48008__$1);
var G__48067 = null;
var G__48068 = (0);
var G__48069 = (0);
seq__46941_47944 = G__48066;
chunk__46943_47945 = G__48067;
count__46944_47946 = G__48068;
i__46945_47947 = G__48069;
continue;
} else {
var G__48072 = cljs.core.next.call(null,seq__46941_48008__$1);
var G__48073 = null;
var G__48074 = (0);
var G__48075 = (0);
seq__46941_47944 = G__48072;
chunk__46943_47945 = G__48073;
count__46944_47946 = G__48074;
i__46945_47947 = G__48075;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48089 = arguments.length;
var i__4737__auto___48092 = (0);
while(true){
if((i__4737__auto___48092 < len__4736__auto___48089)){
args__4742__auto__.push((arguments[i__4737__auto___48092]));

var G__48093 = (i__4737__auto___48092 + (1));
i__4737__auto___48092 = G__48093;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47135){
var G__47136 = cljs.core.first.call(null,seq47135);
var seq47135__$1 = cljs.core.next.call(null,seq47135);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47136,seq47135__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47153 = arguments.length;
switch (G__47153) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__42092__auto___48130 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42093__auto__ = (function (){var switch__41854__auto__ = (function (state_47164){
var state_val_47165 = (state_47164[(1)]);
if((state_val_47165 === (1))){
var state_47164__$1 = state_47164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47164__$1,(2),once_or_cleanup);
} else {
if((state_val_47165 === (2))){
var inst_47161 = (state_47164[(2)]);
var inst_47162 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_47164__$1 = (function (){var statearr_47171 = state_47164;
(statearr_47171[(7)] = inst_47161);

return statearr_47171;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47164__$1,inst_47162);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__41855__auto__ = null;
var shadow$dom$state_machine__41855__auto____0 = (function (){
var statearr_47172 = [null,null,null,null,null,null,null,null];
(statearr_47172[(0)] = shadow$dom$state_machine__41855__auto__);

(statearr_47172[(1)] = (1));

return statearr_47172;
});
var shadow$dom$state_machine__41855__auto____1 = (function (state_47164){
while(true){
var ret_value__41856__auto__ = (function (){try{while(true){
var result__41857__auto__ = switch__41854__auto__(state_47164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41857__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41857__auto__;
}
break;
}
}catch (e47174){var ex__41858__auto__ = e47174;
var statearr_47175_48144 = state_47164;
(statearr_47175_48144[(2)] = ex__41858__auto__);


if(cljs.core.seq.call(null,(state_47164[(4)]))){
var statearr_47176_48149 = state_47164;
(statearr_47176_48149[(1)] = cljs.core.first.call(null,(state_47164[(4)])));

} else {
throw ex__41858__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41856__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48151 = state_47164;
state_47164 = G__48151;
continue;
} else {
return ret_value__41856__auto__;
}
break;
}
});
shadow$dom$state_machine__41855__auto__ = function(state_47164){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__41855__auto____0.call(this);
case 1:
return shadow$dom$state_machine__41855__auto____1.call(this,state_47164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__41855__auto____0;
shadow$dom$state_machine__41855__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__41855__auto____1;
return shadow$dom$state_machine__41855__auto__;
})()
})();
var state__42094__auto__ = (function (){var statearr_47180 = f__42093__auto__();
(statearr_47180[(6)] = c__42092__auto___48130);

return statearr_47180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42094__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
