goog.provide('shadow.xhr');
goog.require('cljs.core');
goog.require('goog.result');
goog.require('goog.result.SimpleResult');
goog.require('goog.labs.net.xhr');
goog.require('cljs.reader');
goog.require('goog.uri.utils');
goog.require('goog.json');
goog.require('shadow.object');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.xhr.result_chain = (function shadow$xhr$result_chain(res,handler){
return goog.result.chain(res,handler);
});
shadow.xhr.result_combine = (function shadow$xhr$result_combine(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51520 = arguments.length;
var i__4790__auto___51521 = (0);
while(true){
if((i__4790__auto___51521 < len__4789__auto___51520)){
args__4795__auto__.push((arguments[i__4790__auto___51521]));

var G__51523 = (i__4790__auto___51521 + (1));
i__4790__auto___51521 = G__51523;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic = (function (results){
return cljs.core.apply.call(null,goog.result.combine,results);
}));

(shadow.xhr.result_combine.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.xhr.result_combine.cljs$lang$applyTo = (function (seq51102){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq51102));
}));

shadow.xhr.result_wait_on_success = (function shadow$xhr$result_wait_on_success(res,callback){
return goog.result.waitOnSuccess(res,callback);
});
shadow.xhr.result_success_QMARK_ = (function shadow$xhr$result_success_QMARK_(res){
return cljs.core._EQ_.call(null,goog.result.Result.State.SUCCESS,res.getState());
});
shadow.xhr.result_value = (function shadow$xhr$result_value(res){
return res.getValue();
});
shadow.xhr.result_immediate = (function shadow$xhr$result_immediate(value){
return goog.result.successfulResult(value);
});
shadow.xhr.result_error = (function shadow$xhr$result_error(res,callback){
return goog.result.waitOnError(res,callback);
});
shadow.xhr.edn_transform = (function shadow$xhr$edn_transform(body){
return cljs.reader.read_string.call(null,body);
});
shadow.xhr.json_transform = (function shadow$xhr$json_transform(body){
return cljs.core.js__GT_clj.call(null,JSON.parse(body));
});
shadow.xhr.goog_keys = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"timeout","timeout",-318625318),"timeoutMs",new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),"withCredentials",new cljs.core.Keyword(null,"headers","headers",-835030129),"headers",new cljs.core.Keyword(null,"mime-type","mime-type",1058646439),"mimeType"], null);
shadow.xhr.make_request_options = (function shadow$xhr$make_request_options(options){
var obj = ({});
var seq__51259_51535 = cljs.core.seq.call(null,options);
var chunk__51260_51536 = null;
var count__51261_51537 = (0);
var i__51262_51538 = (0);
while(true){
if((i__51262_51538 < count__51261_51537)){
var vec__51281_51539 = cljs.core._nth.call(null,chunk__51260_51536,i__51262_51538);
var k_51540 = cljs.core.nth.call(null,vec__51281_51539,(0),null);
var v_51541 = cljs.core.nth.call(null,vec__51281_51539,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_51540)] = cljs.core.clj__GT_js.call(null,v_51541));


var G__51551 = seq__51259_51535;
var G__51552 = chunk__51260_51536;
var G__51553 = count__51261_51537;
var G__51554 = (i__51262_51538 + (1));
seq__51259_51535 = G__51551;
chunk__51260_51536 = G__51552;
count__51261_51537 = G__51553;
i__51262_51538 = G__51554;
continue;
} else {
var temp__5735__auto___51555 = cljs.core.seq.call(null,seq__51259_51535);
if(temp__5735__auto___51555){
var seq__51259_51556__$1 = temp__5735__auto___51555;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51259_51556__$1)){
var c__4609__auto___51558 = cljs.core.chunk_first.call(null,seq__51259_51556__$1);
var G__51559 = cljs.core.chunk_rest.call(null,seq__51259_51556__$1);
var G__51560 = c__4609__auto___51558;
var G__51561 = cljs.core.count.call(null,c__4609__auto___51558);
var G__51562 = (0);
seq__51259_51535 = G__51559;
chunk__51260_51536 = G__51560;
count__51261_51537 = G__51561;
i__51262_51538 = G__51562;
continue;
} else {
var vec__51286_51563 = cljs.core.first.call(null,seq__51259_51556__$1);
var k_51564 = cljs.core.nth.call(null,vec__51286_51563,(0),null);
var v_51565 = cljs.core.nth.call(null,vec__51286_51563,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_51564)] = cljs.core.clj__GT_js.call(null,v_51565));


var G__51568 = cljs.core.next.call(null,seq__51259_51556__$1);
var G__51569 = null;
var G__51570 = (0);
var G__51571 = (0);
seq__51259_51535 = G__51568;
chunk__51260_51536 = G__51569;
count__51261_51537 = G__51570;
i__51262_51538 = G__51571;
continue;
}
} else {
}
}
break;
}

return obj;
});
shadow.xhr.content_transforms = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 5, ["text/edn",shadow.xhr.edn_transform,"application/edn",shadow.xhr.edn_transform,"application/json",shadow.xhr.json_transform,"text/html",cljs.core.identity,"text/plain",cljs.core.identity], null));
shadow.xhr.register_transform = (function shadow$xhr$register_transform(content_type,transform_fn){
return cljs.core.swap_BANG_.call(null,shadow.xhr.content_transforms,cljs.core.assoc,content_type,transform_fn);
});
shadow.xhr.auto_transform = (function shadow$xhr$auto_transform(req){
var content_type = (function (){var ct = clojure.string.lower_case.call(null,req.getResponseHeader("Content-Type"));
var sep = ct.indexOf(";");
if(cljs.core.not_EQ_.call(null,(-1),sep)){
return ct.substring((0),sep);
} else {
return ct;
}
})();
var transform_fn = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.xhr.content_transforms),content_type);
if((transform_fn == null)){
throw cljs.core.ex_info.call(null,"unsupported content-type",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"req","req",-326448303),req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type], null));
} else {
return transform_fn.call(null,req.responseText);
}
});
shadow.xhr.make_url = (function shadow$xhr$make_url(url,params){
return goog.uri.utils.appendParamsFromMap(url,cljs.core.clj__GT_js.call(null,params));
});
shadow.xhr.transform_request_body = (function shadow$xhr$transform_request_body(data){
if(typeof data === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain; charset=utf-8",data], null);
} else {
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (2147483648))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IPrintWithWriter$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/edn; charset=utf-8",cljs.core.pr_str.call(null,data)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["application/octet-stream",data], null);

}
}
});
shadow.xhr.as_url = (function shadow$xhr$as_url(input){
if(typeof input === 'string'){
return input;
} else {
if(((cljs.core.vector_QMARK_.call(null,input)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,input))) && (typeof cljs.core.first.call(null,input) === 'string') && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,input))))){
var vec__51352 = input;
var url = cljs.core.nth.call(null,vec__51352,(0),null);
var params = cljs.core.nth.call(null,vec__51352,(1),null);
return shadow.xhr.make_url.call(null,url,params);
} else {
throw cljs.core.ex_info.call(null,"doesnt look like an url",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),input], null));

}
}
});
shadow.xhr.e__GT_data = (function shadow$xhr$e__GT_data(e){
return e;
});
shadow.xhr.event_handler = (function shadow$xhr$event_handler(req,events,event_type){
return (function (e){
if(cljs.core.map_QMARK_.call(null,events)){
var temp__5735__auto__ = cljs.core.get.call(null,events,event_type);
if(cljs.core.truth_(temp__5735__auto__)){
var c = temp__5735__auto__;
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;
}
} else {
if((!((events == null)))){
return cljs.core.async.put_BANG_.call(null,events,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;

}
}
});
});
shadow.xhr.request_ok_QMARK_ = (function shadow$xhr$request_ok_QMARK_(status){
return cljs.core._EQ_.call(null,(200),status);
});
shadow.xhr.request_error_QMARK_ = (function shadow$xhr$request_error_QMARK_(status){
return (status >= (400));
});
/**
 * creates a channel and performs xhr request like (chan :GET "/something")
 * 
 * accepts url as string or [url params]
 * 
 * this channel will receive one message [status body req] on load
 * loadend will close the result channel, so you will get nil results on request errors/timeouts
 * 
 * use options hash to pass in extra channels
 * 
 * (chan :POST "/something" some-data {:events chan-or-map
 *                                       :upload chan-or-map})
 * 
 * when given a chan that channels receives messages in form of [event-type event-data req]
 * when given a map a channel is expected for each eventtype and will receive [event-data req]
 * {:timeout some-chan}, if no channel for a given event is present, no message is sent
 * 
 * event types are :loadstart :progress :abort :error :timeout :loadend :load (see xhr spec)
 * only exception is that status >= 500 does not return a result and produces an error event instead
 */
shadow.xhr.chan = (function shadow$xhr$chan(var_args){
var G__51392 = arguments.length;
switch (G__51392) {
case 2:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.chan.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.chan.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,p__51401){
var map__51402 = p__51401;
var map__51402__$1 = (((((!((map__51402 == null))))?(((((map__51402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51402.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51402):map__51402);
var options = map__51402__$1;
var events = cljs.core.get.call(null,map__51402__$1,new cljs.core.Keyword(null,"events","events",1792552201));
var upload = cljs.core.get.call(null,map__51402__$1,new cljs.core.Keyword(null,"upload","upload",-255769218));
var body_only = cljs.core.get.call(null,map__51402__$1,new cljs.core.Keyword(null,"body-only","body-only",-698120682));
var req = (new XMLHttpRequest());
var body_QMARK_ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
var vec__51410 = ((body_QMARK_)?shadow.xhr.transform_request_body.call(null,data):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null));
var content_type = cljs.core.nth.call(null,vec__51410,(0),null);
var body = cljs.core.nth.call(null,vec__51410,(1),null);
var result_chan = cljs.core.async.chan.call(null,(1));
if(cljs.core.truth_(((body_QMARK_)?upload:false))){
shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"error","error",-978969032),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"error","error",-978969032)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"load","load",-1318641184),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));
} else {
}

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadend","loadend",1430560564),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadend","loadend",1430560564));
return (function (e){
callback.call(null,e);

return cljs.core.async.close_BANG_.call(null,result_chan);
});
})());

var error_handler_51658 = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"error","error",-978969032));
shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"error","error",-978969032),error_handler_51658);

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"load","load",-1318641184),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"load","load",-1318641184));
return (function (e){
var status = req.status;
var body__$1 = (function (){var temp__5733__auto__ = new cljs.core.Keyword(null,"transform","transform",1381301764).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5733__auto__)){
var transform = temp__5733__auto__;
return transform.call(null,req.responseText,req);
} else {
return shadow.xhr.auto_transform.call(null,req);
}
})();
if(shadow.xhr.request_error_QMARK_.call(null,status)){
return error_handler_51658.call(null,e);
} else {
callback.call(null,e);

if(cljs.core.truth_(body_only)){
return cljs.core.async.put_BANG_.call(null,result_chan,body__$1);
} else {
return cljs.core.async.put_BANG_.call(null,result_chan,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,body__$1,req], null));
}
}
});
})());

req.open(cljs.core.name.call(null,method),shadow.xhr.as_url.call(null,url),true);

(req.responseType = "text");

(req.withCredentials = (!(new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235).cljs$core$IFn$_invoke$arity$1(options) === false)));

if(body_QMARK_){
req.setRequestHeader("Content-Type",content_type);
} else {
}

if(body_QMARK_){
req.send(body);
} else {
req.send();
}

return result_chan;
}));

(shadow.xhr.chan.cljs$lang$maxFixedArity = 4);

shadow.xhr.request = (function shadow$xhr$request(var_args){
var G__51446 = arguments.length;
switch (G__51446) {
case 2:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.request.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.request.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,options){
if((((!(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"DELETE","DELETE",1688673772),null,new cljs.core.Keyword(null,"GET","GET",1736591026),null], null), null),method)))) && ((data == null)))){
throw cljs.core.ex_info.call(null,"request needs data",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"options","options",99638489),options], null));
} else {
}

var body_QMARK_ = (!(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method)) || ((data == null)))));
var vec__51454 = shadow.xhr.transform_request_body.call(null,data);
var content_type = cljs.core.nth.call(null,vec__51454,(0),null);
var body = cljs.core.nth.call(null,vec__51454,(1),null);
var req = goog.labs.net.xhr.send(cljs.core.name.call(null,method),(cljs.core.truth_(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method))?data:false))?shadow.xhr.make_url.call(null,url,data):url),((body_QMARK_)?body:null),shadow.xhr.make_request_options.call(null,((body_QMARK_)?cljs.core.assoc_in.call(null,options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Content-Type"], null),content_type):options)));
var req__$1 = goog.result.SimpleResult.fromPromise(req);
return goog.result.transform(req__$1,shadow.xhr.auto_transform);
}));

(shadow.xhr.request.cljs$lang$maxFixedArity = 4);

shadow.xhr.upload = (function shadow$xhr$upload(var_args){
var args__4795__auto__ = [];
var len__4789__auto___51769 = arguments.length;
var i__4790__auto___51770 = (0);
while(true){
if((i__4790__auto___51770 < len__4789__auto___51769)){
args__4795__auto__.push((arguments[i__4790__auto___51770]));

var G__51772 = (i__4790__auto___51770 + (1));
i__4790__auto___51770 = G__51772;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((2) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((2)),(0),null)):null);
return shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4796__auto__);
});

(shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic = (function (url,file,events){
var xhr = (new XMLHttpRequest());
var seq__51472_51784 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),events));
var chunk__51474_51785 = null;
var count__51475_51786 = (0);
var i__51476_51787 = (0);
while(true){
if((i__51476_51787 < count__51475_51786)){
var vec__51495_51791 = cljs.core._nth.call(null,chunk__51474_51785,i__51476_51787);
var ev_id_51792 = cljs.core.nth.call(null,vec__51495_51791,(0),null);
var ev_handler_51793 = cljs.core.nth.call(null,vec__51495_51791,(1),null);
var target_51804 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_51792))?(xhr["upload"]):xhr);
target_51804.addEventListener(cljs.core.name.call(null,ev_id_51792),ev_handler_51793);


var G__51809 = seq__51472_51784;
var G__51810 = chunk__51474_51785;
var G__51811 = count__51475_51786;
var G__51812 = (i__51476_51787 + (1));
seq__51472_51784 = G__51809;
chunk__51474_51785 = G__51810;
count__51475_51786 = G__51811;
i__51476_51787 = G__51812;
continue;
} else {
var temp__5735__auto___51815 = cljs.core.seq.call(null,seq__51472_51784);
if(temp__5735__auto___51815){
var seq__51472_51822__$1 = temp__5735__auto___51815;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51472_51822__$1)){
var c__4609__auto___51825 = cljs.core.chunk_first.call(null,seq__51472_51822__$1);
var G__51827 = cljs.core.chunk_rest.call(null,seq__51472_51822__$1);
var G__51828 = c__4609__auto___51825;
var G__51829 = cljs.core.count.call(null,c__4609__auto___51825);
var G__51830 = (0);
seq__51472_51784 = G__51827;
chunk__51474_51785 = G__51828;
count__51475_51786 = G__51829;
i__51476_51787 = G__51830;
continue;
} else {
var vec__51508_51849 = cljs.core.first.call(null,seq__51472_51822__$1);
var ev_id_51850 = cljs.core.nth.call(null,vec__51508_51849,(0),null);
var ev_handler_51851 = cljs.core.nth.call(null,vec__51508_51849,(1),null);
var target_51855 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_51850))?(xhr["upload"]):xhr);
target_51855.addEventListener(cljs.core.name.call(null,ev_id_51850),ev_handler_51851);


var G__51868 = cljs.core.next.call(null,seq__51472_51822__$1);
var G__51869 = null;
var G__51870 = (0);
var G__51871 = (0);
seq__51472_51784 = G__51868;
chunk__51474_51785 = G__51869;
count__51475_51786 = G__51870;
i__51476_51787 = G__51871;
continue;
}
} else {
}
}
break;
}

var G__51514 = xhr;
G__51514.open("PUT",url);

G__51514.send(file);

return G__51514;
}));

(shadow.xhr.upload.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.xhr.upload.cljs$lang$applyTo = (function (seq51463){
var G__51465 = cljs.core.first.call(null,seq51463);
var seq51463__$1 = cljs.core.next.call(null,seq51463);
var G__51466 = cljs.core.first.call(null,seq51463__$1);
var seq51463__$2 = cljs.core.next.call(null,seq51463__$1);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51465,G__51466,seq51463__$2);
}));


//# sourceMappingURL=shadow.xhr.js.map
