goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.call(null,null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_.call(null,null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___53536 = arguments.length;
var i__4790__auto___53537 = (0);
while(true){
if((i__4790__auto___53537 < len__4789__auto___53536)){
args__4795__auto__.push((arguments[i__4790__auto___53537]));

var G__53538 = (i__4790__auto___53537 + (1));
i__4790__auto___53537 = G__53538;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq52896){
var G__52898 = cljs.core.first.call(null,seq52896);
var seq52896__$1 = cljs.core.next.call(null,seq52896);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52898,seq52896__$1);
}));

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5733__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s.send(cljs.core.pr_str.call(null,msg));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.call(null,msg));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__52916){
var map__52917 = p__52916;
var map__52917__$1 = (((((!((map__52917 == null))))?(((((map__52917.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52917.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52917):map__52917);
var src = map__52917__$1;
var resource_id = cljs.core.get.call(null,map__52917__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__52917__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4185__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__4185__auto__){
return or__4185__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__52923 = cljs.core.seq.call(null,sources);
var chunk__52924 = null;
var count__52925 = (0);
var i__52926 = (0);
while(true){
if((i__52926 < count__52925)){
var map__52945 = cljs.core._nth.call(null,chunk__52924,i__52926);
var map__52945__$1 = (((((!((map__52945 == null))))?(((((map__52945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52945.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52945):map__52945);
var src = map__52945__$1;
var resource_id = cljs.core.get.call(null,map__52945__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__52945__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__52945__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__52945__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e52951){var e_53553 = e52951;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_53553);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_53553.message)].join('')));
}

var G__53555 = seq__52923;
var G__53556 = chunk__52924;
var G__53557 = count__52925;
var G__53558 = (i__52926 + (1));
seq__52923 = G__53555;
chunk__52924 = G__53556;
count__52925 = G__53557;
i__52926 = G__53558;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__52923);
if(temp__5735__auto__){
var seq__52923__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52923__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__52923__$1);
var G__53560 = cljs.core.chunk_rest.call(null,seq__52923__$1);
var G__53561 = c__4609__auto__;
var G__53562 = cljs.core.count.call(null,c__4609__auto__);
var G__53563 = (0);
seq__52923 = G__53560;
chunk__52924 = G__53561;
count__52925 = G__53562;
i__52926 = G__53563;
continue;
} else {
var map__52957 = cljs.core.first.call(null,seq__52923__$1);
var map__52957__$1 = (((((!((map__52957 == null))))?(((((map__52957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52957):map__52957);
var src = map__52957__$1;
var resource_id = cljs.core.get.call(null,map__52957__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__52957__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__52957__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__52957__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

try{shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e52962){var e_53567 = e52962;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_53567);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_53567.message)].join('')));
}

var G__53568 = cljs.core.next.call(null,seq__52923__$1);
var G__53569 = null;
var G__53570 = (0);
var G__53571 = (0);
seq__52923 = G__53568;
chunk__52924 = G__53569;
count__52925 = G__53570;
i__52926 = G__53571;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,cljs.core.assoc.call(null,msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})),(function (){
return shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__52970 = cljs.core.seq.call(null,js_requires);
var chunk__52971 = null;
var count__52972 = (0);
var i__52973 = (0);
while(true){
if((i__52973 < count__52972)){
var js_ns = cljs.core._nth.call(null,chunk__52971,i__52973);
var require_str_53575 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_53575);


var G__53577 = seq__52970;
var G__53578 = chunk__52971;
var G__53579 = count__52972;
var G__53580 = (i__52973 + (1));
seq__52970 = G__53577;
chunk__52971 = G__53578;
count__52972 = G__53579;
i__52973 = G__53580;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__52970);
if(temp__5735__auto__){
var seq__52970__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52970__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__52970__$1);
var G__53582 = cljs.core.chunk_rest.call(null,seq__52970__$1);
var G__53583 = c__4609__auto__;
var G__53584 = cljs.core.count.call(null,c__4609__auto__);
var G__53585 = (0);
seq__52970 = G__53582;
chunk__52971 = G__53583;
count__52972 = G__53584;
i__52973 = G__53585;
continue;
} else {
var js_ns = cljs.core.first.call(null,seq__52970__$1);
var require_str_53586 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_53586);


var G__53588 = cljs.core.next.call(null,seq__52970__$1);
var G__53589 = null;
var G__53590 = (0);
var G__53591 = (0);
seq__52970 = G__53588;
chunk__52971 = G__53589;
count__52972 = G__53590;
i__52973 = G__53591;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_.call(null,sources)){
return callback.call(null,cljs.core.PersistentVector.EMPTY);
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url.call(null),(function (res){
var req = this;
var content = cljs.reader.read_string.call(null,req.getResponseText());
return callback.call(null,content);
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__52987){
var map__52988 = p__52987;
var map__52988__$1 = (((((!((map__52988 == null))))?(((((map__52988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52988.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52988):map__52988);
var msg = map__52988__$1;
var info = cljs.core.get.call(null,map__52988__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.call(null,map__52988__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__52993 = info;
var map__52993__$1 = (((((!((map__52993 == null))))?(((((map__52993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52993.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52993):map__52993);
var sources = cljs.core.get.call(null,map__52993__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__52993__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__4582__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__52996(s__52997){
return (new cljs.core.LazySeq(null,(function (){
var s__52997__$1 = s__52997;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__52997__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__53005 = cljs.core.first.call(null,xs__6292__auto__);
var map__53005__$1 = (((((!((map__53005 == null))))?(((((map__53005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53005):map__53005);
var src = map__53005__$1;
var resource_name = cljs.core.get.call(null,map__53005__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__53005__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4578__auto__ = ((function (s__52997__$1,map__53005,map__53005__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__52993,map__52993__$1,sources,compiled,map__52988,map__52988__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__52996_$_iter__52999(s__53000){
return (new cljs.core.LazySeq(null,((function (s__52997__$1,map__53005,map__53005__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__52993,map__52993__$1,sources,compiled,map__52988,map__52988__$1,msg,info,reload_info){
return (function (){
var s__53000__$1 = s__53000;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__53000__$1);
if(temp__5735__auto____$1){
var s__53000__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__53000__$2)){
var c__4580__auto__ = cljs.core.chunk_first.call(null,s__53000__$2);
var size__4581__auto__ = cljs.core.count.call(null,c__4580__auto__);
var b__53002 = cljs.core.chunk_buffer.call(null,size__4581__auto__);
if((function (){var i__53001 = (0);
while(true){
if((i__53001 < size__4581__auto__)){
var warning = cljs.core._nth.call(null,c__4580__auto__,i__53001);
cljs.core.chunk_append.call(null,b__53002,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__53605 = (i__53001 + (1));
i__53001 = G__53605;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53002),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__52996_$_iter__52999.call(null,cljs.core.chunk_rest.call(null,s__53000__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__53002),null);
}
} else {
var warning = cljs.core.first.call(null,s__53000__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__52996_$_iter__52999.call(null,cljs.core.rest.call(null,s__53000__$2)));
}
} else {
return null;
}
break;
}
});})(s__52997__$1,map__53005,map__53005__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__52993,map__52993__$1,sources,compiled,map__52988,map__52988__$1,msg,info,reload_info))
,null,null));
});})(s__52997__$1,map__53005,map__53005__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__52993,map__52993__$1,sources,compiled,map__52988,map__52988__$1,msg,info,reload_info))
;
var fs__4579__auto__ = cljs.core.seq.call(null,iterys__4578__auto__.call(null,warnings));
if(fs__4579__auto__){
return cljs.core.concat.call(null,fs__4579__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__52996.call(null,cljs.core.rest.call(null,s__52997__$1)));
} else {
var G__53607 = cljs.core.rest.call(null,s__52997__$1);
s__52997__$1 = G__53607;
continue;
}
} else {
var G__53609 = cljs.core.rest.call(null,s__52997__$1);
s__52997__$1 = G__53609;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__.call(null,sources);
})()));
var seq__53013_53610 = cljs.core.seq.call(null,warnings);
var chunk__53014_53611 = null;
var count__53015_53612 = (0);
var i__53016_53613 = (0);
while(true){
if((i__53016_53613 < count__53015_53612)){
var map__53031_53614 = cljs.core._nth.call(null,chunk__53014_53611,i__53016_53613);
var map__53031_53615__$1 = (((((!((map__53031_53614 == null))))?(((((map__53031_53614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53031_53614.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53031_53614):map__53031_53614);
var w_53616 = map__53031_53615__$1;
var msg_53617__$1 = cljs.core.get.call(null,map__53031_53615__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_53618 = cljs.core.get.call(null,map__53031_53615__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_53619 = cljs.core.get.call(null,map__53031_53615__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_53620 = cljs.core.get.call(null,map__53031_53615__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_53620)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_53618),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_53619),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_53617__$1)].join(''));


var G__53622 = seq__53013_53610;
var G__53623 = chunk__53014_53611;
var G__53624 = count__53015_53612;
var G__53625 = (i__53016_53613 + (1));
seq__53013_53610 = G__53622;
chunk__53014_53611 = G__53623;
count__53015_53612 = G__53624;
i__53016_53613 = G__53625;
continue;
} else {
var temp__5735__auto___53626 = cljs.core.seq.call(null,seq__53013_53610);
if(temp__5735__auto___53626){
var seq__53013_53627__$1 = temp__5735__auto___53626;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53013_53627__$1)){
var c__4609__auto___53628 = cljs.core.chunk_first.call(null,seq__53013_53627__$1);
var G__53630 = cljs.core.chunk_rest.call(null,seq__53013_53627__$1);
var G__53631 = c__4609__auto___53628;
var G__53632 = cljs.core.count.call(null,c__4609__auto___53628);
var G__53633 = (0);
seq__53013_53610 = G__53630;
chunk__53014_53611 = G__53631;
count__53015_53612 = G__53632;
i__53016_53613 = G__53633;
continue;
} else {
var map__53036_53634 = cljs.core.first.call(null,seq__53013_53627__$1);
var map__53036_53635__$1 = (((((!((map__53036_53634 == null))))?(((((map__53036_53634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53036_53634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53036_53634):map__53036_53634);
var w_53636 = map__53036_53635__$1;
var msg_53637__$1 = cljs.core.get.call(null,map__53036_53635__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_53638 = cljs.core.get.call(null,map__53036_53635__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_53639 = cljs.core.get.call(null,map__53036_53635__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_53640 = cljs.core.get.call(null,map__53036_53635__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_53640)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_53638),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_53639),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_53637__$1)].join(''));


var G__53644 = cljs.core.next.call(null,seq__53013_53627__$1);
var G__53645 = null;
var G__53646 = (0);
var G__53647 = (0);
seq__53013_53610 = G__53644;
chunk__53014_53611 = G__53645;
count__53015_53612 = G__53646;
i__53016_53613 = G__53647;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(((cljs.core.empty_QMARK_.call(null,warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p__53041){
var map__53042 = p__53041;
var map__53042__$1 = (((((!((map__53042 == null))))?(((((map__53042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53042.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53042):map__53042);
var src = map__53042__$1;
var ns = cljs.core.get.call(null,map__53042__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__53042__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
}),cljs.core.remove.call(null,(function (p__53048){
var map__53049 = p__53048;
var map__53049__$1 = (((((!((map__53049 == null))))?(((((map__53049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53049.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53049):map__53049);
var ns = cljs.core.get.call(null,map__53049__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
}),cljs.core.filter.call(null,(function (p__53052){
var map__53053 = p__53052;
var map__53053__$1 = (((((!((map__53053 == null))))?(((((map__53053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53053.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53053):map__53053);
var rc = map__53053__$1;
var module = cljs.core.get.call(null,map__53053__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.env.module_is_active_QMARK_.call(null,module)));
}),sources))));
if(cljs.core.not.call(null,cljs.core.seq.call(null,sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.seq.call(null,cljs.core.get_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"reloading code but no :after-load hooks are configured!","https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks");
}

return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_get,(function (p1__52985_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload.call(null,msg,p1__52985_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.call(null,"file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.call(null,new$,(1));
if(((cljs.core._EQ_.call(null,old,rel_new)) || (clojure.string.starts_with_QMARK_.call(null,old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not.call(null,node_uri.hasDomain())))){
if(cljs.core._EQ_.call(null,node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__53065){
var map__53066 = p__53065;
var map__53066__$1 = (((((!((map__53066 == null))))?(((((map__53066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53066.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53066):map__53066);
var msg = map__53066__$1;
var updates = cljs.core.get.call(null,map__53066__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__53070 = cljs.core.seq.call(null,updates);
var chunk__53072 = null;
var count__53073 = (0);
var i__53074 = (0);
while(true){
if((i__53074 < count__53073)){
var path = cljs.core._nth.call(null,chunk__53072,i__53074);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__53136_53662 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__53139_53663 = null;
var count__53140_53664 = (0);
var i__53141_53665 = (0);
while(true){
if((i__53141_53665 < count__53140_53664)){
var node_53667 = cljs.core._nth.call(null,chunk__53139_53663,i__53141_53665);
var path_match_53669 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_53667.getAttribute("href"),path);
if(cljs.core.truth_(path_match_53669)){
var new_link_53671 = (function (){var G__53151 = node_53667.cloneNode(true);
G__53151.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_53669),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__53151;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_53669);

goog.dom.insertSiblingAfter(new_link_53671,node_53667);

goog.dom.removeNode(node_53667);


var G__53673 = seq__53136_53662;
var G__53674 = chunk__53139_53663;
var G__53675 = count__53140_53664;
var G__53676 = (i__53141_53665 + (1));
seq__53136_53662 = G__53673;
chunk__53139_53663 = G__53674;
count__53140_53664 = G__53675;
i__53141_53665 = G__53676;
continue;
} else {
var G__53678 = seq__53136_53662;
var G__53679 = chunk__53139_53663;
var G__53680 = count__53140_53664;
var G__53681 = (i__53141_53665 + (1));
seq__53136_53662 = G__53678;
chunk__53139_53663 = G__53679;
count__53140_53664 = G__53680;
i__53141_53665 = G__53681;
continue;
}
} else {
var temp__5735__auto___53683 = cljs.core.seq.call(null,seq__53136_53662);
if(temp__5735__auto___53683){
var seq__53136_53685__$1 = temp__5735__auto___53683;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53136_53685__$1)){
var c__4609__auto___53686 = cljs.core.chunk_first.call(null,seq__53136_53685__$1);
var G__53687 = cljs.core.chunk_rest.call(null,seq__53136_53685__$1);
var G__53688 = c__4609__auto___53686;
var G__53689 = cljs.core.count.call(null,c__4609__auto___53686);
var G__53690 = (0);
seq__53136_53662 = G__53687;
chunk__53139_53663 = G__53688;
count__53140_53664 = G__53689;
i__53141_53665 = G__53690;
continue;
} else {
var node_53692 = cljs.core.first.call(null,seq__53136_53685__$1);
var path_match_53693 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_53692.getAttribute("href"),path);
if(cljs.core.truth_(path_match_53693)){
var new_link_53694 = (function (){var G__53154 = node_53692.cloneNode(true);
G__53154.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_53693),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__53154;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_53693);

goog.dom.insertSiblingAfter(new_link_53694,node_53692);

goog.dom.removeNode(node_53692);


var G__53697 = cljs.core.next.call(null,seq__53136_53685__$1);
var G__53698 = null;
var G__53699 = (0);
var G__53700 = (0);
seq__53136_53662 = G__53697;
chunk__53139_53663 = G__53698;
count__53140_53664 = G__53699;
i__53141_53665 = G__53700;
continue;
} else {
var G__53701 = cljs.core.next.call(null,seq__53136_53685__$1);
var G__53702 = null;
var G__53703 = (0);
var G__53704 = (0);
seq__53136_53662 = G__53701;
chunk__53139_53663 = G__53702;
count__53140_53664 = G__53703;
i__53141_53665 = G__53704;
continue;
}
}
} else {
}
}
break;
}


var G__53706 = seq__53070;
var G__53707 = chunk__53072;
var G__53708 = count__53073;
var G__53709 = (i__53074 + (1));
seq__53070 = G__53706;
chunk__53072 = G__53707;
count__53073 = G__53708;
i__53074 = G__53709;
continue;
} else {
var G__53710 = seq__53070;
var G__53711 = chunk__53072;
var G__53712 = count__53073;
var G__53713 = (i__53074 + (1));
seq__53070 = G__53710;
chunk__53072 = G__53711;
count__53073 = G__53712;
i__53074 = G__53713;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__53070);
if(temp__5735__auto__){
var seq__53070__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53070__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__53070__$1);
var G__53716 = cljs.core.chunk_rest.call(null,seq__53070__$1);
var G__53717 = c__4609__auto__;
var G__53718 = cljs.core.count.call(null,c__4609__auto__);
var G__53719 = (0);
seq__53070 = G__53716;
chunk__53072 = G__53717;
count__53073 = G__53718;
i__53074 = G__53719;
continue;
} else {
var path = cljs.core.first.call(null,seq__53070__$1);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__53160_53720 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__53163_53721 = null;
var count__53164_53722 = (0);
var i__53165_53723 = (0);
while(true){
if((i__53165_53723 < count__53164_53722)){
var node_53724 = cljs.core._nth.call(null,chunk__53163_53721,i__53165_53723);
var path_match_53725 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_53724.getAttribute("href"),path);
if(cljs.core.truth_(path_match_53725)){
var new_link_53727 = (function (){var G__53170 = node_53724.cloneNode(true);
G__53170.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_53725),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__53170;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_53725);

goog.dom.insertSiblingAfter(new_link_53727,node_53724);

goog.dom.removeNode(node_53724);


var G__53729 = seq__53160_53720;
var G__53730 = chunk__53163_53721;
var G__53731 = count__53164_53722;
var G__53732 = (i__53165_53723 + (1));
seq__53160_53720 = G__53729;
chunk__53163_53721 = G__53730;
count__53164_53722 = G__53731;
i__53165_53723 = G__53732;
continue;
} else {
var G__53734 = seq__53160_53720;
var G__53735 = chunk__53163_53721;
var G__53736 = count__53164_53722;
var G__53737 = (i__53165_53723 + (1));
seq__53160_53720 = G__53734;
chunk__53163_53721 = G__53735;
count__53164_53722 = G__53736;
i__53165_53723 = G__53737;
continue;
}
} else {
var temp__5735__auto___53739__$1 = cljs.core.seq.call(null,seq__53160_53720);
if(temp__5735__auto___53739__$1){
var seq__53160_53740__$1 = temp__5735__auto___53739__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__53160_53740__$1)){
var c__4609__auto___53742 = cljs.core.chunk_first.call(null,seq__53160_53740__$1);
var G__53743 = cljs.core.chunk_rest.call(null,seq__53160_53740__$1);
var G__53744 = c__4609__auto___53742;
var G__53745 = cljs.core.count.call(null,c__4609__auto___53742);
var G__53746 = (0);
seq__53160_53720 = G__53743;
chunk__53163_53721 = G__53744;
count__53164_53722 = G__53745;
i__53165_53723 = G__53746;
continue;
} else {
var node_53748 = cljs.core.first.call(null,seq__53160_53740__$1);
var path_match_53749 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_53748.getAttribute("href"),path);
if(cljs.core.truth_(path_match_53749)){
var new_link_53750 = (function (){var G__53175 = node_53748.cloneNode(true);
G__53175.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_53749),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__53175;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_53749);

goog.dom.insertSiblingAfter(new_link_53750,node_53748);

goog.dom.removeNode(node_53748);


var G__53751 = cljs.core.next.call(null,seq__53160_53740__$1);
var G__53752 = null;
var G__53753 = (0);
var G__53754 = (0);
seq__53160_53720 = G__53751;
chunk__53163_53721 = G__53752;
count__53164_53722 = G__53753;
i__53165_53723 = G__53754;
continue;
} else {
var G__53755 = cljs.core.next.call(null,seq__53160_53740__$1);
var G__53756 = null;
var G__53757 = (0);
var G__53758 = (0);
seq__53160_53720 = G__53755;
chunk__53163_53721 = G__53756;
count__53164_53722 = G__53757;
i__53165_53723 = G__53758;
continue;
}
}
} else {
}
}
break;
}


var G__53759 = cljs.core.next.call(null,seq__53070__$1);
var G__53760 = null;
var G__53761 = (0);
var G__53762 = (0);
seq__53070 = G__53759;
chunk__53072 = G__53760;
count__53073 = G__53761;
i__53074 = G__53762;
continue;
} else {
var G__53763 = cljs.core.next.call(null,seq__53070__$1);
var G__53764 = null;
var G__53765 = (0);
var G__53766 = (0);
seq__53070 = G__53763;
chunk__53072 = G__53764;
count__53073 = G__53765;
i__53074 = G__53766;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace.call(null,s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.call(null,shadow.cljs.devtools.client.env.repl_error.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product.call(null),new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root.call(null));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.call(null,"undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__53200){
var map__53201 = p__53200;
var map__53201__$1 = (((((!((map__53201 == null))))?(((((map__53201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53201.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53201):map__53201);
var id = cljs.core.get.call(null,map__53201__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.call(null,map__53201__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call.call(null,(function (){
return shadow.cljs.devtools.client.browser.global_eval.call(null,js);
}),shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg.call(null,cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__53252,done){
var map__53254 = p__53252;
var map__53254__$1 = (((((!((map__53254 == null))))?(((((map__53254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53254.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53254):map__53254);
var msg = map__53254__$1;
var id = cljs.core.get.call(null,map__53254__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.call(null,map__53254__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.call(null,map__53254__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.call(null,map__53254__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,(function (p__53274){
var map__53275 = p__53274;
var map__53275__$1 = (((((!((map__53275 == null))))?(((((map__53275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53275):map__53275);
var src = map__53275__$1;
var provides = cljs.core.get.call(null,map__53275__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4174__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not.call(null,cljs.core.some.call(null,reload_namespaces,provides));
} else {
return and__4174__auto__;
}
}),sources));
return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_load,(function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load.call(null,sources__$1);

if(cljs.core.seq.call(null,js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires.call(null,js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e53313){var e = e53313;
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {done.call(null);
}}));
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__53345,done){
var map__53352 = p__53345;
var map__53352__$1 = (((((!((map__53352 == null))))?(((((map__53352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53352.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53352):map__53352);
var repl_state = cljs.core.get.call(null,map__53352__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.call(null,map__53352__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);

shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"REPL session start successful");

return done.call(null);
}));
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__53404){
var map__53407 = p__53404;
var map__53407__$1 = (((((!((map__53407 == null))))?(((((map__53407.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53407.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53407):map__53407);
var id = cljs.core.get.call(null,map__53407__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.call(null,map__53407__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_.call(null,null);
shadow.cljs.devtools.client.browser.stale_client_detected = cljs.core.volatile_BANG_.call(null,false);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__53418,done){
var map__53426 = p__53418;
var map__53426__$1 = (((((!((map__53426 == null))))?(((((map__53426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53426):map__53426);
var msg = map__53426__$1;
var type = cljs.core.get.call(null,map__53426__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

var G__53440_53792 = type;
var G__53440_53793__$1 = (((G__53440_53792 instanceof cljs.core.Keyword))?G__53440_53792.fqn:null);
switch (G__53440_53793__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch.call(null,msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke.call(null,msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require.call(null,msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns.call(null,msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init.call(null,msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

shadow.cljs.devtools.client.browser.handle_build_complete.call(null,msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end.call(null);

shadow.cljs.devtools.client.hud.hud_error.call(null,msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide.call(null);

shadow.cljs.devtools.client.hud.load_start.call(null);

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_.call(null,new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_.call(null,shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return done.call(null);
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.call(null,req.getResponseText());
if(cljs.core.truth_(callback)){
return callback.call(null,actions);
} else {
return null;
}
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)),({"content-type": "application/edn; charset=utf-8"}));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_status !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_status = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword(null,"init","init",-1875481434));
}
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status).call(null,new cljs.core.Keyword(null,"init","init",-1875481434)))){
return shadow.cljs.devtools.client.browser.ws_connect_impl.call(null);
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.maybe_reconnect = (function shadow$cljs$devtools$client$browser$maybe_reconnect(){
if(((cljs.core.not.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.stale_client_detected))) && (cljs.core.not_EQ_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.ws_status),new cljs.core.Keyword(null,"init","init",-1875481434))))){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"init","init",-1875481434));

return setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(3000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect_impl = (function shadow$cljs$devtools$client$browser$ws_connect_impl(){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connecting","connecting",-1347943866));

try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url.call(null,new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,socket);

(socket.onmessage = (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg.call(null,e.data,shadow.cljs.devtools.client.browser.handle_message);
}));

(socket.onopen = (function (e){
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connected","connected",-169833045));

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
(goog.provide = goog.constructNamespace_);
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket connected!");
}));

(socket.onclose = (function (e){
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error.call(null,(function (){var or__4185__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);

shadow.cljs.devtools.client.env.reset_print_fns_BANG_.call(null);

return shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);
}));

return (socket.onerror = (function (e){
shadow.cljs.devtools.client.hud.connection_error.call(null,"Connection failed!");

shadow.cljs.devtools.client.browser.maybe_reconnect.call(null);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"websocket error",e);
}));
}catch (e53520){var e = e53520;
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket setup failed",e);
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5735__auto___53809 = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto___53809)){
var s_53810 = temp__5735__auto___53809;
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"connection reset!");

(s_53810.onclose = (function (e){
return null;
}));

s_53810.close();

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5735__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4174__auto__ = document;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.call(null,"loading",document.readyState);
} else {
return and__4174__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
