goog.provide('com.wsscode.async.processing');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('cljs.core.async');
goog.require('com.wsscode.async.async_cljs');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","channel","com.wsscode.async.processing/channel",686460136),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","response-id","com.wsscode.async.processing/response-id",86488027),new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881),new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","request-response","com.wsscode.async.processing/request-response",-1897039463),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_);
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","timeout","com.wsscode.async.processing/timeout",334130262),new cljs.core.Symbol("cljs.core","pos-int?","cljs.core/pos-int?",-2115888030,null),cljs.core.pos_int_QMARK_);
com.wsscode.async.processing._STAR_default_timeout_STAR_ = (5000);
if((typeof com !== 'undefined') && (typeof com.wsscode !== 'undefined') && (typeof com.wsscode.async !== 'undefined') && (typeof com.wsscode.async.processing !== 'undefined') && (typeof com.wsscode.async.processing.response_notifiers_STAR_ !== 'undefined')){
} else {
com.wsscode.async.processing.response_notifiers_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
/**
 * Portable helper to generate random UUID.
 */
com.wsscode.async.processing.random_request_id = (function com$wsscode$async$processing$random_request_id(){
return cljs.core.random_uuid.call(null);
});
/**
 * Wait for some async response, this returns a channel that will receive the data
 *   once the other side responds to the ::request-id.
 * 
 *   When message doesn't have a ::request-id this function is a noop, so its safe to
 *   call in the message return point of your code.
 */
com.wsscode.async.processing.await_BANG_ = (function com$wsscode$async$processing$await_BANG_(p__59397){
var map__59398 = p__59397;
var map__59398__$1 = (((((!((map__59398 == null))))?(((((map__59398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59398):map__59398);
var msg = map__59398__$1;
var request_id = cljs.core.get.call(null,map__59398__$1,new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881));
var timeout = cljs.core.get.call(null,map__59398__$1,new cljs.core.Keyword("com.wsscode.async.processing","timeout","com.wsscode.async.processing/timeout",334130262));
if(cljs.core.truth_(request_id)){
var chan = cljs.core.async.promise_chan.call(null);
var timeout_SINGLEQUOTE_ = (function (){var or__4185__auto__ = timeout;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return com.wsscode.async.processing._STAR_default_timeout_STAR_;
}
})();
var timer = cljs.core.async.timeout.call(null,timeout_SINGLEQUOTE_);
cljs.core.swap_BANG_.call(null,com.wsscode.async.processing.response_notifiers_STAR_,cljs.core.assoc,request_id,chan);

var ch__45917__auto__ = cljs.core.async.promise_chan.call(null);
var c__42559__auto___59516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_59438){
var state_val_59439 = (state_59438[(1)]);
if((state_val_59439 === (7))){
var inst_59419 = [new cljs.core.Keyword(null,"timeout","timeout",-318625318),new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881),new cljs.core.Keyword(null,"request-keys","request-keys",1737737746)];
var inst_59420 = cljs.core.keys.call(null,msg);
var inst_59421 = [timeout_SINGLEQUOTE_,request_id,inst_59420];
var inst_59422 = cljs.core.PersistentHashMap.fromArrays(inst_59419,inst_59421);
var inst_59423 = cljs.core.ex_info.call(null,"Response timeout",inst_59422);
var state_59438__$1 = state_59438;
var statearr_59440_59521 = state_59438__$1;
(statearr_59440_59521[(2)] = inst_59423);

(statearr_59440_59521[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (1))){
var state_59438__$1 = state_59438;
var statearr_59441_59522 = state_59438__$1;
(statearr_59441_59522[(2)] = null);

(statearr_59441_59522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (4))){
var inst_59400 = (state_59438[(2)]);
var state_59438__$1 = state_59438;
var statearr_59442_59523 = state_59438__$1;
(statearr_59442_59523[(2)] = inst_59400);

(statearr_59442_59523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (6))){
var inst_59413 = (state_59438[(2)]);
var inst_59414 = cljs.core.nth.call(null,inst_59413,(0),null);
var inst_59415 = cljs.core.nth.call(null,inst_59413,(1),null);
var inst_59416 = cljs.core.swap_BANG_.call(null,com.wsscode.async.processing.response_notifiers_STAR_,cljs.core.dissoc,request_id);
var inst_59417 = cljs.core._EQ_.call(null,inst_59415,timer);
var state_59438__$1 = (function (){var statearr_59443 = state_59438;
(statearr_59443[(7)] = inst_59414);

(statearr_59443[(8)] = inst_59416);

return statearr_59443;
})();
if(inst_59417){
var statearr_59444_59525 = state_59438__$1;
(statearr_59444_59525[(1)] = (7));

} else {
var statearr_59445_59526 = state_59438__$1;
(statearr_59445_59526[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (3))){
var inst_59429 = (state_59438[(9)]);
var inst_59429__$1 = (state_59438[(2)]);
var inst_59430 = (inst_59429__$1 == null);
var state_59438__$1 = (function (){var statearr_59446 = state_59438;
(statearr_59446[(9)] = inst_59429__$1);

return statearr_59446;
})();
if(cljs.core.truth_(inst_59430)){
var statearr_59447_59527 = state_59438__$1;
(statearr_59447_59527[(1)] = (10));

} else {
var statearr_59448_59528 = state_59438__$1;
(statearr_59448_59528[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (12))){
var inst_59436 = (state_59438[(2)]);
var state_59438__$1 = state_59438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59438__$1,inst_59436);
} else {
if((state_val_59439 === (2))){
var _ = (function (){var statearr_59449 = state_59438;
(statearr_59449[(4)] = cljs.core.cons.call(null,(5),(state_59438[(4)])));

return statearr_59449;
})();
var inst_59409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59410 = [chan,timer];
var inst_59411 = (new cljs.core.PersistentVector(null,2,(5),inst_59409,inst_59410,null));
var state_59438__$1 = state_59438;
return cljs.core.async.ioc_alts_BANG_.call(null,state_59438__$1,(6),inst_59411,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_59439 === (11))){
var inst_59429 = (state_59438[(9)]);
var inst_59434 = cljs.core.async.put_BANG_.call(null,ch__45917__auto__,inst_59429);
var state_59438__$1 = state_59438;
var statearr_59451_59541 = state_59438__$1;
(statearr_59451_59541[(2)] = inst_59434);

(statearr_59451_59541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (9))){
var inst_59426 = (state_59438[(2)]);
var _ = (function (){var statearr_59452 = state_59438;
(statearr_59452[(4)] = cljs.core.rest.call(null,(state_59438[(4)])));

return statearr_59452;
})();
var state_59438__$1 = state_59438;
var statearr_59453_59551 = state_59438__$1;
(statearr_59453_59551[(2)] = inst_59426);

(statearr_59453_59551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (5))){
var _ = (function (){var statearr_59454 = state_59438;
(statearr_59454[(4)] = cljs.core.rest.call(null,(state_59438[(4)])));

return statearr_59454;
})();
var state_59438__$1 = state_59438;
var ex59450 = (state_59438__$1[(2)]);
var statearr_59455_59564 = state_59438__$1;
(statearr_59455_59564[(5)] = ex59450);


var statearr_59456_59570 = state_59438__$1;
(statearr_59456_59570[(1)] = (4));

(statearr_59456_59570[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (10))){
var inst_59432 = cljs.core.async.close_BANG_.call(null,ch__45917__auto__);
var state_59438__$1 = state_59438;
var statearr_59457_59572 = state_59438__$1;
(statearr_59457_59572[(2)] = inst_59432);

(statearr_59457_59572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59439 === (8))){
var inst_59414 = (state_59438[(7)]);
var state_59438__$1 = state_59438;
var statearr_59458_59575 = state_59438__$1;
(statearr_59458_59575[(2)] = inst_59414);

(statearr_59458_59575[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__ = null;
var com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____0 = (function (){
var statearr_59459 = [null,null,null,null,null,null,null,null,null,null];
(statearr_59459[(0)] = com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__);

(statearr_59459[(1)] = (1));

return statearr_59459;
});
var com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____1 = (function (state_59438){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_59438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e59460){var ex__42270__auto__ = e59460;
var statearr_59461_59594 = state_59438;
(statearr_59461_59594[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_59438[(4)]))){
var statearr_59462_59602 = state_59438;
(statearr_59462_59602[(1)] = cljs.core.first.call(null,(state_59438[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59610 = state_59438;
state_59438 = G__59610;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__ = function(state_59438){
switch(arguments.length){
case 0:
return com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____0.call(this);
case 1:
return com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____1.call(this,state_59438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____0;
com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto____1;
return com$wsscode$async$processing$await_BANG__$_state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_59463 = f__42560__auto__.call(null);
(statearr_59463[(6)] = c__42559__auto___59516);

return statearr_59463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return ch__45917__auto__;
} else {
return null;
}
});
/**
 * Use this helper in the receiving side of events, right before sending to your original
 *   handler message. This will ensure that response messages are propagated back to the
 *   listener.
 */
com.wsscode.async.processing.capture_response_BANG_ = (function com$wsscode$async$processing$capture_response_BANG_(p__59464){
var map__59465 = p__59464;
var map__59465__$1 = (((((!((map__59465 == null))))?(((((map__59465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59465):map__59465);
var response_id = cljs.core.get.call(null,map__59465__$1,new cljs.core.Keyword("com.wsscode.async.processing","response-id","com.wsscode.async.processing/response-id",86488027));
var request_response = cljs.core.get.call(null,map__59465__$1,new cljs.core.Keyword("com.wsscode.async.processing","request-response","com.wsscode.async.processing/request-response",-1897039463));
if(cljs.core.truth_(request_response)){
var temp__5733__auto___59625 = cljs.core.get.call(null,cljs.core.deref.call(null,com.wsscode.async.processing.response_notifiers_STAR_),response_id);
if(cljs.core.truth_(temp__5733__auto___59625)){
var chan_59631 = temp__5733__auto___59625;
cljs.core.async.put_BANG_.call(null,chan_59631,request_response);
} else {
cljs.core.print.call(null,"Tried to notify unavailable responder",response_id);
}

return true;
} else {
return null;
}
});
/**
 * Helper to make a response map for a given message with a request-id.
 * 
 *   Use this to generate response data from async events.
 */
com.wsscode.async.processing.reply_message = (function com$wsscode$async$processing$reply_message(p__59467,value){
var map__59468 = p__59467;
var map__59468__$1 = (((((!((map__59468 == null))))?(((((map__59468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59468.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59468):map__59468);
var request_id = cljs.core.get.call(null,map__59468__$1,new cljs.core.Keyword("com.wsscode.async.processing","request-id","com.wsscode.async.processing/request-id",-1101501881));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("com.wsscode.async.processing","response-id","com.wsscode.async.processing/response-id",86488027),request_id,new cljs.core.Keyword("com.wsscode.async.processing","request-response","com.wsscode.async.processing/request-response",-1897039463),value], null);
});
/**
 * Returns a callback handler that will respond to events in a serialized queue. When
 *   the user handler returns a channel, the next message will wait until the current one
 *   finished processing before moving on. Use this on callback handlers that need serialization
 *   to avoid concurrency issues.
 */
com.wsscode.async.processing.event_queue_BANG_ = (function com$wsscode$async$processing$event_queue_BANG_(var_args){
var G__59471 = arguments.length;
switch (G__59471) {
case 1:
return com.wsscode.async.processing.event_queue_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.async.processing.event_queue_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.async.processing.event_queue_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (handler){
return com.wsscode.async.processing.event_queue_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY,handler);
}));

(com.wsscode.async.processing.event_queue_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p__59472,handler){
var map__59473 = p__59472;
var map__59473__$1 = (((((!((map__59473 == null))))?(((((map__59473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59473.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59473):map__59473);
var channel = cljs.core.get.call(null,map__59473__$1,new cljs.core.Keyword("com.wsscode.async.processing","channel","com.wsscode.async.processing/channel",686460136));
var channel_SINGLEQUOTE_ = (function (){var or__4185__auto__ = channel;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.call(null,cljs.core.async.dropping_buffer.call(null,(1024)));
}
})();
var c__42559__auto___59713 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__42560__auto__ = (function (){var switch__42266__auto__ = (function (state_59494){
var state_val_59495 = (state_59494[(1)]);
if((state_val_59495 === (7))){
var inst_59490 = (state_59494[(2)]);
var state_59494__$1 = state_59494;
var statearr_59496_59715 = state_59494__$1;
(statearr_59496_59715[(2)] = inst_59490);

(statearr_59496_59715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (1))){
var state_59494__$1 = state_59494;
var statearr_59497_59716 = state_59494__$1;
(statearr_59497_59716[(2)] = null);

(statearr_59497_59716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (4))){
var inst_59477 = (state_59494[(7)]);
var inst_59477__$1 = (state_59494[(2)]);
var state_59494__$1 = (function (){var statearr_59498 = state_59494;
(statearr_59498[(7)] = inst_59477__$1);

return statearr_59498;
})();
if(cljs.core.truth_(inst_59477__$1)){
var statearr_59499_59717 = state_59494__$1;
(statearr_59499_59717[(1)] = (5));

} else {
var statearr_59500_59719 = state_59494__$1;
(statearr_59500_59719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (6))){
var state_59494__$1 = state_59494;
var statearr_59501_59720 = state_59494__$1;
(statearr_59501_59720[(2)] = null);

(statearr_59501_59720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (3))){
var inst_59492 = (state_59494[(2)]);
var state_59494__$1 = state_59494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59494__$1,inst_59492);
} else {
if((state_val_59495 === (2))){
var state_59494__$1 = state_59494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59494__$1,(4),channel_SINGLEQUOTE_);
} else {
if((state_val_59495 === (11))){
var inst_59483 = (state_59494[(2)]);
var state_59494__$1 = state_59494;
var statearr_59502_59722 = state_59494__$1;
(statearr_59502_59722[(2)] = inst_59483);

(statearr_59502_59722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (9))){
var inst_59479 = (state_59494[(8)]);
var state_59494__$1 = state_59494;
var statearr_59503_59723 = state_59494__$1;
(statearr_59503_59723[(2)] = inst_59479);

(statearr_59503_59723[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (5))){
var inst_59477 = (state_59494[(7)]);
var inst_59479 = (state_59494[(8)]);
var inst_59479__$1 = cljs.core.apply.call(null,handler,inst_59477);
var inst_59480 = com.wsscode.async.async_cljs.chan_QMARK_.call(null,inst_59479__$1);
var state_59494__$1 = (function (){var statearr_59504 = state_59494;
(statearr_59504[(8)] = inst_59479__$1);

return statearr_59504;
})();
if(inst_59480){
var statearr_59505_59724 = state_59494__$1;
(statearr_59505_59724[(1)] = (8));

} else {
var statearr_59506_59725 = state_59494__$1;
(statearr_59506_59725[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (10))){
var inst_59486 = (state_59494[(2)]);
var state_59494__$1 = (function (){var statearr_59507 = state_59494;
(statearr_59507[(9)] = inst_59486);

return statearr_59507;
})();
var statearr_59508_59727 = state_59494__$1;
(statearr_59508_59727[(2)] = null);

(statearr_59508_59727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59495 === (8))){
var inst_59479 = (state_59494[(8)]);
var state_59494__$1 = state_59494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59494__$1,(11),inst_59479);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var com$wsscode$async$processing$state_machine__42267__auto__ = null;
var com$wsscode$async$processing$state_machine__42267__auto____0 = (function (){
var statearr_59509 = [null,null,null,null,null,null,null,null,null,null];
(statearr_59509[(0)] = com$wsscode$async$processing$state_machine__42267__auto__);

(statearr_59509[(1)] = (1));

return statearr_59509;
});
var com$wsscode$async$processing$state_machine__42267__auto____1 = (function (state_59494){
while(true){
var ret_value__42268__auto__ = (function (){try{while(true){
var result__42269__auto__ = switch__42266__auto__.call(null,state_59494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42269__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42269__auto__;
}
break;
}
}catch (e59510){var ex__42270__auto__ = e59510;
var statearr_59511_59732 = state_59494;
(statearr_59511_59732[(2)] = ex__42270__auto__);


if(cljs.core.seq.call(null,(state_59494[(4)]))){
var statearr_59512_59734 = state_59494;
(statearr_59512_59734[(1)] = cljs.core.first.call(null,(state_59494[(4)])));

} else {
throw ex__42270__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42268__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59735 = state_59494;
state_59494 = G__59735;
continue;
} else {
return ret_value__42268__auto__;
}
break;
}
});
com$wsscode$async$processing$state_machine__42267__auto__ = function(state_59494){
switch(arguments.length){
case 0:
return com$wsscode$async$processing$state_machine__42267__auto____0.call(this);
case 1:
return com$wsscode$async$processing$state_machine__42267__auto____1.call(this,state_59494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
com$wsscode$async$processing$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$0 = com$wsscode$async$processing$state_machine__42267__auto____0;
com$wsscode$async$processing$state_machine__42267__auto__.cljs$core$IFn$_invoke$arity$1 = com$wsscode$async$processing$state_machine__42267__auto____1;
return com$wsscode$async$processing$state_machine__42267__auto__;
})()
})();
var state__42561__auto__ = (function (){var statearr_59513 = f__42560__auto__.call(null);
(statearr_59513[(6)] = c__42559__auto___59713);

return statearr_59513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42561__auto__);
}));


return (function() { 
var G__59738__delegate = function (args){
return cljs.core.async.put_BANG_.call(null,channel_SINGLEQUOTE_,args);
};
var G__59738 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__59740__i = 0, G__59740__a = new Array(arguments.length -  0);
while (G__59740__i < G__59740__a.length) {G__59740__a[G__59740__i] = arguments[G__59740__i + 0]; ++G__59740__i;}
  args = new cljs.core.IndexedSeq(G__59740__a,0,null);
} 
return G__59738__delegate.call(this,args);};
G__59738.cljs$lang$maxFixedArity = 0;
G__59738.cljs$lang$applyTo = (function (arglist__59741){
var args = cljs.core.seq(arglist__59741);
return G__59738__delegate(args);
});
G__59738.cljs$core$IFn$_invoke$arity$variadic = G__59738__delegate;
return G__59738;
})()
;
}));

(com.wsscode.async.processing.event_queue_BANG_.cljs$lang$maxFixedArity = 2);

cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","go-try-stream-args","com.wsscode.async.processing/go-try-stream-args",-1609380912),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__59514#","p1__59514#",490036695,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),(2),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__59514#","p1__59514#",490036695,null))))),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"catch","catch",1038065524),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"catch","catch",1038065524),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"catch","catch",-1616370245,null)),"null"], null), null),new cljs.core.Keyword(null,"error-type","error-type",1096890596),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"error-var","error-var",638852194),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"catch-body","catch-body",588849767),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"catch","catch",1038065524)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.alpha.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),(2),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"%","%",-950237169,null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vector_QMARK_,(function (p1__59514_SHARP_){
return cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,p1__59514_SHARP_));
})], null),null),cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"catch","catch",1038065524),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"catch","catch",-1616370245,null)),"null"], null), null),new cljs.core.Keyword(null,"error-type","error-type",1096890596),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"error-var","error-var",638852194),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"catch-body","catch-body",588849767),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"catch","catch",1038065524),new cljs.core.Keyword(null,"error-type","error-type",1096890596),new cljs.core.Keyword(null,"error-var","error-var",638852194),new cljs.core.Keyword(null,"catch-body","catch-body",588849767)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null], null), null),cljs.core.any_QMARK_,cljs.core.symbol_QMARK_,cljs.spec.alpha.rep_PLUS_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"catch","catch",-1616370245,null)),"null"], null), null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)),null,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","and","cljs.spec.alpha/and",-2060279705,null),new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__59514#","p1__59514#",490036695,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),(2),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"p1__59514#","p1__59514#",490036695,null))))),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","spec","cljs.spec.alpha/spec",-707298191,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"catch","catch",1038065524),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"catch","catch",-1616370245,null)),"null"], null), null),new cljs.core.Keyword(null,"error-type","error-type",1096890596),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Keyword(null,"error-var","error-var",638852194),new cljs.core.Symbol("cljs.core","symbol?","cljs.core/symbol?",1422196122,null),new cljs.core.Keyword(null,"catch-body","catch-body",588849767),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","+","cljs.spec.alpha/+",2101263265,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))))], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("com.wsscode.async.processing","go-try-stream","com.wsscode.async.processing/go-try-stream",790874894,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("com.wsscode.async.processing","go-try-stream-args","com.wsscode.async.processing/go-try-stream-args",-1609380912),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("com.wsscode.async.processing","go-try-stream-args","com.wsscode.async.processing/go-try-stream-args",-1609380912),new cljs.core.Keyword("com.wsscode.async.processing","go-try-stream-args","com.wsscode.async.processing/go-try-stream-args",-1609380912),null,null),new cljs.core.Keyword("com.wsscode.async.processing","go-try-stream-args","com.wsscode.async.processing/go-try-stream-args",-1609380912),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null));

//# sourceMappingURL=com.wsscode.async.processing.js.map
