goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__42514){
var map__42515 = p__42514;
var map__42515__$1 = (((((!((map__42515 == null))))?(((((map__42515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42515.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42515):map__42515);
var m = map__42515__$1;
var n = cljs.core.get.call(null,map__42515__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__42515__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4185__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__42532_42916 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__42533_42917 = null;
var count__42534_42918 = (0);
var i__42535_42919 = (0);
while(true){
if((i__42535_42919 < count__42534_42918)){
var f_42920 = cljs.core._nth.call(null,chunk__42533_42917,i__42535_42919);
cljs.core.println.call(null,"  ",f_42920);


var G__42924 = seq__42532_42916;
var G__42925 = chunk__42533_42917;
var G__42926 = count__42534_42918;
var G__42927 = (i__42535_42919 + (1));
seq__42532_42916 = G__42924;
chunk__42533_42917 = G__42925;
count__42534_42918 = G__42926;
i__42535_42919 = G__42927;
continue;
} else {
var temp__5735__auto___42928 = cljs.core.seq.call(null,seq__42532_42916);
if(temp__5735__auto___42928){
var seq__42532_42932__$1 = temp__5735__auto___42928;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42532_42932__$1)){
var c__4609__auto___42935 = cljs.core.chunk_first.call(null,seq__42532_42932__$1);
var G__42936 = cljs.core.chunk_rest.call(null,seq__42532_42932__$1);
var G__42937 = c__4609__auto___42935;
var G__42938 = cljs.core.count.call(null,c__4609__auto___42935);
var G__42939 = (0);
seq__42532_42916 = G__42936;
chunk__42533_42917 = G__42937;
count__42534_42918 = G__42938;
i__42535_42919 = G__42939;
continue;
} else {
var f_42942 = cljs.core.first.call(null,seq__42532_42932__$1);
cljs.core.println.call(null,"  ",f_42942);


var G__42944 = cljs.core.next.call(null,seq__42532_42932__$1);
var G__42945 = null;
var G__42946 = (0);
var G__42947 = (0);
seq__42532_42916 = G__42944;
chunk__42533_42917 = G__42945;
count__42534_42918 = G__42946;
i__42535_42919 = G__42947;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_42949 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_42949);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_42949)))?cljs.core.second.call(null,arglists_42949):arglists_42949));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__42562_42961 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__42563_42962 = null;
var count__42564_42963 = (0);
var i__42565_42964 = (0);
while(true){
if((i__42565_42964 < count__42564_42963)){
var vec__42611_42965 = cljs.core._nth.call(null,chunk__42563_42962,i__42565_42964);
var name_42966 = cljs.core.nth.call(null,vec__42611_42965,(0),null);
var map__42614_42967 = cljs.core.nth.call(null,vec__42611_42965,(1),null);
var map__42614_42968__$1 = (((((!((map__42614_42967 == null))))?(((((map__42614_42967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42614_42967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42614_42967):map__42614_42967);
var doc_42969 = cljs.core.get.call(null,map__42614_42968__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_42970 = cljs.core.get.call(null,map__42614_42968__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_42966);

cljs.core.println.call(null," ",arglists_42970);

if(cljs.core.truth_(doc_42969)){
cljs.core.println.call(null," ",doc_42969);
} else {
}


var G__42976 = seq__42562_42961;
var G__42977 = chunk__42563_42962;
var G__42978 = count__42564_42963;
var G__42979 = (i__42565_42964 + (1));
seq__42562_42961 = G__42976;
chunk__42563_42962 = G__42977;
count__42564_42963 = G__42978;
i__42565_42964 = G__42979;
continue;
} else {
var temp__5735__auto___42982 = cljs.core.seq.call(null,seq__42562_42961);
if(temp__5735__auto___42982){
var seq__42562_42984__$1 = temp__5735__auto___42982;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42562_42984__$1)){
var c__4609__auto___42986 = cljs.core.chunk_first.call(null,seq__42562_42984__$1);
var G__42989 = cljs.core.chunk_rest.call(null,seq__42562_42984__$1);
var G__42990 = c__4609__auto___42986;
var G__42991 = cljs.core.count.call(null,c__4609__auto___42986);
var G__42992 = (0);
seq__42562_42961 = G__42989;
chunk__42563_42962 = G__42990;
count__42564_42963 = G__42991;
i__42565_42964 = G__42992;
continue;
} else {
var vec__42650_42997 = cljs.core.first.call(null,seq__42562_42984__$1);
var name_42999 = cljs.core.nth.call(null,vec__42650_42997,(0),null);
var map__42653_43000 = cljs.core.nth.call(null,vec__42650_42997,(1),null);
var map__42653_43001__$1 = (((((!((map__42653_43000 == null))))?(((((map__42653_43000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42653_43000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42653_43000):map__42653_43000);
var doc_43002 = cljs.core.get.call(null,map__42653_43001__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43003 = cljs.core.get.call(null,map__42653_43001__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_42999);

cljs.core.println.call(null," ",arglists_43003);

if(cljs.core.truth_(doc_43002)){
cljs.core.println.call(null," ",doc_43002);
} else {
}


var G__43005 = cljs.core.next.call(null,seq__42562_42984__$1);
var G__43006 = null;
var G__43007 = (0);
var G__43008 = (0);
seq__42562_42961 = G__43005;
chunk__42563_42962 = G__43006;
count__42564_42963 = G__43007;
i__42565_42964 = G__43008;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.call(null,"Spec");

var seq__42679 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__42680 = null;
var count__42681 = (0);
var i__42682 = (0);
while(true){
if((i__42682 < count__42681)){
var role = cljs.core._nth.call(null,chunk__42680,i__42682);
var temp__5735__auto___43009__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___43009__$1)){
var spec_43011 = temp__5735__auto___43009__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43011));
} else {
}


var G__43013 = seq__42679;
var G__43014 = chunk__42680;
var G__43015 = count__42681;
var G__43016 = (i__42682 + (1));
seq__42679 = G__43013;
chunk__42680 = G__43014;
count__42681 = G__43015;
i__42682 = G__43016;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__42679);
if(temp__5735__auto____$1){
var seq__42679__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42679__$1)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,seq__42679__$1);
var G__43022 = cljs.core.chunk_rest.call(null,seq__42679__$1);
var G__43023 = c__4609__auto__;
var G__43024 = cljs.core.count.call(null,c__4609__auto__);
var G__43025 = (0);
seq__42679 = G__43022;
chunk__42680 = G__43023;
count__42681 = G__43024;
i__42682 = G__43025;
continue;
} else {
var role = cljs.core.first.call(null,seq__42679__$1);
var temp__5735__auto___43027__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___43027__$2)){
var spec_43029 = temp__5735__auto___43027__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43029));
} else {
}


var G__43033 = cljs.core.next.call(null,seq__42679__$1);
var G__43034 = null;
var G__43035 = (0);
var G__43036 = (0);
seq__42679 = G__43033;
chunk__42680 = G__43034;
count__42681 = G__43035;
i__42682 = G__43036;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__43043 = cljs.core.conj.call(null,via,t);
var G__43044 = cljs.core.ex_cause.call(null,t);
via = G__43043;
t = G__43044;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__42743 = datafied_throwable;
var map__42743__$1 = (((((!((map__42743 == null))))?(((((map__42743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42743):map__42743);
var via = cljs.core.get.call(null,map__42743__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__42743__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__42743__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__42744 = cljs.core.last.call(null,via);
var map__42744__$1 = (((((!((map__42744 == null))))?(((((map__42744.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42744.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42744):map__42744);
var type = cljs.core.get.call(null,map__42744__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__42744__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__42744__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__42745 = data;
var map__42745__$1 = (((((!((map__42745 == null))))?(((((map__42745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42745):map__42745);
var problems = cljs.core.get.call(null,map__42745__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__42745__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__42745__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__42746 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__42746__$1 = (((((!((map__42746 == null))))?(((((map__42746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42746):map__42746);
var top_data = map__42746__$1;
var source = cljs.core.get.call(null,map__42746__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__42765 = phase;
var G__42765__$1 = (((G__42765 instanceof cljs.core.Keyword))?G__42765.fqn:null);
switch (G__42765__$1) {
case "read-source":
var map__42766 = data;
var map__42766__$1 = (((((!((map__42766 == null))))?(((((map__42766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42766.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42766):map__42766);
var line = cljs.core.get.call(null,map__42766__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__42766__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__42785 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__42785__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__42785,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__42785);
var G__42785__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__42785__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__42785__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__42785__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__42785__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__42794 = top_data;
var G__42794__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__42794,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__42794);
var G__42794__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__42794__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__42794__$1);
var G__42794__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__42794__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__42794__$2);
var G__42794__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__42794__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__42794__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__42794__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__42794__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__42799 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__42799,(0),null);
var method = cljs.core.nth.call(null,vec__42799,(1),null);
var file = cljs.core.nth.call(null,vec__42799,(2),null);
var line = cljs.core.nth.call(null,vec__42799,(3),null);
var G__42806 = top_data;
var G__42806__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__42806,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__42806);
var G__42806__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__42806__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__42806__$1);
var G__42806__$3 = (cljs.core.truth_((function (){var and__4174__auto__ = source__$1;
if(cljs.core.truth_(and__4174__auto__)){
return method;
} else {
return and__4174__auto__;
}
})())?cljs.core.assoc.call(null,G__42806__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__42806__$2);
var G__42806__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__42806__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__42806__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__42806__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__42806__$4;
}

break;
case "execution":
var vec__42831 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__42831,(0),null);
var method = cljs.core.nth.call(null,vec__42831,(1),null);
var file = cljs.core.nth.call(null,vec__42831,(2),null);
var line = cljs.core.nth.call(null,vec__42831,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__42741_SHARP_){
var or__4185__auto__ = (p1__42741_SHARP_ == null);
if(or__4185__auto__){
return or__4185__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__42741_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4185__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return line;
}
})();
var G__42836 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__42836__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__42836,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__42836);
var G__42836__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__42836__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__42836__$1);
var G__42836__$3 = (cljs.core.truth_((function (){var or__4185__auto__ = fn;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto__ = source__$1;
if(cljs.core.truth_(and__4174__auto__)){
return method;
} else {
return and__4174__auto__;
}
}
})())?cljs.core.assoc.call(null,G__42836__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4185__auto__ = fn;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__42836__$2);
var G__42836__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__42836__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__42836__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__42836__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__42836__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42765__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__42852){
var map__42853 = p__42852;
var map__42853__$1 = (((((!((map__42853 == null))))?(((((map__42853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42853):map__42853);
var triage_data = map__42853__$1;
var phase = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__42853__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4185__auto__ = source;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4185__auto__ = line;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4185__auto__ = class$;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__42882 = phase;
var G__42882__$1 = (((G__42882 instanceof cljs.core.Keyword))?G__42882.fqn:null);
switch (G__42882__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__42885_43141 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__42886_43142 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__42887_43143 = true;
var _STAR_print_fn_STAR__temp_val__42888_43144 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__42887_43143);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__42888_43144);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__42844_SHARP_){
return cljs.core.dissoc.call(null,p1__42844_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__42886_43142);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__42885_43141);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__42902_43151 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__42903_43152 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__42904_43153 = true;
var _STAR_print_fn_STAR__temp_val__42905_43154 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__42904_43153);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__42905_43154);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__42845_SHARP_){
return cljs.core.dissoc.call(null,p1__42845_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__42903_43152);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__42902_43151);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42882__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=cljs.repl.js.map
