goog.provide('com.wsscode.async.async_cljs');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
goog.require('goog.object');
/**
 * Check if c is a core.async channel.
 */
com.wsscode.async.async_cljs.chan_QMARK_ = (function com$wsscode$async$async_cljs$chan_QMARK_(c){
if((!((c == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === c.cljs$core$async$impl$protocols$ReadPort$)))){
return true;
} else {
if((!c.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,c);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,c);
}
});
/**
 * Return true if X is a js obj with the property .then available as a fn.
 */
com.wsscode.async.async_cljs.promise_QMARK_ = (function com$wsscode$async$async_cljs$promise_QMARK_(x){
try{return cljs.core.fn_QMARK_.call(null,goog.object.get(x,"then"));
}catch (e40046){var _ = e40046;
return false;
}});
/**
 * Converts promise p in a promise-chan. The response of this channel should be consumed
 *   using `consume-pair`.
 */
com.wsscode.async.async_cljs.promise__GT_chan = (function com$wsscode$async$async_cljs$promise__GT_chan(p){
var c = cljs.core.async.promise_chan.call(null);
p.then((function (p1__40047_SHARP_){
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"success","success",1890645906),p1__40047_SHARP_], null));
}),(function (p1__40048_SHARP_){
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),p1__40048_SHARP_], null));
}));

return c;
});
/**
 * Consume promise channel result pair.
 */
com.wsscode.async.async_cljs.consumer_pair = (function com$wsscode$async$async_cljs$consumer_pair(resp){
if(cljs.core.contains_QMARK_.call(null,resp,new cljs.core.Keyword(null,"error","error",-978969032))){
throw new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(resp);
} else {
return new cljs.core.Keyword(null,"success","success",1890645906).cljs$core$IFn$_invoke$arity$1(resp);
}
});
/**
 * Returns true if err is an error object.
 */
com.wsscode.async.async_cljs.error_QMARK_ = (function com$wsscode$async$async_cljs$error_QMARK_(err){
return (err instanceof Error);
});
/**
 * Throw error x if x is an error.
 */
com.wsscode.async.async_cljs.throw_err = (function com$wsscode$async$async_cljs$throw_err(x){
if(com.wsscode.async.async_cljs.error_QMARK_.call(null,x)){
throw x;
} else {
return x;
}
});

//# sourceMappingURL=com.wsscode.async.async_cljs.js.map
