/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import clojure.lang.ExceptionInfo;
import clojure.lang.Keyword;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.workiva.eva.client.Connection;
import com.workiva.eva.client.Database;
import com.workiva.eva.client.EdnSerializer;
import com.workiva.eva.client.Endpoints;
import com.workiva.eva.client.Environment;
import com.workiva.eva.client.EvaClientFuture;
import com.workiva.eva.client.EvaClientHelper;
import com.workiva.eva.client.EvaContext;
import com.workiva.eva.client.EvaHttpClient;
import com.workiva.eva.client.exceptions.EvaClientException;
import com.workiva.eva.client.exceptions.EvaException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaHttpClientHelper
implements EvaClientHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaHttpClient.class);
    private final Endpoints endpoints;
    private EdnSerializer ednSerializer;
    private static final String CORRELATION_ID_HEADER = "_cid";
    private ResponseHandler<Object> responseHandler = response -> {
        StatusLine statusLine = response.getStatusLine();
        int status2 = statusLine.getStatusCode();
        String responseString = "";
        try {
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            Object deserializedResponse = this.deserializeResponse(response, responseString);
            if (status2 < 200 || status2 >= 300) {
                if (deserializedResponse instanceof Map) {
                    EvaException exception = new EvaException((Map)deserializedResponse);
                    if (Environment.shouldSanitizeExceptions()) {
                        exception = exception.getSanitized();
                    }
                    throw exception;
                }
                throw new EvaClientException(responseString);
            }
            return deserializedResponse;
        }
        catch (ExceptionInfo ex) {
            throw ex;
        }
        catch (EvaClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (responseString.equals("")) {
                throw new ClientProtocolException(String.format("\nEmpty Client Service Response with status code: %d", status2), (Throwable)ex);
            }
            throw new ClientProtocolException(String.format("\nUnexpected exception occurred with status code: %d\nStacktrace: %s", status2, responseString), (Throwable)ex);
        }
    };

    EvaHttpClientHelper(String url, String tenant, String category, String label2) {
        this.endpoints = new Endpoints(url, tenant, category, label2);
        this.ednSerializer = new EdnSerializer(tenant, category);
    }

    private Object deserializeResponse(HttpResponse response, String responseString) {
        String contentType;
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        String string = contentType = contentTypeHeader == null ? ContentType.TEXT_PLAIN.getMimeType() : contentTypeHeader.getValue();
        if (contentType.startsWith("application/json")) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            return new Gson().fromJson(responseString, type);
        }
        if (contentType.startsWith("application/vnd.eva+edn") || contentType.startsWith("application/edn")) {
            return this.ednSerializer.deserialize(responseString);
        }
        return responseString;
    }

    private void addHeaders(EvaContext context2, List<Header> headers, HttpRequestBase request) {
        request.setHeader(CORRELATION_ID_HEADER, context2.getCorrelationId());
        context2.addTracingHeaders(request);
        this.requestMiddleware(request);
        headers.forEach(h -> request.setHeader(h));
    }

    private void requestMiddleware(HttpRequestBase request) {
    }

    private <T> T doWork(EvaContext context2, List<Header> headers, HttpRequestBase request) throws EvaClientException {
        this.addHeaders(context2, headers, request);
        Future future2 = (Future)EvaHttpClient.getEvaClient().execute(request);
        return (T)new EvaClientFuture(future2, this.responseHandler).get();
    }

    private EvaClientFuture doWorkAsync(EvaContext context2, List<Header> headers, HttpEntityEnclosingRequestBase request) {
        this.addHeaders(context2, headers, (HttpRequestBase)request);
        Future future2 = (Future)EvaHttpClient.getEvaClient().execute(request);
        return new EvaClientFuture(future2, this.responseHandler);
    }

    public Map transact(EvaContext context2, List<Header> headers, List txData, Connection conn) {
        HttpPost post = this.transactHelper(txData, conn);
        post.setHeader("Accept", "application/vnd.eva+edn");
        return (Map)this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Future<Map<Keyword, Object>> transactAsync(EvaContext context2, List<Header> headers, List txData, Connection conn) {
        HttpPost post = this.transactHelper(txData, conn);
        post.setHeader("Accept", "application/vnd.eva+edn");
        return this.doWorkAsync(context2, headers, (HttpEntityEnclosingRequestBase)post);
    }

    private HttpPost transactHelper(List txData, Connection conn) {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("reference", this.ednSerializer.serialize(conn)));
        formFields.add(new BasicNameValuePair("transaction", this.ednSerializer.serialize(txData)));
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.transact);
        post.setHeader("Accept", "application/vnd.eva+edn");
        post.setEntity((HttpEntity)entity2);
        return post;
    }

    @Override
    public Object query(EvaContext context2, List<Header> headers, Object q2, Object ... args) {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("query", this.ednSerializer.serialize(q2)));
        for (int i = 0; i < args.length; ++i) {
            formFields.add(new BasicNameValuePair(String.format("p[%d]", i), this.ednSerializer.serialize(args[i])));
        }
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.query);
        post.setHeader("Accept", "application/vnd.eva+edn");
        post.setEntity((HttpEntity)entity2);
        return this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Map pull(EvaContext context2, List<Header> headers, Database db2, Object pattern, Object entityId, Object ... queryArgs) {
        return (Map)this.pullHelper(context2, headers, db2, pattern, entityId, queryArgs);
    }

    @Override
    public List<Map<Keyword, Object>> pullMany(EvaContext context2, List<Header> headers, Database db2, Object pattern, Object entityIds, Object ... queryArgs) {
        return (List)this.pullHelper(context2, headers, db2, pattern, entityIds, queryArgs);
    }

    <T> T pullHelper(EvaContext context2, List<Header> headers, Database db2, Object pattern, Object entityIds, Object ... queryArgs) throws EvaClientException {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("reference", this.ednSerializer.serialize(db2)));
        formFields.add(new BasicNameValuePair("pattern", this.ednSerializer.serialize(pattern)));
        formFields.add(new BasicNameValuePair("ids", this.ednSerializer.serialize(entityIds)));
        for (int i = 0; i < queryArgs.length; ++i) {
            formFields.add(new BasicNameValuePair(String.format("p[%d]", i), this.ednSerializer.serialize(queryArgs[i])));
        }
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.pull);
        post.setHeader("Accept", "application/vnd.eva+edn");
        post.setEntity((HttpEntity)entity2);
        return this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Object invoke(EvaContext context2, List<Header> headers, Database db2, Object function2, Object ... invokeArgs) {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("reference", this.ednSerializer.serialize(db2)));
        formFields.add(new BasicNameValuePair("function", this.ednSerializer.serialize(function2)));
        for (int i = 0; i < invokeArgs.length; ++i) {
            formFields.add(new BasicNameValuePair(String.format("p[%d]", i), this.ednSerializer.serialize(invokeArgs[i])));
        }
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.invoke);
        post.setHeader("Accept", "application/vnd.eva+edn");
        post.setEntity((HttpEntity)entity2);
        return this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Object entid(EvaContext context2, List<Header> headers, Database db2, Object ident2, boolean strict) {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("reference", this.ednSerializer.serialize(db2)));
        formFields.add(new BasicNameValuePair("ident", this.ednSerializer.serialize(ident2)));
        formFields.add(new BasicNameValuePair("strict", this.ednSerializer.serialize(strict)));
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.entid);
        post.setEntity((HttpEntity)entity2);
        return this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Object ident(EvaContext context2, List<Header> headers, Database db2, Object entid2, boolean strict) {
        ArrayList<BasicNameValuePair> formFields = new ArrayList<BasicNameValuePair>();
        formFields.add(new BasicNameValuePair("reference", this.ednSerializer.serialize(db2)));
        formFields.add(new BasicNameValuePair("entid", this.ednSerializer.serialize(entid2)));
        formFields.add(new BasicNameValuePair("strict", this.ednSerializer.serialize(strict)));
        UrlEncodedFormEntity entity2 = new UrlEncodedFormEntity(formFields, Consts.UTF_8);
        HttpPost post = new HttpPost(this.endpoints.ident);
        post.setHeader("Accept", "application/vnd.eva+edn");
        post.setEntity((HttpEntity)entity2);
        return this.doWork(context2, headers, (HttpRequestBase)post);
    }

    @Override
    public Long latestT(EvaContext context2, List<Header> headers) {
        HttpGet get = new HttpGet(this.endpoints.latestT);
        get.setHeader("Accept", "application/vnd.eva+edn");
        return (Long)this.doWork(context2, headers, (HttpRequestBase)get);
    }
}

