/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import com.workiva.eva.client.exceptions.EvaClientException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class EvaClientFuture<V>
implements Future {
    Future<HttpResponse> future;
    ResponseHandler handler;

    EvaClientFuture(Future future2, ResponseHandler<Object> handler) {
        this.future = future2;
        this.handler = handler;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean cancel(boolean cancelled) {
        return this.future.cancel(cancelled);
    }

    @Override
    public V get() throws EvaClientException {
        try {
            HttpResponse response = this.future.get();
            return (V)this.handler.handleResponse(response);
        }
        catch (InterruptedException e) {
            throw new EvaClientException("Thread interrupted while waiting for response from client service.", e);
        }
        catch (ExecutionException e) {
            throw new EvaClientException("Error executing request to client service.", e);
        }
        catch (IOException e) {
            throw new EvaClientException("Error occurred reading client service response.", e);
        }
    }

    @Override
    public V get(long timeout2, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        try {
            return (V)this.handler.handleResponse(this.future.get(timeout2, timeUnit));
        }
        catch (IOException e) {
            throw new EvaClientException("Error occurred reading client service response", e);
        }
    }
}

