/*
 * Decompiled with CFR 0.152.
 */
package com.workiva.eva.client;

import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import com.workiva.eva.client.EvaContext;
import com.workiva.eva.client.Reference;
import com.workiva.eva.client.exceptions.EvaClientException;
import com.workiva.eva.client.inline.InlineFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;

public class Database
extends Reference {
    private static final List<Header> EMPTY_HEADERS = new ArrayList<Header>();
    private static final String SNAPSHOT_REF_STRING_PREFIX = "#eva.client.service/snapshot-ref { ";
    protected final Object asOf;
    protected boolean syncDb = false;
    protected Long asOfT = null;
    protected Long basisT = null;
    protected Long snapshotT = null;

    public Database(String tenant, String category, String label2) {
        super(tenant, category, label2);
        this.asOf = null;
    }

    public Database(String tenant, String category, String label2, Object asOf, boolean syncDb) {
        super(tenant, category, label2);
        this.asOf = asOf;
        this.syncDb = syncDb;
    }

    Database(String tenant, String category, String label2, Object asOf, boolean syncDb, Long asOfT, Long basisT, Long snapshotT) {
        this(tenant, category, label2, asOf, syncDb);
        this.asOfT = asOfT;
        this.basisT = basisT;
        this.snapshotT = snapshotT;
    }

    public Database asOf(InlineFunction f) {
        return new Database(this.tenant, this.category, this.label, f, this.syncDb);
    }

    public Database asOf(Long t) {
        return new Database(this.tenant, this.category, this.label, t, this.syncDb);
    }

    public Map<Keyword, Object> pull(Object pattern, Object id2) throws EvaClientException {
        return this.clientHelper.pull(new EvaContext(), EMPTY_HEADERS, this, pattern, id2, new Object[0]);
    }

    public Map<Keyword, Object> pull(EvaContext ctx, Object pattern, Object id2) throws EvaClientException {
        return this.clientHelper.pull(ctx, EMPTY_HEADERS, this, pattern, id2, new Object[0]);
    }

    public List<Map<Keyword, Object>> pullMany(Object pattern, List entityIds) throws EvaClientException {
        return this.clientHelper.pullMany(new EvaContext(), EMPTY_HEADERS, this, pattern, PersistentVector.create((List)entityIds), new Object[0]);
    }

    public List<Map<Keyword, Object>> pullMany(EvaContext ctx, Object pattern, List entityIds) throws EvaClientException {
        return this.clientHelper.pullMany(ctx, EMPTY_HEADERS, this, pattern, PersistentVector.create((List)entityIds), new Object[0]);
    }

    public Long basisT() throws EvaClientException {
        if (this.basisT != null) {
            return this.basisT;
        }
        throw new EvaClientException("basis-t Value was never set on Database object.");
    }

    public Long asOfT() throws EvaClientException {
        return this.asOfT;
    }

    public Long snapshotT() throws EvaClientException {
        if (this.snapshotT != null) {
            return this.snapshotT;
        }
        throw new EvaClientException("snapshot-t Value was never set on Database object.");
    }

    public Object invoke(Object dbFunction, Object ... args) throws EvaClientException {
        return this.invoke(new EvaContext(), dbFunction, args);
    }

    public Object invoke(EvaContext ctx, Object dbFunction, Object ... args) throws EvaClientException {
        return this.clientHelper.invoke(ctx, EMPTY_HEADERS, this, dbFunction, args);
    }

    Object query(EvaContext ctx, Object query2, Object ... args) throws EvaClientException {
        return this.clientHelper.query(ctx, EMPTY_HEADERS, query2, args);
    }

    public Object entid(Object ident2) throws EvaClientException {
        return this.entid(new EvaContext(), ident2);
    }

    public Object entid(EvaContext ctx, Object ident2) throws EvaClientException {
        return this.clientHelper.entid(ctx, EMPTY_HEADERS, this, ident2, false);
    }

    public Object ident(Object entid2) throws EvaClientException {
        return this.ident(new EvaContext(), entid2);
    }

    public Object ident(EvaContext ctx, Object entid2) throws EvaClientException {
        return this.clientHelper.ident(ctx, EMPTY_HEADERS, this, entid2, false);
    }

    public String toString() {
        StringBuilder dbEdnStringBuilder = new StringBuilder(SNAPSHOT_REF_STRING_PREFIX);
        dbEdnStringBuilder.append(String.format(":label \"%s\" ", this.label));
        if (this.asOf != null) {
            dbEdnStringBuilder.append(String.format(":as-of %s ", this.asOf));
        }
        if (this.syncDb) {
            dbEdnStringBuilder.append(String.format(":sync-db %s ", this.syncDb));
        }
        dbEdnStringBuilder.append("}");
        return dbEdnStringBuilder.toString();
    }
}

